import { Command } from 'commander';
import { getAuthTokenOption, getPortOption, getSsrTimeoutOption, getSiteDirOption, getSiteZipOption, } from '../utils.js';
import { expDev } from '@lwrjs/api';
export function createExperimentalMrtDevCommand() {
    return new Command('experimental-mrt-dev')
        .description('[experimental] local development with HMR for an MRT bundle')
        .addOption(getPortOption())
        .addOption(getSiteDirOption())
        .addOption(getSiteZipOption())
        .addOption(getSsrTimeoutOption())
        .addOption(getAuthTokenOption())
        .option('-o, --open', `[boolean] open browser on startup`, false)
        .action(async (options, cmd) => {
        const { authToken, logLevel, open, port, siteDir, siteZip, timeout } = cmd.optsWithGlobals();
        await expDev({
            authToken,
            logLevel,
            mode: 'dev',
            open,
            port,
            siteDir,
            siteZip,
            timeout,
        });
    });
}
//# sourceMappingURL=mrt-dev.js.map