import { Command } from 'commander';
import { getPortOption, getSiteDirOption, getSiteZipOption, getSsrTimeoutOption } from '../utils.js';
import { expDev } from '@lwrjs/api';
export function createExperimentalMrtPackageCommand() {
    return new Command('experimental-mrt-package')
        .description('[experimental] Packages up local source into a pre-existing MRT bundle. INTERNAL ONLY - USE AT YOUR OWN RISK!')
        .addOption(getPortOption())
        .addOption(getSiteDirOption())
        .addOption(getSiteZipOption())
        .option('--allRoutes', '[boolean] automatically regenerate every route in the config after starting the server')
        .addOption(getSsrTimeoutOption())
        .action(async (options, cmd) => {
        const { allRoutes, logLevel, open, port, siteDir, siteZip, timeout } = cmd.optsWithGlobals();
        await expDev({
            inlineUpdate: true,
            logLevel,
            mode: 'prod',
            open,
            port,
            regenerateAllRoutes: allRoutes,
            siteDir,
            siteZip,
            timeout,
            writeSrcFilesToBundle: true,
        });
    });
}
//# sourceMappingURL=mrt-package.js.map