import { Command } from 'commander';
import { getAuthTokenOption, getBasePath, getModeOption, getPortOption, getSsrTimeoutOption, getTargetOption, } from '../utils.js';
import { expPreview } from '@lwrjs/api';
export function createPreviewCommand() {
    return new Command('preview')
        .aliases(['start'])
        .description('Preview your built server on the specified target environment')
        .addOption(getPortOption())
        .addOption(getModeOption())
        .addOption(getTargetOption())
        .addOption(getSsrTimeoutOption())
        .addOption(getAuthTokenOption())
        .addOption(getBasePath())
        .option('-b, --buildDir <string>', '[string] The prebuilt directory for your site')
        .option('-o, --open', `[boolean] open browser on startup`, false)
        .option('-d, --debug', '[boolean] launch the application and wait for a debugger to attach', false)
        .action(async (_options, cmd) => {
        const { rootDir, config, port, target, mode, buildDir, basePath, open, logLevel, timeout, authToken, debug, } = cmd.optsWithGlobals();
        await expPreview({
            rootDir,
            config,
            port,
            target,
            mode,
            buildDir,
            basePath,
            open,
            logLevel,
            timeout,
            authToken,
            debug,
        });
    });
}
//# sourceMappingURL=preview.js.map