# Lightning Web Runtime on Node.js

[![NPM Version](https://img.shields.io/npm/v/lwr)](https://www.npmjs.com/package/lwr)
[![License](https://img.shields.io/npm/l/lwr)](MIT)

Lightning Web Runtime (LWR) enables you to build digital experiences that meet the high scale, security, and performance demands of modern web applications. LWR at its simplest is a non-opinionated way to configure and load the modules, services, and dependency providers you need to build a JavaScript app. You can deploy on a variety of runtime environments, depending on your use case. For example, LWR works in a local Node.js runtime, or as a standalone instance in Heroku.

## Documentation

For detailed usage and documentation, please refer to the [Documentation Site](https://developer.salesforce.com/docs/platform/lwr).

## Features

Some benefits of LWR are:

-   Performance — Thanks to page generation at build time, not runtime, and server side rendering our bar is set at sub-second full-page loads.
-   Friction-Free — An enjoyable local development experience.
-   Power — All the power of Lightning Web Components and the Salesforce platform at your disposal.

LWR describes any configurable aspects of the application in a well-defined, portable format. Because of this flexible deployment model, you can deploy on a variety of runtime environments, depending on your use case. For example, LWR works in a local Node.js runtime or as a standalone instance in Heroku or any hosting provider that supports Node.js.

## Installation

> **Compatibility Note:**
> LWR requires [Node.js](https://nodejs.org/en/) version >=20.0.0.

With NPM:

```bash
npm init lwr@latest
```

With Yarn:

```bash
yarn create lwr
```

Then follow the prompts!
