import { Option, InvalidArgumentError } from 'commander';
export function getTargetOption() {
    return new Option('-t, --target <target>', '[string] configured target for deployment')
        .choices(['default', 'mrt', 'netlify'])
        .default('default');
}
export function getSsrTimeoutOption() {
    return new Option('--timeout [number]', `Set an ssr timeout in ms. If not specified, SSR requests will never timeout.`)
        .env('SSR_TIMEOUT')
        .argParser(parseNumArg);
}
export function getPortOption() {
    return new Option('-p, --port <number>', `[number] set port`).env('PORT').argParser(parseNumArg);
}
export function getSiteDirOption() {
    return new Option('--siteDir <path>', `[path] top level path to a directory where an unpacked experience site lives. If specified in conjunction with --siteZip, the site will be extracted to a child directory named 'app' within this folder.`);
}
export function getSiteZipOption() {
    return new Option('--siteZip <file>', `[file] specify the path to an experience site zip file to extract during local development setup. Will be extracted to a folder named 'app' within the specified 'siteDir'`);
}
export function getModeOption() {
    return new Option('-m, --mode <mode>', '[string] server mode')
        .env('MODE')
        .choices(['dev', 'compat', 'prod-compat', 'prod']);
}
export function getAuthTokenOption() {
    return new Option('--authToken <token>', `[string] set the auth token to be used when fetching data from Salesforce`).env('AUTH_TOKEN');
}
export function getBasePath() {
    return new Option('--basePath <path>', `[string] set the basepath to use for the app`).env('BASE_PATH');
}
export function parseNumArg(value) {
    const parsedValue = parseInt(value, 10);
    if (isNaN(parsedValue)) {
        throw new InvalidArgumentError('Not a number.');
    }
    return parsedValue;
}
//# sourceMappingURL=utils.js.map