(function(global2, factory) {
  typeof exports === "object" && typeof module !== "undefined" ? module.exports = factory() : typeof define === "function" && define.amd ? define(factory) : (global2 = typeof globalThis !== "undefined" ? globalThis : global2 || self, global2.mermaid = factory());
})(this, function() {
  var _a, _b;
  "use strict";
  function dedent(templ) {
    var values2 = [];
    for (var _i = 1; _i < arguments.length; _i++) {
      values2[_i - 1] = arguments[_i];
    }
    var strings = Array.from(typeof templ === "string" ? [templ] : templ);
    strings[strings.length - 1] = strings[strings.length - 1].replace(/\r?\n([\t ]*)$/, "");
    var indentLengths = strings.reduce(function(arr, str2) {
      var matches = str2.match(/\n([\t ]+|(?!\s).)/g);
      if (matches) {
        return arr.concat(matches.map(function(match) {
          var _a2, _b2;
          return (_b2 = (_a2 = match.match(/[\t ]/g)) === null || _a2 === void 0 ? void 0 : _a2.length) !== null && _b2 !== void 0 ? _b2 : 0;
        }));
      }
      return arr;
    }, []);
    if (indentLengths.length) {
      var pattern_1 = new RegExp("\n[	 ]{" + Math.min.apply(Math, indentLengths) + "}", "g");
      strings = strings.map(function(str2) {
        return str2.replace(pattern_1, "\n");
      });
    }
    strings[0] = strings[0].replace(/^\r?\n/, "");
    var string2 = strings[0];
    values2.forEach(function(value2, i2) {
      var endentations = string2.match(/(?:^|\n)( *)$/);
      var endentation = endentations ? endentations[1] : "";
      var indentedValue = value2;
      if (typeof value2 === "string" && value2.includes("\n")) {
        indentedValue = String(value2).split("\n").map(function(str2, i3) {
          return i3 === 0 ? str2 : "" + endentation + str2;
        }).join("\n");
      }
      string2 += indentedValue + strings[i2 + 1];
    });
    return string2;
  }
  var commonjsGlobal = typeof globalThis !== "undefined" ? globalThis : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : typeof self !== "undefined" ? self : {};
  function getDefaultExportFromCjs(x2) {
    return x2 && x2.__esModule && Object.prototype.hasOwnProperty.call(x2, "default") ? x2["default"] : x2;
  }
  var dayjs_min = { exports: {} };
  (function(module2, exports2) {
    !function(t, e) {
      module2.exports = e();
    }(commonjsGlobal, function() {
      var t = 1e3, e = 6e4, n = 36e5, r = "millisecond", i2 = "second", s = "minute", u = "hour", a = "day", o = "week", f2 = "month", h = "quarter", c2 = "year", d = "date", l = "Invalid Date", $ = /^(\d{4})[-/]?(\d{1,2})?[-/]?(\d{0,2})[Tt\s]*(\d{1,2})?:?(\d{1,2})?:?(\d{1,2})?[.:]?(\d+)?$/, y2 = /\[([^\]]+)]|Y{1,4}|M{1,4}|D{1,2}|d{1,4}|H{1,2}|h{1,2}|a|A|m{1,2}|s{1,2}|Z{1,2}|SSS/g, M = { name: "en", weekdays: "Sunday_Monday_Tuesday_Wednesday_Thursday_Friday_Saturday".split("_"), months: "January_February_March_April_May_June_July_August_September_October_November_December".split("_"), ordinal: function(t4) {
        var e3 = ["th", "st", "nd", "rd"], n2 = t4 % 100;
        return "[" + t4 + (e3[(n2 - 20) % 10] || e3[n2] || e3[0]) + "]";
      } }, m = function(t4, e3, n2) {
        var r2 = String(t4);
        return !r2 || r2.length >= e3 ? t4 : "" + Array(e3 + 1 - r2.length).join(n2) + t4;
      }, v = { s: m, z: function(t4) {
        var e3 = -t4.utcOffset(), n2 = Math.abs(e3), r2 = Math.floor(n2 / 60), i3 = n2 % 60;
        return (e3 <= 0 ? "+" : "-") + m(r2, 2, "0") + ":" + m(i3, 2, "0");
      }, m: function t4(e3, n2) {
        if (e3.date() < n2.date())
          return -t4(n2, e3);
        var r2 = 12 * (n2.year() - e3.year()) + (n2.month() - e3.month()), i3 = e3.clone().add(r2, f2), s2 = n2 - i3 < 0, u2 = e3.clone().add(r2 + (s2 ? -1 : 1), f2);
        return +(-(r2 + (n2 - i3) / (s2 ? i3 - u2 : u2 - i3)) || 0);
      }, a: function(t4) {
        return t4 < 0 ? Math.ceil(t4) || 0 : Math.floor(t4);
      }, p: function(t4) {
        return { M: f2, y: c2, w: o, d: a, D: d, h: u, m: s, s: i2, ms: r, Q: h }[t4] || String(t4 || "").toLowerCase().replace(/s$/, "");
      }, u: function(t4) {
        return void 0 === t4;
      } }, g = "en", D = {};
      D[g] = M;
      var p = function(t4) {
        return t4 instanceof _2;
      }, S = function t4(e3, n2, r2) {
        var i3;
        if (!e3)
          return g;
        if ("string" == typeof e3) {
          var s2 = e3.toLowerCase();
          D[s2] && (i3 = s2), n2 && (D[s2] = n2, i3 = s2);
          var u2 = e3.split("-");
          if (!i3 && u2.length > 1)
            return t4(u2[0]);
        } else {
          var a2 = e3.name;
          D[a2] = e3, i3 = a2;
        }
        return !r2 && i3 && (g = i3), i3 || !r2 && g;
      }, w2 = function(t4, e3) {
        if (p(t4))
          return t4.clone();
        var n2 = "object" == typeof e3 ? e3 : {};
        return n2.date = t4, n2.args = arguments, new _2(n2);
      }, O = v;
      O.l = S, O.i = p, O.w = function(t4, e3) {
        return w2(t4, { locale: e3.$L, utc: e3.$u, x: e3.$x, $offset: e3.$offset });
      };
      var _2 = function() {
        function M2(t4) {
          this.$L = S(t4.locale, null, true), this.parse(t4);
        }
        var m2 = M2.prototype;
        return m2.parse = function(t4) {
          this.$d = function(t5) {
            var e3 = t5.date, n2 = t5.utc;
            if (null === e3)
              return /* @__PURE__ */ new Date(NaN);
            if (O.u(e3))
              return /* @__PURE__ */ new Date();
            if (e3 instanceof Date)
              return new Date(e3);
            if ("string" == typeof e3 && !/Z$/i.test(e3)) {
              var r2 = e3.match($);
              if (r2) {
                var i3 = r2[2] - 1 || 0, s2 = (r2[7] || "0").substring(0, 3);
                return n2 ? new Date(Date.UTC(r2[1], i3, r2[3] || 1, r2[4] || 0, r2[5] || 0, r2[6] || 0, s2)) : new Date(r2[1], i3, r2[3] || 1, r2[4] || 0, r2[5] || 0, r2[6] || 0, s2);
              }
            }
            return new Date(e3);
          }(t4), this.$x = t4.x || {}, this.init();
        }, m2.init = function() {
          var t4 = this.$d;
          this.$y = t4.getFullYear(), this.$M = t4.getMonth(), this.$D = t4.getDate(), this.$W = t4.getDay(), this.$H = t4.getHours(), this.$m = t4.getMinutes(), this.$s = t4.getSeconds(), this.$ms = t4.getMilliseconds();
        }, m2.$utils = function() {
          return O;
        }, m2.isValid = function() {
          return !(this.$d.toString() === l);
        }, m2.isSame = function(t4, e3) {
          var n2 = w2(t4);
          return this.startOf(e3) <= n2 && n2 <= this.endOf(e3);
        }, m2.isAfter = function(t4, e3) {
          return w2(t4) < this.startOf(e3);
        }, m2.isBefore = function(t4, e3) {
          return this.endOf(e3) < w2(t4);
        }, m2.$g = function(t4, e3, n2) {
          return O.u(t4) ? this[e3] : this.set(n2, t4);
        }, m2.unix = function() {
          return Math.floor(this.valueOf() / 1e3);
        }, m2.valueOf = function() {
          return this.$d.getTime();
        }, m2.startOf = function(t4, e3) {
          var n2 = this, r2 = !!O.u(e3) || e3, h2 = O.p(t4), l2 = function(t5, e4) {
            var i3 = O.w(n2.$u ? Date.UTC(n2.$y, e4, t5) : new Date(n2.$y, e4, t5), n2);
            return r2 ? i3 : i3.endOf(a);
          }, $2 = function(t5, e4) {
            return O.w(n2.toDate()[t5].apply(n2.toDate("s"), (r2 ? [0, 0, 0, 0] : [23, 59, 59, 999]).slice(e4)), n2);
          }, y3 = this.$W, M3 = this.$M, m3 = this.$D, v2 = "set" + (this.$u ? "UTC" : "");
          switch (h2) {
            case c2:
              return r2 ? l2(1, 0) : l2(31, 11);
            case f2:
              return r2 ? l2(1, M3) : l2(0, M3 + 1);
            case o:
              var g2 = this.$locale().weekStart || 0, D2 = (y3 < g2 ? y3 + 7 : y3) - g2;
              return l2(r2 ? m3 - D2 : m3 + (6 - D2), M3);
            case a:
            case d:
              return $2(v2 + "Hours", 0);
            case u:
              return $2(v2 + "Minutes", 1);
            case s:
              return $2(v2 + "Seconds", 2);
            case i2:
              return $2(v2 + "Milliseconds", 3);
            default:
              return this.clone();
          }
        }, m2.endOf = function(t4) {
          return this.startOf(t4, false);
        }, m2.$set = function(t4, e3) {
          var n2, o2 = O.p(t4), h2 = "set" + (this.$u ? "UTC" : ""), l2 = (n2 = {}, n2[a] = h2 + "Date", n2[d] = h2 + "Date", n2[f2] = h2 + "Month", n2[c2] = h2 + "FullYear", n2[u] = h2 + "Hours", n2[s] = h2 + "Minutes", n2[i2] = h2 + "Seconds", n2[r] = h2 + "Milliseconds", n2)[o2], $2 = o2 === a ? this.$D + (e3 - this.$W) : e3;
          if (o2 === f2 || o2 === c2) {
            var y3 = this.clone().set(d, 1);
            y3.$d[l2]($2), y3.init(), this.$d = y3.set(d, Math.min(this.$D, y3.daysInMonth())).$d;
          } else
            l2 && this.$d[l2]($2);
          return this.init(), this;
        }, m2.set = function(t4, e3) {
          return this.clone().$set(t4, e3);
        }, m2.get = function(t4) {
          return this[O.p(t4)]();
        }, m2.add = function(r2, h2) {
          var d2, l2 = this;
          r2 = Number(r2);
          var $2 = O.p(h2), y3 = function(t4) {
            var e3 = w2(l2);
            return O.w(e3.date(e3.date() + Math.round(t4 * r2)), l2);
          };
          if ($2 === f2)
            return this.set(f2, this.$M + r2);
          if ($2 === c2)
            return this.set(c2, this.$y + r2);
          if ($2 === a)
            return y3(1);
          if ($2 === o)
            return y3(7);
          var M3 = (d2 = {}, d2[s] = e, d2[u] = n, d2[i2] = t, d2)[$2] || 1, m3 = this.$d.getTime() + r2 * M3;
          return O.w(m3, this);
        }, m2.subtract = function(t4, e3) {
          return this.add(-1 * t4, e3);
        }, m2.format = function(t4) {
          var e3 = this, n2 = this.$locale();
          if (!this.isValid())
            return n2.invalidDate || l;
          var r2 = t4 || "YYYY-MM-DDTHH:mm:ssZ", i3 = O.z(this), s2 = this.$H, u2 = this.$m, a2 = this.$M, o2 = n2.weekdays, f3 = n2.months, h2 = function(t5, n3, i4, s3) {
            return t5 && (t5[n3] || t5(e3, r2)) || i4[n3].slice(0, s3);
          }, c3 = function(t5) {
            return O.s(s2 % 12 || 12, t5, "0");
          }, d2 = n2.meridiem || function(t5, e4, n3) {
            var r3 = t5 < 12 ? "AM" : "PM";
            return n3 ? r3.toLowerCase() : r3;
          }, $2 = { YY: String(this.$y).slice(-2), YYYY: this.$y, M: a2 + 1, MM: O.s(a2 + 1, 2, "0"), MMM: h2(n2.monthsShort, a2, f3, 3), MMMM: h2(f3, a2), D: this.$D, DD: O.s(this.$D, 2, "0"), d: String(this.$W), dd: h2(n2.weekdaysMin, this.$W, o2, 2), ddd: h2(n2.weekdaysShort, this.$W, o2, 3), dddd: o2[this.$W], H: String(s2), HH: O.s(s2, 2, "0"), h: c3(1), hh: c3(2), a: d2(s2, u2, true), A: d2(s2, u2, false), m: String(u2), mm: O.s(u2, 2, "0"), s: String(this.$s), ss: O.s(this.$s, 2, "0"), SSS: O.s(this.$ms, 3, "0"), Z: i3 };
          return r2.replace(y2, function(t5, e4) {
            return e4 || $2[t5] || i3.replace(":", "");
          });
        }, m2.utcOffset = function() {
          return 15 * -Math.round(this.$d.getTimezoneOffset() / 15);
        }, m2.diff = function(r2, d2, l2) {
          var $2, y3 = O.p(d2), M3 = w2(r2), m3 = (M3.utcOffset() - this.utcOffset()) * e, v2 = this - M3, g2 = O.m(this, M3);
          return g2 = ($2 = {}, $2[c2] = g2 / 12, $2[f2] = g2, $2[h] = g2 / 3, $2[o] = (v2 - m3) / 6048e5, $2[a] = (v2 - m3) / 864e5, $2[u] = v2 / n, $2[s] = v2 / e, $2[i2] = v2 / t, $2)[y3] || v2, l2 ? g2 : O.a(g2);
        }, m2.daysInMonth = function() {
          return this.endOf(f2).$D;
        }, m2.$locale = function() {
          return D[this.$L];
        }, m2.locale = function(t4, e3) {
          if (!t4)
            return this.$L;
          var n2 = this.clone(), r2 = S(t4, e3, true);
          return r2 && (n2.$L = r2), n2;
        }, m2.clone = function() {
          return O.w(this.$d, this);
        }, m2.toDate = function() {
          return new Date(this.valueOf());
        }, m2.toJSON = function() {
          return this.isValid() ? this.toISOString() : null;
        }, m2.toISOString = function() {
          return this.$d.toISOString();
        }, m2.toString = function() {
          return this.$d.toUTCString();
        }, M2;
      }(), T = _2.prototype;
      return w2.prototype = T, [["$ms", r], ["$s", i2], ["$m", s], ["$H", u], ["$W", a], ["$M", f2], ["$y", c2], ["$D", d]].forEach(function(t4) {
        T[t4[1]] = function(e3) {
          return this.$g(e3, t4[0], t4[1]);
        };
      }), w2.extend = function(t4, e3) {
        return t4.$i || (t4(e3, _2, w2), t4.$i = true), w2;
      }, w2.locale = S, w2.isDayjs = p, w2.unix = function(t4) {
        return w2(1e3 * t4);
      }, w2.en = D[g], w2.Ls = D, w2.p = {}, w2;
    });
  })(dayjs_min);
  var dayjs_minExports = dayjs_min.exports;
  const dayjs = /* @__PURE__ */ getDefaultExportFromCjs(dayjs_minExports);
  const LEVELS = {
    trace: 0,
    debug: 1,
    info: 2,
    warn: 3,
    error: 4,
    fatal: 5
  };
  const log$1 = {
    trace: (..._args) => {
    },
    debug: (..._args) => {
    },
    info: (..._args) => {
    },
    warn: (..._args) => {
    },
    error: (..._args) => {
    },
    fatal: (..._args) => {
    }
  };
  const setLogLevel$1 = function(level = "fatal") {
    let numericLevel = LEVELS.fatal;
    if (typeof level === "string") {
      level = level.toLowerCase();
      if (level in LEVELS) {
        numericLevel = LEVELS[level];
      }
    } else if (typeof level === "number") {
      numericLevel = level;
    }
    log$1.trace = () => {
    };
    log$1.debug = () => {
    };
    log$1.info = () => {
    };
    log$1.warn = () => {
    };
    log$1.error = () => {
    };
    log$1.fatal = () => {
    };
    if (numericLevel <= LEVELS.fatal) {
      log$1.fatal = console.error ? console.error.bind(console, format$1("FATAL"), "color: orange") : console.log.bind(console, "\x1B[35m", format$1("FATAL"));
    }
    if (numericLevel <= LEVELS.error) {
      log$1.error = console.error ? console.error.bind(console, format$1("ERROR"), "color: orange") : console.log.bind(console, "\x1B[31m", format$1("ERROR"));
    }
    if (numericLevel <= LEVELS.warn) {
      log$1.warn = console.warn ? console.warn.bind(console, format$1("WARN"), "color: orange") : console.log.bind(console, `\x1B[33m`, format$1("WARN"));
    }
    if (numericLevel <= LEVELS.info) {
      log$1.info = console.info ? console.info.bind(console, format$1("INFO"), "color: lightblue") : console.log.bind(console, "\x1B[34m", format$1("INFO"));
    }
    if (numericLevel <= LEVELS.debug) {
      log$1.debug = console.debug ? console.debug.bind(console, format$1("DEBUG"), "color: lightgreen") : console.log.bind(console, "\x1B[32m", format$1("DEBUG"));
    }
    if (numericLevel <= LEVELS.trace) {
      log$1.trace = console.debug ? console.debug.bind(console, format$1("TRACE"), "color: lightgreen") : console.log.bind(console, "\x1B[32m", format$1("TRACE"));
    }
  };
  const format$1 = (level) => {
    const time2 = dayjs().format("ss.SSS");
    return `%c${time2} : ${level} : `;
  };
  var dist = {};
  Object.defineProperty(dist, "__esModule", { value: true });
  var sanitizeUrl_1 = dist.sanitizeUrl = void 0;
  var invalidProtocolRegex = /^([^\w]*)(javascript|data|vbscript)/im;
  var htmlEntitiesRegex = /&#(\w+)(^\w|;)?/g;
  var htmlCtrlEntityRegex = /&(newline|tab);/gi;
  var ctrlCharactersRegex = /[\u0000-\u001F\u007F-\u009F\u2000-\u200D\uFEFF]/gim;
  var urlSchemeRegex = /^.+(:|&colon;)/gim;
  var relativeFirstCharacters = [".", "/"];
  function isRelativeUrlWithoutProtocol(url) {
    return relativeFirstCharacters.indexOf(url[0]) > -1;
  }
  function decodeHtmlCharacters(str2) {
    return str2.replace(htmlEntitiesRegex, function(match, dec) {
      return String.fromCharCode(dec);
    });
  }
  function sanitizeUrl(url) {
    var sanitizedUrl = decodeHtmlCharacters(url || "").replace(htmlCtrlEntityRegex, "").replace(ctrlCharactersRegex, "").trim();
    if (!sanitizedUrl) {
      return "about:blank";
    }
    if (isRelativeUrlWithoutProtocol(sanitizedUrl)) {
      return sanitizedUrl;
    }
    var urlSchemeParseResults = sanitizedUrl.match(urlSchemeRegex);
    if (!urlSchemeParseResults) {
      return sanitizedUrl;
    }
    var urlScheme = urlSchemeParseResults[0];
    if (invalidProtocolRegex.test(urlScheme)) {
      return "about:blank";
    }
    return sanitizedUrl;
  }
  sanitizeUrl_1 = dist.sanitizeUrl = sanitizeUrl;
  function ascending$1(a, b) {
    return a == null || b == null ? NaN : a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
  }
  function descending$1(a, b) {
    return a == null || b == null ? NaN : b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;
  }
  function bisector(f2) {
    let compare1, compare2, delta;
    if (f2.length !== 2) {
      compare1 = ascending$1;
      compare2 = (d, x2) => ascending$1(f2(d), x2);
      delta = (d, x2) => f2(d) - x2;
    } else {
      compare1 = f2 === ascending$1 || f2 === descending$1 ? f2 : zero$1;
      compare2 = f2;
      delta = f2;
    }
    function left2(a, x2, lo = 0, hi = a.length) {
      if (lo < hi) {
        if (compare1(x2, x2) !== 0)
          return hi;
        do {
          const mid = lo + hi >>> 1;
          if (compare2(a[mid], x2) < 0)
            lo = mid + 1;
          else
            hi = mid;
        } while (lo < hi);
      }
      return lo;
    }
    function right2(a, x2, lo = 0, hi = a.length) {
      if (lo < hi) {
        if (compare1(x2, x2) !== 0)
          return hi;
        do {
          const mid = lo + hi >>> 1;
          if (compare2(a[mid], x2) <= 0)
            lo = mid + 1;
          else
            hi = mid;
        } while (lo < hi);
      }
      return lo;
    }
    function center2(a, x2, lo = 0, hi = a.length) {
      const i2 = left2(a, x2, lo, hi - 1);
      return i2 > lo && delta(a[i2 - 1], x2) > -delta(a[i2], x2) ? i2 - 1 : i2;
    }
    return { left: left2, center: center2, right: right2 };
  }
  function zero$1() {
    return 0;
  }
  function number$3(x2) {
    return x2 === null ? NaN : +x2;
  }
  const ascendingBisect = bisector(ascending$1);
  const bisectRight = ascendingBisect.right;
  bisector(number$3).center;
  const bisect = bisectRight;
  class InternMap extends Map {
    constructor(entries2, key = keyof) {
      super();
      Object.defineProperties(this, { _intern: { value: /* @__PURE__ */ new Map() }, _key: { value: key } });
      if (entries2 != null)
        for (const [key2, value2] of entries2)
          this.set(key2, value2);
    }
    get(key) {
      return super.get(intern_get(this, key));
    }
    has(key) {
      return super.has(intern_get(this, key));
    }
    set(key, value2) {
      return super.set(intern_set(this, key), value2);
    }
    delete(key) {
      return super.delete(intern_delete(this, key));
    }
  }
  function intern_get({ _intern, _key }, value2) {
    const key = _key(value2);
    return _intern.has(key) ? _intern.get(key) : value2;
  }
  function intern_set({ _intern, _key }, value2) {
    const key = _key(value2);
    if (_intern.has(key))
      return _intern.get(key);
    _intern.set(key, value2);
    return value2;
  }
  function intern_delete({ _intern, _key }, value2) {
    const key = _key(value2);
    if (_intern.has(key)) {
      value2 = _intern.get(key);
      _intern.delete(key);
    }
    return value2;
  }
  function keyof(value2) {
    return value2 !== null && typeof value2 === "object" ? value2.valueOf() : value2;
  }
  const e10 = Math.sqrt(50), e5 = Math.sqrt(10), e2 = Math.sqrt(2);
  function tickSpec(start2, stop, count) {
    const step = (stop - start2) / Math.max(0, count), power = Math.floor(Math.log10(step)), error = step / Math.pow(10, power), factor = error >= e10 ? 10 : error >= e5 ? 5 : error >= e2 ? 2 : 1;
    let i1, i2, inc;
    if (power < 0) {
      inc = Math.pow(10, -power) / factor;
      i1 = Math.round(start2 * inc);
      i2 = Math.round(stop * inc);
      if (i1 / inc < start2)
        ++i1;
      if (i2 / inc > stop)
        --i2;
      inc = -inc;
    } else {
      inc = Math.pow(10, power) * factor;
      i1 = Math.round(start2 / inc);
      i2 = Math.round(stop / inc);
      if (i1 * inc < start2)
        ++i1;
      if (i2 * inc > stop)
        --i2;
    }
    if (i2 < i1 && 0.5 <= count && count < 2)
      return tickSpec(start2, stop, count * 2);
    return [i1, i2, inc];
  }
  function ticks(start2, stop, count) {
    stop = +stop, start2 = +start2, count = +count;
    if (!(count > 0))
      return [];
    if (start2 === stop)
      return [start2];
    const reverse = stop < start2, [i1, i2, inc] = reverse ? tickSpec(stop, start2, count) : tickSpec(start2, stop, count);
    if (!(i2 >= i1))
      return [];
    const n = i2 - i1 + 1, ticks2 = new Array(n);
    if (reverse) {
      if (inc < 0)
        for (let i3 = 0; i3 < n; ++i3)
          ticks2[i3] = (i2 - i3) / -inc;
      else
        for (let i3 = 0; i3 < n; ++i3)
          ticks2[i3] = (i2 - i3) * inc;
    } else {
      if (inc < 0)
        for (let i3 = 0; i3 < n; ++i3)
          ticks2[i3] = (i1 + i3) / -inc;
      else
        for (let i3 = 0; i3 < n; ++i3)
          ticks2[i3] = (i1 + i3) * inc;
    }
    return ticks2;
  }
  function tickIncrement(start2, stop, count) {
    stop = +stop, start2 = +start2, count = +count;
    return tickSpec(start2, stop, count)[2];
  }
  function tickStep(start2, stop, count) {
    stop = +stop, start2 = +start2, count = +count;
    const reverse = stop < start2, inc = reverse ? tickIncrement(stop, start2, count) : tickIncrement(start2, stop, count);
    return (reverse ? -1 : 1) * (inc < 0 ? 1 / -inc : inc);
  }
  function max$3(values2, valueof) {
    let max2;
    if (valueof === void 0) {
      for (const value2 of values2) {
        if (value2 != null && (max2 < value2 || max2 === void 0 && value2 >= value2)) {
          max2 = value2;
        }
      }
    } else {
      let index2 = -1;
      for (let value2 of values2) {
        if ((value2 = valueof(value2, ++index2, values2)) != null && (max2 < value2 || max2 === void 0 && value2 >= value2)) {
          max2 = value2;
        }
      }
    }
    return max2;
  }
  function min$3(values2, valueof) {
    let min2;
    if (valueof === void 0) {
      for (const value2 of values2) {
        if (value2 != null && (min2 > value2 || min2 === void 0 && value2 >= value2)) {
          min2 = value2;
        }
      }
    } else {
      let index2 = -1;
      for (let value2 of values2) {
        if ((value2 = valueof(value2, ++index2, values2)) != null && (min2 > value2 || min2 === void 0 && value2 >= value2)) {
          min2 = value2;
        }
      }
    }
    return min2;
  }
  function range$2(start2, stop, step) {
    start2 = +start2, stop = +stop, step = (n = arguments.length) < 2 ? (stop = start2, start2 = 0, 1) : n < 3 ? 1 : +step;
    var i2 = -1, n = Math.max(0, Math.ceil((stop - start2) / step)) | 0, range2 = new Array(n);
    while (++i2 < n) {
      range2[i2] = start2 + i2 * step;
    }
    return range2;
  }
  function identity$5(x2) {
    return x2;
  }
  var top = 1, right$1 = 2, bottom = 3, left$1 = 4, epsilon$3 = 1e-6;
  function translateX(x2) {
    return "translate(" + x2 + ",0)";
  }
  function translateY(y2) {
    return "translate(0," + y2 + ")";
  }
  function number$2(scale) {
    return (d) => +scale(d);
  }
  function center$1(scale, offset) {
    offset = Math.max(0, scale.bandwidth() - offset * 2) / 2;
    if (scale.round())
      offset = Math.round(offset);
    return (d) => +scale(d) + offset;
  }
  function entering() {
    return !this.__axis;
  }
  function axis(orient, scale) {
    var tickArguments = [], tickValues = null, tickFormat2 = null, tickSizeInner = 6, tickSizeOuter = 6, tickPadding = 3, offset = typeof window !== "undefined" && window.devicePixelRatio > 1 ? 0 : 0.5, k = orient === top || orient === left$1 ? -1 : 1, x2 = orient === left$1 || orient === right$1 ? "x" : "y", transform = orient === top || orient === bottom ? translateX : translateY;
    function axis2(context) {
      var values2 = tickValues == null ? scale.ticks ? scale.ticks.apply(scale, tickArguments) : scale.domain() : tickValues, format2 = tickFormat2 == null ? scale.tickFormat ? scale.tickFormat.apply(scale, tickArguments) : identity$5 : tickFormat2, spacing = Math.max(tickSizeInner, 0) + tickPadding, range2 = scale.range(), range0 = +range2[0] + offset, range1 = +range2[range2.length - 1] + offset, position2 = (scale.bandwidth ? center$1 : number$2)(scale.copy(), offset), selection2 = context.selection ? context.selection() : context, path2 = selection2.selectAll(".domain").data([null]), tick = selection2.selectAll(".tick").data(values2, scale).order(), tickExit = tick.exit(), tickEnter = tick.enter().append("g").attr("class", "tick"), line2 = tick.select("line"), text2 = tick.select("text");
      path2 = path2.merge(path2.enter().insert("path", ".tick").attr("class", "domain").attr("stroke", "currentColor"));
      tick = tick.merge(tickEnter);
      line2 = line2.merge(tickEnter.append("line").attr("stroke", "currentColor").attr(x2 + "2", k * tickSizeInner));
      text2 = text2.merge(tickEnter.append("text").attr("fill", "currentColor").attr(x2, k * spacing).attr("dy", orient === top ? "0em" : orient === bottom ? "0.71em" : "0.32em"));
      if (context !== selection2) {
        path2 = path2.transition(context);
        tick = tick.transition(context);
        line2 = line2.transition(context);
        text2 = text2.transition(context);
        tickExit = tickExit.transition(context).attr("opacity", epsilon$3).attr("transform", function(d) {
          return isFinite(d = position2(d)) ? transform(d + offset) : this.getAttribute("transform");
        });
        tickEnter.attr("opacity", epsilon$3).attr("transform", function(d) {
          var p = this.parentNode.__axis;
          return transform((p && isFinite(p = p(d)) ? p : position2(d)) + offset);
        });
      }
      tickExit.remove();
      path2.attr("d", orient === left$1 || orient === right$1 ? tickSizeOuter ? "M" + k * tickSizeOuter + "," + range0 + "H" + offset + "V" + range1 + "H" + k * tickSizeOuter : "M" + offset + "," + range0 + "V" + range1 : tickSizeOuter ? "M" + range0 + "," + k * tickSizeOuter + "V" + offset + "H" + range1 + "V" + k * tickSizeOuter : "M" + range0 + "," + offset + "H" + range1);
      tick.attr("opacity", 1).attr("transform", function(d) {
        return transform(position2(d) + offset);
      });
      line2.attr(x2 + "2", k * tickSizeInner);
      text2.attr(x2, k * spacing).text(format2);
      selection2.filter(entering).attr("fill", "none").attr("font-size", 10).attr("font-family", "sans-serif").attr("text-anchor", orient === right$1 ? "start" : orient === left$1 ? "end" : "middle");
      selection2.each(function() {
        this.__axis = position2;
      });
    }
    axis2.scale = function(_2) {
      return arguments.length ? (scale = _2, axis2) : scale;
    };
    axis2.ticks = function() {
      return tickArguments = Array.from(arguments), axis2;
    };
    axis2.tickArguments = function(_2) {
      return arguments.length ? (tickArguments = _2 == null ? [] : Array.from(_2), axis2) : tickArguments.slice();
    };
    axis2.tickValues = function(_2) {
      return arguments.length ? (tickValues = _2 == null ? null : Array.from(_2), axis2) : tickValues && tickValues.slice();
    };
    axis2.tickFormat = function(_2) {
      return arguments.length ? (tickFormat2 = _2, axis2) : tickFormat2;
    };
    axis2.tickSize = function(_2) {
      return arguments.length ? (tickSizeInner = tickSizeOuter = +_2, axis2) : tickSizeInner;
    };
    axis2.tickSizeInner = function(_2) {
      return arguments.length ? (tickSizeInner = +_2, axis2) : tickSizeInner;
    };
    axis2.tickSizeOuter = function(_2) {
      return arguments.length ? (tickSizeOuter = +_2, axis2) : tickSizeOuter;
    };
    axis2.tickPadding = function(_2) {
      return arguments.length ? (tickPadding = +_2, axis2) : tickPadding;
    };
    axis2.offset = function(_2) {
      return arguments.length ? (offset = +_2, axis2) : offset;
    };
    return axis2;
  }
  function axisTop(scale) {
    return axis(top, scale);
  }
  function axisBottom(scale) {
    return axis(bottom, scale);
  }
  var noop$2 = { value: () => {
  } };
  function dispatch() {
    for (var i2 = 0, n = arguments.length, _2 = {}, t; i2 < n; ++i2) {
      if (!(t = arguments[i2] + "") || t in _2 || /[\s.]/.test(t))
        throw new Error("illegal type: " + t);
      _2[t] = [];
    }
    return new Dispatch(_2);
  }
  function Dispatch(_2) {
    this._ = _2;
  }
  function parseTypenames$1(typenames, types) {
    return typenames.trim().split(/^|\s+/).map(function(t) {
      var name = "", i2 = t.indexOf(".");
      if (i2 >= 0)
        name = t.slice(i2 + 1), t = t.slice(0, i2);
      if (t && !types.hasOwnProperty(t))
        throw new Error("unknown type: " + t);
      return { type: t, name };
    });
  }
  Dispatch.prototype = dispatch.prototype = {
    constructor: Dispatch,
    on: function(typename, callback) {
      var _2 = this._, T = parseTypenames$1(typename + "", _2), t, i2 = -1, n = T.length;
      if (arguments.length < 2) {
        while (++i2 < n)
          if ((t = (typename = T[i2]).type) && (t = get$3(_2[t], typename.name)))
            return t;
        return;
      }
      if (callback != null && typeof callback !== "function")
        throw new Error("invalid callback: " + callback);
      while (++i2 < n) {
        if (t = (typename = T[i2]).type)
          _2[t] = set$3(_2[t], typename.name, callback);
        else if (callback == null)
          for (t in _2)
            _2[t] = set$3(_2[t], typename.name, null);
      }
      return this;
    },
    copy: function() {
      var copy2 = {}, _2 = this._;
      for (var t in _2)
        copy2[t] = _2[t].slice();
      return new Dispatch(copy2);
    },
    call: function(type2, that) {
      if ((n = arguments.length - 2) > 0)
        for (var args = new Array(n), i2 = 0, n, t; i2 < n; ++i2)
          args[i2] = arguments[i2 + 2];
      if (!this._.hasOwnProperty(type2))
        throw new Error("unknown type: " + type2);
      for (t = this._[type2], i2 = 0, n = t.length; i2 < n; ++i2)
        t[i2].value.apply(that, args);
    },
    apply: function(type2, that, args) {
      if (!this._.hasOwnProperty(type2))
        throw new Error("unknown type: " + type2);
      for (var t = this._[type2], i2 = 0, n = t.length; i2 < n; ++i2)
        t[i2].value.apply(that, args);
    }
  };
  function get$3(type2, name) {
    for (var i2 = 0, n = type2.length, c2; i2 < n; ++i2) {
      if ((c2 = type2[i2]).name === name) {
        return c2.value;
      }
    }
  }
  function set$3(type2, name, callback) {
    for (var i2 = 0, n = type2.length; i2 < n; ++i2) {
      if (type2[i2].name === name) {
        type2[i2] = noop$2, type2 = type2.slice(0, i2).concat(type2.slice(i2 + 1));
        break;
      }
    }
    if (callback != null)
      type2.push({ name, value: callback });
    return type2;
  }
  var xhtml = "http://www.w3.org/1999/xhtml";
  const namespaces$1 = {
    svg: "http://www.w3.org/2000/svg",
    xhtml,
    xlink: "http://www.w3.org/1999/xlink",
    xml: "http://www.w3.org/XML/1998/namespace",
    xmlns: "http://www.w3.org/2000/xmlns/"
  };
  function namespace(name) {
    var prefix = name += "", i2 = prefix.indexOf(":");
    if (i2 >= 0 && (prefix = name.slice(0, i2)) !== "xmlns")
      name = name.slice(i2 + 1);
    return namespaces$1.hasOwnProperty(prefix) ? { space: namespaces$1[prefix], local: name } : name;
  }
  function creatorInherit(name) {
    return function() {
      var document2 = this.ownerDocument, uri = this.namespaceURI;
      return uri === xhtml && document2.documentElement.namespaceURI === xhtml ? document2.createElement(name) : document2.createElementNS(uri, name);
    };
  }
  function creatorFixed(fullname) {
    return function() {
      return this.ownerDocument.createElementNS(fullname.space, fullname.local);
    };
  }
  function creator(name) {
    var fullname = namespace(name);
    return (fullname.local ? creatorFixed : creatorInherit)(fullname);
  }
  function none() {
  }
  function selector(selector2) {
    return selector2 == null ? none : function() {
      return this.querySelector(selector2);
    };
  }
  function selection_select(select) {
    if (typeof select !== "function")
      select = selector(select);
    for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, subgroup = subgroups[j] = new Array(n), node2, subnode, i2 = 0; i2 < n; ++i2) {
        if ((node2 = group[i2]) && (subnode = select.call(node2, node2.__data__, i2, group))) {
          if ("__data__" in node2)
            subnode.__data__ = node2.__data__;
          subgroup[i2] = subnode;
        }
      }
    }
    return new Selection$1(subgroups, this._parents);
  }
  function array$1(x2) {
    return x2 == null ? [] : Array.isArray(x2) ? x2 : Array.from(x2);
  }
  function empty() {
    return [];
  }
  function selectorAll(selector2) {
    return selector2 == null ? empty : function() {
      return this.querySelectorAll(selector2);
    };
  }
  function arrayAll(select) {
    return function() {
      return array$1(select.apply(this, arguments));
    };
  }
  function selection_selectAll(select) {
    if (typeof select === "function")
      select = arrayAll(select);
    else
      select = selectorAll(select);
    for (var groups = this._groups, m = groups.length, subgroups = [], parents2 = [], j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          subgroups.push(select.call(node2, node2.__data__, i2, group));
          parents2.push(node2);
        }
      }
    }
    return new Selection$1(subgroups, parents2);
  }
  function matcher(selector2) {
    return function() {
      return this.matches(selector2);
    };
  }
  function childMatcher(selector2) {
    return function(node2) {
      return node2.matches(selector2);
    };
  }
  var find$3 = Array.prototype.find;
  function childFind(match) {
    return function() {
      return find$3.call(this.children, match);
    };
  }
  function childFirst() {
    return this.firstElementChild;
  }
  function selection_selectChild(match) {
    return this.select(match == null ? childFirst : childFind(typeof match === "function" ? match : childMatcher(match)));
  }
  var filter$1 = Array.prototype.filter;
  function children() {
    return Array.from(this.children);
  }
  function childrenFilter(match) {
    return function() {
      return filter$1.call(this.children, match);
    };
  }
  function selection_selectChildren(match) {
    return this.selectAll(match == null ? children : childrenFilter(typeof match === "function" ? match : childMatcher(match)));
  }
  function selection_filter(match) {
    if (typeof match !== "function")
      match = matcher(match);
    for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, subgroup = subgroups[j] = [], node2, i2 = 0; i2 < n; ++i2) {
        if ((node2 = group[i2]) && match.call(node2, node2.__data__, i2, group)) {
          subgroup.push(node2);
        }
      }
    }
    return new Selection$1(subgroups, this._parents);
  }
  function sparse(update2) {
    return new Array(update2.length);
  }
  function selection_enter() {
    return new Selection$1(this._enter || this._groups.map(sparse), this._parents);
  }
  function EnterNode(parent, datum2) {
    this.ownerDocument = parent.ownerDocument;
    this.namespaceURI = parent.namespaceURI;
    this._next = null;
    this._parent = parent;
    this.__data__ = datum2;
  }
  EnterNode.prototype = {
    constructor: EnterNode,
    appendChild: function(child) {
      return this._parent.insertBefore(child, this._next);
    },
    insertBefore: function(child, next2) {
      return this._parent.insertBefore(child, next2);
    },
    querySelector: function(selector2) {
      return this._parent.querySelector(selector2);
    },
    querySelectorAll: function(selector2) {
      return this._parent.querySelectorAll(selector2);
    }
  };
  function constant$5(x2) {
    return function() {
      return x2;
    };
  }
  function bindIndex(parent, group, enter2, update2, exit2, data) {
    var i2 = 0, node2, groupLength = group.length, dataLength = data.length;
    for (; i2 < dataLength; ++i2) {
      if (node2 = group[i2]) {
        node2.__data__ = data[i2];
        update2[i2] = node2;
      } else {
        enter2[i2] = new EnterNode(parent, data[i2]);
      }
    }
    for (; i2 < groupLength; ++i2) {
      if (node2 = group[i2]) {
        exit2[i2] = node2;
      }
    }
  }
  function bindKey(parent, group, enter2, update2, exit2, data, key) {
    var i2, node2, nodeByKeyValue = /* @__PURE__ */ new Map(), groupLength = group.length, dataLength = data.length, keyValues = new Array(groupLength), keyValue;
    for (i2 = 0; i2 < groupLength; ++i2) {
      if (node2 = group[i2]) {
        keyValues[i2] = keyValue = key.call(node2, node2.__data__, i2, group) + "";
        if (nodeByKeyValue.has(keyValue)) {
          exit2[i2] = node2;
        } else {
          nodeByKeyValue.set(keyValue, node2);
        }
      }
    }
    for (i2 = 0; i2 < dataLength; ++i2) {
      keyValue = key.call(parent, data[i2], i2, data) + "";
      if (node2 = nodeByKeyValue.get(keyValue)) {
        update2[i2] = node2;
        node2.__data__ = data[i2];
        nodeByKeyValue.delete(keyValue);
      } else {
        enter2[i2] = new EnterNode(parent, data[i2]);
      }
    }
    for (i2 = 0; i2 < groupLength; ++i2) {
      if ((node2 = group[i2]) && nodeByKeyValue.get(keyValues[i2]) === node2) {
        exit2[i2] = node2;
      }
    }
  }
  function datum(node2) {
    return node2.__data__;
  }
  function selection_data(value2, key) {
    if (!arguments.length)
      return Array.from(this, datum);
    var bind = key ? bindKey : bindIndex, parents2 = this._parents, groups = this._groups;
    if (typeof value2 !== "function")
      value2 = constant$5(value2);
    for (var m = groups.length, update2 = new Array(m), enter2 = new Array(m), exit2 = new Array(m), j = 0; j < m; ++j) {
      var parent = parents2[j], group = groups[j], groupLength = group.length, data = arraylike(value2.call(parent, parent && parent.__data__, j, parents2)), dataLength = data.length, enterGroup = enter2[j] = new Array(dataLength), updateGroup = update2[j] = new Array(dataLength), exitGroup = exit2[j] = new Array(groupLength);
      bind(parent, group, enterGroup, updateGroup, exitGroup, data, key);
      for (var i0 = 0, i1 = 0, previous2, next2; i0 < dataLength; ++i0) {
        if (previous2 = enterGroup[i0]) {
          if (i0 >= i1)
            i1 = i0 + 1;
          while (!(next2 = updateGroup[i1]) && ++i1 < dataLength)
            ;
          previous2._next = next2 || null;
        }
      }
    }
    update2 = new Selection$1(update2, parents2);
    update2._enter = enter2;
    update2._exit = exit2;
    return update2;
  }
  function arraylike(data) {
    return typeof data === "object" && "length" in data ? data : Array.from(data);
  }
  function selection_exit() {
    return new Selection$1(this._exit || this._groups.map(sparse), this._parents);
  }
  function selection_join(onenter, onupdate, onexit) {
    var enter2 = this.enter(), update2 = this, exit2 = this.exit();
    if (typeof onenter === "function") {
      enter2 = onenter(enter2);
      if (enter2)
        enter2 = enter2.selection();
    } else {
      enter2 = enter2.append(onenter + "");
    }
    if (onupdate != null) {
      update2 = onupdate(update2);
      if (update2)
        update2 = update2.selection();
    }
    if (onexit == null)
      exit2.remove();
    else
      onexit(exit2);
    return enter2 && update2 ? enter2.merge(update2).order() : update2;
  }
  function selection_merge(context) {
    var selection2 = context.selection ? context.selection() : context;
    for (var groups0 = this._groups, groups1 = selection2._groups, m0 = groups0.length, m1 = groups1.length, m = Math.min(m0, m1), merges = new Array(m0), j = 0; j < m; ++j) {
      for (var group0 = groups0[j], group1 = groups1[j], n = group0.length, merge2 = merges[j] = new Array(n), node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group0[i2] || group1[i2]) {
          merge2[i2] = node2;
        }
      }
    }
    for (; j < m0; ++j) {
      merges[j] = groups0[j];
    }
    return new Selection$1(merges, this._parents);
  }
  function selection_order() {
    for (var groups = this._groups, j = -1, m = groups.length; ++j < m; ) {
      for (var group = groups[j], i2 = group.length - 1, next2 = group[i2], node2; --i2 >= 0; ) {
        if (node2 = group[i2]) {
          if (next2 && node2.compareDocumentPosition(next2) ^ 4)
            next2.parentNode.insertBefore(node2, next2);
          next2 = node2;
        }
      }
    }
    return this;
  }
  function selection_sort(compare) {
    if (!compare)
      compare = ascending;
    function compareNode(a, b) {
      return a && b ? compare(a.__data__, b.__data__) : !a - !b;
    }
    for (var groups = this._groups, m = groups.length, sortgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, sortgroup = sortgroups[j] = new Array(n), node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          sortgroup[i2] = node2;
        }
      }
      sortgroup.sort(compareNode);
    }
    return new Selection$1(sortgroups, this._parents).order();
  }
  function ascending(a, b) {
    return a < b ? -1 : a > b ? 1 : a >= b ? 0 : NaN;
  }
  function selection_call() {
    var callback = arguments[0];
    arguments[0] = this;
    callback.apply(null, arguments);
    return this;
  }
  function selection_nodes() {
    return Array.from(this);
  }
  function selection_node() {
    for (var groups = this._groups, j = 0, m = groups.length; j < m; ++j) {
      for (var group = groups[j], i2 = 0, n = group.length; i2 < n; ++i2) {
        var node2 = group[i2];
        if (node2)
          return node2;
      }
    }
    return null;
  }
  function selection_size() {
    let size2 = 0;
    for (const node2 of this)
      ++size2;
    return size2;
  }
  function selection_empty() {
    return !this.node();
  }
  function selection_each(callback) {
    for (var groups = this._groups, j = 0, m = groups.length; j < m; ++j) {
      for (var group = groups[j], i2 = 0, n = group.length, node2; i2 < n; ++i2) {
        if (node2 = group[i2])
          callback.call(node2, node2.__data__, i2, group);
      }
    }
    return this;
  }
  function attrRemove$1(name) {
    return function() {
      this.removeAttribute(name);
    };
  }
  function attrRemoveNS$1(fullname) {
    return function() {
      this.removeAttributeNS(fullname.space, fullname.local);
    };
  }
  function attrConstant$1(name, value2) {
    return function() {
      this.setAttribute(name, value2);
    };
  }
  function attrConstantNS$1(fullname, value2) {
    return function() {
      this.setAttributeNS(fullname.space, fullname.local, value2);
    };
  }
  function attrFunction$1(name, value2) {
    return function() {
      var v = value2.apply(this, arguments);
      if (v == null)
        this.removeAttribute(name);
      else
        this.setAttribute(name, v);
    };
  }
  function attrFunctionNS$1(fullname, value2) {
    return function() {
      var v = value2.apply(this, arguments);
      if (v == null)
        this.removeAttributeNS(fullname.space, fullname.local);
      else
        this.setAttributeNS(fullname.space, fullname.local, v);
    };
  }
  function selection_attr(name, value2) {
    var fullname = namespace(name);
    if (arguments.length < 2) {
      var node2 = this.node();
      return fullname.local ? node2.getAttributeNS(fullname.space, fullname.local) : node2.getAttribute(fullname);
    }
    return this.each((value2 == null ? fullname.local ? attrRemoveNS$1 : attrRemove$1 : typeof value2 === "function" ? fullname.local ? attrFunctionNS$1 : attrFunction$1 : fullname.local ? attrConstantNS$1 : attrConstant$1)(fullname, value2));
  }
  function defaultView(node2) {
    return node2.ownerDocument && node2.ownerDocument.defaultView || node2.document && node2 || node2.defaultView;
  }
  function styleRemove$1(name) {
    return function() {
      this.style.removeProperty(name);
    };
  }
  function styleConstant$1(name, value2, priority) {
    return function() {
      this.style.setProperty(name, value2, priority);
    };
  }
  function styleFunction$1(name, value2, priority) {
    return function() {
      var v = value2.apply(this, arguments);
      if (v == null)
        this.style.removeProperty(name);
      else
        this.style.setProperty(name, v, priority);
    };
  }
  function selection_style(name, value2, priority) {
    return arguments.length > 1 ? this.each((value2 == null ? styleRemove$1 : typeof value2 === "function" ? styleFunction$1 : styleConstant$1)(name, value2, priority == null ? "" : priority)) : styleValue(this.node(), name);
  }
  function styleValue(node2, name) {
    return node2.style.getPropertyValue(name) || defaultView(node2).getComputedStyle(node2, null).getPropertyValue(name);
  }
  function propertyRemove(name) {
    return function() {
      delete this[name];
    };
  }
  function propertyConstant(name, value2) {
    return function() {
      this[name] = value2;
    };
  }
  function propertyFunction(name, value2) {
    return function() {
      var v = value2.apply(this, arguments);
      if (v == null)
        delete this[name];
      else
        this[name] = v;
    };
  }
  function selection_property(name, value2) {
    return arguments.length > 1 ? this.each((value2 == null ? propertyRemove : typeof value2 === "function" ? propertyFunction : propertyConstant)(name, value2)) : this.node()[name];
  }
  function classArray(string2) {
    return string2.trim().split(/^|\s+/);
  }
  function classList(node2) {
    return node2.classList || new ClassList(node2);
  }
  function ClassList(node2) {
    this._node = node2;
    this._names = classArray(node2.getAttribute("class") || "");
  }
  ClassList.prototype = {
    add: function(name) {
      var i2 = this._names.indexOf(name);
      if (i2 < 0) {
        this._names.push(name);
        this._node.setAttribute("class", this._names.join(" "));
      }
    },
    remove: function(name) {
      var i2 = this._names.indexOf(name);
      if (i2 >= 0) {
        this._names.splice(i2, 1);
        this._node.setAttribute("class", this._names.join(" "));
      }
    },
    contains: function(name) {
      return this._names.indexOf(name) >= 0;
    }
  };
  function classedAdd(node2, names) {
    var list2 = classList(node2), i2 = -1, n = names.length;
    while (++i2 < n)
      list2.add(names[i2]);
  }
  function classedRemove(node2, names) {
    var list2 = classList(node2), i2 = -1, n = names.length;
    while (++i2 < n)
      list2.remove(names[i2]);
  }
  function classedTrue(names) {
    return function() {
      classedAdd(this, names);
    };
  }
  function classedFalse(names) {
    return function() {
      classedRemove(this, names);
    };
  }
  function classedFunction(names, value2) {
    return function() {
      (value2.apply(this, arguments) ? classedAdd : classedRemove)(this, names);
    };
  }
  function selection_classed(name, value2) {
    var names = classArray(name + "");
    if (arguments.length < 2) {
      var list2 = classList(this.node()), i2 = -1, n = names.length;
      while (++i2 < n)
        if (!list2.contains(names[i2]))
          return false;
      return true;
    }
    return this.each((typeof value2 === "function" ? classedFunction : value2 ? classedTrue : classedFalse)(names, value2));
  }
  function textRemove() {
    this.textContent = "";
  }
  function textConstant$1(value2) {
    return function() {
      this.textContent = value2;
    };
  }
  function textFunction$1(value2) {
    return function() {
      var v = value2.apply(this, arguments);
      this.textContent = v == null ? "" : v;
    };
  }
  function selection_text(value2) {
    return arguments.length ? this.each(value2 == null ? textRemove : (typeof value2 === "function" ? textFunction$1 : textConstant$1)(value2)) : this.node().textContent;
  }
  function htmlRemove() {
    this.innerHTML = "";
  }
  function htmlConstant(value2) {
    return function() {
      this.innerHTML = value2;
    };
  }
  function htmlFunction(value2) {
    return function() {
      var v = value2.apply(this, arguments);
      this.innerHTML = v == null ? "" : v;
    };
  }
  function selection_html(value2) {
    return arguments.length ? this.each(value2 == null ? htmlRemove : (typeof value2 === "function" ? htmlFunction : htmlConstant)(value2)) : this.node().innerHTML;
  }
  function raise() {
    if (this.nextSibling)
      this.parentNode.appendChild(this);
  }
  function selection_raise() {
    return this.each(raise);
  }
  function lower() {
    if (this.previousSibling)
      this.parentNode.insertBefore(this, this.parentNode.firstChild);
  }
  function selection_lower() {
    return this.each(lower);
  }
  function selection_append(name) {
    var create2 = typeof name === "function" ? name : creator(name);
    return this.select(function() {
      return this.appendChild(create2.apply(this, arguments));
    });
  }
  function constantNull() {
    return null;
  }
  function selection_insert(name, before) {
    var create2 = typeof name === "function" ? name : creator(name), select = before == null ? constantNull : typeof before === "function" ? before : selector(before);
    return this.select(function() {
      return this.insertBefore(create2.apply(this, arguments), select.apply(this, arguments) || null);
    });
  }
  function remove() {
    var parent = this.parentNode;
    if (parent)
      parent.removeChild(this);
  }
  function selection_remove() {
    return this.each(remove);
  }
  function selection_cloneShallow() {
    var clone2 = this.cloneNode(false), parent = this.parentNode;
    return parent ? parent.insertBefore(clone2, this.nextSibling) : clone2;
  }
  function selection_cloneDeep() {
    var clone2 = this.cloneNode(true), parent = this.parentNode;
    return parent ? parent.insertBefore(clone2, this.nextSibling) : clone2;
  }
  function selection_clone(deep) {
    return this.select(deep ? selection_cloneDeep : selection_cloneShallow);
  }
  function selection_datum(value2) {
    return arguments.length ? this.property("__data__", value2) : this.node().__data__;
  }
  function contextListener(listener) {
    return function(event) {
      listener.call(this, event, this.__data__);
    };
  }
  function parseTypenames(typenames) {
    return typenames.trim().split(/^|\s+/).map(function(t) {
      var name = "", i2 = t.indexOf(".");
      if (i2 >= 0)
        name = t.slice(i2 + 1), t = t.slice(0, i2);
      return { type: t, name };
    });
  }
  function onRemove(typename) {
    return function() {
      var on = this.__on;
      if (!on)
        return;
      for (var j = 0, i2 = -1, m = on.length, o; j < m; ++j) {
        if (o = on[j], (!typename.type || o.type === typename.type) && o.name === typename.name) {
          this.removeEventListener(o.type, o.listener, o.options);
        } else {
          on[++i2] = o;
        }
      }
      if (++i2)
        on.length = i2;
      else
        delete this.__on;
    };
  }
  function onAdd(typename, value2, options2) {
    return function() {
      var on = this.__on, o, listener = contextListener(value2);
      if (on)
        for (var j = 0, m = on.length; j < m; ++j) {
          if ((o = on[j]).type === typename.type && o.name === typename.name) {
            this.removeEventListener(o.type, o.listener, o.options);
            this.addEventListener(o.type, o.listener = listener, o.options = options2);
            o.value = value2;
            return;
          }
        }
      this.addEventListener(typename.type, listener, options2);
      o = { type: typename.type, name: typename.name, value: value2, listener, options: options2 };
      if (!on)
        this.__on = [o];
      else
        on.push(o);
    };
  }
  function selection_on(typename, value2, options2) {
    var typenames = parseTypenames(typename + ""), i2, n = typenames.length, t;
    if (arguments.length < 2) {
      var on = this.node().__on;
      if (on)
        for (var j = 0, m = on.length, o; j < m; ++j) {
          for (i2 = 0, o = on[j]; i2 < n; ++i2) {
            if ((t = typenames[i2]).type === o.type && t.name === o.name) {
              return o.value;
            }
          }
        }
      return;
    }
    on = value2 ? onAdd : onRemove;
    for (i2 = 0; i2 < n; ++i2)
      this.each(on(typenames[i2], value2, options2));
    return this;
  }
  function dispatchEvent(node2, type2, params) {
    var window2 = defaultView(node2), event = window2.CustomEvent;
    if (typeof event === "function") {
      event = new event(type2, params);
    } else {
      event = window2.document.createEvent("Event");
      if (params)
        event.initEvent(type2, params.bubbles, params.cancelable), event.detail = params.detail;
      else
        event.initEvent(type2, false, false);
    }
    node2.dispatchEvent(event);
  }
  function dispatchConstant(type2, params) {
    return function() {
      return dispatchEvent(this, type2, params);
    };
  }
  function dispatchFunction(type2, params) {
    return function() {
      return dispatchEvent(this, type2, params.apply(this, arguments));
    };
  }
  function selection_dispatch(type2, params) {
    return this.each((typeof params === "function" ? dispatchFunction : dispatchConstant)(type2, params));
  }
  function* selection_iterator() {
    for (var groups = this._groups, j = 0, m = groups.length; j < m; ++j) {
      for (var group = groups[j], i2 = 0, n = group.length, node2; i2 < n; ++i2) {
        if (node2 = group[i2])
          yield node2;
      }
    }
  }
  var root$2 = [null];
  function Selection$1(groups, parents2) {
    this._groups = groups;
    this._parents = parents2;
  }
  function selection() {
    return new Selection$1([[document.documentElement]], root$2);
  }
  function selection_selection() {
    return this;
  }
  Selection$1.prototype = selection.prototype = {
    constructor: Selection$1,
    select: selection_select,
    selectAll: selection_selectAll,
    selectChild: selection_selectChild,
    selectChildren: selection_selectChildren,
    filter: selection_filter,
    data: selection_data,
    enter: selection_enter,
    exit: selection_exit,
    join: selection_join,
    merge: selection_merge,
    selection: selection_selection,
    order: selection_order,
    sort: selection_sort,
    call: selection_call,
    nodes: selection_nodes,
    node: selection_node,
    size: selection_size,
    empty: selection_empty,
    each: selection_each,
    attr: selection_attr,
    style: selection_style,
    property: selection_property,
    classed: selection_classed,
    text: selection_text,
    html: selection_html,
    raise: selection_raise,
    lower: selection_lower,
    append: selection_append,
    insert: selection_insert,
    remove: selection_remove,
    clone: selection_clone,
    datum: selection_datum,
    on: selection_on,
    dispatch: selection_dispatch,
    [Symbol.iterator]: selection_iterator
  };
  function d3select(selector2) {
    return typeof selector2 === "string" ? new Selection$1([[document.querySelector(selector2)]], [document.documentElement]) : new Selection$1([[selector2]], root$2);
  }
  function selectAll(selector2) {
    return typeof selector2 === "string" ? new Selection$1([document.querySelectorAll(selector2)], [document.documentElement]) : new Selection$1([array$1(selector2)], root$2);
  }
  function define2(constructor, factory, prototype) {
    constructor.prototype = factory.prototype = prototype;
    prototype.constructor = constructor;
  }
  function extend$1(parent, definition2) {
    var prototype = Object.create(parent.prototype);
    for (var key in definition2)
      prototype[key] = definition2[key];
    return prototype;
  }
  function Color$2() {
  }
  var darker = 0.7;
  var brighter = 1 / darker;
  var reI = "\\s*([+-]?\\d+)\\s*", reN = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)\\s*", reP = "\\s*([+-]?(?:\\d*\\.)?\\d+(?:[eE][+-]?\\d+)?)%\\s*", reHex = /^#([0-9a-f]{3,8})$/, reRgbInteger = new RegExp(`^rgb\\(${reI},${reI},${reI}\\)$`), reRgbPercent = new RegExp(`^rgb\\(${reP},${reP},${reP}\\)$`), reRgbaInteger = new RegExp(`^rgba\\(${reI},${reI},${reI},${reN}\\)$`), reRgbaPercent = new RegExp(`^rgba\\(${reP},${reP},${reP},${reN}\\)$`), reHslPercent = new RegExp(`^hsl\\(${reN},${reP},${reP}\\)$`), reHslaPercent = new RegExp(`^hsla\\(${reN},${reP},${reP},${reN}\\)$`);
  var named = {
    aliceblue: 15792383,
    antiquewhite: 16444375,
    aqua: 65535,
    aquamarine: 8388564,
    azure: 15794175,
    beige: 16119260,
    bisque: 16770244,
    black: 0,
    blanchedalmond: 16772045,
    blue: 255,
    blueviolet: 9055202,
    brown: 10824234,
    burlywood: 14596231,
    cadetblue: 6266528,
    chartreuse: 8388352,
    chocolate: 13789470,
    coral: 16744272,
    cornflowerblue: 6591981,
    cornsilk: 16775388,
    crimson: 14423100,
    cyan: 65535,
    darkblue: 139,
    darkcyan: 35723,
    darkgoldenrod: 12092939,
    darkgray: 11119017,
    darkgreen: 25600,
    darkgrey: 11119017,
    darkkhaki: 12433259,
    darkmagenta: 9109643,
    darkolivegreen: 5597999,
    darkorange: 16747520,
    darkorchid: 10040012,
    darkred: 9109504,
    darksalmon: 15308410,
    darkseagreen: 9419919,
    darkslateblue: 4734347,
    darkslategray: 3100495,
    darkslategrey: 3100495,
    darkturquoise: 52945,
    darkviolet: 9699539,
    deeppink: 16716947,
    deepskyblue: 49151,
    dimgray: 6908265,
    dimgrey: 6908265,
    dodgerblue: 2003199,
    firebrick: 11674146,
    floralwhite: 16775920,
    forestgreen: 2263842,
    fuchsia: 16711935,
    gainsboro: 14474460,
    ghostwhite: 16316671,
    gold: 16766720,
    goldenrod: 14329120,
    gray: 8421504,
    green: 32768,
    greenyellow: 11403055,
    grey: 8421504,
    honeydew: 15794160,
    hotpink: 16738740,
    indianred: 13458524,
    indigo: 4915330,
    ivory: 16777200,
    khaki: 15787660,
    lavender: 15132410,
    lavenderblush: 16773365,
    lawngreen: 8190976,
    lemonchiffon: 16775885,
    lightblue: 11393254,
    lightcoral: 15761536,
    lightcyan: 14745599,
    lightgoldenrodyellow: 16448210,
    lightgray: 13882323,
    lightgreen: 9498256,
    lightgrey: 13882323,
    lightpink: 16758465,
    lightsalmon: 16752762,
    lightseagreen: 2142890,
    lightskyblue: 8900346,
    lightslategray: 7833753,
    lightslategrey: 7833753,
    lightsteelblue: 11584734,
    lightyellow: 16777184,
    lime: 65280,
    limegreen: 3329330,
    linen: 16445670,
    magenta: 16711935,
    maroon: 8388608,
    mediumaquamarine: 6737322,
    mediumblue: 205,
    mediumorchid: 12211667,
    mediumpurple: 9662683,
    mediumseagreen: 3978097,
    mediumslateblue: 8087790,
    mediumspringgreen: 64154,
    mediumturquoise: 4772300,
    mediumvioletred: 13047173,
    midnightblue: 1644912,
    mintcream: 16121850,
    mistyrose: 16770273,
    moccasin: 16770229,
    navajowhite: 16768685,
    navy: 128,
    oldlace: 16643558,
    olive: 8421376,
    olivedrab: 7048739,
    orange: 16753920,
    orangered: 16729344,
    orchid: 14315734,
    palegoldenrod: 15657130,
    palegreen: 10025880,
    paleturquoise: 11529966,
    palevioletred: 14381203,
    papayawhip: 16773077,
    peachpuff: 16767673,
    peru: 13468991,
    pink: 16761035,
    plum: 14524637,
    powderblue: 11591910,
    purple: 8388736,
    rebeccapurple: 6697881,
    red: 16711680,
    rosybrown: 12357519,
    royalblue: 4286945,
    saddlebrown: 9127187,
    salmon: 16416882,
    sandybrown: 16032864,
    seagreen: 3050327,
    seashell: 16774638,
    sienna: 10506797,
    silver: 12632256,
    skyblue: 8900331,
    slateblue: 6970061,
    slategray: 7372944,
    slategrey: 7372944,
    snow: 16775930,
    springgreen: 65407,
    steelblue: 4620980,
    tan: 13808780,
    teal: 32896,
    thistle: 14204888,
    tomato: 16737095,
    turquoise: 4251856,
    violet: 15631086,
    wheat: 16113331,
    white: 16777215,
    whitesmoke: 16119285,
    yellow: 16776960,
    yellowgreen: 10145074
  };
  define2(Color$2, color, {
    copy(channels2) {
      return Object.assign(new this.constructor(), this, channels2);
    },
    displayable() {
      return this.rgb().displayable();
    },
    hex: color_formatHex,
    // Deprecated! Use color.formatHex.
    formatHex: color_formatHex,
    formatHex8: color_formatHex8,
    formatHsl: color_formatHsl,
    formatRgb: color_formatRgb,
    toString: color_formatRgb
  });
  function color_formatHex() {
    return this.rgb().formatHex();
  }
  function color_formatHex8() {
    return this.rgb().formatHex8();
  }
  function color_formatHsl() {
    return hslConvert(this).formatHsl();
  }
  function color_formatRgb() {
    return this.rgb().formatRgb();
  }
  function color(format2) {
    var m, l;
    format2 = (format2 + "").trim().toLowerCase();
    return (m = reHex.exec(format2)) ? (l = m[1].length, m = parseInt(m[1], 16), l === 6 ? rgbn(m) : l === 3 ? new Rgb(m >> 8 & 15 | m >> 4 & 240, m >> 4 & 15 | m & 240, (m & 15) << 4 | m & 15, 1) : l === 8 ? rgba$2(m >> 24 & 255, m >> 16 & 255, m >> 8 & 255, (m & 255) / 255) : l === 4 ? rgba$2(m >> 12 & 15 | m >> 8 & 240, m >> 8 & 15 | m >> 4 & 240, m >> 4 & 15 | m & 240, ((m & 15) << 4 | m & 15) / 255) : null) : (m = reRgbInteger.exec(format2)) ? new Rgb(m[1], m[2], m[3], 1) : (m = reRgbPercent.exec(format2)) ? new Rgb(m[1] * 255 / 100, m[2] * 255 / 100, m[3] * 255 / 100, 1) : (m = reRgbaInteger.exec(format2)) ? rgba$2(m[1], m[2], m[3], m[4]) : (m = reRgbaPercent.exec(format2)) ? rgba$2(m[1] * 255 / 100, m[2] * 255 / 100, m[3] * 255 / 100, m[4]) : (m = reHslPercent.exec(format2)) ? hsla(m[1], m[2] / 100, m[3] / 100, 1) : (m = reHslaPercent.exec(format2)) ? hsla(m[1], m[2] / 100, m[3] / 100, m[4]) : named.hasOwnProperty(format2) ? rgbn(named[format2]) : format2 === "transparent" ? new Rgb(NaN, NaN, NaN, 0) : null;
  }
  function rgbn(n) {
    return new Rgb(n >> 16 & 255, n >> 8 & 255, n & 255, 1);
  }
  function rgba$2(r, g, b, a) {
    if (a <= 0)
      r = g = b = NaN;
    return new Rgb(r, g, b, a);
  }
  function rgbConvert(o) {
    if (!(o instanceof Color$2))
      o = color(o);
    if (!o)
      return new Rgb();
    o = o.rgb();
    return new Rgb(o.r, o.g, o.b, o.opacity);
  }
  function rgb(r, g, b, opacity) {
    return arguments.length === 1 ? rgbConvert(r) : new Rgb(r, g, b, opacity == null ? 1 : opacity);
  }
  function Rgb(r, g, b, opacity) {
    this.r = +r;
    this.g = +g;
    this.b = +b;
    this.opacity = +opacity;
  }
  define2(Rgb, rgb, extend$1(Color$2, {
    brighter(k) {
      k = k == null ? brighter : Math.pow(brighter, k);
      return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
    },
    darker(k) {
      k = k == null ? darker : Math.pow(darker, k);
      return new Rgb(this.r * k, this.g * k, this.b * k, this.opacity);
    },
    rgb() {
      return this;
    },
    clamp() {
      return new Rgb(clampi(this.r), clampi(this.g), clampi(this.b), clampa(this.opacity));
    },
    displayable() {
      return -0.5 <= this.r && this.r < 255.5 && (-0.5 <= this.g && this.g < 255.5) && (-0.5 <= this.b && this.b < 255.5) && (0 <= this.opacity && this.opacity <= 1);
    },
    hex: rgb_formatHex,
    // Deprecated! Use color.formatHex.
    formatHex: rgb_formatHex,
    formatHex8: rgb_formatHex8,
    formatRgb: rgb_formatRgb,
    toString: rgb_formatRgb
  }));
  function rgb_formatHex() {
    return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}`;
  }
  function rgb_formatHex8() {
    return `#${hex(this.r)}${hex(this.g)}${hex(this.b)}${hex((isNaN(this.opacity) ? 1 : this.opacity) * 255)}`;
  }
  function rgb_formatRgb() {
    const a = clampa(this.opacity);
    return `${a === 1 ? "rgb(" : "rgba("}${clampi(this.r)}, ${clampi(this.g)}, ${clampi(this.b)}${a === 1 ? ")" : `, ${a})`}`;
  }
  function clampa(opacity) {
    return isNaN(opacity) ? 1 : Math.max(0, Math.min(1, opacity));
  }
  function clampi(value2) {
    return Math.max(0, Math.min(255, Math.round(value2) || 0));
  }
  function hex(value2) {
    value2 = clampi(value2);
    return (value2 < 16 ? "0" : "") + value2.toString(16);
  }
  function hsla(h, s, l, a) {
    if (a <= 0)
      h = s = l = NaN;
    else if (l <= 0 || l >= 1)
      h = s = NaN;
    else if (s <= 0)
      h = NaN;
    return new Hsl(h, s, l, a);
  }
  function hslConvert(o) {
    if (o instanceof Hsl)
      return new Hsl(o.h, o.s, o.l, o.opacity);
    if (!(o instanceof Color$2))
      o = color(o);
    if (!o)
      return new Hsl();
    if (o instanceof Hsl)
      return o;
    o = o.rgb();
    var r = o.r / 255, g = o.g / 255, b = o.b / 255, min2 = Math.min(r, g, b), max2 = Math.max(r, g, b), h = NaN, s = max2 - min2, l = (max2 + min2) / 2;
    if (s) {
      if (r === max2)
        h = (g - b) / s + (g < b) * 6;
      else if (g === max2)
        h = (b - r) / s + 2;
      else
        h = (r - g) / s + 4;
      s /= l < 0.5 ? max2 + min2 : 2 - max2 - min2;
      h *= 60;
    } else {
      s = l > 0 && l < 1 ? 0 : h;
    }
    return new Hsl(h, s, l, o.opacity);
  }
  function hsl(h, s, l, opacity) {
    return arguments.length === 1 ? hslConvert(h) : new Hsl(h, s, l, opacity == null ? 1 : opacity);
  }
  function Hsl(h, s, l, opacity) {
    this.h = +h;
    this.s = +s;
    this.l = +l;
    this.opacity = +opacity;
  }
  define2(Hsl, hsl, extend$1(Color$2, {
    brighter(k) {
      k = k == null ? brighter : Math.pow(brighter, k);
      return new Hsl(this.h, this.s, this.l * k, this.opacity);
    },
    darker(k) {
      k = k == null ? darker : Math.pow(darker, k);
      return new Hsl(this.h, this.s, this.l * k, this.opacity);
    },
    rgb() {
      var h = this.h % 360 + (this.h < 0) * 360, s = isNaN(h) || isNaN(this.s) ? 0 : this.s, l = this.l, m2 = l + (l < 0.5 ? l : 1 - l) * s, m1 = 2 * l - m2;
      return new Rgb(
        hsl2rgb(h >= 240 ? h - 240 : h + 120, m1, m2),
        hsl2rgb(h, m1, m2),
        hsl2rgb(h < 120 ? h + 240 : h - 120, m1, m2),
        this.opacity
      );
    },
    clamp() {
      return new Hsl(clamph(this.h), clampt(this.s), clampt(this.l), clampa(this.opacity));
    },
    displayable() {
      return (0 <= this.s && this.s <= 1 || isNaN(this.s)) && (0 <= this.l && this.l <= 1) && (0 <= this.opacity && this.opacity <= 1);
    },
    formatHsl() {
      const a = clampa(this.opacity);
      return `${a === 1 ? "hsl(" : "hsla("}${clamph(this.h)}, ${clampt(this.s) * 100}%, ${clampt(this.l) * 100}%${a === 1 ? ")" : `, ${a})`}`;
    }
  }));
  function clamph(value2) {
    value2 = (value2 || 0) % 360;
    return value2 < 0 ? value2 + 360 : value2;
  }
  function clampt(value2) {
    return Math.max(0, Math.min(1, value2 || 0));
  }
  function hsl2rgb(h, m1, m2) {
    return (h < 60 ? m1 + (m2 - m1) * h / 60 : h < 180 ? m2 : h < 240 ? m1 + (m2 - m1) * (240 - h) / 60 : m1) * 255;
  }
  const radians = Math.PI / 180;
  const degrees$1 = 180 / Math.PI;
  const K = 18, Xn = 0.96422, Yn = 1, Zn = 0.82521, t0$1 = 4 / 29, t1$1 = 6 / 29, t2 = 3 * t1$1 * t1$1, t3 = t1$1 * t1$1 * t1$1;
  function labConvert(o) {
    if (o instanceof Lab)
      return new Lab(o.l, o.a, o.b, o.opacity);
    if (o instanceof Hcl)
      return hcl2lab(o);
    if (!(o instanceof Rgb))
      o = rgbConvert(o);
    var r = rgb2lrgb(o.r), g = rgb2lrgb(o.g), b = rgb2lrgb(o.b), y2 = xyz2lab((0.2225045 * r + 0.7168786 * g + 0.0606169 * b) / Yn), x2, z;
    if (r === g && g === b)
      x2 = z = y2;
    else {
      x2 = xyz2lab((0.4360747 * r + 0.3850649 * g + 0.1430804 * b) / Xn);
      z = xyz2lab((0.0139322 * r + 0.0971045 * g + 0.7141733 * b) / Zn);
    }
    return new Lab(116 * y2 - 16, 500 * (x2 - y2), 200 * (y2 - z), o.opacity);
  }
  function lab(l, a, b, opacity) {
    return arguments.length === 1 ? labConvert(l) : new Lab(l, a, b, opacity == null ? 1 : opacity);
  }
  function Lab(l, a, b, opacity) {
    this.l = +l;
    this.a = +a;
    this.b = +b;
    this.opacity = +opacity;
  }
  define2(Lab, lab, extend$1(Color$2, {
    brighter(k) {
      return new Lab(this.l + K * (k == null ? 1 : k), this.a, this.b, this.opacity);
    },
    darker(k) {
      return new Lab(this.l - K * (k == null ? 1 : k), this.a, this.b, this.opacity);
    },
    rgb() {
      var y2 = (this.l + 16) / 116, x2 = isNaN(this.a) ? y2 : y2 + this.a / 500, z = isNaN(this.b) ? y2 : y2 - this.b / 200;
      x2 = Xn * lab2xyz(x2);
      y2 = Yn * lab2xyz(y2);
      z = Zn * lab2xyz(z);
      return new Rgb(
        lrgb2rgb(3.1338561 * x2 - 1.6168667 * y2 - 0.4906146 * z),
        lrgb2rgb(-0.9787684 * x2 + 1.9161415 * y2 + 0.033454 * z),
        lrgb2rgb(0.0719453 * x2 - 0.2289914 * y2 + 1.4052427 * z),
        this.opacity
      );
    }
  }));
  function xyz2lab(t) {
    return t > t3 ? Math.pow(t, 1 / 3) : t / t2 + t0$1;
  }
  function lab2xyz(t) {
    return t > t1$1 ? t * t * t : t2 * (t - t0$1);
  }
  function lrgb2rgb(x2) {
    return 255 * (x2 <= 31308e-7 ? 12.92 * x2 : 1.055 * Math.pow(x2, 1 / 2.4) - 0.055);
  }
  function rgb2lrgb(x2) {
    return (x2 /= 255) <= 0.04045 ? x2 / 12.92 : Math.pow((x2 + 0.055) / 1.055, 2.4);
  }
  function hclConvert(o) {
    if (o instanceof Hcl)
      return new Hcl(o.h, o.c, o.l, o.opacity);
    if (!(o instanceof Lab))
      o = labConvert(o);
    if (o.a === 0 && o.b === 0)
      return new Hcl(NaN, 0 < o.l && o.l < 100 ? 0 : NaN, o.l, o.opacity);
    var h = Math.atan2(o.b, o.a) * degrees$1;
    return new Hcl(h < 0 ? h + 360 : h, Math.sqrt(o.a * o.a + o.b * o.b), o.l, o.opacity);
  }
  function hcl$1(h, c2, l, opacity) {
    return arguments.length === 1 ? hclConvert(h) : new Hcl(h, c2, l, opacity == null ? 1 : opacity);
  }
  function Hcl(h, c2, l, opacity) {
    this.h = +h;
    this.c = +c2;
    this.l = +l;
    this.opacity = +opacity;
  }
  function hcl2lab(o) {
    if (isNaN(o.h))
      return new Lab(o.l, 0, 0, o.opacity);
    var h = o.h * radians;
    return new Lab(o.l, Math.cos(h) * o.c, Math.sin(h) * o.c, o.opacity);
  }
  define2(Hcl, hcl$1, extend$1(Color$2, {
    brighter(k) {
      return new Hcl(this.h, this.c, this.l + K * (k == null ? 1 : k), this.opacity);
    },
    darker(k) {
      return new Hcl(this.h, this.c, this.l - K * (k == null ? 1 : k), this.opacity);
    },
    rgb() {
      return hcl2lab(this).rgb();
    }
  }));
  const constant$4 = (x2) => () => x2;
  function linear$1(a, d) {
    return function(t) {
      return a + t * d;
    };
  }
  function exponential(a, b, y2) {
    return a = Math.pow(a, y2), b = Math.pow(b, y2) - a, y2 = 1 / y2, function(t) {
      return Math.pow(a + t * b, y2);
    };
  }
  function hue(a, b) {
    var d = b - a;
    return d ? linear$1(a, d > 180 || d < -180 ? d - 360 * Math.round(d / 360) : d) : constant$4(isNaN(a) ? b : a);
  }
  function gamma(y2) {
    return (y2 = +y2) === 1 ? nogamma : function(a, b) {
      return b - a ? exponential(a, b, y2) : constant$4(isNaN(a) ? b : a);
    };
  }
  function nogamma(a, b) {
    var d = b - a;
    return d ? linear$1(a, d) : constant$4(isNaN(a) ? b : a);
  }
  const interpolateRgb = function rgbGamma(y2) {
    var color2 = gamma(y2);
    function rgb$1(start2, end2) {
      var r = color2((start2 = rgb(start2)).r, (end2 = rgb(end2)).r), g = color2(start2.g, end2.g), b = color2(start2.b, end2.b), opacity = nogamma(start2.opacity, end2.opacity);
      return function(t) {
        start2.r = r(t);
        start2.g = g(t);
        start2.b = b(t);
        start2.opacity = opacity(t);
        return start2 + "";
      };
    }
    rgb$1.gamma = rgbGamma;
    return rgb$1;
  }(1);
  function numberArray(a, b) {
    if (!b)
      b = [];
    var n = a ? Math.min(b.length, a.length) : 0, c2 = b.slice(), i2;
    return function(t) {
      for (i2 = 0; i2 < n; ++i2)
        c2[i2] = a[i2] * (1 - t) + b[i2] * t;
      return c2;
    };
  }
  function isNumberArray(x2) {
    return ArrayBuffer.isView(x2) && !(x2 instanceof DataView);
  }
  function genericArray(a, b) {
    var nb = b ? b.length : 0, na = a ? Math.min(nb, a.length) : 0, x2 = new Array(na), c2 = new Array(nb), i2;
    for (i2 = 0; i2 < na; ++i2)
      x2[i2] = interpolate$1(a[i2], b[i2]);
    for (; i2 < nb; ++i2)
      c2[i2] = b[i2];
    return function(t) {
      for (i2 = 0; i2 < na; ++i2)
        c2[i2] = x2[i2](t);
      return c2;
    };
  }
  function date$1(a, b) {
    var d = /* @__PURE__ */ new Date();
    return a = +a, b = +b, function(t) {
      return d.setTime(a * (1 - t) + b * t), d;
    };
  }
  function interpolateNumber(a, b) {
    return a = +a, b = +b, function(t) {
      return a * (1 - t) + b * t;
    };
  }
  function object(a, b) {
    var i2 = {}, c2 = {}, k;
    if (a === null || typeof a !== "object")
      a = {};
    if (b === null || typeof b !== "object")
      b = {};
    for (k in b) {
      if (k in a) {
        i2[k] = interpolate$1(a[k], b[k]);
      } else {
        c2[k] = b[k];
      }
    }
    return function(t) {
      for (k in i2)
        c2[k] = i2[k](t);
      return c2;
    };
  }
  var reA = /[-+]?(?:\d+\.?\d*|\.?\d+)(?:[eE][-+]?\d+)?/g, reB = new RegExp(reA.source, "g");
  function zero(b) {
    return function() {
      return b;
    };
  }
  function one$1(b) {
    return function(t) {
      return b(t) + "";
    };
  }
  function interpolateString(a, b) {
    var bi = reA.lastIndex = reB.lastIndex = 0, am, bm, bs, i2 = -1, s = [], q = [];
    a = a + "", b = b + "";
    while ((am = reA.exec(a)) && (bm = reB.exec(b))) {
      if ((bs = bm.index) > bi) {
        bs = b.slice(bi, bs);
        if (s[i2])
          s[i2] += bs;
        else
          s[++i2] = bs;
      }
      if ((am = am[0]) === (bm = bm[0])) {
        if (s[i2])
          s[i2] += bm;
        else
          s[++i2] = bm;
      } else {
        s[++i2] = null;
        q.push({ i: i2, x: interpolateNumber(am, bm) });
      }
      bi = reB.lastIndex;
    }
    if (bi < b.length) {
      bs = b.slice(bi);
      if (s[i2])
        s[i2] += bs;
      else
        s[++i2] = bs;
    }
    return s.length < 2 ? q[0] ? one$1(q[0].x) : zero(b) : (b = q.length, function(t) {
      for (var i3 = 0, o; i3 < b; ++i3)
        s[(o = q[i3]).i] = o.x(t);
      return s.join("");
    });
  }
  function interpolate$1(a, b) {
    var t = typeof b, c2;
    return b == null || t === "boolean" ? constant$4(b) : (t === "number" ? interpolateNumber : t === "string" ? (c2 = color(b)) ? (b = c2, interpolateRgb) : interpolateString : b instanceof color ? interpolateRgb : b instanceof Date ? date$1 : isNumberArray(b) ? numberArray : Array.isArray(b) ? genericArray : typeof b.valueOf !== "function" && typeof b.toString !== "function" || isNaN(b) ? object : interpolateNumber)(a, b);
  }
  function interpolateRound(a, b) {
    return a = +a, b = +b, function(t) {
      return Math.round(a * (1 - t) + b * t);
    };
  }
  var degrees = 180 / Math.PI;
  var identity$4 = {
    translateX: 0,
    translateY: 0,
    rotate: 0,
    skewX: 0,
    scaleX: 1,
    scaleY: 1
  };
  function decompose(a, b, c2, d, e, f2) {
    var scaleX, scaleY, skewX;
    if (scaleX = Math.sqrt(a * a + b * b))
      a /= scaleX, b /= scaleX;
    if (skewX = a * c2 + b * d)
      c2 -= a * skewX, d -= b * skewX;
    if (scaleY = Math.sqrt(c2 * c2 + d * d))
      c2 /= scaleY, d /= scaleY, skewX /= scaleY;
    if (a * d < b * c2)
      a = -a, b = -b, skewX = -skewX, scaleX = -scaleX;
    return {
      translateX: e,
      translateY: f2,
      rotate: Math.atan2(b, a) * degrees,
      skewX: Math.atan(skewX) * degrees,
      scaleX,
      scaleY
    };
  }
  var svgNode;
  function parseCss(value2) {
    const m = new (typeof DOMMatrix === "function" ? DOMMatrix : WebKitCSSMatrix)(value2 + "");
    return m.isIdentity ? identity$4 : decompose(m.a, m.b, m.c, m.d, m.e, m.f);
  }
  function parseSvg(value2) {
    if (value2 == null)
      return identity$4;
    if (!svgNode)
      svgNode = document.createElementNS("http://www.w3.org/2000/svg", "g");
    svgNode.setAttribute("transform", value2);
    if (!(value2 = svgNode.transform.baseVal.consolidate()))
      return identity$4;
    value2 = value2.matrix;
    return decompose(value2.a, value2.b, value2.c, value2.d, value2.e, value2.f);
  }
  function interpolateTransform(parse2, pxComma, pxParen, degParen) {
    function pop(s) {
      return s.length ? s.pop() + " " : "";
    }
    function translate(xa, ya, xb, yb, s, q) {
      if (xa !== xb || ya !== yb) {
        var i2 = s.push("translate(", null, pxComma, null, pxParen);
        q.push({ i: i2 - 4, x: interpolateNumber(xa, xb) }, { i: i2 - 2, x: interpolateNumber(ya, yb) });
      } else if (xb || yb) {
        s.push("translate(" + xb + pxComma + yb + pxParen);
      }
    }
    function rotate(a, b, s, q) {
      if (a !== b) {
        if (a - b > 180)
          b += 360;
        else if (b - a > 180)
          a += 360;
        q.push({ i: s.push(pop(s) + "rotate(", null, degParen) - 2, x: interpolateNumber(a, b) });
      } else if (b) {
        s.push(pop(s) + "rotate(" + b + degParen);
      }
    }
    function skewX(a, b, s, q) {
      if (a !== b) {
        q.push({ i: s.push(pop(s) + "skewX(", null, degParen) - 2, x: interpolateNumber(a, b) });
      } else if (b) {
        s.push(pop(s) + "skewX(" + b + degParen);
      }
    }
    function scale(xa, ya, xb, yb, s, q) {
      if (xa !== xb || ya !== yb) {
        var i2 = s.push(pop(s) + "scale(", null, ",", null, ")");
        q.push({ i: i2 - 4, x: interpolateNumber(xa, xb) }, { i: i2 - 2, x: interpolateNumber(ya, yb) });
      } else if (xb !== 1 || yb !== 1) {
        s.push(pop(s) + "scale(" + xb + "," + yb + ")");
      }
    }
    return function(a, b) {
      var s = [], q = [];
      a = parse2(a), b = parse2(b);
      translate(a.translateX, a.translateY, b.translateX, b.translateY, s, q);
      rotate(a.rotate, b.rotate, s, q);
      skewX(a.skewX, b.skewX, s, q);
      scale(a.scaleX, a.scaleY, b.scaleX, b.scaleY, s, q);
      a = b = null;
      return function(t) {
        var i2 = -1, n = q.length, o;
        while (++i2 < n)
          s[(o = q[i2]).i] = o.x(t);
        return s.join("");
      };
    };
  }
  var interpolateTransformCss = interpolateTransform(parseCss, "px, ", "px)", "deg)");
  var interpolateTransformSvg = interpolateTransform(parseSvg, ", ", ")", ")");
  function hcl(hue2) {
    return function(start2, end2) {
      var h = hue2((start2 = hcl$1(start2)).h, (end2 = hcl$1(end2)).h), c2 = nogamma(start2.c, end2.c), l = nogamma(start2.l, end2.l), opacity = nogamma(start2.opacity, end2.opacity);
      return function(t) {
        start2.h = h(t);
        start2.c = c2(t);
        start2.l = l(t);
        start2.opacity = opacity(t);
        return start2 + "";
      };
    };
  }
  const interpolateHcl = hcl(hue);
  var frame = 0, timeout$1 = 0, interval = 0, pokeDelay = 1e3, taskHead, taskTail, clockLast = 0, clockNow = 0, clockSkew = 0, clock = typeof performance === "object" && performance.now ? performance : Date, setFrame = typeof window === "object" && window.requestAnimationFrame ? window.requestAnimationFrame.bind(window) : function(f2) {
    setTimeout(f2, 17);
  };
  function now$2() {
    return clockNow || (setFrame(clearNow), clockNow = clock.now() + clockSkew);
  }
  function clearNow() {
    clockNow = 0;
  }
  function Timer() {
    this._call = this._time = this._next = null;
  }
  Timer.prototype = timer.prototype = {
    constructor: Timer,
    restart: function(callback, delay, time2) {
      if (typeof callback !== "function")
        throw new TypeError("callback is not a function");
      time2 = (time2 == null ? now$2() : +time2) + (delay == null ? 0 : +delay);
      if (!this._next && taskTail !== this) {
        if (taskTail)
          taskTail._next = this;
        else
          taskHead = this;
        taskTail = this;
      }
      this._call = callback;
      this._time = time2;
      sleep();
    },
    stop: function() {
      if (this._call) {
        this._call = null;
        this._time = Infinity;
        sleep();
      }
    }
  };
  function timer(callback, delay, time2) {
    var t = new Timer();
    t.restart(callback, delay, time2);
    return t;
  }
  function timerFlush() {
    now$2();
    ++frame;
    var t = taskHead, e;
    while (t) {
      if ((e = clockNow - t._time) >= 0)
        t._call.call(void 0, e);
      t = t._next;
    }
    --frame;
  }
  function wake() {
    clockNow = (clockLast = clock.now()) + clockSkew;
    frame = timeout$1 = 0;
    try {
      timerFlush();
    } finally {
      frame = 0;
      nap();
      clockNow = 0;
    }
  }
  function poke() {
    var now2 = clock.now(), delay = now2 - clockLast;
    if (delay > pokeDelay)
      clockSkew -= delay, clockLast = now2;
  }
  function nap() {
    var t02, t12 = taskHead, t22, time2 = Infinity;
    while (t12) {
      if (t12._call) {
        if (time2 > t12._time)
          time2 = t12._time;
        t02 = t12, t12 = t12._next;
      } else {
        t22 = t12._next, t12._next = null;
        t12 = t02 ? t02._next = t22 : taskHead = t22;
      }
    }
    taskTail = t02;
    sleep(time2);
  }
  function sleep(time2) {
    if (frame)
      return;
    if (timeout$1)
      timeout$1 = clearTimeout(timeout$1);
    var delay = time2 - clockNow;
    if (delay > 24) {
      if (time2 < Infinity)
        timeout$1 = setTimeout(wake, time2 - clock.now() - clockSkew);
      if (interval)
        interval = clearInterval(interval);
    } else {
      if (!interval)
        clockLast = clock.now(), interval = setInterval(poke, pokeDelay);
      frame = 1, setFrame(wake);
    }
  }
  function timeout(callback, delay, time2) {
    var t = new Timer();
    delay = delay == null ? 0 : +delay;
    t.restart((elapsed) => {
      t.stop();
      callback(elapsed + delay);
    }, delay, time2);
    return t;
  }
  var emptyOn = dispatch("start", "end", "cancel", "interrupt");
  var emptyTween = [];
  var CREATED = 0;
  var SCHEDULED = 1;
  var STARTING = 2;
  var STARTED = 3;
  var RUNNING = 4;
  var ENDING = 5;
  var ENDED = 6;
  function schedule(node2, name, id2, index2, group, timing) {
    var schedules = node2.__transition;
    if (!schedules)
      node2.__transition = {};
    else if (id2 in schedules)
      return;
    create$1(node2, id2, {
      name,
      index: index2,
      // For context during callback.
      group,
      // For context during callback.
      on: emptyOn,
      tween: emptyTween,
      time: timing.time,
      delay: timing.delay,
      duration: timing.duration,
      ease: timing.ease,
      timer: null,
      state: CREATED
    });
  }
  function init$1(node2, id2) {
    var schedule2 = get$2(node2, id2);
    if (schedule2.state > CREATED)
      throw new Error("too late; already scheduled");
    return schedule2;
  }
  function set$2(node2, id2) {
    var schedule2 = get$2(node2, id2);
    if (schedule2.state > STARTED)
      throw new Error("too late; already running");
    return schedule2;
  }
  function get$2(node2, id2) {
    var schedule2 = node2.__transition;
    if (!schedule2 || !(schedule2 = schedule2[id2]))
      throw new Error("transition not found");
    return schedule2;
  }
  function create$1(node2, id2, self2) {
    var schedules = node2.__transition, tween;
    schedules[id2] = self2;
    self2.timer = timer(schedule2, 0, self2.time);
    function schedule2(elapsed) {
      self2.state = SCHEDULED;
      self2.timer.restart(start2, self2.delay, self2.time);
      if (self2.delay <= elapsed)
        start2(elapsed - self2.delay);
    }
    function start2(elapsed) {
      var i2, j, n, o;
      if (self2.state !== SCHEDULED)
        return stop();
      for (i2 in schedules) {
        o = schedules[i2];
        if (o.name !== self2.name)
          continue;
        if (o.state === STARTED)
          return timeout(start2);
        if (o.state === RUNNING) {
          o.state = ENDED;
          o.timer.stop();
          o.on.call("interrupt", node2, node2.__data__, o.index, o.group);
          delete schedules[i2];
        } else if (+i2 < id2) {
          o.state = ENDED;
          o.timer.stop();
          o.on.call("cancel", node2, node2.__data__, o.index, o.group);
          delete schedules[i2];
        }
      }
      timeout(function() {
        if (self2.state === STARTED) {
          self2.state = RUNNING;
          self2.timer.restart(tick, self2.delay, self2.time);
          tick(elapsed);
        }
      });
      self2.state = STARTING;
      self2.on.call("start", node2, node2.__data__, self2.index, self2.group);
      if (self2.state !== STARTING)
        return;
      self2.state = STARTED;
      tween = new Array(n = self2.tween.length);
      for (i2 = 0, j = -1; i2 < n; ++i2) {
        if (o = self2.tween[i2].value.call(node2, node2.__data__, self2.index, self2.group)) {
          tween[++j] = o;
        }
      }
      tween.length = j + 1;
    }
    function tick(elapsed) {
      var t = elapsed < self2.duration ? self2.ease.call(null, elapsed / self2.duration) : (self2.timer.restart(stop), self2.state = ENDING, 1), i2 = -1, n = tween.length;
      while (++i2 < n) {
        tween[i2].call(node2, t);
      }
      if (self2.state === ENDING) {
        self2.on.call("end", node2, node2.__data__, self2.index, self2.group);
        stop();
      }
    }
    function stop() {
      self2.state = ENDED;
      self2.timer.stop();
      delete schedules[id2];
      for (var i2 in schedules)
        return;
      delete node2.__transition;
    }
  }
  function interrupt(node2, name) {
    var schedules = node2.__transition, schedule2, active, empty2 = true, i2;
    if (!schedules)
      return;
    name = name == null ? null : name + "";
    for (i2 in schedules) {
      if ((schedule2 = schedules[i2]).name !== name) {
        empty2 = false;
        continue;
      }
      active = schedule2.state > STARTING && schedule2.state < ENDING;
      schedule2.state = ENDED;
      schedule2.timer.stop();
      schedule2.on.call(active ? "interrupt" : "cancel", node2, node2.__data__, schedule2.index, schedule2.group);
      delete schedules[i2];
    }
    if (empty2)
      delete node2.__transition;
  }
  function selection_interrupt(name) {
    return this.each(function() {
      interrupt(this, name);
    });
  }
  function tweenRemove(id2, name) {
    var tween0, tween1;
    return function() {
      var schedule2 = set$2(this, id2), tween = schedule2.tween;
      if (tween !== tween0) {
        tween1 = tween0 = tween;
        for (var i2 = 0, n = tween1.length; i2 < n; ++i2) {
          if (tween1[i2].name === name) {
            tween1 = tween1.slice();
            tween1.splice(i2, 1);
            break;
          }
        }
      }
      schedule2.tween = tween1;
    };
  }
  function tweenFunction(id2, name, value2) {
    var tween0, tween1;
    if (typeof value2 !== "function")
      throw new Error();
    return function() {
      var schedule2 = set$2(this, id2), tween = schedule2.tween;
      if (tween !== tween0) {
        tween1 = (tween0 = tween).slice();
        for (var t = { name, value: value2 }, i2 = 0, n = tween1.length; i2 < n; ++i2) {
          if (tween1[i2].name === name) {
            tween1[i2] = t;
            break;
          }
        }
        if (i2 === n)
          tween1.push(t);
      }
      schedule2.tween = tween1;
    };
  }
  function transition_tween(name, value2) {
    var id2 = this._id;
    name += "";
    if (arguments.length < 2) {
      var tween = get$2(this.node(), id2).tween;
      for (var i2 = 0, n = tween.length, t; i2 < n; ++i2) {
        if ((t = tween[i2]).name === name) {
          return t.value;
        }
      }
      return null;
    }
    return this.each((value2 == null ? tweenRemove : tweenFunction)(id2, name, value2));
  }
  function tweenValue(transition, name, value2) {
    var id2 = transition._id;
    transition.each(function() {
      var schedule2 = set$2(this, id2);
      (schedule2.value || (schedule2.value = {}))[name] = value2.apply(this, arguments);
    });
    return function(node2) {
      return get$2(node2, id2).value[name];
    };
  }
  function interpolate(a, b) {
    var c2;
    return (typeof b === "number" ? interpolateNumber : b instanceof color ? interpolateRgb : (c2 = color(b)) ? (b = c2, interpolateRgb) : interpolateString)(a, b);
  }
  function attrRemove(name) {
    return function() {
      this.removeAttribute(name);
    };
  }
  function attrRemoveNS(fullname) {
    return function() {
      this.removeAttributeNS(fullname.space, fullname.local);
    };
  }
  function attrConstant(name, interpolate2, value1) {
    var string00, string1 = value1 + "", interpolate0;
    return function() {
      var string0 = this.getAttribute(name);
      return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
    };
  }
  function attrConstantNS(fullname, interpolate2, value1) {
    var string00, string1 = value1 + "", interpolate0;
    return function() {
      var string0 = this.getAttributeNS(fullname.space, fullname.local);
      return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
    };
  }
  function attrFunction(name, interpolate2, value2) {
    var string00, string10, interpolate0;
    return function() {
      var string0, value1 = value2(this), string1;
      if (value1 == null)
        return void this.removeAttribute(name);
      string0 = this.getAttribute(name);
      string1 = value1 + "";
      return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
    };
  }
  function attrFunctionNS(fullname, interpolate2, value2) {
    var string00, string10, interpolate0;
    return function() {
      var string0, value1 = value2(this), string1;
      if (value1 == null)
        return void this.removeAttributeNS(fullname.space, fullname.local);
      string0 = this.getAttributeNS(fullname.space, fullname.local);
      string1 = value1 + "";
      return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
    };
  }
  function transition_attr(name, value2) {
    var fullname = namespace(name), i2 = fullname === "transform" ? interpolateTransformSvg : interpolate;
    return this.attrTween(name, typeof value2 === "function" ? (fullname.local ? attrFunctionNS : attrFunction)(fullname, i2, tweenValue(this, "attr." + name, value2)) : value2 == null ? (fullname.local ? attrRemoveNS : attrRemove)(fullname) : (fullname.local ? attrConstantNS : attrConstant)(fullname, i2, value2));
  }
  function attrInterpolate(name, i2) {
    return function(t) {
      this.setAttribute(name, i2.call(this, t));
    };
  }
  function attrInterpolateNS(fullname, i2) {
    return function(t) {
      this.setAttributeNS(fullname.space, fullname.local, i2.call(this, t));
    };
  }
  function attrTweenNS(fullname, value2) {
    var t02, i0;
    function tween() {
      var i2 = value2.apply(this, arguments);
      if (i2 !== i0)
        t02 = (i0 = i2) && attrInterpolateNS(fullname, i2);
      return t02;
    }
    tween._value = value2;
    return tween;
  }
  function attrTween(name, value2) {
    var t02, i0;
    function tween() {
      var i2 = value2.apply(this, arguments);
      if (i2 !== i0)
        t02 = (i0 = i2) && attrInterpolate(name, i2);
      return t02;
    }
    tween._value = value2;
    return tween;
  }
  function transition_attrTween(name, value2) {
    var key = "attr." + name;
    if (arguments.length < 2)
      return (key = this.tween(key)) && key._value;
    if (value2 == null)
      return this.tween(key, null);
    if (typeof value2 !== "function")
      throw new Error();
    var fullname = namespace(name);
    return this.tween(key, (fullname.local ? attrTweenNS : attrTween)(fullname, value2));
  }
  function delayFunction(id2, value2) {
    return function() {
      init$1(this, id2).delay = +value2.apply(this, arguments);
    };
  }
  function delayConstant(id2, value2) {
    return value2 = +value2, function() {
      init$1(this, id2).delay = value2;
    };
  }
  function transition_delay(value2) {
    var id2 = this._id;
    return arguments.length ? this.each((typeof value2 === "function" ? delayFunction : delayConstant)(id2, value2)) : get$2(this.node(), id2).delay;
  }
  function durationFunction(id2, value2) {
    return function() {
      set$2(this, id2).duration = +value2.apply(this, arguments);
    };
  }
  function durationConstant(id2, value2) {
    return value2 = +value2, function() {
      set$2(this, id2).duration = value2;
    };
  }
  function transition_duration(value2) {
    var id2 = this._id;
    return arguments.length ? this.each((typeof value2 === "function" ? durationFunction : durationConstant)(id2, value2)) : get$2(this.node(), id2).duration;
  }
  function easeConstant(id2, value2) {
    if (typeof value2 !== "function")
      throw new Error();
    return function() {
      set$2(this, id2).ease = value2;
    };
  }
  function transition_ease(value2) {
    var id2 = this._id;
    return arguments.length ? this.each(easeConstant(id2, value2)) : get$2(this.node(), id2).ease;
  }
  function easeVarying(id2, value2) {
    return function() {
      var v = value2.apply(this, arguments);
      if (typeof v !== "function")
        throw new Error();
      set$2(this, id2).ease = v;
    };
  }
  function transition_easeVarying(value2) {
    if (typeof value2 !== "function")
      throw new Error();
    return this.each(easeVarying(this._id, value2));
  }
  function transition_filter(match) {
    if (typeof match !== "function")
      match = matcher(match);
    for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, subgroup = subgroups[j] = [], node2, i2 = 0; i2 < n; ++i2) {
        if ((node2 = group[i2]) && match.call(node2, node2.__data__, i2, group)) {
          subgroup.push(node2);
        }
      }
    }
    return new Transition(subgroups, this._parents, this._name, this._id);
  }
  function transition_merge(transition) {
    if (transition._id !== this._id)
      throw new Error();
    for (var groups0 = this._groups, groups1 = transition._groups, m0 = groups0.length, m1 = groups1.length, m = Math.min(m0, m1), merges = new Array(m0), j = 0; j < m; ++j) {
      for (var group0 = groups0[j], group1 = groups1[j], n = group0.length, merge2 = merges[j] = new Array(n), node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group0[i2] || group1[i2]) {
          merge2[i2] = node2;
        }
      }
    }
    for (; j < m0; ++j) {
      merges[j] = groups0[j];
    }
    return new Transition(merges, this._parents, this._name, this._id);
  }
  function start$1(name) {
    return (name + "").trim().split(/^|\s+/).every(function(t) {
      var i2 = t.indexOf(".");
      if (i2 >= 0)
        t = t.slice(0, i2);
      return !t || t === "start";
    });
  }
  function onFunction(id2, name, listener) {
    var on0, on1, sit = start$1(name) ? init$1 : set$2;
    return function() {
      var schedule2 = sit(this, id2), on = schedule2.on;
      if (on !== on0)
        (on1 = (on0 = on).copy()).on(name, listener);
      schedule2.on = on1;
    };
  }
  function transition_on(name, listener) {
    var id2 = this._id;
    return arguments.length < 2 ? get$2(this.node(), id2).on.on(name) : this.each(onFunction(id2, name, listener));
  }
  function removeFunction(id2) {
    return function() {
      var parent = this.parentNode;
      for (var i2 in this.__transition)
        if (+i2 !== id2)
          return;
      if (parent)
        parent.removeChild(this);
    };
  }
  function transition_remove() {
    return this.on("end.remove", removeFunction(this._id));
  }
  function transition_select(select) {
    var name = this._name, id2 = this._id;
    if (typeof select !== "function")
      select = selector(select);
    for (var groups = this._groups, m = groups.length, subgroups = new Array(m), j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, subgroup = subgroups[j] = new Array(n), node2, subnode, i2 = 0; i2 < n; ++i2) {
        if ((node2 = group[i2]) && (subnode = select.call(node2, node2.__data__, i2, group))) {
          if ("__data__" in node2)
            subnode.__data__ = node2.__data__;
          subgroup[i2] = subnode;
          schedule(subgroup[i2], name, id2, i2, subgroup, get$2(node2, id2));
        }
      }
    }
    return new Transition(subgroups, this._parents, name, id2);
  }
  function transition_selectAll(select) {
    var name = this._name, id2 = this._id;
    if (typeof select !== "function")
      select = selectorAll(select);
    for (var groups = this._groups, m = groups.length, subgroups = [], parents2 = [], j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          for (var children2 = select.call(node2, node2.__data__, i2, group), child, inherit2 = get$2(node2, id2), k = 0, l = children2.length; k < l; ++k) {
            if (child = children2[k]) {
              schedule(child, name, id2, k, children2, inherit2);
            }
          }
          subgroups.push(children2);
          parents2.push(node2);
        }
      }
    }
    return new Transition(subgroups, parents2, name, id2);
  }
  var Selection = selection.prototype.constructor;
  function transition_selection() {
    return new Selection(this._groups, this._parents);
  }
  function styleNull(name, interpolate2) {
    var string00, string10, interpolate0;
    return function() {
      var string0 = styleValue(this, name), string1 = (this.style.removeProperty(name), styleValue(this, name));
      return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, string10 = string1);
    };
  }
  function styleRemove(name) {
    return function() {
      this.style.removeProperty(name);
    };
  }
  function styleConstant(name, interpolate2, value1) {
    var string00, string1 = value1 + "", interpolate0;
    return function() {
      var string0 = styleValue(this, name);
      return string0 === string1 ? null : string0 === string00 ? interpolate0 : interpolate0 = interpolate2(string00 = string0, value1);
    };
  }
  function styleFunction(name, interpolate2, value2) {
    var string00, string10, interpolate0;
    return function() {
      var string0 = styleValue(this, name), value1 = value2(this), string1 = value1 + "";
      if (value1 == null)
        string1 = value1 = (this.style.removeProperty(name), styleValue(this, name));
      return string0 === string1 ? null : string0 === string00 && string1 === string10 ? interpolate0 : (string10 = string1, interpolate0 = interpolate2(string00 = string0, value1));
    };
  }
  function styleMaybeRemove(id2, name) {
    var on0, on1, listener0, key = "style." + name, event = "end." + key, remove2;
    return function() {
      var schedule2 = set$2(this, id2), on = schedule2.on, listener = schedule2.value[key] == null ? remove2 || (remove2 = styleRemove(name)) : void 0;
      if (on !== on0 || listener0 !== listener)
        (on1 = (on0 = on).copy()).on(event, listener0 = listener);
      schedule2.on = on1;
    };
  }
  function transition_style(name, value2, priority) {
    var i2 = (name += "") === "transform" ? interpolateTransformCss : interpolate;
    return value2 == null ? this.styleTween(name, styleNull(name, i2)).on("end.style." + name, styleRemove(name)) : typeof value2 === "function" ? this.styleTween(name, styleFunction(name, i2, tweenValue(this, "style." + name, value2))).each(styleMaybeRemove(this._id, name)) : this.styleTween(name, styleConstant(name, i2, value2), priority).on("end.style." + name, null);
  }
  function styleInterpolate(name, i2, priority) {
    return function(t) {
      this.style.setProperty(name, i2.call(this, t), priority);
    };
  }
  function styleTween(name, value2, priority) {
    var t, i0;
    function tween() {
      var i2 = value2.apply(this, arguments);
      if (i2 !== i0)
        t = (i0 = i2) && styleInterpolate(name, i2, priority);
      return t;
    }
    tween._value = value2;
    return tween;
  }
  function transition_styleTween(name, value2, priority) {
    var key = "style." + (name += "");
    if (arguments.length < 2)
      return (key = this.tween(key)) && key._value;
    if (value2 == null)
      return this.tween(key, null);
    if (typeof value2 !== "function")
      throw new Error();
    return this.tween(key, styleTween(name, value2, priority == null ? "" : priority));
  }
  function textConstant(value2) {
    return function() {
      this.textContent = value2;
    };
  }
  function textFunction(value2) {
    return function() {
      var value1 = value2(this);
      this.textContent = value1 == null ? "" : value1;
    };
  }
  function transition_text(value2) {
    return this.tween("text", typeof value2 === "function" ? textFunction(tweenValue(this, "text", value2)) : textConstant(value2 == null ? "" : value2 + ""));
  }
  function textInterpolate(i2) {
    return function(t) {
      this.textContent = i2.call(this, t);
    };
  }
  function textTween(value2) {
    var t02, i0;
    function tween() {
      var i2 = value2.apply(this, arguments);
      if (i2 !== i0)
        t02 = (i0 = i2) && textInterpolate(i2);
      return t02;
    }
    tween._value = value2;
    return tween;
  }
  function transition_textTween(value2) {
    var key = "text";
    if (arguments.length < 1)
      return (key = this.tween(key)) && key._value;
    if (value2 == null)
      return this.tween(key, null);
    if (typeof value2 !== "function")
      throw new Error();
    return this.tween(key, textTween(value2));
  }
  function transition_transition() {
    var name = this._name, id0 = this._id, id1 = newId();
    for (var groups = this._groups, m = groups.length, j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          var inherit2 = get$2(node2, id0);
          schedule(node2, name, id1, i2, group, {
            time: inherit2.time + inherit2.delay + inherit2.duration,
            delay: 0,
            duration: inherit2.duration,
            ease: inherit2.ease
          });
        }
      }
    }
    return new Transition(groups, this._parents, name, id1);
  }
  function transition_end() {
    var on0, on1, that = this, id2 = that._id, size2 = that.size();
    return new Promise(function(resolve, reject) {
      var cancel = { value: reject }, end2 = { value: function() {
        if (--size2 === 0)
          resolve();
      } };
      that.each(function() {
        var schedule2 = set$2(this, id2), on = schedule2.on;
        if (on !== on0) {
          on1 = (on0 = on).copy();
          on1._.cancel.push(cancel);
          on1._.interrupt.push(cancel);
          on1._.end.push(end2);
        }
        schedule2.on = on1;
      });
      if (size2 === 0)
        resolve();
    });
  }
  var id$m = 0;
  function Transition(groups, parents2, name, id2) {
    this._groups = groups;
    this._parents = parents2;
    this._name = name;
    this._id = id2;
  }
  function newId() {
    return ++id$m;
  }
  var selection_prototype = selection.prototype;
  Transition.prototype = {
    constructor: Transition,
    select: transition_select,
    selectAll: transition_selectAll,
    selectChild: selection_prototype.selectChild,
    selectChildren: selection_prototype.selectChildren,
    filter: transition_filter,
    merge: transition_merge,
    selection: transition_selection,
    transition: transition_transition,
    call: selection_prototype.call,
    nodes: selection_prototype.nodes,
    node: selection_prototype.node,
    size: selection_prototype.size,
    empty: selection_prototype.empty,
    each: selection_prototype.each,
    on: transition_on,
    attr: transition_attr,
    attrTween: transition_attrTween,
    style: transition_style,
    styleTween: transition_styleTween,
    text: transition_text,
    textTween: transition_textTween,
    remove: transition_remove,
    tween: transition_tween,
    delay: transition_delay,
    duration: transition_duration,
    ease: transition_ease,
    easeVarying: transition_easeVarying,
    end: transition_end,
    [Symbol.iterator]: selection_prototype[Symbol.iterator]
  };
  function cubicInOut(t) {
    return ((t *= 2) <= 1 ? t * t * t : (t -= 2) * t * t + 2) / 2;
  }
  var defaultTiming = {
    time: null,
    // Set on use.
    delay: 0,
    duration: 250,
    ease: cubicInOut
  };
  function inherit(node2, id2) {
    var timing;
    while (!(timing = node2.__transition) || !(timing = timing[id2])) {
      if (!(node2 = node2.parentNode)) {
        throw new Error(`transition ${id2} not found`);
      }
    }
    return timing;
  }
  function selection_transition(name) {
    var id2, timing;
    if (name instanceof Transition) {
      id2 = name._id, name = name._name;
    } else {
      id2 = newId(), (timing = defaultTiming).time = now$2(), name = name == null ? null : name + "";
    }
    for (var groups = this._groups, m = groups.length, j = 0; j < m; ++j) {
      for (var group = groups[j], n = group.length, node2, i2 = 0; i2 < n; ++i2) {
        if (node2 = group[i2]) {
          schedule(node2, name, id2, i2, group, timing || inherit(node2, id2));
        }
      }
    }
    return new Transition(groups, this._parents, name, id2);
  }
  selection.prototype.interrupt = selection_interrupt;
  selection.prototype.transition = selection_transition;
  const pi$2 = Math.PI, tau$2 = 2 * pi$2, epsilon$2 = 1e-6, tauEpsilon$1 = tau$2 - epsilon$2;
  function append$1(strings) {
    this._ += strings[0];
    for (let i2 = 1, n = strings.length; i2 < n; ++i2) {
      this._ += arguments[i2] + strings[i2];
    }
  }
  function appendRound(digits) {
    let d = Math.floor(digits);
    if (!(d >= 0))
      throw new Error(`invalid digits: ${digits}`);
    if (d > 15)
      return append$1;
    const k = 10 ** d;
    return function(strings) {
      this._ += strings[0];
      for (let i2 = 1, n = strings.length; i2 < n; ++i2) {
        this._ += Math.round(arguments[i2] * k) / k + strings[i2];
      }
    };
  }
  let Path$1 = class Path {
    constructor(digits) {
      this._x0 = this._y0 = // start of current subpath
      this._x1 = this._y1 = null;
      this._ = "";
      this._append = digits == null ? append$1 : appendRound(digits);
    }
    moveTo(x2, y2) {
      this._append`M${this._x0 = this._x1 = +x2},${this._y0 = this._y1 = +y2}`;
    }
    closePath() {
      if (this._x1 !== null) {
        this._x1 = this._x0, this._y1 = this._y0;
        this._append`Z`;
      }
    }
    lineTo(x2, y2) {
      this._append`L${this._x1 = +x2},${this._y1 = +y2}`;
    }
    quadraticCurveTo(x1, y1, x2, y2) {
      this._append`Q${+x1},${+y1},${this._x1 = +x2},${this._y1 = +y2}`;
    }
    bezierCurveTo(x1, y1, x2, y2, x3, y3) {
      this._append`C${+x1},${+y1},${+x2},${+y2},${this._x1 = +x3},${this._y1 = +y3}`;
    }
    arcTo(x1, y1, x2, y2, r) {
      x1 = +x1, y1 = +y1, x2 = +x2, y2 = +y2, r = +r;
      if (r < 0)
        throw new Error(`negative radius: ${r}`);
      let x0 = this._x1, y0 = this._y1, x21 = x2 - x1, y21 = y2 - y1, x01 = x0 - x1, y01 = y0 - y1, l01_2 = x01 * x01 + y01 * y01;
      if (this._x1 === null) {
        this._append`M${this._x1 = x1},${this._y1 = y1}`;
      } else if (!(l01_2 > epsilon$2))
        ;
      else if (!(Math.abs(y01 * x21 - y21 * x01) > epsilon$2) || !r) {
        this._append`L${this._x1 = x1},${this._y1 = y1}`;
      } else {
        let x20 = x2 - x0, y20 = y2 - y0, l21_2 = x21 * x21 + y21 * y21, l20_2 = x20 * x20 + y20 * y20, l21 = Math.sqrt(l21_2), l01 = Math.sqrt(l01_2), l = r * Math.tan((pi$2 - Math.acos((l21_2 + l01_2 - l20_2) / (2 * l21 * l01))) / 2), t01 = l / l01, t21 = l / l21;
        if (Math.abs(t01 - 1) > epsilon$2) {
          this._append`L${x1 + t01 * x01},${y1 + t01 * y01}`;
        }
        this._append`A${r},${r},0,0,${+(y01 * x20 > x01 * y20)},${this._x1 = x1 + t21 * x21},${this._y1 = y1 + t21 * y21}`;
      }
    }
    arc(x2, y2, r, a0, a1, ccw) {
      x2 = +x2, y2 = +y2, r = +r, ccw = !!ccw;
      if (r < 0)
        throw new Error(`negative radius: ${r}`);
      let dx = r * Math.cos(a0), dy = r * Math.sin(a0), x0 = x2 + dx, y0 = y2 + dy, cw = 1 ^ ccw, da = ccw ? a0 - a1 : a1 - a0;
      if (this._x1 === null) {
        this._append`M${x0},${y0}`;
      } else if (Math.abs(this._x1 - x0) > epsilon$2 || Math.abs(this._y1 - y0) > epsilon$2) {
        this._append`L${x0},${y0}`;
      }
      if (!r)
        return;
      if (da < 0)
        da = da % tau$2 + tau$2;
      if (da > tauEpsilon$1) {
        this._append`A${r},${r},0,1,${cw},${x2 - dx},${y2 - dy}A${r},${r},0,1,${cw},${this._x1 = x0},${this._y1 = y0}`;
      } else if (da > epsilon$2) {
        this._append`A${r},${r},0,${+(da >= pi$2)},${cw},${this._x1 = x2 + r * Math.cos(a1)},${this._y1 = y2 + r * Math.sin(a1)}`;
      }
    }
    rect(x2, y2, w2, h) {
      this._append`M${this._x0 = this._x1 = +x2},${this._y0 = this._y1 = +y2}h${w2 = +w2}v${+h}h${-w2}Z`;
    }
    toString() {
      return this._;
    }
  };
  function responseText(response) {
    if (!response.ok)
      throw new Error(response.status + " " + response.statusText);
    return response.text();
  }
  function text$3(input, init2) {
    return fetch(input, init2).then(responseText);
  }
  function parser$x(type2) {
    return (input, init2) => text$3(input, init2).then((text2) => new DOMParser().parseFromString(text2, type2));
  }
  var svg$2 = parser$x("image/svg+xml");
  function formatDecimal(x2) {
    return Math.abs(x2 = Math.round(x2)) >= 1e21 ? x2.toLocaleString("en").replace(/,/g, "") : x2.toString(10);
  }
  function formatDecimalParts(x2, p) {
    if ((i2 = (x2 = p ? x2.toExponential(p - 1) : x2.toExponential()).indexOf("e")) < 0)
      return null;
    var i2, coefficient = x2.slice(0, i2);
    return [
      coefficient.length > 1 ? coefficient[0] + coefficient.slice(2) : coefficient,
      +x2.slice(i2 + 1)
    ];
  }
  function exponent(x2) {
    return x2 = formatDecimalParts(Math.abs(x2)), x2 ? x2[1] : NaN;
  }
  function formatGroup(grouping, thousands) {
    return function(value2, width2) {
      var i2 = value2.length, t = [], j = 0, g = grouping[0], length2 = 0;
      while (i2 > 0 && g > 0) {
        if (length2 + g + 1 > width2)
          g = Math.max(1, width2 - length2);
        t.push(value2.substring(i2 -= g, i2 + g));
        if ((length2 += g + 1) > width2)
          break;
        g = grouping[j = (j + 1) % grouping.length];
      }
      return t.reverse().join(thousands);
    };
  }
  function formatNumerals(numerals) {
    return function(value2) {
      return value2.replace(/[0-9]/g, function(i2) {
        return numerals[+i2];
      });
    };
  }
  var re = /^(?:(.)?([<>=^]))?([+\-( ])?([$#])?(0)?(\d+)?(,)?(\.\d+)?(~)?([a-z%])?$/i;
  function formatSpecifier(specifier) {
    if (!(match = re.exec(specifier)))
      throw new Error("invalid format: " + specifier);
    var match;
    return new FormatSpecifier({
      fill: match[1],
      align: match[2],
      sign: match[3],
      symbol: match[4],
      zero: match[5],
      width: match[6],
      comma: match[7],
      precision: match[8] && match[8].slice(1),
      trim: match[9],
      type: match[10]
    });
  }
  formatSpecifier.prototype = FormatSpecifier.prototype;
  function FormatSpecifier(specifier) {
    this.fill = specifier.fill === void 0 ? " " : specifier.fill + "";
    this.align = specifier.align === void 0 ? ">" : specifier.align + "";
    this.sign = specifier.sign === void 0 ? "-" : specifier.sign + "";
    this.symbol = specifier.symbol === void 0 ? "" : specifier.symbol + "";
    this.zero = !!specifier.zero;
    this.width = specifier.width === void 0 ? void 0 : +specifier.width;
    this.comma = !!specifier.comma;
    this.precision = specifier.precision === void 0 ? void 0 : +specifier.precision;
    this.trim = !!specifier.trim;
    this.type = specifier.type === void 0 ? "" : specifier.type + "";
  }
  FormatSpecifier.prototype.toString = function() {
    return this.fill + this.align + this.sign + this.symbol + (this.zero ? "0" : "") + (this.width === void 0 ? "" : Math.max(1, this.width | 0)) + (this.comma ? "," : "") + (this.precision === void 0 ? "" : "." + Math.max(0, this.precision | 0)) + (this.trim ? "~" : "") + this.type;
  };
  function formatTrim(s) {
    out:
      for (var n = s.length, i2 = 1, i0 = -1, i1; i2 < n; ++i2) {
        switch (s[i2]) {
          case ".":
            i0 = i1 = i2;
            break;
          case "0":
            if (i0 === 0)
              i0 = i2;
            i1 = i2;
            break;
          default:
            if (!+s[i2])
              break out;
            if (i0 > 0)
              i0 = 0;
            break;
        }
      }
    return i0 > 0 ? s.slice(0, i0) + s.slice(i1 + 1) : s;
  }
  var prefixExponent;
  function formatPrefixAuto(x2, p) {
    var d = formatDecimalParts(x2, p);
    if (!d)
      return x2 + "";
    var coefficient = d[0], exponent2 = d[1], i2 = exponent2 - (prefixExponent = Math.max(-8, Math.min(8, Math.floor(exponent2 / 3))) * 3) + 1, n = coefficient.length;
    return i2 === n ? coefficient : i2 > n ? coefficient + new Array(i2 - n + 1).join("0") : i2 > 0 ? coefficient.slice(0, i2) + "." + coefficient.slice(i2) : "0." + new Array(1 - i2).join("0") + formatDecimalParts(x2, Math.max(0, p + i2 - 1))[0];
  }
  function formatRounded(x2, p) {
    var d = formatDecimalParts(x2, p);
    if (!d)
      return x2 + "";
    var coefficient = d[0], exponent2 = d[1];
    return exponent2 < 0 ? "0." + new Array(-exponent2).join("0") + coefficient : coefficient.length > exponent2 + 1 ? coefficient.slice(0, exponent2 + 1) + "." + coefficient.slice(exponent2 + 1) : coefficient + new Array(exponent2 - coefficient.length + 2).join("0");
  }
  const formatTypes = {
    "%": (x2, p) => (x2 * 100).toFixed(p),
    "b": (x2) => Math.round(x2).toString(2),
    "c": (x2) => x2 + "",
    "d": formatDecimal,
    "e": (x2, p) => x2.toExponential(p),
    "f": (x2, p) => x2.toFixed(p),
    "g": (x2, p) => x2.toPrecision(p),
    "o": (x2) => Math.round(x2).toString(8),
    "p": (x2, p) => formatRounded(x2 * 100, p),
    "r": formatRounded,
    "s": formatPrefixAuto,
    "X": (x2) => Math.round(x2).toString(16).toUpperCase(),
    "x": (x2) => Math.round(x2).toString(16)
  };
  function identity$3(x2) {
    return x2;
  }
  var map$2 = Array.prototype.map, prefixes = ["y", "z", "a", "f", "p", "n", "µ", "m", "", "k", "M", "G", "T", "P", "E", "Z", "Y"];
  function formatLocale$1(locale2) {
    var group = locale2.grouping === void 0 || locale2.thousands === void 0 ? identity$3 : formatGroup(map$2.call(locale2.grouping, Number), locale2.thousands + ""), currencyPrefix = locale2.currency === void 0 ? "" : locale2.currency[0] + "", currencySuffix = locale2.currency === void 0 ? "" : locale2.currency[1] + "", decimal = locale2.decimal === void 0 ? "." : locale2.decimal + "", numerals = locale2.numerals === void 0 ? identity$3 : formatNumerals(map$2.call(locale2.numerals, String)), percent = locale2.percent === void 0 ? "%" : locale2.percent + "", minus = locale2.minus === void 0 ? "−" : locale2.minus + "", nan = locale2.nan === void 0 ? "NaN" : locale2.nan + "";
    function newFormat(specifier) {
      specifier = formatSpecifier(specifier);
      var fill = specifier.fill, align = specifier.align, sign2 = specifier.sign, symbol = specifier.symbol, zero2 = specifier.zero, width2 = specifier.width, comma = specifier.comma, precision = specifier.precision, trim2 = specifier.trim, type2 = specifier.type;
      if (type2 === "n")
        comma = true, type2 = "g";
      else if (!formatTypes[type2])
        precision === void 0 && (precision = 12), trim2 = true, type2 = "g";
      if (zero2 || fill === "0" && align === "=")
        zero2 = true, fill = "0", align = "=";
      var prefix = symbol === "$" ? currencyPrefix : symbol === "#" && /[boxX]/.test(type2) ? "0" + type2.toLowerCase() : "", suffix = symbol === "$" ? currencySuffix : /[%p]/.test(type2) ? percent : "";
      var formatType = formatTypes[type2], maybeSuffix = /[defgprs%]/.test(type2);
      precision = precision === void 0 ? 6 : /[gprs]/.test(type2) ? Math.max(1, Math.min(21, precision)) : Math.max(0, Math.min(20, precision));
      function format2(value2) {
        var valuePrefix = prefix, valueSuffix = suffix, i2, n, c2;
        if (type2 === "c") {
          valueSuffix = formatType(value2) + valueSuffix;
          value2 = "";
        } else {
          value2 = +value2;
          var valueNegative = value2 < 0 || 1 / value2 < 0;
          value2 = isNaN(value2) ? nan : formatType(Math.abs(value2), precision);
          if (trim2)
            value2 = formatTrim(value2);
          if (valueNegative && +value2 === 0 && sign2 !== "+")
            valueNegative = false;
          valuePrefix = (valueNegative ? sign2 === "(" ? sign2 : minus : sign2 === "-" || sign2 === "(" ? "" : sign2) + valuePrefix;
          valueSuffix = (type2 === "s" ? prefixes[8 + prefixExponent / 3] : "") + valueSuffix + (valueNegative && sign2 === "(" ? ")" : "");
          if (maybeSuffix) {
            i2 = -1, n = value2.length;
            while (++i2 < n) {
              if (c2 = value2.charCodeAt(i2), 48 > c2 || c2 > 57) {
                valueSuffix = (c2 === 46 ? decimal + value2.slice(i2 + 1) : value2.slice(i2)) + valueSuffix;
                value2 = value2.slice(0, i2);
                break;
              }
            }
          }
        }
        if (comma && !zero2)
          value2 = group(value2, Infinity);
        var length2 = valuePrefix.length + value2.length + valueSuffix.length, padding2 = length2 < width2 ? new Array(width2 - length2 + 1).join(fill) : "";
        if (comma && zero2)
          value2 = group(padding2 + value2, padding2.length ? width2 - valueSuffix.length : Infinity), padding2 = "";
        switch (align) {
          case "<":
            value2 = valuePrefix + value2 + valueSuffix + padding2;
            break;
          case "=":
            value2 = valuePrefix + padding2 + value2 + valueSuffix;
            break;
          case "^":
            value2 = padding2.slice(0, length2 = padding2.length >> 1) + valuePrefix + value2 + valueSuffix + padding2.slice(length2);
            break;
          default:
            value2 = padding2 + valuePrefix + value2 + valueSuffix;
            break;
        }
        return numerals(value2);
      }
      format2.toString = function() {
        return specifier + "";
      };
      return format2;
    }
    function formatPrefix2(specifier, value2) {
      var f2 = newFormat((specifier = formatSpecifier(specifier), specifier.type = "f", specifier)), e = Math.max(-8, Math.min(8, Math.floor(exponent(value2) / 3))) * 3, k = Math.pow(10, -e), prefix = prefixes[8 + e / 3];
      return function(value3) {
        return f2(k * value3) + prefix;
      };
    }
    return {
      format: newFormat,
      formatPrefix: formatPrefix2
    };
  }
  var locale$1;
  var format;
  var formatPrefix;
  defaultLocale$1({
    thousands: ",",
    grouping: [3],
    currency: ["$", ""]
  });
  function defaultLocale$1(definition2) {
    locale$1 = formatLocale$1(definition2);
    format = locale$1.format;
    formatPrefix = locale$1.formatPrefix;
    return locale$1;
  }
  function precisionFixed(step) {
    return Math.max(0, -exponent(Math.abs(step)));
  }
  function precisionPrefix(step, value2) {
    return Math.max(0, Math.max(-8, Math.min(8, Math.floor(exponent(value2) / 3))) * 3 - exponent(Math.abs(step)));
  }
  function precisionRound(step, max2) {
    step = Math.abs(step), max2 = Math.abs(max2) - step;
    return Math.max(0, exponent(max2) - exponent(step)) + 1;
  }
  function initRange(domain, range2) {
    switch (arguments.length) {
      case 0:
        break;
      case 1:
        this.range(domain);
        break;
      default:
        this.range(range2).domain(domain);
        break;
    }
    return this;
  }
  const implicit = Symbol("implicit");
  function ordinal() {
    var index2 = new InternMap(), domain = [], range2 = [], unknown = implicit;
    function scale(d) {
      let i2 = index2.get(d);
      if (i2 === void 0) {
        if (unknown !== implicit)
          return unknown;
        index2.set(d, i2 = domain.push(d) - 1);
      }
      return range2[i2 % range2.length];
    }
    scale.domain = function(_2) {
      if (!arguments.length)
        return domain.slice();
      domain = [], index2 = new InternMap();
      for (const value2 of _2) {
        if (index2.has(value2))
          continue;
        index2.set(value2, domain.push(value2) - 1);
      }
      return scale;
    };
    scale.range = function(_2) {
      return arguments.length ? (range2 = Array.from(_2), scale) : range2.slice();
    };
    scale.unknown = function(_2) {
      return arguments.length ? (unknown = _2, scale) : unknown;
    };
    scale.copy = function() {
      return ordinal(domain, range2).unknown(unknown);
    };
    initRange.apply(scale, arguments);
    return scale;
  }
  function band() {
    var scale = ordinal().unknown(void 0), domain = scale.domain, ordinalRange = scale.range, r0 = 0, r1 = 1, step, bandwidth, round = false, paddingInner = 0, paddingOuter = 0, align = 0.5;
    delete scale.unknown;
    function rescale() {
      var n = domain().length, reverse = r1 < r0, start2 = reverse ? r1 : r0, stop = reverse ? r0 : r1;
      step = (stop - start2) / Math.max(1, n - paddingInner + paddingOuter * 2);
      if (round)
        step = Math.floor(step);
      start2 += (stop - start2 - step * (n - paddingInner)) * align;
      bandwidth = step * (1 - paddingInner);
      if (round)
        start2 = Math.round(start2), bandwidth = Math.round(bandwidth);
      var values2 = range$2(n).map(function(i2) {
        return start2 + step * i2;
      });
      return ordinalRange(reverse ? values2.reverse() : values2);
    }
    scale.domain = function(_2) {
      return arguments.length ? (domain(_2), rescale()) : domain();
    };
    scale.range = function(_2) {
      return arguments.length ? ([r0, r1] = _2, r0 = +r0, r1 = +r1, rescale()) : [r0, r1];
    };
    scale.rangeRound = function(_2) {
      return [r0, r1] = _2, r0 = +r0, r1 = +r1, round = true, rescale();
    };
    scale.bandwidth = function() {
      return bandwidth;
    };
    scale.step = function() {
      return step;
    };
    scale.round = function(_2) {
      return arguments.length ? (round = !!_2, rescale()) : round;
    };
    scale.padding = function(_2) {
      return arguments.length ? (paddingInner = Math.min(1, paddingOuter = +_2), rescale()) : paddingInner;
    };
    scale.paddingInner = function(_2) {
      return arguments.length ? (paddingInner = Math.min(1, _2), rescale()) : paddingInner;
    };
    scale.paddingOuter = function(_2) {
      return arguments.length ? (paddingOuter = +_2, rescale()) : paddingOuter;
    };
    scale.align = function(_2) {
      return arguments.length ? (align = Math.max(0, Math.min(1, _2)), rescale()) : align;
    };
    scale.copy = function() {
      return band(domain(), [r0, r1]).round(round).paddingInner(paddingInner).paddingOuter(paddingOuter).align(align);
    };
    return initRange.apply(rescale(), arguments);
  }
  function constants(x2) {
    return function() {
      return x2;
    };
  }
  function number$1(x2) {
    return +x2;
  }
  var unit$1 = [0, 1];
  function identity$2(x2) {
    return x2;
  }
  function normalize(a, b) {
    return (b -= a = +a) ? function(x2) {
      return (x2 - a) / b;
    } : constants(isNaN(b) ? NaN : 0.5);
  }
  function clamper(a, b) {
    var t;
    if (a > b)
      t = a, a = b, b = t;
    return function(x2) {
      return Math.max(a, Math.min(b, x2));
    };
  }
  function bimap(domain, range2, interpolate2) {
    var d0 = domain[0], d1 = domain[1], r0 = range2[0], r1 = range2[1];
    if (d1 < d0)
      d0 = normalize(d1, d0), r0 = interpolate2(r1, r0);
    else
      d0 = normalize(d0, d1), r0 = interpolate2(r0, r1);
    return function(x2) {
      return r0(d0(x2));
    };
  }
  function polymap(domain, range2, interpolate2) {
    var j = Math.min(domain.length, range2.length) - 1, d = new Array(j), r = new Array(j), i2 = -1;
    if (domain[j] < domain[0]) {
      domain = domain.slice().reverse();
      range2 = range2.slice().reverse();
    }
    while (++i2 < j) {
      d[i2] = normalize(domain[i2], domain[i2 + 1]);
      r[i2] = interpolate2(range2[i2], range2[i2 + 1]);
    }
    return function(x2) {
      var i3 = bisect(domain, x2, 1, j) - 1;
      return r[i3](d[i3](x2));
    };
  }
  function copy$1(source, target) {
    return target.domain(source.domain()).range(source.range()).interpolate(source.interpolate()).clamp(source.clamp()).unknown(source.unknown());
  }
  function transformer() {
    var domain = unit$1, range2 = unit$1, interpolate2 = interpolate$1, transform, untransform, unknown, clamp = identity$2, piecewise, output, input;
    function rescale() {
      var n = Math.min(domain.length, range2.length);
      if (clamp !== identity$2)
        clamp = clamper(domain[0], domain[n - 1]);
      piecewise = n > 2 ? polymap : bimap;
      output = input = null;
      return scale;
    }
    function scale(x2) {
      return x2 == null || isNaN(x2 = +x2) ? unknown : (output || (output = piecewise(domain.map(transform), range2, interpolate2)))(transform(clamp(x2)));
    }
    scale.invert = function(y2) {
      return clamp(untransform((input || (input = piecewise(range2, domain.map(transform), interpolateNumber)))(y2)));
    };
    scale.domain = function(_2) {
      return arguments.length ? (domain = Array.from(_2, number$1), rescale()) : domain.slice();
    };
    scale.range = function(_2) {
      return arguments.length ? (range2 = Array.from(_2), rescale()) : range2.slice();
    };
    scale.rangeRound = function(_2) {
      return range2 = Array.from(_2), interpolate2 = interpolateRound, rescale();
    };
    scale.clamp = function(_2) {
      return arguments.length ? (clamp = _2 ? true : identity$2, rescale()) : clamp !== identity$2;
    };
    scale.interpolate = function(_2) {
      return arguments.length ? (interpolate2 = _2, rescale()) : interpolate2;
    };
    scale.unknown = function(_2) {
      return arguments.length ? (unknown = _2, scale) : unknown;
    };
    return function(t, u) {
      transform = t, untransform = u;
      return rescale();
    };
  }
  function continuous() {
    return transformer()(identity$2, identity$2);
  }
  function tickFormat(start2, stop, count, specifier) {
    var step = tickStep(start2, stop, count), precision;
    specifier = formatSpecifier(specifier == null ? ",f" : specifier);
    switch (specifier.type) {
      case "s": {
        var value2 = Math.max(Math.abs(start2), Math.abs(stop));
        if (specifier.precision == null && !isNaN(precision = precisionPrefix(step, value2)))
          specifier.precision = precision;
        return formatPrefix(specifier, value2);
      }
      case "":
      case "e":
      case "g":
      case "p":
      case "r": {
        if (specifier.precision == null && !isNaN(precision = precisionRound(step, Math.max(Math.abs(start2), Math.abs(stop)))))
          specifier.precision = precision - (specifier.type === "e");
        break;
      }
      case "f":
      case "%": {
        if (specifier.precision == null && !isNaN(precision = precisionFixed(step)))
          specifier.precision = precision - (specifier.type === "%") * 2;
        break;
      }
    }
    return format(specifier);
  }
  function linearish(scale) {
    var domain = scale.domain;
    scale.ticks = function(count) {
      var d = domain();
      return ticks(d[0], d[d.length - 1], count == null ? 10 : count);
    };
    scale.tickFormat = function(count, specifier) {
      var d = domain();
      return tickFormat(d[0], d[d.length - 1], count == null ? 10 : count, specifier);
    };
    scale.nice = function(count) {
      if (count == null)
        count = 10;
      var d = domain();
      var i0 = 0;
      var i1 = d.length - 1;
      var start2 = d[i0];
      var stop = d[i1];
      var prestep;
      var step;
      var maxIter = 10;
      if (stop < start2) {
        step = start2, start2 = stop, stop = step;
        step = i0, i0 = i1, i1 = step;
      }
      while (maxIter-- > 0) {
        step = tickIncrement(start2, stop, count);
        if (step === prestep) {
          d[i0] = start2;
          d[i1] = stop;
          return domain(d);
        } else if (step > 0) {
          start2 = Math.floor(start2 / step) * step;
          stop = Math.ceil(stop / step) * step;
        } else if (step < 0) {
          start2 = Math.ceil(start2 * step) / step;
          stop = Math.floor(stop * step) / step;
        } else {
          break;
        }
        prestep = step;
      }
      return scale;
    };
    return scale;
  }
  function linear() {
    var scale = continuous();
    scale.copy = function() {
      return copy$1(scale, linear());
    };
    initRange.apply(scale, arguments);
    return linearish(scale);
  }
  function nice(domain, interval2) {
    domain = domain.slice();
    var i0 = 0, i1 = domain.length - 1, x0 = domain[i0], x1 = domain[i1], t;
    if (x1 < x0) {
      t = i0, i0 = i1, i1 = t;
      t = x0, x0 = x1, x1 = t;
    }
    domain[i0] = interval2.floor(x0);
    domain[i1] = interval2.ceil(x1);
    return domain;
  }
  const t0 = /* @__PURE__ */ new Date(), t1 = /* @__PURE__ */ new Date();
  function timeInterval(floori, offseti, count, field) {
    function interval2(date2) {
      return floori(date2 = arguments.length === 0 ? /* @__PURE__ */ new Date() : /* @__PURE__ */ new Date(+date2)), date2;
    }
    interval2.floor = (date2) => {
      return floori(date2 = /* @__PURE__ */ new Date(+date2)), date2;
    };
    interval2.ceil = (date2) => {
      return floori(date2 = new Date(date2 - 1)), offseti(date2, 1), floori(date2), date2;
    };
    interval2.round = (date2) => {
      const d0 = interval2(date2), d1 = interval2.ceil(date2);
      return date2 - d0 < d1 - date2 ? d0 : d1;
    };
    interval2.offset = (date2, step) => {
      return offseti(date2 = /* @__PURE__ */ new Date(+date2), step == null ? 1 : Math.floor(step)), date2;
    };
    interval2.range = (start2, stop, step) => {
      const range2 = [];
      start2 = interval2.ceil(start2);
      step = step == null ? 1 : Math.floor(step);
      if (!(start2 < stop) || !(step > 0))
        return range2;
      let previous2;
      do
        range2.push(previous2 = /* @__PURE__ */ new Date(+start2)), offseti(start2, step), floori(start2);
      while (previous2 < start2 && start2 < stop);
      return range2;
    };
    interval2.filter = (test) => {
      return timeInterval((date2) => {
        if (date2 >= date2)
          while (floori(date2), !test(date2))
            date2.setTime(date2 - 1);
      }, (date2, step) => {
        if (date2 >= date2) {
          if (step < 0)
            while (++step <= 0) {
              while (offseti(date2, -1), !test(date2)) {
              }
            }
          else
            while (--step >= 0) {
              while (offseti(date2, 1), !test(date2)) {
              }
            }
        }
      });
    };
    if (count) {
      interval2.count = (start2, end2) => {
        t0.setTime(+start2), t1.setTime(+end2);
        floori(t0), floori(t1);
        return Math.floor(count(t0, t1));
      };
      interval2.every = (step) => {
        step = Math.floor(step);
        return !isFinite(step) || !(step > 0) ? null : !(step > 1) ? interval2 : interval2.filter(field ? (d) => field(d) % step === 0 : (d) => interval2.count(0, d) % step === 0);
      };
    }
    return interval2;
  }
  const millisecond = timeInterval(() => {
  }, (date2, step) => {
    date2.setTime(+date2 + step);
  }, (start2, end2) => {
    return end2 - start2;
  });
  millisecond.every = (k) => {
    k = Math.floor(k);
    if (!isFinite(k) || !(k > 0))
      return null;
    if (!(k > 1))
      return millisecond;
    return timeInterval((date2) => {
      date2.setTime(Math.floor(date2 / k) * k);
    }, (date2, step) => {
      date2.setTime(+date2 + step * k);
    }, (start2, end2) => {
      return (end2 - start2) / k;
    });
  };
  millisecond.range;
  const durationSecond = 1e3;
  const durationMinute = durationSecond * 60;
  const durationHour = durationMinute * 60;
  const durationDay = durationHour * 24;
  const durationWeek = durationDay * 7;
  const durationMonth = durationDay * 30;
  const durationYear = durationDay * 365;
  const second = timeInterval((date2) => {
    date2.setTime(date2 - date2.getMilliseconds());
  }, (date2, step) => {
    date2.setTime(+date2 + step * durationSecond);
  }, (start2, end2) => {
    return (end2 - start2) / durationSecond;
  }, (date2) => {
    return date2.getUTCSeconds();
  });
  second.range;
  const timeMinute = timeInterval((date2) => {
    date2.setTime(date2 - date2.getMilliseconds() - date2.getSeconds() * durationSecond);
  }, (date2, step) => {
    date2.setTime(+date2 + step * durationMinute);
  }, (start2, end2) => {
    return (end2 - start2) / durationMinute;
  }, (date2) => {
    return date2.getMinutes();
  });
  timeMinute.range;
  const utcMinute = timeInterval((date2) => {
    date2.setUTCSeconds(0, 0);
  }, (date2, step) => {
    date2.setTime(+date2 + step * durationMinute);
  }, (start2, end2) => {
    return (end2 - start2) / durationMinute;
  }, (date2) => {
    return date2.getUTCMinutes();
  });
  utcMinute.range;
  const timeHour = timeInterval((date2) => {
    date2.setTime(date2 - date2.getMilliseconds() - date2.getSeconds() * durationSecond - date2.getMinutes() * durationMinute);
  }, (date2, step) => {
    date2.setTime(+date2 + step * durationHour);
  }, (start2, end2) => {
    return (end2 - start2) / durationHour;
  }, (date2) => {
    return date2.getHours();
  });
  timeHour.range;
  const utcHour = timeInterval((date2) => {
    date2.setUTCMinutes(0, 0, 0);
  }, (date2, step) => {
    date2.setTime(+date2 + step * durationHour);
  }, (start2, end2) => {
    return (end2 - start2) / durationHour;
  }, (date2) => {
    return date2.getUTCHours();
  });
  utcHour.range;
  const timeDay = timeInterval(
    (date2) => date2.setHours(0, 0, 0, 0),
    (date2, step) => date2.setDate(date2.getDate() + step),
    (start2, end2) => (end2 - start2 - (end2.getTimezoneOffset() - start2.getTimezoneOffset()) * durationMinute) / durationDay,
    (date2) => date2.getDate() - 1
  );
  timeDay.range;
  const utcDay = timeInterval((date2) => {
    date2.setUTCHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setUTCDate(date2.getUTCDate() + step);
  }, (start2, end2) => {
    return (end2 - start2) / durationDay;
  }, (date2) => {
    return date2.getUTCDate() - 1;
  });
  utcDay.range;
  const unixDay = timeInterval((date2) => {
    date2.setUTCHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setUTCDate(date2.getUTCDate() + step);
  }, (start2, end2) => {
    return (end2 - start2) / durationDay;
  }, (date2) => {
    return Math.floor(date2 / durationDay);
  });
  unixDay.range;
  function timeWeekday(i2) {
    return timeInterval((date2) => {
      date2.setDate(date2.getDate() - (date2.getDay() + 7 - i2) % 7);
      date2.setHours(0, 0, 0, 0);
    }, (date2, step) => {
      date2.setDate(date2.getDate() + step * 7);
    }, (start2, end2) => {
      return (end2 - start2 - (end2.getTimezoneOffset() - start2.getTimezoneOffset()) * durationMinute) / durationWeek;
    });
  }
  const timeSunday = timeWeekday(0);
  const timeMonday = timeWeekday(1);
  const timeTuesday = timeWeekday(2);
  const timeWednesday = timeWeekday(3);
  const timeThursday = timeWeekday(4);
  const timeFriday = timeWeekday(5);
  const timeSaturday = timeWeekday(6);
  timeSunday.range;
  timeMonday.range;
  timeTuesday.range;
  timeWednesday.range;
  timeThursday.range;
  timeFriday.range;
  timeSaturday.range;
  function utcWeekday(i2) {
    return timeInterval((date2) => {
      date2.setUTCDate(date2.getUTCDate() - (date2.getUTCDay() + 7 - i2) % 7);
      date2.setUTCHours(0, 0, 0, 0);
    }, (date2, step) => {
      date2.setUTCDate(date2.getUTCDate() + step * 7);
    }, (start2, end2) => {
      return (end2 - start2) / durationWeek;
    });
  }
  const utcSunday = utcWeekday(0);
  const utcMonday = utcWeekday(1);
  const utcTuesday = utcWeekday(2);
  const utcWednesday = utcWeekday(3);
  const utcThursday = utcWeekday(4);
  const utcFriday = utcWeekday(5);
  const utcSaturday = utcWeekday(6);
  utcSunday.range;
  utcMonday.range;
  utcTuesday.range;
  utcWednesday.range;
  utcThursday.range;
  utcFriday.range;
  utcSaturday.range;
  const timeMonth = timeInterval((date2) => {
    date2.setDate(1);
    date2.setHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setMonth(date2.getMonth() + step);
  }, (start2, end2) => {
    return end2.getMonth() - start2.getMonth() + (end2.getFullYear() - start2.getFullYear()) * 12;
  }, (date2) => {
    return date2.getMonth();
  });
  timeMonth.range;
  const utcMonth = timeInterval((date2) => {
    date2.setUTCDate(1);
    date2.setUTCHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setUTCMonth(date2.getUTCMonth() + step);
  }, (start2, end2) => {
    return end2.getUTCMonth() - start2.getUTCMonth() + (end2.getUTCFullYear() - start2.getUTCFullYear()) * 12;
  }, (date2) => {
    return date2.getUTCMonth();
  });
  utcMonth.range;
  const timeYear = timeInterval((date2) => {
    date2.setMonth(0, 1);
    date2.setHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setFullYear(date2.getFullYear() + step);
  }, (start2, end2) => {
    return end2.getFullYear() - start2.getFullYear();
  }, (date2) => {
    return date2.getFullYear();
  });
  timeYear.every = (k) => {
    return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : timeInterval((date2) => {
      date2.setFullYear(Math.floor(date2.getFullYear() / k) * k);
      date2.setMonth(0, 1);
      date2.setHours(0, 0, 0, 0);
    }, (date2, step) => {
      date2.setFullYear(date2.getFullYear() + step * k);
    });
  };
  timeYear.range;
  const utcYear = timeInterval((date2) => {
    date2.setUTCMonth(0, 1);
    date2.setUTCHours(0, 0, 0, 0);
  }, (date2, step) => {
    date2.setUTCFullYear(date2.getUTCFullYear() + step);
  }, (start2, end2) => {
    return end2.getUTCFullYear() - start2.getUTCFullYear();
  }, (date2) => {
    return date2.getUTCFullYear();
  });
  utcYear.every = (k) => {
    return !isFinite(k = Math.floor(k)) || !(k > 0) ? null : timeInterval((date2) => {
      date2.setUTCFullYear(Math.floor(date2.getUTCFullYear() / k) * k);
      date2.setUTCMonth(0, 1);
      date2.setUTCHours(0, 0, 0, 0);
    }, (date2, step) => {
      date2.setUTCFullYear(date2.getUTCFullYear() + step * k);
    });
  };
  utcYear.range;
  function ticker(year, month, week, day, hour, minute) {
    const tickIntervals = [
      [second, 1, durationSecond],
      [second, 5, 5 * durationSecond],
      [second, 15, 15 * durationSecond],
      [second, 30, 30 * durationSecond],
      [minute, 1, durationMinute],
      [minute, 5, 5 * durationMinute],
      [minute, 15, 15 * durationMinute],
      [minute, 30, 30 * durationMinute],
      [hour, 1, durationHour],
      [hour, 3, 3 * durationHour],
      [hour, 6, 6 * durationHour],
      [hour, 12, 12 * durationHour],
      [day, 1, durationDay],
      [day, 2, 2 * durationDay],
      [week, 1, durationWeek],
      [month, 1, durationMonth],
      [month, 3, 3 * durationMonth],
      [year, 1, durationYear]
    ];
    function ticks2(start2, stop, count) {
      const reverse = stop < start2;
      if (reverse)
        [start2, stop] = [stop, start2];
      const interval2 = count && typeof count.range === "function" ? count : tickInterval2(start2, stop, count);
      const ticks3 = interval2 ? interval2.range(start2, +stop + 1) : [];
      return reverse ? ticks3.reverse() : ticks3;
    }
    function tickInterval2(start2, stop, count) {
      const target = Math.abs(stop - start2) / count;
      const i2 = bisector(([, , step2]) => step2).right(tickIntervals, target);
      if (i2 === tickIntervals.length)
        return year.every(tickStep(start2 / durationYear, stop / durationYear, count));
      if (i2 === 0)
        return millisecond.every(Math.max(tickStep(start2, stop, count), 1));
      const [t, step] = tickIntervals[target / tickIntervals[i2 - 1][2] < tickIntervals[i2][2] / target ? i2 - 1 : i2];
      return t.every(step);
    }
    return [ticks2, tickInterval2];
  }
  const [timeTicks, timeTickInterval] = ticker(timeYear, timeMonth, timeSunday, timeDay, timeHour, timeMinute);
  function localDate(d) {
    if (0 <= d.y && d.y < 100) {
      var date2 = new Date(-1, d.m, d.d, d.H, d.M, d.S, d.L);
      date2.setFullYear(d.y);
      return date2;
    }
    return new Date(d.y, d.m, d.d, d.H, d.M, d.S, d.L);
  }
  function utcDate(d) {
    if (0 <= d.y && d.y < 100) {
      var date2 = new Date(Date.UTC(-1, d.m, d.d, d.H, d.M, d.S, d.L));
      date2.setUTCFullYear(d.y);
      return date2;
    }
    return new Date(Date.UTC(d.y, d.m, d.d, d.H, d.M, d.S, d.L));
  }
  function newDate(y2, m, d) {
    return { y: y2, m, d, H: 0, M: 0, S: 0, L: 0 };
  }
  function formatLocale(locale2) {
    var locale_dateTime = locale2.dateTime, locale_date = locale2.date, locale_time = locale2.time, locale_periods = locale2.periods, locale_weekdays = locale2.days, locale_shortWeekdays = locale2.shortDays, locale_months = locale2.months, locale_shortMonths = locale2.shortMonths;
    var periodRe = formatRe(locale_periods), periodLookup = formatLookup(locale_periods), weekdayRe = formatRe(locale_weekdays), weekdayLookup = formatLookup(locale_weekdays), shortWeekdayRe = formatRe(locale_shortWeekdays), shortWeekdayLookup = formatLookup(locale_shortWeekdays), monthRe = formatRe(locale_months), monthLookup = formatLookup(locale_months), shortMonthRe = formatRe(locale_shortMonths), shortMonthLookup = formatLookup(locale_shortMonths);
    var formats = {
      "a": formatShortWeekday,
      "A": formatWeekday,
      "b": formatShortMonth,
      "B": formatMonth,
      "c": null,
      "d": formatDayOfMonth,
      "e": formatDayOfMonth,
      "f": formatMicroseconds,
      "g": formatYearISO,
      "G": formatFullYearISO,
      "H": formatHour24,
      "I": formatHour12,
      "j": formatDayOfYear,
      "L": formatMilliseconds,
      "m": formatMonthNumber,
      "M": formatMinutes,
      "p": formatPeriod,
      "q": formatQuarter,
      "Q": formatUnixTimestamp,
      "s": formatUnixTimestampSeconds,
      "S": formatSeconds,
      "u": formatWeekdayNumberMonday,
      "U": formatWeekNumberSunday,
      "V": formatWeekNumberISO,
      "w": formatWeekdayNumberSunday,
      "W": formatWeekNumberMonday,
      "x": null,
      "X": null,
      "y": formatYear,
      "Y": formatFullYear,
      "Z": formatZone,
      "%": formatLiteralPercent
    };
    var utcFormats = {
      "a": formatUTCShortWeekday,
      "A": formatUTCWeekday,
      "b": formatUTCShortMonth,
      "B": formatUTCMonth,
      "c": null,
      "d": formatUTCDayOfMonth,
      "e": formatUTCDayOfMonth,
      "f": formatUTCMicroseconds,
      "g": formatUTCYearISO,
      "G": formatUTCFullYearISO,
      "H": formatUTCHour24,
      "I": formatUTCHour12,
      "j": formatUTCDayOfYear,
      "L": formatUTCMilliseconds,
      "m": formatUTCMonthNumber,
      "M": formatUTCMinutes,
      "p": formatUTCPeriod,
      "q": formatUTCQuarter,
      "Q": formatUnixTimestamp,
      "s": formatUnixTimestampSeconds,
      "S": formatUTCSeconds,
      "u": formatUTCWeekdayNumberMonday,
      "U": formatUTCWeekNumberSunday,
      "V": formatUTCWeekNumberISO,
      "w": formatUTCWeekdayNumberSunday,
      "W": formatUTCWeekNumberMonday,
      "x": null,
      "X": null,
      "y": formatUTCYear,
      "Y": formatUTCFullYear,
      "Z": formatUTCZone,
      "%": formatLiteralPercent
    };
    var parses = {
      "a": parseShortWeekday,
      "A": parseWeekday,
      "b": parseShortMonth,
      "B": parseMonth,
      "c": parseLocaleDateTime,
      "d": parseDayOfMonth,
      "e": parseDayOfMonth,
      "f": parseMicroseconds,
      "g": parseYear,
      "G": parseFullYear,
      "H": parseHour24,
      "I": parseHour24,
      "j": parseDayOfYear,
      "L": parseMilliseconds,
      "m": parseMonthNumber,
      "M": parseMinutes,
      "p": parsePeriod,
      "q": parseQuarter,
      "Q": parseUnixTimestamp,
      "s": parseUnixTimestampSeconds,
      "S": parseSeconds,
      "u": parseWeekdayNumberMonday,
      "U": parseWeekNumberSunday,
      "V": parseWeekNumberISO,
      "w": parseWeekdayNumberSunday,
      "W": parseWeekNumberMonday,
      "x": parseLocaleDate,
      "X": parseLocaleTime,
      "y": parseYear,
      "Y": parseFullYear,
      "Z": parseZone,
      "%": parseLiteralPercent
    };
    formats.x = newFormat(locale_date, formats);
    formats.X = newFormat(locale_time, formats);
    formats.c = newFormat(locale_dateTime, formats);
    utcFormats.x = newFormat(locale_date, utcFormats);
    utcFormats.X = newFormat(locale_time, utcFormats);
    utcFormats.c = newFormat(locale_dateTime, utcFormats);
    function newFormat(specifier, formats2) {
      return function(date2) {
        var string2 = [], i2 = -1, j = 0, n = specifier.length, c2, pad2, format2;
        if (!(date2 instanceof Date))
          date2 = /* @__PURE__ */ new Date(+date2);
        while (++i2 < n) {
          if (specifier.charCodeAt(i2) === 37) {
            string2.push(specifier.slice(j, i2));
            if ((pad2 = pads[c2 = specifier.charAt(++i2)]) != null)
              c2 = specifier.charAt(++i2);
            else
              pad2 = c2 === "e" ? " " : "0";
            if (format2 = formats2[c2])
              c2 = format2(date2, pad2);
            string2.push(c2);
            j = i2 + 1;
          }
        }
        string2.push(specifier.slice(j, i2));
        return string2.join("");
      };
    }
    function newParse(specifier, Z) {
      return function(string2) {
        var d = newDate(1900, void 0, 1), i2 = parseSpecifier(d, specifier, string2 += "", 0), week, day;
        if (i2 != string2.length)
          return null;
        if ("Q" in d)
          return new Date(d.Q);
        if ("s" in d)
          return new Date(d.s * 1e3 + ("L" in d ? d.L : 0));
        if (Z && !("Z" in d))
          d.Z = 0;
        if ("p" in d)
          d.H = d.H % 12 + d.p * 12;
        if (d.m === void 0)
          d.m = "q" in d ? d.q : 0;
        if ("V" in d) {
          if (d.V < 1 || d.V > 53)
            return null;
          if (!("w" in d))
            d.w = 1;
          if ("Z" in d) {
            week = utcDate(newDate(d.y, 0, 1)), day = week.getUTCDay();
            week = day > 4 || day === 0 ? utcMonday.ceil(week) : utcMonday(week);
            week = utcDay.offset(week, (d.V - 1) * 7);
            d.y = week.getUTCFullYear();
            d.m = week.getUTCMonth();
            d.d = week.getUTCDate() + (d.w + 6) % 7;
          } else {
            week = localDate(newDate(d.y, 0, 1)), day = week.getDay();
            week = day > 4 || day === 0 ? timeMonday.ceil(week) : timeMonday(week);
            week = timeDay.offset(week, (d.V - 1) * 7);
            d.y = week.getFullYear();
            d.m = week.getMonth();
            d.d = week.getDate() + (d.w + 6) % 7;
          }
        } else if ("W" in d || "U" in d) {
          if (!("w" in d))
            d.w = "u" in d ? d.u % 7 : "W" in d ? 1 : 0;
          day = "Z" in d ? utcDate(newDate(d.y, 0, 1)).getUTCDay() : localDate(newDate(d.y, 0, 1)).getDay();
          d.m = 0;
          d.d = "W" in d ? (d.w + 6) % 7 + d.W * 7 - (day + 5) % 7 : d.w + d.U * 7 - (day + 6) % 7;
        }
        if ("Z" in d) {
          d.H += d.Z / 100 | 0;
          d.M += d.Z % 100;
          return utcDate(d);
        }
        return localDate(d);
      };
    }
    function parseSpecifier(d, specifier, string2, j) {
      var i2 = 0, n = specifier.length, m = string2.length, c2, parse2;
      while (i2 < n) {
        if (j >= m)
          return -1;
        c2 = specifier.charCodeAt(i2++);
        if (c2 === 37) {
          c2 = specifier.charAt(i2++);
          parse2 = parses[c2 in pads ? specifier.charAt(i2++) : c2];
          if (!parse2 || (j = parse2(d, string2, j)) < 0)
            return -1;
        } else if (c2 != string2.charCodeAt(j++)) {
          return -1;
        }
      }
      return j;
    }
    function parsePeriod(d, string2, i2) {
      var n = periodRe.exec(string2.slice(i2));
      return n ? (d.p = periodLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseShortWeekday(d, string2, i2) {
      var n = shortWeekdayRe.exec(string2.slice(i2));
      return n ? (d.w = shortWeekdayLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseWeekday(d, string2, i2) {
      var n = weekdayRe.exec(string2.slice(i2));
      return n ? (d.w = weekdayLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseShortMonth(d, string2, i2) {
      var n = shortMonthRe.exec(string2.slice(i2));
      return n ? (d.m = shortMonthLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseMonth(d, string2, i2) {
      var n = monthRe.exec(string2.slice(i2));
      return n ? (d.m = monthLookup.get(n[0].toLowerCase()), i2 + n[0].length) : -1;
    }
    function parseLocaleDateTime(d, string2, i2) {
      return parseSpecifier(d, locale_dateTime, string2, i2);
    }
    function parseLocaleDate(d, string2, i2) {
      return parseSpecifier(d, locale_date, string2, i2);
    }
    function parseLocaleTime(d, string2, i2) {
      return parseSpecifier(d, locale_time, string2, i2);
    }
    function formatShortWeekday(d) {
      return locale_shortWeekdays[d.getDay()];
    }
    function formatWeekday(d) {
      return locale_weekdays[d.getDay()];
    }
    function formatShortMonth(d) {
      return locale_shortMonths[d.getMonth()];
    }
    function formatMonth(d) {
      return locale_months[d.getMonth()];
    }
    function formatPeriod(d) {
      return locale_periods[+(d.getHours() >= 12)];
    }
    function formatQuarter(d) {
      return 1 + ~~(d.getMonth() / 3);
    }
    function formatUTCShortWeekday(d) {
      return locale_shortWeekdays[d.getUTCDay()];
    }
    function formatUTCWeekday(d) {
      return locale_weekdays[d.getUTCDay()];
    }
    function formatUTCShortMonth(d) {
      return locale_shortMonths[d.getUTCMonth()];
    }
    function formatUTCMonth(d) {
      return locale_months[d.getUTCMonth()];
    }
    function formatUTCPeriod(d) {
      return locale_periods[+(d.getUTCHours() >= 12)];
    }
    function formatUTCQuarter(d) {
      return 1 + ~~(d.getUTCMonth() / 3);
    }
    return {
      format: function(specifier) {
        var f2 = newFormat(specifier += "", formats);
        f2.toString = function() {
          return specifier;
        };
        return f2;
      },
      parse: function(specifier) {
        var p = newParse(specifier += "", false);
        p.toString = function() {
          return specifier;
        };
        return p;
      },
      utcFormat: function(specifier) {
        var f2 = newFormat(specifier += "", utcFormats);
        f2.toString = function() {
          return specifier;
        };
        return f2;
      },
      utcParse: function(specifier) {
        var p = newParse(specifier += "", true);
        p.toString = function() {
          return specifier;
        };
        return p;
      }
    };
  }
  var pads = { "-": "", "_": " ", "0": "0" }, numberRe = /^\s*\d+/, percentRe = /^%/, requoteRe = /[\\^$*+?|[\]().{}]/g;
  function pad(value2, fill, width2) {
    var sign2 = value2 < 0 ? "-" : "", string2 = (sign2 ? -value2 : value2) + "", length2 = string2.length;
    return sign2 + (length2 < width2 ? new Array(width2 - length2 + 1).join(fill) + string2 : string2);
  }
  function requote(s) {
    return s.replace(requoteRe, "\\$&");
  }
  function formatRe(names) {
    return new RegExp("^(?:" + names.map(requote).join("|") + ")", "i");
  }
  function formatLookup(names) {
    return new Map(names.map((name, i2) => [name.toLowerCase(), i2]));
  }
  function parseWeekdayNumberSunday(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 1));
    return n ? (d.w = +n[0], i2 + n[0].length) : -1;
  }
  function parseWeekdayNumberMonday(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 1));
    return n ? (d.u = +n[0], i2 + n[0].length) : -1;
  }
  function parseWeekNumberSunday(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.U = +n[0], i2 + n[0].length) : -1;
  }
  function parseWeekNumberISO(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.V = +n[0], i2 + n[0].length) : -1;
  }
  function parseWeekNumberMonday(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.W = +n[0], i2 + n[0].length) : -1;
  }
  function parseFullYear(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 4));
    return n ? (d.y = +n[0], i2 + n[0].length) : -1;
  }
  function parseYear(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.y = +n[0] + (+n[0] > 68 ? 1900 : 2e3), i2 + n[0].length) : -1;
  }
  function parseZone(d, string2, i2) {
    var n = /^(Z)|([+-]\d\d)(?::?(\d\d))?/.exec(string2.slice(i2, i2 + 6));
    return n ? (d.Z = n[1] ? 0 : -(n[2] + (n[3] || "00")), i2 + n[0].length) : -1;
  }
  function parseQuarter(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 1));
    return n ? (d.q = n[0] * 3 - 3, i2 + n[0].length) : -1;
  }
  function parseMonthNumber(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.m = n[0] - 1, i2 + n[0].length) : -1;
  }
  function parseDayOfMonth(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.d = +n[0], i2 + n[0].length) : -1;
  }
  function parseDayOfYear(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 3));
    return n ? (d.m = 0, d.d = +n[0], i2 + n[0].length) : -1;
  }
  function parseHour24(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.H = +n[0], i2 + n[0].length) : -1;
  }
  function parseMinutes(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.M = +n[0], i2 + n[0].length) : -1;
  }
  function parseSeconds(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 2));
    return n ? (d.S = +n[0], i2 + n[0].length) : -1;
  }
  function parseMilliseconds(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 3));
    return n ? (d.L = +n[0], i2 + n[0].length) : -1;
  }
  function parseMicroseconds(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2, i2 + 6));
    return n ? (d.L = Math.floor(n[0] / 1e3), i2 + n[0].length) : -1;
  }
  function parseLiteralPercent(d, string2, i2) {
    var n = percentRe.exec(string2.slice(i2, i2 + 1));
    return n ? i2 + n[0].length : -1;
  }
  function parseUnixTimestamp(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2));
    return n ? (d.Q = +n[0], i2 + n[0].length) : -1;
  }
  function parseUnixTimestampSeconds(d, string2, i2) {
    var n = numberRe.exec(string2.slice(i2));
    return n ? (d.s = +n[0], i2 + n[0].length) : -1;
  }
  function formatDayOfMonth(d, p) {
    return pad(d.getDate(), p, 2);
  }
  function formatHour24(d, p) {
    return pad(d.getHours(), p, 2);
  }
  function formatHour12(d, p) {
    return pad(d.getHours() % 12 || 12, p, 2);
  }
  function formatDayOfYear(d, p) {
    return pad(1 + timeDay.count(timeYear(d), d), p, 3);
  }
  function formatMilliseconds(d, p) {
    return pad(d.getMilliseconds(), p, 3);
  }
  function formatMicroseconds(d, p) {
    return formatMilliseconds(d, p) + "000";
  }
  function formatMonthNumber(d, p) {
    return pad(d.getMonth() + 1, p, 2);
  }
  function formatMinutes(d, p) {
    return pad(d.getMinutes(), p, 2);
  }
  function formatSeconds(d, p) {
    return pad(d.getSeconds(), p, 2);
  }
  function formatWeekdayNumberMonday(d) {
    var day = d.getDay();
    return day === 0 ? 7 : day;
  }
  function formatWeekNumberSunday(d, p) {
    return pad(timeSunday.count(timeYear(d) - 1, d), p, 2);
  }
  function dISO(d) {
    var day = d.getDay();
    return day >= 4 || day === 0 ? timeThursday(d) : timeThursday.ceil(d);
  }
  function formatWeekNumberISO(d, p) {
    d = dISO(d);
    return pad(timeThursday.count(timeYear(d), d) + (timeYear(d).getDay() === 4), p, 2);
  }
  function formatWeekdayNumberSunday(d) {
    return d.getDay();
  }
  function formatWeekNumberMonday(d, p) {
    return pad(timeMonday.count(timeYear(d) - 1, d), p, 2);
  }
  function formatYear(d, p) {
    return pad(d.getFullYear() % 100, p, 2);
  }
  function formatYearISO(d, p) {
    d = dISO(d);
    return pad(d.getFullYear() % 100, p, 2);
  }
  function formatFullYear(d, p) {
    return pad(d.getFullYear() % 1e4, p, 4);
  }
  function formatFullYearISO(d, p) {
    var day = d.getDay();
    d = day >= 4 || day === 0 ? timeThursday(d) : timeThursday.ceil(d);
    return pad(d.getFullYear() % 1e4, p, 4);
  }
  function formatZone(d) {
    var z = d.getTimezoneOffset();
    return (z > 0 ? "-" : (z *= -1, "+")) + pad(z / 60 | 0, "0", 2) + pad(z % 60, "0", 2);
  }
  function formatUTCDayOfMonth(d, p) {
    return pad(d.getUTCDate(), p, 2);
  }
  function formatUTCHour24(d, p) {
    return pad(d.getUTCHours(), p, 2);
  }
  function formatUTCHour12(d, p) {
    return pad(d.getUTCHours() % 12 || 12, p, 2);
  }
  function formatUTCDayOfYear(d, p) {
    return pad(1 + utcDay.count(utcYear(d), d), p, 3);
  }
  function formatUTCMilliseconds(d, p) {
    return pad(d.getUTCMilliseconds(), p, 3);
  }
  function formatUTCMicroseconds(d, p) {
    return formatUTCMilliseconds(d, p) + "000";
  }
  function formatUTCMonthNumber(d, p) {
    return pad(d.getUTCMonth() + 1, p, 2);
  }
  function formatUTCMinutes(d, p) {
    return pad(d.getUTCMinutes(), p, 2);
  }
  function formatUTCSeconds(d, p) {
    return pad(d.getUTCSeconds(), p, 2);
  }
  function formatUTCWeekdayNumberMonday(d) {
    var dow = d.getUTCDay();
    return dow === 0 ? 7 : dow;
  }
  function formatUTCWeekNumberSunday(d, p) {
    return pad(utcSunday.count(utcYear(d) - 1, d), p, 2);
  }
  function UTCdISO(d) {
    var day = d.getUTCDay();
    return day >= 4 || day === 0 ? utcThursday(d) : utcThursday.ceil(d);
  }
  function formatUTCWeekNumberISO(d, p) {
    d = UTCdISO(d);
    return pad(utcThursday.count(utcYear(d), d) + (utcYear(d).getUTCDay() === 4), p, 2);
  }
  function formatUTCWeekdayNumberSunday(d) {
    return d.getUTCDay();
  }
  function formatUTCWeekNumberMonday(d, p) {
    return pad(utcMonday.count(utcYear(d) - 1, d), p, 2);
  }
  function formatUTCYear(d, p) {
    return pad(d.getUTCFullYear() % 100, p, 2);
  }
  function formatUTCYearISO(d, p) {
    d = UTCdISO(d);
    return pad(d.getUTCFullYear() % 100, p, 2);
  }
  function formatUTCFullYear(d, p) {
    return pad(d.getUTCFullYear() % 1e4, p, 4);
  }
  function formatUTCFullYearISO(d, p) {
    var day = d.getUTCDay();
    d = day >= 4 || day === 0 ? utcThursday(d) : utcThursday.ceil(d);
    return pad(d.getUTCFullYear() % 1e4, p, 4);
  }
  function formatUTCZone() {
    return "+0000";
  }
  function formatLiteralPercent() {
    return "%";
  }
  function formatUnixTimestamp(d) {
    return +d;
  }
  function formatUnixTimestampSeconds(d) {
    return Math.floor(+d / 1e3);
  }
  var locale;
  var timeFormat;
  defaultLocale({
    dateTime: "%x, %X",
    date: "%-m/%-d/%Y",
    time: "%-I:%M:%S %p",
    periods: ["AM", "PM"],
    days: ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"],
    shortDays: ["Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat"],
    months: ["January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"],
    shortMonths: ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
  });
  function defaultLocale(definition2) {
    locale = formatLocale(definition2);
    timeFormat = locale.format;
    locale.parse;
    locale.utcFormat;
    locale.utcParse;
    return locale;
  }
  function date(t) {
    return new Date(t);
  }
  function number(t) {
    return t instanceof Date ? +t : +/* @__PURE__ */ new Date(+t);
  }
  function calendar(ticks2, tickInterval2, year, month, week, day, hour, minute, second2, format2) {
    var scale = continuous(), invert2 = scale.invert, domain = scale.domain;
    var formatMillisecond = format2(".%L"), formatSecond = format2(":%S"), formatMinute = format2("%I:%M"), formatHour = format2("%I %p"), formatDay = format2("%a %d"), formatWeek = format2("%b %d"), formatMonth = format2("%B"), formatYear2 = format2("%Y");
    function tickFormat2(date2) {
      return (second2(date2) < date2 ? formatMillisecond : minute(date2) < date2 ? formatSecond : hour(date2) < date2 ? formatMinute : day(date2) < date2 ? formatHour : month(date2) < date2 ? week(date2) < date2 ? formatDay : formatWeek : year(date2) < date2 ? formatMonth : formatYear2)(date2);
    }
    scale.invert = function(y2) {
      return new Date(invert2(y2));
    };
    scale.domain = function(_2) {
      return arguments.length ? domain(Array.from(_2, number)) : domain().map(date);
    };
    scale.ticks = function(interval2) {
      var d = domain();
      return ticks2(d[0], d[d.length - 1], interval2 == null ? 10 : interval2);
    };
    scale.tickFormat = function(count, specifier) {
      return specifier == null ? tickFormat2 : format2(specifier);
    };
    scale.nice = function(interval2) {
      var d = domain();
      if (!interval2 || typeof interval2.range !== "function")
        interval2 = tickInterval2(d[0], d[d.length - 1], interval2 == null ? 10 : interval2);
      return interval2 ? domain(nice(d, interval2)) : scale;
    };
    scale.copy = function() {
      return copy$1(scale, calendar(ticks2, tickInterval2, year, month, week, day, hour, minute, second2, format2));
    };
    return scale;
  }
  function time$1() {
    return initRange.apply(calendar(timeTicks, timeTickInterval, timeYear, timeMonth, timeSunday, timeDay, timeHour, timeMinute, second, timeFormat).domain([new Date(2e3, 0, 1), new Date(2e3, 0, 2)]), arguments);
  }
  function colors(specifier) {
    var n = specifier.length / 6 | 0, colors2 = new Array(n), i2 = 0;
    while (i2 < n)
      colors2[i2] = "#" + specifier.slice(i2 * 6, ++i2 * 6);
    return colors2;
  }
  const d3schemeTableau10 = colors("4e79a7f28e2ce1575976b7b259a14fedc949af7aa1ff9da79c755fbab0ab");
  function constant$3(x2) {
    return function constant2() {
      return x2;
    };
  }
  const abs$1 = Math.abs;
  const atan2 = Math.atan2;
  const cos = Math.cos;
  const max$2 = Math.max;
  const min$2 = Math.min;
  const sin = Math.sin;
  const sqrt = Math.sqrt;
  const epsilon$1 = 1e-12;
  const pi$1 = Math.PI;
  const halfPi = pi$1 / 2;
  const tau$1 = 2 * pi$1;
  function acos(x2) {
    return x2 > 1 ? 0 : x2 < -1 ? pi$1 : Math.acos(x2);
  }
  function asin(x2) {
    return x2 >= 1 ? halfPi : x2 <= -1 ? -halfPi : Math.asin(x2);
  }
  function withPath(shape) {
    let digits = 3;
    shape.digits = function(_2) {
      if (!arguments.length)
        return digits;
      if (_2 == null) {
        digits = null;
      } else {
        const d = Math.floor(_2);
        if (!(d >= 0))
          throw new RangeError(`invalid digits: ${_2}`);
        digits = d;
      }
      return shape;
    };
    return () => new Path$1(digits);
  }
  function arcInnerRadius(d) {
    return d.innerRadius;
  }
  function arcOuterRadius(d) {
    return d.outerRadius;
  }
  function arcStartAngle(d) {
    return d.startAngle;
  }
  function arcEndAngle(d) {
    return d.endAngle;
  }
  function arcPadAngle(d) {
    return d && d.padAngle;
  }
  function intersect$1(x0, y0, x1, y1, x2, y2, x3, y3) {
    var x10 = x1 - x0, y10 = y1 - y0, x32 = x3 - x2, y32 = y3 - y2, t = y32 * x10 - x32 * y10;
    if (t * t < epsilon$1)
      return;
    t = (x32 * (y0 - y2) - y32 * (x0 - x2)) / t;
    return [x0 + t * x10, y0 + t * y10];
  }
  function cornerTangents(x0, y0, x1, y1, r1, rc, cw) {
    var x01 = x0 - x1, y01 = y0 - y1, lo = (cw ? rc : -rc) / sqrt(x01 * x01 + y01 * y01), ox = lo * y01, oy = -lo * x01, x11 = x0 + ox, y11 = y0 + oy, x10 = x1 + ox, y10 = y1 + oy, x00 = (x11 + x10) / 2, y00 = (y11 + y10) / 2, dx = x10 - x11, dy = y10 - y11, d2 = dx * dx + dy * dy, r = r1 - rc, D = x11 * y10 - x10 * y11, d = (dy < 0 ? -1 : 1) * sqrt(max$2(0, r * r * d2 - D * D)), cx0 = (D * dy - dx * d) / d2, cy0 = (-D * dx - dy * d) / d2, cx1 = (D * dy + dx * d) / d2, cy1 = (-D * dx + dy * d) / d2, dx0 = cx0 - x00, dy0 = cy0 - y00, dx1 = cx1 - x00, dy1 = cy1 - y00;
    if (dx0 * dx0 + dy0 * dy0 > dx1 * dx1 + dy1 * dy1)
      cx0 = cx1, cy0 = cy1;
    return {
      cx: cx0,
      cy: cy0,
      x01: -ox,
      y01: -oy,
      x11: cx0 * (r1 / r - 1),
      y11: cy0 * (r1 / r - 1)
    };
  }
  function d3arc() {
    var innerRadius = arcInnerRadius, outerRadius = arcOuterRadius, cornerRadius = constant$3(0), padRadius = null, startAngle = arcStartAngle, endAngle = arcEndAngle, padAngle = arcPadAngle, context = null, path2 = withPath(arc);
    function arc() {
      var buffer, r, r0 = +innerRadius.apply(this, arguments), r1 = +outerRadius.apply(this, arguments), a0 = startAngle.apply(this, arguments) - halfPi, a1 = endAngle.apply(this, arguments) - halfPi, da = abs$1(a1 - a0), cw = a1 > a0;
      if (!context)
        context = buffer = path2();
      if (r1 < r0)
        r = r1, r1 = r0, r0 = r;
      if (!(r1 > epsilon$1))
        context.moveTo(0, 0);
      else if (da > tau$1 - epsilon$1) {
        context.moveTo(r1 * cos(a0), r1 * sin(a0));
        context.arc(0, 0, r1, a0, a1, !cw);
        if (r0 > epsilon$1) {
          context.moveTo(r0 * cos(a1), r0 * sin(a1));
          context.arc(0, 0, r0, a1, a0, cw);
        }
      } else {
        var a01 = a0, a11 = a1, a00 = a0, a10 = a1, da0 = da, da1 = da, ap = padAngle.apply(this, arguments) / 2, rp = ap > epsilon$1 && (padRadius ? +padRadius.apply(this, arguments) : sqrt(r0 * r0 + r1 * r1)), rc = min$2(abs$1(r1 - r0) / 2, +cornerRadius.apply(this, arguments)), rc0 = rc, rc1 = rc, t02, t12;
        if (rp > epsilon$1) {
          var p0 = asin(rp / r0 * sin(ap)), p1 = asin(rp / r1 * sin(ap));
          if ((da0 -= p0 * 2) > epsilon$1)
            p0 *= cw ? 1 : -1, a00 += p0, a10 -= p0;
          else
            da0 = 0, a00 = a10 = (a0 + a1) / 2;
          if ((da1 -= p1 * 2) > epsilon$1)
            p1 *= cw ? 1 : -1, a01 += p1, a11 -= p1;
          else
            da1 = 0, a01 = a11 = (a0 + a1) / 2;
        }
        var x01 = r1 * cos(a01), y01 = r1 * sin(a01), x10 = r0 * cos(a10), y10 = r0 * sin(a10);
        if (rc > epsilon$1) {
          var x11 = r1 * cos(a11), y11 = r1 * sin(a11), x00 = r0 * cos(a00), y00 = r0 * sin(a00), oc;
          if (da < pi$1) {
            if (oc = intersect$1(x01, y01, x00, y00, x11, y11, x10, y10)) {
              var ax = x01 - oc[0], ay = y01 - oc[1], bx = x11 - oc[0], by = y11 - oc[1], kc = 1 / sin(acos((ax * bx + ay * by) / (sqrt(ax * ax + ay * ay) * sqrt(bx * bx + by * by))) / 2), lc = sqrt(oc[0] * oc[0] + oc[1] * oc[1]);
              rc0 = min$2(rc, (r0 - lc) / (kc - 1));
              rc1 = min$2(rc, (r1 - lc) / (kc + 1));
            } else {
              rc0 = rc1 = 0;
            }
          }
        }
        if (!(da1 > epsilon$1))
          context.moveTo(x01, y01);
        else if (rc1 > epsilon$1) {
          t02 = cornerTangents(x00, y00, x01, y01, r1, rc1, cw);
          t12 = cornerTangents(x11, y11, x10, y10, r1, rc1, cw);
          context.moveTo(t02.cx + t02.x01, t02.cy + t02.y01);
          if (rc1 < rc)
            context.arc(t02.cx, t02.cy, rc1, atan2(t02.y01, t02.x01), atan2(t12.y01, t12.x01), !cw);
          else {
            context.arc(t02.cx, t02.cy, rc1, atan2(t02.y01, t02.x01), atan2(t02.y11, t02.x11), !cw);
            context.arc(0, 0, r1, atan2(t02.cy + t02.y11, t02.cx + t02.x11), atan2(t12.cy + t12.y11, t12.cx + t12.x11), !cw);
            context.arc(t12.cx, t12.cy, rc1, atan2(t12.y11, t12.x11), atan2(t12.y01, t12.x01), !cw);
          }
        } else
          context.moveTo(x01, y01), context.arc(0, 0, r1, a01, a11, !cw);
        if (!(r0 > epsilon$1) || !(da0 > epsilon$1))
          context.lineTo(x10, y10);
        else if (rc0 > epsilon$1) {
          t02 = cornerTangents(x10, y10, x11, y11, r0, -rc0, cw);
          t12 = cornerTangents(x01, y01, x00, y00, r0, -rc0, cw);
          context.lineTo(t02.cx + t02.x01, t02.cy + t02.y01);
          if (rc0 < rc)
            context.arc(t02.cx, t02.cy, rc0, atan2(t02.y01, t02.x01), atan2(t12.y01, t12.x01), !cw);
          else {
            context.arc(t02.cx, t02.cy, rc0, atan2(t02.y01, t02.x01), atan2(t02.y11, t02.x11), !cw);
            context.arc(0, 0, r0, atan2(t02.cy + t02.y11, t02.cx + t02.x11), atan2(t12.cy + t12.y11, t12.cx + t12.x11), cw);
            context.arc(t12.cx, t12.cy, rc0, atan2(t12.y11, t12.x11), atan2(t12.y01, t12.x01), !cw);
          }
        } else
          context.arc(0, 0, r0, a10, a00, cw);
      }
      context.closePath();
      if (buffer)
        return context = null, buffer + "" || null;
    }
    arc.centroid = function() {
      var r = (+innerRadius.apply(this, arguments) + +outerRadius.apply(this, arguments)) / 2, a = (+startAngle.apply(this, arguments) + +endAngle.apply(this, arguments)) / 2 - pi$1 / 2;
      return [cos(a) * r, sin(a) * r];
    };
    arc.innerRadius = function(_2) {
      return arguments.length ? (innerRadius = typeof _2 === "function" ? _2 : constant$3(+_2), arc) : innerRadius;
    };
    arc.outerRadius = function(_2) {
      return arguments.length ? (outerRadius = typeof _2 === "function" ? _2 : constant$3(+_2), arc) : outerRadius;
    };
    arc.cornerRadius = function(_2) {
      return arguments.length ? (cornerRadius = typeof _2 === "function" ? _2 : constant$3(+_2), arc) : cornerRadius;
    };
    arc.padRadius = function(_2) {
      return arguments.length ? (padRadius = _2 == null ? null : typeof _2 === "function" ? _2 : constant$3(+_2), arc) : padRadius;
    };
    arc.startAngle = function(_2) {
      return arguments.length ? (startAngle = typeof _2 === "function" ? _2 : constant$3(+_2), arc) : startAngle;
    };
    arc.endAngle = function(_2) {
      return arguments.length ? (endAngle = typeof _2 === "function" ? _2 : constant$3(+_2), arc) : endAngle;
    };
    arc.padAngle = function(_2) {
      return arguments.length ? (padAngle = typeof _2 === "function" ? _2 : constant$3(+_2), arc) : padAngle;
    };
    arc.context = function(_2) {
      return arguments.length ? (context = _2 == null ? null : _2, arc) : context;
    };
    return arc;
  }
  function array(x2) {
    return typeof x2 === "object" && "length" in x2 ? x2 : Array.from(x2);
  }
  function Linear(context) {
    this._context = context;
  }
  Linear.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._point = 0;
    },
    lineEnd: function() {
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
        default:
          this._context.lineTo(x2, y2);
          break;
      }
    }
  };
  function curveLinear(context) {
    return new Linear(context);
  }
  function x$1(p) {
    return p[0];
  }
  function y$1(p) {
    return p[1];
  }
  function line$1(x2, y2) {
    var defined = constant$3(true), context = null, curve = curveLinear, output = null, path2 = withPath(line2);
    x2 = typeof x2 === "function" ? x2 : x2 === void 0 ? x$1 : constant$3(x2);
    y2 = typeof y2 === "function" ? y2 : y2 === void 0 ? y$1 : constant$3(y2);
    function line2(data) {
      var i2, n = (data = array(data)).length, d, defined0 = false, buffer;
      if (context == null)
        output = curve(buffer = path2());
      for (i2 = 0; i2 <= n; ++i2) {
        if (!(i2 < n && defined(d = data[i2], i2, data)) === defined0) {
          if (defined0 = !defined0)
            output.lineStart();
          else
            output.lineEnd();
        }
        if (defined0)
          output.point(+x2(d, i2, data), +y2(d, i2, data));
      }
      if (buffer)
        return output = null, buffer + "" || null;
    }
    line2.x = function(_2) {
      return arguments.length ? (x2 = typeof _2 === "function" ? _2 : constant$3(+_2), line2) : x2;
    };
    line2.y = function(_2) {
      return arguments.length ? (y2 = typeof _2 === "function" ? _2 : constant$3(+_2), line2) : y2;
    };
    line2.defined = function(_2) {
      return arguments.length ? (defined = typeof _2 === "function" ? _2 : constant$3(!!_2), line2) : defined;
    };
    line2.curve = function(_2) {
      return arguments.length ? (curve = _2, context != null && (output = curve(context)), line2) : curve;
    };
    line2.context = function(_2) {
      return arguments.length ? (_2 == null ? context = output = null : output = curve(context = _2), line2) : context;
    };
    return line2;
  }
  function descending(a, b) {
    return b < a ? -1 : b > a ? 1 : b >= a ? 0 : NaN;
  }
  function identity$1(d) {
    return d;
  }
  function d3pie() {
    var value2 = identity$1, sortValues = descending, sort2 = null, startAngle = constant$3(0), endAngle = constant$3(tau$1), padAngle = constant$3(0);
    function pie2(data) {
      var i2, n = (data = array(data)).length, j, k, sum2 = 0, index2 = new Array(n), arcs = new Array(n), a0 = +startAngle.apply(this, arguments), da = Math.min(tau$1, Math.max(-tau$1, endAngle.apply(this, arguments) - a0)), a1, p = Math.min(Math.abs(da) / n, padAngle.apply(this, arguments)), pa = p * (da < 0 ? -1 : 1), v;
      for (i2 = 0; i2 < n; ++i2) {
        if ((v = arcs[index2[i2] = i2] = +value2(data[i2], i2, data)) > 0) {
          sum2 += v;
        }
      }
      if (sortValues != null)
        index2.sort(function(i3, j2) {
          return sortValues(arcs[i3], arcs[j2]);
        });
      else if (sort2 != null)
        index2.sort(function(i3, j2) {
          return sort2(data[i3], data[j2]);
        });
      for (i2 = 0, k = sum2 ? (da - n * pa) / sum2 : 0; i2 < n; ++i2, a0 = a1) {
        j = index2[i2], v = arcs[j], a1 = a0 + (v > 0 ? v * k : 0) + pa, arcs[j] = {
          data: data[j],
          index: i2,
          value: v,
          startAngle: a0,
          endAngle: a1,
          padAngle: p
        };
      }
      return arcs;
    }
    pie2.value = function(_2) {
      return arguments.length ? (value2 = typeof _2 === "function" ? _2 : constant$3(+_2), pie2) : value2;
    };
    pie2.sortValues = function(_2) {
      return arguments.length ? (sortValues = _2, sort2 = null, pie2) : sortValues;
    };
    pie2.sort = function(_2) {
      return arguments.length ? (sort2 = _2, sortValues = null, pie2) : sort2;
    };
    pie2.startAngle = function(_2) {
      return arguments.length ? (startAngle = typeof _2 === "function" ? _2 : constant$3(+_2), pie2) : startAngle;
    };
    pie2.endAngle = function(_2) {
      return arguments.length ? (endAngle = typeof _2 === "function" ? _2 : constant$3(+_2), pie2) : endAngle;
    };
    pie2.padAngle = function(_2) {
      return arguments.length ? (padAngle = typeof _2 === "function" ? _2 : constant$3(+_2), pie2) : padAngle;
    };
    return pie2;
  }
  class Bump {
    constructor(context, x2) {
      this._context = context;
      this._x = x2;
    }
    areaStart() {
      this._line = 0;
    }
    areaEnd() {
      this._line = NaN;
    }
    lineStart() {
      this._point = 0;
    }
    lineEnd() {
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    }
    point(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0: {
          this._point = 1;
          if (this._line)
            this._context.lineTo(x2, y2);
          else
            this._context.moveTo(x2, y2);
          break;
        }
        case 1:
          this._point = 2;
        default: {
          if (this._x)
            this._context.bezierCurveTo(this._x0 = (this._x0 + x2) / 2, this._y0, this._x0, y2, x2, y2);
          else
            this._context.bezierCurveTo(this._x0, this._y0 = (this._y0 + y2) / 2, x2, this._y0, x2, y2);
          break;
        }
      }
      this._x0 = x2, this._y0 = y2;
    }
  }
  function bumpX(context) {
    return new Bump(context, true);
  }
  function bumpY(context) {
    return new Bump(context, false);
  }
  function noop$1() {
  }
  function point$6(that, x2, y2) {
    that._context.bezierCurveTo(
      (2 * that._x0 + that._x1) / 3,
      (2 * that._y0 + that._y1) / 3,
      (that._x0 + 2 * that._x1) / 3,
      (that._y0 + 2 * that._y1) / 3,
      (that._x0 + 4 * that._x1 + x2) / 6,
      (that._y0 + 4 * that._y1 + y2) / 6
    );
  }
  function Basis(context) {
    this._context = context;
  }
  Basis.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._y0 = this._y1 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 3:
          point$6(this, this._x1, this._y1);
        case 2:
          this._context.lineTo(this._x1, this._y1);
          break;
      }
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          this._context.lineTo((5 * this._x0 + this._x1) / 6, (5 * this._y0 + this._y1) / 6);
        default:
          point$6(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = x2;
      this._y0 = this._y1, this._y1 = y2;
    }
  };
  function curveBasis(context) {
    return new Basis(context);
  }
  function BasisClosed(context) {
    this._context = context;
  }
  BasisClosed.prototype = {
    areaStart: noop$1,
    areaEnd: noop$1,
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 1: {
          this._context.moveTo(this._x2, this._y2);
          this._context.closePath();
          break;
        }
        case 2: {
          this._context.moveTo((this._x2 + 2 * this._x3) / 3, (this._y2 + 2 * this._y3) / 3);
          this._context.lineTo((this._x3 + 2 * this._x2) / 3, (this._y3 + 2 * this._y2) / 3);
          this._context.closePath();
          break;
        }
        case 3: {
          this.point(this._x2, this._y2);
          this.point(this._x3, this._y3);
          this.point(this._x4, this._y4);
          break;
        }
      }
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._x2 = x2, this._y2 = y2;
          break;
        case 1:
          this._point = 2;
          this._x3 = x2, this._y3 = y2;
          break;
        case 2:
          this._point = 3;
          this._x4 = x2, this._y4 = y2;
          this._context.moveTo((this._x0 + 4 * this._x1 + x2) / 6, (this._y0 + 4 * this._y1 + y2) / 6);
          break;
        default:
          point$6(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = x2;
      this._y0 = this._y1, this._y1 = y2;
    }
  };
  function curveBasisClosed(context) {
    return new BasisClosed(context);
  }
  function BasisOpen(context) {
    this._context = context;
  }
  BasisOpen.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._y0 = this._y1 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      if (this._line || this._line !== 0 && this._point === 3)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          var x0 = (this._x0 + 4 * this._x1 + x2) / 6, y0 = (this._y0 + 4 * this._y1 + y2) / 6;
          this._line ? this._context.lineTo(x0, y0) : this._context.moveTo(x0, y0);
          break;
        case 3:
          this._point = 4;
        default:
          point$6(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = x2;
      this._y0 = this._y1, this._y1 = y2;
    }
  };
  function curveBasisOpen(context) {
    return new BasisOpen(context);
  }
  function Bundle(context, beta) {
    this._basis = new Basis(context);
    this._beta = beta;
  }
  Bundle.prototype = {
    lineStart: function() {
      this._x = [];
      this._y = [];
      this._basis.lineStart();
    },
    lineEnd: function() {
      var x2 = this._x, y2 = this._y, j = x2.length - 1;
      if (j > 0) {
        var x0 = x2[0], y0 = y2[0], dx = x2[j] - x0, dy = y2[j] - y0, i2 = -1, t;
        while (++i2 <= j) {
          t = i2 / j;
          this._basis.point(
            this._beta * x2[i2] + (1 - this._beta) * (x0 + t * dx),
            this._beta * y2[i2] + (1 - this._beta) * (y0 + t * dy)
          );
        }
      }
      this._x = this._y = null;
      this._basis.lineEnd();
    },
    point: function(x2, y2) {
      this._x.push(+x2);
      this._y.push(+y2);
    }
  };
  const curveBundle = function custom(beta) {
    function bundle(context) {
      return beta === 1 ? new Basis(context) : new Bundle(context, beta);
    }
    bundle.beta = function(beta2) {
      return custom(+beta2);
    };
    return bundle;
  }(0.85);
  function point$5(that, x2, y2) {
    that._context.bezierCurveTo(
      that._x1 + that._k * (that._x2 - that._x0),
      that._y1 + that._k * (that._y2 - that._y0),
      that._x2 + that._k * (that._x1 - x2),
      that._y2 + that._k * (that._y1 - y2),
      that._x2,
      that._y2
    );
  }
  function Cardinal(context, tension) {
    this._context = context;
    this._k = (1 - tension) / 6;
  }
  Cardinal.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 2:
          this._context.lineTo(this._x2, this._y2);
          break;
        case 3:
          point$5(this, this._x1, this._y1);
          break;
      }
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
          this._x1 = x2, this._y1 = y2;
          break;
        case 2:
          this._point = 3;
        default:
          point$5(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCardinal = function custom(tension) {
    function cardinal(context) {
      return new Cardinal(context, tension);
    }
    cardinal.tension = function(tension2) {
      return custom(+tension2);
    };
    return cardinal;
  }(0);
  function CardinalClosed(context, tension) {
    this._context = context;
    this._k = (1 - tension) / 6;
  }
  CardinalClosed.prototype = {
    areaStart: noop$1,
    areaEnd: noop$1,
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 1: {
          this._context.moveTo(this._x3, this._y3);
          this._context.closePath();
          break;
        }
        case 2: {
          this._context.lineTo(this._x3, this._y3);
          this._context.closePath();
          break;
        }
        case 3: {
          this.point(this._x3, this._y3);
          this.point(this._x4, this._y4);
          this.point(this._x5, this._y5);
          break;
        }
      }
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._x3 = x2, this._y3 = y2;
          break;
        case 1:
          this._point = 2;
          this._context.moveTo(this._x4 = x2, this._y4 = y2);
          break;
        case 2:
          this._point = 3;
          this._x5 = x2, this._y5 = y2;
          break;
        default:
          point$5(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCardinalClosed = function custom(tension) {
    function cardinal(context) {
      return new CardinalClosed(context, tension);
    }
    cardinal.tension = function(tension2) {
      return custom(+tension2);
    };
    return cardinal;
  }(0);
  function CardinalOpen(context, tension) {
    this._context = context;
    this._k = (1 - tension) / 6;
  }
  CardinalOpen.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      if (this._line || this._line !== 0 && this._point === 3)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2);
          break;
        case 3:
          this._point = 4;
        default:
          point$5(this, x2, y2);
          break;
      }
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCardinalOpen = function custom(tension) {
    function cardinal(context) {
      return new CardinalOpen(context, tension);
    }
    cardinal.tension = function(tension2) {
      return custom(+tension2);
    };
    return cardinal;
  }(0);
  function point$4(that, x2, y2) {
    var x1 = that._x1, y1 = that._y1, x22 = that._x2, y22 = that._y2;
    if (that._l01_a > epsilon$1) {
      var a = 2 * that._l01_2a + 3 * that._l01_a * that._l12_a + that._l12_2a, n = 3 * that._l01_a * (that._l01_a + that._l12_a);
      x1 = (x1 * a - that._x0 * that._l12_2a + that._x2 * that._l01_2a) / n;
      y1 = (y1 * a - that._y0 * that._l12_2a + that._y2 * that._l01_2a) / n;
    }
    if (that._l23_a > epsilon$1) {
      var b = 2 * that._l23_2a + 3 * that._l23_a * that._l12_a + that._l12_2a, m = 3 * that._l23_a * (that._l23_a + that._l12_a);
      x22 = (x22 * b + that._x1 * that._l23_2a - x2 * that._l12_2a) / m;
      y22 = (y22 * b + that._y1 * that._l23_2a - y2 * that._l12_2a) / m;
    }
    that._context.bezierCurveTo(x1, y1, x22, y22, that._x2, that._y2);
  }
  function CatmullRom(context, alpha) {
    this._context = context;
    this._alpha = alpha;
  }
  CatmullRom.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
      this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 2:
          this._context.lineTo(this._x2, this._y2);
          break;
        case 3:
          this.point(this._x2, this._y2);
          break;
      }
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      if (this._point) {
        var x23 = this._x2 - x2, y23 = this._y2 - y2;
        this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
      }
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
        default:
          point$4(this, x2, y2);
          break;
      }
      this._l01_a = this._l12_a, this._l12_a = this._l23_a;
      this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCatmullRom = function custom(alpha) {
    function catmullRom(context) {
      return alpha ? new CatmullRom(context, alpha) : new Cardinal(context, 0);
    }
    catmullRom.alpha = function(alpha2) {
      return custom(+alpha2);
    };
    return catmullRom;
  }(0.5);
  function CatmullRomClosed(context, alpha) {
    this._context = context;
    this._alpha = alpha;
  }
  CatmullRomClosed.prototype = {
    areaStart: noop$1,
    areaEnd: noop$1,
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._x3 = this._x4 = this._x5 = this._y0 = this._y1 = this._y2 = this._y3 = this._y4 = this._y5 = NaN;
      this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 1: {
          this._context.moveTo(this._x3, this._y3);
          this._context.closePath();
          break;
        }
        case 2: {
          this._context.lineTo(this._x3, this._y3);
          this._context.closePath();
          break;
        }
        case 3: {
          this.point(this._x3, this._y3);
          this.point(this._x4, this._y4);
          this.point(this._x5, this._y5);
          break;
        }
      }
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      if (this._point) {
        var x23 = this._x2 - x2, y23 = this._y2 - y2;
        this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
      }
      switch (this._point) {
        case 0:
          this._point = 1;
          this._x3 = x2, this._y3 = y2;
          break;
        case 1:
          this._point = 2;
          this._context.moveTo(this._x4 = x2, this._y4 = y2);
          break;
        case 2:
          this._point = 3;
          this._x5 = x2, this._y5 = y2;
          break;
        default:
          point$4(this, x2, y2);
          break;
      }
      this._l01_a = this._l12_a, this._l12_a = this._l23_a;
      this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCatmullRomClosed = function custom(alpha) {
    function catmullRom(context) {
      return alpha ? new CatmullRomClosed(context, alpha) : new CardinalClosed(context, 0);
    }
    catmullRom.alpha = function(alpha2) {
      return custom(+alpha2);
    };
    return catmullRom;
  }(0.5);
  function CatmullRomOpen(context, alpha) {
    this._context = context;
    this._alpha = alpha;
  }
  CatmullRomOpen.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._x2 = this._y0 = this._y1 = this._y2 = NaN;
      this._l01_a = this._l12_a = this._l23_a = this._l01_2a = this._l12_2a = this._l23_2a = this._point = 0;
    },
    lineEnd: function() {
      if (this._line || this._line !== 0 && this._point === 3)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      if (this._point) {
        var x23 = this._x2 - x2, y23 = this._y2 - y2;
        this._l23_a = Math.sqrt(this._l23_2a = Math.pow(x23 * x23 + y23 * y23, this._alpha));
      }
      switch (this._point) {
        case 0:
          this._point = 1;
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          this._line ? this._context.lineTo(this._x2, this._y2) : this._context.moveTo(this._x2, this._y2);
          break;
        case 3:
          this._point = 4;
        default:
          point$4(this, x2, y2);
          break;
      }
      this._l01_a = this._l12_a, this._l12_a = this._l23_a;
      this._l01_2a = this._l12_2a, this._l12_2a = this._l23_2a;
      this._x0 = this._x1, this._x1 = this._x2, this._x2 = x2;
      this._y0 = this._y1, this._y1 = this._y2, this._y2 = y2;
    }
  };
  const curveCatmullRomOpen = function custom(alpha) {
    function catmullRom(context) {
      return alpha ? new CatmullRomOpen(context, alpha) : new CardinalOpen(context, 0);
    }
    catmullRom.alpha = function(alpha2) {
      return custom(+alpha2);
    };
    return catmullRom;
  }(0.5);
  function LinearClosed(context) {
    this._context = context;
  }
  LinearClosed.prototype = {
    areaStart: noop$1,
    areaEnd: noop$1,
    lineStart: function() {
      this._point = 0;
    },
    lineEnd: function() {
      if (this._point)
        this._context.closePath();
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      if (this._point)
        this._context.lineTo(x2, y2);
      else
        this._point = 1, this._context.moveTo(x2, y2);
    }
  };
  function curveLinearClosed(context) {
    return new LinearClosed(context);
  }
  function sign(x2) {
    return x2 < 0 ? -1 : 1;
  }
  function slope3(that, x2, y2) {
    var h0 = that._x1 - that._x0, h1 = x2 - that._x1, s0 = (that._y1 - that._y0) / (h0 || h1 < 0 && -0), s1 = (y2 - that._y1) / (h1 || h0 < 0 && -0), p = (s0 * h1 + s1 * h0) / (h0 + h1);
    return (sign(s0) + sign(s1)) * Math.min(Math.abs(s0), Math.abs(s1), 0.5 * Math.abs(p)) || 0;
  }
  function slope2(that, t) {
    var h = that._x1 - that._x0;
    return h ? (3 * (that._y1 - that._y0) / h - t) / 2 : t;
  }
  function point$3(that, t02, t12) {
    var x0 = that._x0, y0 = that._y0, x1 = that._x1, y1 = that._y1, dx = (x1 - x0) / 3;
    that._context.bezierCurveTo(x0 + dx, y0 + dx * t02, x1 - dx, y1 - dx * t12, x1, y1);
  }
  function MonotoneX(context) {
    this._context = context;
  }
  MonotoneX.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x0 = this._x1 = this._y0 = this._y1 = this._t0 = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      switch (this._point) {
        case 2:
          this._context.lineTo(this._x1, this._y1);
          break;
        case 3:
          point$3(this, this._t0, slope2(this, this._t0));
          break;
      }
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      var t12 = NaN;
      x2 = +x2, y2 = +y2;
      if (x2 === this._x1 && y2 === this._y1)
        return;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
          break;
        case 2:
          this._point = 3;
          point$3(this, slope2(this, t12 = slope3(this, x2, y2)), t12);
          break;
        default:
          point$3(this, this._t0, t12 = slope3(this, x2, y2));
          break;
      }
      this._x0 = this._x1, this._x1 = x2;
      this._y0 = this._y1, this._y1 = y2;
      this._t0 = t12;
    }
  };
  function MonotoneY(context) {
    this._context = new ReflectContext(context);
  }
  (MonotoneY.prototype = Object.create(MonotoneX.prototype)).point = function(x2, y2) {
    MonotoneX.prototype.point.call(this, y2, x2);
  };
  function ReflectContext(context) {
    this._context = context;
  }
  ReflectContext.prototype = {
    moveTo: function(x2, y2) {
      this._context.moveTo(y2, x2);
    },
    closePath: function() {
      this._context.closePath();
    },
    lineTo: function(x2, y2) {
      this._context.lineTo(y2, x2);
    },
    bezierCurveTo: function(x1, y1, x2, y2, x3, y3) {
      this._context.bezierCurveTo(y1, x1, y2, x2, y3, x3);
    }
  };
  function monotoneX(context) {
    return new MonotoneX(context);
  }
  function monotoneY(context) {
    return new MonotoneY(context);
  }
  function Natural(context) {
    this._context = context;
  }
  Natural.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x = [];
      this._y = [];
    },
    lineEnd: function() {
      var x2 = this._x, y2 = this._y, n = x2.length;
      if (n) {
        this._line ? this._context.lineTo(x2[0], y2[0]) : this._context.moveTo(x2[0], y2[0]);
        if (n === 2) {
          this._context.lineTo(x2[1], y2[1]);
        } else {
          var px = controlPoints(x2), py = controlPoints(y2);
          for (var i0 = 0, i1 = 1; i1 < n; ++i0, ++i1) {
            this._context.bezierCurveTo(px[0][i0], py[0][i0], px[1][i0], py[1][i0], x2[i1], y2[i1]);
          }
        }
      }
      if (this._line || this._line !== 0 && n === 1)
        this._context.closePath();
      this._line = 1 - this._line;
      this._x = this._y = null;
    },
    point: function(x2, y2) {
      this._x.push(+x2);
      this._y.push(+y2);
    }
  };
  function controlPoints(x2) {
    var i2, n = x2.length - 1, m, a = new Array(n), b = new Array(n), r = new Array(n);
    a[0] = 0, b[0] = 2, r[0] = x2[0] + 2 * x2[1];
    for (i2 = 1; i2 < n - 1; ++i2)
      a[i2] = 1, b[i2] = 4, r[i2] = 4 * x2[i2] + 2 * x2[i2 + 1];
    a[n - 1] = 2, b[n - 1] = 7, r[n - 1] = 8 * x2[n - 1] + x2[n];
    for (i2 = 1; i2 < n; ++i2)
      m = a[i2] / b[i2 - 1], b[i2] -= m, r[i2] -= m * r[i2 - 1];
    a[n - 1] = r[n - 1] / b[n - 1];
    for (i2 = n - 2; i2 >= 0; --i2)
      a[i2] = (r[i2] - a[i2 + 1]) / b[i2];
    b[n - 1] = (x2[n] + a[n - 1]) / 2;
    for (i2 = 0; i2 < n - 1; ++i2)
      b[i2] = 2 * x2[i2 + 1] - a[i2 + 1];
    return [a, b];
  }
  function curveNatural(context) {
    return new Natural(context);
  }
  function Step(context, t) {
    this._context = context;
    this._t = t;
  }
  Step.prototype = {
    areaStart: function() {
      this._line = 0;
    },
    areaEnd: function() {
      this._line = NaN;
    },
    lineStart: function() {
      this._x = this._y = NaN;
      this._point = 0;
    },
    lineEnd: function() {
      if (0 < this._t && this._t < 1 && this._point === 2)
        this._context.lineTo(this._x, this._y);
      if (this._line || this._line !== 0 && this._point === 1)
        this._context.closePath();
      if (this._line >= 0)
        this._t = 1 - this._t, this._line = 1 - this._line;
    },
    point: function(x2, y2) {
      x2 = +x2, y2 = +y2;
      switch (this._point) {
        case 0:
          this._point = 1;
          this._line ? this._context.lineTo(x2, y2) : this._context.moveTo(x2, y2);
          break;
        case 1:
          this._point = 2;
        default: {
          if (this._t <= 0) {
            this._context.lineTo(this._x, y2);
            this._context.lineTo(x2, y2);
          } else {
            var x1 = this._x * (1 - this._t) + x2 * this._t;
            this._context.lineTo(x1, this._y);
            this._context.lineTo(x1, y2);
          }
          break;
        }
      }
      this._x = x2, this._y = y2;
    }
  };
  function curveStep(context) {
    return new Step(context, 0.5);
  }
  function stepBefore(context) {
    return new Step(context, 0);
  }
  function stepAfter(context) {
    return new Step(context, 1);
  }
  function Transform(k, x2, y2) {
    this.k = k;
    this.x = x2;
    this.y = y2;
  }
  Transform.prototype = {
    constructor: Transform,
    scale: function(k) {
      return k === 1 ? this : new Transform(this.k * k, this.x, this.y);
    },
    translate: function(x2, y2) {
      return x2 === 0 & y2 === 0 ? this : new Transform(this.k, this.x + this.k * x2, this.y + this.k * y2);
    },
    apply: function(point2) {
      return [point2[0] * this.k + this.x, point2[1] * this.k + this.y];
    },
    applyX: function(x2) {
      return x2 * this.k + this.x;
    },
    applyY: function(y2) {
      return y2 * this.k + this.y;
    },
    invert: function(location2) {
      return [(location2[0] - this.x) / this.k, (location2[1] - this.y) / this.k];
    },
    invertX: function(x2) {
      return (x2 - this.x) / this.k;
    },
    invertY: function(y2) {
      return (y2 - this.y) / this.k;
    },
    rescaleX: function(x2) {
      return x2.copy().domain(x2.range().map(this.invertX, this).map(x2.invert, x2));
    },
    rescaleY: function(y2) {
      return y2.copy().domain(y2.range().map(this.invertY, this).map(y2.invert, y2));
    },
    toString: function() {
      return "translate(" + this.x + "," + this.y + ") scale(" + this.k + ")";
    }
  };
  Transform.prototype;
  /*! @license DOMPurify 3.0.5 | (c) Cure53 and other contributors | Released under the Apache license 2.0 and Mozilla Public License 2.0 | github.com/cure53/DOMPurify/blob/3.0.5/LICENSE */
  const {
    entries,
    setPrototypeOf,
    isFrozen,
    getPrototypeOf,
    getOwnPropertyDescriptor
  } = Object;
  let {
    freeze,
    seal,
    create
  } = Object;
  let {
    apply: apply$2,
    construct
  } = typeof Reflect !== "undefined" && Reflect;
  if (!apply$2) {
    apply$2 = function apply2(fun, thisValue, args) {
      return fun.apply(thisValue, args);
    };
  }
  if (!freeze) {
    freeze = function freeze2(x2) {
      return x2;
    };
  }
  if (!seal) {
    seal = function seal2(x2) {
      return x2;
    };
  }
  if (!construct) {
    construct = function construct2(Func, args) {
      return new Func(...args);
    };
  }
  const arrayForEach = unapply(Array.prototype.forEach);
  const arrayPop = unapply(Array.prototype.pop);
  const arrayPush$1 = unapply(Array.prototype.push);
  const stringToLowerCase = unapply(String.prototype.toLowerCase);
  const stringToString = unapply(String.prototype.toString);
  const stringMatch = unapply(String.prototype.match);
  const stringReplace = unapply(String.prototype.replace);
  const stringIndexOf = unapply(String.prototype.indexOf);
  const stringTrim = unapply(String.prototype.trim);
  const regExpTest = unapply(RegExp.prototype.test);
  const typeErrorCreate = unconstruct(TypeError);
  function unapply(func) {
    return function(thisArg) {
      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        args[_key - 1] = arguments[_key];
      }
      return apply$2(func, thisArg, args);
    };
  }
  function unconstruct(func) {
    return function() {
      for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {
        args[_key2] = arguments[_key2];
      }
      return construct(func, args);
    };
  }
  function addToSet(set2, array2, transformCaseFunc) {
    var _transformCaseFunc;
    transformCaseFunc = (_transformCaseFunc = transformCaseFunc) !== null && _transformCaseFunc !== void 0 ? _transformCaseFunc : stringToLowerCase;
    if (setPrototypeOf) {
      setPrototypeOf(set2, null);
    }
    let l = array2.length;
    while (l--) {
      let element2 = array2[l];
      if (typeof element2 === "string") {
        const lcElement = transformCaseFunc(element2);
        if (lcElement !== element2) {
          if (!isFrozen(array2)) {
            array2[l] = lcElement;
          }
          element2 = lcElement;
        }
      }
      set2[element2] = true;
    }
    return set2;
  }
  function clone$2(object2) {
    const newObject = create(null);
    for (const [property2, value2] of entries(object2)) {
      newObject[property2] = value2;
    }
    return newObject;
  }
  function lookupGetter(object2, prop) {
    while (object2 !== null) {
      const desc = getOwnPropertyDescriptor(object2, prop);
      if (desc) {
        if (desc.get) {
          return unapply(desc.get);
        }
        if (typeof desc.value === "function") {
          return unapply(desc.value);
        }
      }
      object2 = getPrototypeOf(object2);
    }
    function fallbackValue(element2) {
      console.warn("fallback value for", element2);
      return null;
    }
    return fallbackValue;
  }
  const html$1 = freeze(["a", "abbr", "acronym", "address", "area", "article", "aside", "audio", "b", "bdi", "bdo", "big", "blink", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "content", "data", "datalist", "dd", "decorator", "del", "details", "dfn", "dialog", "dir", "div", "dl", "dt", "element", "em", "fieldset", "figcaption", "figure", "font", "footer", "form", "h1", "h2", "h3", "h4", "h5", "h6", "head", "header", "hgroup", "hr", "html", "i", "img", "input", "ins", "kbd", "label", "legend", "li", "main", "map", "mark", "marquee", "menu", "menuitem", "meter", "nav", "nobr", "ol", "optgroup", "option", "output", "p", "picture", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "section", "select", "shadow", "small", "source", "spacer", "span", "strike", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "template", "textarea", "tfoot", "th", "thead", "time", "tr", "track", "tt", "u", "ul", "var", "video", "wbr"]);
  const svg$1 = freeze(["svg", "a", "altglyph", "altglyphdef", "altglyphitem", "animatecolor", "animatemotion", "animatetransform", "circle", "clippath", "defs", "desc", "ellipse", "filter", "font", "g", "glyph", "glyphref", "hkern", "image", "line", "lineargradient", "marker", "mask", "metadata", "mpath", "path", "pattern", "polygon", "polyline", "radialgradient", "rect", "stop", "style", "switch", "symbol", "text", "textpath", "title", "tref", "tspan", "view", "vkern"]);
  const svgFilters = freeze(["feBlend", "feColorMatrix", "feComponentTransfer", "feComposite", "feConvolveMatrix", "feDiffuseLighting", "feDisplacementMap", "feDistantLight", "feDropShadow", "feFlood", "feFuncA", "feFuncB", "feFuncG", "feFuncR", "feGaussianBlur", "feImage", "feMerge", "feMergeNode", "feMorphology", "feOffset", "fePointLight", "feSpecularLighting", "feSpotLight", "feTile", "feTurbulence"]);
  const svgDisallowed = freeze(["animate", "color-profile", "cursor", "discard", "font-face", "font-face-format", "font-face-name", "font-face-src", "font-face-uri", "foreignobject", "hatch", "hatchpath", "mesh", "meshgradient", "meshpatch", "meshrow", "missing-glyph", "script", "set", "solidcolor", "unknown", "use"]);
  const mathMl$1 = freeze(["math", "menclose", "merror", "mfenced", "mfrac", "mglyph", "mi", "mlabeledtr", "mmultiscripts", "mn", "mo", "mover", "mpadded", "mphantom", "mroot", "mrow", "ms", "mspace", "msqrt", "mstyle", "msub", "msup", "msubsup", "mtable", "mtd", "mtext", "mtr", "munder", "munderover", "mprescripts"]);
  const mathMlDisallowed = freeze(["maction", "maligngroup", "malignmark", "mlongdiv", "mscarries", "mscarry", "msgroup", "mstack", "msline", "msrow", "semantics", "annotation", "annotation-xml", "mprescripts", "none"]);
  const text$2 = freeze(["#text"]);
  const html = freeze(["accept", "action", "align", "alt", "autocapitalize", "autocomplete", "autopictureinpicture", "autoplay", "background", "bgcolor", "border", "capture", "cellpadding", "cellspacing", "checked", "cite", "class", "clear", "color", "cols", "colspan", "controls", "controlslist", "coords", "crossorigin", "datetime", "decoding", "default", "dir", "disabled", "disablepictureinpicture", "disableremoteplayback", "download", "draggable", "enctype", "enterkeyhint", "face", "for", "headers", "height", "hidden", "high", "href", "hreflang", "id", "inputmode", "integrity", "ismap", "kind", "label", "lang", "list", "loading", "loop", "low", "max", "maxlength", "media", "method", "min", "minlength", "multiple", "muted", "name", "nonce", "noshade", "novalidate", "nowrap", "open", "optimum", "pattern", "placeholder", "playsinline", "poster", "preload", "pubdate", "radiogroup", "readonly", "rel", "required", "rev", "reversed", "role", "rows", "rowspan", "spellcheck", "scope", "selected", "shape", "size", "sizes", "span", "srclang", "start", "src", "srcset", "step", "style", "summary", "tabindex", "title", "translate", "type", "usemap", "valign", "value", "width", "xmlns", "slot"]);
  const svg = freeze(["accent-height", "accumulate", "additive", "alignment-baseline", "ascent", "attributename", "attributetype", "azimuth", "basefrequency", "baseline-shift", "begin", "bias", "by", "class", "clip", "clippathunits", "clip-path", "clip-rule", "color", "color-interpolation", "color-interpolation-filters", "color-profile", "color-rendering", "cx", "cy", "d", "dx", "dy", "diffuseconstant", "direction", "display", "divisor", "dur", "edgemode", "elevation", "end", "fill", "fill-opacity", "fill-rule", "filter", "filterunits", "flood-color", "flood-opacity", "font-family", "font-size", "font-size-adjust", "font-stretch", "font-style", "font-variant", "font-weight", "fx", "fy", "g1", "g2", "glyph-name", "glyphref", "gradientunits", "gradienttransform", "height", "href", "id", "image-rendering", "in", "in2", "k", "k1", "k2", "k3", "k4", "kerning", "keypoints", "keysplines", "keytimes", "lang", "lengthadjust", "letter-spacing", "kernelmatrix", "kernelunitlength", "lighting-color", "local", "marker-end", "marker-mid", "marker-start", "markerheight", "markerunits", "markerwidth", "maskcontentunits", "maskunits", "max", "mask", "media", "method", "mode", "min", "name", "numoctaves", "offset", "operator", "opacity", "order", "orient", "orientation", "origin", "overflow", "paint-order", "path", "pathlength", "patterncontentunits", "patterntransform", "patternunits", "points", "preservealpha", "preserveaspectratio", "primitiveunits", "r", "rx", "ry", "radius", "refx", "refy", "repeatcount", "repeatdur", "restart", "result", "rotate", "scale", "seed", "shape-rendering", "specularconstant", "specularexponent", "spreadmethod", "startoffset", "stddeviation", "stitchtiles", "stop-color", "stop-opacity", "stroke-dasharray", "stroke-dashoffset", "stroke-linecap", "stroke-linejoin", "stroke-miterlimit", "stroke-opacity", "stroke", "stroke-width", "style", "surfacescale", "systemlanguage", "tabindex", "targetx", "targety", "transform", "transform-origin", "text-anchor", "text-decoration", "text-rendering", "textlength", "type", "u1", "u2", "unicode", "values", "viewbox", "visibility", "version", "vert-adv-y", "vert-origin-x", "vert-origin-y", "width", "word-spacing", "wrap", "writing-mode", "xchannelselector", "ychannelselector", "x", "x1", "x2", "xmlns", "y", "y1", "y2", "z", "zoomandpan"]);
  const mathMl = freeze(["accent", "accentunder", "align", "bevelled", "close", "columnsalign", "columnlines", "columnspan", "denomalign", "depth", "dir", "display", "displaystyle", "encoding", "fence", "frame", "height", "href", "id", "largeop", "length", "linethickness", "lspace", "lquote", "mathbackground", "mathcolor", "mathsize", "mathvariant", "maxsize", "minsize", "movablelimits", "notation", "numalign", "open", "rowalign", "rowlines", "rowspacing", "rowspan", "rspace", "rquote", "scriptlevel", "scriptminsize", "scriptsizemultiplier", "selection", "separator", "separators", "stretchy", "subscriptshift", "supscriptshift", "symmetric", "voffset", "width", "xmlns"]);
  const xml = freeze(["xlink:href", "xml:id", "xlink:title", "xml:space", "xmlns:xlink"]);
  const MUSTACHE_EXPR = seal(/\{\{[\w\W]*|[\w\W]*\}\}/gm);
  const ERB_EXPR = seal(/<%[\w\W]*|[\w\W]*%>/gm);
  const TMPLIT_EXPR = seal(/\${[\w\W]*}/gm);
  const DATA_ATTR = seal(/^data-[\-\w.\u00B7-\uFFFF]/);
  const ARIA_ATTR = seal(/^aria-[\-\w]+$/);
  const IS_ALLOWED_URI = seal(
    /^(?:(?:(?:f|ht)tps?|mailto|tel|callto|sms|cid|xmpp):|[^a-z]|[a-z+.\-]+(?:[^a-z+.\-:]|$))/i
    // eslint-disable-line no-useless-escape
  );
  const IS_SCRIPT_OR_DATA = seal(/^(?:\w+script|data):/i);
  const ATTR_WHITESPACE = seal(
    /[\u0000-\u0020\u00A0\u1680\u180E\u2000-\u2029\u205F\u3000]/g
    // eslint-disable-line no-control-regex
  );
  const DOCTYPE_NAME = seal(/^html$/i);
  var EXPRESSIONS = /* @__PURE__ */ Object.freeze({
    __proto__: null,
    MUSTACHE_EXPR,
    ERB_EXPR,
    TMPLIT_EXPR,
    DATA_ATTR,
    ARIA_ATTR,
    IS_ALLOWED_URI,
    IS_SCRIPT_OR_DATA,
    ATTR_WHITESPACE,
    DOCTYPE_NAME
  });
  const getGlobal = () => typeof window === "undefined" ? null : window;
  const _createTrustedTypesPolicy = function _createTrustedTypesPolicy2(trustedTypes, purifyHostElement) {
    if (typeof trustedTypes !== "object" || typeof trustedTypes.createPolicy !== "function") {
      return null;
    }
    let suffix = null;
    const ATTR_NAME = "data-tt-policy-suffix";
    if (purifyHostElement && purifyHostElement.hasAttribute(ATTR_NAME)) {
      suffix = purifyHostElement.getAttribute(ATTR_NAME);
    }
    const policyName = "dompurify" + (suffix ? "#" + suffix : "");
    try {
      return trustedTypes.createPolicy(policyName, {
        createHTML(html2) {
          return html2;
        },
        createScriptURL(scriptUrl) {
          return scriptUrl;
        }
      });
    } catch (_2) {
      console.warn("TrustedTypes policy " + policyName + " could not be created.");
      return null;
    }
  };
  function createDOMPurify() {
    let window2 = arguments.length > 0 && arguments[0] !== void 0 ? arguments[0] : getGlobal();
    const DOMPurify = (root2) => createDOMPurify(root2);
    DOMPurify.version = "3.0.5";
    DOMPurify.removed = [];
    if (!window2 || !window2.document || window2.document.nodeType !== 9) {
      DOMPurify.isSupported = false;
      return DOMPurify;
    }
    const originalDocument = window2.document;
    const currentScript = originalDocument.currentScript;
    let {
      document: document2
    } = window2;
    const {
      DocumentFragment,
      HTMLTemplateElement,
      Node,
      Element,
      NodeFilter,
      NamedNodeMap = window2.NamedNodeMap || window2.MozNamedAttrMap,
      HTMLFormElement,
      DOMParser: DOMParser2,
      trustedTypes
    } = window2;
    const ElementPrototype = Element.prototype;
    const cloneNode = lookupGetter(ElementPrototype, "cloneNode");
    const getNextSibling = lookupGetter(ElementPrototype, "nextSibling");
    const getChildNodes = lookupGetter(ElementPrototype, "childNodes");
    const getParentNode = lookupGetter(ElementPrototype, "parentNode");
    if (typeof HTMLTemplateElement === "function") {
      const template = document2.createElement("template");
      if (template.content && template.content.ownerDocument) {
        document2 = template.content.ownerDocument;
      }
    }
    let trustedTypesPolicy;
    let emptyHTML = "";
    const {
      implementation,
      createNodeIterator,
      createDocumentFragment,
      getElementsByTagName
    } = document2;
    const {
      importNode
    } = originalDocument;
    let hooks = {};
    DOMPurify.isSupported = typeof entries === "function" && typeof getParentNode === "function" && implementation && implementation.createHTMLDocument !== void 0;
    const {
      MUSTACHE_EXPR: MUSTACHE_EXPR2,
      ERB_EXPR: ERB_EXPR2,
      TMPLIT_EXPR: TMPLIT_EXPR2,
      DATA_ATTR: DATA_ATTR2,
      ARIA_ATTR: ARIA_ATTR2,
      IS_SCRIPT_OR_DATA: IS_SCRIPT_OR_DATA2,
      ATTR_WHITESPACE: ATTR_WHITESPACE2
    } = EXPRESSIONS;
    let {
      IS_ALLOWED_URI: IS_ALLOWED_URI$1
    } = EXPRESSIONS;
    let ALLOWED_TAGS = null;
    const DEFAULT_ALLOWED_TAGS = addToSet({}, [...html$1, ...svg$1, ...svgFilters, ...mathMl$1, ...text$2]);
    let ALLOWED_ATTR = null;
    const DEFAULT_ALLOWED_ATTR = addToSet({}, [...html, ...svg, ...mathMl, ...xml]);
    let CUSTOM_ELEMENT_HANDLING = Object.seal(Object.create(null, {
      tagNameCheck: {
        writable: true,
        configurable: false,
        enumerable: true,
        value: null
      },
      attributeNameCheck: {
        writable: true,
        configurable: false,
        enumerable: true,
        value: null
      },
      allowCustomizedBuiltInElements: {
        writable: true,
        configurable: false,
        enumerable: true,
        value: false
      }
    }));
    let FORBID_TAGS = null;
    let FORBID_ATTR = null;
    let ALLOW_ARIA_ATTR = true;
    let ALLOW_DATA_ATTR = true;
    let ALLOW_UNKNOWN_PROTOCOLS = false;
    let ALLOW_SELF_CLOSE_IN_ATTR = true;
    let SAFE_FOR_TEMPLATES = false;
    let WHOLE_DOCUMENT = false;
    let SET_CONFIG = false;
    let FORCE_BODY = false;
    let RETURN_DOM = false;
    let RETURN_DOM_FRAGMENT = false;
    let RETURN_TRUSTED_TYPE = false;
    let SANITIZE_DOM = true;
    let SANITIZE_NAMED_PROPS = false;
    const SANITIZE_NAMED_PROPS_PREFIX = "user-content-";
    let KEEP_CONTENT = true;
    let IN_PLACE = false;
    let USE_PROFILES = {};
    let FORBID_CONTENTS = null;
    const DEFAULT_FORBID_CONTENTS = addToSet({}, ["annotation-xml", "audio", "colgroup", "desc", "foreignobject", "head", "iframe", "math", "mi", "mn", "mo", "ms", "mtext", "noembed", "noframes", "noscript", "plaintext", "script", "style", "svg", "template", "thead", "title", "video", "xmp"]);
    let DATA_URI_TAGS = null;
    const DEFAULT_DATA_URI_TAGS = addToSet({}, ["audio", "video", "img", "source", "image", "track"]);
    let URI_SAFE_ATTRIBUTES = null;
    const DEFAULT_URI_SAFE_ATTRIBUTES = addToSet({}, ["alt", "class", "for", "id", "label", "name", "pattern", "placeholder", "role", "summary", "title", "value", "style", "xmlns"]);
    const MATHML_NAMESPACE = "http://www.w3.org/1998/Math/MathML";
    const SVG_NAMESPACE = "http://www.w3.org/2000/svg";
    const HTML_NAMESPACE = "http://www.w3.org/1999/xhtml";
    let NAMESPACE = HTML_NAMESPACE;
    let IS_EMPTY_INPUT = false;
    let ALLOWED_NAMESPACES = null;
    const DEFAULT_ALLOWED_NAMESPACES = addToSet({}, [MATHML_NAMESPACE, SVG_NAMESPACE, HTML_NAMESPACE], stringToString);
    let PARSER_MEDIA_TYPE;
    const SUPPORTED_PARSER_MEDIA_TYPES = ["application/xhtml+xml", "text/html"];
    const DEFAULT_PARSER_MEDIA_TYPE = "text/html";
    let transformCaseFunc;
    let CONFIG = null;
    const formElement = document2.createElement("form");
    const isRegexOrFunction = function isRegexOrFunction2(testValue) {
      return testValue instanceof RegExp || testValue instanceof Function;
    };
    const _parseConfig = function _parseConfig2(cfg) {
      if (CONFIG && CONFIG === cfg) {
        return;
      }
      if (!cfg || typeof cfg !== "object") {
        cfg = {};
      }
      cfg = clone$2(cfg);
      PARSER_MEDIA_TYPE = // eslint-disable-next-line unicorn/prefer-includes
      SUPPORTED_PARSER_MEDIA_TYPES.indexOf(cfg.PARSER_MEDIA_TYPE) === -1 ? PARSER_MEDIA_TYPE = DEFAULT_PARSER_MEDIA_TYPE : PARSER_MEDIA_TYPE = cfg.PARSER_MEDIA_TYPE;
      transformCaseFunc = PARSER_MEDIA_TYPE === "application/xhtml+xml" ? stringToString : stringToLowerCase;
      ALLOWED_TAGS = "ALLOWED_TAGS" in cfg ? addToSet({}, cfg.ALLOWED_TAGS, transformCaseFunc) : DEFAULT_ALLOWED_TAGS;
      ALLOWED_ATTR = "ALLOWED_ATTR" in cfg ? addToSet({}, cfg.ALLOWED_ATTR, transformCaseFunc) : DEFAULT_ALLOWED_ATTR;
      ALLOWED_NAMESPACES = "ALLOWED_NAMESPACES" in cfg ? addToSet({}, cfg.ALLOWED_NAMESPACES, stringToString) : DEFAULT_ALLOWED_NAMESPACES;
      URI_SAFE_ATTRIBUTES = "ADD_URI_SAFE_ATTR" in cfg ? addToSet(
        clone$2(DEFAULT_URI_SAFE_ATTRIBUTES),
        // eslint-disable-line indent
        cfg.ADD_URI_SAFE_ATTR,
        // eslint-disable-line indent
        transformCaseFunc
        // eslint-disable-line indent
      ) : DEFAULT_URI_SAFE_ATTRIBUTES;
      DATA_URI_TAGS = "ADD_DATA_URI_TAGS" in cfg ? addToSet(
        clone$2(DEFAULT_DATA_URI_TAGS),
        // eslint-disable-line indent
        cfg.ADD_DATA_URI_TAGS,
        // eslint-disable-line indent
        transformCaseFunc
        // eslint-disable-line indent
      ) : DEFAULT_DATA_URI_TAGS;
      FORBID_CONTENTS = "FORBID_CONTENTS" in cfg ? addToSet({}, cfg.FORBID_CONTENTS, transformCaseFunc) : DEFAULT_FORBID_CONTENTS;
      FORBID_TAGS = "FORBID_TAGS" in cfg ? addToSet({}, cfg.FORBID_TAGS, transformCaseFunc) : {};
      FORBID_ATTR = "FORBID_ATTR" in cfg ? addToSet({}, cfg.FORBID_ATTR, transformCaseFunc) : {};
      USE_PROFILES = "USE_PROFILES" in cfg ? cfg.USE_PROFILES : false;
      ALLOW_ARIA_ATTR = cfg.ALLOW_ARIA_ATTR !== false;
      ALLOW_DATA_ATTR = cfg.ALLOW_DATA_ATTR !== false;
      ALLOW_UNKNOWN_PROTOCOLS = cfg.ALLOW_UNKNOWN_PROTOCOLS || false;
      ALLOW_SELF_CLOSE_IN_ATTR = cfg.ALLOW_SELF_CLOSE_IN_ATTR !== false;
      SAFE_FOR_TEMPLATES = cfg.SAFE_FOR_TEMPLATES || false;
      WHOLE_DOCUMENT = cfg.WHOLE_DOCUMENT || false;
      RETURN_DOM = cfg.RETURN_DOM || false;
      RETURN_DOM_FRAGMENT = cfg.RETURN_DOM_FRAGMENT || false;
      RETURN_TRUSTED_TYPE = cfg.RETURN_TRUSTED_TYPE || false;
      FORCE_BODY = cfg.FORCE_BODY || false;
      SANITIZE_DOM = cfg.SANITIZE_DOM !== false;
      SANITIZE_NAMED_PROPS = cfg.SANITIZE_NAMED_PROPS || false;
      KEEP_CONTENT = cfg.KEEP_CONTENT !== false;
      IN_PLACE = cfg.IN_PLACE || false;
      IS_ALLOWED_URI$1 = cfg.ALLOWED_URI_REGEXP || IS_ALLOWED_URI;
      NAMESPACE = cfg.NAMESPACE || HTML_NAMESPACE;
      CUSTOM_ELEMENT_HANDLING = cfg.CUSTOM_ELEMENT_HANDLING || {};
      if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck)) {
        CUSTOM_ELEMENT_HANDLING.tagNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.tagNameCheck;
      }
      if (cfg.CUSTOM_ELEMENT_HANDLING && isRegexOrFunction(cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck)) {
        CUSTOM_ELEMENT_HANDLING.attributeNameCheck = cfg.CUSTOM_ELEMENT_HANDLING.attributeNameCheck;
      }
      if (cfg.CUSTOM_ELEMENT_HANDLING && typeof cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements === "boolean") {
        CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements = cfg.CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements;
      }
      if (SAFE_FOR_TEMPLATES) {
        ALLOW_DATA_ATTR = false;
      }
      if (RETURN_DOM_FRAGMENT) {
        RETURN_DOM = true;
      }
      if (USE_PROFILES) {
        ALLOWED_TAGS = addToSet({}, [...text$2]);
        ALLOWED_ATTR = [];
        if (USE_PROFILES.html === true) {
          addToSet(ALLOWED_TAGS, html$1);
          addToSet(ALLOWED_ATTR, html);
        }
        if (USE_PROFILES.svg === true) {
          addToSet(ALLOWED_TAGS, svg$1);
          addToSet(ALLOWED_ATTR, svg);
          addToSet(ALLOWED_ATTR, xml);
        }
        if (USE_PROFILES.svgFilters === true) {
          addToSet(ALLOWED_TAGS, svgFilters);
          addToSet(ALLOWED_ATTR, svg);
          addToSet(ALLOWED_ATTR, xml);
        }
        if (USE_PROFILES.mathMl === true) {
          addToSet(ALLOWED_TAGS, mathMl$1);
          addToSet(ALLOWED_ATTR, mathMl);
          addToSet(ALLOWED_ATTR, xml);
        }
      }
      if (cfg.ADD_TAGS) {
        if (ALLOWED_TAGS === DEFAULT_ALLOWED_TAGS) {
          ALLOWED_TAGS = clone$2(ALLOWED_TAGS);
        }
        addToSet(ALLOWED_TAGS, cfg.ADD_TAGS, transformCaseFunc);
      }
      if (cfg.ADD_ATTR) {
        if (ALLOWED_ATTR === DEFAULT_ALLOWED_ATTR) {
          ALLOWED_ATTR = clone$2(ALLOWED_ATTR);
        }
        addToSet(ALLOWED_ATTR, cfg.ADD_ATTR, transformCaseFunc);
      }
      if (cfg.ADD_URI_SAFE_ATTR) {
        addToSet(URI_SAFE_ATTRIBUTES, cfg.ADD_URI_SAFE_ATTR, transformCaseFunc);
      }
      if (cfg.FORBID_CONTENTS) {
        if (FORBID_CONTENTS === DEFAULT_FORBID_CONTENTS) {
          FORBID_CONTENTS = clone$2(FORBID_CONTENTS);
        }
        addToSet(FORBID_CONTENTS, cfg.FORBID_CONTENTS, transformCaseFunc);
      }
      if (KEEP_CONTENT) {
        ALLOWED_TAGS["#text"] = true;
      }
      if (WHOLE_DOCUMENT) {
        addToSet(ALLOWED_TAGS, ["html", "head", "body"]);
      }
      if (ALLOWED_TAGS.table) {
        addToSet(ALLOWED_TAGS, ["tbody"]);
        delete FORBID_TAGS.tbody;
      }
      if (cfg.TRUSTED_TYPES_POLICY) {
        if (typeof cfg.TRUSTED_TYPES_POLICY.createHTML !== "function") {
          throw typeErrorCreate('TRUSTED_TYPES_POLICY configuration option must provide a "createHTML" hook.');
        }
        if (typeof cfg.TRUSTED_TYPES_POLICY.createScriptURL !== "function") {
          throw typeErrorCreate('TRUSTED_TYPES_POLICY configuration option must provide a "createScriptURL" hook.');
        }
        trustedTypesPolicy = cfg.TRUSTED_TYPES_POLICY;
        emptyHTML = trustedTypesPolicy.createHTML("");
      } else {
        if (trustedTypesPolicy === void 0) {
          trustedTypesPolicy = _createTrustedTypesPolicy(trustedTypes, currentScript);
        }
        if (trustedTypesPolicy !== null && typeof emptyHTML === "string") {
          emptyHTML = trustedTypesPolicy.createHTML("");
        }
      }
      if (freeze) {
        freeze(cfg);
      }
      CONFIG = cfg;
    };
    const MATHML_TEXT_INTEGRATION_POINTS = addToSet({}, ["mi", "mo", "mn", "ms", "mtext"]);
    const HTML_INTEGRATION_POINTS = addToSet({}, ["foreignobject", "desc", "title", "annotation-xml"]);
    const COMMON_SVG_AND_HTML_ELEMENTS = addToSet({}, ["title", "style", "font", "a", "script"]);
    const ALL_SVG_TAGS = addToSet({}, svg$1);
    addToSet(ALL_SVG_TAGS, svgFilters);
    addToSet(ALL_SVG_TAGS, svgDisallowed);
    const ALL_MATHML_TAGS = addToSet({}, mathMl$1);
    addToSet(ALL_MATHML_TAGS, mathMlDisallowed);
    const _checkValidNamespace = function _checkValidNamespace2(element2) {
      let parent = getParentNode(element2);
      if (!parent || !parent.tagName) {
        parent = {
          namespaceURI: NAMESPACE,
          tagName: "template"
        };
      }
      const tagName = stringToLowerCase(element2.tagName);
      const parentTagName = stringToLowerCase(parent.tagName);
      if (!ALLOWED_NAMESPACES[element2.namespaceURI]) {
        return false;
      }
      if (element2.namespaceURI === SVG_NAMESPACE) {
        if (parent.namespaceURI === HTML_NAMESPACE) {
          return tagName === "svg";
        }
        if (parent.namespaceURI === MATHML_NAMESPACE) {
          return tagName === "svg" && (parentTagName === "annotation-xml" || MATHML_TEXT_INTEGRATION_POINTS[parentTagName]);
        }
        return Boolean(ALL_SVG_TAGS[tagName]);
      }
      if (element2.namespaceURI === MATHML_NAMESPACE) {
        if (parent.namespaceURI === HTML_NAMESPACE) {
          return tagName === "math";
        }
        if (parent.namespaceURI === SVG_NAMESPACE) {
          return tagName === "math" && HTML_INTEGRATION_POINTS[parentTagName];
        }
        return Boolean(ALL_MATHML_TAGS[tagName]);
      }
      if (element2.namespaceURI === HTML_NAMESPACE) {
        if (parent.namespaceURI === SVG_NAMESPACE && !HTML_INTEGRATION_POINTS[parentTagName]) {
          return false;
        }
        if (parent.namespaceURI === MATHML_NAMESPACE && !MATHML_TEXT_INTEGRATION_POINTS[parentTagName]) {
          return false;
        }
        return !ALL_MATHML_TAGS[tagName] && (COMMON_SVG_AND_HTML_ELEMENTS[tagName] || !ALL_SVG_TAGS[tagName]);
      }
      if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && ALLOWED_NAMESPACES[element2.namespaceURI]) {
        return true;
      }
      return false;
    };
    const _forceRemove = function _forceRemove2(node2) {
      arrayPush$1(DOMPurify.removed, {
        element: node2
      });
      try {
        node2.parentNode.removeChild(node2);
      } catch (_2) {
        node2.remove();
      }
    };
    const _removeAttribute = function _removeAttribute2(name, node2) {
      try {
        arrayPush$1(DOMPurify.removed, {
          attribute: node2.getAttributeNode(name),
          from: node2
        });
      } catch (_2) {
        arrayPush$1(DOMPurify.removed, {
          attribute: null,
          from: node2
        });
      }
      node2.removeAttribute(name);
      if (name === "is" && !ALLOWED_ATTR[name]) {
        if (RETURN_DOM || RETURN_DOM_FRAGMENT) {
          try {
            _forceRemove(node2);
          } catch (_2) {
          }
        } else {
          try {
            node2.setAttribute(name, "");
          } catch (_2) {
          }
        }
      }
    };
    const _initDocument = function _initDocument2(dirty) {
      let doc;
      let leadingWhitespace;
      if (FORCE_BODY) {
        dirty = "<remove></remove>" + dirty;
      } else {
        const matches = stringMatch(dirty, /^[\r\n\t ]+/);
        leadingWhitespace = matches && matches[0];
      }
      if (PARSER_MEDIA_TYPE === "application/xhtml+xml" && NAMESPACE === HTML_NAMESPACE) {
        dirty = '<html xmlns="http://www.w3.org/1999/xhtml"><head></head><body>' + dirty + "</body></html>";
      }
      const dirtyPayload = trustedTypesPolicy ? trustedTypesPolicy.createHTML(dirty) : dirty;
      if (NAMESPACE === HTML_NAMESPACE) {
        try {
          doc = new DOMParser2().parseFromString(dirtyPayload, PARSER_MEDIA_TYPE);
        } catch (_2) {
        }
      }
      if (!doc || !doc.documentElement) {
        doc = implementation.createDocument(NAMESPACE, "template", null);
        try {
          doc.documentElement.innerHTML = IS_EMPTY_INPUT ? emptyHTML : dirtyPayload;
        } catch (_2) {
        }
      }
      const body = doc.body || doc.documentElement;
      if (dirty && leadingWhitespace) {
        body.insertBefore(document2.createTextNode(leadingWhitespace), body.childNodes[0] || null);
      }
      if (NAMESPACE === HTML_NAMESPACE) {
        return getElementsByTagName.call(doc, WHOLE_DOCUMENT ? "html" : "body")[0];
      }
      return WHOLE_DOCUMENT ? doc.documentElement : body;
    };
    const _createIterator = function _createIterator2(root2) {
      return createNodeIterator.call(
        root2.ownerDocument || root2,
        root2,
        // eslint-disable-next-line no-bitwise
        NodeFilter.SHOW_ELEMENT | NodeFilter.SHOW_COMMENT | NodeFilter.SHOW_TEXT,
        null,
        false
      );
    };
    const _isClobbered = function _isClobbered2(elm) {
      return elm instanceof HTMLFormElement && (typeof elm.nodeName !== "string" || typeof elm.textContent !== "string" || typeof elm.removeChild !== "function" || !(elm.attributes instanceof NamedNodeMap) || typeof elm.removeAttribute !== "function" || typeof elm.setAttribute !== "function" || typeof elm.namespaceURI !== "string" || typeof elm.insertBefore !== "function" || typeof elm.hasChildNodes !== "function");
    };
    const _isNode = function _isNode2(object2) {
      return typeof Node === "object" ? object2 instanceof Node : object2 && typeof object2 === "object" && typeof object2.nodeType === "number" && typeof object2.nodeName === "string";
    };
    const _executeHook = function _executeHook2(entryPoint, currentNode, data) {
      if (!hooks[entryPoint]) {
        return;
      }
      arrayForEach(hooks[entryPoint], (hook) => {
        hook.call(DOMPurify, currentNode, data, CONFIG);
      });
    };
    const _sanitizeElements = function _sanitizeElements2(currentNode) {
      let content2;
      _executeHook("beforeSanitizeElements", currentNode, null);
      if (_isClobbered(currentNode)) {
        _forceRemove(currentNode);
        return true;
      }
      const tagName = transformCaseFunc(currentNode.nodeName);
      _executeHook("uponSanitizeElement", currentNode, {
        tagName,
        allowedTags: ALLOWED_TAGS
      });
      if (currentNode.hasChildNodes() && !_isNode(currentNode.firstElementChild) && (!_isNode(currentNode.content) || !_isNode(currentNode.content.firstElementChild)) && regExpTest(/<[/\w]/g, currentNode.innerHTML) && regExpTest(/<[/\w]/g, currentNode.textContent)) {
        _forceRemove(currentNode);
        return true;
      }
      if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
        if (!FORBID_TAGS[tagName] && _basicCustomElementTest(tagName)) {
          if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, tagName))
            return false;
          if (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(tagName))
            return false;
        }
        if (KEEP_CONTENT && !FORBID_CONTENTS[tagName]) {
          const parentNode = getParentNode(currentNode) || currentNode.parentNode;
          const childNodes = getChildNodes(currentNode) || currentNode.childNodes;
          if (childNodes && parentNode) {
            const childCount = childNodes.length;
            for (let i2 = childCount - 1; i2 >= 0; --i2) {
              parentNode.insertBefore(cloneNode(childNodes[i2], true), getNextSibling(currentNode));
            }
          }
        }
        _forceRemove(currentNode);
        return true;
      }
      if (currentNode instanceof Element && !_checkValidNamespace(currentNode)) {
        _forceRemove(currentNode);
        return true;
      }
      if ((tagName === "noscript" || tagName === "noembed" || tagName === "noframes") && regExpTest(/<\/no(script|embed|frames)/i, currentNode.innerHTML)) {
        _forceRemove(currentNode);
        return true;
      }
      if (SAFE_FOR_TEMPLATES && currentNode.nodeType === 3) {
        content2 = currentNode.textContent;
        content2 = stringReplace(content2, MUSTACHE_EXPR2, " ");
        content2 = stringReplace(content2, ERB_EXPR2, " ");
        content2 = stringReplace(content2, TMPLIT_EXPR2, " ");
        if (currentNode.textContent !== content2) {
          arrayPush$1(DOMPurify.removed, {
            element: currentNode.cloneNode()
          });
          currentNode.textContent = content2;
        }
      }
      _executeHook("afterSanitizeElements", currentNode, null);
      return false;
    };
    const _isValidAttribute = function _isValidAttribute2(lcTag, lcName, value2) {
      if (SANITIZE_DOM && (lcName === "id" || lcName === "name") && (value2 in document2 || value2 in formElement)) {
        return false;
      }
      if (ALLOW_DATA_ATTR && !FORBID_ATTR[lcName] && regExpTest(DATA_ATTR2, lcName))
        ;
      else if (ALLOW_ARIA_ATTR && regExpTest(ARIA_ATTR2, lcName))
        ;
      else if (!ALLOWED_ATTR[lcName] || FORBID_ATTR[lcName]) {
        if (
          // First condition does a very basic check if a) it's basically a valid custom element tagname AND
          // b) if the tagName passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
          // and c) if the attribute name passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.attributeNameCheck
          _basicCustomElementTest(lcTag) && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, lcTag) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(lcTag)) && (CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.attributeNameCheck, lcName) || CUSTOM_ELEMENT_HANDLING.attributeNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.attributeNameCheck(lcName)) || // Alternative, second condition checks if it's an `is`-attribute, AND
          // the value passes whatever the user has configured for CUSTOM_ELEMENT_HANDLING.tagNameCheck
          lcName === "is" && CUSTOM_ELEMENT_HANDLING.allowCustomizedBuiltInElements && (CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof RegExp && regExpTest(CUSTOM_ELEMENT_HANDLING.tagNameCheck, value2) || CUSTOM_ELEMENT_HANDLING.tagNameCheck instanceof Function && CUSTOM_ELEMENT_HANDLING.tagNameCheck(value2))
        )
          ;
        else {
          return false;
        }
      } else if (URI_SAFE_ATTRIBUTES[lcName])
        ;
      else if (regExpTest(IS_ALLOWED_URI$1, stringReplace(value2, ATTR_WHITESPACE2, "")))
        ;
      else if ((lcName === "src" || lcName === "xlink:href" || lcName === "href") && lcTag !== "script" && stringIndexOf(value2, "data:") === 0 && DATA_URI_TAGS[lcTag])
        ;
      else if (ALLOW_UNKNOWN_PROTOCOLS && !regExpTest(IS_SCRIPT_OR_DATA2, stringReplace(value2, ATTR_WHITESPACE2, "")))
        ;
      else if (value2) {
        return false;
      } else
        ;
      return true;
    };
    const _basicCustomElementTest = function _basicCustomElementTest2(tagName) {
      return tagName.indexOf("-") > 0;
    };
    const _sanitizeAttributes = function _sanitizeAttributes2(currentNode) {
      let attr;
      let value2;
      let lcName;
      let l;
      _executeHook("beforeSanitizeAttributes", currentNode, null);
      const {
        attributes
      } = currentNode;
      if (!attributes) {
        return;
      }
      const hookEvent = {
        attrName: "",
        attrValue: "",
        keepAttr: true,
        allowedAttributes: ALLOWED_ATTR
      };
      l = attributes.length;
      while (l--) {
        attr = attributes[l];
        const {
          name,
          namespaceURI
        } = attr;
        value2 = name === "value" ? attr.value : stringTrim(attr.value);
        lcName = transformCaseFunc(name);
        hookEvent.attrName = lcName;
        hookEvent.attrValue = value2;
        hookEvent.keepAttr = true;
        hookEvent.forceKeepAttr = void 0;
        _executeHook("uponSanitizeAttribute", currentNode, hookEvent);
        value2 = hookEvent.attrValue;
        if (hookEvent.forceKeepAttr) {
          continue;
        }
        _removeAttribute(name, currentNode);
        if (!hookEvent.keepAttr) {
          continue;
        }
        if (!ALLOW_SELF_CLOSE_IN_ATTR && regExpTest(/\/>/i, value2)) {
          _removeAttribute(name, currentNode);
          continue;
        }
        if (SAFE_FOR_TEMPLATES) {
          value2 = stringReplace(value2, MUSTACHE_EXPR2, " ");
          value2 = stringReplace(value2, ERB_EXPR2, " ");
          value2 = stringReplace(value2, TMPLIT_EXPR2, " ");
        }
        const lcTag = transformCaseFunc(currentNode.nodeName);
        if (!_isValidAttribute(lcTag, lcName, value2)) {
          continue;
        }
        if (SANITIZE_NAMED_PROPS && (lcName === "id" || lcName === "name")) {
          _removeAttribute(name, currentNode);
          value2 = SANITIZE_NAMED_PROPS_PREFIX + value2;
        }
        if (trustedTypesPolicy && typeof trustedTypes === "object" && typeof trustedTypes.getAttributeType === "function") {
          if (namespaceURI)
            ;
          else {
            switch (trustedTypes.getAttributeType(lcTag, lcName)) {
              case "TrustedHTML": {
                value2 = trustedTypesPolicy.createHTML(value2);
                break;
              }
              case "TrustedScriptURL": {
                value2 = trustedTypesPolicy.createScriptURL(value2);
                break;
              }
            }
          }
        }
        try {
          if (namespaceURI) {
            currentNode.setAttributeNS(namespaceURI, name, value2);
          } else {
            currentNode.setAttribute(name, value2);
          }
          arrayPop(DOMPurify.removed);
        } catch (_2) {
        }
      }
      _executeHook("afterSanitizeAttributes", currentNode, null);
    };
    const _sanitizeShadowDOM = function _sanitizeShadowDOM2(fragment) {
      let shadowNode;
      const shadowIterator = _createIterator(fragment);
      _executeHook("beforeSanitizeShadowDOM", fragment, null);
      while (shadowNode = shadowIterator.nextNode()) {
        _executeHook("uponSanitizeShadowNode", shadowNode, null);
        if (_sanitizeElements(shadowNode)) {
          continue;
        }
        if (shadowNode.content instanceof DocumentFragment) {
          _sanitizeShadowDOM2(shadowNode.content);
        }
        _sanitizeAttributes(shadowNode);
      }
      _executeHook("afterSanitizeShadowDOM", fragment, null);
    };
    DOMPurify.sanitize = function(dirty) {
      let cfg = arguments.length > 1 && arguments[1] !== void 0 ? arguments[1] : {};
      let body;
      let importedNode;
      let currentNode;
      let returnNode;
      IS_EMPTY_INPUT = !dirty;
      if (IS_EMPTY_INPUT) {
        dirty = "<!-->";
      }
      if (typeof dirty !== "string" && !_isNode(dirty)) {
        if (typeof dirty.toString === "function") {
          dirty = dirty.toString();
          if (typeof dirty !== "string") {
            throw typeErrorCreate("dirty is not a string, aborting");
          }
        } else {
          throw typeErrorCreate("toString is not a function");
        }
      }
      if (!DOMPurify.isSupported) {
        return dirty;
      }
      if (!SET_CONFIG) {
        _parseConfig(cfg);
      }
      DOMPurify.removed = [];
      if (typeof dirty === "string") {
        IN_PLACE = false;
      }
      if (IN_PLACE) {
        if (dirty.nodeName) {
          const tagName = transformCaseFunc(dirty.nodeName);
          if (!ALLOWED_TAGS[tagName] || FORBID_TAGS[tagName]) {
            throw typeErrorCreate("root node is forbidden and cannot be sanitized in-place");
          }
        }
      } else if (dirty instanceof Node) {
        body = _initDocument("<!---->");
        importedNode = body.ownerDocument.importNode(dirty, true);
        if (importedNode.nodeType === 1 && importedNode.nodeName === "BODY") {
          body = importedNode;
        } else if (importedNode.nodeName === "HTML") {
          body = importedNode;
        } else {
          body.appendChild(importedNode);
        }
      } else {
        if (!RETURN_DOM && !SAFE_FOR_TEMPLATES && !WHOLE_DOCUMENT && // eslint-disable-next-line unicorn/prefer-includes
        dirty.indexOf("<") === -1) {
          return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(dirty) : dirty;
        }
        body = _initDocument(dirty);
        if (!body) {
          return RETURN_DOM ? null : RETURN_TRUSTED_TYPE ? emptyHTML : "";
        }
      }
      if (body && FORCE_BODY) {
        _forceRemove(body.firstChild);
      }
      const nodeIterator = _createIterator(IN_PLACE ? dirty : body);
      while (currentNode = nodeIterator.nextNode()) {
        if (_sanitizeElements(currentNode)) {
          continue;
        }
        if (currentNode.content instanceof DocumentFragment) {
          _sanitizeShadowDOM(currentNode.content);
        }
        _sanitizeAttributes(currentNode);
      }
      if (IN_PLACE) {
        return dirty;
      }
      if (RETURN_DOM) {
        if (RETURN_DOM_FRAGMENT) {
          returnNode = createDocumentFragment.call(body.ownerDocument);
          while (body.firstChild) {
            returnNode.appendChild(body.firstChild);
          }
        } else {
          returnNode = body;
        }
        if (ALLOWED_ATTR.shadowroot || ALLOWED_ATTR.shadowrootmode) {
          returnNode = importNode.call(originalDocument, returnNode, true);
        }
        return returnNode;
      }
      let serializedHTML = WHOLE_DOCUMENT ? body.outerHTML : body.innerHTML;
      if (WHOLE_DOCUMENT && ALLOWED_TAGS["!doctype"] && body.ownerDocument && body.ownerDocument.doctype && body.ownerDocument.doctype.name && regExpTest(DOCTYPE_NAME, body.ownerDocument.doctype.name)) {
        serializedHTML = "<!DOCTYPE " + body.ownerDocument.doctype.name + ">\n" + serializedHTML;
      }
      if (SAFE_FOR_TEMPLATES) {
        serializedHTML = stringReplace(serializedHTML, MUSTACHE_EXPR2, " ");
        serializedHTML = stringReplace(serializedHTML, ERB_EXPR2, " ");
        serializedHTML = stringReplace(serializedHTML, TMPLIT_EXPR2, " ");
      }
      return trustedTypesPolicy && RETURN_TRUSTED_TYPE ? trustedTypesPolicy.createHTML(serializedHTML) : serializedHTML;
    };
    DOMPurify.setConfig = function(cfg) {
      _parseConfig(cfg);
      SET_CONFIG = true;
    };
    DOMPurify.clearConfig = function() {
      CONFIG = null;
      SET_CONFIG = false;
    };
    DOMPurify.isValidAttribute = function(tag, attr, value2) {
      if (!CONFIG) {
        _parseConfig({});
      }
      const lcTag = transformCaseFunc(tag);
      const lcName = transformCaseFunc(attr);
      return _isValidAttribute(lcTag, lcName, value2);
    };
    DOMPurify.addHook = function(entryPoint, hookFunction) {
      if (typeof hookFunction !== "function") {
        return;
      }
      hooks[entryPoint] = hooks[entryPoint] || [];
      arrayPush$1(hooks[entryPoint], hookFunction);
    };
    DOMPurify.removeHook = function(entryPoint) {
      if (hooks[entryPoint]) {
        return arrayPop(hooks[entryPoint]);
      }
    };
    DOMPurify.removeHooks = function(entryPoint) {
      if (hooks[entryPoint]) {
        hooks[entryPoint] = [];
      }
    };
    DOMPurify.removeAllHooks = function() {
      hooks = {};
    };
    return DOMPurify;
  }
  var purify = createDOMPurify();
  const lineBreakRegex = /<br\s*\/?>/gi;
  const getRows = (s) => {
    if (!s) {
      return [""];
    }
    const str2 = breakToPlaceholder(s).replace(/\\n/g, "#br#");
    return str2.split("#br#");
  };
  const setupDompurifyHooksIfNotSetup = (() => {
    let setup = false;
    return () => {
      if (!setup) {
        setupDompurifyHooks();
        setup = true;
      }
    };
  })();
  function setupDompurifyHooks() {
    const TEMPORARY_ATTRIBUTE = "data-temp-href-target";
    purify.addHook("beforeSanitizeAttributes", (node2) => {
      if (node2.tagName === "A" && node2.hasAttribute("target")) {
        node2.setAttribute(TEMPORARY_ATTRIBUTE, node2.getAttribute("target") || "");
      }
    });
    purify.addHook("afterSanitizeAttributes", (node2) => {
      if (node2.tagName === "A" && node2.hasAttribute(TEMPORARY_ATTRIBUTE)) {
        node2.setAttribute("target", node2.getAttribute(TEMPORARY_ATTRIBUTE) || "");
        node2.removeAttribute(TEMPORARY_ATTRIBUTE);
        if (node2.getAttribute("target") === "_blank") {
          node2.setAttribute("rel", "noopener");
        }
      }
    });
  }
  const removeScript = (txt) => {
    setupDompurifyHooksIfNotSetup();
    const sanitizedText = purify.sanitize(txt);
    return sanitizedText;
  };
  const sanitizeMore = (text2, config2) => {
    var _a2;
    if (((_a2 = config2.flowchart) == null ? void 0 : _a2.htmlLabels) !== false) {
      const level = config2.securityLevel;
      if (level === "antiscript" || level === "strict") {
        text2 = removeScript(text2);
      } else if (level !== "loose") {
        text2 = breakToPlaceholder(text2);
        text2 = text2.replace(/</g, "&lt;").replace(/>/g, "&gt;");
        text2 = text2.replace(/=/g, "&equals;");
        text2 = placeholderToBreak(text2);
      }
    }
    return text2;
  };
  const sanitizeText$5 = (text2, config2) => {
    if (!text2) {
      return text2;
    }
    if (config2.dompurifyConfig) {
      text2 = purify.sanitize(sanitizeMore(text2, config2), config2.dompurifyConfig).toString();
    } else {
      text2 = purify.sanitize(sanitizeMore(text2, config2), {
        FORBID_TAGS: ["style"]
      }).toString();
    }
    return text2;
  };
  const sanitizeTextOrArray = (a, config2) => {
    if (typeof a === "string") {
      return sanitizeText$5(a, config2);
    }
    return a.flat().map((x2) => sanitizeText$5(x2, config2));
  };
  const hasBreaks = (text2) => {
    return lineBreakRegex.test(text2);
  };
  const splitBreaks = (text2) => {
    return text2.split(lineBreakRegex);
  };
  const placeholderToBreak = (s) => {
    return s.replace(/#br#/g, "<br/>");
  };
  const breakToPlaceholder = (s) => {
    return s.replace(lineBreakRegex, "#br#");
  };
  const getUrl = (useAbsolute) => {
    let url = "";
    if (useAbsolute) {
      url = window.location.protocol + "//" + window.location.host + window.location.pathname + window.location.search;
      url = url.replaceAll(/\(/g, "\\(");
      url = url.replaceAll(/\)/g, "\\)");
    }
    return url;
  };
  const evaluate = (val) => val === false || ["false", "null", "0"].includes(String(val).trim().toLowerCase()) ? false : true;
  const getMax = function(...values2) {
    const newValues = values2.filter((value2) => {
      return !isNaN(value2);
    });
    return Math.max(...newValues);
  };
  const getMin = function(...values2) {
    const newValues = values2.filter((value2) => {
      return !isNaN(value2);
    });
    return Math.min(...newValues);
  };
  const parseGenericTypes = function(input) {
    const inputSets = input.split(/(,)/);
    const output = [];
    for (let i2 = 0; i2 < inputSets.length; i2++) {
      let thisSet = inputSets[i2];
      if (thisSet === "," && i2 > 0 && i2 + 1 < inputSets.length) {
        const previousSet = inputSets[i2 - 1];
        const nextSet = inputSets[i2 + 1];
        if (shouldCombineSets(previousSet, nextSet)) {
          thisSet = previousSet + "," + nextSet;
          i2++;
          output.pop();
        }
      }
      output.push(processSet(thisSet));
    }
    return output.join("");
  };
  const countOccurrence = (string2, substring) => {
    return Math.max(0, string2.split(substring).length - 1);
  };
  const shouldCombineSets = (previousSet, nextSet) => {
    const prevCount = countOccurrence(previousSet, "~");
    const nextCount = countOccurrence(nextSet, "~");
    return prevCount === 1 && nextCount === 1;
  };
  const processSet = (input) => {
    const tildeCount = countOccurrence(input, "~");
    let hasStartingTilde = false;
    if (tildeCount <= 1) {
      return input;
    }
    if (tildeCount % 2 !== 0 && input.startsWith("~")) {
      input = input.substring(1);
      hasStartingTilde = true;
    }
    const chars = [...input];
    let first = chars.indexOf("~");
    let last2 = chars.lastIndexOf("~");
    while (first !== -1 && last2 !== -1 && first !== last2) {
      chars[first] = "<";
      chars[last2] = ">";
      first = chars.indexOf("~");
      last2 = chars.lastIndexOf("~");
    }
    if (hasStartingTilde) {
      chars.unshift("~");
    }
    return chars.join("");
  };
  const common$1 = {
    getRows,
    sanitizeText: sanitizeText$5,
    sanitizeTextOrArray,
    hasBreaks,
    splitBreaks,
    lineBreakRegex,
    removeScript,
    getUrl,
    evaluate,
    getMax,
    getMin
  };
  const Channel = {
    /* CLAMP */
    min: {
      r: 0,
      g: 0,
      b: 0,
      s: 0,
      l: 0,
      a: 0
    },
    max: {
      r: 255,
      g: 255,
      b: 255,
      h: 360,
      s: 100,
      l: 100,
      a: 1
    },
    clamp: {
      r: (r) => r >= 255 ? 255 : r < 0 ? 0 : r,
      g: (g) => g >= 255 ? 255 : g < 0 ? 0 : g,
      b: (b) => b >= 255 ? 255 : b < 0 ? 0 : b,
      h: (h) => h % 360,
      s: (s) => s >= 100 ? 100 : s < 0 ? 0 : s,
      l: (l) => l >= 100 ? 100 : l < 0 ? 0 : l,
      a: (a) => a >= 1 ? 1 : a < 0 ? 0 : a
    },
    /* CONVERSION */
    //SOURCE: https://planetcalc.com/7779
    toLinear: (c2) => {
      const n = c2 / 255;
      return c2 > 0.03928 ? Math.pow((n + 0.055) / 1.055, 2.4) : n / 12.92;
    },
    //SOURCE: https://gist.github.com/mjackson/5311256
    hue2rgb: (p, q, t) => {
      if (t < 0)
        t += 1;
      if (t > 1)
        t -= 1;
      if (t < 1 / 6)
        return p + (q - p) * 6 * t;
      if (t < 1 / 2)
        return q;
      if (t < 2 / 3)
        return p + (q - p) * (2 / 3 - t) * 6;
      return p;
    },
    hsl2rgb: ({ h, s, l }, channel2) => {
      if (!s)
        return l * 2.55;
      h /= 360;
      s /= 100;
      l /= 100;
      const q = l < 0.5 ? l * (1 + s) : l + s - l * s;
      const p = 2 * l - q;
      switch (channel2) {
        case "r":
          return Channel.hue2rgb(p, q, h + 1 / 3) * 255;
        case "g":
          return Channel.hue2rgb(p, q, h) * 255;
        case "b":
          return Channel.hue2rgb(p, q, h - 1 / 3) * 255;
      }
    },
    rgb2hsl: ({ r, g, b }, channel2) => {
      r /= 255;
      g /= 255;
      b /= 255;
      const max2 = Math.max(r, g, b);
      const min2 = Math.min(r, g, b);
      const l = (max2 + min2) / 2;
      if (channel2 === "l")
        return l * 100;
      if (max2 === min2)
        return 0;
      const d = max2 - min2;
      const s = l > 0.5 ? d / (2 - max2 - min2) : d / (max2 + min2);
      if (channel2 === "s")
        return s * 100;
      switch (max2) {
        case r:
          return ((g - b) / d + (g < b ? 6 : 0)) * 60;
        case g:
          return ((b - r) / d + 2) * 60;
        case b:
          return ((r - g) / d + 4) * 60;
        default:
          return -1;
      }
    }
  };
  const channel$2 = Channel;
  const Lang = {
    /* API */
    clamp: (number2, lower2, upper) => {
      if (lower2 > upper)
        return Math.min(lower2, Math.max(upper, number2));
      return Math.min(upper, Math.max(lower2, number2));
    },
    round: (number2) => {
      return Math.round(number2 * 1e10) / 1e10;
    }
  };
  const lang = Lang;
  const Unit = {
    /* API */
    dec2hex: (dec) => {
      const hex2 = Math.round(dec).toString(16);
      return hex2.length > 1 ? hex2 : `0${hex2}`;
    }
  };
  const unit = Unit;
  const Utils = {
    channel: channel$2,
    lang,
    unit
  };
  const _ = Utils;
  const DEC2HEX = {};
  for (let i2 = 0; i2 <= 255; i2++)
    DEC2HEX[i2] = _.unit.dec2hex(i2);
  const TYPE = {
    ALL: 0,
    RGB: 1,
    HSL: 2
  };
  class Type {
    constructor() {
      this.type = TYPE.ALL;
    }
    /* API */
    get() {
      return this.type;
    }
    set(type2) {
      if (this.type && this.type !== type2)
        throw new Error("Cannot change both RGB and HSL channels at the same time");
      this.type = type2;
    }
    reset() {
      this.type = TYPE.ALL;
    }
    is(type2) {
      return this.type === type2;
    }
  }
  const Type$2 = Type;
  class Channels {
    /* CONSTRUCTOR */
    constructor(data, color2) {
      this.color = color2;
      this.changed = false;
      this.data = data;
      this.type = new Type$2();
    }
    /* API */
    set(data, color2) {
      this.color = color2;
      this.changed = false;
      this.data = data;
      this.type.type = TYPE.ALL;
      return this;
    }
    /* HELPERS */
    _ensureHSL() {
      const data = this.data;
      const { h, s, l } = data;
      if (h === void 0)
        data.h = _.channel.rgb2hsl(data, "h");
      if (s === void 0)
        data.s = _.channel.rgb2hsl(data, "s");
      if (l === void 0)
        data.l = _.channel.rgb2hsl(data, "l");
    }
    _ensureRGB() {
      const data = this.data;
      const { r, g, b } = data;
      if (r === void 0)
        data.r = _.channel.hsl2rgb(data, "r");
      if (g === void 0)
        data.g = _.channel.hsl2rgb(data, "g");
      if (b === void 0)
        data.b = _.channel.hsl2rgb(data, "b");
    }
    /* GETTERS */
    get r() {
      const data = this.data;
      const r = data.r;
      if (!this.type.is(TYPE.HSL) && r !== void 0)
        return r;
      this._ensureHSL();
      return _.channel.hsl2rgb(data, "r");
    }
    get g() {
      const data = this.data;
      const g = data.g;
      if (!this.type.is(TYPE.HSL) && g !== void 0)
        return g;
      this._ensureHSL();
      return _.channel.hsl2rgb(data, "g");
    }
    get b() {
      const data = this.data;
      const b = data.b;
      if (!this.type.is(TYPE.HSL) && b !== void 0)
        return b;
      this._ensureHSL();
      return _.channel.hsl2rgb(data, "b");
    }
    get h() {
      const data = this.data;
      const h = data.h;
      if (!this.type.is(TYPE.RGB) && h !== void 0)
        return h;
      this._ensureRGB();
      return _.channel.rgb2hsl(data, "h");
    }
    get s() {
      const data = this.data;
      const s = data.s;
      if (!this.type.is(TYPE.RGB) && s !== void 0)
        return s;
      this._ensureRGB();
      return _.channel.rgb2hsl(data, "s");
    }
    get l() {
      const data = this.data;
      const l = data.l;
      if (!this.type.is(TYPE.RGB) && l !== void 0)
        return l;
      this._ensureRGB();
      return _.channel.rgb2hsl(data, "l");
    }
    get a() {
      return this.data.a;
    }
    /* SETTERS */
    set r(r) {
      this.type.set(TYPE.RGB);
      this.changed = true;
      this.data.r = r;
    }
    set g(g) {
      this.type.set(TYPE.RGB);
      this.changed = true;
      this.data.g = g;
    }
    set b(b) {
      this.type.set(TYPE.RGB);
      this.changed = true;
      this.data.b = b;
    }
    set h(h) {
      this.type.set(TYPE.HSL);
      this.changed = true;
      this.data.h = h;
    }
    set s(s) {
      this.type.set(TYPE.HSL);
      this.changed = true;
      this.data.s = s;
    }
    set l(l) {
      this.type.set(TYPE.HSL);
      this.changed = true;
      this.data.l = l;
    }
    set a(a) {
      this.changed = true;
      this.data.a = a;
    }
  }
  const Channels$1 = Channels;
  const channels = new Channels$1({ r: 0, g: 0, b: 0, a: 0 }, "transparent");
  const ChannelsReusable = channels;
  const Hex = {
    /* VARIABLES */
    re: /^#((?:[a-f0-9]{2}){2,4}|[a-f0-9]{3})$/i,
    /* API */
    parse: (color2) => {
      if (color2.charCodeAt(0) !== 35)
        return;
      const match = color2.match(Hex.re);
      if (!match)
        return;
      const hex2 = match[1];
      const dec = parseInt(hex2, 16);
      const length2 = hex2.length;
      const hasAlpha = length2 % 4 === 0;
      const isFullLength = length2 > 4;
      const multiplier = isFullLength ? 1 : 17;
      const bits = isFullLength ? 8 : 4;
      const bitsOffset = hasAlpha ? 0 : -1;
      const mask = isFullLength ? 255 : 15;
      return ChannelsReusable.set({
        r: (dec >> bits * (bitsOffset + 3) & mask) * multiplier,
        g: (dec >> bits * (bitsOffset + 2) & mask) * multiplier,
        b: (dec >> bits * (bitsOffset + 1) & mask) * multiplier,
        a: hasAlpha ? (dec & mask) * multiplier / 255 : 1
      }, color2);
    },
    stringify: (channels2) => {
      const { r, g, b, a } = channels2;
      if (a < 1) {
        return `#${DEC2HEX[Math.round(r)]}${DEC2HEX[Math.round(g)]}${DEC2HEX[Math.round(b)]}${DEC2HEX[Math.round(a * 255)]}`;
      } else {
        return `#${DEC2HEX[Math.round(r)]}${DEC2HEX[Math.round(g)]}${DEC2HEX[Math.round(b)]}`;
      }
    }
  };
  const Hex$1 = Hex;
  const HSL = {
    /* VARIABLES */
    re: /^hsla?\(\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?(?:deg|grad|rad|turn)?)\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?%)\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?%)(?:\s*?(?:,|\/)\s*?\+?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e-?\d+)?(%)?))?\s*?\)$/i,
    hueRe: /^(.+?)(deg|grad|rad|turn)$/i,
    /* HELPERS */
    _hue2deg: (hue2) => {
      const match = hue2.match(HSL.hueRe);
      if (match) {
        const [, number2, unit2] = match;
        switch (unit2) {
          case "grad":
            return _.channel.clamp.h(parseFloat(number2) * 0.9);
          case "rad":
            return _.channel.clamp.h(parseFloat(number2) * 180 / Math.PI);
          case "turn":
            return _.channel.clamp.h(parseFloat(number2) * 360);
        }
      }
      return _.channel.clamp.h(parseFloat(hue2));
    },
    /* API */
    parse: (color2) => {
      const charCode = color2.charCodeAt(0);
      if (charCode !== 104 && charCode !== 72)
        return;
      const match = color2.match(HSL.re);
      if (!match)
        return;
      const [, h, s, l, a, isAlphaPercentage] = match;
      return ChannelsReusable.set({
        h: HSL._hue2deg(h),
        s: _.channel.clamp.s(parseFloat(s)),
        l: _.channel.clamp.l(parseFloat(l)),
        a: a ? _.channel.clamp.a(isAlphaPercentage ? parseFloat(a) / 100 : parseFloat(a)) : 1
      }, color2);
    },
    stringify: (channels2) => {
      const { h, s, l, a } = channels2;
      if (a < 1) {
        return `hsla(${_.lang.round(h)}, ${_.lang.round(s)}%, ${_.lang.round(l)}%, ${a})`;
      } else {
        return `hsl(${_.lang.round(h)}, ${_.lang.round(s)}%, ${_.lang.round(l)}%)`;
      }
    }
  };
  const HSL$1 = HSL;
  const Keyword = {
    /* VARIABLES */
    colors: {
      aliceblue: "#f0f8ff",
      antiquewhite: "#faebd7",
      aqua: "#00ffff",
      aquamarine: "#7fffd4",
      azure: "#f0ffff",
      beige: "#f5f5dc",
      bisque: "#ffe4c4",
      black: "#000000",
      blanchedalmond: "#ffebcd",
      blue: "#0000ff",
      blueviolet: "#8a2be2",
      brown: "#a52a2a",
      burlywood: "#deb887",
      cadetblue: "#5f9ea0",
      chartreuse: "#7fff00",
      chocolate: "#d2691e",
      coral: "#ff7f50",
      cornflowerblue: "#6495ed",
      cornsilk: "#fff8dc",
      crimson: "#dc143c",
      cyanaqua: "#00ffff",
      darkblue: "#00008b",
      darkcyan: "#008b8b",
      darkgoldenrod: "#b8860b",
      darkgray: "#a9a9a9",
      darkgreen: "#006400",
      darkgrey: "#a9a9a9",
      darkkhaki: "#bdb76b",
      darkmagenta: "#8b008b",
      darkolivegreen: "#556b2f",
      darkorange: "#ff8c00",
      darkorchid: "#9932cc",
      darkred: "#8b0000",
      darksalmon: "#e9967a",
      darkseagreen: "#8fbc8f",
      darkslateblue: "#483d8b",
      darkslategray: "#2f4f4f",
      darkslategrey: "#2f4f4f",
      darkturquoise: "#00ced1",
      darkviolet: "#9400d3",
      deeppink: "#ff1493",
      deepskyblue: "#00bfff",
      dimgray: "#696969",
      dimgrey: "#696969",
      dodgerblue: "#1e90ff",
      firebrick: "#b22222",
      floralwhite: "#fffaf0",
      forestgreen: "#228b22",
      fuchsia: "#ff00ff",
      gainsboro: "#dcdcdc",
      ghostwhite: "#f8f8ff",
      gold: "#ffd700",
      goldenrod: "#daa520",
      gray: "#808080",
      green: "#008000",
      greenyellow: "#adff2f",
      grey: "#808080",
      honeydew: "#f0fff0",
      hotpink: "#ff69b4",
      indianred: "#cd5c5c",
      indigo: "#4b0082",
      ivory: "#fffff0",
      khaki: "#f0e68c",
      lavender: "#e6e6fa",
      lavenderblush: "#fff0f5",
      lawngreen: "#7cfc00",
      lemonchiffon: "#fffacd",
      lightblue: "#add8e6",
      lightcoral: "#f08080",
      lightcyan: "#e0ffff",
      lightgoldenrodyellow: "#fafad2",
      lightgray: "#d3d3d3",
      lightgreen: "#90ee90",
      lightgrey: "#d3d3d3",
      lightpink: "#ffb6c1",
      lightsalmon: "#ffa07a",
      lightseagreen: "#20b2aa",
      lightskyblue: "#87cefa",
      lightslategray: "#778899",
      lightslategrey: "#778899",
      lightsteelblue: "#b0c4de",
      lightyellow: "#ffffe0",
      lime: "#00ff00",
      limegreen: "#32cd32",
      linen: "#faf0e6",
      magenta: "#ff00ff",
      maroon: "#800000",
      mediumaquamarine: "#66cdaa",
      mediumblue: "#0000cd",
      mediumorchid: "#ba55d3",
      mediumpurple: "#9370db",
      mediumseagreen: "#3cb371",
      mediumslateblue: "#7b68ee",
      mediumspringgreen: "#00fa9a",
      mediumturquoise: "#48d1cc",
      mediumvioletred: "#c71585",
      midnightblue: "#191970",
      mintcream: "#f5fffa",
      mistyrose: "#ffe4e1",
      moccasin: "#ffe4b5",
      navajowhite: "#ffdead",
      navy: "#000080",
      oldlace: "#fdf5e6",
      olive: "#808000",
      olivedrab: "#6b8e23",
      orange: "#ffa500",
      orangered: "#ff4500",
      orchid: "#da70d6",
      palegoldenrod: "#eee8aa",
      palegreen: "#98fb98",
      paleturquoise: "#afeeee",
      palevioletred: "#db7093",
      papayawhip: "#ffefd5",
      peachpuff: "#ffdab9",
      peru: "#cd853f",
      pink: "#ffc0cb",
      plum: "#dda0dd",
      powderblue: "#b0e0e6",
      purple: "#800080",
      rebeccapurple: "#663399",
      red: "#ff0000",
      rosybrown: "#bc8f8f",
      royalblue: "#4169e1",
      saddlebrown: "#8b4513",
      salmon: "#fa8072",
      sandybrown: "#f4a460",
      seagreen: "#2e8b57",
      seashell: "#fff5ee",
      sienna: "#a0522d",
      silver: "#c0c0c0",
      skyblue: "#87ceeb",
      slateblue: "#6a5acd",
      slategray: "#708090",
      slategrey: "#708090",
      snow: "#fffafa",
      springgreen: "#00ff7f",
      tan: "#d2b48c",
      teal: "#008080",
      thistle: "#d8bfd8",
      transparent: "#00000000",
      turquoise: "#40e0d0",
      violet: "#ee82ee",
      wheat: "#f5deb3",
      white: "#ffffff",
      whitesmoke: "#f5f5f5",
      yellow: "#ffff00",
      yellowgreen: "#9acd32"
    },
    /* API */
    parse: (color2) => {
      color2 = color2.toLowerCase();
      const hex2 = Keyword.colors[color2];
      if (!hex2)
        return;
      return Hex$1.parse(hex2);
    },
    stringify: (channels2) => {
      const hex2 = Hex$1.stringify(channels2);
      for (const name in Keyword.colors) {
        if (Keyword.colors[name] === hex2)
          return name;
      }
      return;
    }
  };
  const Keyword$1 = Keyword;
  const RGB = {
    /* VARIABLES */
    re: /^rgba?\(\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?))\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?))\s*?(?:,|\s)\s*?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?))(?:\s*?(?:,|\/)\s*?\+?(-?(?:\d+(?:\.\d+)?|(?:\.\d+))(?:e\d+)?(%?)))?\s*?\)$/i,
    /* API */
    parse: (color2) => {
      const charCode = color2.charCodeAt(0);
      if (charCode !== 114 && charCode !== 82)
        return;
      const match = color2.match(RGB.re);
      if (!match)
        return;
      const [, r, isRedPercentage, g, isGreenPercentage, b, isBluePercentage, a, isAlphaPercentage] = match;
      return ChannelsReusable.set({
        r: _.channel.clamp.r(isRedPercentage ? parseFloat(r) * 2.55 : parseFloat(r)),
        g: _.channel.clamp.g(isGreenPercentage ? parseFloat(g) * 2.55 : parseFloat(g)),
        b: _.channel.clamp.b(isBluePercentage ? parseFloat(b) * 2.55 : parseFloat(b)),
        a: a ? _.channel.clamp.a(isAlphaPercentage ? parseFloat(a) / 100 : parseFloat(a)) : 1
      }, color2);
    },
    stringify: (channels2) => {
      const { r, g, b, a } = channels2;
      if (a < 1) {
        return `rgba(${_.lang.round(r)}, ${_.lang.round(g)}, ${_.lang.round(b)}, ${_.lang.round(a)})`;
      } else {
        return `rgb(${_.lang.round(r)}, ${_.lang.round(g)}, ${_.lang.round(b)})`;
      }
    }
  };
  const RGB$1 = RGB;
  const Color = {
    /* VARIABLES */
    format: {
      keyword: Keyword$1,
      hex: Hex$1,
      rgb: RGB$1,
      rgba: RGB$1,
      hsl: HSL$1,
      hsla: HSL$1
    },
    /* API */
    parse: (color2) => {
      if (typeof color2 !== "string")
        return color2;
      const channels2 = Hex$1.parse(color2) || RGB$1.parse(color2) || HSL$1.parse(color2) || Keyword$1.parse(color2);
      if (channels2)
        return channels2;
      throw new Error(`Unsupported color format: "${color2}"`);
    },
    stringify: (channels2) => {
      if (!channels2.changed && channels2.color)
        return channels2.color;
      if (channels2.type.is(TYPE.HSL) || channels2.data.r === void 0) {
        return HSL$1.stringify(channels2);
      } else if (channels2.a < 1 || !Number.isInteger(channels2.r) || !Number.isInteger(channels2.g) || !Number.isInteger(channels2.b)) {
        return RGB$1.stringify(channels2);
      } else {
        return Hex$1.stringify(channels2);
      }
    }
  };
  const Color$1 = Color;
  const change = (color2, channels2) => {
    const ch = Color$1.parse(color2);
    for (const c2 in channels2) {
      ch[c2] = _.channel.clamp[c2](channels2[c2]);
    }
    return Color$1.stringify(ch);
  };
  const change$1 = change;
  const rgba = (r, g, b = 0, a = 1) => {
    if (typeof r !== "number")
      return change$1(r, { a: g });
    const channels2 = ChannelsReusable.set({
      r: _.channel.clamp.r(r),
      g: _.channel.clamp.g(g),
      b: _.channel.clamp.b(b),
      a: _.channel.clamp.a(a)
    });
    return Color$1.stringify(channels2);
  };
  const rgba$1 = rgba;
  const channel = (color2, channel2) => {
    return _.lang.round(Color$1.parse(color2)[channel2]);
  };
  const channel$1 = channel;
  const luminance = (color2) => {
    const { r, g, b } = Color$1.parse(color2);
    const luminance2 = 0.2126 * _.channel.toLinear(r) + 0.7152 * _.channel.toLinear(g) + 0.0722 * _.channel.toLinear(b);
    return _.lang.round(luminance2);
  };
  const luminance$1 = luminance;
  const isLight = (color2) => {
    return luminance$1(color2) >= 0.5;
  };
  const isLight$1 = isLight;
  const isDark = (color2) => {
    return !isLight$1(color2);
  };
  const isDark$1 = isDark;
  const adjustChannel = (color2, channel2, amount) => {
    const channels2 = Color$1.parse(color2);
    const amountCurrent = channels2[channel2];
    const amountNext = _.channel.clamp[channel2](amountCurrent + amount);
    if (amountCurrent !== amountNext)
      channels2[channel2] = amountNext;
    return Color$1.stringify(channels2);
  };
  const adjustChannel$1 = adjustChannel;
  const lighten = (color2, amount) => {
    return adjustChannel$1(color2, "l", amount);
  };
  const lighten$1 = lighten;
  const darken = (color2, amount) => {
    return adjustChannel$1(color2, "l", -amount);
  };
  const darken$1 = darken;
  const adjust$1 = (color2, channels2) => {
    const ch = Color$1.parse(color2);
    const changes = {};
    for (const c2 in channels2) {
      if (!channels2[c2])
        continue;
      changes[c2] = ch[c2] + channels2[c2];
    }
    return change$1(color2, changes);
  };
  const adjust$2 = adjust$1;
  const mix = (color1, color2, weight = 50) => {
    const { r: r1, g: g1, b: b1, a: a1 } = Color$1.parse(color1);
    const { r: r2, g: g2, b: b2, a: a2 } = Color$1.parse(color2);
    const weightScale = weight / 100;
    const weightNormalized = weightScale * 2 - 1;
    const alphaDelta = a1 - a2;
    const weight1combined = weightNormalized * alphaDelta === -1 ? weightNormalized : (weightNormalized + alphaDelta) / (1 + weightNormalized * alphaDelta);
    const weight1 = (weight1combined + 1) / 2;
    const weight2 = 1 - weight1;
    const r = r1 * weight1 + r2 * weight2;
    const g = g1 * weight1 + g2 * weight2;
    const b = b1 * weight1 + b2 * weight2;
    const a = a1 * weightScale + a2 * (1 - weightScale);
    return rgba$1(r, g, b, a);
  };
  const mix$1 = mix;
  const invert = (color2, weight = 100) => {
    const inverse = Color$1.parse(color2);
    inverse.r = 255 - inverse.r;
    inverse.g = 255 - inverse.g;
    inverse.b = 255 - inverse.b;
    return mix$1(inverse, color2, weight);
  };
  const invert$1 = invert;
  const mkBorder = (col, darkMode) => darkMode ? adjust$2(col, { s: -40, l: 10 }) : adjust$2(col, { s: -40, l: -10 });
  const oldAttributeBackgroundColorOdd = "#ffffff";
  const oldAttributeBackgroundColorEven = "#f2f2f2";
  let Theme$4 = class Theme {
    constructor() {
      this.background = "#f4f4f4";
      this.primaryColor = "#fff4dd";
      this.noteBkgColor = "#fff5ad";
      this.noteTextColor = "#333";
      this.THEME_COLOR_LIMIT = 12;
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
    }
    updateColors() {
      var _a2, _b2, _c, _d, _e, _f, _g, _h, _i, _j, _k;
      this.primaryTextColor = this.primaryTextColor || (this.darkMode ? "#eee" : "#333");
      this.secondaryColor = this.secondaryColor || adjust$2(this.primaryColor, { h: -120 });
      this.tertiaryColor = this.tertiaryColor || adjust$2(this.primaryColor, { h: 180, l: 5 });
      this.primaryBorderColor = this.primaryBorderColor || mkBorder(this.primaryColor, this.darkMode);
      this.secondaryBorderColor = this.secondaryBorderColor || mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = this.tertiaryBorderColor || mkBorder(this.tertiaryColor, this.darkMode);
      this.noteBorderColor = this.noteBorderColor || mkBorder(this.noteBkgColor, this.darkMode);
      this.noteBkgColor = this.noteBkgColor || "#fff5ad";
      this.noteTextColor = this.noteTextColor || "#333";
      this.secondaryTextColor = this.secondaryTextColor || invert$1(this.secondaryColor);
      this.tertiaryTextColor = this.tertiaryTextColor || invert$1(this.tertiaryColor);
      this.lineColor = this.lineColor || invert$1(this.background);
      this.arrowheadColor = this.arrowheadColor || invert$1(this.background);
      this.textColor = this.textColor || this.primaryTextColor;
      this.border2 = this.border2 || this.tertiaryBorderColor;
      this.nodeBkg = this.nodeBkg || this.primaryColor;
      this.mainBkg = this.mainBkg || this.primaryColor;
      this.nodeBorder = this.nodeBorder || this.primaryBorderColor;
      this.clusterBkg = this.clusterBkg || this.tertiaryColor;
      this.clusterBorder = this.clusterBorder || this.tertiaryBorderColor;
      this.defaultLinkColor = this.defaultLinkColor || this.lineColor;
      this.titleColor = this.titleColor || this.tertiaryTextColor;
      this.edgeLabelBackground = this.edgeLabelBackground || (this.darkMode ? darken$1(this.secondaryColor, 30) : this.secondaryColor);
      this.nodeTextColor = this.nodeTextColor || this.primaryTextColor;
      this.actorBorder = this.actorBorder || this.primaryBorderColor;
      this.actorBkg = this.actorBkg || this.mainBkg;
      this.actorTextColor = this.actorTextColor || this.primaryTextColor;
      this.actorLineColor = this.actorLineColor || "grey";
      this.labelBoxBkgColor = this.labelBoxBkgColor || this.actorBkg;
      this.signalColor = this.signalColor || this.textColor;
      this.signalTextColor = this.signalTextColor || this.textColor;
      this.labelBoxBorderColor = this.labelBoxBorderColor || this.actorBorder;
      this.labelTextColor = this.labelTextColor || this.actorTextColor;
      this.loopTextColor = this.loopTextColor || this.actorTextColor;
      this.activationBorderColor = this.activationBorderColor || darken$1(this.secondaryColor, 10);
      this.activationBkgColor = this.activationBkgColor || this.secondaryColor;
      this.sequenceNumberColor = this.sequenceNumberColor || invert$1(this.lineColor);
      this.sectionBkgColor = this.sectionBkgColor || this.tertiaryColor;
      this.altSectionBkgColor = this.altSectionBkgColor || "white";
      this.sectionBkgColor = this.sectionBkgColor || this.secondaryColor;
      this.sectionBkgColor2 = this.sectionBkgColor2 || this.primaryColor;
      this.excludeBkgColor = this.excludeBkgColor || "#eeeeee";
      this.taskBorderColor = this.taskBorderColor || this.primaryBorderColor;
      this.taskBkgColor = this.taskBkgColor || this.primaryColor;
      this.activeTaskBorderColor = this.activeTaskBorderColor || this.primaryColor;
      this.activeTaskBkgColor = this.activeTaskBkgColor || lighten$1(this.primaryColor, 23);
      this.gridColor = this.gridColor || "lightgrey";
      this.doneTaskBkgColor = this.doneTaskBkgColor || "lightgrey";
      this.doneTaskBorderColor = this.doneTaskBorderColor || "grey";
      this.critBorderColor = this.critBorderColor || "#ff8888";
      this.critBkgColor = this.critBkgColor || "red";
      this.todayLineColor = this.todayLineColor || "red";
      this.taskTextColor = this.taskTextColor || this.textColor;
      this.taskTextOutsideColor = this.taskTextOutsideColor || this.textColor;
      this.taskTextLightColor = this.taskTextLightColor || this.textColor;
      this.taskTextColor = this.taskTextColor || this.primaryTextColor;
      this.taskTextDarkColor = this.taskTextDarkColor || this.textColor;
      this.taskTextClickableColor = this.taskTextClickableColor || "#003163";
      this.personBorder = this.personBorder || this.primaryBorderColor;
      this.personBkg = this.personBkg || this.mainBkg;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || this.tertiaryColor;
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.compositeBorder = this.compositeBorder || this.nodeBorder;
      this.innerEndBackground = this.nodeBorder;
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.specialStateColor = this.lineColor;
      this.cScale0 = this.cScale0 || this.primaryColor;
      this.cScale1 = this.cScale1 || this.secondaryColor;
      this.cScale2 = this.cScale2 || this.tertiaryColor;
      this.cScale3 = this.cScale3 || adjust$2(this.primaryColor, { h: 30 });
      this.cScale4 = this.cScale4 || adjust$2(this.primaryColor, { h: 60 });
      this.cScale5 = this.cScale5 || adjust$2(this.primaryColor, { h: 90 });
      this.cScale6 = this.cScale6 || adjust$2(this.primaryColor, { h: 120 });
      this.cScale7 = this.cScale7 || adjust$2(this.primaryColor, { h: 150 });
      this.cScale8 = this.cScale8 || adjust$2(this.primaryColor, { h: 210, l: 150 });
      this.cScale9 = this.cScale9 || adjust$2(this.primaryColor, { h: 270 });
      this.cScale10 = this.cScale10 || adjust$2(this.primaryColor, { h: 300 });
      this.cScale11 = this.cScale11 || adjust$2(this.primaryColor, { h: 330 });
      if (this.darkMode) {
        for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
          this["cScale" + i2] = darken$1(this["cScale" + i2], 75);
        }
      } else {
        for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
          this["cScale" + i2] = darken$1(this["cScale" + i2], 25);
        }
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || invert$1(this["cScale" + i2]);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        if (this.darkMode) {
          this["cScalePeer" + i2] = this["cScalePeer" + i2] || lighten$1(this["cScale" + i2], 10);
        } else {
          this["cScalePeer" + i2] = this["cScalePeer" + i2] || darken$1(this["cScale" + i2], 10);
        }
      }
      this.scaleLabelColor = this.scaleLabelColor || this.labelTextColor;
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.scaleLabelColor;
      }
      const multiplier = this.darkMode ? -4 : -1;
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { h: 180, s: -15, l: multiplier * (5 + i2 * 3) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { h: 180, s: -15, l: multiplier * (8 + i2 * 3) });
      }
      this.classText = this.classText || this.textColor;
      this.fillType0 = this.fillType0 || this.primaryColor;
      this.fillType1 = this.fillType1 || this.secondaryColor;
      this.fillType2 = this.fillType2 || adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = this.fillType3 || adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = this.fillType4 || adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = this.fillType5 || adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = this.fillType6 || adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = this.fillType7 || adjust$2(this.secondaryColor, { h: 128 });
      this.pie1 = this.pie1 || this.primaryColor;
      this.pie2 = this.pie2 || this.secondaryColor;
      this.pie3 = this.pie3 || this.tertiaryColor;
      this.pie4 = this.pie4 || adjust$2(this.primaryColor, { l: -10 });
      this.pie5 = this.pie5 || adjust$2(this.secondaryColor, { l: -10 });
      this.pie6 = this.pie6 || adjust$2(this.tertiaryColor, { l: -10 });
      this.pie7 = this.pie7 || adjust$2(this.primaryColor, { h: 60, l: -10 });
      this.pie8 = this.pie8 || adjust$2(this.primaryColor, { h: -60, l: -10 });
      this.pie9 = this.pie9 || adjust$2(this.primaryColor, { h: 120, l: 0 });
      this.pie10 = this.pie10 || adjust$2(this.primaryColor, { h: 60, l: -20 });
      this.pie11 = this.pie11 || adjust$2(this.primaryColor, { h: -60, l: -20 });
      this.pie12 = this.pie12 || adjust$2(this.primaryColor, { h: 120, l: -10 });
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOuterStrokeWidth = this.pieOuterStrokeWidth || "2px";
      this.pieOuterStrokeColor = this.pieOuterStrokeColor || "black";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.quadrant1Fill = this.quadrant1Fill || this.primaryColor;
      this.quadrant2Fill = this.quadrant2Fill || adjust$2(this.primaryColor, { r: 5, g: 5, b: 5 });
      this.quadrant3Fill = this.quadrant3Fill || adjust$2(this.primaryColor, { r: 10, g: 10, b: 10 });
      this.quadrant4Fill = this.quadrant4Fill || adjust$2(this.primaryColor, { r: 15, g: 15, b: 15 });
      this.quadrant1TextFill = this.quadrant1TextFill || this.primaryTextColor;
      this.quadrant2TextFill = this.quadrant2TextFill || adjust$2(this.primaryTextColor, { r: -5, g: -5, b: -5 });
      this.quadrant3TextFill = this.quadrant3TextFill || adjust$2(this.primaryTextColor, { r: -10, g: -10, b: -10 });
      this.quadrant4TextFill = this.quadrant4TextFill || adjust$2(this.primaryTextColor, { r: -15, g: -15, b: -15 });
      this.quadrantPointFill = this.quadrantPointFill || isDark$1(this.quadrant1Fill) ? lighten$1(this.quadrant1Fill) : darken$1(this.quadrant1Fill);
      this.quadrantPointTextFill = this.quadrantPointTextFill || this.primaryTextColor;
      this.quadrantXAxisTextFill = this.quadrantXAxisTextFill || this.primaryTextColor;
      this.quadrantYAxisTextFill = this.quadrantYAxisTextFill || this.primaryTextColor;
      this.quadrantInternalBorderStrokeFill = this.quadrantInternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantExternalBorderStrokeFill = this.quadrantExternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantTitleFill = this.quadrantTitleFill || this.primaryTextColor;
      this.xyChart = {
        backgroundColor: ((_a2 = this.xyChart) == null ? void 0 : _a2.backgroundColor) || this.background,
        titleColor: ((_b2 = this.xyChart) == null ? void 0 : _b2.titleColor) || this.primaryTextColor,
        xAxisTitleColor: ((_c = this.xyChart) == null ? void 0 : _c.xAxisTitleColor) || this.primaryTextColor,
        xAxisLabelColor: ((_d = this.xyChart) == null ? void 0 : _d.xAxisLabelColor) || this.primaryTextColor,
        xAxisTickColor: ((_e = this.xyChart) == null ? void 0 : _e.xAxisTickColor) || this.primaryTextColor,
        xAxisLineColor: ((_f = this.xyChart) == null ? void 0 : _f.xAxisLineColor) || this.primaryTextColor,
        yAxisTitleColor: ((_g = this.xyChart) == null ? void 0 : _g.yAxisTitleColor) || this.primaryTextColor,
        yAxisLabelColor: ((_h = this.xyChart) == null ? void 0 : _h.yAxisLabelColor) || this.primaryTextColor,
        yAxisTickColor: ((_i = this.xyChart) == null ? void 0 : _i.yAxisTickColor) || this.primaryTextColor,
        yAxisLineColor: ((_j = this.xyChart) == null ? void 0 : _j.yAxisLineColor) || this.primaryTextColor,
        plotColorPalette: ((_k = this.xyChart) == null ? void 0 : _k.plotColorPalette) || "#FFF4DD,#FFD8B1,#FFA07A,#ECEFF1,#D6DBDF,#C3E0A8,#FFB6A4,#FFD74D,#738FA7,#FFFFF0"
      };
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || "1";
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || (this.darkMode ? darken$1(this.secondaryColor, 30) : this.secondaryColor);
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = this.git0 || this.primaryColor;
      this.git1 = this.git1 || this.secondaryColor;
      this.git2 = this.git2 || this.tertiaryColor;
      this.git3 = this.git3 || adjust$2(this.primaryColor, { h: -30 });
      this.git4 = this.git4 || adjust$2(this.primaryColor, { h: -60 });
      this.git5 = this.git5 || adjust$2(this.primaryColor, { h: -90 });
      this.git6 = this.git6 || adjust$2(this.primaryColor, { h: 60 });
      this.git7 = this.git7 || adjust$2(this.primaryColor, { h: 120 });
      if (this.darkMode) {
        this.git0 = lighten$1(this.git0, 25);
        this.git1 = lighten$1(this.git1, 25);
        this.git2 = lighten$1(this.git2, 25);
        this.git3 = lighten$1(this.git3, 25);
        this.git4 = lighten$1(this.git4, 25);
        this.git5 = lighten$1(this.git5, 25);
        this.git6 = lighten$1(this.git6, 25);
        this.git7 = lighten$1(this.git7, 25);
      } else {
        this.git0 = darken$1(this.git0, 25);
        this.git1 = darken$1(this.git1, 25);
        this.git2 = darken$1(this.git2, 25);
        this.git3 = darken$1(this.git3, 25);
        this.git4 = darken$1(this.git4, 25);
        this.git5 = darken$1(this.git5, 25);
        this.git6 = darken$1(this.git6, 25);
        this.git7 = darken$1(this.git7, 25);
      }
      this.gitInv0 = this.gitInv0 || invert$1(this.git0);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.branchLabelColor = this.branchLabelColor || (this.darkMode ? "black" : this.labelTextColor);
      this.gitBranchLabel0 = this.gitBranchLabel0 || this.branchLabelColor;
      this.gitBranchLabel1 = this.gitBranchLabel1 || this.branchLabelColor;
      this.gitBranchLabel2 = this.gitBranchLabel2 || this.branchLabelColor;
      this.gitBranchLabel3 = this.gitBranchLabel3 || this.branchLabelColor;
      this.gitBranchLabel4 = this.gitBranchLabel4 || this.branchLabelColor;
      this.gitBranchLabel5 = this.gitBranchLabel5 || this.branchLabelColor;
      this.gitBranchLabel6 = this.gitBranchLabel6 || this.branchLabelColor;
      this.gitBranchLabel7 = this.gitBranchLabel7 || this.branchLabelColor;
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  };
  const getThemeVariables$4 = (userOverrides) => {
    const theme2 = new Theme$4();
    theme2.calculate(userOverrides);
    return theme2;
  };
  let Theme$3 = class Theme {
    constructor() {
      this.background = "#333";
      this.primaryColor = "#1f2020";
      this.secondaryColor = lighten$1(this.primaryColor, 16);
      this.tertiaryColor = adjust$2(this.primaryColor, { h: -160 });
      this.primaryBorderColor = invert$1(this.background);
      this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
      this.primaryTextColor = invert$1(this.primaryColor);
      this.secondaryTextColor = invert$1(this.secondaryColor);
      this.tertiaryTextColor = invert$1(this.tertiaryColor);
      this.lineColor = invert$1(this.background);
      this.textColor = invert$1(this.background);
      this.mainBkg = "#1f2020";
      this.secondBkg = "calculated";
      this.mainContrastColor = "lightgrey";
      this.darkTextColor = lighten$1(invert$1("#323D47"), 10);
      this.lineColor = "calculated";
      this.border1 = "#81B1DB";
      this.border2 = rgba$1(255, 255, 255, 0.25);
      this.arrowheadColor = "calculated";
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
      this.labelBackground = "#181818";
      this.textColor = "#ccc";
      this.THEME_COLOR_LIMIT = 12;
      this.nodeBkg = "calculated";
      this.nodeBorder = "calculated";
      this.clusterBkg = "calculated";
      this.clusterBorder = "calculated";
      this.defaultLinkColor = "calculated";
      this.titleColor = "#F9FFFE";
      this.edgeLabelBackground = "calculated";
      this.actorBorder = "calculated";
      this.actorBkg = "calculated";
      this.actorTextColor = "calculated";
      this.actorLineColor = "calculated";
      this.signalColor = "calculated";
      this.signalTextColor = "calculated";
      this.labelBoxBkgColor = "calculated";
      this.labelBoxBorderColor = "calculated";
      this.labelTextColor = "calculated";
      this.loopTextColor = "calculated";
      this.noteBorderColor = "calculated";
      this.noteBkgColor = "#fff5ad";
      this.noteTextColor = "calculated";
      this.activationBorderColor = "calculated";
      this.activationBkgColor = "calculated";
      this.sequenceNumberColor = "black";
      this.sectionBkgColor = darken$1("#EAE8D9", 30);
      this.altSectionBkgColor = "calculated";
      this.sectionBkgColor2 = "#EAE8D9";
      this.excludeBkgColor = darken$1(this.sectionBkgColor, 10);
      this.taskBorderColor = rgba$1(255, 255, 255, 70);
      this.taskBkgColor = "calculated";
      this.taskTextColor = "calculated";
      this.taskTextLightColor = "calculated";
      this.taskTextOutsideColor = "calculated";
      this.taskTextClickableColor = "#003163";
      this.activeTaskBorderColor = rgba$1(255, 255, 255, 50);
      this.activeTaskBkgColor = "#81B1DB";
      this.gridColor = "calculated";
      this.doneTaskBkgColor = "calculated";
      this.doneTaskBorderColor = "grey";
      this.critBorderColor = "#E83737";
      this.critBkgColor = "#E83737";
      this.taskTextDarkColor = "calculated";
      this.todayLineColor = "#DB5757";
      this.personBorder = this.primaryBorderColor;
      this.personBkg = this.mainBkg;
      this.labelColor = "calculated";
      this.errorBkgColor = "#a44141";
      this.errorTextColor = "#ddd";
    }
    updateColors() {
      var _a2, _b2, _c, _d, _e, _f, _g, _h, _i, _j, _k;
      this.secondBkg = lighten$1(this.mainBkg, 16);
      this.lineColor = this.mainContrastColor;
      this.arrowheadColor = this.mainContrastColor;
      this.nodeBkg = this.mainBkg;
      this.nodeBorder = this.border1;
      this.clusterBkg = this.secondBkg;
      this.clusterBorder = this.border2;
      this.defaultLinkColor = this.lineColor;
      this.edgeLabelBackground = lighten$1(this.labelBackground, 25);
      this.actorBorder = this.border1;
      this.actorBkg = this.mainBkg;
      this.actorTextColor = this.mainContrastColor;
      this.actorLineColor = this.mainContrastColor;
      this.signalColor = this.mainContrastColor;
      this.signalTextColor = this.mainContrastColor;
      this.labelBoxBkgColor = this.actorBkg;
      this.labelBoxBorderColor = this.actorBorder;
      this.labelTextColor = this.mainContrastColor;
      this.loopTextColor = this.mainContrastColor;
      this.noteBorderColor = this.secondaryBorderColor;
      this.noteBkgColor = this.secondBkg;
      this.noteTextColor = this.secondaryTextColor;
      this.activationBorderColor = this.border1;
      this.activationBkgColor = this.secondBkg;
      this.altSectionBkgColor = this.background;
      this.taskBkgColor = lighten$1(this.mainBkg, 23);
      this.taskTextColor = this.darkTextColor;
      this.taskTextLightColor = this.mainContrastColor;
      this.taskTextOutsideColor = this.taskTextLightColor;
      this.gridColor = this.mainContrastColor;
      this.doneTaskBkgColor = this.mainContrastColor;
      this.taskTextDarkColor = this.darkTextColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || "#555";
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.compositeBorder = this.compositeBorder || this.nodeBorder;
      this.innerEndBackground = this.primaryBorderColor;
      this.specialStateColor = "#f4f4f4";
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.fillType0 = this.primaryColor;
      this.fillType1 = this.secondaryColor;
      this.fillType2 = adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = adjust$2(this.secondaryColor, { h: 128 });
      this.cScale1 = this.cScale1 || "#0b0000";
      this.cScale2 = this.cScale2 || "#4d1037";
      this.cScale3 = this.cScale3 || "#3f5258";
      this.cScale4 = this.cScale4 || "#4f2f1b";
      this.cScale5 = this.cScale5 || "#6e0a0a";
      this.cScale6 = this.cScale6 || "#3b0048";
      this.cScale7 = this.cScale7 || "#995a01";
      this.cScale8 = this.cScale8 || "#154706";
      this.cScale9 = this.cScale9 || "#161722";
      this.cScale10 = this.cScale10 || "#00296f";
      this.cScale11 = this.cScale11 || "#01629c";
      this.cScale12 = this.cScale12 || "#010029";
      this.cScale0 = this.cScale0 || this.primaryColor;
      this.cScale1 = this.cScale1 || this.secondaryColor;
      this.cScale2 = this.cScale2 || this.tertiaryColor;
      this.cScale3 = this.cScale3 || adjust$2(this.primaryColor, { h: 30 });
      this.cScale4 = this.cScale4 || adjust$2(this.primaryColor, { h: 60 });
      this.cScale5 = this.cScale5 || adjust$2(this.primaryColor, { h: 90 });
      this.cScale6 = this.cScale6 || adjust$2(this.primaryColor, { h: 120 });
      this.cScale7 = this.cScale7 || adjust$2(this.primaryColor, { h: 150 });
      this.cScale8 = this.cScale8 || adjust$2(this.primaryColor, { h: 210 });
      this.cScale9 = this.cScale9 || adjust$2(this.primaryColor, { h: 270 });
      this.cScale10 = this.cScale10 || adjust$2(this.primaryColor, { h: 300 });
      this.cScale11 = this.cScale11 || adjust$2(this.primaryColor, { h: 330 });
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || invert$1(this["cScale" + i2]);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScalePeer" + i2] = this["cScalePeer" + i2] || lighten$1(this["cScale" + i2], 10);
      }
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { h: 30, s: -30, l: -(-10 + i2 * 4) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { h: 30, s: -30, l: -(-7 + i2 * 4) });
      }
      this.scaleLabelColor = this.scaleLabelColor || (this.darkMode ? "black" : this.labelTextColor);
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.scaleLabelColor;
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["pie" + i2] = this["cScale" + i2];
      }
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOuterStrokeWidth = this.pieOuterStrokeWidth || "2px";
      this.pieOuterStrokeColor = this.pieOuterStrokeColor || "black";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.quadrant1Fill = this.quadrant1Fill || this.primaryColor;
      this.quadrant2Fill = this.quadrant2Fill || adjust$2(this.primaryColor, { r: 5, g: 5, b: 5 });
      this.quadrant3Fill = this.quadrant3Fill || adjust$2(this.primaryColor, { r: 10, g: 10, b: 10 });
      this.quadrant4Fill = this.quadrant4Fill || adjust$2(this.primaryColor, { r: 15, g: 15, b: 15 });
      this.quadrant1TextFill = this.quadrant1TextFill || this.primaryTextColor;
      this.quadrant2TextFill = this.quadrant2TextFill || adjust$2(this.primaryTextColor, { r: -5, g: -5, b: -5 });
      this.quadrant3TextFill = this.quadrant3TextFill || adjust$2(this.primaryTextColor, { r: -10, g: -10, b: -10 });
      this.quadrant4TextFill = this.quadrant4TextFill || adjust$2(this.primaryTextColor, { r: -15, g: -15, b: -15 });
      this.quadrantPointFill = this.quadrantPointFill || isDark$1(this.quadrant1Fill) ? lighten$1(this.quadrant1Fill) : darken$1(this.quadrant1Fill);
      this.quadrantPointTextFill = this.quadrantPointTextFill || this.primaryTextColor;
      this.quadrantXAxisTextFill = this.quadrantXAxisTextFill || this.primaryTextColor;
      this.quadrantYAxisTextFill = this.quadrantYAxisTextFill || this.primaryTextColor;
      this.quadrantInternalBorderStrokeFill = this.quadrantInternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantExternalBorderStrokeFill = this.quadrantExternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantTitleFill = this.quadrantTitleFill || this.primaryTextColor;
      this.xyChart = {
        backgroundColor: ((_a2 = this.xyChart) == null ? void 0 : _a2.backgroundColor) || this.background,
        titleColor: ((_b2 = this.xyChart) == null ? void 0 : _b2.titleColor) || this.primaryTextColor,
        xAxisTitleColor: ((_c = this.xyChart) == null ? void 0 : _c.xAxisTitleColor) || this.primaryTextColor,
        xAxisLabelColor: ((_d = this.xyChart) == null ? void 0 : _d.xAxisLabelColor) || this.primaryTextColor,
        xAxisTickColor: ((_e = this.xyChart) == null ? void 0 : _e.xAxisTickColor) || this.primaryTextColor,
        xAxisLineColor: ((_f = this.xyChart) == null ? void 0 : _f.xAxisLineColor) || this.primaryTextColor,
        yAxisTitleColor: ((_g = this.xyChart) == null ? void 0 : _g.yAxisTitleColor) || this.primaryTextColor,
        yAxisLabelColor: ((_h = this.xyChart) == null ? void 0 : _h.yAxisLabelColor) || this.primaryTextColor,
        yAxisTickColor: ((_i = this.xyChart) == null ? void 0 : _i.yAxisTickColor) || this.primaryTextColor,
        yAxisLineColor: ((_j = this.xyChart) == null ? void 0 : _j.yAxisLineColor) || this.primaryTextColor,
        plotColorPalette: ((_k = this.xyChart) == null ? void 0 : _k.plotColorPalette) || "#3498db,#2ecc71,#e74c3c,#f1c40f,#bdc3c7,#ffffff,#34495e,#9b59b6,#1abc9c,#e67e22"
      };
      this.classText = this.primaryTextColor;
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || "1";
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || (this.darkMode ? darken$1(this.secondaryColor, 30) : this.secondaryColor);
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = lighten$1(this.secondaryColor, 20);
      this.git1 = lighten$1(this.pie2 || this.secondaryColor, 20);
      this.git2 = lighten$1(this.pie3 || this.tertiaryColor, 20);
      this.git3 = lighten$1(this.pie4 || adjust$2(this.primaryColor, { h: -30 }), 20);
      this.git4 = lighten$1(this.pie5 || adjust$2(this.primaryColor, { h: -60 }), 20);
      this.git5 = lighten$1(this.pie6 || adjust$2(this.primaryColor, { h: -90 }), 10);
      this.git6 = lighten$1(this.pie7 || adjust$2(this.primaryColor, { h: 60 }), 10);
      this.git7 = lighten$1(this.pie8 || adjust$2(this.primaryColor, { h: 120 }), 20);
      this.gitInv0 = this.gitInv0 || invert$1(this.git0);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.gitBranchLabel0 = this.gitBranchLabel0 || invert$1(this.labelTextColor);
      this.gitBranchLabel1 = this.gitBranchLabel1 || this.labelTextColor;
      this.gitBranchLabel2 = this.gitBranchLabel2 || this.labelTextColor;
      this.gitBranchLabel3 = this.gitBranchLabel3 || invert$1(this.labelTextColor);
      this.gitBranchLabel4 = this.gitBranchLabel4 || this.labelTextColor;
      this.gitBranchLabel5 = this.gitBranchLabel5 || this.labelTextColor;
      this.gitBranchLabel6 = this.gitBranchLabel6 || this.labelTextColor;
      this.gitBranchLabel7 = this.gitBranchLabel7 || this.labelTextColor;
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || lighten$1(this.background, 12);
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || lighten$1(this.background, 2);
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  };
  const getThemeVariables$3 = (userOverrides) => {
    const theme2 = new Theme$3();
    theme2.calculate(userOverrides);
    return theme2;
  };
  let Theme$2 = class Theme {
    constructor() {
      this.background = "#f4f4f4";
      this.primaryColor = "#ECECFF";
      this.secondaryColor = adjust$2(this.primaryColor, { h: 120 });
      this.secondaryColor = "#ffffde";
      this.tertiaryColor = adjust$2(this.primaryColor, { h: -160 });
      this.primaryBorderColor = mkBorder(this.primaryColor, this.darkMode);
      this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
      this.primaryTextColor = invert$1(this.primaryColor);
      this.secondaryTextColor = invert$1(this.secondaryColor);
      this.tertiaryTextColor = invert$1(this.tertiaryColor);
      this.lineColor = invert$1(this.background);
      this.textColor = invert$1(this.background);
      this.background = "white";
      this.mainBkg = "#ECECFF";
      this.secondBkg = "#ffffde";
      this.lineColor = "#333333";
      this.border1 = "#9370DB";
      this.border2 = "#aaaa33";
      this.arrowheadColor = "#333333";
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
      this.labelBackground = "#e8e8e8";
      this.textColor = "#333";
      this.THEME_COLOR_LIMIT = 12;
      this.nodeBkg = "calculated";
      this.nodeBorder = "calculated";
      this.clusterBkg = "calculated";
      this.clusterBorder = "calculated";
      this.defaultLinkColor = "calculated";
      this.titleColor = "calculated";
      this.edgeLabelBackground = "calculated";
      this.actorBorder = "calculated";
      this.actorBkg = "calculated";
      this.actorTextColor = "black";
      this.actorLineColor = "grey";
      this.signalColor = "calculated";
      this.signalTextColor = "calculated";
      this.labelBoxBkgColor = "calculated";
      this.labelBoxBorderColor = "calculated";
      this.labelTextColor = "calculated";
      this.loopTextColor = "calculated";
      this.noteBorderColor = "calculated";
      this.noteBkgColor = "#fff5ad";
      this.noteTextColor = "calculated";
      this.activationBorderColor = "#666";
      this.activationBkgColor = "#f4f4f4";
      this.sequenceNumberColor = "white";
      this.sectionBkgColor = "calculated";
      this.altSectionBkgColor = "calculated";
      this.sectionBkgColor2 = "calculated";
      this.excludeBkgColor = "#eeeeee";
      this.taskBorderColor = "calculated";
      this.taskBkgColor = "calculated";
      this.taskTextLightColor = "calculated";
      this.taskTextColor = this.taskTextLightColor;
      this.taskTextDarkColor = "calculated";
      this.taskTextOutsideColor = this.taskTextDarkColor;
      this.taskTextClickableColor = "calculated";
      this.activeTaskBorderColor = "calculated";
      this.activeTaskBkgColor = "calculated";
      this.gridColor = "calculated";
      this.doneTaskBkgColor = "calculated";
      this.doneTaskBorderColor = "calculated";
      this.critBorderColor = "calculated";
      this.critBkgColor = "calculated";
      this.todayLineColor = "calculated";
      this.sectionBkgColor = rgba$1(102, 102, 255, 0.49);
      this.altSectionBkgColor = "white";
      this.sectionBkgColor2 = "#fff400";
      this.taskBorderColor = "#534fbc";
      this.taskBkgColor = "#8a90dd";
      this.taskTextLightColor = "white";
      this.taskTextColor = "calculated";
      this.taskTextDarkColor = "black";
      this.taskTextOutsideColor = "calculated";
      this.taskTextClickableColor = "#003163";
      this.activeTaskBorderColor = "#534fbc";
      this.activeTaskBkgColor = "#bfc7ff";
      this.gridColor = "lightgrey";
      this.doneTaskBkgColor = "lightgrey";
      this.doneTaskBorderColor = "grey";
      this.critBorderColor = "#ff8888";
      this.critBkgColor = "red";
      this.todayLineColor = "red";
      this.personBorder = this.primaryBorderColor;
      this.personBkg = this.mainBkg;
      this.labelColor = "black";
      this.errorBkgColor = "#552222";
      this.errorTextColor = "#552222";
      this.updateColors();
    }
    updateColors() {
      var _a2, _b2, _c, _d, _e, _f, _g, _h, _i, _j, _k;
      this.cScale0 = this.cScale0 || this.primaryColor;
      this.cScale1 = this.cScale1 || this.secondaryColor;
      this.cScale2 = this.cScale2 || this.tertiaryColor;
      this.cScale3 = this.cScale3 || adjust$2(this.primaryColor, { h: 30 });
      this.cScale4 = this.cScale4 || adjust$2(this.primaryColor, { h: 60 });
      this.cScale5 = this.cScale5 || adjust$2(this.primaryColor, { h: 90 });
      this.cScale6 = this.cScale6 || adjust$2(this.primaryColor, { h: 120 });
      this.cScale7 = this.cScale7 || adjust$2(this.primaryColor, { h: 150 });
      this.cScale8 = this.cScale8 || adjust$2(this.primaryColor, { h: 210 });
      this.cScale9 = this.cScale9 || adjust$2(this.primaryColor, { h: 270 });
      this.cScale10 = this.cScale10 || adjust$2(this.primaryColor, { h: 300 });
      this.cScale11 = this.cScale11 || adjust$2(this.primaryColor, { h: 330 });
      this["cScalePeer1"] = this["cScalePeer1"] || darken$1(this.secondaryColor, 45);
      this["cScalePeer2"] = this["cScalePeer2"] || darken$1(this.tertiaryColor, 40);
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScale" + i2] = darken$1(this["cScale" + i2], 10);
        this["cScalePeer" + i2] = this["cScalePeer" + i2] || darken$1(this["cScale" + i2], 25);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || adjust$2(this["cScale" + i2], { h: 180 });
      }
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { h: 30, l: -(5 + i2 * 5) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { h: 30, l: -(7 + i2 * 5) });
      }
      this.scaleLabelColor = this.scaleLabelColor !== "calculated" && this.scaleLabelColor ? this.scaleLabelColor : this.labelTextColor;
      if (this.labelTextColor !== "calculated") {
        this.cScaleLabel0 = this.cScaleLabel0 || invert$1(this.labelTextColor);
        this.cScaleLabel3 = this.cScaleLabel3 || invert$1(this.labelTextColor);
        for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
          this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.labelTextColor;
        }
      }
      this.nodeBkg = this.mainBkg;
      this.nodeBorder = this.border1;
      this.clusterBkg = this.secondBkg;
      this.clusterBorder = this.border2;
      this.defaultLinkColor = this.lineColor;
      this.titleColor = this.textColor;
      this.edgeLabelBackground = this.labelBackground;
      this.actorBorder = lighten$1(this.border1, 23);
      this.actorBkg = this.mainBkg;
      this.labelBoxBkgColor = this.actorBkg;
      this.signalColor = this.textColor;
      this.signalTextColor = this.textColor;
      this.labelBoxBorderColor = this.actorBorder;
      this.labelTextColor = this.actorTextColor;
      this.loopTextColor = this.actorTextColor;
      this.noteBorderColor = this.border2;
      this.noteTextColor = this.actorTextColor;
      this.taskTextColor = this.taskTextLightColor;
      this.taskTextOutsideColor = this.taskTextDarkColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || "#f0f0f0";
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.compositeBorder = this.compositeBorder || this.nodeBorder;
      this.innerEndBackground = this.nodeBorder;
      this.specialStateColor = this.lineColor;
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.classText = this.primaryTextColor;
      this.fillType0 = this.primaryColor;
      this.fillType1 = this.secondaryColor;
      this.fillType2 = adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = adjust$2(this.secondaryColor, { h: 128 });
      this.pie1 = this.pie1 || this.primaryColor;
      this.pie2 = this.pie2 || this.secondaryColor;
      this.pie3 = this.pie3 || adjust$2(this.tertiaryColor, { l: -40 });
      this.pie4 = this.pie4 || adjust$2(this.primaryColor, { l: -10 });
      this.pie5 = this.pie5 || adjust$2(this.secondaryColor, { l: -30 });
      this.pie6 = this.pie6 || adjust$2(this.tertiaryColor, { l: -20 });
      this.pie7 = this.pie7 || adjust$2(this.primaryColor, { h: 60, l: -20 });
      this.pie8 = this.pie8 || adjust$2(this.primaryColor, { h: -60, l: -40 });
      this.pie9 = this.pie9 || adjust$2(this.primaryColor, { h: 120, l: -40 });
      this.pie10 = this.pie10 || adjust$2(this.primaryColor, { h: 60, l: -40 });
      this.pie11 = this.pie11 || adjust$2(this.primaryColor, { h: -90, l: -40 });
      this.pie12 = this.pie12 || adjust$2(this.primaryColor, { h: 120, l: -30 });
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOuterStrokeWidth = this.pieOuterStrokeWidth || "2px";
      this.pieOuterStrokeColor = this.pieOuterStrokeColor || "black";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.quadrant1Fill = this.quadrant1Fill || this.primaryColor;
      this.quadrant2Fill = this.quadrant2Fill || adjust$2(this.primaryColor, { r: 5, g: 5, b: 5 });
      this.quadrant3Fill = this.quadrant3Fill || adjust$2(this.primaryColor, { r: 10, g: 10, b: 10 });
      this.quadrant4Fill = this.quadrant4Fill || adjust$2(this.primaryColor, { r: 15, g: 15, b: 15 });
      this.quadrant1TextFill = this.quadrant1TextFill || this.primaryTextColor;
      this.quadrant2TextFill = this.quadrant2TextFill || adjust$2(this.primaryTextColor, { r: -5, g: -5, b: -5 });
      this.quadrant3TextFill = this.quadrant3TextFill || adjust$2(this.primaryTextColor, { r: -10, g: -10, b: -10 });
      this.quadrant4TextFill = this.quadrant4TextFill || adjust$2(this.primaryTextColor, { r: -15, g: -15, b: -15 });
      this.quadrantPointFill = this.quadrantPointFill || isDark$1(this.quadrant1Fill) ? lighten$1(this.quadrant1Fill) : darken$1(this.quadrant1Fill);
      this.quadrantPointTextFill = this.quadrantPointTextFill || this.primaryTextColor;
      this.quadrantXAxisTextFill = this.quadrantXAxisTextFill || this.primaryTextColor;
      this.quadrantYAxisTextFill = this.quadrantYAxisTextFill || this.primaryTextColor;
      this.quadrantInternalBorderStrokeFill = this.quadrantInternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantExternalBorderStrokeFill = this.quadrantExternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantTitleFill = this.quadrantTitleFill || this.primaryTextColor;
      this.xyChart = {
        backgroundColor: ((_a2 = this.xyChart) == null ? void 0 : _a2.backgroundColor) || this.background,
        titleColor: ((_b2 = this.xyChart) == null ? void 0 : _b2.titleColor) || this.primaryTextColor,
        xAxisTitleColor: ((_c = this.xyChart) == null ? void 0 : _c.xAxisTitleColor) || this.primaryTextColor,
        xAxisLabelColor: ((_d = this.xyChart) == null ? void 0 : _d.xAxisLabelColor) || this.primaryTextColor,
        xAxisTickColor: ((_e = this.xyChart) == null ? void 0 : _e.xAxisTickColor) || this.primaryTextColor,
        xAxisLineColor: ((_f = this.xyChart) == null ? void 0 : _f.xAxisLineColor) || this.primaryTextColor,
        yAxisTitleColor: ((_g = this.xyChart) == null ? void 0 : _g.yAxisTitleColor) || this.primaryTextColor,
        yAxisLabelColor: ((_h = this.xyChart) == null ? void 0 : _h.yAxisLabelColor) || this.primaryTextColor,
        yAxisTickColor: ((_i = this.xyChart) == null ? void 0 : _i.yAxisTickColor) || this.primaryTextColor,
        yAxisLineColor: ((_j = this.xyChart) == null ? void 0 : _j.yAxisLineColor) || this.primaryTextColor,
        plotColorPalette: ((_k = this.xyChart) == null ? void 0 : _k.plotColorPalette) || "#ECECFF,#8493A6,#FFC3A0,#DCDDE1,#B8E994,#D1A36F,#C3CDE6,#FFB6C1,#496078,#F8F3E3"
      };
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || "1";
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || this.labelBackground;
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = this.git0 || this.primaryColor;
      this.git1 = this.git1 || this.secondaryColor;
      this.git2 = this.git2 || this.tertiaryColor;
      this.git3 = this.git3 || adjust$2(this.primaryColor, { h: -30 });
      this.git4 = this.git4 || adjust$2(this.primaryColor, { h: -60 });
      this.git5 = this.git5 || adjust$2(this.primaryColor, { h: -90 });
      this.git6 = this.git6 || adjust$2(this.primaryColor, { h: 60 });
      this.git7 = this.git7 || adjust$2(this.primaryColor, { h: 120 });
      if (this.darkMode) {
        this.git0 = lighten$1(this.git0, 25);
        this.git1 = lighten$1(this.git1, 25);
        this.git2 = lighten$1(this.git2, 25);
        this.git3 = lighten$1(this.git3, 25);
        this.git4 = lighten$1(this.git4, 25);
        this.git5 = lighten$1(this.git5, 25);
        this.git6 = lighten$1(this.git6, 25);
        this.git7 = lighten$1(this.git7, 25);
      } else {
        this.git0 = darken$1(this.git0, 25);
        this.git1 = darken$1(this.git1, 25);
        this.git2 = darken$1(this.git2, 25);
        this.git3 = darken$1(this.git3, 25);
        this.git4 = darken$1(this.git4, 25);
        this.git5 = darken$1(this.git5, 25);
        this.git6 = darken$1(this.git6, 25);
        this.git7 = darken$1(this.git7, 25);
      }
      this.gitInv0 = this.gitInv0 || darken$1(invert$1(this.git0), 25);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.gitBranchLabel0 = this.gitBranchLabel0 || invert$1(this.labelTextColor);
      this.gitBranchLabel1 = this.gitBranchLabel1 || this.labelTextColor;
      this.gitBranchLabel2 = this.gitBranchLabel2 || this.labelTextColor;
      this.gitBranchLabel3 = this.gitBranchLabel3 || invert$1(this.labelTextColor);
      this.gitBranchLabel4 = this.gitBranchLabel4 || this.labelTextColor;
      this.gitBranchLabel5 = this.gitBranchLabel5 || this.labelTextColor;
      this.gitBranchLabel6 = this.gitBranchLabel6 || this.labelTextColor;
      this.gitBranchLabel7 = this.gitBranchLabel7 || this.labelTextColor;
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  };
  const getThemeVariables$2 = (userOverrides) => {
    const theme2 = new Theme$2();
    theme2.calculate(userOverrides);
    return theme2;
  };
  let Theme$1 = class Theme {
    constructor() {
      this.background = "#f4f4f4";
      this.primaryColor = "#cde498";
      this.secondaryColor = "#cdffb2";
      this.background = "white";
      this.mainBkg = "#cde498";
      this.secondBkg = "#cdffb2";
      this.lineColor = "green";
      this.border1 = "#13540c";
      this.border2 = "#6eaa49";
      this.arrowheadColor = "green";
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
      this.tertiaryColor = lighten$1("#cde498", 10);
      this.primaryBorderColor = mkBorder(this.primaryColor, this.darkMode);
      this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
      this.primaryTextColor = invert$1(this.primaryColor);
      this.secondaryTextColor = invert$1(this.secondaryColor);
      this.tertiaryTextColor = invert$1(this.primaryColor);
      this.lineColor = invert$1(this.background);
      this.textColor = invert$1(this.background);
      this.THEME_COLOR_LIMIT = 12;
      this.nodeBkg = "calculated";
      this.nodeBorder = "calculated";
      this.clusterBkg = "calculated";
      this.clusterBorder = "calculated";
      this.defaultLinkColor = "calculated";
      this.titleColor = "#333";
      this.edgeLabelBackground = "#e8e8e8";
      this.actorBorder = "calculated";
      this.actorBkg = "calculated";
      this.actorTextColor = "black";
      this.actorLineColor = "grey";
      this.signalColor = "#333";
      this.signalTextColor = "#333";
      this.labelBoxBkgColor = "calculated";
      this.labelBoxBorderColor = "#326932";
      this.labelTextColor = "calculated";
      this.loopTextColor = "calculated";
      this.noteBorderColor = "calculated";
      this.noteBkgColor = "#fff5ad";
      this.noteTextColor = "calculated";
      this.activationBorderColor = "#666";
      this.activationBkgColor = "#f4f4f4";
      this.sequenceNumberColor = "white";
      this.sectionBkgColor = "#6eaa49";
      this.altSectionBkgColor = "white";
      this.sectionBkgColor2 = "#6eaa49";
      this.excludeBkgColor = "#eeeeee";
      this.taskBorderColor = "calculated";
      this.taskBkgColor = "#487e3a";
      this.taskTextLightColor = "white";
      this.taskTextColor = "calculated";
      this.taskTextDarkColor = "black";
      this.taskTextOutsideColor = "calculated";
      this.taskTextClickableColor = "#003163";
      this.activeTaskBorderColor = "calculated";
      this.activeTaskBkgColor = "calculated";
      this.gridColor = "lightgrey";
      this.doneTaskBkgColor = "lightgrey";
      this.doneTaskBorderColor = "grey";
      this.critBorderColor = "#ff8888";
      this.critBkgColor = "red";
      this.todayLineColor = "red";
      this.personBorder = this.primaryBorderColor;
      this.personBkg = this.mainBkg;
      this.labelColor = "black";
      this.errorBkgColor = "#552222";
      this.errorTextColor = "#552222";
    }
    updateColors() {
      var _a2, _b2, _c, _d, _e, _f, _g, _h, _i, _j, _k;
      this.actorBorder = darken$1(this.mainBkg, 20);
      this.actorBkg = this.mainBkg;
      this.labelBoxBkgColor = this.actorBkg;
      this.labelTextColor = this.actorTextColor;
      this.loopTextColor = this.actorTextColor;
      this.noteBorderColor = this.border2;
      this.noteTextColor = this.actorTextColor;
      this.cScale0 = this.cScale0 || this.primaryColor;
      this.cScale1 = this.cScale1 || this.secondaryColor;
      this.cScale2 = this.cScale2 || this.tertiaryColor;
      this.cScale3 = this.cScale3 || adjust$2(this.primaryColor, { h: 30 });
      this.cScale4 = this.cScale4 || adjust$2(this.primaryColor, { h: 60 });
      this.cScale5 = this.cScale5 || adjust$2(this.primaryColor, { h: 90 });
      this.cScale6 = this.cScale6 || adjust$2(this.primaryColor, { h: 120 });
      this.cScale7 = this.cScale7 || adjust$2(this.primaryColor, { h: 150 });
      this.cScale8 = this.cScale8 || adjust$2(this.primaryColor, { h: 210 });
      this.cScale9 = this.cScale9 || adjust$2(this.primaryColor, { h: 270 });
      this.cScale10 = this.cScale10 || adjust$2(this.primaryColor, { h: 300 });
      this.cScale11 = this.cScale11 || adjust$2(this.primaryColor, { h: 330 });
      this["cScalePeer1"] = this["cScalePeer1"] || darken$1(this.secondaryColor, 45);
      this["cScalePeer2"] = this["cScalePeer2"] || darken$1(this.tertiaryColor, 40);
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScale" + i2] = darken$1(this["cScale" + i2], 10);
        this["cScalePeer" + i2] = this["cScalePeer" + i2] || darken$1(this["cScale" + i2], 25);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || adjust$2(this["cScale" + i2], { h: 180 });
      }
      this.scaleLabelColor = this.scaleLabelColor !== "calculated" && this.scaleLabelColor ? this.scaleLabelColor : this.labelTextColor;
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.scaleLabelColor;
      }
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { h: 30, s: -30, l: -(5 + i2 * 5) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { h: 30, s: -30, l: -(8 + i2 * 5) });
      }
      this.nodeBkg = this.mainBkg;
      this.nodeBorder = this.border1;
      this.clusterBkg = this.secondBkg;
      this.clusterBorder = this.border2;
      this.defaultLinkColor = this.lineColor;
      this.taskBorderColor = this.border1;
      this.taskTextColor = this.taskTextLightColor;
      this.taskTextOutsideColor = this.taskTextDarkColor;
      this.activeTaskBorderColor = this.taskBorderColor;
      this.activeTaskBkgColor = this.mainBkg;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || "#f0f0f0";
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.compositeBorder = this.compositeBorder || this.nodeBorder;
      this.innerEndBackground = this.primaryBorderColor;
      this.specialStateColor = this.lineColor;
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.transitionColor = this.transitionColor || this.lineColor;
      this.classText = this.primaryTextColor;
      this.fillType0 = this.primaryColor;
      this.fillType1 = this.secondaryColor;
      this.fillType2 = adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = adjust$2(this.secondaryColor, { h: 128 });
      this.pie1 = this.pie1 || this.primaryColor;
      this.pie2 = this.pie2 || this.secondaryColor;
      this.pie3 = this.pie3 || this.tertiaryColor;
      this.pie4 = this.pie4 || adjust$2(this.primaryColor, { l: -30 });
      this.pie5 = this.pie5 || adjust$2(this.secondaryColor, { l: -30 });
      this.pie6 = this.pie6 || adjust$2(this.tertiaryColor, { h: 40, l: -40 });
      this.pie7 = this.pie7 || adjust$2(this.primaryColor, { h: 60, l: -10 });
      this.pie8 = this.pie8 || adjust$2(this.primaryColor, { h: -60, l: -10 });
      this.pie9 = this.pie9 || adjust$2(this.primaryColor, { h: 120, l: 0 });
      this.pie10 = this.pie10 || adjust$2(this.primaryColor, { h: 60, l: -50 });
      this.pie11 = this.pie11 || adjust$2(this.primaryColor, { h: -60, l: -50 });
      this.pie12 = this.pie12 || adjust$2(this.primaryColor, { h: 120, l: -50 });
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOuterStrokeWidth = this.pieOuterStrokeWidth || "2px";
      this.pieOuterStrokeColor = this.pieOuterStrokeColor || "black";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.quadrant1Fill = this.quadrant1Fill || this.primaryColor;
      this.quadrant2Fill = this.quadrant2Fill || adjust$2(this.primaryColor, { r: 5, g: 5, b: 5 });
      this.quadrant3Fill = this.quadrant3Fill || adjust$2(this.primaryColor, { r: 10, g: 10, b: 10 });
      this.quadrant4Fill = this.quadrant4Fill || adjust$2(this.primaryColor, { r: 15, g: 15, b: 15 });
      this.quadrant1TextFill = this.quadrant1TextFill || this.primaryTextColor;
      this.quadrant2TextFill = this.quadrant2TextFill || adjust$2(this.primaryTextColor, { r: -5, g: -5, b: -5 });
      this.quadrant3TextFill = this.quadrant3TextFill || adjust$2(this.primaryTextColor, { r: -10, g: -10, b: -10 });
      this.quadrant4TextFill = this.quadrant4TextFill || adjust$2(this.primaryTextColor, { r: -15, g: -15, b: -15 });
      this.quadrantPointFill = this.quadrantPointFill || isDark$1(this.quadrant1Fill) ? lighten$1(this.quadrant1Fill) : darken$1(this.quadrant1Fill);
      this.quadrantPointTextFill = this.quadrantPointTextFill || this.primaryTextColor;
      this.quadrantXAxisTextFill = this.quadrantXAxisTextFill || this.primaryTextColor;
      this.quadrantYAxisTextFill = this.quadrantYAxisTextFill || this.primaryTextColor;
      this.quadrantInternalBorderStrokeFill = this.quadrantInternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantExternalBorderStrokeFill = this.quadrantExternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantTitleFill = this.quadrantTitleFill || this.primaryTextColor;
      this.xyChart = {
        backgroundColor: ((_a2 = this.xyChart) == null ? void 0 : _a2.backgroundColor) || this.background,
        titleColor: ((_b2 = this.xyChart) == null ? void 0 : _b2.titleColor) || this.primaryTextColor,
        xAxisTitleColor: ((_c = this.xyChart) == null ? void 0 : _c.xAxisTitleColor) || this.primaryTextColor,
        xAxisLabelColor: ((_d = this.xyChart) == null ? void 0 : _d.xAxisLabelColor) || this.primaryTextColor,
        xAxisTickColor: ((_e = this.xyChart) == null ? void 0 : _e.xAxisTickColor) || this.primaryTextColor,
        xAxisLineColor: ((_f = this.xyChart) == null ? void 0 : _f.xAxisLineColor) || this.primaryTextColor,
        yAxisTitleColor: ((_g = this.xyChart) == null ? void 0 : _g.yAxisTitleColor) || this.primaryTextColor,
        yAxisLabelColor: ((_h = this.xyChart) == null ? void 0 : _h.yAxisLabelColor) || this.primaryTextColor,
        yAxisTickColor: ((_i = this.xyChart) == null ? void 0 : _i.yAxisTickColor) || this.primaryTextColor,
        yAxisLineColor: ((_j = this.xyChart) == null ? void 0 : _j.yAxisLineColor) || this.primaryTextColor,
        plotColorPalette: ((_k = this.xyChart) == null ? void 0 : _k.plotColorPalette) || "#CDE498,#FF6B6B,#A0D2DB,#D7BDE2,#F0F0F0,#FFC3A0,#7FD8BE,#FF9A8B,#FAF3E0,#FFF176"
      };
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || "1";
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || this.edgeLabelBackground;
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = this.git0 || this.primaryColor;
      this.git1 = this.git1 || this.secondaryColor;
      this.git2 = this.git2 || this.tertiaryColor;
      this.git3 = this.git3 || adjust$2(this.primaryColor, { h: -30 });
      this.git4 = this.git4 || adjust$2(this.primaryColor, { h: -60 });
      this.git5 = this.git5 || adjust$2(this.primaryColor, { h: -90 });
      this.git6 = this.git6 || adjust$2(this.primaryColor, { h: 60 });
      this.git7 = this.git7 || adjust$2(this.primaryColor, { h: 120 });
      if (this.darkMode) {
        this.git0 = lighten$1(this.git0, 25);
        this.git1 = lighten$1(this.git1, 25);
        this.git2 = lighten$1(this.git2, 25);
        this.git3 = lighten$1(this.git3, 25);
        this.git4 = lighten$1(this.git4, 25);
        this.git5 = lighten$1(this.git5, 25);
        this.git6 = lighten$1(this.git6, 25);
        this.git7 = lighten$1(this.git7, 25);
      } else {
        this.git0 = darken$1(this.git0, 25);
        this.git1 = darken$1(this.git1, 25);
        this.git2 = darken$1(this.git2, 25);
        this.git3 = darken$1(this.git3, 25);
        this.git4 = darken$1(this.git4, 25);
        this.git5 = darken$1(this.git5, 25);
        this.git6 = darken$1(this.git6, 25);
        this.git7 = darken$1(this.git7, 25);
      }
      this.gitInv0 = this.gitInv0 || invert$1(this.git0);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.gitBranchLabel0 = this.gitBranchLabel0 || invert$1(this.labelTextColor);
      this.gitBranchLabel1 = this.gitBranchLabel1 || this.labelTextColor;
      this.gitBranchLabel2 = this.gitBranchLabel2 || this.labelTextColor;
      this.gitBranchLabel3 = this.gitBranchLabel3 || invert$1(this.labelTextColor);
      this.gitBranchLabel4 = this.gitBranchLabel4 || this.labelTextColor;
      this.gitBranchLabel5 = this.gitBranchLabel5 || this.labelTextColor;
      this.gitBranchLabel6 = this.gitBranchLabel6 || this.labelTextColor;
      this.gitBranchLabel7 = this.gitBranchLabel7 || this.labelTextColor;
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  };
  const getThemeVariables$1 = (userOverrides) => {
    const theme2 = new Theme$1();
    theme2.calculate(userOverrides);
    return theme2;
  };
  class Theme {
    constructor() {
      this.primaryColor = "#eee";
      this.contrast = "#707070";
      this.secondaryColor = lighten$1(this.contrast, 55);
      this.background = "#ffffff";
      this.tertiaryColor = adjust$2(this.primaryColor, { h: -160 });
      this.primaryBorderColor = mkBorder(this.primaryColor, this.darkMode);
      this.secondaryBorderColor = mkBorder(this.secondaryColor, this.darkMode);
      this.tertiaryBorderColor = mkBorder(this.tertiaryColor, this.darkMode);
      this.primaryTextColor = invert$1(this.primaryColor);
      this.secondaryTextColor = invert$1(this.secondaryColor);
      this.tertiaryTextColor = invert$1(this.tertiaryColor);
      this.lineColor = invert$1(this.background);
      this.textColor = invert$1(this.background);
      this.mainBkg = "#eee";
      this.secondBkg = "calculated";
      this.lineColor = "#666";
      this.border1 = "#999";
      this.border2 = "calculated";
      this.note = "#ffa";
      this.text = "#333";
      this.critical = "#d42";
      this.done = "#bbb";
      this.arrowheadColor = "#333333";
      this.fontFamily = '"trebuchet ms", verdana, arial, sans-serif';
      this.fontSize = "16px";
      this.THEME_COLOR_LIMIT = 12;
      this.nodeBkg = "calculated";
      this.nodeBorder = "calculated";
      this.clusterBkg = "calculated";
      this.clusterBorder = "calculated";
      this.defaultLinkColor = "calculated";
      this.titleColor = "calculated";
      this.edgeLabelBackground = "white";
      this.actorBorder = "calculated";
      this.actorBkg = "calculated";
      this.actorTextColor = "calculated";
      this.actorLineColor = "calculated";
      this.signalColor = "calculated";
      this.signalTextColor = "calculated";
      this.labelBoxBkgColor = "calculated";
      this.labelBoxBorderColor = "calculated";
      this.labelTextColor = "calculated";
      this.loopTextColor = "calculated";
      this.noteBorderColor = "calculated";
      this.noteBkgColor = "calculated";
      this.noteTextColor = "calculated";
      this.activationBorderColor = "#666";
      this.activationBkgColor = "#f4f4f4";
      this.sequenceNumberColor = "white";
      this.sectionBkgColor = "calculated";
      this.altSectionBkgColor = "white";
      this.sectionBkgColor2 = "calculated";
      this.excludeBkgColor = "#eeeeee";
      this.taskBorderColor = "calculated";
      this.taskBkgColor = "calculated";
      this.taskTextLightColor = "white";
      this.taskTextColor = "calculated";
      this.taskTextDarkColor = "calculated";
      this.taskTextOutsideColor = "calculated";
      this.taskTextClickableColor = "#003163";
      this.activeTaskBorderColor = "calculated";
      this.activeTaskBkgColor = "calculated";
      this.gridColor = "calculated";
      this.doneTaskBkgColor = "calculated";
      this.doneTaskBorderColor = "calculated";
      this.critBkgColor = "calculated";
      this.critBorderColor = "calculated";
      this.todayLineColor = "calculated";
      this.personBorder = this.primaryBorderColor;
      this.personBkg = this.mainBkg;
      this.labelColor = "black";
      this.errorBkgColor = "#552222";
      this.errorTextColor = "#552222";
    }
    updateColors() {
      var _a2, _b2, _c, _d, _e, _f, _g, _h, _i, _j, _k;
      this.secondBkg = lighten$1(this.contrast, 55);
      this.border2 = this.contrast;
      this.actorBorder = lighten$1(this.border1, 23);
      this.actorBkg = this.mainBkg;
      this.actorTextColor = this.text;
      this.actorLineColor = this.lineColor;
      this.signalColor = this.text;
      this.signalTextColor = this.text;
      this.labelBoxBkgColor = this.actorBkg;
      this.labelBoxBorderColor = this.actorBorder;
      this.labelTextColor = this.text;
      this.loopTextColor = this.text;
      this.noteBorderColor = "#999";
      this.noteBkgColor = "#666";
      this.noteTextColor = "#fff";
      this.cScale0 = this.cScale0 || "#555";
      this.cScale1 = this.cScale1 || "#F4F4F4";
      this.cScale2 = this.cScale2 || "#555";
      this.cScale3 = this.cScale3 || "#BBB";
      this.cScale4 = this.cScale4 || "#777";
      this.cScale5 = this.cScale5 || "#999";
      this.cScale6 = this.cScale6 || "#DDD";
      this.cScale7 = this.cScale7 || "#FFF";
      this.cScale8 = this.cScale8 || "#DDD";
      this.cScale9 = this.cScale9 || "#BBB";
      this.cScale10 = this.cScale10 || "#999";
      this.cScale11 = this.cScale11 || "#777";
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleInv" + i2] = this["cScaleInv" + i2] || invert$1(this["cScale" + i2]);
      }
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        if (this.darkMode) {
          this["cScalePeer" + i2] = this["cScalePeer" + i2] || lighten$1(this["cScale" + i2], 10);
        } else {
          this["cScalePeer" + i2] = this["cScalePeer" + i2] || darken$1(this["cScale" + i2], 10);
        }
      }
      this.scaleLabelColor = this.scaleLabelColor || (this.darkMode ? "black" : this.labelTextColor);
      this["cScaleLabel0"] = this["cScaleLabel0"] || this.cScale1;
      this["cScaleLabel2"] = this["cScaleLabel2"] || this.cScale1;
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["cScaleLabel" + i2] = this["cScaleLabel" + i2] || this.scaleLabelColor;
      }
      for (let i2 = 0; i2 < 5; i2++) {
        this["surface" + i2] = this["surface" + i2] || adjust$2(this.mainBkg, { l: -(5 + i2 * 5) });
        this["surfacePeer" + i2] = this["surfacePeer" + i2] || adjust$2(this.mainBkg, { l: -(8 + i2 * 5) });
      }
      this.nodeBkg = this.mainBkg;
      this.nodeBorder = this.border1;
      this.clusterBkg = this.secondBkg;
      this.clusterBorder = this.border2;
      this.defaultLinkColor = this.lineColor;
      this.titleColor = this.text;
      this.sectionBkgColor = lighten$1(this.contrast, 30);
      this.sectionBkgColor2 = lighten$1(this.contrast, 30);
      this.taskBorderColor = darken$1(this.contrast, 10);
      this.taskBkgColor = this.contrast;
      this.taskTextColor = this.taskTextLightColor;
      this.taskTextDarkColor = this.text;
      this.taskTextOutsideColor = this.taskTextDarkColor;
      this.activeTaskBorderColor = this.taskBorderColor;
      this.activeTaskBkgColor = this.mainBkg;
      this.gridColor = lighten$1(this.border1, 30);
      this.doneTaskBkgColor = this.done;
      this.doneTaskBorderColor = this.lineColor;
      this.critBkgColor = this.critical;
      this.critBorderColor = darken$1(this.critBkgColor, 10);
      this.todayLineColor = this.critBkgColor;
      this.transitionColor = this.transitionColor || "#000";
      this.transitionLabelColor = this.transitionLabelColor || this.textColor;
      this.stateLabelColor = this.stateLabelColor || this.stateBkg || this.primaryTextColor;
      this.stateBkg = this.stateBkg || this.mainBkg;
      this.labelBackgroundColor = this.labelBackgroundColor || this.stateBkg;
      this.compositeBackground = this.compositeBackground || this.background || this.tertiaryColor;
      this.altBackground = this.altBackground || "#f4f4f4";
      this.compositeTitleBackground = this.compositeTitleBackground || this.mainBkg;
      this.stateBorder = this.stateBorder || "#000";
      this.innerEndBackground = this.primaryBorderColor;
      this.specialStateColor = "#222";
      this.errorBkgColor = this.errorBkgColor || this.tertiaryColor;
      this.errorTextColor = this.errorTextColor || this.tertiaryTextColor;
      this.classText = this.primaryTextColor;
      this.fillType0 = this.primaryColor;
      this.fillType1 = this.secondaryColor;
      this.fillType2 = adjust$2(this.primaryColor, { h: 64 });
      this.fillType3 = adjust$2(this.secondaryColor, { h: 64 });
      this.fillType4 = adjust$2(this.primaryColor, { h: -64 });
      this.fillType5 = adjust$2(this.secondaryColor, { h: -64 });
      this.fillType6 = adjust$2(this.primaryColor, { h: 128 });
      this.fillType7 = adjust$2(this.secondaryColor, { h: 128 });
      for (let i2 = 0; i2 < this.THEME_COLOR_LIMIT; i2++) {
        this["pie" + i2] = this["cScale" + i2];
      }
      this.pie12 = this.pie0;
      this.pieTitleTextSize = this.pieTitleTextSize || "25px";
      this.pieTitleTextColor = this.pieTitleTextColor || this.taskTextDarkColor;
      this.pieSectionTextSize = this.pieSectionTextSize || "17px";
      this.pieSectionTextColor = this.pieSectionTextColor || this.textColor;
      this.pieLegendTextSize = this.pieLegendTextSize || "17px";
      this.pieLegendTextColor = this.pieLegendTextColor || this.taskTextDarkColor;
      this.pieStrokeColor = this.pieStrokeColor || "black";
      this.pieStrokeWidth = this.pieStrokeWidth || "2px";
      this.pieOuterStrokeWidth = this.pieOuterStrokeWidth || "2px";
      this.pieOuterStrokeColor = this.pieOuterStrokeColor || "black";
      this.pieOpacity = this.pieOpacity || "0.7";
      this.quadrant1Fill = this.quadrant1Fill || this.primaryColor;
      this.quadrant2Fill = this.quadrant2Fill || adjust$2(this.primaryColor, { r: 5, g: 5, b: 5 });
      this.quadrant3Fill = this.quadrant3Fill || adjust$2(this.primaryColor, { r: 10, g: 10, b: 10 });
      this.quadrant4Fill = this.quadrant4Fill || adjust$2(this.primaryColor, { r: 15, g: 15, b: 15 });
      this.quadrant1TextFill = this.quadrant1TextFill || this.primaryTextColor;
      this.quadrant2TextFill = this.quadrant2TextFill || adjust$2(this.primaryTextColor, { r: -5, g: -5, b: -5 });
      this.quadrant3TextFill = this.quadrant3TextFill || adjust$2(this.primaryTextColor, { r: -10, g: -10, b: -10 });
      this.quadrant4TextFill = this.quadrant4TextFill || adjust$2(this.primaryTextColor, { r: -15, g: -15, b: -15 });
      this.quadrantPointFill = this.quadrantPointFill || isDark$1(this.quadrant1Fill) ? lighten$1(this.quadrant1Fill) : darken$1(this.quadrant1Fill);
      this.quadrantPointTextFill = this.quadrantPointTextFill || this.primaryTextColor;
      this.quadrantXAxisTextFill = this.quadrantXAxisTextFill || this.primaryTextColor;
      this.quadrantYAxisTextFill = this.quadrantYAxisTextFill || this.primaryTextColor;
      this.quadrantInternalBorderStrokeFill = this.quadrantInternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantExternalBorderStrokeFill = this.quadrantExternalBorderStrokeFill || this.primaryBorderColor;
      this.quadrantTitleFill = this.quadrantTitleFill || this.primaryTextColor;
      this.xyChart = {
        backgroundColor: ((_a2 = this.xyChart) == null ? void 0 : _a2.backgroundColor) || this.background,
        titleColor: ((_b2 = this.xyChart) == null ? void 0 : _b2.titleColor) || this.primaryTextColor,
        xAxisTitleColor: ((_c = this.xyChart) == null ? void 0 : _c.xAxisTitleColor) || this.primaryTextColor,
        xAxisLabelColor: ((_d = this.xyChart) == null ? void 0 : _d.xAxisLabelColor) || this.primaryTextColor,
        xAxisTickColor: ((_e = this.xyChart) == null ? void 0 : _e.xAxisTickColor) || this.primaryTextColor,
        xAxisLineColor: ((_f = this.xyChart) == null ? void 0 : _f.xAxisLineColor) || this.primaryTextColor,
        yAxisTitleColor: ((_g = this.xyChart) == null ? void 0 : _g.yAxisTitleColor) || this.primaryTextColor,
        yAxisLabelColor: ((_h = this.xyChart) == null ? void 0 : _h.yAxisLabelColor) || this.primaryTextColor,
        yAxisTickColor: ((_i = this.xyChart) == null ? void 0 : _i.yAxisTickColor) || this.primaryTextColor,
        yAxisLineColor: ((_j = this.xyChart) == null ? void 0 : _j.yAxisLineColor) || this.primaryTextColor,
        plotColorPalette: ((_k = this.xyChart) == null ? void 0 : _k.plotColorPalette) || "#EEE,#6BB8E4,#8ACB88,#C7ACD6,#E8DCC2,#FFB2A8,#FFF380,#7E8D91,#FFD8B1,#FAF3E0"
      };
      this.requirementBackground = this.requirementBackground || this.primaryColor;
      this.requirementBorderColor = this.requirementBorderColor || this.primaryBorderColor;
      this.requirementBorderSize = this.requirementBorderSize || "1";
      this.requirementTextColor = this.requirementTextColor || this.primaryTextColor;
      this.relationColor = this.relationColor || this.lineColor;
      this.relationLabelBackground = this.relationLabelBackground || this.edgeLabelBackground;
      this.relationLabelColor = this.relationLabelColor || this.actorTextColor;
      this.git0 = darken$1(this.pie1, 25) || this.primaryColor;
      this.git1 = this.pie2 || this.secondaryColor;
      this.git2 = this.pie3 || this.tertiaryColor;
      this.git3 = this.pie4 || adjust$2(this.primaryColor, { h: -30 });
      this.git4 = this.pie5 || adjust$2(this.primaryColor, { h: -60 });
      this.git5 = this.pie6 || adjust$2(this.primaryColor, { h: -90 });
      this.git6 = this.pie7 || adjust$2(this.primaryColor, { h: 60 });
      this.git7 = this.pie8 || adjust$2(this.primaryColor, { h: 120 });
      this.gitInv0 = this.gitInv0 || invert$1(this.git0);
      this.gitInv1 = this.gitInv1 || invert$1(this.git1);
      this.gitInv2 = this.gitInv2 || invert$1(this.git2);
      this.gitInv3 = this.gitInv3 || invert$1(this.git3);
      this.gitInv4 = this.gitInv4 || invert$1(this.git4);
      this.gitInv5 = this.gitInv5 || invert$1(this.git5);
      this.gitInv6 = this.gitInv6 || invert$1(this.git6);
      this.gitInv7 = this.gitInv7 || invert$1(this.git7);
      this.branchLabelColor = this.branchLabelColor || this.labelTextColor;
      this.gitBranchLabel0 = this.branchLabelColor;
      this.gitBranchLabel1 = "white";
      this.gitBranchLabel2 = this.branchLabelColor;
      this.gitBranchLabel3 = "white";
      this.gitBranchLabel4 = this.branchLabelColor;
      this.gitBranchLabel5 = this.branchLabelColor;
      this.gitBranchLabel6 = this.branchLabelColor;
      this.gitBranchLabel7 = this.branchLabelColor;
      this.tagLabelColor = this.tagLabelColor || this.primaryTextColor;
      this.tagLabelBackground = this.tagLabelBackground || this.primaryColor;
      this.tagLabelBorder = this.tagBorder || this.primaryBorderColor;
      this.tagLabelFontSize = this.tagLabelFontSize || "10px";
      this.commitLabelColor = this.commitLabelColor || this.secondaryTextColor;
      this.commitLabelBackground = this.commitLabelBackground || this.secondaryColor;
      this.commitLabelFontSize = this.commitLabelFontSize || "10px";
      this.attributeBackgroundColorOdd = this.attributeBackgroundColorOdd || oldAttributeBackgroundColorOdd;
      this.attributeBackgroundColorEven = this.attributeBackgroundColorEven || oldAttributeBackgroundColorEven;
    }
    calculate(overrides) {
      if (typeof overrides !== "object") {
        this.updateColors();
        return;
      }
      const keys2 = Object.keys(overrides);
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
      this.updateColors();
      keys2.forEach((k) => {
        this[k] = overrides[k];
      });
    }
  }
  const getThemeVariables = (userOverrides) => {
    const theme2 = new Theme();
    theme2.calculate(userOverrides);
    return theme2;
  };
  const theme = {
    base: {
      getThemeVariables: getThemeVariables$4
    },
    dark: {
      getThemeVariables: getThemeVariables$3
    },
    default: {
      getThemeVariables: getThemeVariables$2
    },
    forest: {
      getThemeVariables: getThemeVariables$1
    },
    neutral: {
      getThemeVariables
    }
  };
  const defaultConfigJson = {
    "flowchart": {
      "useMaxWidth": true,
      "titleTopMargin": 25,
      "subGraphTitleMargin": {
        "top": 0,
        "bottom": 0
      },
      "diagramPadding": 8,
      "htmlLabels": true,
      "nodeSpacing": 50,
      "rankSpacing": 50,
      "curve": "basis",
      "padding": 15,
      "defaultRenderer": "dagre-wrapper",
      "wrappingWidth": 200
    },
    "sequence": {
      "useMaxWidth": true,
      "hideUnusedParticipants": false,
      "activationWidth": 10,
      "diagramMarginX": 50,
      "diagramMarginY": 10,
      "actorMargin": 50,
      "width": 150,
      "height": 65,
      "boxMargin": 10,
      "boxTextMargin": 5,
      "noteMargin": 10,
      "messageMargin": 35,
      "messageAlign": "center",
      "mirrorActors": true,
      "forceMenus": false,
      "bottomMarginAdj": 1,
      "rightAngles": false,
      "showSequenceNumbers": false,
      "actorFontSize": 14,
      "actorFontFamily": '"Open Sans", sans-serif',
      "actorFontWeight": 400,
      "noteFontSize": 14,
      "noteFontFamily": '"trebuchet ms", verdana, arial, sans-serif',
      "noteFontWeight": 400,
      "noteAlign": "center",
      "messageFontSize": 16,
      "messageFontFamily": '"trebuchet ms", verdana, arial, sans-serif',
      "messageFontWeight": 400,
      "wrap": false,
      "wrapPadding": 10,
      "labelBoxWidth": 50,
      "labelBoxHeight": 20
    },
    "gantt": {
      "useMaxWidth": true,
      "titleTopMargin": 25,
      "barHeight": 20,
      "barGap": 4,
      "topPadding": 50,
      "rightPadding": 75,
      "leftPadding": 75,
      "gridLineStartPadding": 35,
      "fontSize": 11,
      "sectionFontSize": 11,
      "numberSectionStyles": 4,
      "axisFormat": "%Y-%m-%d",
      "topAxis": false,
      "displayMode": "",
      "weekday": "sunday"
    },
    "journey": {
      "useMaxWidth": true,
      "diagramMarginX": 50,
      "diagramMarginY": 10,
      "leftMargin": 150,
      "width": 150,
      "height": 50,
      "boxMargin": 10,
      "boxTextMargin": 5,
      "noteMargin": 10,
      "messageMargin": 35,
      "messageAlign": "center",
      "bottomMarginAdj": 1,
      "rightAngles": false,
      "taskFontSize": 14,
      "taskFontFamily": '"Open Sans", sans-serif',
      "taskMargin": 50,
      "activationWidth": 10,
      "textPlacement": "fo",
      "actorColours": [
        "#8FBC8F",
        "#7CFC00",
        "#00FFFF",
        "#20B2AA",
        "#B0E0E6",
        "#FFFFE0"
      ],
      "sectionFills": [
        "#191970",
        "#8B008B",
        "#4B0082",
        "#2F4F4F",
        "#800000",
        "#8B4513",
        "#00008B"
      ],
      "sectionColours": [
        "#fff"
      ]
    },
    "class": {
      "useMaxWidth": true,
      "titleTopMargin": 25,
      "arrowMarkerAbsolute": false,
      "dividerMargin": 10,
      "padding": 5,
      "textHeight": 10,
      "defaultRenderer": "dagre-wrapper",
      "htmlLabels": false
    },
    "state": {
      "useMaxWidth": true,
      "titleTopMargin": 25,
      "dividerMargin": 10,
      "sizeUnit": 5,
      "padding": 8,
      "textHeight": 10,
      "titleShift": -15,
      "noteMargin": 10,
      "forkWidth": 70,
      "forkHeight": 7,
      "miniPadding": 2,
      "fontSizeFactor": 5.02,
      "fontSize": 24,
      "labelHeight": 16,
      "edgeLengthFactor": "20",
      "compositTitleSize": 35,
      "radius": 5,
      "defaultRenderer": "dagre-wrapper"
    },
    "er": {
      "useMaxWidth": true,
      "titleTopMargin": 25,
      "diagramPadding": 20,
      "layoutDirection": "TB",
      "minEntityWidth": 100,
      "minEntityHeight": 75,
      "entityPadding": 15,
      "stroke": "gray",
      "fill": "honeydew",
      "fontSize": 12
    },
    "pie": {
      "useMaxWidth": true,
      "textPosition": 0.75
    },
    "quadrantChart": {
      "useMaxWidth": true,
      "chartWidth": 500,
      "chartHeight": 500,
      "titleFontSize": 20,
      "titlePadding": 10,
      "quadrantPadding": 5,
      "xAxisLabelPadding": 5,
      "yAxisLabelPadding": 5,
      "xAxisLabelFontSize": 16,
      "yAxisLabelFontSize": 16,
      "quadrantLabelFontSize": 16,
      "quadrantTextTopPadding": 5,
      "pointTextPadding": 5,
      "pointLabelFontSize": 12,
      "pointRadius": 5,
      "xAxisPosition": "top",
      "yAxisPosition": "left",
      "quadrantInternalBorderStrokeWidth": 1,
      "quadrantExternalBorderStrokeWidth": 2
    },
    "xyChart": {
      "useMaxWidth": true,
      "width": 700,
      "height": 500,
      "titleFontSize": 20,
      "titlePadding": 10,
      "showTitle": true,
      "xAxis": {
        "$ref": "#/$defs/XYChartAxisConfig",
        "showLabel": true,
        "labelFontSize": 14,
        "labelPadding": 5,
        "showTitle": true,
        "titleFontSize": 16,
        "titlePadding": 5,
        "showTick": true,
        "tickLength": 5,
        "tickWidth": 2,
        "showAxisLine": true,
        "axisLineWidth": 2
      },
      "yAxis": {
        "$ref": "#/$defs/XYChartAxisConfig",
        "showLabel": true,
        "labelFontSize": 14,
        "labelPadding": 5,
        "showTitle": true,
        "titleFontSize": 16,
        "titlePadding": 5,
        "showTick": true,
        "tickLength": 5,
        "tickWidth": 2,
        "showAxisLine": true,
        "axisLineWidth": 2
      },
      "chartOrientation": "vertical",
      "plotReservedSpacePercent": 50
    },
    "requirement": {
      "useMaxWidth": true,
      "rect_fill": "#f9f9f9",
      "text_color": "#333",
      "rect_border_size": "0.5px",
      "rect_border_color": "#bbb",
      "rect_min_width": 200,
      "rect_min_height": 200,
      "fontSize": 14,
      "rect_padding": 10,
      "line_height": 20
    },
    "mindmap": {
      "useMaxWidth": true,
      "padding": 10,
      "maxNodeWidth": 200
    },
    "timeline": {
      "useMaxWidth": true,
      "diagramMarginX": 50,
      "diagramMarginY": 10,
      "leftMargin": 150,
      "width": 150,
      "height": 50,
      "boxMargin": 10,
      "boxTextMargin": 5,
      "noteMargin": 10,
      "messageMargin": 35,
      "messageAlign": "center",
      "bottomMarginAdj": 1,
      "rightAngles": false,
      "taskFontSize": 14,
      "taskFontFamily": '"Open Sans", sans-serif',
      "taskMargin": 50,
      "activationWidth": 10,
      "textPlacement": "fo",
      "actorColours": [
        "#8FBC8F",
        "#7CFC00",
        "#00FFFF",
        "#20B2AA",
        "#B0E0E6",
        "#FFFFE0"
      ],
      "sectionFills": [
        "#191970",
        "#8B008B",
        "#4B0082",
        "#2F4F4F",
        "#800000",
        "#8B4513",
        "#00008B"
      ],
      "sectionColours": [
        "#fff"
      ],
      "disableMulticolor": false
    },
    "gitGraph": {
      "useMaxWidth": true,
      "titleTopMargin": 25,
      "diagramPadding": 8,
      "nodeLabel": {
        "width": 75,
        "height": 100,
        "x": -25,
        "y": 0
      },
      "mainBranchName": "main",
      "mainBranchOrder": 0,
      "showCommitLabel": true,
      "showBranches": true,
      "rotateCommitLabel": true,
      "parallelCommits": false,
      "arrowMarkerAbsolute": false
    },
    "c4": {
      "useMaxWidth": true,
      "diagramMarginX": 50,
      "diagramMarginY": 10,
      "c4ShapeMargin": 50,
      "c4ShapePadding": 20,
      "width": 216,
      "height": 60,
      "boxMargin": 10,
      "c4ShapeInRow": 4,
      "nextLinePaddingX": 0,
      "c4BoundaryInRow": 2,
      "personFontSize": 14,
      "personFontFamily": '"Open Sans", sans-serif',
      "personFontWeight": "normal",
      "external_personFontSize": 14,
      "external_personFontFamily": '"Open Sans", sans-serif',
      "external_personFontWeight": "normal",
      "systemFontSize": 14,
      "systemFontFamily": '"Open Sans", sans-serif',
      "systemFontWeight": "normal",
      "external_systemFontSize": 14,
      "external_systemFontFamily": '"Open Sans", sans-serif',
      "external_systemFontWeight": "normal",
      "system_dbFontSize": 14,
      "system_dbFontFamily": '"Open Sans", sans-serif',
      "system_dbFontWeight": "normal",
      "external_system_dbFontSize": 14,
      "external_system_dbFontFamily": '"Open Sans", sans-serif',
      "external_system_dbFontWeight": "normal",
      "system_queueFontSize": 14,
      "system_queueFontFamily": '"Open Sans", sans-serif',
      "system_queueFontWeight": "normal",
      "external_system_queueFontSize": 14,
      "external_system_queueFontFamily": '"Open Sans", sans-serif',
      "external_system_queueFontWeight": "normal",
      "boundaryFontSize": 14,
      "boundaryFontFamily": '"Open Sans", sans-serif',
      "boundaryFontWeight": "normal",
      "messageFontSize": 12,
      "messageFontFamily": '"Open Sans", sans-serif',
      "messageFontWeight": "normal",
      "containerFontSize": 14,
      "containerFontFamily": '"Open Sans", sans-serif',
      "containerFontWeight": "normal",
      "external_containerFontSize": 14,
      "external_containerFontFamily": '"Open Sans", sans-serif',
      "external_containerFontWeight": "normal",
      "container_dbFontSize": 14,
      "container_dbFontFamily": '"Open Sans", sans-serif',
      "container_dbFontWeight": "normal",
      "external_container_dbFontSize": 14,
      "external_container_dbFontFamily": '"Open Sans", sans-serif',
      "external_container_dbFontWeight": "normal",
      "container_queueFontSize": 14,
      "container_queueFontFamily": '"Open Sans", sans-serif',
      "container_queueFontWeight": "normal",
      "external_container_queueFontSize": 14,
      "external_container_queueFontFamily": '"Open Sans", sans-serif',
      "external_container_queueFontWeight": "normal",
      "componentFontSize": 14,
      "componentFontFamily": '"Open Sans", sans-serif',
      "componentFontWeight": "normal",
      "external_componentFontSize": 14,
      "external_componentFontFamily": '"Open Sans", sans-serif',
      "external_componentFontWeight": "normal",
      "component_dbFontSize": 14,
      "component_dbFontFamily": '"Open Sans", sans-serif',
      "component_dbFontWeight": "normal",
      "external_component_dbFontSize": 14,
      "external_component_dbFontFamily": '"Open Sans", sans-serif',
      "external_component_dbFontWeight": "normal",
      "component_queueFontSize": 14,
      "component_queueFontFamily": '"Open Sans", sans-serif',
      "component_queueFontWeight": "normal",
      "external_component_queueFontSize": 14,
      "external_component_queueFontFamily": '"Open Sans", sans-serif',
      "external_component_queueFontWeight": "normal",
      "wrap": true,
      "wrapPadding": 10,
      "person_bg_color": "#08427B",
      "person_border_color": "#073B6F",
      "external_person_bg_color": "#686868",
      "external_person_border_color": "#8A8A8A",
      "system_bg_color": "#1168BD",
      "system_border_color": "#3C7FC0",
      "system_db_bg_color": "#1168BD",
      "system_db_border_color": "#3C7FC0",
      "system_queue_bg_color": "#1168BD",
      "system_queue_border_color": "#3C7FC0",
      "external_system_bg_color": "#999999",
      "external_system_border_color": "#8A8A8A",
      "external_system_db_bg_color": "#999999",
      "external_system_db_border_color": "#8A8A8A",
      "external_system_queue_bg_color": "#999999",
      "external_system_queue_border_color": "#8A8A8A",
      "container_bg_color": "#438DD5",
      "container_border_color": "#3C7FC0",
      "container_db_bg_color": "#438DD5",
      "container_db_border_color": "#3C7FC0",
      "container_queue_bg_color": "#438DD5",
      "container_queue_border_color": "#3C7FC0",
      "external_container_bg_color": "#B3B3B3",
      "external_container_border_color": "#A6A6A6",
      "external_container_db_bg_color": "#B3B3B3",
      "external_container_db_border_color": "#A6A6A6",
      "external_container_queue_bg_color": "#B3B3B3",
      "external_container_queue_border_color": "#A6A6A6",
      "component_bg_color": "#85BBF0",
      "component_border_color": "#78A8D8",
      "component_db_bg_color": "#85BBF0",
      "component_db_border_color": "#78A8D8",
      "component_queue_bg_color": "#85BBF0",
      "component_queue_border_color": "#78A8D8",
      "external_component_bg_color": "#CCCCCC",
      "external_component_border_color": "#BFBFBF",
      "external_component_db_bg_color": "#CCCCCC",
      "external_component_db_border_color": "#BFBFBF",
      "external_component_queue_bg_color": "#CCCCCC",
      "external_component_queue_border_color": "#BFBFBF"
    },
    "sankey": {
      "useMaxWidth": true,
      "width": 600,
      "height": 400,
      "linkColor": "gradient",
      "nodeAlignment": "justify",
      "showValues": true,
      "prefix": "",
      "suffix": ""
    },
    "block": {
      "useMaxWidth": true,
      "padding": 8
    },
    "theme": "default",
    "maxTextSize": 5e4,
    "maxEdges": 500,
    "darkMode": false,
    "fontFamily": '"trebuchet ms", verdana, arial, sans-serif;',
    "logLevel": 5,
    "securityLevel": "strict",
    "startOnLoad": true,
    "arrowMarkerAbsolute": false,
    "secure": [
      "secure",
      "securityLevel",
      "startOnLoad",
      "maxTextSize",
      "maxEdges"
    ],
    "deterministicIds": false,
    "fontSize": 16
  };
  const config$3 = {
    ...defaultConfigJson,
    // Set, even though they're `undefined` so that `configKeys` finds these keys
    // TODO: Should we replace these with `null` so that they can go in the JSON Schema?
    deterministicIDSeed: void 0,
    themeCSS: void 0,
    // add non-JSON default config values
    themeVariables: theme["default"].getThemeVariables(),
    sequence: {
      ...defaultConfigJson.sequence,
      messageFont: function() {
        return {
          fontFamily: this.messageFontFamily,
          fontSize: this.messageFontSize,
          fontWeight: this.messageFontWeight
        };
      },
      noteFont: function() {
        return {
          fontFamily: this.noteFontFamily,
          fontSize: this.noteFontSize,
          fontWeight: this.noteFontWeight
        };
      },
      actorFont: function() {
        return {
          fontFamily: this.actorFontFamily,
          fontSize: this.actorFontSize,
          fontWeight: this.actorFontWeight
        };
      }
    },
    gantt: {
      ...defaultConfigJson.gantt,
      tickInterval: void 0,
      useWidth: void 0
      // can probably be removed since `configKeys` already includes this
    },
    c4: {
      ...defaultConfigJson.c4,
      useWidth: void 0,
      personFont: function() {
        return {
          fontFamily: this.personFontFamily,
          fontSize: this.personFontSize,
          fontWeight: this.personFontWeight
        };
      },
      external_personFont: function() {
        return {
          fontFamily: this.external_personFontFamily,
          fontSize: this.external_personFontSize,
          fontWeight: this.external_personFontWeight
        };
      },
      systemFont: function() {
        return {
          fontFamily: this.systemFontFamily,
          fontSize: this.systemFontSize,
          fontWeight: this.systemFontWeight
        };
      },
      external_systemFont: function() {
        return {
          fontFamily: this.external_systemFontFamily,
          fontSize: this.external_systemFontSize,
          fontWeight: this.external_systemFontWeight
        };
      },
      system_dbFont: function() {
        return {
          fontFamily: this.system_dbFontFamily,
          fontSize: this.system_dbFontSize,
          fontWeight: this.system_dbFontWeight
        };
      },
      external_system_dbFont: function() {
        return {
          fontFamily: this.external_system_dbFontFamily,
          fontSize: this.external_system_dbFontSize,
          fontWeight: this.external_system_dbFontWeight
        };
      },
      system_queueFont: function() {
        return {
          fontFamily: this.system_queueFontFamily,
          fontSize: this.system_queueFontSize,
          fontWeight: this.system_queueFontWeight
        };
      },
      external_system_queueFont: function() {
        return {
          fontFamily: this.external_system_queueFontFamily,
          fontSize: this.external_system_queueFontSize,
          fontWeight: this.external_system_queueFontWeight
        };
      },
      containerFont: function() {
        return {
          fontFamily: this.containerFontFamily,
          fontSize: this.containerFontSize,
          fontWeight: this.containerFontWeight
        };
      },
      external_containerFont: function() {
        return {
          fontFamily: this.external_containerFontFamily,
          fontSize: this.external_containerFontSize,
          fontWeight: this.external_containerFontWeight
        };
      },
      container_dbFont: function() {
        return {
          fontFamily: this.container_dbFontFamily,
          fontSize: this.container_dbFontSize,
          fontWeight: this.container_dbFontWeight
        };
      },
      external_container_dbFont: function() {
        return {
          fontFamily: this.external_container_dbFontFamily,
          fontSize: this.external_container_dbFontSize,
          fontWeight: this.external_container_dbFontWeight
        };
      },
      container_queueFont: function() {
        return {
          fontFamily: this.container_queueFontFamily,
          fontSize: this.container_queueFontSize,
          fontWeight: this.container_queueFontWeight
        };
      },
      external_container_queueFont: function() {
        return {
          fontFamily: this.external_container_queueFontFamily,
          fontSize: this.external_container_queueFontSize,
          fontWeight: this.external_container_queueFontWeight
        };
      },
      componentFont: function() {
        return {
          fontFamily: this.componentFontFamily,
          fontSize: this.componentFontSize,
          fontWeight: this.componentFontWeight
        };
      },
      external_componentFont: function() {
        return {
          fontFamily: this.external_componentFontFamily,
          fontSize: this.external_componentFontSize,
          fontWeight: this.external_componentFontWeight
        };
      },
      component_dbFont: function() {
        return {
          fontFamily: this.component_dbFontFamily,
          fontSize: this.component_dbFontSize,
          fontWeight: this.component_dbFontWeight
        };
      },
      external_component_dbFont: function() {
        return {
          fontFamily: this.external_component_dbFontFamily,
          fontSize: this.external_component_dbFontSize,
          fontWeight: this.external_component_dbFontWeight
        };
      },
      component_queueFont: function() {
        return {
          fontFamily: this.component_queueFontFamily,
          fontSize: this.component_queueFontSize,
          fontWeight: this.component_queueFontWeight
        };
      },
      external_component_queueFont: function() {
        return {
          fontFamily: this.external_component_queueFontFamily,
          fontSize: this.external_component_queueFontSize,
          fontWeight: this.external_component_queueFontWeight
        };
      },
      boundaryFont: function() {
        return {
          fontFamily: this.boundaryFontFamily,
          fontSize: this.boundaryFontSize,
          fontWeight: this.boundaryFontWeight
        };
      },
      messageFont: function() {
        return {
          fontFamily: this.messageFontFamily,
          fontSize: this.messageFontSize,
          fontWeight: this.messageFontWeight
        };
      }
    },
    pie: {
      ...defaultConfigJson.pie,
      useWidth: 984
    },
    xyChart: {
      ...defaultConfigJson.xyChart,
      useWidth: void 0
    },
    requirement: {
      ...defaultConfigJson.requirement,
      useWidth: void 0
    },
    gitGraph: {
      ...defaultConfigJson.gitGraph,
      // TODO: This is a temporary override for `gitGraph`, since every other
      //       diagram does have `useMaxWidth`, but instead sets it to `true`.
      //       Should we set this to `true` instead?
      useMaxWidth: false
    },
    sankey: {
      ...defaultConfigJson.sankey,
      // this is false, unlike every other diagram (other than gitGraph)
      // TODO: can we make this default to `true` instead?
      useMaxWidth: false
    }
  };
  const keyify = (obj, prefix = "") => Object.keys(obj).reduce((res, el) => {
    if (Array.isArray(obj[el])) {
      return res;
    } else if (typeof obj[el] === "object" && obj[el] !== null) {
      return [...res, prefix + el, ...keyify(obj[el], "")];
    }
    return [...res, prefix + el];
  }, []);
  const configKeys = new Set(keyify(config$3, ""));
  const defaultConfig$2 = config$3;
  const sanitizeDirective = (args) => {
    log$1.debug("sanitizeDirective called with", args);
    if (typeof args !== "object" || args == null) {
      return;
    }
    if (Array.isArray(args)) {
      args.forEach((arg) => sanitizeDirective(arg));
      return;
    }
    for (const key of Object.keys(args)) {
      log$1.debug("Checking key", key);
      if (key.startsWith("__") || key.includes("proto") || key.includes("constr") || !configKeys.has(key) || args[key] == null) {
        log$1.debug("sanitize deleting key: ", key);
        delete args[key];
        continue;
      }
      if (typeof args[key] === "object") {
        log$1.debug("sanitizing object", key);
        sanitizeDirective(args[key]);
        continue;
      }
      const cssMatchers = ["themeCSS", "fontFamily", "altFontFamily"];
      for (const cssKey of cssMatchers) {
        if (key.includes(cssKey)) {
          log$1.debug("sanitizing css option", key);
          args[key] = sanitizeCss(args[key]);
        }
      }
    }
    if (args.themeVariables) {
      for (const k of Object.keys(args.themeVariables)) {
        const val = args.themeVariables[k];
        if ((val == null ? void 0 : val.match) && !val.match(/^[\d "#%(),.;A-Za-z]+$/)) {
          args.themeVariables[k] = "";
        }
      }
    }
    log$1.debug("After sanitization", args);
  };
  const sanitizeCss = (str2) => {
    let startCnt = 0;
    let endCnt = 0;
    for (const element2 of str2) {
      if (startCnt < endCnt) {
        return "{ /* ERROR: Unbalanced CSS */ }";
      }
      if (element2 === "{") {
        startCnt++;
      } else if (element2 === "}") {
        endCnt++;
      }
    }
    if (startCnt !== endCnt) {
      return "{ /* ERROR: Unbalanced CSS */ }";
    }
    return str2;
  };
  const frontMatterRegex = /^-{3}\s*[\n\r](.*?)[\n\r]-{3}\s*[\n\r]+/s;
  const directiveRegex = /%{2}{\s*(?:(\w+)\s*:|(\w+))\s*(?:(\w+)|((?:(?!}%{2}).|\r?\n)*))?\s*(?:}%{2})?/gi;
  const anyCommentRegex = /\s*%%.*\n/gm;
  class UnknownDiagramError extends Error {
    constructor(message) {
      super(message);
      this.name = "UnknownDiagramError";
    }
  }
  const detectors = {};
  const detectType = function(text2, config2) {
    text2 = text2.replace(frontMatterRegex, "").replace(directiveRegex, "").replace(anyCommentRegex, "\n");
    for (const [key, { detector: detector2 }] of Object.entries(detectors)) {
      const diagram2 = detector2(text2, config2);
      if (diagram2) {
        return key;
      }
    }
    throw new UnknownDiagramError(
      `No diagram type detected matching given configuration for text: ${text2}`
    );
  };
  const registerLazyLoadedDiagrams = (...diagrams2) => {
    for (const { id: id2, detector: detector2, loader: loader2 } of diagrams2) {
      addDetector(id2, detector2, loader2);
    }
  };
  const addDetector = (key, detector2, loader2) => {
    if (detectors[key]) {
      log$1.error(`Detector with key ${key} already exists`);
    } else {
      detectors[key] = { detector: detector2, loader: loader2 };
    }
    log$1.debug(`Detector with key ${key} added${loader2 ? " with loader" : ""}`);
  };
  const getDiagramLoader = (key) => {
    return detectors[key].loader;
  };
  const assignWithDepth = (dst, src, { depth = 2, clobber = false } = {}) => {
    const config2 = { depth, clobber };
    if (Array.isArray(src) && !Array.isArray(dst)) {
      src.forEach((s) => assignWithDepth(dst, s, config2));
      return dst;
    } else if (Array.isArray(src) && Array.isArray(dst)) {
      src.forEach((s) => {
        if (!dst.includes(s)) {
          dst.push(s);
        }
      });
      return dst;
    }
    if (dst === void 0 || depth <= 0) {
      if (dst !== void 0 && dst !== null && typeof dst === "object" && typeof src === "object") {
        return Object.assign(dst, src);
      } else {
        return src;
      }
    }
    if (src !== void 0 && typeof dst === "object" && typeof src === "object") {
      Object.keys(src).forEach((key) => {
        if (typeof src[key] === "object" && (dst[key] === void 0 || typeof dst[key] === "object")) {
          if (dst[key] === void 0) {
            dst[key] = Array.isArray(src[key]) ? [] : {};
          }
          dst[key] = assignWithDepth(dst[key], src[key], { depth: depth - 1, clobber });
        } else if (clobber || typeof dst[key] !== "object" && typeof src[key] !== "object") {
          dst[key] = src[key];
        }
      });
    }
    return dst;
  };
  const assignWithDepth$1 = assignWithDepth;
  var freeGlobal = typeof global == "object" && global && global.Object === Object && global;
  const freeGlobal$1 = freeGlobal;
  var freeSelf = typeof self == "object" && self && self.Object === Object && self;
  var root = freeGlobal$1 || freeSelf || Function("return this")();
  const root$1 = root;
  var Symbol$1 = root$1.Symbol;
  const Symbol$2 = Symbol$1;
  var objectProto$i = Object.prototype;
  var hasOwnProperty$g = objectProto$i.hasOwnProperty;
  var nativeObjectToString$1 = objectProto$i.toString;
  var symToStringTag$1 = Symbol$2 ? Symbol$2.toStringTag : void 0;
  function getRawTag(value2) {
    var isOwn = hasOwnProperty$g.call(value2, symToStringTag$1), tag = value2[symToStringTag$1];
    try {
      value2[symToStringTag$1] = void 0;
      var unmasked = true;
    } catch (e) {
    }
    var result = nativeObjectToString$1.call(value2);
    if (unmasked) {
      if (isOwn) {
        value2[symToStringTag$1] = tag;
      } else {
        delete value2[symToStringTag$1];
      }
    }
    return result;
  }
  var objectProto$h = Object.prototype;
  var nativeObjectToString = objectProto$h.toString;
  function objectToString(value2) {
    return nativeObjectToString.call(value2);
  }
  var nullTag = "[object Null]", undefinedTag = "[object Undefined]";
  var symToStringTag = Symbol$2 ? Symbol$2.toStringTag : void 0;
  function baseGetTag(value2) {
    if (value2 == null) {
      return value2 === void 0 ? undefinedTag : nullTag;
    }
    return symToStringTag && symToStringTag in Object(value2) ? getRawTag(value2) : objectToString(value2);
  }
  function isObject$1(value2) {
    var type2 = typeof value2;
    return value2 != null && (type2 == "object" || type2 == "function");
  }
  var asyncTag = "[object AsyncFunction]", funcTag$2 = "[object Function]", genTag$1 = "[object GeneratorFunction]", proxyTag = "[object Proxy]";
  function isFunction(value2) {
    if (!isObject$1(value2)) {
      return false;
    }
    var tag = baseGetTag(value2);
    return tag == funcTag$2 || tag == genTag$1 || tag == asyncTag || tag == proxyTag;
  }
  var coreJsData = root$1["__core-js_shared__"];
  const coreJsData$1 = coreJsData;
  var maskSrcKey = function() {
    var uid = /[^.]+$/.exec(coreJsData$1 && coreJsData$1.keys && coreJsData$1.keys.IE_PROTO || "");
    return uid ? "Symbol(src)_1." + uid : "";
  }();
  function isMasked(func) {
    return !!maskSrcKey && maskSrcKey in func;
  }
  var funcProto$2 = Function.prototype;
  var funcToString$2 = funcProto$2.toString;
  function toSource(func) {
    if (func != null) {
      try {
        return funcToString$2.call(func);
      } catch (e) {
      }
      try {
        return func + "";
      } catch (e) {
      }
    }
    return "";
  }
  var reRegExpChar = /[\\^$.*+?()[\]{}|]/g;
  var reIsHostCtor = /^\[object .+?Constructor\]$/;
  var funcProto$1 = Function.prototype, objectProto$g = Object.prototype;
  var funcToString$1 = funcProto$1.toString;
  var hasOwnProperty$f = objectProto$g.hasOwnProperty;
  var reIsNative = RegExp(
    "^" + funcToString$1.call(hasOwnProperty$f).replace(reRegExpChar, "\\$&").replace(/hasOwnProperty|(function).*?(?=\\\()| for .+?(?=\\\])/g, "$1.*?") + "$"
  );
  function baseIsNative(value2) {
    if (!isObject$1(value2) || isMasked(value2)) {
      return false;
    }
    var pattern = isFunction(value2) ? reIsNative : reIsHostCtor;
    return pattern.test(toSource(value2));
  }
  function getValue(object2, key) {
    return object2 == null ? void 0 : object2[key];
  }
  function getNative(object2, key) {
    var value2 = getValue(object2, key);
    return baseIsNative(value2) ? value2 : void 0;
  }
  var nativeCreate = getNative(Object, "create");
  const nativeCreate$1 = nativeCreate;
  function hashClear() {
    this.__data__ = nativeCreate$1 ? nativeCreate$1(null) : {};
    this.size = 0;
  }
  function hashDelete(key) {
    var result = this.has(key) && delete this.__data__[key];
    this.size -= result ? 1 : 0;
    return result;
  }
  var HASH_UNDEFINED$2 = "__lodash_hash_undefined__";
  var objectProto$f = Object.prototype;
  var hasOwnProperty$e = objectProto$f.hasOwnProperty;
  function hashGet(key) {
    var data = this.__data__;
    if (nativeCreate$1) {
      var result = data[key];
      return result === HASH_UNDEFINED$2 ? void 0 : result;
    }
    return hasOwnProperty$e.call(data, key) ? data[key] : void 0;
  }
  var objectProto$e = Object.prototype;
  var hasOwnProperty$d = objectProto$e.hasOwnProperty;
  function hashHas(key) {
    var data = this.__data__;
    return nativeCreate$1 ? data[key] !== void 0 : hasOwnProperty$d.call(data, key);
  }
  var HASH_UNDEFINED$1 = "__lodash_hash_undefined__";
  function hashSet(key, value2) {
    var data = this.__data__;
    this.size += this.has(key) ? 0 : 1;
    data[key] = nativeCreate$1 && value2 === void 0 ? HASH_UNDEFINED$1 : value2;
    return this;
  }
  function Hash(entries2) {
    var index2 = -1, length2 = entries2 == null ? 0 : entries2.length;
    this.clear();
    while (++index2 < length2) {
      var entry = entries2[index2];
      this.set(entry[0], entry[1]);
    }
  }
  Hash.prototype.clear = hashClear;
  Hash.prototype["delete"] = hashDelete;
  Hash.prototype.get = hashGet;
  Hash.prototype.has = hashHas;
  Hash.prototype.set = hashSet;
  function listCacheClear() {
    this.__data__ = [];
    this.size = 0;
  }
  function eq(value2, other) {
    return value2 === other || value2 !== value2 && other !== other;
  }
  function assocIndexOf(array2, key) {
    var length2 = array2.length;
    while (length2--) {
      if (eq(array2[length2][0], key)) {
        return length2;
      }
    }
    return -1;
  }
  var arrayProto = Array.prototype;
  var splice$1 = arrayProto.splice;
  function listCacheDelete(key) {
    var data = this.__data__, index2 = assocIndexOf(data, key);
    if (index2 < 0) {
      return false;
    }
    var lastIndex = data.length - 1;
    if (index2 == lastIndex) {
      data.pop();
    } else {
      splice$1.call(data, index2, 1);
    }
    --this.size;
    return true;
  }
  function listCacheGet(key) {
    var data = this.__data__, index2 = assocIndexOf(data, key);
    return index2 < 0 ? void 0 : data[index2][1];
  }
  function listCacheHas(key) {
    return assocIndexOf(this.__data__, key) > -1;
  }
  function listCacheSet(key, value2) {
    var data = this.__data__, index2 = assocIndexOf(data, key);
    if (index2 < 0) {
      ++this.size;
      data.push([key, value2]);
    } else {
      data[index2][1] = value2;
    }
    return this;
  }
  function ListCache(entries2) {
    var index2 = -1, length2 = entries2 == null ? 0 : entries2.length;
    this.clear();
    while (++index2 < length2) {
      var entry = entries2[index2];
      this.set(entry[0], entry[1]);
    }
  }
  ListCache.prototype.clear = listCacheClear;
  ListCache.prototype["delete"] = listCacheDelete;
  ListCache.prototype.get = listCacheGet;
  ListCache.prototype.has = listCacheHas;
  ListCache.prototype.set = listCacheSet;
  var Map$1 = getNative(root$1, "Map");
  const Map$2 = Map$1;
  function mapCacheClear() {
    this.size = 0;
    this.__data__ = {
      "hash": new Hash(),
      "map": new (Map$2 || ListCache)(),
      "string": new Hash()
    };
  }
  function isKeyable(value2) {
    var type2 = typeof value2;
    return type2 == "string" || type2 == "number" || type2 == "symbol" || type2 == "boolean" ? value2 !== "__proto__" : value2 === null;
  }
  function getMapData(map2, key) {
    var data = map2.__data__;
    return isKeyable(key) ? data[typeof key == "string" ? "string" : "hash"] : data.map;
  }
  function mapCacheDelete(key) {
    var result = getMapData(this, key)["delete"](key);
    this.size -= result ? 1 : 0;
    return result;
  }
  function mapCacheGet(key) {
    return getMapData(this, key).get(key);
  }
  function mapCacheHas(key) {
    return getMapData(this, key).has(key);
  }
  function mapCacheSet(key, value2) {
    var data = getMapData(this, key), size2 = data.size;
    data.set(key, value2);
    this.size += data.size == size2 ? 0 : 1;
    return this;
  }
  function MapCache(entries2) {
    var index2 = -1, length2 = entries2 == null ? 0 : entries2.length;
    this.clear();
    while (++index2 < length2) {
      var entry = entries2[index2];
      this.set(entry[0], entry[1]);
    }
  }
  MapCache.prototype.clear = mapCacheClear;
  MapCache.prototype["delete"] = mapCacheDelete;
  MapCache.prototype.get = mapCacheGet;
  MapCache.prototype.has = mapCacheHas;
  MapCache.prototype.set = mapCacheSet;
  var FUNC_ERROR_TEXT = "Expected a function";
  function memoize(func, resolver2) {
    if (typeof func != "function" || resolver2 != null && typeof resolver2 != "function") {
      throw new TypeError(FUNC_ERROR_TEXT);
    }
    var memoized = function() {
      var args = arguments, key = resolver2 ? resolver2.apply(this, args) : args[0], cache = memoized.cache;
      if (cache.has(key)) {
        return cache.get(key);
      }
      var result = func.apply(this, args);
      memoized.cache = cache.set(key, result) || cache;
      return result;
    };
    memoized.cache = new (memoize.Cache || MapCache)();
    return memoized;
  }
  memoize.Cache = MapCache;
  function stackClear() {
    this.__data__ = new ListCache();
    this.size = 0;
  }
  function stackDelete(key) {
    var data = this.__data__, result = data["delete"](key);
    this.size = data.size;
    return result;
  }
  function stackGet(key) {
    return this.__data__.get(key);
  }
  function stackHas(key) {
    return this.__data__.has(key);
  }
  var LARGE_ARRAY_SIZE$1 = 200;
  function stackSet(key, value2) {
    var data = this.__data__;
    if (data instanceof ListCache) {
      var pairs2 = data.__data__;
      if (!Map$2 || pairs2.length < LARGE_ARRAY_SIZE$1 - 1) {
        pairs2.push([key, value2]);
        this.size = ++data.size;
        return this;
      }
      data = this.__data__ = new MapCache(pairs2);
    }
    data.set(key, value2);
    this.size = data.size;
    return this;
  }
  function Stack(entries2) {
    var data = this.__data__ = new ListCache(entries2);
    this.size = data.size;
  }
  Stack.prototype.clear = stackClear;
  Stack.prototype["delete"] = stackDelete;
  Stack.prototype.get = stackGet;
  Stack.prototype.has = stackHas;
  Stack.prototype.set = stackSet;
  var defineProperty = function() {
    try {
      var func = getNative(Object, "defineProperty");
      func({}, "", {});
      return func;
    } catch (e) {
    }
  }();
  const defineProperty$1 = defineProperty;
  function baseAssignValue(object2, key, value2) {
    if (key == "__proto__" && defineProperty$1) {
      defineProperty$1(object2, key, {
        "configurable": true,
        "enumerable": true,
        "value": value2,
        "writable": true
      });
    } else {
      object2[key] = value2;
    }
  }
  function assignMergeValue(object2, key, value2) {
    if (value2 !== void 0 && !eq(object2[key], value2) || value2 === void 0 && !(key in object2)) {
      baseAssignValue(object2, key, value2);
    }
  }
  function createBaseFor(fromRight) {
    return function(object2, iteratee, keysFunc) {
      var index2 = -1, iterable = Object(object2), props = keysFunc(object2), length2 = props.length;
      while (length2--) {
        var key = props[fromRight ? length2 : ++index2];
        if (iteratee(iterable[key], key, iterable) === false) {
          break;
        }
      }
      return object2;
    };
  }
  var baseFor = createBaseFor();
  const baseFor$1 = baseFor;
  var freeExports$2 = typeof exports == "object" && exports && !exports.nodeType && exports;
  var freeModule$2 = freeExports$2 && typeof module == "object" && module && !module.nodeType && module;
  var moduleExports$2 = freeModule$2 && freeModule$2.exports === freeExports$2;
  var Buffer$1 = moduleExports$2 ? root$1.Buffer : void 0, allocUnsafe = Buffer$1 ? Buffer$1.allocUnsafe : void 0;
  function cloneBuffer(buffer, isDeep) {
    if (isDeep) {
      return buffer.slice();
    }
    var length2 = buffer.length, result = allocUnsafe ? allocUnsafe(length2) : new buffer.constructor(length2);
    buffer.copy(result);
    return result;
  }
  var Uint8Array$1 = root$1.Uint8Array;
  const Uint8Array$2 = Uint8Array$1;
  function cloneArrayBuffer(arrayBuffer) {
    var result = new arrayBuffer.constructor(arrayBuffer.byteLength);
    new Uint8Array$2(result).set(new Uint8Array$2(arrayBuffer));
    return result;
  }
  function cloneTypedArray(typedArray, isDeep) {
    var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;
    return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);
  }
  function copyArray(source, array2) {
    var index2 = -1, length2 = source.length;
    array2 || (array2 = Array(length2));
    while (++index2 < length2) {
      array2[index2] = source[index2];
    }
    return array2;
  }
  var objectCreate = Object.create;
  var baseCreate = function() {
    function object2() {
    }
    return function(proto) {
      if (!isObject$1(proto)) {
        return {};
      }
      if (objectCreate) {
        return objectCreate(proto);
      }
      object2.prototype = proto;
      var result = new object2();
      object2.prototype = void 0;
      return result;
    };
  }();
  const baseCreate$1 = baseCreate;
  function overArg(func, transform) {
    return function(arg) {
      return func(transform(arg));
    };
  }
  var getPrototype = overArg(Object.getPrototypeOf, Object);
  const getPrototype$1 = getPrototype;
  var objectProto$d = Object.prototype;
  function isPrototype(value2) {
    var Ctor = value2 && value2.constructor, proto = typeof Ctor == "function" && Ctor.prototype || objectProto$d;
    return value2 === proto;
  }
  function initCloneObject(object2) {
    return typeof object2.constructor == "function" && !isPrototype(object2) ? baseCreate$1(getPrototype$1(object2)) : {};
  }
  function isObjectLike(value2) {
    return value2 != null && typeof value2 == "object";
  }
  var argsTag$3 = "[object Arguments]";
  function baseIsArguments(value2) {
    return isObjectLike(value2) && baseGetTag(value2) == argsTag$3;
  }
  var objectProto$c = Object.prototype;
  var hasOwnProperty$c = objectProto$c.hasOwnProperty;
  var propertyIsEnumerable$1 = objectProto$c.propertyIsEnumerable;
  var isArguments = baseIsArguments(function() {
    return arguments;
  }()) ? baseIsArguments : function(value2) {
    return isObjectLike(value2) && hasOwnProperty$c.call(value2, "callee") && !propertyIsEnumerable$1.call(value2, "callee");
  };
  const isArguments$1 = isArguments;
  var isArray = Array.isArray;
  const isArray$1 = isArray;
  var MAX_SAFE_INTEGER$1 = 9007199254740991;
  function isLength(value2) {
    return typeof value2 == "number" && value2 > -1 && value2 % 1 == 0 && value2 <= MAX_SAFE_INTEGER$1;
  }
  function isArrayLike(value2) {
    return value2 != null && isLength(value2.length) && !isFunction(value2);
  }
  function isArrayLikeObject(value2) {
    return isObjectLike(value2) && isArrayLike(value2);
  }
  function stubFalse() {
    return false;
  }
  var freeExports$1 = typeof exports == "object" && exports && !exports.nodeType && exports;
  var freeModule$1 = freeExports$1 && typeof module == "object" && module && !module.nodeType && module;
  var moduleExports$1 = freeModule$1 && freeModule$1.exports === freeExports$1;
  var Buffer = moduleExports$1 ? root$1.Buffer : void 0;
  var nativeIsBuffer = Buffer ? Buffer.isBuffer : void 0;
  var isBuffer = nativeIsBuffer || stubFalse;
  const isBuffer$1 = isBuffer;
  var objectTag$4 = "[object Object]";
  var funcProto = Function.prototype, objectProto$b = Object.prototype;
  var funcToString = funcProto.toString;
  var hasOwnProperty$b = objectProto$b.hasOwnProperty;
  var objectCtorString = funcToString.call(Object);
  function isPlainObject(value2) {
    if (!isObjectLike(value2) || baseGetTag(value2) != objectTag$4) {
      return false;
    }
    var proto = getPrototype$1(value2);
    if (proto === null) {
      return true;
    }
    var Ctor = hasOwnProperty$b.call(proto, "constructor") && proto.constructor;
    return typeof Ctor == "function" && Ctor instanceof Ctor && funcToString.call(Ctor) == objectCtorString;
  }
  var argsTag$2 = "[object Arguments]", arrayTag$2 = "[object Array]", boolTag$3 = "[object Boolean]", dateTag$3 = "[object Date]", errorTag$2 = "[object Error]", funcTag$1 = "[object Function]", mapTag$6 = "[object Map]", numberTag$3 = "[object Number]", objectTag$3 = "[object Object]", regexpTag$3 = "[object RegExp]", setTag$6 = "[object Set]", stringTag$3 = "[object String]", weakMapTag$2 = "[object WeakMap]";
  var arrayBufferTag$3 = "[object ArrayBuffer]", dataViewTag$4 = "[object DataView]", float32Tag$2 = "[object Float32Array]", float64Tag$2 = "[object Float64Array]", int8Tag$2 = "[object Int8Array]", int16Tag$2 = "[object Int16Array]", int32Tag$2 = "[object Int32Array]", uint8Tag$2 = "[object Uint8Array]", uint8ClampedTag$2 = "[object Uint8ClampedArray]", uint16Tag$2 = "[object Uint16Array]", uint32Tag$2 = "[object Uint32Array]";
  var typedArrayTags = {};
  typedArrayTags[float32Tag$2] = typedArrayTags[float64Tag$2] = typedArrayTags[int8Tag$2] = typedArrayTags[int16Tag$2] = typedArrayTags[int32Tag$2] = typedArrayTags[uint8Tag$2] = typedArrayTags[uint8ClampedTag$2] = typedArrayTags[uint16Tag$2] = typedArrayTags[uint32Tag$2] = true;
  typedArrayTags[argsTag$2] = typedArrayTags[arrayTag$2] = typedArrayTags[arrayBufferTag$3] = typedArrayTags[boolTag$3] = typedArrayTags[dataViewTag$4] = typedArrayTags[dateTag$3] = typedArrayTags[errorTag$2] = typedArrayTags[funcTag$1] = typedArrayTags[mapTag$6] = typedArrayTags[numberTag$3] = typedArrayTags[objectTag$3] = typedArrayTags[regexpTag$3] = typedArrayTags[setTag$6] = typedArrayTags[stringTag$3] = typedArrayTags[weakMapTag$2] = false;
  function baseIsTypedArray(value2) {
    return isObjectLike(value2) && isLength(value2.length) && !!typedArrayTags[baseGetTag(value2)];
  }
  function baseUnary(func) {
    return function(value2) {
      return func(value2);
    };
  }
  var freeExports = typeof exports == "object" && exports && !exports.nodeType && exports;
  var freeModule = freeExports && typeof module == "object" && module && !module.nodeType && module;
  var moduleExports = freeModule && freeModule.exports === freeExports;
  var freeProcess = moduleExports && freeGlobal$1.process;
  var nodeUtil = function() {
    try {
      var types = freeModule && freeModule.require && freeModule.require("util").types;
      if (types) {
        return types;
      }
      return freeProcess && freeProcess.binding && freeProcess.binding("util");
    } catch (e) {
    }
  }();
  const nodeUtil$1 = nodeUtil;
  var nodeIsTypedArray = nodeUtil$1 && nodeUtil$1.isTypedArray;
  var isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;
  const isTypedArray$1 = isTypedArray;
  function safeGet(object2, key) {
    if (key === "constructor" && typeof object2[key] === "function") {
      return;
    }
    if (key == "__proto__") {
      return;
    }
    return object2[key];
  }
  var objectProto$a = Object.prototype;
  var hasOwnProperty$a = objectProto$a.hasOwnProperty;
  function assignValue(object2, key, value2) {
    var objValue = object2[key];
    if (!(hasOwnProperty$a.call(object2, key) && eq(objValue, value2)) || value2 === void 0 && !(key in object2)) {
      baseAssignValue(object2, key, value2);
    }
  }
  function copyObject(source, props, object2, customizer) {
    var isNew = !object2;
    object2 || (object2 = {});
    var index2 = -1, length2 = props.length;
    while (++index2 < length2) {
      var key = props[index2];
      var newValue = customizer ? customizer(object2[key], source[key], key, object2, source) : void 0;
      if (newValue === void 0) {
        newValue = source[key];
      }
      if (isNew) {
        baseAssignValue(object2, key, newValue);
      } else {
        assignValue(object2, key, newValue);
      }
    }
    return object2;
  }
  function baseTimes(n, iteratee) {
    var index2 = -1, result = Array(n);
    while (++index2 < n) {
      result[index2] = iteratee(index2);
    }
    return result;
  }
  var MAX_SAFE_INTEGER = 9007199254740991;
  var reIsUint = /^(?:0|[1-9]\d*)$/;
  function isIndex(value2, length2) {
    var type2 = typeof value2;
    length2 = length2 == null ? MAX_SAFE_INTEGER : length2;
    return !!length2 && (type2 == "number" || type2 != "symbol" && reIsUint.test(value2)) && (value2 > -1 && value2 % 1 == 0 && value2 < length2);
  }
  var objectProto$9 = Object.prototype;
  var hasOwnProperty$9 = objectProto$9.hasOwnProperty;
  function arrayLikeKeys(value2, inherited) {
    var isArr = isArray$1(value2), isArg = !isArr && isArguments$1(value2), isBuff = !isArr && !isArg && isBuffer$1(value2), isType = !isArr && !isArg && !isBuff && isTypedArray$1(value2), skipIndexes = isArr || isArg || isBuff || isType, result = skipIndexes ? baseTimes(value2.length, String) : [], length2 = result.length;
    for (var key in value2) {
      if ((inherited || hasOwnProperty$9.call(value2, key)) && !(skipIndexes && // Safari 9 has enumerable `arguments.length` in strict mode.
      (key == "length" || // Node.js 0.10 has enumerable non-index properties on buffers.
      isBuff && (key == "offset" || key == "parent") || // PhantomJS 2 has enumerable non-index properties on typed arrays.
      isType && (key == "buffer" || key == "byteLength" || key == "byteOffset") || // Skip index properties.
      isIndex(key, length2)))) {
        result.push(key);
      }
    }
    return result;
  }
  function nativeKeysIn(object2) {
    var result = [];
    if (object2 != null) {
      for (var key in Object(object2)) {
        result.push(key);
      }
    }
    return result;
  }
  var objectProto$8 = Object.prototype;
  var hasOwnProperty$8 = objectProto$8.hasOwnProperty;
  function baseKeysIn(object2) {
    if (!isObject$1(object2)) {
      return nativeKeysIn(object2);
    }
    var isProto = isPrototype(object2), result = [];
    for (var key in object2) {
      if (!(key == "constructor" && (isProto || !hasOwnProperty$8.call(object2, key)))) {
        result.push(key);
      }
    }
    return result;
  }
  function keysIn(object2) {
    return isArrayLike(object2) ? arrayLikeKeys(object2, true) : baseKeysIn(object2);
  }
  function toPlainObject(value2) {
    return copyObject(value2, keysIn(value2));
  }
  function baseMergeDeep(object2, source, key, srcIndex, mergeFunc, customizer, stack) {
    var objValue = safeGet(object2, key), srcValue = safeGet(source, key), stacked = stack.get(srcValue);
    if (stacked) {
      assignMergeValue(object2, key, stacked);
      return;
    }
    var newValue = customizer ? customizer(objValue, srcValue, key + "", object2, source, stack) : void 0;
    var isCommon = newValue === void 0;
    if (isCommon) {
      var isArr = isArray$1(srcValue), isBuff = !isArr && isBuffer$1(srcValue), isTyped = !isArr && !isBuff && isTypedArray$1(srcValue);
      newValue = srcValue;
      if (isArr || isBuff || isTyped) {
        if (isArray$1(objValue)) {
          newValue = objValue;
        } else if (isArrayLikeObject(objValue)) {
          newValue = copyArray(objValue);
        } else if (isBuff) {
          isCommon = false;
          newValue = cloneBuffer(srcValue, true);
        } else if (isTyped) {
          isCommon = false;
          newValue = cloneTypedArray(srcValue, true);
        } else {
          newValue = [];
        }
      } else if (isPlainObject(srcValue) || isArguments$1(srcValue)) {
        newValue = objValue;
        if (isArguments$1(objValue)) {
          newValue = toPlainObject(objValue);
        } else if (!isObject$1(objValue) || isFunction(objValue)) {
          newValue = initCloneObject(srcValue);
        }
      } else {
        isCommon = false;
      }
    }
    if (isCommon) {
      stack.set(srcValue, newValue);
      mergeFunc(newValue, srcValue, srcIndex, customizer, stack);
      stack["delete"](srcValue);
    }
    assignMergeValue(object2, key, newValue);
  }
  function baseMerge(object2, source, srcIndex, customizer, stack) {
    if (object2 === source) {
      return;
    }
    baseFor$1(source, function(srcValue, key) {
      stack || (stack = new Stack());
      if (isObject$1(srcValue)) {
        baseMergeDeep(object2, source, key, srcIndex, baseMerge, customizer, stack);
      } else {
        var newValue = customizer ? customizer(safeGet(object2, key), srcValue, key + "", object2, source, stack) : void 0;
        if (newValue === void 0) {
          newValue = srcValue;
        }
        assignMergeValue(object2, key, newValue);
      }
    }, keysIn);
  }
  function identity(value2) {
    return value2;
  }
  function apply$1(func, thisArg, args) {
    switch (args.length) {
      case 0:
        return func.call(thisArg);
      case 1:
        return func.call(thisArg, args[0]);
      case 2:
        return func.call(thisArg, args[0], args[1]);
      case 3:
        return func.call(thisArg, args[0], args[1], args[2]);
    }
    return func.apply(thisArg, args);
  }
  var nativeMax$2 = Math.max;
  function overRest(func, start2, transform) {
    start2 = nativeMax$2(start2 === void 0 ? func.length - 1 : start2, 0);
    return function() {
      var args = arguments, index2 = -1, length2 = nativeMax$2(args.length - start2, 0), array2 = Array(length2);
      while (++index2 < length2) {
        array2[index2] = args[start2 + index2];
      }
      index2 = -1;
      var otherArgs = Array(start2 + 1);
      while (++index2 < start2) {
        otherArgs[index2] = args[index2];
      }
      otherArgs[start2] = transform(array2);
      return apply$1(func, this, otherArgs);
    };
  }
  function constant$2(value2) {
    return function() {
      return value2;
    };
  }
  var baseSetToString = !defineProperty$1 ? identity : function(func, string2) {
    return defineProperty$1(func, "toString", {
      "configurable": true,
      "enumerable": false,
      "value": constant$2(string2),
      "writable": true
    });
  };
  const baseSetToString$1 = baseSetToString;
  var HOT_COUNT = 800, HOT_SPAN = 16;
  var nativeNow = Date.now;
  function shortOut(func) {
    var count = 0, lastCalled = 0;
    return function() {
      var stamp = nativeNow(), remaining = HOT_SPAN - (stamp - lastCalled);
      lastCalled = stamp;
      if (remaining > 0) {
        if (++count >= HOT_COUNT) {
          return arguments[0];
        }
      } else {
        count = 0;
      }
      return func.apply(void 0, arguments);
    };
  }
  var setToString = shortOut(baseSetToString$1);
  const setToString$1 = setToString;
  function baseRest(func, start2) {
    return setToString$1(overRest(func, start2, identity), func + "");
  }
  function isIterateeCall(value2, index2, object2) {
    if (!isObject$1(object2)) {
      return false;
    }
    var type2 = typeof index2;
    if (type2 == "number" ? isArrayLike(object2) && isIndex(index2, object2.length) : type2 == "string" && index2 in object2) {
      return eq(object2[index2], value2);
    }
    return false;
  }
  function createAssigner(assigner) {
    return baseRest(function(object2, sources) {
      var index2 = -1, length2 = sources.length, customizer = length2 > 1 ? sources[length2 - 1] : void 0, guard = length2 > 2 ? sources[2] : void 0;
      customizer = assigner.length > 3 && typeof customizer == "function" ? (length2--, customizer) : void 0;
      if (guard && isIterateeCall(sources[0], sources[1], guard)) {
        customizer = length2 < 3 ? void 0 : customizer;
        length2 = 1;
      }
      object2 = Object(object2);
      while (++index2 < length2) {
        var source = sources[index2];
        if (source) {
          assigner(object2, source, index2, customizer);
        }
      }
      return object2;
    });
  }
  var merge$2 = createAssigner(function(object2, source, srcIndex) {
    baseMerge(object2, source, srcIndex);
  });
  const merge$3 = merge$2;
  const ZERO_WIDTH_SPACE = "​";
  const d3CurveTypes = {
    curveBasis,
    curveBasisClosed,
    curveBasisOpen,
    curveBumpX: bumpX,
    curveBumpY: bumpY,
    curveBundle,
    curveCardinalClosed,
    curveCardinalOpen,
    curveCardinal,
    curveCatmullRomClosed,
    curveCatmullRomOpen,
    curveCatmullRom,
    curveLinear,
    curveLinearClosed,
    curveMonotoneX: monotoneX,
    curveMonotoneY: monotoneY,
    curveNatural,
    curveStep,
    curveStepAfter: stepAfter,
    curveStepBefore: stepBefore
  };
  const directiveWithoutOpen = /\s*(?:(\w+)(?=:):|(\w+))\s*(?:(\w+)|((?:(?!}%{2}).|\r?\n)*))?\s*(?:}%{2})?/gi;
  const detectInit = function(text2, config2) {
    const inits = detectDirective(text2, /(?:init\b)|(?:initialize\b)/);
    let results = {};
    if (Array.isArray(inits)) {
      const args = inits.map((init2) => init2.args);
      sanitizeDirective(args);
      results = assignWithDepth$1(results, [...args]);
    } else {
      results = inits.args;
    }
    if (!results) {
      return;
    }
    let type2 = detectType(text2, config2);
    const prop = "config";
    if (results[prop] !== void 0) {
      if (type2 === "flowchart-v2") {
        type2 = "flowchart";
      }
      results[type2] = results[prop];
      delete results[prop];
    }
    return results;
  };
  const detectDirective = function(text2, type2 = null) {
    try {
      const commentWithoutDirectives = new RegExp(
        `[%]{2}(?![{]${directiveWithoutOpen.source})(?=[}][%]{2}).*
`,
        "ig"
      );
      text2 = text2.trim().replace(commentWithoutDirectives, "").replace(/'/gm, '"');
      log$1.debug(
        `Detecting diagram directive${type2 !== null ? " type:" + type2 : ""} based on the text:${text2}`
      );
      let match;
      const result = [];
      while ((match = directiveRegex.exec(text2)) !== null) {
        if (match.index === directiveRegex.lastIndex) {
          directiveRegex.lastIndex++;
        }
        if (match && !type2 || type2 && match[1] && match[1].match(type2) || type2 && match[2] && match[2].match(type2)) {
          const type22 = match[1] ? match[1] : match[2];
          const args = match[3] ? match[3].trim() : match[4] ? JSON.parse(match[4].trim()) : null;
          result.push({ type: type22, args });
        }
      }
      if (result.length === 0) {
        return { type: text2, args: null };
      }
      return result.length === 1 ? result[0] : result;
    } catch (error) {
      log$1.error(
        `ERROR: ${error.message} - Unable to parse directive type: '${type2}' based on the text: '${text2}'`
      );
      return { type: void 0, args: null };
    }
  };
  const removeDirectives = function(text2) {
    return text2.replace(directiveRegex, "");
  };
  const isSubstringInArray = function(str2, arr) {
    for (const [i2, element2] of arr.entries()) {
      if (element2.match(str2)) {
        return i2;
      }
    }
    return -1;
  };
  function interpolateToCurve(interpolate2, defaultCurve) {
    if (!interpolate2) {
      return defaultCurve;
    }
    const curveName = `curve${interpolate2.charAt(0).toUpperCase() + interpolate2.slice(1)}`;
    return d3CurveTypes[curveName] ?? defaultCurve;
  }
  function formatUrl(linkStr, config2) {
    const url = linkStr.trim();
    if (!url) {
      return void 0;
    }
    if (config2.securityLevel !== "loose") {
      return sanitizeUrl_1(url);
    }
    return url;
  }
  const runFunc = (functionName, ...params) => {
    const arrPaths = functionName.split(".");
    const len = arrPaths.length - 1;
    const fnName = arrPaths[len];
    let obj = window;
    for (let i2 = 0; i2 < len; i2++) {
      obj = obj[arrPaths[i2]];
      if (!obj) {
        log$1.error(`Function name: ${functionName} not found in window`);
        return;
      }
    }
    obj[fnName](...params);
  };
  function distance(p1, p2) {
    if (!p1 || !p2) {
      return 0;
    }
    return Math.sqrt(Math.pow(p2.x - p1.x, 2) + Math.pow(p2.y - p1.y, 2));
  }
  function traverseEdge(points) {
    let prevPoint;
    let totalDistance = 0;
    points.forEach((point2) => {
      totalDistance += distance(point2, prevPoint);
      prevPoint = point2;
    });
    const remainingDistance = totalDistance / 2;
    return calculatePoint(points, remainingDistance);
  }
  function calcLabelPosition(points) {
    if (points.length === 1) {
      return points[0];
    }
    return traverseEdge(points);
  }
  const roundNumber = (num, precision = 2) => {
    const factor = Math.pow(10, precision);
    return Math.round(num * factor) / factor;
  };
  const calculatePoint = (points, distanceToTraverse) => {
    let prevPoint = void 0;
    let remainingDistance = distanceToTraverse;
    for (const point2 of points) {
      if (prevPoint) {
        const vectorDistance = distance(point2, prevPoint);
        if (vectorDistance < remainingDistance) {
          remainingDistance -= vectorDistance;
        } else {
          const distanceRatio = remainingDistance / vectorDistance;
          if (distanceRatio <= 0) {
            return prevPoint;
          }
          if (distanceRatio >= 1) {
            return { x: point2.x, y: point2.y };
          }
          if (distanceRatio > 0 && distanceRatio < 1) {
            return {
              x: roundNumber((1 - distanceRatio) * prevPoint.x + distanceRatio * point2.x, 5),
              y: roundNumber((1 - distanceRatio) * prevPoint.y + distanceRatio * point2.y, 5)
            };
          }
        }
      }
      prevPoint = point2;
    }
    throw new Error("Could not find a suitable point for the given distance");
  };
  const calcCardinalityPosition = (isRelationTypePresent, points, initialPosition) => {
    log$1.info(`our points ${JSON.stringify(points)}`);
    if (points[0] !== initialPosition) {
      points = points.reverse();
    }
    const distanceToCardinalityPoint = 25;
    const center2 = calculatePoint(points, distanceToCardinalityPoint);
    const d = isRelationTypePresent ? 10 : 5;
    const angle = Math.atan2(points[0].y - center2.y, points[0].x - center2.x);
    const cardinalityPosition = { x: 0, y: 0 };
    cardinalityPosition.x = Math.sin(angle) * d + (points[0].x + center2.x) / 2;
    cardinalityPosition.y = -Math.cos(angle) * d + (points[0].y + center2.y) / 2;
    return cardinalityPosition;
  };
  function calcTerminalLabelPosition(terminalMarkerSize, position2, _points) {
    const points = structuredClone(_points);
    log$1.info("our points", points);
    if (position2 !== "start_left" && position2 !== "start_right") {
      points.reverse();
    }
    const distanceToCardinalityPoint = 25 + terminalMarkerSize;
    const center2 = calculatePoint(points, distanceToCardinalityPoint);
    const d = 10 + terminalMarkerSize * 0.5;
    const angle = Math.atan2(points[0].y - center2.y, points[0].x - center2.x);
    const cardinalityPosition = { x: 0, y: 0 };
    if (position2 === "start_left") {
      cardinalityPosition.x = Math.sin(angle + Math.PI) * d + (points[0].x + center2.x) / 2;
      cardinalityPosition.y = -Math.cos(angle + Math.PI) * d + (points[0].y + center2.y) / 2;
    } else if (position2 === "end_right") {
      cardinalityPosition.x = Math.sin(angle - Math.PI) * d + (points[0].x + center2.x) / 2 - 5;
      cardinalityPosition.y = -Math.cos(angle - Math.PI) * d + (points[0].y + center2.y) / 2 - 5;
    } else if (position2 === "end_left") {
      cardinalityPosition.x = Math.sin(angle) * d + (points[0].x + center2.x) / 2 - 5;
      cardinalityPosition.y = -Math.cos(angle) * d + (points[0].y + center2.y) / 2 - 5;
    } else {
      cardinalityPosition.x = Math.sin(angle) * d + (points[0].x + center2.x) / 2;
      cardinalityPosition.y = -Math.cos(angle) * d + (points[0].y + center2.y) / 2;
    }
    return cardinalityPosition;
  }
  function getStylesFromArray(arr) {
    let style = "";
    let labelStyle = "";
    for (const element2 of arr) {
      if (element2 !== void 0) {
        if (element2.startsWith("color:") || element2.startsWith("text-align:")) {
          labelStyle = labelStyle + element2 + ";";
        } else {
          style = style + element2 + ";";
        }
      }
    }
    return { style, labelStyle };
  }
  let cnt$2 = 0;
  const generateId$2 = () => {
    cnt$2++;
    return "id-" + Math.random().toString(36).substr(2, 12) + "-" + cnt$2;
  };
  function makeRandomHex(length2) {
    let result = "";
    const characters2 = "0123456789abcdef";
    const charactersLength = characters2.length;
    for (let i2 = 0; i2 < length2; i2++) {
      result += characters2.charAt(Math.floor(Math.random() * charactersLength));
    }
    return result;
  }
  const random = (options2) => {
    return makeRandomHex(options2.length);
  };
  const getTextObj$3 = function() {
    return {
      x: 0,
      y: 0,
      fill: void 0,
      anchor: "start",
      style: "#666",
      width: 100,
      height: 100,
      textMargin: 0,
      rx: 0,
      ry: 0,
      valign: void 0,
      text: ""
    };
  };
  const drawSimpleText = function(elem, textData) {
    const nText = textData.text.replace(common$1.lineBreakRegex, " ");
    const [, _fontSizePx] = parseFontSize(textData.fontSize);
    const textElem = elem.append("text");
    textElem.attr("x", textData.x);
    textElem.attr("y", textData.y);
    textElem.style("text-anchor", textData.anchor);
    textElem.style("font-family", textData.fontFamily);
    textElem.style("font-size", _fontSizePx);
    textElem.style("font-weight", textData.fontWeight);
    textElem.attr("fill", textData.fill);
    if (textData.class !== void 0) {
      textElem.attr("class", textData.class);
    }
    const span = textElem.append("tspan");
    span.attr("x", textData.x + textData.textMargin * 2);
    span.attr("fill", textData.fill);
    span.text(nText);
    return textElem;
  };
  const wrapLabel = memoize(
    (label, maxWidth, config2) => {
      if (!label) {
        return label;
      }
      config2 = Object.assign(
        { fontSize: 12, fontWeight: 400, fontFamily: "Arial", joinWith: "<br/>" },
        config2
      );
      if (common$1.lineBreakRegex.test(label)) {
        return label;
      }
      const words = label.split(" ");
      const completedLines = [];
      let nextLine = "";
      words.forEach((word, index2) => {
        const wordLength = calculateTextWidth(`${word} `, config2);
        const nextLineLength = calculateTextWidth(nextLine, config2);
        if (wordLength > maxWidth) {
          const { hyphenatedStrings, remainingWord } = breakString(word, maxWidth, "-", config2);
          completedLines.push(nextLine, ...hyphenatedStrings);
          nextLine = remainingWord;
        } else if (nextLineLength + wordLength >= maxWidth) {
          completedLines.push(nextLine);
          nextLine = word;
        } else {
          nextLine = [nextLine, word].filter(Boolean).join(" ");
        }
        const currentWord = index2 + 1;
        const isLastWord = currentWord === words.length;
        if (isLastWord) {
          completedLines.push(nextLine);
        }
      });
      return completedLines.filter((line2) => line2 !== "").join(config2.joinWith);
    },
    (label, maxWidth, config2) => `${label}${maxWidth}${config2.fontSize}${config2.fontWeight}${config2.fontFamily}${config2.joinWith}`
  );
  const breakString = memoize(
    (word, maxWidth, hyphenCharacter = "-", config2) => {
      config2 = Object.assign(
        { fontSize: 12, fontWeight: 400, fontFamily: "Arial", margin: 0 },
        config2
      );
      const characters2 = [...word];
      const lines = [];
      let currentLine = "";
      characters2.forEach((character2, index2) => {
        const nextLine = `${currentLine}${character2}`;
        const lineWidth = calculateTextWidth(nextLine, config2);
        if (lineWidth >= maxWidth) {
          const currentCharacter = index2 + 1;
          const isLastLine = characters2.length === currentCharacter;
          const hyphenatedNextLine = `${nextLine}${hyphenCharacter}`;
          lines.push(isLastLine ? nextLine : hyphenatedNextLine);
          currentLine = "";
        } else {
          currentLine = nextLine;
        }
      });
      return { hyphenatedStrings: lines, remainingWord: currentLine };
    },
    (word, maxWidth, hyphenCharacter = "-", config2) => `${word}${maxWidth}${hyphenCharacter}${config2.fontSize}${config2.fontWeight}${config2.fontFamily}`
  );
  function calculateTextHeight(text2, config2) {
    return calculateTextDimensions(text2, config2).height;
  }
  function calculateTextWidth(text2, config2) {
    return calculateTextDimensions(text2, config2).width;
  }
  const calculateTextDimensions = memoize(
    (text2, config2) => {
      const { fontSize = 12, fontFamily = "Arial", fontWeight = 400 } = config2;
      if (!text2) {
        return { width: 0, height: 0 };
      }
      const [, _fontSizePx] = parseFontSize(fontSize);
      const fontFamilies = ["sans-serif", fontFamily];
      const lines = text2.split(common$1.lineBreakRegex);
      const dims = [];
      const body = d3select("body");
      if (!body.remove) {
        return { width: 0, height: 0, lineHeight: 0 };
      }
      const g = body.append("svg");
      for (const fontFamily2 of fontFamilies) {
        let cHeight = 0;
        const dim = { width: 0, height: 0, lineHeight: 0 };
        for (const line2 of lines) {
          const textObj = getTextObj$3();
          textObj.text = line2 || ZERO_WIDTH_SPACE;
          const textElem = drawSimpleText(g, textObj).style("font-size", _fontSizePx).style("font-weight", fontWeight).style("font-family", fontFamily2);
          const bBox = (textElem._groups || textElem)[0][0].getBBox();
          if (bBox.width === 0 && bBox.height === 0) {
            throw new Error("svg element not in render tree");
          }
          dim.width = Math.round(Math.max(dim.width, bBox.width));
          cHeight = Math.round(bBox.height);
          dim.height += cHeight;
          dim.lineHeight = Math.round(Math.max(dim.lineHeight, cHeight));
        }
        dims.push(dim);
      }
      g.remove();
      const index2 = isNaN(dims[1].height) || isNaN(dims[1].width) || isNaN(dims[1].lineHeight) || dims[0].height > dims[1].height && dims[0].width > dims[1].width && dims[0].lineHeight > dims[1].lineHeight ? 0 : 1;
      return dims[index2];
    },
    (text2, config2) => `${text2}${config2.fontSize}${config2.fontWeight}${config2.fontFamily}`
  );
  class InitIDGenerator {
    constructor(deterministic = false, seed) {
      this.count = 0;
      this.count = seed ? seed.length : 0;
      this.next = deterministic ? () => this.count++ : () => Date.now();
    }
  }
  let decoder;
  const entityDecode = function(html2) {
    decoder = decoder || document.createElement("div");
    html2 = escape(html2).replace(/%26/g, "&").replace(/%23/g, "#").replace(/%3B/g, ";");
    decoder.innerHTML = html2;
    return unescape(decoder.textContent);
  };
  function isDetailedError(error) {
    return "str" in error;
  }
  const insertTitle = (parent, cssClass, titleTopMargin, title2) => {
    var _a2;
    if (!title2) {
      return;
    }
    const bounds2 = (_a2 = parent.node()) == null ? void 0 : _a2.getBBox();
    if (!bounds2) {
      return;
    }
    parent.append("text").text(title2).attr("x", bounds2.x + bounds2.width / 2).attr("y", -titleTopMargin).attr("class", cssClass);
  };
  const parseFontSize = (fontSize) => {
    if (typeof fontSize === "number") {
      return [fontSize, fontSize + "px"];
    }
    const fontSizeNumber = parseInt(fontSize ?? "", 10);
    if (Number.isNaN(fontSizeNumber)) {
      return [void 0, void 0];
    } else if (fontSize === String(fontSizeNumber)) {
      return [fontSizeNumber, fontSize + "px"];
    } else {
      return [fontSizeNumber, fontSize];
    }
  };
  function cleanAndMerge(defaultData, data) {
    return merge$3({}, defaultData, data);
  }
  const utils = {
    assignWithDepth: assignWithDepth$1,
    wrapLabel,
    calculateTextHeight,
    calculateTextWidth,
    calculateTextDimensions,
    cleanAndMerge,
    detectInit,
    detectDirective,
    isSubstringInArray,
    interpolateToCurve,
    calcLabelPosition,
    calcCardinalityPosition,
    calcTerminalLabelPosition,
    formatUrl,
    getStylesFromArray,
    generateId: generateId$2,
    random,
    runFunc,
    entityDecode,
    insertTitle,
    parseFontSize,
    InitIDGenerator
  };
  const encodeEntities = function(text2) {
    let txt = text2;
    txt = txt.replace(/style.*:\S*#.*;/g, function(s) {
      return s.substring(0, s.length - 1);
    });
    txt = txt.replace(/classDef.*:\S*#.*;/g, function(s) {
      return s.substring(0, s.length - 1);
    });
    txt = txt.replace(/#\w+;/g, function(s) {
      const innerTxt = s.substring(1, s.length - 1);
      const isInt = /^\+?\d+$/.test(innerTxt);
      if (isInt) {
        return "ﬂ°°" + innerTxt + "¶ß";
      } else {
        return "ﬂ°" + innerTxt + "¶ß";
      }
    });
    return txt;
  };
  const decodeEntities = function(text2) {
    return text2.replace(/ﬂ°°/g, "&#").replace(/ﬂ°/g, "&").replace(/¶ß/g, ";");
  };
  var COMMENT = "comm";
  var RULESET = "rule";
  var DECLARATION = "decl";
  var IMPORT = "@import";
  var KEYFRAMES = "@keyframes";
  var abs = Math.abs;
  var from = String.fromCharCode;
  function trim(value2) {
    return value2.trim();
  }
  function replace(value2, pattern, replacement) {
    return value2.replace(pattern, replacement);
  }
  function indexof(value2, search2) {
    return value2.indexOf(search2);
  }
  function charat(value2, index2) {
    return value2.charCodeAt(index2) | 0;
  }
  function substr(value2, begin, end2) {
    return value2.slice(begin, end2);
  }
  function strlen(value2) {
    return value2.length;
  }
  function sizeof(value2) {
    return value2.length;
  }
  function append(value2, array2) {
    return array2.push(value2), value2;
  }
  var line = 1;
  var column = 1;
  var length = 0;
  var position$2 = 0;
  var character = 0;
  var characters = "";
  function node$1(value2, root2, parent, type2, props, children2, length2) {
    return { value: value2, root: root2, parent, type: type2, props, children: children2, line, column, length: length2, return: "" };
  }
  function char() {
    return character;
  }
  function prev() {
    character = position$2 > 0 ? charat(characters, --position$2) : 0;
    if (column--, character === 10)
      column = 1, line--;
    return character;
  }
  function next$1() {
    character = position$2 < length ? charat(characters, position$2++) : 0;
    if (column++, character === 10)
      column = 1, line++;
    return character;
  }
  function peek() {
    return charat(characters, position$2);
  }
  function caret() {
    return position$2;
  }
  function slice$1(begin, end2) {
    return substr(characters, begin, end2);
  }
  function token(type2) {
    switch (type2) {
      case 0:
      case 9:
      case 10:
      case 13:
      case 32:
        return 5;
      case 33:
      case 43:
      case 44:
      case 47:
      case 62:
      case 64:
      case 126:
      case 59:
      case 123:
      case 125:
        return 4;
      case 58:
        return 3;
      case 34:
      case 39:
      case 40:
      case 91:
        return 2;
      case 41:
      case 93:
        return 1;
    }
    return 0;
  }
  function alloc(value2) {
    return line = column = 1, length = strlen(characters = value2), position$2 = 0, [];
  }
  function dealloc(value2) {
    return characters = "", value2;
  }
  function delimit(type2) {
    return trim(slice$1(position$2 - 1, delimiter(type2 === 91 ? type2 + 2 : type2 === 40 ? type2 + 1 : type2)));
  }
  function whitespace(type2) {
    while (character = peek())
      if (character < 33)
        next$1();
      else
        break;
    return token(type2) > 2 || token(character) > 3 ? "" : " ";
  }
  function escaping(index2, count) {
    while (--count && next$1())
      if (character < 48 || character > 102 || character > 57 && character < 65 || character > 70 && character < 97)
        break;
    return slice$1(index2, caret() + (count < 6 && peek() == 32 && next$1() == 32));
  }
  function delimiter(type2) {
    while (next$1())
      switch (character) {
        case type2:
          return position$2;
        case 34:
        case 39:
          if (type2 !== 34 && type2 !== 39)
            delimiter(character);
          break;
        case 40:
          if (type2 === 41)
            delimiter(type2);
          break;
        case 92:
          next$1();
          break;
      }
    return position$2;
  }
  function commenter(type2, index2) {
    while (next$1())
      if (type2 + character === 47 + 10)
        break;
      else if (type2 + character === 42 + 42 && peek() === 47)
        break;
    return "/*" + slice$1(index2, position$2 - 1) + "*" + from(type2 === 47 ? type2 : next$1());
  }
  function identifier(index2) {
    while (!token(peek()))
      next$1();
    return slice$1(index2, position$2);
  }
  function compile(value2) {
    return dealloc(parse$4("", null, null, null, [""], value2 = alloc(value2), 0, [0], value2));
  }
  function parse$4(value2, root2, parent, rule, rules, rulesets, pseudo, points, declarations) {
    var index2 = 0;
    var offset = 0;
    var length2 = pseudo;
    var atrule = 0;
    var property2 = 0;
    var previous2 = 0;
    var variable = 1;
    var scanning = 1;
    var ampersand = 1;
    var character2 = 0;
    var type2 = "";
    var props = rules;
    var children2 = rulesets;
    var reference = rule;
    var characters2 = type2;
    while (scanning)
      switch (previous2 = character2, character2 = next$1()) {
        case 40:
          if (previous2 != 108 && charat(characters2, length2 - 1) == 58) {
            if (indexof(characters2 += replace(delimit(character2), "&", "&\f"), "&\f") != -1)
              ampersand = -1;
            break;
          }
        case 34:
        case 39:
        case 91:
          characters2 += delimit(character2);
          break;
        case 9:
        case 10:
        case 13:
        case 32:
          characters2 += whitespace(previous2);
          break;
        case 92:
          characters2 += escaping(caret() - 1, 7);
          continue;
        case 47:
          switch (peek()) {
            case 42:
            case 47:
              append(comment(commenter(next$1(), caret()), root2, parent), declarations);
              break;
            default:
              characters2 += "/";
          }
          break;
        case 123 * variable:
          points[index2++] = strlen(characters2) * ampersand;
        case 125 * variable:
        case 59:
        case 0:
          switch (character2) {
            case 0:
            case 125:
              scanning = 0;
            case 59 + offset:
              if (property2 > 0 && strlen(characters2) - length2)
                append(property2 > 32 ? declaration(characters2 + ";", rule, parent, length2 - 1) : declaration(replace(characters2, " ", "") + ";", rule, parent, length2 - 2), declarations);
              break;
            case 59:
              characters2 += ";";
            default:
              append(reference = ruleset(characters2, root2, parent, index2, offset, rules, points, type2, props = [], children2 = [], length2), rulesets);
              if (character2 === 123)
                if (offset === 0)
                  parse$4(characters2, root2, reference, reference, props, rulesets, length2, points, children2);
                else
                  switch (atrule === 99 && charat(characters2, 3) === 110 ? 100 : atrule) {
                    case 100:
                    case 109:
                    case 115:
                      parse$4(value2, reference, reference, rule && append(ruleset(value2, reference, reference, 0, 0, rules, points, type2, rules, props = [], length2), children2), rules, children2, length2, points, rule ? props : children2);
                      break;
                    default:
                      parse$4(characters2, reference, reference, reference, [""], children2, 0, points, children2);
                  }
          }
          index2 = offset = property2 = 0, variable = ampersand = 1, type2 = characters2 = "", length2 = pseudo;
          break;
        case 58:
          length2 = 1 + strlen(characters2), property2 = previous2;
        default:
          if (variable < 1) {
            if (character2 == 123)
              --variable;
            else if (character2 == 125 && variable++ == 0 && prev() == 125)
              continue;
          }
          switch (characters2 += from(character2), character2 * variable) {
            case 38:
              ampersand = offset > 0 ? 1 : (characters2 += "\f", -1);
              break;
            case 44:
              points[index2++] = (strlen(characters2) - 1) * ampersand, ampersand = 1;
              break;
            case 64:
              if (peek() === 45)
                characters2 += delimit(next$1());
              atrule = peek(), offset = length2 = strlen(type2 = characters2 += identifier(caret())), character2++;
              break;
            case 45:
              if (previous2 === 45 && strlen(characters2) == 2)
                variable = 0;
          }
      }
    return rulesets;
  }
  function ruleset(value2, root2, parent, index2, offset, rules, points, type2, props, children2, length2) {
    var post = offset - 1;
    var rule = offset === 0 ? rules : [""];
    var size2 = sizeof(rule);
    for (var i2 = 0, j = 0, k = 0; i2 < index2; ++i2)
      for (var x2 = 0, y2 = substr(value2, post + 1, post = abs(j = points[i2])), z = value2; x2 < size2; ++x2)
        if (z = trim(j > 0 ? rule[x2] + " " + y2 : replace(y2, /&\f/g, rule[x2])))
          props[k++] = z;
    return node$1(value2, root2, parent, offset === 0 ? RULESET : type2, props, children2, length2);
  }
  function comment(value2, root2, parent) {
    return node$1(value2, root2, parent, COMMENT, from(char()), substr(value2, 2, -2), 0);
  }
  function declaration(value2, root2, parent, length2) {
    return node$1(value2, root2, parent, DECLARATION, substr(value2, 0, length2), substr(value2, length2 + 1, -1), length2);
  }
  function serialize(children2, callback) {
    var output = "";
    var length2 = sizeof(children2);
    for (var i2 = 0; i2 < length2; i2++)
      output += callback(children2[i2], i2, children2, callback) || "";
    return output;
  }
  function stringify(element2, index2, children2, callback) {
    switch (element2.type) {
      case IMPORT:
      case DECLARATION:
        return element2.return = element2.return || element2.value;
      case COMMENT:
        return "";
      case KEYFRAMES:
        return element2.return = element2.value + "{" + serialize(element2.children, callback) + "}";
      case RULESET:
        element2.value = element2.props.join(",");
    }
    return strlen(children2 = serialize(element2.children, callback)) ? element2.return = element2.value + "{" + children2 + "}" : "";
  }
  const version$1 = "10.8.0";
  const defaultConfig$1 = Object.freeze(defaultConfig$2);
  let siteConfig = assignWithDepth$1({}, defaultConfig$1);
  let configFromInitialize;
  let directives = [];
  let currentConfig = assignWithDepth$1({}, defaultConfig$1);
  const updateCurrentConfig = (siteCfg, _directives) => {
    let cfg = assignWithDepth$1({}, siteCfg);
    let sumOfDirectives = {};
    for (const d of _directives) {
      sanitize(d);
      sumOfDirectives = assignWithDepth$1(sumOfDirectives, d);
    }
    cfg = assignWithDepth$1(cfg, sumOfDirectives);
    if (sumOfDirectives.theme && sumOfDirectives.theme in theme) {
      const tmpConfigFromInitialize = assignWithDepth$1({}, configFromInitialize);
      const themeVariables = assignWithDepth$1(
        tmpConfigFromInitialize.themeVariables || {},
        sumOfDirectives.themeVariables
      );
      if (cfg.theme && cfg.theme in theme) {
        cfg.themeVariables = theme[cfg.theme].getThemeVariables(themeVariables);
      }
    }
    currentConfig = cfg;
    checkConfig(currentConfig);
    return currentConfig;
  };
  const setSiteConfig = (conf2) => {
    siteConfig = assignWithDepth$1({}, defaultConfig$1);
    siteConfig = assignWithDepth$1(siteConfig, conf2);
    if (conf2.theme && theme[conf2.theme]) {
      siteConfig.themeVariables = theme[conf2.theme].getThemeVariables(conf2.themeVariables);
    }
    updateCurrentConfig(siteConfig, directives);
    return siteConfig;
  };
  const saveConfigFromInitialize = (conf2) => {
    configFromInitialize = assignWithDepth$1({}, conf2);
  };
  const updateSiteConfig = (conf2) => {
    siteConfig = assignWithDepth$1(siteConfig, conf2);
    updateCurrentConfig(siteConfig, directives);
    return siteConfig;
  };
  const getSiteConfig = () => {
    return assignWithDepth$1({}, siteConfig);
  };
  const setConfig$1 = (conf2) => {
    checkConfig(conf2);
    assignWithDepth$1(currentConfig, conf2);
    return getConfig$2();
  };
  const getConfig$2 = () => {
    return assignWithDepth$1({}, currentConfig);
  };
  const sanitize = (options2) => {
    if (!options2) {
      return;
    }
    ["secure", ...siteConfig.secure ?? []].forEach((key) => {
      if (Object.hasOwn(options2, key)) {
        log$1.debug(`Denied attempt to modify a secure key ${key}`, options2[key]);
        delete options2[key];
      }
    });
    Object.keys(options2).forEach((key) => {
      if (key.startsWith("__")) {
        delete options2[key];
      }
    });
    Object.keys(options2).forEach((key) => {
      if (typeof options2[key] === "string" && (options2[key].includes("<") || options2[key].includes(">") || options2[key].includes("url(data:"))) {
        delete options2[key];
      }
      if (typeof options2[key] === "object") {
        sanitize(options2[key]);
      }
    });
  };
  const addDirective = (directive) => {
    sanitizeDirective(directive);
    if (directive.fontFamily && (!directive.themeVariables || !directive.themeVariables.fontFamily)) {
      directive.themeVariables = { fontFamily: directive.fontFamily };
    }
    directives.push(directive);
    updateCurrentConfig(siteConfig, directives);
  };
  const reset = (config2 = siteConfig) => {
    directives = [];
    updateCurrentConfig(config2, directives);
  };
  const ConfigWarning = {
    LAZY_LOAD_DEPRECATED: "The configuration options lazyLoadedDiagrams and loadExternalDiagramsAtStartup are deprecated. Please use registerExternalDiagrams instead."
  };
  const issuedWarnings = {};
  const issueWarning = (warning) => {
    if (issuedWarnings[warning]) {
      return;
    }
    log$1.warn(ConfigWarning[warning]);
    issuedWarnings[warning] = true;
  };
  const checkConfig = (config2) => {
    if (!config2) {
      return;
    }
    if (config2.lazyLoadedDiagrams || config2.loadExternalDiagramsAtStartup) {
      issueWarning("LAZY_LOAD_DEPRECATED");
    }
  };
  const id$l = "c4";
  const detector$l = (txt) => {
    return /^\s*C4Context|C4Container|C4Component|C4Dynamic|C4Deployment/.test(txt);
  };
  const loader$m = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => c4Diagram);
    return { id: id$l, diagram: diagram2 };
  };
  const plugin$j = {
    id: id$l,
    detector: detector$l,
    loader: loader$m
  };
  const c4 = plugin$j;
  const id$k = "flowchart";
  const detector$k = (txt, config2) => {
    var _a2, _b2;
    if (((_a2 = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _a2.defaultRenderer) === "dagre-wrapper" || ((_b2 = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _b2.defaultRenderer) === "elk") {
      return false;
    }
    return /^\s*graph/.test(txt);
  };
  const loader$l = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => flowDiagram);
    return { id: id$k, diagram: diagram2 };
  };
  const plugin$i = {
    id: id$k,
    detector: detector$k,
    loader: loader$l
  };
  const flowchart = plugin$i;
  const id$j = "flowchart-v2";
  const detector$j = (txt, config2) => {
    var _a2, _b2, _c;
    if (((_a2 = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _a2.defaultRenderer) === "dagre-d3" || ((_b2 = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _b2.defaultRenderer) === "elk") {
      return false;
    }
    if (/^\s*graph/.test(txt) && ((_c = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _c.defaultRenderer) === "dagre-wrapper") {
      return true;
    }
    return /^\s*flowchart/.test(txt);
  };
  const loader$k = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => flowDiagramV2);
    return { id: id$j, diagram: diagram2 };
  };
  const plugin$h = {
    id: id$j,
    detector: detector$j,
    loader: loader$k
  };
  const flowchartV2 = plugin$h;
  const id$i = "er";
  const detector$i = (txt) => {
    return /^\s*erDiagram/.test(txt);
  };
  const loader$j = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => erDiagram);
    return { id: id$i, diagram: diagram2 };
  };
  const plugin$g = {
    id: id$i,
    detector: detector$i,
    loader: loader$j
  };
  const er = plugin$g;
  const id$h = "gitGraph";
  const detector$h = (txt) => {
    return /^\s*gitGraph/.test(txt);
  };
  const loader$i = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => gitGraphDiagram);
    return { id: id$h, diagram: diagram2 };
  };
  const plugin$f = {
    id: id$h,
    detector: detector$h,
    loader: loader$i
  };
  const git = plugin$f;
  const id$g = "gantt";
  const detector$g = (txt) => {
    return /^\s*gantt/.test(txt);
  };
  const loader$h = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => ganttDiagram);
    return { id: id$g, diagram: diagram2 };
  };
  const plugin$e = {
    id: id$g,
    detector: detector$g,
    loader: loader$h
  };
  const gantt = plugin$e;
  const id$f = "info";
  const detector$f = (txt) => {
    return /^\s*info/.test(txt);
  };
  const loader$g = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => infoDiagram);
    return { id: id$f, diagram: diagram2 };
  };
  const info$1 = {
    id: id$f,
    detector: detector$f,
    loader: loader$g
  };
  const id$e = "pie";
  const detector$e = (txt) => {
    return /^\s*pie/.test(txt);
  };
  const loader$f = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => pieDiagram);
    return { id: id$e, diagram: diagram2 };
  };
  const pie = {
    id: id$e,
    detector: detector$e,
    loader: loader$f
  };
  const id$d = "quadrantChart";
  const detector$d = (txt) => {
    return /^\s*quadrantChart/.test(txt);
  };
  const loader$e = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => quadrantDiagram);
    return { id: id$d, diagram: diagram2 };
  };
  const plugin$d = {
    id: id$d,
    detector: detector$d,
    loader: loader$e
  };
  const quadrantChart = plugin$d;
  const id$c = "xychart";
  const detector$c = (txt) => {
    return /^\s*xychart-beta/.test(txt);
  };
  const loader$d = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => xychartDiagram);
    return { id: id$c, diagram: diagram2 };
  };
  const plugin$c = {
    id: id$c,
    detector: detector$c,
    loader: loader$d
  };
  const xychart = plugin$c;
  const id$b = "requirement";
  const detector$b = (txt) => {
    return /^\s*requirement(Diagram)?/.test(txt);
  };
  const loader$c = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => requirementDiagram);
    return { id: id$b, diagram: diagram2 };
  };
  const plugin$b = {
    id: id$b,
    detector: detector$b,
    loader: loader$c
  };
  const requirement = plugin$b;
  const id$a = "sequence";
  const detector$a = (txt) => {
    return /^\s*sequenceDiagram/.test(txt);
  };
  const loader$b = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => sequenceDiagram);
    return { id: id$a, diagram: diagram2 };
  };
  const plugin$a = {
    id: id$a,
    detector: detector$a,
    loader: loader$b
  };
  const sequence = plugin$a;
  const id$9 = "class";
  const detector$9 = (txt, config2) => {
    var _a2;
    if (((_a2 = config2 == null ? void 0 : config2.class) == null ? void 0 : _a2.defaultRenderer) === "dagre-wrapper") {
      return false;
    }
    return /^\s*classDiagram/.test(txt);
  };
  const loader$a = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => classDiagram);
    return { id: id$9, diagram: diagram2 };
  };
  const plugin$9 = {
    id: id$9,
    detector: detector$9,
    loader: loader$a
  };
  const classDiagram$1 = plugin$9;
  const id$8 = "classDiagram";
  const detector$8 = (txt, config2) => {
    var _a2;
    if (/^\s*classDiagram/.test(txt) && ((_a2 = config2 == null ? void 0 : config2.class) == null ? void 0 : _a2.defaultRenderer) === "dagre-wrapper") {
      return true;
    }
    return /^\s*classDiagram-v2/.test(txt);
  };
  const loader$9 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => classDiagramV2);
    return { id: id$8, diagram: diagram2 };
  };
  const plugin$8 = {
    id: id$8,
    detector: detector$8,
    loader: loader$9
  };
  const classDiagramV2$1 = plugin$8;
  const id$7 = "state";
  const detector$7 = (txt, config2) => {
    var _a2;
    if (((_a2 = config2 == null ? void 0 : config2.state) == null ? void 0 : _a2.defaultRenderer) === "dagre-wrapper") {
      return false;
    }
    return /^\s*stateDiagram/.test(txt);
  };
  const loader$8 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => stateDiagram);
    return { id: id$7, diagram: diagram2 };
  };
  const plugin$7 = {
    id: id$7,
    detector: detector$7,
    loader: loader$8
  };
  const state$1 = plugin$7;
  const id$6 = "stateDiagram";
  const detector$6 = (txt, config2) => {
    var _a2;
    if (/^\s*stateDiagram-v2/.test(txt)) {
      return true;
    }
    if (/^\s*stateDiagram/.test(txt) && ((_a2 = config2 == null ? void 0 : config2.state) == null ? void 0 : _a2.defaultRenderer) === "dagre-wrapper") {
      return true;
    }
    return false;
  };
  const loader$7 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => stateDiagramV2);
    return { id: id$6, diagram: diagram2 };
  };
  const plugin$6 = {
    id: id$6,
    detector: detector$6,
    loader: loader$7
  };
  const stateV2 = plugin$6;
  const id$5 = "journey";
  const detector$5 = (txt) => {
    return /^\s*journey/.test(txt);
  };
  const loader$6 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => journeyDiagram);
    return { id: id$5, diagram: diagram2 };
  };
  const plugin$5 = {
    id: id$5,
    detector: detector$5,
    loader: loader$6
  };
  const journey = plugin$5;
  const d3Attrs = function(d3Elem, attrs) {
    for (let attr of attrs) {
      d3Elem.attr(attr[0], attr[1]);
    }
  };
  const calculateSvgSizeAttrs = function(height, width2, useMaxWidth) {
    let attrs = /* @__PURE__ */ new Map();
    if (useMaxWidth) {
      attrs.set("width", "100%");
      attrs.set("style", `max-width: ${width2}px;`);
    } else {
      attrs.set("height", height);
      attrs.set("width", width2);
    }
    return attrs;
  };
  const configureSvgSize = function(svgElem, height, width2, useMaxWidth) {
    const attrs = calculateSvgSizeAttrs(height, width2, useMaxWidth);
    d3Attrs(svgElem, attrs);
  };
  const setupGraphViewbox$1 = function(graph, svgElem, padding2, useMaxWidth) {
    const svgBounds = svgElem.node().getBBox();
    const sWidth = svgBounds.width;
    const sHeight = svgBounds.height;
    log$1.info(`SVG bounds: ${sWidth}x${sHeight}`, svgBounds);
    let width2 = 0;
    let height = 0;
    log$1.info(`Graph bounds: ${width2}x${height}`, graph);
    width2 = sWidth + padding2 * 2;
    height = sHeight + padding2 * 2;
    log$1.info(`Calculated bounds: ${width2}x${height}`);
    configureSvgSize(svgElem, height, width2, useMaxWidth);
    const vBox = `${svgBounds.x - padding2} ${svgBounds.y - padding2} ${svgBounds.width + 2 * padding2} ${svgBounds.height + 2 * padding2}`;
    svgElem.attr("viewBox", vBox);
  };
  const themes = {};
  const getStyles$f = (type2, userStyles, options2) => {
    let diagramStyles = "";
    if (type2 in themes && themes[type2]) {
      diagramStyles = themes[type2](options2);
    } else {
      log$1.warn(`No theme found for ${type2}`);
    }
    return ` & {
    font-family: ${options2.fontFamily};
    font-size: ${options2.fontSize};
    fill: ${options2.textColor}
  }

  /* Classes common for multiple diagrams */

  & .error-icon {
    fill: ${options2.errorBkgColor};
  }
  & .error-text {
    fill: ${options2.errorTextColor};
    stroke: ${options2.errorTextColor};
  }

  & .edge-thickness-normal {
    stroke-width: 2px;
  }
  & .edge-thickness-thick {
    stroke-width: 3.5px
  }
  & .edge-pattern-solid {
    stroke-dasharray: 0;
  }

  & .edge-pattern-dashed{
    stroke-dasharray: 3;
  }
  .edge-pattern-dotted {
    stroke-dasharray: 2;
  }

  & .marker {
    fill: ${options2.lineColor};
    stroke: ${options2.lineColor};
  }
  & .marker.cross {
    stroke: ${options2.lineColor};
  }

  & svg {
    font-family: ${options2.fontFamily};
    font-size: ${options2.fontSize};
  }

  ${diagramStyles}

  ${userStyles}
`;
  };
  const addStylesForDiagram = (type2, diagramTheme) => {
    if (diagramTheme !== void 0) {
      themes[type2] = diagramTheme;
    }
  };
  const getStyles$g = getStyles$f;
  let accTitle = "";
  let diagramTitle = "";
  let accDescription = "";
  const sanitizeText$4 = (txt) => sanitizeText$5(txt, getConfig$2());
  const clear$n = () => {
    accTitle = "";
    accDescription = "";
    diagramTitle = "";
  };
  const setAccTitle = (txt) => {
    accTitle = sanitizeText$4(txt).replace(/^\s+/g, "");
  };
  const getAccTitle = () => accTitle;
  const setAccDescription = (txt) => {
    accDescription = sanitizeText$4(txt).replace(/\n\s+/g, "\n");
  };
  const getAccDescription = () => accDescription;
  const setDiagramTitle = (txt) => {
    diagramTitle = sanitizeText$4(txt);
  };
  const getDiagramTitle = () => diagramTitle;
  const commonDb = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    clear: clear$n,
    getAccDescription,
    getAccTitle,
    getDiagramTitle,
    setAccDescription,
    setAccTitle,
    setDiagramTitle
  }, Symbol.toStringTag, { value: "Module" }));
  const log = log$1;
  const setLogLevel = setLogLevel$1;
  const getConfig$1 = getConfig$2;
  const setConfig = setConfig$1;
  const defaultConfig = defaultConfig$1;
  const sanitizeText$3 = (text2) => sanitizeText$5(text2, getConfig$1());
  const setupGraphViewbox = setupGraphViewbox$1;
  const getCommonDb$1 = () => {
    return commonDb;
  };
  const diagrams = {};
  const registerDiagram = (id2, diagram2, detector2) => {
    var _a2;
    if (diagrams[id2]) {
      throw new Error(`Diagram ${id2} already registered.`);
    }
    diagrams[id2] = diagram2;
    if (detector2) {
      addDetector(id2, detector2);
    }
    addStylesForDiagram(id2, diagram2.styles);
    (_a2 = diagram2.injectUtils) == null ? void 0 : _a2.call(
      diagram2,
      log,
      setLogLevel,
      getConfig$1,
      sanitizeText$3,
      setupGraphViewbox,
      getCommonDb$1(),
      () => {
      }
    );
  };
  const getDiagram = (name) => {
    if (name in diagrams) {
      return diagrams[name];
    }
    throw new DiagramNotFoundError(name);
  };
  class DiagramNotFoundError extends Error {
    constructor(name) {
      super(`Diagram ${name} not found.`);
    }
  }
  const selectSvgElement = (id2) => {
    var _a2;
    const { securityLevel } = getConfig$1();
    let root2 = d3select("body");
    if (securityLevel === "sandbox") {
      const sandboxElement = d3select(`#i${id2}`);
      const doc = ((_a2 = sandboxElement.node()) == null ? void 0 : _a2.contentDocument) ?? document;
      root2 = d3select(doc.body);
    }
    const svg2 = root2.select(`#${id2}`);
    return svg2;
  };
  const draw$m = (_text, id2, version2) => {
    log$1.debug("rendering svg for syntax error\n");
    const svg2 = selectSvgElement(id2);
    svg2.attr("viewBox", "0 0 2412 512");
    configureSvgSize(svg2, 100, 512, true);
    const g = svg2.append("g");
    g.append("path").attr("class", "error-icon").attr(
      "d",
      "m411.313,123.313c6.25-6.25 6.25-16.375 0-22.625s-16.375-6.25-22.625,0l-32,32-9.375,9.375-20.688-20.688c-12.484-12.5-32.766-12.5-45.25,0l-16,16c-1.261,1.261-2.304,2.648-3.31,4.051-21.739-8.561-45.324-13.426-70.065-13.426-105.867,0-192,86.133-192,192s86.133,192 192,192 192-86.133 192-192c0-24.741-4.864-48.327-13.426-70.065 1.402-1.007 2.79-2.049 4.051-3.31l16-16c12.5-12.492 12.5-32.758 0-45.25l-20.688-20.688 9.375-9.375 32.001-31.999zm-219.313,100.687c-52.938,0-96,43.063-96,96 0,8.836-7.164,16-16,16s-16-7.164-16-16c0-70.578 57.422-128 128-128 8.836,0 16,7.164 16,16s-7.164,16-16,16z"
    );
    g.append("path").attr("class", "error-icon").attr(
      "d",
      "m459.02,148.98c-6.25-6.25-16.375-6.25-22.625,0s-6.25,16.375 0,22.625l16,16c3.125,3.125 7.219,4.688 11.313,4.688 4.094,0 8.188-1.563 11.313-4.688 6.25-6.25 6.25-16.375 0-22.625l-16.001-16z"
    );
    g.append("path").attr("class", "error-icon").attr(
      "d",
      "m340.395,75.605c3.125,3.125 7.219,4.688 11.313,4.688 4.094,0 8.188-1.563 11.313-4.688 6.25-6.25 6.25-16.375 0-22.625l-16-16c-6.25-6.25-16.375-6.25-22.625,0s-6.25,16.375 0,22.625l15.999,16z"
    );
    g.append("path").attr("class", "error-icon").attr(
      "d",
      "m400,64c8.844,0 16-7.164 16-16v-32c0-8.836-7.156-16-16-16-8.844,0-16,7.164-16,16v32c0,8.836 7.156,16 16,16z"
    );
    g.append("path").attr("class", "error-icon").attr(
      "d",
      "m496,96.586h-32c-8.844,0-16,7.164-16,16 0,8.836 7.156,16 16,16h32c8.844,0 16-7.164 16-16 0-8.836-7.156-16-16-16z"
    );
    g.append("path").attr("class", "error-icon").attr(
      "d",
      "m436.98,75.605c3.125,3.125 7.219,4.688 11.313,4.688 4.094,0 8.188-1.563 11.313-4.688l32-32c6.25-6.25 6.25-16.375 0-22.625s-16.375-6.25-22.625,0l-32,32c-6.251,6.25-6.251,16.375-0.001,22.625z"
    );
    g.append("text").attr("class", "error-text").attr("x", 1440).attr("y", 250).attr("font-size", "150px").style("text-anchor", "middle").text("Syntax error in text");
    g.append("text").attr("class", "error-text").attr("x", 1250).attr("y", 400).attr("font-size", "100px").style("text-anchor", "middle").text(`mermaid version ${version2}`);
  };
  const renderer$h = { draw: draw$m };
  const errorRenderer = renderer$h;
  const diagram$m = {
    db: {},
    renderer: renderer$h,
    parser: {
      parser: { yy: {} },
      parse: () => {
        return;
      }
    }
  };
  const errorDiagram = diagram$m;
  const id$4 = "flowchart-elk";
  const detector$4 = (txt, config2) => {
    var _a2;
    if (
      // If diagram explicitly states flowchart-elk
      /^\s*flowchart-elk/.test(txt) || // If a flowchart/graph diagram has their default renderer set to elk
      /^\s*flowchart|graph/.test(txt) && ((_a2 = config2 == null ? void 0 : config2.flowchart) == null ? void 0 : _a2.defaultRenderer) === "elk"
    ) {
      return true;
    }
    return false;
  };
  const loader$5 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => flowchartElkDefinition);
    return { id: id$4, diagram: diagram2 };
  };
  const plugin$4 = {
    id: id$4,
    detector: detector$4,
    loader: loader$5
  };
  const flowchartElk = plugin$4;
  const id$3 = "timeline";
  const detector$3 = (txt) => {
    return /^\s*timeline/.test(txt);
  };
  const loader$4 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => timelineDefinition);
    return { id: id$3, diagram: diagram2 };
  };
  const plugin$3 = {
    id: id$3,
    detector: detector$3,
    loader: loader$4
  };
  const timeline = plugin$3;
  const id$2 = "mindmap";
  const detector$2 = (txt) => {
    return /^\s*mindmap/.test(txt);
  };
  const loader$3 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => mindmapDefinition);
    return { id: id$2, diagram: diagram2 };
  };
  const plugin$2 = {
    id: id$2,
    detector: detector$2,
    loader: loader$3
  };
  const mindmap = plugin$2;
  const id$1 = "sankey";
  const detector$1 = (txt) => {
    return /^\s*sankey-beta/.test(txt);
  };
  const loader$2 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => sankeyDiagram);
    return { id: id$1, diagram: diagram2 };
  };
  const plugin$1 = {
    id: id$1,
    detector: detector$1,
    loader: loader$2
  };
  const sankey = plugin$1;
  const id = "block";
  const detector = (txt) => {
    return /^\s*block-beta/.test(txt);
  };
  const loader$1 = async () => {
    const { diagram: diagram2 } = await Promise.resolve().then(() => blockDiagram);
    return { id, diagram: diagram2 };
  };
  const plugin = {
    id,
    detector,
    loader: loader$1
  };
  const block = plugin;
  let hasLoadedDiagrams = false;
  const addDiagrams = () => {
    if (hasLoadedDiagrams) {
      return;
    }
    hasLoadedDiagrams = true;
    registerDiagram("error", errorDiagram, (text2) => {
      return text2.toLowerCase().trim() === "error";
    });
    registerDiagram(
      "---",
      // --- diagram type may appear if YAML front-matter is not parsed correctly
      {
        db: {
          clear: () => {
          }
        },
        styles: {},
        // should never be used
        renderer: {
          draw: () => {
          }
        },
        parser: {
          parser: { yy: {} },
          parse: () => {
            throw new Error(
              "Diagrams beginning with --- are not valid. If you were trying to use a YAML front-matter, please ensure that you've correctly opened and closed the YAML front-matter with un-indented `---` blocks"
            );
          }
        },
        init: () => null
        // no op
      },
      (text2) => {
        return text2.toLowerCase().trimStart().startsWith("---");
      }
    );
    registerLazyLoadedDiagrams(
      c4,
      classDiagramV2$1,
      classDiagram$1,
      er,
      gantt,
      info$1,
      pie,
      requirement,
      sequence,
      flowchartElk,
      flowchartV2,
      flowchart,
      mindmap,
      timeline,
      git,
      stateV2,
      state$1,
      journey,
      quadrantChart,
      sankey,
      xychart,
      block
    );
  };
  class Diagram {
    constructor(text2, metadata = {}) {
      this.text = text2;
      this.metadata = metadata;
      this.type = "graph";
      this.text = encodeEntities(text2);
      this.text += "\n";
      const cnf = getConfig$2();
      try {
        this.type = detectType(text2, cnf);
      } catch (e) {
        this.type = "error";
        this.detectError = e;
      }
      const diagram2 = getDiagram(this.type);
      log$1.debug("Type " + this.type);
      this.db = diagram2.db;
      this.renderer = diagram2.renderer;
      this.parser = diagram2.parser;
      this.parser.parser.yy = this.db;
      this.init = diagram2.init;
      this.parse();
    }
    parse() {
      var _a2, _b2, _c, _d, _e;
      if (this.detectError) {
        throw this.detectError;
      }
      (_b2 = (_a2 = this.db).clear) == null ? void 0 : _b2.call(_a2);
      const config2 = getConfig$2();
      (_c = this.init) == null ? void 0 : _c.call(this, config2);
      if (this.metadata.title) {
        (_e = (_d = this.db).setDiagramTitle) == null ? void 0 : _e.call(_d, this.metadata.title);
      }
      this.parser.parse(this.text);
    }
    async render(id2, version2) {
      await this.renderer.draw(this.text, id2, version2, this);
    }
    getParser() {
      return this.parser;
    }
    getType() {
      return this.type;
    }
  }
  const getDiagramFromText$1 = async (text2, metadata = {}) => {
    const type2 = detectType(text2, getConfig$2());
    try {
      getDiagram(type2);
    } catch (error) {
      const loader2 = getDiagramLoader(type2);
      if (!loader2) {
        throw new UnknownDiagramError(`Diagram ${type2} not found.`);
      }
      const { id: id2, diagram: diagram2 } = await loader2();
      registerDiagram(id2, diagram2);
    }
    return new Diagram(text2, metadata);
  };
  let interactionFunctions = [];
  const attachFunctions = () => {
    interactionFunctions.forEach((f2) => {
      f2();
    });
    interactionFunctions = [];
  };
  var nativeKeys = overArg(Object.keys, Object);
  const nativeKeys$1 = nativeKeys;
  var objectProto$7 = Object.prototype;
  var hasOwnProperty$7 = objectProto$7.hasOwnProperty;
  function baseKeys(object2) {
    if (!isPrototype(object2)) {
      return nativeKeys$1(object2);
    }
    var result = [];
    for (var key in Object(object2)) {
      if (hasOwnProperty$7.call(object2, key) && key != "constructor") {
        result.push(key);
      }
    }
    return result;
  }
  var DataView$1 = getNative(root$1, "DataView");
  const DataView$2 = DataView$1;
  var Promise$1 = getNative(root$1, "Promise");
  const Promise$2 = Promise$1;
  var Set$1 = getNative(root$1, "Set");
  const Set$2 = Set$1;
  var WeakMap = getNative(root$1, "WeakMap");
  const WeakMap$1 = WeakMap;
  var mapTag$5 = "[object Map]", objectTag$2 = "[object Object]", promiseTag = "[object Promise]", setTag$5 = "[object Set]", weakMapTag$1 = "[object WeakMap]";
  var dataViewTag$3 = "[object DataView]";
  var dataViewCtorString = toSource(DataView$2), mapCtorString = toSource(Map$2), promiseCtorString = toSource(Promise$2), setCtorString = toSource(Set$2), weakMapCtorString = toSource(WeakMap$1);
  var getTag = baseGetTag;
  if (DataView$2 && getTag(new DataView$2(new ArrayBuffer(1))) != dataViewTag$3 || Map$2 && getTag(new Map$2()) != mapTag$5 || Promise$2 && getTag(Promise$2.resolve()) != promiseTag || Set$2 && getTag(new Set$2()) != setTag$5 || WeakMap$1 && getTag(new WeakMap$1()) != weakMapTag$1) {
    getTag = function(value2) {
      var result = baseGetTag(value2), Ctor = result == objectTag$2 ? value2.constructor : void 0, ctorString = Ctor ? toSource(Ctor) : "";
      if (ctorString) {
        switch (ctorString) {
          case dataViewCtorString:
            return dataViewTag$3;
          case mapCtorString:
            return mapTag$5;
          case promiseCtorString:
            return promiseTag;
          case setCtorString:
            return setTag$5;
          case weakMapCtorString:
            return weakMapTag$1;
        }
      }
      return result;
    };
  }
  const getTag$1 = getTag;
  var mapTag$4 = "[object Map]", setTag$4 = "[object Set]";
  var objectProto$6 = Object.prototype;
  var hasOwnProperty$6 = objectProto$6.hasOwnProperty;
  function isEmpty(value2) {
    if (value2 == null) {
      return true;
    }
    if (isArrayLike(value2) && (isArray$1(value2) || typeof value2 == "string" || typeof value2.splice == "function" || isBuffer$1(value2) || isTypedArray$1(value2) || isArguments$1(value2))) {
      return !value2.length;
    }
    var tag = getTag$1(value2);
    if (tag == mapTag$4 || tag == setTag$4) {
      return !value2.size;
    }
    if (isPrototype(value2)) {
      return !baseKeys(value2).length;
    }
    for (var key in value2) {
      if (hasOwnProperty$6.call(value2, key)) {
        return false;
      }
    }
    return true;
  }
  const SVG_ROLE = "graphics-document document";
  function setA11yDiagramInfo(svg2, diagramType) {
    svg2.attr("role", SVG_ROLE);
    if (diagramType !== "") {
      svg2.attr("aria-roledescription", diagramType);
    }
  }
  function addSVGa11yTitleDescription(svg2, a11yTitle, a11yDesc, baseId) {
    if (svg2.insert === void 0) {
      return;
    }
    if (a11yDesc) {
      const descId = `chart-desc-${baseId}`;
      svg2.attr("aria-describedby", descId);
      svg2.insert("desc", ":first-child").attr("id", descId).text(a11yDesc);
    }
    if (a11yTitle) {
      const titleId = `chart-title-${baseId}`;
      svg2.attr("aria-labelledby", titleId);
      svg2.insert("title", ":first-child").attr("id", titleId).text(a11yTitle);
    }
  }
  const cleanupComments = (text2) => {
    return text2.replace(/^\s*%%(?!{)[^\n]+\n?/gm, "").trimStart();
  };
  /*! js-yaml 4.1.0 https://github.com/nodeca/js-yaml @license MIT */
  function isNothing(subject) {
    return typeof subject === "undefined" || subject === null;
  }
  function isObject(subject) {
    return typeof subject === "object" && subject !== null;
  }
  function toArray(sequence2) {
    if (Array.isArray(sequence2))
      return sequence2;
    else if (isNothing(sequence2))
      return [];
    return [sequence2];
  }
  function extend(target, source) {
    var index2, length2, key, sourceKeys;
    if (source) {
      sourceKeys = Object.keys(source);
      for (index2 = 0, length2 = sourceKeys.length; index2 < length2; index2 += 1) {
        key = sourceKeys[index2];
        target[key] = source[key];
      }
    }
    return target;
  }
  function repeat(string2, count) {
    var result = "", cycle;
    for (cycle = 0; cycle < count; cycle += 1) {
      result += string2;
    }
    return result;
  }
  function isNegativeZero(number2) {
    return number2 === 0 && Number.NEGATIVE_INFINITY === 1 / number2;
  }
  var isNothing_1 = isNothing;
  var isObject_1 = isObject;
  var toArray_1 = toArray;
  var repeat_1 = repeat;
  var isNegativeZero_1 = isNegativeZero;
  var extend_1 = extend;
  var common = {
    isNothing: isNothing_1,
    isObject: isObject_1,
    toArray: toArray_1,
    repeat: repeat_1,
    isNegativeZero: isNegativeZero_1,
    extend: extend_1
  };
  function formatError(exception2, compact) {
    var where = "", message = exception2.reason || "(unknown reason)";
    if (!exception2.mark)
      return message;
    if (exception2.mark.name) {
      where += 'in "' + exception2.mark.name + '" ';
    }
    where += "(" + (exception2.mark.line + 1) + ":" + (exception2.mark.column + 1) + ")";
    if (!compact && exception2.mark.snippet) {
      where += "\n\n" + exception2.mark.snippet;
    }
    return message + " " + where;
  }
  function YAMLException$1(reason, mark) {
    Error.call(this);
    this.name = "YAMLException";
    this.reason = reason;
    this.mark = mark;
    this.message = formatError(this, false);
    if (Error.captureStackTrace) {
      Error.captureStackTrace(this, this.constructor);
    } else {
      this.stack = new Error().stack || "";
    }
  }
  YAMLException$1.prototype = Object.create(Error.prototype);
  YAMLException$1.prototype.constructor = YAMLException$1;
  YAMLException$1.prototype.toString = function toString2(compact) {
    return this.name + ": " + formatError(this, compact);
  };
  var exception = YAMLException$1;
  function getLine(buffer, lineStart, lineEnd, position2, maxLineLength) {
    var head2 = "";
    var tail = "";
    var maxHalfLength = Math.floor(maxLineLength / 2) - 1;
    if (position2 - lineStart > maxHalfLength) {
      head2 = " ... ";
      lineStart = position2 - maxHalfLength + head2.length;
    }
    if (lineEnd - position2 > maxHalfLength) {
      tail = " ...";
      lineEnd = position2 + maxHalfLength - tail.length;
    }
    return {
      str: head2 + buffer.slice(lineStart, lineEnd).replace(/\t/g, "→") + tail,
      pos: position2 - lineStart + head2.length
      // relative position
    };
  }
  function padStart(string2, max2) {
    return common.repeat(" ", max2 - string2.length) + string2;
  }
  function makeSnippet(mark, options2) {
    options2 = Object.create(options2 || null);
    if (!mark.buffer)
      return null;
    if (!options2.maxLength)
      options2.maxLength = 79;
    if (typeof options2.indent !== "number")
      options2.indent = 1;
    if (typeof options2.linesBefore !== "number")
      options2.linesBefore = 3;
    if (typeof options2.linesAfter !== "number")
      options2.linesAfter = 2;
    var re2 = /\r?\n|\r|\0/g;
    var lineStarts = [0];
    var lineEnds = [];
    var match;
    var foundLineNo = -1;
    while (match = re2.exec(mark.buffer)) {
      lineEnds.push(match.index);
      lineStarts.push(match.index + match[0].length);
      if (mark.position <= match.index && foundLineNo < 0) {
        foundLineNo = lineStarts.length - 2;
      }
    }
    if (foundLineNo < 0)
      foundLineNo = lineStarts.length - 1;
    var result = "", i2, line2;
    var lineNoLength = Math.min(mark.line + options2.linesAfter, lineEnds.length).toString().length;
    var maxLineLength = options2.maxLength - (options2.indent + lineNoLength + 3);
    for (i2 = 1; i2 <= options2.linesBefore; i2++) {
      if (foundLineNo - i2 < 0)
        break;
      line2 = getLine(
        mark.buffer,
        lineStarts[foundLineNo - i2],
        lineEnds[foundLineNo - i2],
        mark.position - (lineStarts[foundLineNo] - lineStarts[foundLineNo - i2]),
        maxLineLength
      );
      result = common.repeat(" ", options2.indent) + padStart((mark.line - i2 + 1).toString(), lineNoLength) + " | " + line2.str + "\n" + result;
    }
    line2 = getLine(mark.buffer, lineStarts[foundLineNo], lineEnds[foundLineNo], mark.position, maxLineLength);
    result += common.repeat(" ", options2.indent) + padStart((mark.line + 1).toString(), lineNoLength) + " | " + line2.str + "\n";
    result += common.repeat("-", options2.indent + lineNoLength + 3 + line2.pos) + "^\n";
    for (i2 = 1; i2 <= options2.linesAfter; i2++) {
      if (foundLineNo + i2 >= lineEnds.length)
        break;
      line2 = getLine(
        mark.buffer,
        lineStarts[foundLineNo + i2],
        lineEnds[foundLineNo + i2],
        mark.position - (lineStarts[foundLineNo] - lineStarts[foundLineNo + i2]),
        maxLineLength
      );
      result += common.repeat(" ", options2.indent) + padStart((mark.line + i2 + 1).toString(), lineNoLength) + " | " + line2.str + "\n";
    }
    return result.replace(/\n$/, "");
  }
  var snippet = makeSnippet;
  var TYPE_CONSTRUCTOR_OPTIONS = [
    "kind",
    "multi",
    "resolve",
    "construct",
    "instanceOf",
    "predicate",
    "represent",
    "representName",
    "defaultStyle",
    "styleAliases"
  ];
  var YAML_NODE_KINDS = [
    "scalar",
    "sequence",
    "mapping"
  ];
  function compileStyleAliases(map2) {
    var result = {};
    if (map2 !== null) {
      Object.keys(map2).forEach(function(style) {
        map2[style].forEach(function(alias) {
          result[String(alias)] = style;
        });
      });
    }
    return result;
  }
  function Type$1(tag, options2) {
    options2 = options2 || {};
    Object.keys(options2).forEach(function(name) {
      if (TYPE_CONSTRUCTOR_OPTIONS.indexOf(name) === -1) {
        throw new exception('Unknown option "' + name + '" is met in definition of "' + tag + '" YAML type.');
      }
    });
    this.options = options2;
    this.tag = tag;
    this.kind = options2["kind"] || null;
    this.resolve = options2["resolve"] || function() {
      return true;
    };
    this.construct = options2["construct"] || function(data) {
      return data;
    };
    this.instanceOf = options2["instanceOf"] || null;
    this.predicate = options2["predicate"] || null;
    this.represent = options2["represent"] || null;
    this.representName = options2["representName"] || null;
    this.defaultStyle = options2["defaultStyle"] || null;
    this.multi = options2["multi"] || false;
    this.styleAliases = compileStyleAliases(options2["styleAliases"] || null);
    if (YAML_NODE_KINDS.indexOf(this.kind) === -1) {
      throw new exception('Unknown kind "' + this.kind + '" is specified for "' + tag + '" YAML type.');
    }
  }
  var type = Type$1;
  function compileList(schema2, name) {
    var result = [];
    schema2[name].forEach(function(currentType) {
      var newIndex = result.length;
      result.forEach(function(previousType, previousIndex) {
        if (previousType.tag === currentType.tag && previousType.kind === currentType.kind && previousType.multi === currentType.multi) {
          newIndex = previousIndex;
        }
      });
      result[newIndex] = currentType;
    });
    return result;
  }
  function compileMap() {
    var result = {
      scalar: {},
      sequence: {},
      mapping: {},
      fallback: {},
      multi: {
        scalar: [],
        sequence: [],
        mapping: [],
        fallback: []
      }
    }, index2, length2;
    function collectType(type2) {
      if (type2.multi) {
        result.multi[type2.kind].push(type2);
        result.multi["fallback"].push(type2);
      } else {
        result[type2.kind][type2.tag] = result["fallback"][type2.tag] = type2;
      }
    }
    for (index2 = 0, length2 = arguments.length; index2 < length2; index2 += 1) {
      arguments[index2].forEach(collectType);
    }
    return result;
  }
  function Schema$1(definition2) {
    return this.extend(definition2);
  }
  Schema$1.prototype.extend = function extend2(definition2) {
    var implicit2 = [];
    var explicit = [];
    if (definition2 instanceof type) {
      explicit.push(definition2);
    } else if (Array.isArray(definition2)) {
      explicit = explicit.concat(definition2);
    } else if (definition2 && (Array.isArray(definition2.implicit) || Array.isArray(definition2.explicit))) {
      if (definition2.implicit)
        implicit2 = implicit2.concat(definition2.implicit);
      if (definition2.explicit)
        explicit = explicit.concat(definition2.explicit);
    } else {
      throw new exception("Schema.extend argument should be a Type, [ Type ], or a schema definition ({ implicit: [...], explicit: [...] })");
    }
    implicit2.forEach(function(type$1) {
      if (!(type$1 instanceof type)) {
        throw new exception("Specified list of YAML types (or a single Type object) contains a non-Type object.");
      }
      if (type$1.loadKind && type$1.loadKind !== "scalar") {
        throw new exception("There is a non-scalar type in the implicit list of a schema. Implicit resolving of such types is not supported.");
      }
      if (type$1.multi) {
        throw new exception("There is a multi type in the implicit list of a schema. Multi tags can only be listed as explicit.");
      }
    });
    explicit.forEach(function(type$1) {
      if (!(type$1 instanceof type)) {
        throw new exception("Specified list of YAML types (or a single Type object) contains a non-Type object.");
      }
    });
    var result = Object.create(Schema$1.prototype);
    result.implicit = (this.implicit || []).concat(implicit2);
    result.explicit = (this.explicit || []).concat(explicit);
    result.compiledImplicit = compileList(result, "implicit");
    result.compiledExplicit = compileList(result, "explicit");
    result.compiledTypeMap = compileMap(result.compiledImplicit, result.compiledExplicit);
    return result;
  };
  var schema = Schema$1;
  var str = new type("tag:yaml.org,2002:str", {
    kind: "scalar",
    construct: function(data) {
      return data !== null ? data : "";
    }
  });
  var seq$1 = new type("tag:yaml.org,2002:seq", {
    kind: "sequence",
    construct: function(data) {
      return data !== null ? data : [];
    }
  });
  var map$1 = new type("tag:yaml.org,2002:map", {
    kind: "mapping",
    construct: function(data) {
      return data !== null ? data : {};
    }
  });
  var failsafe = new schema({
    explicit: [
      str,
      seq$1,
      map$1
    ]
  });
  function resolveYamlNull(data) {
    if (data === null)
      return true;
    var max2 = data.length;
    return max2 === 1 && data === "~" || max2 === 4 && (data === "null" || data === "Null" || data === "NULL");
  }
  function constructYamlNull() {
    return null;
  }
  function isNull(object2) {
    return object2 === null;
  }
  var _null = new type("tag:yaml.org,2002:null", {
    kind: "scalar",
    resolve: resolveYamlNull,
    construct: constructYamlNull,
    predicate: isNull,
    represent: {
      canonical: function() {
        return "~";
      },
      lowercase: function() {
        return "null";
      },
      uppercase: function() {
        return "NULL";
      },
      camelcase: function() {
        return "Null";
      },
      empty: function() {
        return "";
      }
    },
    defaultStyle: "lowercase"
  });
  function resolveYamlBoolean(data) {
    if (data === null)
      return false;
    var max2 = data.length;
    return max2 === 4 && (data === "true" || data === "True" || data === "TRUE") || max2 === 5 && (data === "false" || data === "False" || data === "FALSE");
  }
  function constructYamlBoolean(data) {
    return data === "true" || data === "True" || data === "TRUE";
  }
  function isBoolean(object2) {
    return Object.prototype.toString.call(object2) === "[object Boolean]";
  }
  var bool = new type("tag:yaml.org,2002:bool", {
    kind: "scalar",
    resolve: resolveYamlBoolean,
    construct: constructYamlBoolean,
    predicate: isBoolean,
    represent: {
      lowercase: function(object2) {
        return object2 ? "true" : "false";
      },
      uppercase: function(object2) {
        return object2 ? "TRUE" : "FALSE";
      },
      camelcase: function(object2) {
        return object2 ? "True" : "False";
      }
    },
    defaultStyle: "lowercase"
  });
  function isHexCode(c2) {
    return 48 <= c2 && c2 <= 57 || 65 <= c2 && c2 <= 70 || 97 <= c2 && c2 <= 102;
  }
  function isOctCode(c2) {
    return 48 <= c2 && c2 <= 55;
  }
  function isDecCode(c2) {
    return 48 <= c2 && c2 <= 57;
  }
  function resolveYamlInteger(data) {
    if (data === null)
      return false;
    var max2 = data.length, index2 = 0, hasDigits = false, ch;
    if (!max2)
      return false;
    ch = data[index2];
    if (ch === "-" || ch === "+") {
      ch = data[++index2];
    }
    if (ch === "0") {
      if (index2 + 1 === max2)
        return true;
      ch = data[++index2];
      if (ch === "b") {
        index2++;
        for (; index2 < max2; index2++) {
          ch = data[index2];
          if (ch === "_")
            continue;
          if (ch !== "0" && ch !== "1")
            return false;
          hasDigits = true;
        }
        return hasDigits && ch !== "_";
      }
      if (ch === "x") {
        index2++;
        for (; index2 < max2; index2++) {
          ch = data[index2];
          if (ch === "_")
            continue;
          if (!isHexCode(data.charCodeAt(index2)))
            return false;
          hasDigits = true;
        }
        return hasDigits && ch !== "_";
      }
      if (ch === "o") {
        index2++;
        for (; index2 < max2; index2++) {
          ch = data[index2];
          if (ch === "_")
            continue;
          if (!isOctCode(data.charCodeAt(index2)))
            return false;
          hasDigits = true;
        }
        return hasDigits && ch !== "_";
      }
    }
    if (ch === "_")
      return false;
    for (; index2 < max2; index2++) {
      ch = data[index2];
      if (ch === "_")
        continue;
      if (!isDecCode(data.charCodeAt(index2))) {
        return false;
      }
      hasDigits = true;
    }
    if (!hasDigits || ch === "_")
      return false;
    return true;
  }
  function constructYamlInteger(data) {
    var value2 = data, sign2 = 1, ch;
    if (value2.indexOf("_") !== -1) {
      value2 = value2.replace(/_/g, "");
    }
    ch = value2[0];
    if (ch === "-" || ch === "+") {
      if (ch === "-")
        sign2 = -1;
      value2 = value2.slice(1);
      ch = value2[0];
    }
    if (value2 === "0")
      return 0;
    if (ch === "0") {
      if (value2[1] === "b")
        return sign2 * parseInt(value2.slice(2), 2);
      if (value2[1] === "x")
        return sign2 * parseInt(value2.slice(2), 16);
      if (value2[1] === "o")
        return sign2 * parseInt(value2.slice(2), 8);
    }
    return sign2 * parseInt(value2, 10);
  }
  function isInteger(object2) {
    return Object.prototype.toString.call(object2) === "[object Number]" && (object2 % 1 === 0 && !common.isNegativeZero(object2));
  }
  var int = new type("tag:yaml.org,2002:int", {
    kind: "scalar",
    resolve: resolveYamlInteger,
    construct: constructYamlInteger,
    predicate: isInteger,
    represent: {
      binary: function(obj) {
        return obj >= 0 ? "0b" + obj.toString(2) : "-0b" + obj.toString(2).slice(1);
      },
      octal: function(obj) {
        return obj >= 0 ? "0o" + obj.toString(8) : "-0o" + obj.toString(8).slice(1);
      },
      decimal: function(obj) {
        return obj.toString(10);
      },
      /* eslint-disable max-len */
      hexadecimal: function(obj) {
        return obj >= 0 ? "0x" + obj.toString(16).toUpperCase() : "-0x" + obj.toString(16).toUpperCase().slice(1);
      }
    },
    defaultStyle: "decimal",
    styleAliases: {
      binary: [2, "bin"],
      octal: [8, "oct"],
      decimal: [10, "dec"],
      hexadecimal: [16, "hex"]
    }
  });
  var YAML_FLOAT_PATTERN = new RegExp(
    // 2.5e4, 2.5 and integers
    "^(?:[-+]?(?:[0-9][0-9_]*)(?:\\.[0-9_]*)?(?:[eE][-+]?[0-9]+)?|\\.[0-9_]+(?:[eE][-+]?[0-9]+)?|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$"
  );
  function resolveYamlFloat(data) {
    if (data === null)
      return false;
    if (!YAML_FLOAT_PATTERN.test(data) || // Quick hack to not allow integers end with `_`
    // Probably should update regexp & check speed
    data[data.length - 1] === "_") {
      return false;
    }
    return true;
  }
  function constructYamlFloat(data) {
    var value2, sign2;
    value2 = data.replace(/_/g, "").toLowerCase();
    sign2 = value2[0] === "-" ? -1 : 1;
    if ("+-".indexOf(value2[0]) >= 0) {
      value2 = value2.slice(1);
    }
    if (value2 === ".inf") {
      return sign2 === 1 ? Number.POSITIVE_INFINITY : Number.NEGATIVE_INFINITY;
    } else if (value2 === ".nan") {
      return NaN;
    }
    return sign2 * parseFloat(value2, 10);
  }
  var SCIENTIFIC_WITHOUT_DOT = /^[-+]?[0-9]+e/;
  function representYamlFloat(object2, style) {
    var res;
    if (isNaN(object2)) {
      switch (style) {
        case "lowercase":
          return ".nan";
        case "uppercase":
          return ".NAN";
        case "camelcase":
          return ".NaN";
      }
    } else if (Number.POSITIVE_INFINITY === object2) {
      switch (style) {
        case "lowercase":
          return ".inf";
        case "uppercase":
          return ".INF";
        case "camelcase":
          return ".Inf";
      }
    } else if (Number.NEGATIVE_INFINITY === object2) {
      switch (style) {
        case "lowercase":
          return "-.inf";
        case "uppercase":
          return "-.INF";
        case "camelcase":
          return "-.Inf";
      }
    } else if (common.isNegativeZero(object2)) {
      return "-0.0";
    }
    res = object2.toString(10);
    return SCIENTIFIC_WITHOUT_DOT.test(res) ? res.replace("e", ".e") : res;
  }
  function isFloat(object2) {
    return Object.prototype.toString.call(object2) === "[object Number]" && (object2 % 1 !== 0 || common.isNegativeZero(object2));
  }
  var float = new type("tag:yaml.org,2002:float", {
    kind: "scalar",
    resolve: resolveYamlFloat,
    construct: constructYamlFloat,
    predicate: isFloat,
    represent: representYamlFloat,
    defaultStyle: "lowercase"
  });
  var json = failsafe.extend({
    implicit: [
      _null,
      bool,
      int,
      float
    ]
  });
  var core = json;
  var YAML_DATE_REGEXP = new RegExp(
    "^([0-9][0-9][0-9][0-9])-([0-9][0-9])-([0-9][0-9])$"
  );
  var YAML_TIMESTAMP_REGEXP = new RegExp(
    "^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:[Tt]|[ \\t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \\t]*(Z|([-+])([0-9][0-9]?)(?::([0-9][0-9]))?))?$"
  );
  function resolveYamlTimestamp(data) {
    if (data === null)
      return false;
    if (YAML_DATE_REGEXP.exec(data) !== null)
      return true;
    if (YAML_TIMESTAMP_REGEXP.exec(data) !== null)
      return true;
    return false;
  }
  function constructYamlTimestamp(data) {
    var match, year, month, day, hour, minute, second2, fraction = 0, delta = null, tz_hour, tz_minute, date2;
    match = YAML_DATE_REGEXP.exec(data);
    if (match === null)
      match = YAML_TIMESTAMP_REGEXP.exec(data);
    if (match === null)
      throw new Error("Date resolve error");
    year = +match[1];
    month = +match[2] - 1;
    day = +match[3];
    if (!match[4]) {
      return new Date(Date.UTC(year, month, day));
    }
    hour = +match[4];
    minute = +match[5];
    second2 = +match[6];
    if (match[7]) {
      fraction = match[7].slice(0, 3);
      while (fraction.length < 3) {
        fraction += "0";
      }
      fraction = +fraction;
    }
    if (match[9]) {
      tz_hour = +match[10];
      tz_minute = +(match[11] || 0);
      delta = (tz_hour * 60 + tz_minute) * 6e4;
      if (match[9] === "-")
        delta = -delta;
    }
    date2 = new Date(Date.UTC(year, month, day, hour, minute, second2, fraction));
    if (delta)
      date2.setTime(date2.getTime() - delta);
    return date2;
  }
  function representYamlTimestamp(object2) {
    return object2.toISOString();
  }
  var timestamp = new type("tag:yaml.org,2002:timestamp", {
    kind: "scalar",
    resolve: resolveYamlTimestamp,
    construct: constructYamlTimestamp,
    instanceOf: Date,
    represent: representYamlTimestamp
  });
  function resolveYamlMerge(data) {
    return data === "<<" || data === null;
  }
  var merge$1 = new type("tag:yaml.org,2002:merge", {
    kind: "scalar",
    resolve: resolveYamlMerge
  });
  var BASE64_MAP = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=\n\r";
  function resolveYamlBinary(data) {
    if (data === null)
      return false;
    var code, idx, bitlen = 0, max2 = data.length, map2 = BASE64_MAP;
    for (idx = 0; idx < max2; idx++) {
      code = map2.indexOf(data.charAt(idx));
      if (code > 64)
        continue;
      if (code < 0)
        return false;
      bitlen += 6;
    }
    return bitlen % 8 === 0;
  }
  function constructYamlBinary(data) {
    var idx, tailbits, input = data.replace(/[\r\n=]/g, ""), max2 = input.length, map2 = BASE64_MAP, bits = 0, result = [];
    for (idx = 0; idx < max2; idx++) {
      if (idx % 4 === 0 && idx) {
        result.push(bits >> 16 & 255);
        result.push(bits >> 8 & 255);
        result.push(bits & 255);
      }
      bits = bits << 6 | map2.indexOf(input.charAt(idx));
    }
    tailbits = max2 % 4 * 6;
    if (tailbits === 0) {
      result.push(bits >> 16 & 255);
      result.push(bits >> 8 & 255);
      result.push(bits & 255);
    } else if (tailbits === 18) {
      result.push(bits >> 10 & 255);
      result.push(bits >> 2 & 255);
    } else if (tailbits === 12) {
      result.push(bits >> 4 & 255);
    }
    return new Uint8Array(result);
  }
  function representYamlBinary(object2) {
    var result = "", bits = 0, idx, tail, max2 = object2.length, map2 = BASE64_MAP;
    for (idx = 0; idx < max2; idx++) {
      if (idx % 3 === 0 && idx) {
        result += map2[bits >> 18 & 63];
        result += map2[bits >> 12 & 63];
        result += map2[bits >> 6 & 63];
        result += map2[bits & 63];
      }
      bits = (bits << 8) + object2[idx];
    }
    tail = max2 % 3;
    if (tail === 0) {
      result += map2[bits >> 18 & 63];
      result += map2[bits >> 12 & 63];
      result += map2[bits >> 6 & 63];
      result += map2[bits & 63];
    } else if (tail === 2) {
      result += map2[bits >> 10 & 63];
      result += map2[bits >> 4 & 63];
      result += map2[bits << 2 & 63];
      result += map2[64];
    } else if (tail === 1) {
      result += map2[bits >> 2 & 63];
      result += map2[bits << 4 & 63];
      result += map2[64];
      result += map2[64];
    }
    return result;
  }
  function isBinary(obj) {
    return Object.prototype.toString.call(obj) === "[object Uint8Array]";
  }
  var binary = new type("tag:yaml.org,2002:binary", {
    kind: "scalar",
    resolve: resolveYamlBinary,
    construct: constructYamlBinary,
    predicate: isBinary,
    represent: representYamlBinary
  });
  var _hasOwnProperty$3 = Object.prototype.hasOwnProperty;
  var _toString$2 = Object.prototype.toString;
  function resolveYamlOmap(data) {
    if (data === null)
      return true;
    var objectKeys = [], index2, length2, pair, pairKey, pairHasKey, object2 = data;
    for (index2 = 0, length2 = object2.length; index2 < length2; index2 += 1) {
      pair = object2[index2];
      pairHasKey = false;
      if (_toString$2.call(pair) !== "[object Object]")
        return false;
      for (pairKey in pair) {
        if (_hasOwnProperty$3.call(pair, pairKey)) {
          if (!pairHasKey)
            pairHasKey = true;
          else
            return false;
        }
      }
      if (!pairHasKey)
        return false;
      if (objectKeys.indexOf(pairKey) === -1)
        objectKeys.push(pairKey);
      else
        return false;
    }
    return true;
  }
  function constructYamlOmap(data) {
    return data !== null ? data : [];
  }
  var omap = new type("tag:yaml.org,2002:omap", {
    kind: "sequence",
    resolve: resolveYamlOmap,
    construct: constructYamlOmap
  });
  var _toString$1 = Object.prototype.toString;
  function resolveYamlPairs(data) {
    if (data === null)
      return true;
    var index2, length2, pair, keys2, result, object2 = data;
    result = new Array(object2.length);
    for (index2 = 0, length2 = object2.length; index2 < length2; index2 += 1) {
      pair = object2[index2];
      if (_toString$1.call(pair) !== "[object Object]")
        return false;
      keys2 = Object.keys(pair);
      if (keys2.length !== 1)
        return false;
      result[index2] = [keys2[0], pair[keys2[0]]];
    }
    return true;
  }
  function constructYamlPairs(data) {
    if (data === null)
      return [];
    var index2, length2, pair, keys2, result, object2 = data;
    result = new Array(object2.length);
    for (index2 = 0, length2 = object2.length; index2 < length2; index2 += 1) {
      pair = object2[index2];
      keys2 = Object.keys(pair);
      result[index2] = [keys2[0], pair[keys2[0]]];
    }
    return result;
  }
  var pairs = new type("tag:yaml.org,2002:pairs", {
    kind: "sequence",
    resolve: resolveYamlPairs,
    construct: constructYamlPairs
  });
  var _hasOwnProperty$2 = Object.prototype.hasOwnProperty;
  function resolveYamlSet(data) {
    if (data === null)
      return true;
    var key, object2 = data;
    for (key in object2) {
      if (_hasOwnProperty$2.call(object2, key)) {
        if (object2[key] !== null)
          return false;
      }
    }
    return true;
  }
  function constructYamlSet(data) {
    return data !== null ? data : {};
  }
  var set$1 = new type("tag:yaml.org,2002:set", {
    kind: "mapping",
    resolve: resolveYamlSet,
    construct: constructYamlSet
  });
  var _default = core.extend({
    implicit: [
      timestamp,
      merge$1
    ],
    explicit: [
      binary,
      omap,
      pairs,
      set$1
    ]
  });
  var _hasOwnProperty$1 = Object.prototype.hasOwnProperty;
  var CONTEXT_FLOW_IN = 1;
  var CONTEXT_FLOW_OUT = 2;
  var CONTEXT_BLOCK_IN = 3;
  var CONTEXT_BLOCK_OUT = 4;
  var CHOMPING_CLIP = 1;
  var CHOMPING_STRIP = 2;
  var CHOMPING_KEEP = 3;
  var PATTERN_NON_PRINTABLE = /[\x00-\x08\x0B\x0C\x0E-\x1F\x7F-\x84\x86-\x9F\uFFFE\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]/;
  var PATTERN_NON_ASCII_LINE_BREAKS = /[\x85\u2028\u2029]/;
  var PATTERN_FLOW_INDICATORS = /[,\[\]\{\}]/;
  var PATTERN_TAG_HANDLE = /^(?:!|!!|![a-z\-]+!)$/i;
  var PATTERN_TAG_URI = /^(?:!|[^,\[\]\{\}])(?:%[0-9a-f]{2}|[0-9a-z\-#;\/\?:@&=\+\$,_\.!~\*'\(\)\[\]])*$/i;
  function _class(obj) {
    return Object.prototype.toString.call(obj);
  }
  function is_EOL(c2) {
    return c2 === 10 || c2 === 13;
  }
  function is_WHITE_SPACE(c2) {
    return c2 === 9 || c2 === 32;
  }
  function is_WS_OR_EOL(c2) {
    return c2 === 9 || c2 === 32 || c2 === 10 || c2 === 13;
  }
  function is_FLOW_INDICATOR(c2) {
    return c2 === 44 || c2 === 91 || c2 === 93 || c2 === 123 || c2 === 125;
  }
  function fromHexCode(c2) {
    var lc;
    if (48 <= c2 && c2 <= 57) {
      return c2 - 48;
    }
    lc = c2 | 32;
    if (97 <= lc && lc <= 102) {
      return lc - 97 + 10;
    }
    return -1;
  }
  function escapedHexLen(c2) {
    if (c2 === 120) {
      return 2;
    }
    if (c2 === 117) {
      return 4;
    }
    if (c2 === 85) {
      return 8;
    }
    return 0;
  }
  function fromDecimalCode(c2) {
    if (48 <= c2 && c2 <= 57) {
      return c2 - 48;
    }
    return -1;
  }
  function simpleEscapeSequence(c2) {
    return c2 === 48 ? "\0" : c2 === 97 ? "\x07" : c2 === 98 ? "\b" : c2 === 116 ? "	" : c2 === 9 ? "	" : c2 === 110 ? "\n" : c2 === 118 ? "\v" : c2 === 102 ? "\f" : c2 === 114 ? "\r" : c2 === 101 ? "\x1B" : c2 === 32 ? " " : c2 === 34 ? '"' : c2 === 47 ? "/" : c2 === 92 ? "\\" : c2 === 78 ? "" : c2 === 95 ? " " : c2 === 76 ? "\u2028" : c2 === 80 ? "\u2029" : "";
  }
  function charFromCodepoint(c2) {
    if (c2 <= 65535) {
      return String.fromCharCode(c2);
    }
    return String.fromCharCode(
      (c2 - 65536 >> 10) + 55296,
      (c2 - 65536 & 1023) + 56320
    );
  }
  var simpleEscapeCheck = new Array(256);
  var simpleEscapeMap = new Array(256);
  for (var i = 0; i < 256; i++) {
    simpleEscapeCheck[i] = simpleEscapeSequence(i) ? 1 : 0;
    simpleEscapeMap[i] = simpleEscapeSequence(i);
  }
  function State$1(input, options2) {
    this.input = input;
    this.filename = options2["filename"] || null;
    this.schema = options2["schema"] || _default;
    this.onWarning = options2["onWarning"] || null;
    this.legacy = options2["legacy"] || false;
    this.json = options2["json"] || false;
    this.listener = options2["listener"] || null;
    this.implicitTypes = this.schema.compiledImplicit;
    this.typeMap = this.schema.compiledTypeMap;
    this.length = input.length;
    this.position = 0;
    this.line = 0;
    this.lineStart = 0;
    this.lineIndent = 0;
    this.firstTabInLine = -1;
    this.documents = [];
  }
  function generateError(state2, message) {
    var mark = {
      name: state2.filename,
      buffer: state2.input.slice(0, -1),
      // omit trailing \0
      position: state2.position,
      line: state2.line,
      column: state2.position - state2.lineStart
    };
    mark.snippet = snippet(mark);
    return new exception(message, mark);
  }
  function throwError(state2, message) {
    throw generateError(state2, message);
  }
  function throwWarning(state2, message) {
    if (state2.onWarning) {
      state2.onWarning.call(null, generateError(state2, message));
    }
  }
  var directiveHandlers = {
    YAML: function handleYamlDirective(state2, name, args) {
      var match, major, minor;
      if (state2.version !== null) {
        throwError(state2, "duplication of %YAML directive");
      }
      if (args.length !== 1) {
        throwError(state2, "YAML directive accepts exactly one argument");
      }
      match = /^([0-9]+)\.([0-9]+)$/.exec(args[0]);
      if (match === null) {
        throwError(state2, "ill-formed argument of the YAML directive");
      }
      major = parseInt(match[1], 10);
      minor = parseInt(match[2], 10);
      if (major !== 1) {
        throwError(state2, "unacceptable YAML version of the document");
      }
      state2.version = args[0];
      state2.checkLineBreaks = minor < 2;
      if (minor !== 1 && minor !== 2) {
        throwWarning(state2, "unsupported YAML version of the document");
      }
    },
    TAG: function handleTagDirective(state2, name, args) {
      var handle, prefix;
      if (args.length !== 2) {
        throwError(state2, "TAG directive accepts exactly two arguments");
      }
      handle = args[0];
      prefix = args[1];
      if (!PATTERN_TAG_HANDLE.test(handle)) {
        throwError(state2, "ill-formed tag handle (first argument) of the TAG directive");
      }
      if (_hasOwnProperty$1.call(state2.tagMap, handle)) {
        throwError(state2, 'there is a previously declared suffix for "' + handle + '" tag handle');
      }
      if (!PATTERN_TAG_URI.test(prefix)) {
        throwError(state2, "ill-formed tag prefix (second argument) of the TAG directive");
      }
      try {
        prefix = decodeURIComponent(prefix);
      } catch (err) {
        throwError(state2, "tag prefix is malformed: " + prefix);
      }
      state2.tagMap[handle] = prefix;
    }
  };
  function captureSegment(state2, start2, end2, checkJson) {
    var _position, _length, _character, _result;
    if (start2 < end2) {
      _result = state2.input.slice(start2, end2);
      if (checkJson) {
        for (_position = 0, _length = _result.length; _position < _length; _position += 1) {
          _character = _result.charCodeAt(_position);
          if (!(_character === 9 || 32 <= _character && _character <= 1114111)) {
            throwError(state2, "expected valid JSON character");
          }
        }
      } else if (PATTERN_NON_PRINTABLE.test(_result)) {
        throwError(state2, "the stream contains non-printable characters");
      }
      state2.result += _result;
    }
  }
  function mergeMappings(state2, destination, source, overridableKeys) {
    var sourceKeys, key, index2, quantity;
    if (!common.isObject(source)) {
      throwError(state2, "cannot merge mappings; the provided source object is unacceptable");
    }
    sourceKeys = Object.keys(source);
    for (index2 = 0, quantity = sourceKeys.length; index2 < quantity; index2 += 1) {
      key = sourceKeys[index2];
      if (!_hasOwnProperty$1.call(destination, key)) {
        destination[key] = source[key];
        overridableKeys[key] = true;
      }
    }
  }
  function storeMappingPair(state2, _result, overridableKeys, keyTag, keyNode, valueNode, startLine, startLineStart, startPos) {
    var index2, quantity;
    if (Array.isArray(keyNode)) {
      keyNode = Array.prototype.slice.call(keyNode);
      for (index2 = 0, quantity = keyNode.length; index2 < quantity; index2 += 1) {
        if (Array.isArray(keyNode[index2])) {
          throwError(state2, "nested arrays are not supported inside keys");
        }
        if (typeof keyNode === "object" && _class(keyNode[index2]) === "[object Object]") {
          keyNode[index2] = "[object Object]";
        }
      }
    }
    if (typeof keyNode === "object" && _class(keyNode) === "[object Object]") {
      keyNode = "[object Object]";
    }
    keyNode = String(keyNode);
    if (_result === null) {
      _result = {};
    }
    if (keyTag === "tag:yaml.org,2002:merge") {
      if (Array.isArray(valueNode)) {
        for (index2 = 0, quantity = valueNode.length; index2 < quantity; index2 += 1) {
          mergeMappings(state2, _result, valueNode[index2], overridableKeys);
        }
      } else {
        mergeMappings(state2, _result, valueNode, overridableKeys);
      }
    } else {
      if (!state2.json && !_hasOwnProperty$1.call(overridableKeys, keyNode) && _hasOwnProperty$1.call(_result, keyNode)) {
        state2.line = startLine || state2.line;
        state2.lineStart = startLineStart || state2.lineStart;
        state2.position = startPos || state2.position;
        throwError(state2, "duplicated mapping key");
      }
      if (keyNode === "__proto__") {
        Object.defineProperty(_result, keyNode, {
          configurable: true,
          enumerable: true,
          writable: true,
          value: valueNode
        });
      } else {
        _result[keyNode] = valueNode;
      }
      delete overridableKeys[keyNode];
    }
    return _result;
  }
  function readLineBreak(state2) {
    var ch;
    ch = state2.input.charCodeAt(state2.position);
    if (ch === 10) {
      state2.position++;
    } else if (ch === 13) {
      state2.position++;
      if (state2.input.charCodeAt(state2.position) === 10) {
        state2.position++;
      }
    } else {
      throwError(state2, "a line break is expected");
    }
    state2.line += 1;
    state2.lineStart = state2.position;
    state2.firstTabInLine = -1;
  }
  function skipSeparationSpace(state2, allowComments, checkIndent) {
    var lineBreaks = 0, ch = state2.input.charCodeAt(state2.position);
    while (ch !== 0) {
      while (is_WHITE_SPACE(ch)) {
        if (ch === 9 && state2.firstTabInLine === -1) {
          state2.firstTabInLine = state2.position;
        }
        ch = state2.input.charCodeAt(++state2.position);
      }
      if (allowComments && ch === 35) {
        do {
          ch = state2.input.charCodeAt(++state2.position);
        } while (ch !== 10 && ch !== 13 && ch !== 0);
      }
      if (is_EOL(ch)) {
        readLineBreak(state2);
        ch = state2.input.charCodeAt(state2.position);
        lineBreaks++;
        state2.lineIndent = 0;
        while (ch === 32) {
          state2.lineIndent++;
          ch = state2.input.charCodeAt(++state2.position);
        }
      } else {
        break;
      }
    }
    if (checkIndent !== -1 && lineBreaks !== 0 && state2.lineIndent < checkIndent) {
      throwWarning(state2, "deficient indentation");
    }
    return lineBreaks;
  }
  function testDocumentSeparator(state2) {
    var _position = state2.position, ch;
    ch = state2.input.charCodeAt(_position);
    if ((ch === 45 || ch === 46) && ch === state2.input.charCodeAt(_position + 1) && ch === state2.input.charCodeAt(_position + 2)) {
      _position += 3;
      ch = state2.input.charCodeAt(_position);
      if (ch === 0 || is_WS_OR_EOL(ch)) {
        return true;
      }
    }
    return false;
  }
  function writeFoldedLines(state2, count) {
    if (count === 1) {
      state2.result += " ";
    } else if (count > 1) {
      state2.result += common.repeat("\n", count - 1);
    }
  }
  function readPlainScalar(state2, nodeIndent, withinFlowCollection) {
    var preceding, following, captureStart, captureEnd, hasPendingContent, _line, _lineStart, _lineIndent, _kind = state2.kind, _result = state2.result, ch;
    ch = state2.input.charCodeAt(state2.position);
    if (is_WS_OR_EOL(ch) || is_FLOW_INDICATOR(ch) || ch === 35 || ch === 38 || ch === 42 || ch === 33 || ch === 124 || ch === 62 || ch === 39 || ch === 34 || ch === 37 || ch === 64 || ch === 96) {
      return false;
    }
    if (ch === 63 || ch === 45) {
      following = state2.input.charCodeAt(state2.position + 1);
      if (is_WS_OR_EOL(following) || withinFlowCollection && is_FLOW_INDICATOR(following)) {
        return false;
      }
    }
    state2.kind = "scalar";
    state2.result = "";
    captureStart = captureEnd = state2.position;
    hasPendingContent = false;
    while (ch !== 0) {
      if (ch === 58) {
        following = state2.input.charCodeAt(state2.position + 1);
        if (is_WS_OR_EOL(following) || withinFlowCollection && is_FLOW_INDICATOR(following)) {
          break;
        }
      } else if (ch === 35) {
        preceding = state2.input.charCodeAt(state2.position - 1);
        if (is_WS_OR_EOL(preceding)) {
          break;
        }
      } else if (state2.position === state2.lineStart && testDocumentSeparator(state2) || withinFlowCollection && is_FLOW_INDICATOR(ch)) {
        break;
      } else if (is_EOL(ch)) {
        _line = state2.line;
        _lineStart = state2.lineStart;
        _lineIndent = state2.lineIndent;
        skipSeparationSpace(state2, false, -1);
        if (state2.lineIndent >= nodeIndent) {
          hasPendingContent = true;
          ch = state2.input.charCodeAt(state2.position);
          continue;
        } else {
          state2.position = captureEnd;
          state2.line = _line;
          state2.lineStart = _lineStart;
          state2.lineIndent = _lineIndent;
          break;
        }
      }
      if (hasPendingContent) {
        captureSegment(state2, captureStart, captureEnd, false);
        writeFoldedLines(state2, state2.line - _line);
        captureStart = captureEnd = state2.position;
        hasPendingContent = false;
      }
      if (!is_WHITE_SPACE(ch)) {
        captureEnd = state2.position + 1;
      }
      ch = state2.input.charCodeAt(++state2.position);
    }
    captureSegment(state2, captureStart, captureEnd, false);
    if (state2.result) {
      return true;
    }
    state2.kind = _kind;
    state2.result = _result;
    return false;
  }
  function readSingleQuotedScalar(state2, nodeIndent) {
    var ch, captureStart, captureEnd;
    ch = state2.input.charCodeAt(state2.position);
    if (ch !== 39) {
      return false;
    }
    state2.kind = "scalar";
    state2.result = "";
    state2.position++;
    captureStart = captureEnd = state2.position;
    while ((ch = state2.input.charCodeAt(state2.position)) !== 0) {
      if (ch === 39) {
        captureSegment(state2, captureStart, state2.position, true);
        ch = state2.input.charCodeAt(++state2.position);
        if (ch === 39) {
          captureStart = state2.position;
          state2.position++;
          captureEnd = state2.position;
        } else {
          return true;
        }
      } else if (is_EOL(ch)) {
        captureSegment(state2, captureStart, captureEnd, true);
        writeFoldedLines(state2, skipSeparationSpace(state2, false, nodeIndent));
        captureStart = captureEnd = state2.position;
      } else if (state2.position === state2.lineStart && testDocumentSeparator(state2)) {
        throwError(state2, "unexpected end of the document within a single quoted scalar");
      } else {
        state2.position++;
        captureEnd = state2.position;
      }
    }
    throwError(state2, "unexpected end of the stream within a single quoted scalar");
  }
  function readDoubleQuotedScalar(state2, nodeIndent) {
    var captureStart, captureEnd, hexLength, hexResult, tmp, ch;
    ch = state2.input.charCodeAt(state2.position);
    if (ch !== 34) {
      return false;
    }
    state2.kind = "scalar";
    state2.result = "";
    state2.position++;
    captureStart = captureEnd = state2.position;
    while ((ch = state2.input.charCodeAt(state2.position)) !== 0) {
      if (ch === 34) {
        captureSegment(state2, captureStart, state2.position, true);
        state2.position++;
        return true;
      } else if (ch === 92) {
        captureSegment(state2, captureStart, state2.position, true);
        ch = state2.input.charCodeAt(++state2.position);
        if (is_EOL(ch)) {
          skipSeparationSpace(state2, false, nodeIndent);
        } else if (ch < 256 && simpleEscapeCheck[ch]) {
          state2.result += simpleEscapeMap[ch];
          state2.position++;
        } else if ((tmp = escapedHexLen(ch)) > 0) {
          hexLength = tmp;
          hexResult = 0;
          for (; hexLength > 0; hexLength--) {
            ch = state2.input.charCodeAt(++state2.position);
            if ((tmp = fromHexCode(ch)) >= 0) {
              hexResult = (hexResult << 4) + tmp;
            } else {
              throwError(state2, "expected hexadecimal character");
            }
          }
          state2.result += charFromCodepoint(hexResult);
          state2.position++;
        } else {
          throwError(state2, "unknown escape sequence");
        }
        captureStart = captureEnd = state2.position;
      } else if (is_EOL(ch)) {
        captureSegment(state2, captureStart, captureEnd, true);
        writeFoldedLines(state2, skipSeparationSpace(state2, false, nodeIndent));
        captureStart = captureEnd = state2.position;
      } else if (state2.position === state2.lineStart && testDocumentSeparator(state2)) {
        throwError(state2, "unexpected end of the document within a double quoted scalar");
      } else {
        state2.position++;
        captureEnd = state2.position;
      }
    }
    throwError(state2, "unexpected end of the stream within a double quoted scalar");
  }
  function readFlowCollection(state2, nodeIndent) {
    var readNext = true, _line, _lineStart, _pos, _tag = state2.tag, _result, _anchor = state2.anchor, following, terminator, isPair, isExplicitPair, isMapping, overridableKeys = /* @__PURE__ */ Object.create(null), keyNode, keyTag, valueNode, ch;
    ch = state2.input.charCodeAt(state2.position);
    if (ch === 91) {
      terminator = 93;
      isMapping = false;
      _result = [];
    } else if (ch === 123) {
      terminator = 125;
      isMapping = true;
      _result = {};
    } else {
      return false;
    }
    if (state2.anchor !== null) {
      state2.anchorMap[state2.anchor] = _result;
    }
    ch = state2.input.charCodeAt(++state2.position);
    while (ch !== 0) {
      skipSeparationSpace(state2, true, nodeIndent);
      ch = state2.input.charCodeAt(state2.position);
      if (ch === terminator) {
        state2.position++;
        state2.tag = _tag;
        state2.anchor = _anchor;
        state2.kind = isMapping ? "mapping" : "sequence";
        state2.result = _result;
        return true;
      } else if (!readNext) {
        throwError(state2, "missed comma between flow collection entries");
      } else if (ch === 44) {
        throwError(state2, "expected the node content, but found ','");
      }
      keyTag = keyNode = valueNode = null;
      isPair = isExplicitPair = false;
      if (ch === 63) {
        following = state2.input.charCodeAt(state2.position + 1);
        if (is_WS_OR_EOL(following)) {
          isPair = isExplicitPair = true;
          state2.position++;
          skipSeparationSpace(state2, true, nodeIndent);
        }
      }
      _line = state2.line;
      _lineStart = state2.lineStart;
      _pos = state2.position;
      composeNode(state2, nodeIndent, CONTEXT_FLOW_IN, false, true);
      keyTag = state2.tag;
      keyNode = state2.result;
      skipSeparationSpace(state2, true, nodeIndent);
      ch = state2.input.charCodeAt(state2.position);
      if ((isExplicitPair || state2.line === _line) && ch === 58) {
        isPair = true;
        ch = state2.input.charCodeAt(++state2.position);
        skipSeparationSpace(state2, true, nodeIndent);
        composeNode(state2, nodeIndent, CONTEXT_FLOW_IN, false, true);
        valueNode = state2.result;
      }
      if (isMapping) {
        storeMappingPair(state2, _result, overridableKeys, keyTag, keyNode, valueNode, _line, _lineStart, _pos);
      } else if (isPair) {
        _result.push(storeMappingPair(state2, null, overridableKeys, keyTag, keyNode, valueNode, _line, _lineStart, _pos));
      } else {
        _result.push(keyNode);
      }
      skipSeparationSpace(state2, true, nodeIndent);
      ch = state2.input.charCodeAt(state2.position);
      if (ch === 44) {
        readNext = true;
        ch = state2.input.charCodeAt(++state2.position);
      } else {
        readNext = false;
      }
    }
    throwError(state2, "unexpected end of the stream within a flow collection");
  }
  function readBlockScalar(state2, nodeIndent) {
    var captureStart, folding, chomping = CHOMPING_CLIP, didReadContent = false, detectedIndent = false, textIndent = nodeIndent, emptyLines = 0, atMoreIndented = false, tmp, ch;
    ch = state2.input.charCodeAt(state2.position);
    if (ch === 124) {
      folding = false;
    } else if (ch === 62) {
      folding = true;
    } else {
      return false;
    }
    state2.kind = "scalar";
    state2.result = "";
    while (ch !== 0) {
      ch = state2.input.charCodeAt(++state2.position);
      if (ch === 43 || ch === 45) {
        if (CHOMPING_CLIP === chomping) {
          chomping = ch === 43 ? CHOMPING_KEEP : CHOMPING_STRIP;
        } else {
          throwError(state2, "repeat of a chomping mode identifier");
        }
      } else if ((tmp = fromDecimalCode(ch)) >= 0) {
        if (tmp === 0) {
          throwError(state2, "bad explicit indentation width of a block scalar; it cannot be less than one");
        } else if (!detectedIndent) {
          textIndent = nodeIndent + tmp - 1;
          detectedIndent = true;
        } else {
          throwError(state2, "repeat of an indentation width identifier");
        }
      } else {
        break;
      }
    }
    if (is_WHITE_SPACE(ch)) {
      do {
        ch = state2.input.charCodeAt(++state2.position);
      } while (is_WHITE_SPACE(ch));
      if (ch === 35) {
        do {
          ch = state2.input.charCodeAt(++state2.position);
        } while (!is_EOL(ch) && ch !== 0);
      }
    }
    while (ch !== 0) {
      readLineBreak(state2);
      state2.lineIndent = 0;
      ch = state2.input.charCodeAt(state2.position);
      while ((!detectedIndent || state2.lineIndent < textIndent) && ch === 32) {
        state2.lineIndent++;
        ch = state2.input.charCodeAt(++state2.position);
      }
      if (!detectedIndent && state2.lineIndent > textIndent) {
        textIndent = state2.lineIndent;
      }
      if (is_EOL(ch)) {
        emptyLines++;
        continue;
      }
      if (state2.lineIndent < textIndent) {
        if (chomping === CHOMPING_KEEP) {
          state2.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
        } else if (chomping === CHOMPING_CLIP) {
          if (didReadContent) {
            state2.result += "\n";
          }
        }
        break;
      }
      if (folding) {
        if (is_WHITE_SPACE(ch)) {
          atMoreIndented = true;
          state2.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
        } else if (atMoreIndented) {
          atMoreIndented = false;
          state2.result += common.repeat("\n", emptyLines + 1);
        } else if (emptyLines === 0) {
          if (didReadContent) {
            state2.result += " ";
          }
        } else {
          state2.result += common.repeat("\n", emptyLines);
        }
      } else {
        state2.result += common.repeat("\n", didReadContent ? 1 + emptyLines : emptyLines);
      }
      didReadContent = true;
      detectedIndent = true;
      emptyLines = 0;
      captureStart = state2.position;
      while (!is_EOL(ch) && ch !== 0) {
        ch = state2.input.charCodeAt(++state2.position);
      }
      captureSegment(state2, captureStart, state2.position, false);
    }
    return true;
  }
  function readBlockSequence(state2, nodeIndent) {
    var _line, _tag = state2.tag, _anchor = state2.anchor, _result = [], following, detected = false, ch;
    if (state2.firstTabInLine !== -1)
      return false;
    if (state2.anchor !== null) {
      state2.anchorMap[state2.anchor] = _result;
    }
    ch = state2.input.charCodeAt(state2.position);
    while (ch !== 0) {
      if (state2.firstTabInLine !== -1) {
        state2.position = state2.firstTabInLine;
        throwError(state2, "tab characters must not be used in indentation");
      }
      if (ch !== 45) {
        break;
      }
      following = state2.input.charCodeAt(state2.position + 1);
      if (!is_WS_OR_EOL(following)) {
        break;
      }
      detected = true;
      state2.position++;
      if (skipSeparationSpace(state2, true, -1)) {
        if (state2.lineIndent <= nodeIndent) {
          _result.push(null);
          ch = state2.input.charCodeAt(state2.position);
          continue;
        }
      }
      _line = state2.line;
      composeNode(state2, nodeIndent, CONTEXT_BLOCK_IN, false, true);
      _result.push(state2.result);
      skipSeparationSpace(state2, true, -1);
      ch = state2.input.charCodeAt(state2.position);
      if ((state2.line === _line || state2.lineIndent > nodeIndent) && ch !== 0) {
        throwError(state2, "bad indentation of a sequence entry");
      } else if (state2.lineIndent < nodeIndent) {
        break;
      }
    }
    if (detected) {
      state2.tag = _tag;
      state2.anchor = _anchor;
      state2.kind = "sequence";
      state2.result = _result;
      return true;
    }
    return false;
  }
  function readBlockMapping(state2, nodeIndent, flowIndent) {
    var following, allowCompact, _line, _keyLine, _keyLineStart, _keyPos, _tag = state2.tag, _anchor = state2.anchor, _result = {}, overridableKeys = /* @__PURE__ */ Object.create(null), keyTag = null, keyNode = null, valueNode = null, atExplicitKey = false, detected = false, ch;
    if (state2.firstTabInLine !== -1)
      return false;
    if (state2.anchor !== null) {
      state2.anchorMap[state2.anchor] = _result;
    }
    ch = state2.input.charCodeAt(state2.position);
    while (ch !== 0) {
      if (!atExplicitKey && state2.firstTabInLine !== -1) {
        state2.position = state2.firstTabInLine;
        throwError(state2, "tab characters must not be used in indentation");
      }
      following = state2.input.charCodeAt(state2.position + 1);
      _line = state2.line;
      if ((ch === 63 || ch === 58) && is_WS_OR_EOL(following)) {
        if (ch === 63) {
          if (atExplicitKey) {
            storeMappingPair(state2, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
            keyTag = keyNode = valueNode = null;
          }
          detected = true;
          atExplicitKey = true;
          allowCompact = true;
        } else if (atExplicitKey) {
          atExplicitKey = false;
          allowCompact = true;
        } else {
          throwError(state2, "incomplete explicit mapping pair; a key node is missed; or followed by a non-tabulated empty line");
        }
        state2.position += 1;
        ch = following;
      } else {
        _keyLine = state2.line;
        _keyLineStart = state2.lineStart;
        _keyPos = state2.position;
        if (!composeNode(state2, flowIndent, CONTEXT_FLOW_OUT, false, true)) {
          break;
        }
        if (state2.line === _line) {
          ch = state2.input.charCodeAt(state2.position);
          while (is_WHITE_SPACE(ch)) {
            ch = state2.input.charCodeAt(++state2.position);
          }
          if (ch === 58) {
            ch = state2.input.charCodeAt(++state2.position);
            if (!is_WS_OR_EOL(ch)) {
              throwError(state2, "a whitespace character is expected after the key-value separator within a block mapping");
            }
            if (atExplicitKey) {
              storeMappingPair(state2, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
              keyTag = keyNode = valueNode = null;
            }
            detected = true;
            atExplicitKey = false;
            allowCompact = false;
            keyTag = state2.tag;
            keyNode = state2.result;
          } else if (detected) {
            throwError(state2, "can not read an implicit mapping pair; a colon is missed");
          } else {
            state2.tag = _tag;
            state2.anchor = _anchor;
            return true;
          }
        } else if (detected) {
          throwError(state2, "can not read a block mapping entry; a multiline key may not be an implicit key");
        } else {
          state2.tag = _tag;
          state2.anchor = _anchor;
          return true;
        }
      }
      if (state2.line === _line || state2.lineIndent > nodeIndent) {
        if (atExplicitKey) {
          _keyLine = state2.line;
          _keyLineStart = state2.lineStart;
          _keyPos = state2.position;
        }
        if (composeNode(state2, nodeIndent, CONTEXT_BLOCK_OUT, true, allowCompact)) {
          if (atExplicitKey) {
            keyNode = state2.result;
          } else {
            valueNode = state2.result;
          }
        }
        if (!atExplicitKey) {
          storeMappingPair(state2, _result, overridableKeys, keyTag, keyNode, valueNode, _keyLine, _keyLineStart, _keyPos);
          keyTag = keyNode = valueNode = null;
        }
        skipSeparationSpace(state2, true, -1);
        ch = state2.input.charCodeAt(state2.position);
      }
      if ((state2.line === _line || state2.lineIndent > nodeIndent) && ch !== 0) {
        throwError(state2, "bad indentation of a mapping entry");
      } else if (state2.lineIndent < nodeIndent) {
        break;
      }
    }
    if (atExplicitKey) {
      storeMappingPair(state2, _result, overridableKeys, keyTag, keyNode, null, _keyLine, _keyLineStart, _keyPos);
    }
    if (detected) {
      state2.tag = _tag;
      state2.anchor = _anchor;
      state2.kind = "mapping";
      state2.result = _result;
    }
    return detected;
  }
  function readTagProperty(state2) {
    var _position, isVerbatim = false, isNamed = false, tagHandle, tagName, ch;
    ch = state2.input.charCodeAt(state2.position);
    if (ch !== 33)
      return false;
    if (state2.tag !== null) {
      throwError(state2, "duplication of a tag property");
    }
    ch = state2.input.charCodeAt(++state2.position);
    if (ch === 60) {
      isVerbatim = true;
      ch = state2.input.charCodeAt(++state2.position);
    } else if (ch === 33) {
      isNamed = true;
      tagHandle = "!!";
      ch = state2.input.charCodeAt(++state2.position);
    } else {
      tagHandle = "!";
    }
    _position = state2.position;
    if (isVerbatim) {
      do {
        ch = state2.input.charCodeAt(++state2.position);
      } while (ch !== 0 && ch !== 62);
      if (state2.position < state2.length) {
        tagName = state2.input.slice(_position, state2.position);
        ch = state2.input.charCodeAt(++state2.position);
      } else {
        throwError(state2, "unexpected end of the stream within a verbatim tag");
      }
    } else {
      while (ch !== 0 && !is_WS_OR_EOL(ch)) {
        if (ch === 33) {
          if (!isNamed) {
            tagHandle = state2.input.slice(_position - 1, state2.position + 1);
            if (!PATTERN_TAG_HANDLE.test(tagHandle)) {
              throwError(state2, "named tag handle cannot contain such characters");
            }
            isNamed = true;
            _position = state2.position + 1;
          } else {
            throwError(state2, "tag suffix cannot contain exclamation marks");
          }
        }
        ch = state2.input.charCodeAt(++state2.position);
      }
      tagName = state2.input.slice(_position, state2.position);
      if (PATTERN_FLOW_INDICATORS.test(tagName)) {
        throwError(state2, "tag suffix cannot contain flow indicator characters");
      }
    }
    if (tagName && !PATTERN_TAG_URI.test(tagName)) {
      throwError(state2, "tag name cannot contain such characters: " + tagName);
    }
    try {
      tagName = decodeURIComponent(tagName);
    } catch (err) {
      throwError(state2, "tag name is malformed: " + tagName);
    }
    if (isVerbatim) {
      state2.tag = tagName;
    } else if (_hasOwnProperty$1.call(state2.tagMap, tagHandle)) {
      state2.tag = state2.tagMap[tagHandle] + tagName;
    } else if (tagHandle === "!") {
      state2.tag = "!" + tagName;
    } else if (tagHandle === "!!") {
      state2.tag = "tag:yaml.org,2002:" + tagName;
    } else {
      throwError(state2, 'undeclared tag handle "' + tagHandle + '"');
    }
    return true;
  }
  function readAnchorProperty(state2) {
    var _position, ch;
    ch = state2.input.charCodeAt(state2.position);
    if (ch !== 38)
      return false;
    if (state2.anchor !== null) {
      throwError(state2, "duplication of an anchor property");
    }
    ch = state2.input.charCodeAt(++state2.position);
    _position = state2.position;
    while (ch !== 0 && !is_WS_OR_EOL(ch) && !is_FLOW_INDICATOR(ch)) {
      ch = state2.input.charCodeAt(++state2.position);
    }
    if (state2.position === _position) {
      throwError(state2, "name of an anchor node must contain at least one character");
    }
    state2.anchor = state2.input.slice(_position, state2.position);
    return true;
  }
  function readAlias(state2) {
    var _position, alias, ch;
    ch = state2.input.charCodeAt(state2.position);
    if (ch !== 42)
      return false;
    ch = state2.input.charCodeAt(++state2.position);
    _position = state2.position;
    while (ch !== 0 && !is_WS_OR_EOL(ch) && !is_FLOW_INDICATOR(ch)) {
      ch = state2.input.charCodeAt(++state2.position);
    }
    if (state2.position === _position) {
      throwError(state2, "name of an alias node must contain at least one character");
    }
    alias = state2.input.slice(_position, state2.position);
    if (!_hasOwnProperty$1.call(state2.anchorMap, alias)) {
      throwError(state2, 'unidentified alias "' + alias + '"');
    }
    state2.result = state2.anchorMap[alias];
    skipSeparationSpace(state2, true, -1);
    return true;
  }
  function composeNode(state2, parentIndent, nodeContext, allowToSeek, allowCompact) {
    var allowBlockStyles, allowBlockScalars, allowBlockCollections, indentStatus = 1, atNewLine = false, hasContent = false, typeIndex, typeQuantity, typeList, type2, flowIndent, blockIndent;
    if (state2.listener !== null) {
      state2.listener("open", state2);
    }
    state2.tag = null;
    state2.anchor = null;
    state2.kind = null;
    state2.result = null;
    allowBlockStyles = allowBlockScalars = allowBlockCollections = CONTEXT_BLOCK_OUT === nodeContext || CONTEXT_BLOCK_IN === nodeContext;
    if (allowToSeek) {
      if (skipSeparationSpace(state2, true, -1)) {
        atNewLine = true;
        if (state2.lineIndent > parentIndent) {
          indentStatus = 1;
        } else if (state2.lineIndent === parentIndent) {
          indentStatus = 0;
        } else if (state2.lineIndent < parentIndent) {
          indentStatus = -1;
        }
      }
    }
    if (indentStatus === 1) {
      while (readTagProperty(state2) || readAnchorProperty(state2)) {
        if (skipSeparationSpace(state2, true, -1)) {
          atNewLine = true;
          allowBlockCollections = allowBlockStyles;
          if (state2.lineIndent > parentIndent) {
            indentStatus = 1;
          } else if (state2.lineIndent === parentIndent) {
            indentStatus = 0;
          } else if (state2.lineIndent < parentIndent) {
            indentStatus = -1;
          }
        } else {
          allowBlockCollections = false;
        }
      }
    }
    if (allowBlockCollections) {
      allowBlockCollections = atNewLine || allowCompact;
    }
    if (indentStatus === 1 || CONTEXT_BLOCK_OUT === nodeContext) {
      if (CONTEXT_FLOW_IN === nodeContext || CONTEXT_FLOW_OUT === nodeContext) {
        flowIndent = parentIndent;
      } else {
        flowIndent = parentIndent + 1;
      }
      blockIndent = state2.position - state2.lineStart;
      if (indentStatus === 1) {
        if (allowBlockCollections && (readBlockSequence(state2, blockIndent) || readBlockMapping(state2, blockIndent, flowIndent)) || readFlowCollection(state2, flowIndent)) {
          hasContent = true;
        } else {
          if (allowBlockScalars && readBlockScalar(state2, flowIndent) || readSingleQuotedScalar(state2, flowIndent) || readDoubleQuotedScalar(state2, flowIndent)) {
            hasContent = true;
          } else if (readAlias(state2)) {
            hasContent = true;
            if (state2.tag !== null || state2.anchor !== null) {
              throwError(state2, "alias node should not have any properties");
            }
          } else if (readPlainScalar(state2, flowIndent, CONTEXT_FLOW_IN === nodeContext)) {
            hasContent = true;
            if (state2.tag === null) {
              state2.tag = "?";
            }
          }
          if (state2.anchor !== null) {
            state2.anchorMap[state2.anchor] = state2.result;
          }
        }
      } else if (indentStatus === 0) {
        hasContent = allowBlockCollections && readBlockSequence(state2, blockIndent);
      }
    }
    if (state2.tag === null) {
      if (state2.anchor !== null) {
        state2.anchorMap[state2.anchor] = state2.result;
      }
    } else if (state2.tag === "?") {
      if (state2.result !== null && state2.kind !== "scalar") {
        throwError(state2, 'unacceptable node kind for !<?> tag; it should be "scalar", not "' + state2.kind + '"');
      }
      for (typeIndex = 0, typeQuantity = state2.implicitTypes.length; typeIndex < typeQuantity; typeIndex += 1) {
        type2 = state2.implicitTypes[typeIndex];
        if (type2.resolve(state2.result)) {
          state2.result = type2.construct(state2.result);
          state2.tag = type2.tag;
          if (state2.anchor !== null) {
            state2.anchorMap[state2.anchor] = state2.result;
          }
          break;
        }
      }
    } else if (state2.tag !== "!") {
      if (_hasOwnProperty$1.call(state2.typeMap[state2.kind || "fallback"], state2.tag)) {
        type2 = state2.typeMap[state2.kind || "fallback"][state2.tag];
      } else {
        type2 = null;
        typeList = state2.typeMap.multi[state2.kind || "fallback"];
        for (typeIndex = 0, typeQuantity = typeList.length; typeIndex < typeQuantity; typeIndex += 1) {
          if (state2.tag.slice(0, typeList[typeIndex].tag.length) === typeList[typeIndex].tag) {
            type2 = typeList[typeIndex];
            break;
          }
        }
      }
      if (!type2) {
        throwError(state2, "unknown tag !<" + state2.tag + ">");
      }
      if (state2.result !== null && type2.kind !== state2.kind) {
        throwError(state2, "unacceptable node kind for !<" + state2.tag + '> tag; it should be "' + type2.kind + '", not "' + state2.kind + '"');
      }
      if (!type2.resolve(state2.result, state2.tag)) {
        throwError(state2, "cannot resolve a node with !<" + state2.tag + "> explicit tag");
      } else {
        state2.result = type2.construct(state2.result, state2.tag);
        if (state2.anchor !== null) {
          state2.anchorMap[state2.anchor] = state2.result;
        }
      }
    }
    if (state2.listener !== null) {
      state2.listener("close", state2);
    }
    return state2.tag !== null || state2.anchor !== null || hasContent;
  }
  function readDocument(state2) {
    var documentStart = state2.position, _position, directiveName, directiveArgs, hasDirectives = false, ch;
    state2.version = null;
    state2.checkLineBreaks = state2.legacy;
    state2.tagMap = /* @__PURE__ */ Object.create(null);
    state2.anchorMap = /* @__PURE__ */ Object.create(null);
    while ((ch = state2.input.charCodeAt(state2.position)) !== 0) {
      skipSeparationSpace(state2, true, -1);
      ch = state2.input.charCodeAt(state2.position);
      if (state2.lineIndent > 0 || ch !== 37) {
        break;
      }
      hasDirectives = true;
      ch = state2.input.charCodeAt(++state2.position);
      _position = state2.position;
      while (ch !== 0 && !is_WS_OR_EOL(ch)) {
        ch = state2.input.charCodeAt(++state2.position);
      }
      directiveName = state2.input.slice(_position, state2.position);
      directiveArgs = [];
      if (directiveName.length < 1) {
        throwError(state2, "directive name must not be less than one character in length");
      }
      while (ch !== 0) {
        while (is_WHITE_SPACE(ch)) {
          ch = state2.input.charCodeAt(++state2.position);
        }
        if (ch === 35) {
          do {
            ch = state2.input.charCodeAt(++state2.position);
          } while (ch !== 0 && !is_EOL(ch));
          break;
        }
        if (is_EOL(ch))
          break;
        _position = state2.position;
        while (ch !== 0 && !is_WS_OR_EOL(ch)) {
          ch = state2.input.charCodeAt(++state2.position);
        }
        directiveArgs.push(state2.input.slice(_position, state2.position));
      }
      if (ch !== 0)
        readLineBreak(state2);
      if (_hasOwnProperty$1.call(directiveHandlers, directiveName)) {
        directiveHandlers[directiveName](state2, directiveName, directiveArgs);
      } else {
        throwWarning(state2, 'unknown document directive "' + directiveName + '"');
      }
    }
    skipSeparationSpace(state2, true, -1);
    if (state2.lineIndent === 0 && state2.input.charCodeAt(state2.position) === 45 && state2.input.charCodeAt(state2.position + 1) === 45 && state2.input.charCodeAt(state2.position + 2) === 45) {
      state2.position += 3;
      skipSeparationSpace(state2, true, -1);
    } else if (hasDirectives) {
      throwError(state2, "directives end mark is expected");
    }
    composeNode(state2, state2.lineIndent - 1, CONTEXT_BLOCK_OUT, false, true);
    skipSeparationSpace(state2, true, -1);
    if (state2.checkLineBreaks && PATTERN_NON_ASCII_LINE_BREAKS.test(state2.input.slice(documentStart, state2.position))) {
      throwWarning(state2, "non-ASCII line breaks are interpreted as content");
    }
    state2.documents.push(state2.result);
    if (state2.position === state2.lineStart && testDocumentSeparator(state2)) {
      if (state2.input.charCodeAt(state2.position) === 46) {
        state2.position += 3;
        skipSeparationSpace(state2, true, -1);
      }
      return;
    }
    if (state2.position < state2.length - 1) {
      throwError(state2, "end of the stream or a document separator is expected");
    } else {
      return;
    }
  }
  function loadDocuments(input, options2) {
    input = String(input);
    options2 = options2 || {};
    if (input.length !== 0) {
      if (input.charCodeAt(input.length - 1) !== 10 && input.charCodeAt(input.length - 1) !== 13) {
        input += "\n";
      }
      if (input.charCodeAt(0) === 65279) {
        input = input.slice(1);
      }
    }
    var state2 = new State$1(input, options2);
    var nullpos = input.indexOf("\0");
    if (nullpos !== -1) {
      state2.position = nullpos;
      throwError(state2, "null byte is not allowed in input");
    }
    state2.input += "\0";
    while (state2.input.charCodeAt(state2.position) === 32) {
      state2.lineIndent += 1;
      state2.position += 1;
    }
    while (state2.position < state2.length - 1) {
      readDocument(state2);
    }
    return state2.documents;
  }
  function loadAll$1(input, iterator, options2) {
    if (iterator !== null && typeof iterator === "object" && typeof options2 === "undefined") {
      options2 = iterator;
      iterator = null;
    }
    var documents2 = loadDocuments(input, options2);
    if (typeof iterator !== "function") {
      return documents2;
    }
    for (var index2 = 0, length2 = documents2.length; index2 < length2; index2 += 1) {
      iterator(documents2[index2]);
    }
  }
  function load$1(input, options2) {
    var documents2 = loadDocuments(input, options2);
    if (documents2.length === 0) {
      return void 0;
    } else if (documents2.length === 1) {
      return documents2[0];
    }
    throw new exception("expected a single document in the stream, but found more");
  }
  var loadAll_1 = loadAll$1;
  var load_1 = load$1;
  var loader = {
    loadAll: loadAll_1,
    load: load_1
  };
  var JSON_SCHEMA = json;
  var load = loader.load;
  function extractFrontMatter(text2) {
    const matches = text2.match(frontMatterRegex);
    if (!matches) {
      return {
        text: text2,
        metadata: {}
      };
    }
    let parsed = load(matches[1], {
      // To support config, we need JSON schema.
      // https://www.yaml.org/spec/1.2/spec.html#id2803231
      schema: JSON_SCHEMA
    }) ?? {};
    parsed = typeof parsed === "object" && !Array.isArray(parsed) ? parsed : {};
    const metadata = {};
    if (parsed.displayMode) {
      metadata.displayMode = parsed.displayMode.toString();
    }
    if (parsed.title) {
      metadata.title = parsed.title.toString();
    }
    if (parsed.config) {
      metadata.config = parsed.config;
    }
    return {
      text: text2.slice(matches[0].length),
      metadata
    };
  }
  const cleanupText = (code) => {
    return code.replace(/\r\n?/g, "\n").replace(
      /<(\w+)([^>]*)>/g,
      (match, tag, attributes) => "<" + tag + attributes.replace(/="([^"]*)"/g, "='$1'") + ">"
    );
  };
  const processFrontmatter = (code) => {
    const { text: text2, metadata } = extractFrontMatter(code);
    const { displayMode: displayMode2, title: title2, config: config2 = {} } = metadata;
    if (displayMode2) {
      if (!config2.gantt) {
        config2.gantt = {};
      }
      config2.gantt.displayMode = displayMode2;
    }
    return { title: title2, config: config2, text: text2 };
  };
  const processDirectives = (code) => {
    const initDirective = utils.detectInit(code) ?? {};
    const wrapDirectives = utils.detectDirective(code, "wrap");
    if (Array.isArray(wrapDirectives)) {
      initDirective.wrap = wrapDirectives.some(({ type: type2 }) => {
      });
    } else if ((wrapDirectives == null ? void 0 : wrapDirectives.type) === "wrap") {
      initDirective.wrap = true;
    }
    return {
      text: removeDirectives(code),
      directive: initDirective
    };
  };
  function preprocessDiagram(code) {
    const cleanedCode = cleanupText(code);
    const frontMatterResult = processFrontmatter(cleanedCode);
    const directiveResult = processDirectives(frontMatterResult.text);
    const config2 = cleanAndMerge(frontMatterResult.config, directiveResult.directive);
    code = cleanupComments(directiveResult.text);
    return {
      code,
      title: frontMatterResult.title,
      config: config2
    };
  }
  const MAX_TEXTLENGTH = 5e4;
  const MAX_TEXTLENGTH_EXCEEDED_MSG = "graph TB;a[Maximum text size in diagram exceeded];style a fill:#faa";
  const SECURITY_LVL_SANDBOX = "sandbox";
  const SECURITY_LVL_LOOSE = "loose";
  const XMLNS_SVG_STD = "http://www.w3.org/2000/svg";
  const XMLNS_XLINK_STD = "http://www.w3.org/1999/xlink";
  const XMLNS_XHTML_STD = "http://www.w3.org/1999/xhtml";
  const IFRAME_WIDTH = "100%";
  const IFRAME_HEIGHT = "100%";
  const IFRAME_STYLES = "border:0;margin:0;";
  const IFRAME_BODY_STYLE = "margin:0";
  const IFRAME_SANDBOX_OPTS = "allow-top-navigation-by-user-activation allow-popups";
  const IFRAME_NOT_SUPPORTED_MSG = 'The "iframe" tag is not supported by your browser.';
  const DOMPURIFY_TAGS = ["foreignobject"];
  const DOMPURIFY_ATTR = ["dominant-baseline"];
  function processAndSetConfigs(text2) {
    const processed2 = preprocessDiagram(text2);
    reset();
    addDirective(processed2.config ?? {});
    return processed2;
  }
  async function parse$3(text2, parseOptions) {
    addDiagrams();
    text2 = processAndSetConfigs(text2).code;
    try {
      await getDiagramFromText(text2);
    } catch (error) {
      if (parseOptions == null ? void 0 : parseOptions.suppressErrors) {
        return false;
      }
      throw error;
    }
    return true;
  }
  const cssImportantStyles = (cssClass, element2, cssClasses = []) => {
    return `
.${cssClass} ${element2} { ${cssClasses.join(" !important; ")} !important; }`;
  };
  const createCssStyles = (config2, classDefs = {}) => {
    var _a2;
    let cssStyles = "";
    if (config2.themeCSS !== void 0) {
      cssStyles += `
${config2.themeCSS}`;
    }
    if (config2.fontFamily !== void 0) {
      cssStyles += `
:root { --mermaid-font-family: ${config2.fontFamily}}`;
    }
    if (config2.altFontFamily !== void 0) {
      cssStyles += `
:root { --mermaid-alt-font-family: ${config2.altFontFamily}}`;
    }
    if (!isEmpty(classDefs)) {
      const htmlLabels = config2.htmlLabels || ((_a2 = config2.flowchart) == null ? void 0 : _a2.htmlLabels);
      const cssHtmlElements = ["> *", "span"];
      const cssShapeElements = ["rect", "polygon", "ellipse", "circle", "path"];
      const cssElements = htmlLabels ? cssHtmlElements : cssShapeElements;
      for (const classId in classDefs) {
        const styleClassDef = classDefs[classId];
        if (!isEmpty(styleClassDef.styles)) {
          cssElements.forEach((cssElement) => {
            cssStyles += cssImportantStyles(styleClassDef.id, cssElement, styleClassDef.styles);
          });
        }
        if (!isEmpty(styleClassDef.textStyles)) {
          cssStyles += cssImportantStyles(styleClassDef.id, "tspan", styleClassDef.textStyles);
        }
      }
    }
    return cssStyles;
  };
  const createUserStyles = (config2, graphType, classDefs, svgId) => {
    const userCSSstyles = createCssStyles(config2, classDefs);
    const allStyles = getStyles$g(graphType, userCSSstyles, config2.themeVariables);
    return serialize(compile(`${svgId}{${allStyles}}`), stringify);
  };
  const cleanUpSvgCode = (svgCode = "", inSandboxMode, useArrowMarkerUrls) => {
    let cleanedUpSvg = svgCode;
    if (!useArrowMarkerUrls && !inSandboxMode) {
      cleanedUpSvg = cleanedUpSvg.replace(
        /marker-end="url\([\d+./:=?A-Za-z-]*?#/g,
        'marker-end="url(#'
      );
    }
    cleanedUpSvg = decodeEntities(cleanedUpSvg);
    cleanedUpSvg = cleanedUpSvg.replace(/<br>/g, "<br/>");
    return cleanedUpSvg;
  };
  const putIntoIFrame = (svgCode = "", svgElement) => {
    var _a2, _b2;
    const height = ((_b2 = (_a2 = svgElement == null ? void 0 : svgElement.viewBox) == null ? void 0 : _a2.baseVal) == null ? void 0 : _b2.height) ? svgElement.viewBox.baseVal.height + "px" : IFRAME_HEIGHT;
    const base64encodedSrc = btoa('<body style="' + IFRAME_BODY_STYLE + '">' + svgCode + "</body>");
    return `<iframe style="width:${IFRAME_WIDTH};height:${height};${IFRAME_STYLES}" src="data:text/html;base64,${base64encodedSrc}" sandbox="${IFRAME_SANDBOX_OPTS}">
  ${IFRAME_NOT_SUPPORTED_MSG}
</iframe>`;
  };
  const appendDivSvgG = (parentRoot, id2, enclosingDivId, divStyle, svgXlink) => {
    const enclosingDiv = parentRoot.append("div");
    enclosingDiv.attr("id", enclosingDivId);
    if (divStyle) {
      enclosingDiv.attr("style", divStyle);
    }
    const svgNode2 = enclosingDiv.append("svg").attr("id", id2).attr("width", "100%").attr("xmlns", XMLNS_SVG_STD);
    if (svgXlink) {
      svgNode2.attr("xmlns:xlink", svgXlink);
    }
    svgNode2.append("g");
    return parentRoot;
  };
  function sandboxedIframe(parentNode, iFrameId) {
    return parentNode.append("iframe").attr("id", iFrameId).attr("style", "width: 100%; height: 100%;").attr("sandbox", "");
  }
  const removeExistingElements = (doc, id2, divId, iFrameId) => {
    var _a2, _b2, _c;
    (_a2 = doc.getElementById(id2)) == null ? void 0 : _a2.remove();
    (_b2 = doc.getElementById(divId)) == null ? void 0 : _b2.remove();
    (_c = doc.getElementById(iFrameId)) == null ? void 0 : _c.remove();
  };
  const render$3 = async function(id2, text2, svgContainingElement) {
    var _a2, _b2, _c, _d, _e, _f;
    addDiagrams();
    const processed2 = processAndSetConfigs(text2);
    text2 = processed2.code;
    const config2 = getConfig$2();
    log$1.debug(config2);
    if (text2.length > ((config2 == null ? void 0 : config2.maxTextSize) ?? MAX_TEXTLENGTH)) {
      text2 = MAX_TEXTLENGTH_EXCEEDED_MSG;
    }
    const idSelector = "#" + id2;
    const iFrameID = "i" + id2;
    const iFrameID_selector = "#" + iFrameID;
    const enclosingDivID = "d" + id2;
    const enclosingDivID_selector = "#" + enclosingDivID;
    let root2 = d3select("body");
    const isSandboxed = config2.securityLevel === SECURITY_LVL_SANDBOX;
    const isLooseSecurityLevel = config2.securityLevel === SECURITY_LVL_LOOSE;
    const fontFamily = config2.fontFamily;
    if (svgContainingElement !== void 0) {
      if (svgContainingElement) {
        svgContainingElement.innerHTML = "";
      }
      if (isSandboxed) {
        const iframe = sandboxedIframe(d3select(svgContainingElement), iFrameID);
        root2 = d3select(iframe.nodes()[0].contentDocument.body);
        root2.node().style.margin = 0;
      } else {
        root2 = d3select(svgContainingElement);
      }
      appendDivSvgG(root2, id2, enclosingDivID, `font-family: ${fontFamily}`, XMLNS_XLINK_STD);
    } else {
      removeExistingElements(document, id2, enclosingDivID, iFrameID);
      if (isSandboxed) {
        const iframe = sandboxedIframe(d3select("body"), iFrameID);
        root2 = d3select(iframe.nodes()[0].contentDocument.body);
        root2.node().style.margin = 0;
      } else {
        root2 = d3select("body");
      }
      appendDivSvgG(root2, id2, enclosingDivID);
    }
    let diag;
    let parseEncounteredException;
    try {
      diag = await getDiagramFromText(text2, { title: processed2.title });
    } catch (error) {
      diag = new Diagram("error");
      parseEncounteredException = error;
    }
    const element2 = root2.select(enclosingDivID_selector).node();
    const diagramType = diag.type;
    const svg2 = element2.firstChild;
    const firstChild = svg2.firstChild;
    const diagramClassDefs = (_b2 = (_a2 = diag.renderer).getClasses) == null ? void 0 : _b2.call(_a2, text2, diag);
    const rules = createUserStyles(config2, diagramType, diagramClassDefs, idSelector);
    const style1 = document.createElement("style");
    style1.innerHTML = rules;
    svg2.insertBefore(style1, firstChild);
    try {
      await diag.renderer.draw(text2, id2, version$1, diag);
    } catch (e) {
      errorRenderer.draw(text2, id2, version$1);
      throw e;
    }
    const svgNode2 = root2.select(`${enclosingDivID_selector} svg`);
    const a11yTitle = (_d = (_c = diag.db).getAccTitle) == null ? void 0 : _d.call(_c);
    const a11yDescr = (_f = (_e = diag.db).getAccDescription) == null ? void 0 : _f.call(_e);
    addA11yInfo(diagramType, svgNode2, a11yTitle, a11yDescr);
    root2.select(`[id="${id2}"]`).selectAll("foreignobject > *").attr("xmlns", XMLNS_XHTML_STD);
    let svgCode = root2.select(enclosingDivID_selector).node().innerHTML;
    log$1.debug("config.arrowMarkerAbsolute", config2.arrowMarkerAbsolute);
    svgCode = cleanUpSvgCode(svgCode, isSandboxed, evaluate(config2.arrowMarkerAbsolute));
    if (isSandboxed) {
      const svgEl = root2.select(enclosingDivID_selector + " svg").node();
      svgCode = putIntoIFrame(svgCode, svgEl);
    } else if (!isLooseSecurityLevel) {
      svgCode = purify.sanitize(svgCode, {
        ADD_TAGS: DOMPURIFY_TAGS,
        ADD_ATTR: DOMPURIFY_ATTR
      });
    }
    attachFunctions();
    if (parseEncounteredException) {
      throw parseEncounteredException;
    }
    const tmpElementSelector = isSandboxed ? iFrameID_selector : enclosingDivID_selector;
    const node2 = d3select(tmpElementSelector).node();
    if (node2 && "remove" in node2) {
      node2.remove();
    }
    return {
      svg: svgCode,
      bindFunctions: diag.db.bindFunctions
    };
  };
  function initialize$1(options2 = {}) {
    var _a2;
    if ((options2 == null ? void 0 : options2.fontFamily) && !((_a2 = options2.themeVariables) == null ? void 0 : _a2.fontFamily)) {
      if (!options2.themeVariables) {
        options2.themeVariables = {};
      }
      options2.themeVariables.fontFamily = options2.fontFamily;
    }
    saveConfigFromInitialize(options2);
    if ((options2 == null ? void 0 : options2.theme) && options2.theme in theme) {
      options2.themeVariables = theme[options2.theme].getThemeVariables(
        options2.themeVariables
      );
    } else if (options2) {
      options2.themeVariables = theme.default.getThemeVariables(options2.themeVariables);
    }
    const config2 = typeof options2 === "object" ? setSiteConfig(options2) : getSiteConfig();
    setLogLevel$1(config2.logLevel);
    addDiagrams();
  }
  const getDiagramFromText = (text2, metadata = {}) => {
    const { code } = preprocessDiagram(text2);
    return getDiagramFromText$1(code, metadata);
  };
  function addA11yInfo(diagramType, svgNode2, a11yTitle, a11yDescr) {
    setA11yDiagramInfo(svgNode2, diagramType);
    addSVGa11yTitleDescription(svgNode2, a11yTitle, a11yDescr, svgNode2.attr("id"));
  }
  const mermaidAPI = Object.freeze({
    render: render$3,
    parse: parse$3,
    getDiagramFromText,
    initialize: initialize$1,
    getConfig: getConfig$2,
    setConfig: setConfig$1,
    getSiteConfig,
    updateSiteConfig,
    reset: () => {
      reset();
    },
    globalReset: () => {
      reset(defaultConfig$1);
    },
    defaultConfig: defaultConfig$1
  });
  setLogLevel$1(getConfig$2().logLevel);
  reset(getConfig$2());
  const loadRegisteredDiagrams = async () => {
    log$1.debug(`Loading registered diagrams`);
    const results = await Promise.allSettled(
      Object.entries(detectors).map(async ([key, { detector: detector2, loader: loader2 }]) => {
        if (loader2) {
          try {
            getDiagram(key);
          } catch (error) {
            try {
              const { diagram: diagram2, id: id2 } = await loader2();
              registerDiagram(id2, diagram2, detector2);
            } catch (err) {
              log$1.error(`Failed to load external diagram with key ${key}. Removing from detectors.`);
              delete detectors[key];
              throw err;
            }
          }
        }
      })
    );
    const failed = results.filter((result) => result.status === "rejected");
    if (failed.length > 0) {
      log$1.error(`Failed to load ${failed.length} external diagrams`);
      for (const res of failed) {
        log$1.error(res);
      }
      throw new Error(`Failed to load ${failed.length} external diagrams`);
    }
  };
  const handleError = (error, errors, parseError) => {
    log$1.warn(error);
    if (isDetailedError(error)) {
      if (parseError) {
        parseError(error.str, error.hash);
      }
      errors.push({ ...error, message: error.str, error });
    } else {
      if (parseError) {
        parseError(error);
      }
      if (error instanceof Error) {
        errors.push({
          str: error.message,
          message: error.message,
          hash: error.name,
          error
        });
      }
    }
  };
  const run$3 = async function(options2 = {
    querySelector: ".mermaid"
  }) {
    try {
      await runThrowsErrors(options2);
    } catch (e) {
      if (isDetailedError(e)) {
        log$1.error(e.str);
      }
      if (mermaid.parseError) {
        mermaid.parseError(e);
      }
      if (!options2.suppressErrors) {
        log$1.error("Use the suppressErrors option to suppress these errors");
        throw e;
      }
    }
  };
  const runThrowsErrors = async function({ postRenderCallback, querySelector, nodes: nodes2 } = {
    querySelector: ".mermaid"
  }) {
    const conf2 = mermaidAPI.getConfig();
    log$1.debug(`${!postRenderCallback ? "No " : ""}Callback function found`);
    let nodesToProcess;
    if (nodes2) {
      nodesToProcess = nodes2;
    } else if (querySelector) {
      nodesToProcess = document.querySelectorAll(querySelector);
    } else {
      throw new Error("Nodes and querySelector are both undefined");
    }
    log$1.debug(`Found ${nodesToProcess.length} diagrams`);
    if ((conf2 == null ? void 0 : conf2.startOnLoad) !== void 0) {
      log$1.debug("Start On Load: " + (conf2 == null ? void 0 : conf2.startOnLoad));
      mermaidAPI.updateSiteConfig({ startOnLoad: conf2 == null ? void 0 : conf2.startOnLoad });
    }
    const idGenerator = new utils.InitIDGenerator(conf2.deterministicIds, conf2.deterministicIDSeed);
    let txt;
    const errors = [];
    for (const element2 of Array.from(nodesToProcess)) {
      log$1.info("Rendering diagram: " + element2.id);
      /*! Check if previously processed */
      if (element2.getAttribute("data-processed")) {
        continue;
      }
      element2.setAttribute("data-processed", "true");
      const id2 = `mermaid-${idGenerator.next()}`;
      txt = element2.innerHTML;
      txt = dedent(utils.entityDecode(txt)).trim().replace(/<br\s*\/?>/gi, "<br/>");
      const init2 = utils.detectInit(txt);
      if (init2) {
        log$1.debug("Detected early reinit: ", init2);
      }
      try {
        const { svg: svg2, bindFunctions: bindFunctions2 } = await render$2(id2, txt, element2);
        element2.innerHTML = svg2;
        if (postRenderCallback) {
          await postRenderCallback(id2);
        }
        if (bindFunctions2) {
          bindFunctions2(element2);
        }
      } catch (error) {
        handleError(error, errors, mermaid.parseError);
      }
    }
    if (errors.length > 0) {
      throw errors[0];
    }
  };
  const initialize = function(config2) {
    mermaidAPI.initialize(config2);
  };
  const init = async function(config2, nodes2, callback) {
    log$1.warn("mermaid.init is deprecated. Please use run instead.");
    if (config2) {
      initialize(config2);
    }
    const runOptions = { postRenderCallback: callback, querySelector: ".mermaid" };
    if (typeof nodes2 === "string") {
      runOptions.querySelector = nodes2;
    } else if (nodes2) {
      if (nodes2 instanceof HTMLElement) {
        runOptions.nodes = [nodes2];
      } else {
        runOptions.nodes = nodes2;
      }
    }
    await run$3(runOptions);
  };
  const registerExternalDiagrams = async (diagrams2, {
    lazyLoad = true
  } = {}) => {
    registerLazyLoadedDiagrams(...diagrams2);
    if (lazyLoad === false) {
      await loadRegisteredDiagrams();
    }
  };
  const contentLoaded = function() {
    if (mermaid.startOnLoad) {
      const { startOnLoad } = mermaidAPI.getConfig();
      if (startOnLoad) {
        mermaid.run().catch((err) => log$1.error("Mermaid failed to initialize", err));
      }
    }
  };
  if (typeof document !== "undefined") {
    /*!
     * Wait for document loaded before starting the execution
     */
    window.addEventListener("load", contentLoaded, false);
  }
  const setParseErrorHandler = function(parseErrorHandler) {
    mermaid.parseError = parseErrorHandler;
  };
  const executionQueue = [];
  let executionQueueRunning = false;
  const executeQueue = async () => {
    if (executionQueueRunning) {
      return;
    }
    executionQueueRunning = true;
    while (executionQueue.length > 0) {
      const f2 = executionQueue.shift();
      if (f2) {
        try {
          await f2();
        } catch (e) {
          log$1.error("Error executing queue", e);
        }
      }
    }
    executionQueueRunning = false;
  };
  const parse$2 = async (text2, parseOptions) => {
    return new Promise((resolve, reject) => {
      const performCall = () => new Promise((res, rej) => {
        mermaidAPI.parse(text2, parseOptions).then(
          (r) => {
            res(r);
            resolve(r);
          },
          (e) => {
            var _a2;
            log$1.error("Error parsing", e);
            (_a2 = mermaid.parseError) == null ? void 0 : _a2.call(mermaid, e);
            rej(e);
            reject(e);
          }
        );
      });
      executionQueue.push(performCall);
      executeQueue().catch(reject);
    });
  };
  const render$2 = (id2, text2, container) => {
    return new Promise((resolve, reject) => {
      const performCall = () => new Promise((res, rej) => {
        mermaidAPI.render(id2, text2, container).then(
          (r) => {
            res(r);
            resolve(r);
          },
          (e) => {
            var _a2;
            log$1.error("Error parsing", e);
            (_a2 = mermaid.parseError) == null ? void 0 : _a2.call(mermaid, e);
            rej(e);
            reject(e);
          }
        );
      });
      executionQueue.push(performCall);
      executeQueue().catch(reject);
    });
  };
  const mermaid = {
    startOnLoad: true,
    mermaidAPI,
    parse: parse$2,
    render: render$2,
    init,
    run: run$3,
    registerExternalDiagrams,
    initialize,
    parseError: void 0,
    contentLoaded,
    setParseErrorHandler,
    detectType
  };
  var parser$v = function() {
    var o = function(k, v, o2, l) {
      for (o2 = o2 || {}, l = k.length; l--; o2[k[l]] = v)
        ;
      return o2;
    }, $V0 = [1, 24], $V1 = [1, 25], $V2 = [1, 26], $V3 = [1, 27], $V4 = [1, 28], $V5 = [1, 63], $V6 = [1, 64], $V7 = [1, 65], $V8 = [1, 66], $V9 = [1, 67], $Va = [1, 68], $Vb = [1, 69], $Vc = [1, 29], $Vd = [1, 30], $Ve = [1, 31], $Vf = [1, 32], $Vg = [1, 33], $Vh = [1, 34], $Vi = [1, 35], $Vj = [1, 36], $Vk = [1, 37], $Vl = [1, 38], $Vm = [1, 39], $Vn = [1, 40], $Vo = [1, 41], $Vp = [1, 42], $Vq = [1, 43], $Vr = [1, 44], $Vs = [1, 45], $Vt = [1, 46], $Vu = [1, 47], $Vv = [1, 48], $Vw = [1, 50], $Vx = [1, 51], $Vy = [1, 52], $Vz = [1, 53], $VA = [1, 54], $VB = [1, 55], $VC = [1, 56], $VD = [1, 57], $VE = [1, 58], $VF = [1, 59], $VG = [1, 60], $VH = [14, 42], $VI = [14, 34, 36, 37, 38, 39, 40, 41, 42, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74], $VJ = [12, 14, 34, 36, 37, 38, 39, 40, 41, 42, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74], $VK = [1, 82], $VL = [1, 83], $VM = [1, 84], $VN = [1, 85], $VO = [12, 14, 42], $VP = [12, 14, 33, 42], $VQ = [12, 14, 33, 42, 76, 77, 79, 80], $VR = [12, 33], $VS = [34, 36, 37, 38, 39, 40, 41, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74];
    var parser2 = {
      trace: function trace() {
      },
      yy: {},
      symbols_: { "error": 2, "start": 3, "mermaidDoc": 4, "direction": 5, "direction_tb": 6, "direction_bt": 7, "direction_rl": 8, "direction_lr": 9, "graphConfig": 10, "C4_CONTEXT": 11, "NEWLINE": 12, "statements": 13, "EOF": 14, "C4_CONTAINER": 15, "C4_COMPONENT": 16, "C4_DYNAMIC": 17, "C4_DEPLOYMENT": 18, "otherStatements": 19, "diagramStatements": 20, "otherStatement": 21, "title": 22, "accDescription": 23, "acc_title": 24, "acc_title_value": 25, "acc_descr": 26, "acc_descr_value": 27, "acc_descr_multiline_value": 28, "boundaryStatement": 29, "boundaryStartStatement": 30, "boundaryStopStatement": 31, "boundaryStart": 32, "LBRACE": 33, "ENTERPRISE_BOUNDARY": 34, "attributes": 35, "SYSTEM_BOUNDARY": 36, "BOUNDARY": 37, "CONTAINER_BOUNDARY": 38, "NODE": 39, "NODE_L": 40, "NODE_R": 41, "RBRACE": 42, "diagramStatement": 43, "PERSON": 44, "PERSON_EXT": 45, "SYSTEM": 46, "SYSTEM_DB": 47, "SYSTEM_QUEUE": 48, "SYSTEM_EXT": 49, "SYSTEM_EXT_DB": 50, "SYSTEM_EXT_QUEUE": 51, "CONTAINER": 52, "CONTAINER_DB": 53, "CONTAINER_QUEUE": 54, "CONTAINER_EXT": 55, "CONTAINER_EXT_DB": 56, "CONTAINER_EXT_QUEUE": 57, "COMPONENT": 58, "COMPONENT_DB": 59, "COMPONENT_QUEUE": 60, "COMPONENT_EXT": 61, "COMPONENT_EXT_DB": 62, "COMPONENT_EXT_QUEUE": 63, "REL": 64, "BIREL": 65, "REL_U": 66, "REL_D": 67, "REL_L": 68, "REL_R": 69, "REL_B": 70, "REL_INDEX": 71, "UPDATE_EL_STYLE": 72, "UPDATE_REL_STYLE": 73, "UPDATE_LAYOUT_CONFIG": 74, "attribute": 75, "STR": 76, "STR_KEY": 77, "STR_VALUE": 78, "ATTRIBUTE": 79, "ATTRIBUTE_EMPTY": 80, "$accept": 0, "$end": 1 },
      terminals_: { 2: "error", 6: "direction_tb", 7: "direction_bt", 8: "direction_rl", 9: "direction_lr", 11: "C4_CONTEXT", 12: "NEWLINE", 14: "EOF", 15: "C4_CONTAINER", 16: "C4_COMPONENT", 17: "C4_DYNAMIC", 18: "C4_DEPLOYMENT", 22: "title", 23: "accDescription", 24: "acc_title", 25: "acc_title_value", 26: "acc_descr", 27: "acc_descr_value", 28: "acc_descr_multiline_value", 33: "LBRACE", 34: "ENTERPRISE_BOUNDARY", 36: "SYSTEM_BOUNDARY", 37: "BOUNDARY", 38: "CONTAINER_BOUNDARY", 39: "NODE", 40: "NODE_L", 41: "NODE_R", 42: "RBRACE", 44: "PERSON", 45: "PERSON_EXT", 46: "SYSTEM", 47: "SYSTEM_DB", 48: "SYSTEM_QUEUE", 49: "SYSTEM_EXT", 50: "SYSTEM_EXT_DB", 51: "SYSTEM_EXT_QUEUE", 52: "CONTAINER", 53: "CONTAINER_DB", 54: "CONTAINER_QUEUE", 55: "CONTAINER_EXT", 56: "CONTAINER_EXT_DB", 57: "CONTAINER_EXT_QUEUE", 58: "COMPONENT", 59: "COMPONENT_DB", 60: "COMPONENT_QUEUE", 61: "COMPONENT_EXT", 62: "COMPONENT_EXT_DB", 63: "COMPONENT_EXT_QUEUE", 64: "REL", 65: "BIREL", 66: "REL_U", 67: "REL_D", 68: "REL_L", 69: "REL_R", 70: "REL_B", 71: "REL_INDEX", 72: "UPDATE_EL_STYLE", 73: "UPDATE_REL_STYLE", 74: "UPDATE_LAYOUT_CONFIG", 76: "STR", 77: "STR_KEY", 78: "STR_VALUE", 79: "ATTRIBUTE", 80: "ATTRIBUTE_EMPTY" },
      productions_: [0, [3, 1], [3, 1], [5, 1], [5, 1], [5, 1], [5, 1], [4, 1], [10, 4], [10, 4], [10, 4], [10, 4], [10, 4], [13, 1], [13, 1], [13, 2], [19, 1], [19, 2], [19, 3], [21, 1], [21, 1], [21, 2], [21, 2], [21, 1], [29, 3], [30, 3], [30, 3], [30, 4], [32, 2], [32, 2], [32, 2], [32, 2], [32, 2], [32, 2], [32, 2], [31, 1], [20, 1], [20, 2], [20, 3], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 1], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [43, 2], [35, 1], [35, 2], [75, 1], [75, 2], [75, 1], [75, 1]],
      performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
        var $0 = $$.length - 1;
        switch (yystate) {
          case 3:
            yy.setDirection("TB");
            break;
          case 4:
            yy.setDirection("BT");
            break;
          case 5:
            yy.setDirection("RL");
            break;
          case 6:
            yy.setDirection("LR");
            break;
          case 8:
          case 9:
          case 10:
          case 11:
          case 12:
            yy.setC4Type($$[$0 - 3]);
            break;
          case 19:
            yy.setTitle($$[$0].substring(6));
            this.$ = $$[$0].substring(6);
            break;
          case 20:
            yy.setAccDescription($$[$0].substring(15));
            this.$ = $$[$0].substring(15);
            break;
          case 21:
            this.$ = $$[$0].trim();
            yy.setTitle(this.$);
            break;
          case 22:
          case 23:
            this.$ = $$[$0].trim();
            yy.setAccDescription(this.$);
            break;
          case 28:
          case 29:
            $$[$0].splice(2, 0, "ENTERPRISE");
            yy.addPersonOrSystemBoundary(...$$[$0]);
            this.$ = $$[$0];
            break;
          case 30:
            yy.addPersonOrSystemBoundary(...$$[$0]);
            this.$ = $$[$0];
            break;
          case 31:
            $$[$0].splice(2, 0, "CONTAINER");
            yy.addContainerBoundary(...$$[$0]);
            this.$ = $$[$0];
            break;
          case 32:
            yy.addDeploymentNode("node", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 33:
            yy.addDeploymentNode("nodeL", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 34:
            yy.addDeploymentNode("nodeR", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 35:
            yy.popBoundaryParseStack();
            break;
          case 39:
            yy.addPersonOrSystem("person", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 40:
            yy.addPersonOrSystem("external_person", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 41:
            yy.addPersonOrSystem("system", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 42:
            yy.addPersonOrSystem("system_db", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 43:
            yy.addPersonOrSystem("system_queue", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 44:
            yy.addPersonOrSystem("external_system", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 45:
            yy.addPersonOrSystem("external_system_db", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 46:
            yy.addPersonOrSystem("external_system_queue", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 47:
            yy.addContainer("container", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 48:
            yy.addContainer("container_db", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 49:
            yy.addContainer("container_queue", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 50:
            yy.addContainer("external_container", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 51:
            yy.addContainer("external_container_db", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 52:
            yy.addContainer("external_container_queue", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 53:
            yy.addComponent("component", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 54:
            yy.addComponent("component_db", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 55:
            yy.addComponent("component_queue", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 56:
            yy.addComponent("external_component", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 57:
            yy.addComponent("external_component_db", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 58:
            yy.addComponent("external_component_queue", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 60:
            yy.addRel("rel", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 61:
            yy.addRel("birel", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 62:
            yy.addRel("rel_u", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 63:
            yy.addRel("rel_d", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 64:
            yy.addRel("rel_l", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 65:
            yy.addRel("rel_r", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 66:
            yy.addRel("rel_b", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 67:
            $$[$0].splice(0, 1);
            yy.addRel("rel", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 68:
            yy.updateElStyle("update_el_style", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 69:
            yy.updateRelStyle("update_rel_style", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 70:
            yy.updateLayoutConfig("update_layout_config", ...$$[$0]);
            this.$ = $$[$0];
            break;
          case 71:
            this.$ = [$$[$0]];
            break;
          case 72:
            $$[$0].unshift($$[$0 - 1]);
            this.$ = $$[$0];
            break;
          case 73:
          case 75:
            this.$ = $$[$0].trim();
            break;
          case 74:
            let kv = {};
            kv[$$[$0 - 1].trim()] = $$[$0].trim();
            this.$ = kv;
            break;
          case 76:
            this.$ = "";
            break;
        }
      },
      table: [{ 3: 1, 4: 2, 5: 3, 6: [1, 5], 7: [1, 6], 8: [1, 7], 9: [1, 8], 10: 4, 11: [1, 9], 15: [1, 10], 16: [1, 11], 17: [1, 12], 18: [1, 13] }, { 1: [3] }, { 1: [2, 1] }, { 1: [2, 2] }, { 1: [2, 7] }, { 1: [2, 3] }, { 1: [2, 4] }, { 1: [2, 5] }, { 1: [2, 6] }, { 12: [1, 14] }, { 12: [1, 15] }, { 12: [1, 16] }, { 12: [1, 17] }, { 12: [1, 18] }, { 13: 19, 19: 20, 20: 21, 21: 22, 22: $V0, 23: $V1, 24: $V2, 26: $V3, 28: $V4, 29: 49, 30: 61, 32: 62, 34: $V5, 36: $V6, 37: $V7, 38: $V8, 39: $V9, 40: $Va, 41: $Vb, 43: 23, 44: $Vc, 45: $Vd, 46: $Ve, 47: $Vf, 48: $Vg, 49: $Vh, 50: $Vi, 51: $Vj, 52: $Vk, 53: $Vl, 54: $Vm, 55: $Vn, 56: $Vo, 57: $Vp, 58: $Vq, 59: $Vr, 60: $Vs, 61: $Vt, 62: $Vu, 63: $Vv, 64: $Vw, 65: $Vx, 66: $Vy, 67: $Vz, 68: $VA, 69: $VB, 70: $VC, 71: $VD, 72: $VE, 73: $VF, 74: $VG }, { 13: 70, 19: 20, 20: 21, 21: 22, 22: $V0, 23: $V1, 24: $V2, 26: $V3, 28: $V4, 29: 49, 30: 61, 32: 62, 34: $V5, 36: $V6, 37: $V7, 38: $V8, 39: $V9, 40: $Va, 41: $Vb, 43: 23, 44: $Vc, 45: $Vd, 46: $Ve, 47: $Vf, 48: $Vg, 49: $Vh, 50: $Vi, 51: $Vj, 52: $Vk, 53: $Vl, 54: $Vm, 55: $Vn, 56: $Vo, 57: $Vp, 58: $Vq, 59: $Vr, 60: $Vs, 61: $Vt, 62: $Vu, 63: $Vv, 64: $Vw, 65: $Vx, 66: $Vy, 67: $Vz, 68: $VA, 69: $VB, 70: $VC, 71: $VD, 72: $VE, 73: $VF, 74: $VG }, { 13: 71, 19: 20, 20: 21, 21: 22, 22: $V0, 23: $V1, 24: $V2, 26: $V3, 28: $V4, 29: 49, 30: 61, 32: 62, 34: $V5, 36: $V6, 37: $V7, 38: $V8, 39: $V9, 40: $Va, 41: $Vb, 43: 23, 44: $Vc, 45: $Vd, 46: $Ve, 47: $Vf, 48: $Vg, 49: $Vh, 50: $Vi, 51: $Vj, 52: $Vk, 53: $Vl, 54: $Vm, 55: $Vn, 56: $Vo, 57: $Vp, 58: $Vq, 59: $Vr, 60: $Vs, 61: $Vt, 62: $Vu, 63: $Vv, 64: $Vw, 65: $Vx, 66: $Vy, 67: $Vz, 68: $VA, 69: $VB, 70: $VC, 71: $VD, 72: $VE, 73: $VF, 74: $VG }, { 13: 72, 19: 20, 20: 21, 21: 22, 22: $V0, 23: $V1, 24: $V2, 26: $V3, 28: $V4, 29: 49, 30: 61, 32: 62, 34: $V5, 36: $V6, 37: $V7, 38: $V8, 39: $V9, 40: $Va, 41: $Vb, 43: 23, 44: $Vc, 45: $Vd, 46: $Ve, 47: $Vf, 48: $Vg, 49: $Vh, 50: $Vi, 51: $Vj, 52: $Vk, 53: $Vl, 54: $Vm, 55: $Vn, 56: $Vo, 57: $Vp, 58: $Vq, 59: $Vr, 60: $Vs, 61: $Vt, 62: $Vu, 63: $Vv, 64: $Vw, 65: $Vx, 66: $Vy, 67: $Vz, 68: $VA, 69: $VB, 70: $VC, 71: $VD, 72: $VE, 73: $VF, 74: $VG }, { 13: 73, 19: 20, 20: 21, 21: 22, 22: $V0, 23: $V1, 24: $V2, 26: $V3, 28: $V4, 29: 49, 30: 61, 32: 62, 34: $V5, 36: $V6, 37: $V7, 38: $V8, 39: $V9, 40: $Va, 41: $Vb, 43: 23, 44: $Vc, 45: $Vd, 46: $Ve, 47: $Vf, 48: $Vg, 49: $Vh, 50: $Vi, 51: $Vj, 52: $Vk, 53: $Vl, 54: $Vm, 55: $Vn, 56: $Vo, 57: $Vp, 58: $Vq, 59: $Vr, 60: $Vs, 61: $Vt, 62: $Vu, 63: $Vv, 64: $Vw, 65: $Vx, 66: $Vy, 67: $Vz, 68: $VA, 69: $VB, 70: $VC, 71: $VD, 72: $VE, 73: $VF, 74: $VG }, { 14: [1, 74] }, o($VH, [2, 13], { 43: 23, 29: 49, 30: 61, 32: 62, 20: 75, 34: $V5, 36: $V6, 37: $V7, 38: $V8, 39: $V9, 40: $Va, 41: $Vb, 44: $Vc, 45: $Vd, 46: $Ve, 47: $Vf, 48: $Vg, 49: $Vh, 50: $Vi, 51: $Vj, 52: $Vk, 53: $Vl, 54: $Vm, 55: $Vn, 56: $Vo, 57: $Vp, 58: $Vq, 59: $Vr, 60: $Vs, 61: $Vt, 62: $Vu, 63: $Vv, 64: $Vw, 65: $Vx, 66: $Vy, 67: $Vz, 68: $VA, 69: $VB, 70: $VC, 71: $VD, 72: $VE, 73: $VF, 74: $VG }), o($VH, [2, 14]), o($VI, [2, 16], { 12: [1, 76] }), o($VH, [2, 36], { 12: [1, 77] }), o($VJ, [2, 19]), o($VJ, [2, 20]), { 25: [1, 78] }, { 27: [1, 79] }, o($VJ, [2, 23]), { 35: 80, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 86, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 87, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 88, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 89, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 90, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 91, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 92, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 93, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 94, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 95, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 96, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 97, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 98, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 99, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 100, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 101, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 102, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 103, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 104, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, o($VO, [2, 59]), { 35: 105, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 106, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 107, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 108, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 109, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 110, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 111, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 112, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 113, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 114, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 115, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 20: 116, 29: 49, 30: 61, 32: 62, 34: $V5, 36: $V6, 37: $V7, 38: $V8, 39: $V9, 40: $Va, 41: $Vb, 43: 23, 44: $Vc, 45: $Vd, 46: $Ve, 47: $Vf, 48: $Vg, 49: $Vh, 50: $Vi, 51: $Vj, 52: $Vk, 53: $Vl, 54: $Vm, 55: $Vn, 56: $Vo, 57: $Vp, 58: $Vq, 59: $Vr, 60: $Vs, 61: $Vt, 62: $Vu, 63: $Vv, 64: $Vw, 65: $Vx, 66: $Vy, 67: $Vz, 68: $VA, 69: $VB, 70: $VC, 71: $VD, 72: $VE, 73: $VF, 74: $VG }, { 12: [1, 118], 33: [1, 117] }, { 35: 119, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 120, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 121, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 122, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 123, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 124, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 35: 125, 75: 81, 76: $VK, 77: $VL, 79: $VM, 80: $VN }, { 14: [1, 126] }, { 14: [1, 127] }, { 14: [1, 128] }, { 14: [1, 129] }, { 1: [2, 8] }, o($VH, [2, 15]), o($VI, [2, 17], { 21: 22, 19: 130, 22: $V0, 23: $V1, 24: $V2, 26: $V3, 28: $V4 }), o($VH, [2, 37], { 19: 20, 20: 21, 21: 22, 43: 23, 29: 49, 30: 61, 32: 62, 13: 131, 22: $V0, 23: $V1, 24: $V2, 26: $V3, 28: $V4, 34: $V5, 36: $V6, 37: $V7, 38: $V8, 39: $V9, 40: $Va, 41: $Vb, 44: $Vc, 45: $Vd, 46: $Ve, 47: $Vf, 48: $Vg, 49: $Vh, 50: $Vi, 51: $Vj, 52: $Vk, 53: $Vl, 54: $Vm, 55: $Vn, 56: $Vo, 57: $Vp, 58: $Vq, 59: $Vr, 60: $Vs, 61: $Vt, 62: $Vu, 63: $Vv, 64: $Vw, 65: $Vx, 66: $Vy, 67: $Vz, 68: $VA, 69: $VB, 70: $VC, 71: $VD, 72: $VE, 73: $VF, 74: $VG }), o($VJ, [2, 21]), o($VJ, [2, 22]), o($VO, [2, 39]), o($VP, [2, 71], { 75: 81, 35: 132, 76: $VK, 77: $VL, 79: $VM, 80: $VN }), o($VQ, [2, 73]), { 78: [1, 133] }, o($VQ, [2, 75]), o($VQ, [2, 76]), o($VO, [2, 40]), o($VO, [2, 41]), o($VO, [2, 42]), o($VO, [2, 43]), o($VO, [2, 44]), o($VO, [2, 45]), o($VO, [2, 46]), o($VO, [2, 47]), o($VO, [2, 48]), o($VO, [2, 49]), o($VO, [2, 50]), o($VO, [2, 51]), o($VO, [2, 52]), o($VO, [2, 53]), o($VO, [2, 54]), o($VO, [2, 55]), o($VO, [2, 56]), o($VO, [2, 57]), o($VO, [2, 58]), o($VO, [2, 60]), o($VO, [2, 61]), o($VO, [2, 62]), o($VO, [2, 63]), o($VO, [2, 64]), o($VO, [2, 65]), o($VO, [2, 66]), o($VO, [2, 67]), o($VO, [2, 68]), o($VO, [2, 69]), o($VO, [2, 70]), { 31: 134, 42: [1, 135] }, { 12: [1, 136] }, { 33: [1, 137] }, o($VR, [2, 28]), o($VR, [2, 29]), o($VR, [2, 30]), o($VR, [2, 31]), o($VR, [2, 32]), o($VR, [2, 33]), o($VR, [2, 34]), { 1: [2, 9] }, { 1: [2, 10] }, { 1: [2, 11] }, { 1: [2, 12] }, o($VI, [2, 18]), o($VH, [2, 38]), o($VP, [2, 72]), o($VQ, [2, 74]), o($VO, [2, 24]), o($VO, [2, 35]), o($VS, [2, 25]), o($VS, [2, 26], { 12: [1, 138] }), o($VS, [2, 27])],
      defaultActions: { 2: [2, 1], 3: [2, 2], 4: [2, 7], 5: [2, 3], 6: [2, 4], 7: [2, 5], 8: [2, 6], 74: [2, 8], 126: [2, 9], 127: [2, 10], 128: [2, 11], 129: [2, 12] },
      parseError: function parseError(str2, hash) {
        if (hash.recoverable) {
          this.trace(str2);
        } else {
          var error = new Error(str2);
          error.hash = hash;
          throw error;
        }
      },
      parse: function parse2(input) {
        var self2 = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, TERROR = 2, EOF = 1;
        var args = lstack.slice.call(arguments, 1);
        var lexer2 = Object.create(this.lexer);
        var sharedState = { yy: {} };
        for (var k in this.yy) {
          if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
            sharedState.yy[k] = this.yy[k];
          }
        }
        lexer2.setInput(input, sharedState.yy);
        sharedState.yy.lexer = lexer2;
        sharedState.yy.parser = this;
        if (typeof lexer2.yylloc == "undefined") {
          lexer2.yylloc = {};
        }
        var yyloc = lexer2.yylloc;
        lstack.push(yyloc);
        var ranges = lexer2.options && lexer2.options.ranges;
        if (typeof sharedState.yy.parseError === "function") {
          this.parseError = sharedState.yy.parseError;
        } else {
          this.parseError = Object.getPrototypeOf(this).parseError;
        }
        function lex2() {
          var token2;
          token2 = tstack.pop() || lexer2.lex() || EOF;
          if (typeof token2 !== "number") {
            if (token2 instanceof Array) {
              tstack = token2;
              token2 = tstack.pop();
            }
            token2 = self2.symbols_[token2] || token2;
          }
          return token2;
        }
        var symbol, state2, action, r, yyval = {}, p, len, newState, expected;
        while (true) {
          state2 = stack[stack.length - 1];
          if (this.defaultActions[state2]) {
            action = this.defaultActions[state2];
          } else {
            if (symbol === null || typeof symbol == "undefined") {
              symbol = lex2();
            }
            action = table[state2] && table[state2][symbol];
          }
          if (typeof action === "undefined" || !action.length || !action[0]) {
            var errStr = "";
            expected = [];
            for (p in table[state2]) {
              if (this.terminals_[p] && p > TERROR) {
                expected.push("'" + this.terminals_[p] + "'");
              }
            }
            if (lexer2.showPosition) {
              errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer2.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
            } else {
              errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
            }
            this.parseError(errStr, {
              text: lexer2.match,
              token: this.terminals_[symbol] || symbol,
              line: lexer2.yylineno,
              loc: yyloc,
              expected
            });
          }
          if (action[0] instanceof Array && action.length > 1) {
            throw new Error("Parse Error: multiple actions possible at state: " + state2 + ", token: " + symbol);
          }
          switch (action[0]) {
            case 1:
              stack.push(symbol);
              vstack.push(lexer2.yytext);
              lstack.push(lexer2.yylloc);
              stack.push(action[1]);
              symbol = null;
              {
                yyleng = lexer2.yyleng;
                yytext = lexer2.yytext;
                yylineno = lexer2.yylineno;
                yyloc = lexer2.yylloc;
              }
              break;
            case 2:
              len = this.productions_[action[1]][1];
              yyval.$ = vstack[vstack.length - len];
              yyval._$ = {
                first_line: lstack[lstack.length - (len || 1)].first_line,
                last_line: lstack[lstack.length - 1].last_line,
                first_column: lstack[lstack.length - (len || 1)].first_column,
                last_column: lstack[lstack.length - 1].last_column
              };
              if (ranges) {
                yyval._$.range = [
                  lstack[lstack.length - (len || 1)].range[0],
                  lstack[lstack.length - 1].range[1]
                ];
              }
              r = this.performAction.apply(yyval, [
                yytext,
                yyleng,
                yylineno,
                sharedState.yy,
                action[1],
                vstack,
                lstack
              ].concat(args));
              if (typeof r !== "undefined") {
                return r;
              }
              if (len) {
                stack = stack.slice(0, -1 * len * 2);
                vstack = vstack.slice(0, -1 * len);
                lstack = lstack.slice(0, -1 * len);
              }
              stack.push(this.productions_[action[1]][0]);
              vstack.push(yyval.$);
              lstack.push(yyval._$);
              newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
              stack.push(newState);
              break;
            case 3:
              return true;
          }
        }
        return true;
      }
    };
    var lexer = function() {
      var lexer2 = {
        EOF: 1,
        parseError: function parseError(str2, hash) {
          if (this.yy.parser) {
            this.yy.parser.parseError(str2, hash);
          } else {
            throw new Error(str2);
          }
        },
        // resets the lexer, sets new input
        setInput: function(input, yy) {
          this.yy = yy || this.yy || {};
          this._input = input;
          this._more = this._backtrack = this.done = false;
          this.yylineno = this.yyleng = 0;
          this.yytext = this.matched = this.match = "";
          this.conditionStack = ["INITIAL"];
          this.yylloc = {
            first_line: 1,
            first_column: 0,
            last_line: 1,
            last_column: 0
          };
          if (this.options.ranges) {
            this.yylloc.range = [0, 0];
          }
          this.offset = 0;
          return this;
        },
        // consumes and returns one char from the input
        input: function() {
          var ch = this._input[0];
          this.yytext += ch;
          this.yyleng++;
          this.offset++;
          this.match += ch;
          this.matched += ch;
          var lines = ch.match(/(?:\r\n?|\n).*/g);
          if (lines) {
            this.yylineno++;
            this.yylloc.last_line++;
          } else {
            this.yylloc.last_column++;
          }
          if (this.options.ranges) {
            this.yylloc.range[1]++;
          }
          this._input = this._input.slice(1);
          return ch;
        },
        // unshifts one char (or a string) into the input
        unput: function(ch) {
          var len = ch.length;
          var lines = ch.split(/(?:\r\n?|\n)/g);
          this._input = ch + this._input;
          this.yytext = this.yytext.substr(0, this.yytext.length - len);
          this.offset -= len;
          var oldLines = this.match.split(/(?:\r\n?|\n)/g);
          this.match = this.match.substr(0, this.match.length - 1);
          this.matched = this.matched.substr(0, this.matched.length - 1);
          if (lines.length - 1) {
            this.yylineno -= lines.length - 1;
          }
          var r = this.yylloc.range;
          this.yylloc = {
            first_line: this.yylloc.first_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.first_column,
            last_column: lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
          };
          if (this.options.ranges) {
            this.yylloc.range = [r[0], r[0] + this.yyleng - len];
          }
          this.yyleng = this.yytext.length;
          return this;
        },
        // When called from action, caches matched text and appends it on next action
        more: function() {
          this._more = true;
          return this;
        },
        // When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
        reject: function() {
          if (this.options.backtrack_lexer) {
            this._backtrack = true;
          } else {
            return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {
              text: "",
              token: null,
              line: this.yylineno
            });
          }
          return this;
        },
        // retain first n characters of the match
        less: function(n) {
          this.unput(this.match.slice(n));
        },
        // displays already matched input, i.e. for error messages
        pastInput: function() {
          var past = this.matched.substr(0, this.matched.length - this.match.length);
          return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
        },
        // displays upcoming input, i.e. for error messages
        upcomingInput: function() {
          var next2 = this.match;
          if (next2.length < 20) {
            next2 += this._input.substr(0, 20 - next2.length);
          }
          return (next2.substr(0, 20) + (next2.length > 20 ? "..." : "")).replace(/\n/g, "");
        },
        // displays the character position where the lexing error occurred, i.e. for error messages
        showPosition: function() {
          var pre = this.pastInput();
          var c2 = new Array(pre.length + 1).join("-");
          return pre + this.upcomingInput() + "\n" + c2 + "^";
        },
        // test the lexed token: return FALSE when not a match, otherwise return token
        test_match: function(match, indexed_rule) {
          var token2, lines, backup;
          if (this.options.backtrack_lexer) {
            backup = {
              yylineno: this.yylineno,
              yylloc: {
                first_line: this.yylloc.first_line,
                last_line: this.last_line,
                first_column: this.yylloc.first_column,
                last_column: this.yylloc.last_column
              },
              yytext: this.yytext,
              match: this.match,
              matches: this.matches,
              matched: this.matched,
              yyleng: this.yyleng,
              offset: this.offset,
              _more: this._more,
              _input: this._input,
              yy: this.yy,
              conditionStack: this.conditionStack.slice(0),
              done: this.done
            };
            if (this.options.ranges) {
              backup.yylloc.range = this.yylloc.range.slice(0);
            }
          }
          lines = match[0].match(/(?:\r\n?|\n).*/g);
          if (lines) {
            this.yylineno += lines.length;
          }
          this.yylloc = {
            first_line: this.yylloc.last_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.last_column,
            last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length
          };
          this.yytext += match[0];
          this.match += match[0];
          this.matches = match;
          this.yyleng = this.yytext.length;
          if (this.options.ranges) {
            this.yylloc.range = [this.offset, this.offset += this.yyleng];
          }
          this._more = false;
          this._backtrack = false;
          this._input = this._input.slice(match[0].length);
          this.matched += match[0];
          token2 = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
          if (this.done && this._input) {
            this.done = false;
          }
          if (token2) {
            return token2;
          } else if (this._backtrack) {
            for (var k in backup) {
              this[k] = backup[k];
            }
            return false;
          }
          return false;
        },
        // return next match in input
        next: function() {
          if (this.done) {
            return this.EOF;
          }
          if (!this._input) {
            this.done = true;
          }
          var token2, match, tempMatch, index2;
          if (!this._more) {
            this.yytext = "";
            this.match = "";
          }
          var rules = this._currentRules();
          for (var i2 = 0; i2 < rules.length; i2++) {
            tempMatch = this._input.match(this.rules[rules[i2]]);
            if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
              match = tempMatch;
              index2 = i2;
              if (this.options.backtrack_lexer) {
                token2 = this.test_match(tempMatch, rules[i2]);
                if (token2 !== false) {
                  return token2;
                } else if (this._backtrack) {
                  match = false;
                  continue;
                } else {
                  return false;
                }
              } else if (!this.options.flex) {
                break;
              }
            }
          }
          if (match) {
            token2 = this.test_match(match, rules[index2]);
            if (token2 !== false) {
              return token2;
            }
            return false;
          }
          if (this._input === "") {
            return this.EOF;
          } else {
            return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {
              text: "",
              token: null,
              line: this.yylineno
            });
          }
        },
        // return next match that has a token
        lex: function lex2() {
          var r = this.next();
          if (r) {
            return r;
          } else {
            return this.lex();
          }
        },
        // activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
        begin: function begin(condition) {
          this.conditionStack.push(condition);
        },
        // pop the previously active lexer condition state off the condition stack
        popState: function popState() {
          var n = this.conditionStack.length - 1;
          if (n > 0) {
            return this.conditionStack.pop();
          } else {
            return this.conditionStack[0];
          }
        },
        // produce the lexer rule set which is active for the currently active lexer condition state
        _currentRules: function _currentRules() {
          if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
            return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
          } else {
            return this.conditions["INITIAL"].rules;
          }
        },
        // return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
        topState: function topState(n) {
          n = this.conditionStack.length - 1 - Math.abs(n || 0);
          if (n >= 0) {
            return this.conditionStack[n];
          } else {
            return "INITIAL";
          }
        },
        // alias for begin(condition)
        pushState: function pushState(condition) {
          this.begin(condition);
        },
        // return the number of states currently on the stack
        stateStackSize: function stateStackSize() {
          return this.conditionStack.length;
        },
        options: {},
        performAction: function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
          switch ($avoiding_name_collisions) {
            case 0:
              return 6;
            case 1:
              return 7;
            case 2:
              return 8;
            case 3:
              return 9;
            case 4:
              return 22;
            case 5:
              return 23;
            case 6:
              this.begin("acc_title");
              return 24;
            case 7:
              this.popState();
              return "acc_title_value";
            case 8:
              this.begin("acc_descr");
              return 26;
            case 9:
              this.popState();
              return "acc_descr_value";
            case 10:
              this.begin("acc_descr_multiline");
              break;
            case 11:
              this.popState();
              break;
            case 12:
              return "acc_descr_multiline_value";
            case 13:
              break;
            case 14:
              c;
              break;
            case 15:
              return 12;
            case 16:
              break;
            case 17:
              return 11;
            case 18:
              return 15;
            case 19:
              return 16;
            case 20:
              return 17;
            case 21:
              return 18;
            case 22:
              this.begin("person_ext");
              return 45;
            case 23:
              this.begin("person");
              return 44;
            case 24:
              this.begin("system_ext_queue");
              return 51;
            case 25:
              this.begin("system_ext_db");
              return 50;
            case 26:
              this.begin("system_ext");
              return 49;
            case 27:
              this.begin("system_queue");
              return 48;
            case 28:
              this.begin("system_db");
              return 47;
            case 29:
              this.begin("system");
              return 46;
            case 30:
              this.begin("boundary");
              return 37;
            case 31:
              this.begin("enterprise_boundary");
              return 34;
            case 32:
              this.begin("system_boundary");
              return 36;
            case 33:
              this.begin("container_ext_queue");
              return 57;
            case 34:
              this.begin("container_ext_db");
              return 56;
            case 35:
              this.begin("container_ext");
              return 55;
            case 36:
              this.begin("container_queue");
              return 54;
            case 37:
              this.begin("container_db");
              return 53;
            case 38:
              this.begin("container");
              return 52;
            case 39:
              this.begin("container_boundary");
              return 38;
            case 40:
              this.begin("component_ext_queue");
              return 63;
            case 41:
              this.begin("component_ext_db");
              return 62;
            case 42:
              this.begin("component_ext");
              return 61;
            case 43:
              this.begin("component_queue");
              return 60;
            case 44:
              this.begin("component_db");
              return 59;
            case 45:
              this.begin("component");
              return 58;
            case 46:
              this.begin("node");
              return 39;
            case 47:
              this.begin("node");
              return 39;
            case 48:
              this.begin("node_l");
              return 40;
            case 49:
              this.begin("node_r");
              return 41;
            case 50:
              this.begin("rel");
              return 64;
            case 51:
              this.begin("birel");
              return 65;
            case 52:
              this.begin("rel_u");
              return 66;
            case 53:
              this.begin("rel_u");
              return 66;
            case 54:
              this.begin("rel_d");
              return 67;
            case 55:
              this.begin("rel_d");
              return 67;
            case 56:
              this.begin("rel_l");
              return 68;
            case 57:
              this.begin("rel_l");
              return 68;
            case 58:
              this.begin("rel_r");
              return 69;
            case 59:
              this.begin("rel_r");
              return 69;
            case 60:
              this.begin("rel_b");
              return 70;
            case 61:
              this.begin("rel_index");
              return 71;
            case 62:
              this.begin("update_el_style");
              return 72;
            case 63:
              this.begin("update_rel_style");
              return 73;
            case 64:
              this.begin("update_layout_config");
              return 74;
            case 65:
              return "EOF_IN_STRUCT";
            case 66:
              this.begin("attribute");
              return "ATTRIBUTE_EMPTY";
            case 67:
              this.begin("attribute");
              break;
            case 68:
              this.popState();
              this.popState();
              break;
            case 69:
              return 80;
            case 70:
              break;
            case 71:
              return 80;
            case 72:
              this.begin("string");
              break;
            case 73:
              this.popState();
              break;
            case 74:
              return "STR";
            case 75:
              this.begin("string_kv");
              break;
            case 76:
              this.begin("string_kv_key");
              return "STR_KEY";
            case 77:
              this.popState();
              this.begin("string_kv_value");
              break;
            case 78:
              return "STR_VALUE";
            case 79:
              this.popState();
              this.popState();
              break;
            case 80:
              return "STR";
            case 81:
              return "LBRACE";
            case 82:
              return "RBRACE";
            case 83:
              return "SPACE";
            case 84:
              return "EOL";
            case 85:
              return 14;
          }
        },
        rules: [/^(?:.*direction\s+TB[^\n]*)/, /^(?:.*direction\s+BT[^\n]*)/, /^(?:.*direction\s+RL[^\n]*)/, /^(?:.*direction\s+LR[^\n]*)/, /^(?:title\s[^#\n;]+)/, /^(?:accDescription\s[^#\n;]+)/, /^(?:accTitle\s*:\s*)/, /^(?:(?!\n||)*[^\n]*)/, /^(?:accDescr\s*:\s*)/, /^(?:(?!\n||)*[^\n]*)/, /^(?:accDescr\s*\{\s*)/, /^(?:[\}])/, /^(?:[^\}]*)/, /^(?:%%(?!\{)*[^\n]*(\r?\n?)+)/, /^(?:%%[^\n]*(\r?\n)*)/, /^(?:\s*(\r?\n)+)/, /^(?:\s+)/, /^(?:C4Context\b)/, /^(?:C4Container\b)/, /^(?:C4Component\b)/, /^(?:C4Dynamic\b)/, /^(?:C4Deployment\b)/, /^(?:Person_Ext\b)/, /^(?:Person\b)/, /^(?:SystemQueue_Ext\b)/, /^(?:SystemDb_Ext\b)/, /^(?:System_Ext\b)/, /^(?:SystemQueue\b)/, /^(?:SystemDb\b)/, /^(?:System\b)/, /^(?:Boundary\b)/, /^(?:Enterprise_Boundary\b)/, /^(?:System_Boundary\b)/, /^(?:ContainerQueue_Ext\b)/, /^(?:ContainerDb_Ext\b)/, /^(?:Container_Ext\b)/, /^(?:ContainerQueue\b)/, /^(?:ContainerDb\b)/, /^(?:Container\b)/, /^(?:Container_Boundary\b)/, /^(?:ComponentQueue_Ext\b)/, /^(?:ComponentDb_Ext\b)/, /^(?:Component_Ext\b)/, /^(?:ComponentQueue\b)/, /^(?:ComponentDb\b)/, /^(?:Component\b)/, /^(?:Deployment_Node\b)/, /^(?:Node\b)/, /^(?:Node_L\b)/, /^(?:Node_R\b)/, /^(?:Rel\b)/, /^(?:BiRel\b)/, /^(?:Rel_Up\b)/, /^(?:Rel_U\b)/, /^(?:Rel_Down\b)/, /^(?:Rel_D\b)/, /^(?:Rel_Left\b)/, /^(?:Rel_L\b)/, /^(?:Rel_Right\b)/, /^(?:Rel_R\b)/, /^(?:Rel_Back\b)/, /^(?:RelIndex\b)/, /^(?:UpdateElementStyle\b)/, /^(?:UpdateRelStyle\b)/, /^(?:UpdateLayoutConfig\b)/, /^(?:$)/, /^(?:[(][ ]*[,])/, /^(?:[(])/, /^(?:[)])/, /^(?:,,)/, /^(?:,)/, /^(?:[ ]*["]["])/, /^(?:[ ]*["])/, /^(?:["])/, /^(?:[^"]*)/, /^(?:[ ]*[\$])/, /^(?:[^=]*)/, /^(?:[=][ ]*["])/, /^(?:[^"]+)/, /^(?:["])/, /^(?:[^,]+)/, /^(?:\{)/, /^(?:\})/, /^(?:[\s]+)/, /^(?:[\n\r]+)/, /^(?:$)/],
        conditions: { "acc_descr_multiline": { "rules": [11, 12], "inclusive": false }, "acc_descr": { "rules": [9], "inclusive": false }, "acc_title": { "rules": [7], "inclusive": false }, "string_kv_value": { "rules": [78, 79], "inclusive": false }, "string_kv_key": { "rules": [77], "inclusive": false }, "string_kv": { "rules": [76], "inclusive": false }, "string": { "rules": [73, 74], "inclusive": false }, "attribute": { "rules": [68, 69, 70, 71, 72, 75, 80], "inclusive": false }, "update_layout_config": { "rules": [65, 66, 67, 68], "inclusive": false }, "update_rel_style": { "rules": [65, 66, 67, 68], "inclusive": false }, "update_el_style": { "rules": [65, 66, 67, 68], "inclusive": false }, "rel_b": { "rules": [65, 66, 67, 68], "inclusive": false }, "rel_r": { "rules": [65, 66, 67, 68], "inclusive": false }, "rel_l": { "rules": [65, 66, 67, 68], "inclusive": false }, "rel_d": { "rules": [65, 66, 67, 68], "inclusive": false }, "rel_u": { "rules": [65, 66, 67, 68], "inclusive": false }, "rel_bi": { "rules": [], "inclusive": false }, "rel": { "rules": [65, 66, 67, 68], "inclusive": false }, "node_r": { "rules": [65, 66, 67, 68], "inclusive": false }, "node_l": { "rules": [65, 66, 67, 68], "inclusive": false }, "node": { "rules": [65, 66, 67, 68], "inclusive": false }, "index": { "rules": [], "inclusive": false }, "rel_index": { "rules": [65, 66, 67, 68], "inclusive": false }, "component_ext_queue": { "rules": [], "inclusive": false }, "component_ext_db": { "rules": [65, 66, 67, 68], "inclusive": false }, "component_ext": { "rules": [65, 66, 67, 68], "inclusive": false }, "component_queue": { "rules": [65, 66, 67, 68], "inclusive": false }, "component_db": { "rules": [65, 66, 67, 68], "inclusive": false }, "component": { "rules": [65, 66, 67, 68], "inclusive": false }, "container_boundary": { "rules": [65, 66, 67, 68], "inclusive": false }, "container_ext_queue": { "rules": [65, 66, 67, 68], "inclusive": false }, "container_ext_db": { "rules": [65, 66, 67, 68], "inclusive": false }, "container_ext": { "rules": [65, 66, 67, 68], "inclusive": false }, "container_queue": { "rules": [65, 66, 67, 68], "inclusive": false }, "container_db": { "rules": [65, 66, 67, 68], "inclusive": false }, "container": { "rules": [65, 66, 67, 68], "inclusive": false }, "birel": { "rules": [65, 66, 67, 68], "inclusive": false }, "system_boundary": { "rules": [65, 66, 67, 68], "inclusive": false }, "enterprise_boundary": { "rules": [65, 66, 67, 68], "inclusive": false }, "boundary": { "rules": [65, 66, 67, 68], "inclusive": false }, "system_ext_queue": { "rules": [65, 66, 67, 68], "inclusive": false }, "system_ext_db": { "rules": [65, 66, 67, 68], "inclusive": false }, "system_ext": { "rules": [65, 66, 67, 68], "inclusive": false }, "system_queue": { "rules": [65, 66, 67, 68], "inclusive": false }, "system_db": { "rules": [65, 66, 67, 68], "inclusive": false }, "system": { "rules": [65, 66, 67, 68], "inclusive": false }, "person_ext": { "rules": [65, 66, 67, 68], "inclusive": false }, "person": { "rules": [65, 66, 67, 68], "inclusive": false }, "INITIAL": { "rules": [0, 1, 2, 3, 4, 5, 6, 8, 10, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 81, 82, 83, 84, 85], "inclusive": true } }
      };
      return lexer2;
    }();
    parser2.lexer = lexer;
    function Parser() {
      this.yy = {};
    }
    Parser.prototype = parser2;
    parser2.Parser = Parser;
    return new Parser();
  }();
  parser$v.parser = parser$v;
  const parser$w = parser$v;
  let c4ShapeArray = [];
  let boundaryParseStack = [""];
  let currentBoundaryParse = "global";
  let parentBoundaryParse = "";
  let boundarys = [
    {
      alias: "global",
      label: { text: "global" },
      type: { text: "global" },
      tags: null,
      link: null,
      parentBoundary: ""
    }
  ];
  let rels = [];
  let title = "";
  let wrapEnabled = false;
  let c4ShapeInRow$1 = 4;
  let c4BoundaryInRow$1 = 2;
  var c4Type;
  const getC4Type = function() {
    return c4Type;
  };
  const setC4Type = function(c4TypeParam) {
    let sanitizedText = sanitizeText$5(c4TypeParam, getConfig$1());
    c4Type = sanitizedText;
  };
  const addRel = function(type2, from2, to, label, techn, descr, sprite, tags2, link2) {
    if (type2 === void 0 || type2 === null || from2 === void 0 || from2 === null || to === void 0 || to === null || label === void 0 || label === null) {
      return;
    }
    let rel = {};
    const old = rels.find((rel2) => rel2.from === from2 && rel2.to === to);
    if (old) {
      rel = old;
    } else {
      rels.push(rel);
    }
    rel.type = type2;
    rel.from = from2;
    rel.to = to;
    rel.label = { text: label };
    if (techn === void 0 || techn === null) {
      rel.techn = { text: "" };
    } else {
      if (typeof techn === "object") {
        let [key, value2] = Object.entries(techn)[0];
        rel[key] = { text: value2 };
      } else {
        rel.techn = { text: techn };
      }
    }
    if (descr === void 0 || descr === null) {
      rel.descr = { text: "" };
    } else {
      if (typeof descr === "object") {
        let [key, value2] = Object.entries(descr)[0];
        rel[key] = { text: value2 };
      } else {
        rel.descr = { text: descr };
      }
    }
    if (typeof sprite === "object") {
      let [key, value2] = Object.entries(sprite)[0];
      rel[key] = value2;
    } else {
      rel.sprite = sprite;
    }
    if (typeof tags2 === "object") {
      let [key, value2] = Object.entries(tags2)[0];
      rel[key] = value2;
    } else {
      rel.tags = tags2;
    }
    if (typeof link2 === "object") {
      let [key, value2] = Object.entries(link2)[0];
      rel[key] = value2;
    } else {
      rel.link = link2;
    }
    rel.wrap = autoWrap$1();
  };
  const addPersonOrSystem = function(typeC4Shape, alias, label, descr, sprite, tags2, link2) {
    if (alias === null || label === null) {
      return;
    }
    let personOrSystem = {};
    const old = c4ShapeArray.find((personOrSystem2) => personOrSystem2.alias === alias);
    if (old && alias === old.alias) {
      personOrSystem = old;
    } else {
      personOrSystem.alias = alias;
      c4ShapeArray.push(personOrSystem);
    }
    if (label === void 0 || label === null) {
      personOrSystem.label = { text: "" };
    } else {
      personOrSystem.label = { text: label };
    }
    if (descr === void 0 || descr === null) {
      personOrSystem.descr = { text: "" };
    } else {
      if (typeof descr === "object") {
        let [key, value2] = Object.entries(descr)[0];
        personOrSystem[key] = { text: value2 };
      } else {
        personOrSystem.descr = { text: descr };
      }
    }
    if (typeof sprite === "object") {
      let [key, value2] = Object.entries(sprite)[0];
      personOrSystem[key] = value2;
    } else {
      personOrSystem.sprite = sprite;
    }
    if (typeof tags2 === "object") {
      let [key, value2] = Object.entries(tags2)[0];
      personOrSystem[key] = value2;
    } else {
      personOrSystem.tags = tags2;
    }
    if (typeof link2 === "object") {
      let [key, value2] = Object.entries(link2)[0];
      personOrSystem[key] = value2;
    } else {
      personOrSystem.link = link2;
    }
    personOrSystem.typeC4Shape = { text: typeC4Shape };
    personOrSystem.parentBoundary = currentBoundaryParse;
    personOrSystem.wrap = autoWrap$1();
  };
  const addContainer = function(typeC4Shape, alias, label, techn, descr, sprite, tags2, link2) {
    if (alias === null || label === null) {
      return;
    }
    let container = {};
    const old = c4ShapeArray.find((container2) => container2.alias === alias);
    if (old && alias === old.alias) {
      container = old;
    } else {
      container.alias = alias;
      c4ShapeArray.push(container);
    }
    if (label === void 0 || label === null) {
      container.label = { text: "" };
    } else {
      container.label = { text: label };
    }
    if (techn === void 0 || techn === null) {
      container.techn = { text: "" };
    } else {
      if (typeof techn === "object") {
        let [key, value2] = Object.entries(techn)[0];
        container[key] = { text: value2 };
      } else {
        container.techn = { text: techn };
      }
    }
    if (descr === void 0 || descr === null) {
      container.descr = { text: "" };
    } else {
      if (typeof descr === "object") {
        let [key, value2] = Object.entries(descr)[0];
        container[key] = { text: value2 };
      } else {
        container.descr = { text: descr };
      }
    }
    if (typeof sprite === "object") {
      let [key, value2] = Object.entries(sprite)[0];
      container[key] = value2;
    } else {
      container.sprite = sprite;
    }
    if (typeof tags2 === "object") {
      let [key, value2] = Object.entries(tags2)[0];
      container[key] = value2;
    } else {
      container.tags = tags2;
    }
    if (typeof link2 === "object") {
      let [key, value2] = Object.entries(link2)[0];
      container[key] = value2;
    } else {
      container.link = link2;
    }
    container.wrap = autoWrap$1();
    container.typeC4Shape = { text: typeC4Shape };
    container.parentBoundary = currentBoundaryParse;
  };
  const addComponent = function(typeC4Shape, alias, label, techn, descr, sprite, tags2, link2) {
    if (alias === null || label === null) {
      return;
    }
    let component = {};
    const old = c4ShapeArray.find((component2) => component2.alias === alias);
    if (old && alias === old.alias) {
      component = old;
    } else {
      component.alias = alias;
      c4ShapeArray.push(component);
    }
    if (label === void 0 || label === null) {
      component.label = { text: "" };
    } else {
      component.label = { text: label };
    }
    if (techn === void 0 || techn === null) {
      component.techn = { text: "" };
    } else {
      if (typeof techn === "object") {
        let [key, value2] = Object.entries(techn)[0];
        component[key] = { text: value2 };
      } else {
        component.techn = { text: techn };
      }
    }
    if (descr === void 0 || descr === null) {
      component.descr = { text: "" };
    } else {
      if (typeof descr === "object") {
        let [key, value2] = Object.entries(descr)[0];
        component[key] = { text: value2 };
      } else {
        component.descr = { text: descr };
      }
    }
    if (typeof sprite === "object") {
      let [key, value2] = Object.entries(sprite)[0];
      component[key] = value2;
    } else {
      component.sprite = sprite;
    }
    if (typeof tags2 === "object") {
      let [key, value2] = Object.entries(tags2)[0];
      component[key] = value2;
    } else {
      component.tags = tags2;
    }
    if (typeof link2 === "object") {
      let [key, value2] = Object.entries(link2)[0];
      component[key] = value2;
    } else {
      component.link = link2;
    }
    component.wrap = autoWrap$1();
    component.typeC4Shape = { text: typeC4Shape };
    component.parentBoundary = currentBoundaryParse;
  };
  const addPersonOrSystemBoundary = function(alias, label, type2, tags2, link2) {
    if (alias === null || label === null) {
      return;
    }
    let boundary = {};
    const old = boundarys.find((boundary2) => boundary2.alias === alias);
    if (old && alias === old.alias) {
      boundary = old;
    } else {
      boundary.alias = alias;
      boundarys.push(boundary);
    }
    if (label === void 0 || label === null) {
      boundary.label = { text: "" };
    } else {
      boundary.label = { text: label };
    }
    if (type2 === void 0 || type2 === null) {
      boundary.type = { text: "system" };
    } else {
      if (typeof type2 === "object") {
        let [key, value2] = Object.entries(type2)[0];
        boundary[key] = { text: value2 };
      } else {
        boundary.type = { text: type2 };
      }
    }
    if (typeof tags2 === "object") {
      let [key, value2] = Object.entries(tags2)[0];
      boundary[key] = value2;
    } else {
      boundary.tags = tags2;
    }
    if (typeof link2 === "object") {
      let [key, value2] = Object.entries(link2)[0];
      boundary[key] = value2;
    } else {
      boundary.link = link2;
    }
    boundary.parentBoundary = currentBoundaryParse;
    boundary.wrap = autoWrap$1();
    parentBoundaryParse = currentBoundaryParse;
    currentBoundaryParse = alias;
    boundaryParseStack.push(parentBoundaryParse);
  };
  const addContainerBoundary = function(alias, label, type2, tags2, link2) {
    if (alias === null || label === null) {
      return;
    }
    let boundary = {};
    const old = boundarys.find((boundary2) => boundary2.alias === alias);
    if (old && alias === old.alias) {
      boundary = old;
    } else {
      boundary.alias = alias;
      boundarys.push(boundary);
    }
    if (label === void 0 || label === null) {
      boundary.label = { text: "" };
    } else {
      boundary.label = { text: label };
    }
    if (type2 === void 0 || type2 === null) {
      boundary.type = { text: "container" };
    } else {
      if (typeof type2 === "object") {
        let [key, value2] = Object.entries(type2)[0];
        boundary[key] = { text: value2 };
      } else {
        boundary.type = { text: type2 };
      }
    }
    if (typeof tags2 === "object") {
      let [key, value2] = Object.entries(tags2)[0];
      boundary[key] = value2;
    } else {
      boundary.tags = tags2;
    }
    if (typeof link2 === "object") {
      let [key, value2] = Object.entries(link2)[0];
      boundary[key] = value2;
    } else {
      boundary.link = link2;
    }
    boundary.parentBoundary = currentBoundaryParse;
    boundary.wrap = autoWrap$1();
    parentBoundaryParse = currentBoundaryParse;
    currentBoundaryParse = alias;
    boundaryParseStack.push(parentBoundaryParse);
  };
  const addDeploymentNode = function(nodeType2, alias, label, type2, descr, sprite, tags2, link2) {
    if (alias === null || label === null) {
      return;
    }
    let boundary = {};
    const old = boundarys.find((boundary2) => boundary2.alias === alias);
    if (old && alias === old.alias) {
      boundary = old;
    } else {
      boundary.alias = alias;
      boundarys.push(boundary);
    }
    if (label === void 0 || label === null) {
      boundary.label = { text: "" };
    } else {
      boundary.label = { text: label };
    }
    if (type2 === void 0 || type2 === null) {
      boundary.type = { text: "node" };
    } else {
      if (typeof type2 === "object") {
        let [key, value2] = Object.entries(type2)[0];
        boundary[key] = { text: value2 };
      } else {
        boundary.type = { text: type2 };
      }
    }
    if (descr === void 0 || descr === null) {
      boundary.descr = { text: "" };
    } else {
      if (typeof descr === "object") {
        let [key, value2] = Object.entries(descr)[0];
        boundary[key] = { text: value2 };
      } else {
        boundary.descr = { text: descr };
      }
    }
    if (typeof tags2 === "object") {
      let [key, value2] = Object.entries(tags2)[0];
      boundary[key] = value2;
    } else {
      boundary.tags = tags2;
    }
    if (typeof link2 === "object") {
      let [key, value2] = Object.entries(link2)[0];
      boundary[key] = value2;
    } else {
      boundary.link = link2;
    }
    boundary.nodeType = nodeType2;
    boundary.parentBoundary = currentBoundaryParse;
    boundary.wrap = autoWrap$1();
    parentBoundaryParse = currentBoundaryParse;
    currentBoundaryParse = alias;
    boundaryParseStack.push(parentBoundaryParse);
  };
  const popBoundaryParseStack = function() {
    currentBoundaryParse = parentBoundaryParse;
    boundaryParseStack.pop();
    parentBoundaryParse = boundaryParseStack.pop();
    boundaryParseStack.push(parentBoundaryParse);
  };
  const updateElStyle = function(typeC4Shape, elementName, bgColor, fontColor, borderColor, shadowing, shape, sprite, techn, legendText, legendSprite) {
    let old = c4ShapeArray.find((element2) => element2.alias === elementName);
    if (old === void 0) {
      old = boundarys.find((element2) => element2.alias === elementName);
      if (old === void 0) {
        return;
      }
    }
    if (bgColor !== void 0 && bgColor !== null) {
      if (typeof bgColor === "object") {
        let [key, value2] = Object.entries(bgColor)[0];
        old[key] = value2;
      } else {
        old.bgColor = bgColor;
      }
    }
    if (fontColor !== void 0 && fontColor !== null) {
      if (typeof fontColor === "object") {
        let [key, value2] = Object.entries(fontColor)[0];
        old[key] = value2;
      } else {
        old.fontColor = fontColor;
      }
    }
    if (borderColor !== void 0 && borderColor !== null) {
      if (typeof borderColor === "object") {
        let [key, value2] = Object.entries(borderColor)[0];
        old[key] = value2;
      } else {
        old.borderColor = borderColor;
      }
    }
    if (shadowing !== void 0 && shadowing !== null) {
      if (typeof shadowing === "object") {
        let [key, value2] = Object.entries(shadowing)[0];
        old[key] = value2;
      } else {
        old.shadowing = shadowing;
      }
    }
    if (shape !== void 0 && shape !== null) {
      if (typeof shape === "object") {
        let [key, value2] = Object.entries(shape)[0];
        old[key] = value2;
      } else {
        old.shape = shape;
      }
    }
    if (sprite !== void 0 && sprite !== null) {
      if (typeof sprite === "object") {
        let [key, value2] = Object.entries(sprite)[0];
        old[key] = value2;
      } else {
        old.sprite = sprite;
      }
    }
    if (techn !== void 0 && techn !== null) {
      if (typeof techn === "object") {
        let [key, value2] = Object.entries(techn)[0];
        old[key] = value2;
      } else {
        old.techn = techn;
      }
    }
    if (legendText !== void 0 && legendText !== null) {
      if (typeof legendText === "object") {
        let [key, value2] = Object.entries(legendText)[0];
        old[key] = value2;
      } else {
        old.legendText = legendText;
      }
    }
    if (legendSprite !== void 0 && legendSprite !== null) {
      if (typeof legendSprite === "object") {
        let [key, value2] = Object.entries(legendSprite)[0];
        old[key] = value2;
      } else {
        old.legendSprite = legendSprite;
      }
    }
  };
  const updateRelStyle = function(typeC4Shape, from2, to, textColor, lineColor, offsetX, offsetY) {
    const old = rels.find((rel) => rel.from === from2 && rel.to === to);
    if (old === void 0) {
      return;
    }
    if (textColor !== void 0 && textColor !== null) {
      if (typeof textColor === "object") {
        let [key, value2] = Object.entries(textColor)[0];
        old[key] = value2;
      } else {
        old.textColor = textColor;
      }
    }
    if (lineColor !== void 0 && lineColor !== null) {
      if (typeof lineColor === "object") {
        let [key, value2] = Object.entries(lineColor)[0];
        old[key] = value2;
      } else {
        old.lineColor = lineColor;
      }
    }
    if (offsetX !== void 0 && offsetX !== null) {
      if (typeof offsetX === "object") {
        let [key, value2] = Object.entries(offsetX)[0];
        old[key] = parseInt(value2);
      } else {
        old.offsetX = parseInt(offsetX);
      }
    }
    if (offsetY !== void 0 && offsetY !== null) {
      if (typeof offsetY === "object") {
        let [key, value2] = Object.entries(offsetY)[0];
        old[key] = parseInt(value2);
      } else {
        old.offsetY = parseInt(offsetY);
      }
    }
  };
  const updateLayoutConfig = function(typeC4Shape, c4ShapeInRowParam, c4BoundaryInRowParam) {
    let c4ShapeInRowValue = c4ShapeInRow$1;
    let c4BoundaryInRowValue = c4BoundaryInRow$1;
    if (typeof c4ShapeInRowParam === "object") {
      const value2 = Object.values(c4ShapeInRowParam)[0];
      c4ShapeInRowValue = parseInt(value2);
    } else {
      c4ShapeInRowValue = parseInt(c4ShapeInRowParam);
    }
    if (typeof c4BoundaryInRowParam === "object") {
      const value2 = Object.values(c4BoundaryInRowParam)[0];
      c4BoundaryInRowValue = parseInt(value2);
    } else {
      c4BoundaryInRowValue = parseInt(c4BoundaryInRowParam);
    }
    if (c4ShapeInRowValue >= 1) {
      c4ShapeInRow$1 = c4ShapeInRowValue;
    }
    if (c4BoundaryInRowValue >= 1) {
      c4BoundaryInRow$1 = c4BoundaryInRowValue;
    }
  };
  const getC4ShapeInRow = function() {
    return c4ShapeInRow$1;
  };
  const getC4BoundaryInRow = function() {
    return c4BoundaryInRow$1;
  };
  const getCurrentBoundaryParse = function() {
    return currentBoundaryParse;
  };
  const getParentBoundaryParse = function() {
    return parentBoundaryParse;
  };
  const getC4ShapeArray = function(parentBoundary) {
    if (parentBoundary === void 0 || parentBoundary === null) {
      return c4ShapeArray;
    } else {
      return c4ShapeArray.filter((personOrSystem) => {
        return personOrSystem.parentBoundary === parentBoundary;
      });
    }
  };
  const getC4Shape = function(alias) {
    return c4ShapeArray.find((personOrSystem) => personOrSystem.alias === alias);
  };
  const getC4ShapeKeys = function(parentBoundary) {
    return Object.keys(getC4ShapeArray(parentBoundary));
  };
  const getBoundarys = function(parentBoundary) {
    if (parentBoundary === void 0 || parentBoundary === null) {
      return boundarys;
    } else {
      return boundarys.filter((boundary) => boundary.parentBoundary === parentBoundary);
    }
  };
  const getRels = function() {
    return rels;
  };
  const getTitle = function() {
    return title;
  };
  const setWrap$1 = function(wrapSetting) {
    wrapEnabled = wrapSetting;
  };
  const autoWrap$1 = function() {
    return wrapEnabled;
  };
  const clear$m = function() {
    c4ShapeArray = [];
    boundarys = [
      {
        alias: "global",
        label: { text: "global" },
        type: { text: "global" },
        tags: null,
        link: null,
        parentBoundary: ""
      }
    ];
    parentBoundaryParse = "";
    currentBoundaryParse = "global";
    boundaryParseStack = [""];
    rels = [];
    boundaryParseStack = [""];
    title = "";
    wrapEnabled = false;
    c4ShapeInRow$1 = 4;
    c4BoundaryInRow$1 = 2;
  };
  const LINETYPE$1 = {
    SOLID: 0,
    DOTTED: 1,
    NOTE: 2,
    SOLID_CROSS: 3,
    DOTTED_CROSS: 4,
    SOLID_OPEN: 5,
    DOTTED_OPEN: 6,
    LOOP_START: 10,
    LOOP_END: 11,
    ALT_START: 12,
    ALT_ELSE: 13,
    ALT_END: 14,
    OPT_START: 15,
    OPT_END: 16,
    ACTIVE_START: 17,
    ACTIVE_END: 18,
    PAR_START: 19,
    PAR_AND: 20,
    PAR_END: 21,
    RECT_START: 22,
    RECT_END: 23,
    SOLID_POINT: 24,
    DOTTED_POINT: 25
  };
  const ARROWTYPE$1 = {
    FILLED: 0,
    OPEN: 1
  };
  const PLACEMENT$1 = {
    LEFTOF: 0,
    RIGHTOF: 1,
    OVER: 2
  };
  const setTitle = function(txt) {
    let sanitizedText = sanitizeText$5(txt, getConfig$1());
    title = sanitizedText;
  };
  const db$g = {
    addPersonOrSystem,
    addPersonOrSystemBoundary,
    addContainer,
    addContainerBoundary,
    addComponent,
    addDeploymentNode,
    popBoundaryParseStack,
    addRel,
    updateElStyle,
    updateRelStyle,
    updateLayoutConfig,
    autoWrap: autoWrap$1,
    setWrap: setWrap$1,
    getC4ShapeArray,
    getC4Shape,
    getC4ShapeKeys,
    getBoundarys,
    getCurrentBoundaryParse,
    getParentBoundaryParse,
    getRels,
    getTitle,
    getC4Type,
    getC4ShapeInRow,
    getC4BoundaryInRow,
    setAccTitle,
    getAccTitle,
    getAccDescription,
    setAccDescription,
    getConfig: () => getConfig$1().c4,
    clear: clear$m,
    LINETYPE: LINETYPE$1,
    ARROWTYPE: ARROWTYPE$1,
    PLACEMENT: PLACEMENT$1,
    setTitle,
    setC4Type
    // apply,
  };
  const drawRect$4 = (element2, rectData) => {
    const rectElement = element2.append("rect");
    rectElement.attr("x", rectData.x);
    rectElement.attr("y", rectData.y);
    rectElement.attr("fill", rectData.fill);
    rectElement.attr("stroke", rectData.stroke);
    rectElement.attr("width", rectData.width);
    rectElement.attr("height", rectData.height);
    rectData.rx !== void 0 && rectElement.attr("rx", rectData.rx);
    rectData.ry !== void 0 && rectElement.attr("ry", rectData.ry);
    if (rectData.attrs !== void 0) {
      for (const attrKey in rectData.attrs) {
        rectElement.attr(attrKey, rectData.attrs[attrKey]);
      }
    }
    rectData.class !== void 0 && rectElement.attr("class", rectData.class);
    return rectElement;
  };
  const drawBackgroundRect$3 = (element2, bounds2) => {
    const rectData = {
      x: bounds2.startx,
      y: bounds2.starty,
      width: bounds2.stopx - bounds2.startx,
      height: bounds2.stopy - bounds2.starty,
      fill: bounds2.fill,
      stroke: bounds2.stroke,
      class: "rect"
    };
    const rectElement = drawRect$4(element2, rectData);
    rectElement.lower();
  };
  const drawText$4 = (element2, textData) => {
    const nText = textData.text.replace(lineBreakRegex, " ");
    const textElem = element2.append("text");
    textElem.attr("x", textData.x);
    textElem.attr("y", textData.y);
    textElem.attr("class", "legend");
    textElem.style("text-anchor", textData.anchor);
    textData.class !== void 0 && textElem.attr("class", textData.class);
    const tspan = textElem.append("tspan");
    tspan.attr("x", textData.x + textData.textMargin * 2);
    tspan.text(nText);
    return textElem;
  };
  const drawImage$1 = (elem, x2, y2, link2) => {
    const imageElement = elem.append("image");
    imageElement.attr("x", x2);
    imageElement.attr("y", y2);
    const sanitizedLink = sanitizeUrl_1(link2);
    imageElement.attr("xlink:href", sanitizedLink);
  };
  const drawEmbeddedImage = (element2, x2, y2, link2) => {
    const imageElement = element2.append("use");
    imageElement.attr("x", x2);
    imageElement.attr("y", y2);
    const sanitizedLink = sanitizeUrl_1(link2);
    imageElement.attr("xlink:href", `#${sanitizedLink}`);
  };
  const getNoteRect$2 = () => {
    const noteRectData = {
      x: 0,
      y: 0,
      width: 100,
      height: 100,
      fill: "#EDF2AE",
      stroke: "#666",
      anchor: "start",
      rx: 0,
      ry: 0
    };
    return noteRectData;
  };
  const getTextObj$2 = () => {
    const testObject = {
      x: 0,
      y: 0,
      width: 100,
      height: 100,
      "text-anchor": "start",
      style: "#666",
      textMargin: 0,
      rx: 0,
      ry: 0,
      tspan: true
    };
    return testObject;
  };
  const drawRect$3 = function(elem, rectData) {
    return drawRect$4(elem, rectData);
  };
  const drawImage = function(elem, width2, height, x2, y2, link2) {
    const imageElem = elem.append("image");
    imageElem.attr("width", width2);
    imageElem.attr("height", height);
    imageElem.attr("x", x2);
    imageElem.attr("y", y2);
    let sanitizedLink = link2.startsWith("data:image/png;base64") ? link2 : sanitizeUrl_1(link2);
    imageElem.attr("xlink:href", sanitizedLink);
  };
  const drawRels$1 = (elem, rels2, conf2) => {
    const relsElem = elem.append("g");
    let i2 = 0;
    for (let rel of rels2) {
      let textColor = rel.textColor ? rel.textColor : "#444444";
      let strokeColor = rel.lineColor ? rel.lineColor : "#444444";
      let offsetX = rel.offsetX ? parseInt(rel.offsetX) : 0;
      let offsetY = rel.offsetY ? parseInt(rel.offsetY) : 0;
      let url = "";
      if (i2 === 0) {
        let line2 = relsElem.append("line");
        line2.attr("x1", rel.startPoint.x);
        line2.attr("y1", rel.startPoint.y);
        line2.attr("x2", rel.endPoint.x);
        line2.attr("y2", rel.endPoint.y);
        line2.attr("stroke-width", "1");
        line2.attr("stroke", strokeColor);
        line2.style("fill", "none");
        if (rel.type !== "rel_b") {
          line2.attr("marker-end", "url(" + url + "#arrowhead)");
        }
        if (rel.type === "birel" || rel.type === "rel_b") {
          line2.attr("marker-start", "url(" + url + "#arrowend)");
        }
        i2 = -1;
      } else {
        let line2 = relsElem.append("path");
        line2.attr("fill", "none").attr("stroke-width", "1").attr("stroke", strokeColor).attr(
          "d",
          "Mstartx,starty Qcontrolx,controly stopx,stopy ".replaceAll("startx", rel.startPoint.x).replaceAll("starty", rel.startPoint.y).replaceAll(
            "controlx",
            rel.startPoint.x + (rel.endPoint.x - rel.startPoint.x) / 2 - (rel.endPoint.x - rel.startPoint.x) / 4
          ).replaceAll("controly", rel.startPoint.y + (rel.endPoint.y - rel.startPoint.y) / 2).replaceAll("stopx", rel.endPoint.x).replaceAll("stopy", rel.endPoint.y)
        );
        if (rel.type !== "rel_b") {
          line2.attr("marker-end", "url(" + url + "#arrowhead)");
        }
        if (rel.type === "birel" || rel.type === "rel_b") {
          line2.attr("marker-start", "url(" + url + "#arrowend)");
        }
      }
      let messageConf = conf2.messageFont();
      _drawTextCandidateFunc$3(conf2)(
        rel.label.text,
        relsElem,
        Math.min(rel.startPoint.x, rel.endPoint.x) + Math.abs(rel.endPoint.x - rel.startPoint.x) / 2 + offsetX,
        Math.min(rel.startPoint.y, rel.endPoint.y) + Math.abs(rel.endPoint.y - rel.startPoint.y) / 2 + offsetY,
        rel.label.width,
        rel.label.height,
        { fill: textColor },
        messageConf
      );
      if (rel.techn && rel.techn.text !== "") {
        messageConf = conf2.messageFont();
        _drawTextCandidateFunc$3(conf2)(
          "[" + rel.techn.text + "]",
          relsElem,
          Math.min(rel.startPoint.x, rel.endPoint.x) + Math.abs(rel.endPoint.x - rel.startPoint.x) / 2 + offsetX,
          Math.min(rel.startPoint.y, rel.endPoint.y) + Math.abs(rel.endPoint.y - rel.startPoint.y) / 2 + conf2.messageFontSize + 5 + offsetY,
          Math.max(rel.label.width, rel.techn.width),
          rel.techn.height,
          { fill: textColor, "font-style": "italic" },
          messageConf
        );
      }
    }
  };
  const drawBoundary$1 = function(elem, boundary, conf2) {
    const boundaryElem = elem.append("g");
    let fillColor = boundary.bgColor ? boundary.bgColor : "none";
    let strokeColor = boundary.borderColor ? boundary.borderColor : "#444444";
    let fontColor = boundary.fontColor ? boundary.fontColor : "black";
    let attrsValue = { "stroke-width": 1, "stroke-dasharray": "7.0,7.0" };
    if (boundary.nodeType) {
      attrsValue = { "stroke-width": 1 };
    }
    let rectData = {
      x: boundary.x,
      y: boundary.y,
      fill: fillColor,
      stroke: strokeColor,
      width: boundary.width,
      height: boundary.height,
      rx: 2.5,
      ry: 2.5,
      attrs: attrsValue
    };
    drawRect$3(boundaryElem, rectData);
    let boundaryConf = conf2.boundaryFont();
    boundaryConf.fontWeight = "bold";
    boundaryConf.fontSize = boundaryConf.fontSize + 2;
    boundaryConf.fontColor = fontColor;
    _drawTextCandidateFunc$3(conf2)(
      boundary.label.text,
      boundaryElem,
      boundary.x,
      boundary.y + boundary.label.Y,
      boundary.width,
      boundary.height,
      { fill: "#444444" },
      boundaryConf
    );
    if (boundary.type && boundary.type.text !== "") {
      boundaryConf = conf2.boundaryFont();
      boundaryConf.fontColor = fontColor;
      _drawTextCandidateFunc$3(conf2)(
        boundary.type.text,
        boundaryElem,
        boundary.x,
        boundary.y + boundary.type.Y,
        boundary.width,
        boundary.height,
        { fill: "#444444" },
        boundaryConf
      );
    }
    if (boundary.descr && boundary.descr.text !== "") {
      boundaryConf = conf2.boundaryFont();
      boundaryConf.fontSize = boundaryConf.fontSize - 2;
      boundaryConf.fontColor = fontColor;
      _drawTextCandidateFunc$3(conf2)(
        boundary.descr.text,
        boundaryElem,
        boundary.x,
        boundary.y + boundary.descr.Y,
        boundary.width,
        boundary.height,
        { fill: "#444444" },
        boundaryConf
      );
    }
  };
  const drawC4Shape = function(elem, c4Shape, conf2) {
    var _a2;
    let fillColor = c4Shape.bgColor ? c4Shape.bgColor : conf2[c4Shape.typeC4Shape.text + "_bg_color"];
    let strokeColor = c4Shape.borderColor ? c4Shape.borderColor : conf2[c4Shape.typeC4Shape.text + "_border_color"];
    let fontColor = c4Shape.fontColor ? c4Shape.fontColor : "#FFFFFF";
    let personImg = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAIAAADYYG7QAAACD0lEQVR4Xu2YoU4EMRCGT+4j8Ai8AhaH4QHgAUjQuFMECUgMIUgwJAgMhgQsAYUiJCiQIBBY+EITsjfTdme6V24v4c8vyGbb+ZjOtN0bNcvjQXmkH83WvYBWto6PLm6v7p7uH1/w2fXD+PBycX1Pv2l3IdDm/vn7x+dXQiAubRzoURa7gRZWd0iGRIiJbOnhnfYBQZNJjNbuyY2eJG8fkDE3bbG4ep6MHUAsgYxmE3nVs6VsBWJSGccsOlFPmLIViMzLOB7pCVO2AtHJMohH7Fh6zqitQK7m0rJvAVYgGcEpe//PLdDz65sM4pF9N7ICcXDKIB5Nv6j7tD0NoSdM2QrU9Gg0ewE1LqBhHR3BBdvj2vapnidjHxD/q6vd7Pvhr31AwcY8eXMTXAKECZZJFXuEq27aLgQK5uLMohCenGGuGewOxSjBvYBqeG6B+Nqiblggdjnc+ZXDy+FNFpFzw76O3UBAROuXh6FoiAcf5g9eTvUgzy0nWg6I8cXHRUpg5bOVBCo+KDpFajOf23GgPme7RSQ+lacIENUgJ6gg1k6HjgOlqnLqip4tEuhv0hNEMXUD0clyXE3p6pZA0S2nnvTlXwLJEZWlb7cTQH1+USgTN4VhAenm/wea1OCAOmqo6fE1WCb9WSKBah+rbUWPWAmE2Rvk0ApiB45eOyNAzU8xcTvj8KvkKEoOaIYeHNA3ZuygAvFMUO0AAAAASUVORK5CYII=";
    switch (c4Shape.typeC4Shape.text) {
      case "person":
        personImg = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAIAAADYYG7QAAACD0lEQVR4Xu2YoU4EMRCGT+4j8Ai8AhaH4QHgAUjQuFMECUgMIUgwJAgMhgQsAYUiJCiQIBBY+EITsjfTdme6V24v4c8vyGbb+ZjOtN0bNcvjQXmkH83WvYBWto6PLm6v7p7uH1/w2fXD+PBycX1Pv2l3IdDm/vn7x+dXQiAubRzoURa7gRZWd0iGRIiJbOnhnfYBQZNJjNbuyY2eJG8fkDE3bbG4ep6MHUAsgYxmE3nVs6VsBWJSGccsOlFPmLIViMzLOB7pCVO2AtHJMohH7Fh6zqitQK7m0rJvAVYgGcEpe//PLdDz65sM4pF9N7ICcXDKIB5Nv6j7tD0NoSdM2QrU9Gg0ewE1LqBhHR3BBdvj2vapnidjHxD/q6vd7Pvhr31AwcY8eXMTXAKECZZJFXuEq27aLgQK5uLMohCenGGuGewOxSjBvYBqeG6B+Nqiblggdjnc+ZXDy+FNFpFzw76O3UBAROuXh6FoiAcf5g9eTvUgzy0nWg6I8cXHRUpg5bOVBCo+KDpFajOf23GgPme7RSQ+lacIENUgJ6gg1k6HjgOlqnLqip4tEuhv0hNEMXUD0clyXE3p6pZA0S2nnvTlXwLJEZWlb7cTQH1+USgTN4VhAenm/wea1OCAOmqo6fE1WCb9WSKBah+rbUWPWAmE2Rvk0ApiB45eOyNAzU8xcTvj8KvkKEoOaIYeHNA3ZuygAvFMUO0AAAAASUVORK5CYII=";
        break;
      case "external_person":
        personImg = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAwCAIAAADYYG7QAAAB6ElEQVR4Xu2YLY+EMBCG9+dWr0aj0Wg0Go1Go0+j8Xdv2uTCvv1gpt0ebHKPuhDaeW4605Z9mJvx4AdXUyTUdd08z+u6flmWZRnHsWkafk9DptAwDPu+f0eAYtu2PEaGWuj5fCIZrBAC2eLBAnRCsEkkxmeaJp7iDJ2QMDdHsLg8SxKFEJaAo8lAXnmuOFIhTMpxxKATebo4UiFknuNo4OniSIXQyRxEA3YsnjGCVEjVXD7yLUAqxBGUyPv/Y4W2beMgGuS7kVQIBycH0fD+oi5pezQETxdHKmQKGk1eQEYldK+jw5GxPfZ9z7Mk0Qnhf1W1m3w//EUn5BDmSZsbR44QQLBEqrBHqOrmSKaQAxdnLArCrxZcM7A7ZKs4ioRq8LFC+NpC3WCBJsvpVw5edm9iEXFuyNfxXAgSwfrFQ1c0iNda8AdejvUgnktOtJQQxmcfFzGglc5WVCj7oDgFqU18boeFSs52CUh8LE8BIVQDT1ABrB0HtgSEYlX5doJnCwv9TXocKCaKbnwhdDKPq4lf3SwU3HLq4V/+WYhHVMa/3b4IlfyikAduCkcBc7mQ3/z/Qq/cTuikhkzB12Ae/mcJC9U+Vo8Ej1gWAtgbeGgFsAMHr50BIWOLCbezvhpBFUdY6EJuJ/QDW0XoMX60zZ0AAAAASUVORK5CYII=";
        break;
    }
    const c4ShapeElem = elem.append("g");
    c4ShapeElem.attr("class", "person-man");
    const rect2 = getNoteRect$2();
    switch (c4Shape.typeC4Shape.text) {
      case "person":
      case "external_person":
      case "system":
      case "external_system":
      case "container":
      case "external_container":
      case "component":
      case "external_component":
        rect2.x = c4Shape.x;
        rect2.y = c4Shape.y;
        rect2.fill = fillColor;
        rect2.width = c4Shape.width;
        rect2.height = c4Shape.height;
        rect2.stroke = strokeColor;
        rect2.rx = 2.5;
        rect2.ry = 2.5;
        rect2.attrs = { "stroke-width": 0.5 };
        drawRect$3(c4ShapeElem, rect2);
        break;
      case "system_db":
      case "external_system_db":
      case "container_db":
      case "external_container_db":
      case "component_db":
      case "external_component_db":
        c4ShapeElem.append("path").attr("fill", fillColor).attr("stroke-width", "0.5").attr("stroke", strokeColor).attr(
          "d",
          "Mstartx,startyc0,-10 half,-10 half,-10c0,0 half,0 half,10l0,heightc0,10 -half,10 -half,10c0,0 -half,0 -half,-10l0,-height".replaceAll("startx", c4Shape.x).replaceAll("starty", c4Shape.y).replaceAll("half", c4Shape.width / 2).replaceAll("height", c4Shape.height)
        );
        c4ShapeElem.append("path").attr("fill", "none").attr("stroke-width", "0.5").attr("stroke", strokeColor).attr(
          "d",
          "Mstartx,startyc0,10 half,10 half,10c0,0 half,0 half,-10".replaceAll("startx", c4Shape.x).replaceAll("starty", c4Shape.y).replaceAll("half", c4Shape.width / 2)
        );
        break;
      case "system_queue":
      case "external_system_queue":
      case "container_queue":
      case "external_container_queue":
      case "component_queue":
      case "external_component_queue":
        c4ShapeElem.append("path").attr("fill", fillColor).attr("stroke-width", "0.5").attr("stroke", strokeColor).attr(
          "d",
          "Mstartx,startylwidth,0c5,0 5,half 5,halfc0,0 0,half -5,halfl-width,0c-5,0 -5,-half -5,-halfc0,0 0,-half 5,-half".replaceAll("startx", c4Shape.x).replaceAll("starty", c4Shape.y).replaceAll("width", c4Shape.width).replaceAll("half", c4Shape.height / 2)
        );
        c4ShapeElem.append("path").attr("fill", "none").attr("stroke-width", "0.5").attr("stroke", strokeColor).attr(
          "d",
          "Mstartx,startyc-5,0 -5,half -5,halfc0,half 5,half 5,half".replaceAll("startx", c4Shape.x + c4Shape.width).replaceAll("starty", c4Shape.y).replaceAll("half", c4Shape.height / 2)
        );
        break;
    }
    let c4ShapeFontConf = getC4ShapeFont(conf2, c4Shape.typeC4Shape.text);
    c4ShapeElem.append("text").attr("fill", fontColor).attr("font-family", c4ShapeFontConf.fontFamily).attr("font-size", c4ShapeFontConf.fontSize - 2).attr("font-style", "italic").attr("lengthAdjust", "spacing").attr("textLength", c4Shape.typeC4Shape.width).attr("x", c4Shape.x + c4Shape.width / 2 - c4Shape.typeC4Shape.width / 2).attr("y", c4Shape.y + c4Shape.typeC4Shape.Y).text("<<" + c4Shape.typeC4Shape.text + ">>");
    switch (c4Shape.typeC4Shape.text) {
      case "person":
      case "external_person":
        drawImage(
          c4ShapeElem,
          48,
          48,
          c4Shape.x + c4Shape.width / 2 - 24,
          c4Shape.y + c4Shape.image.Y,
          personImg
        );
        break;
    }
    let textFontConf = conf2[c4Shape.typeC4Shape.text + "Font"]();
    textFontConf.fontWeight = "bold";
    textFontConf.fontSize = textFontConf.fontSize + 2;
    textFontConf.fontColor = fontColor;
    _drawTextCandidateFunc$3(conf2)(
      c4Shape.label.text,
      c4ShapeElem,
      c4Shape.x,
      c4Shape.y + c4Shape.label.Y,
      c4Shape.width,
      c4Shape.height,
      { fill: fontColor },
      textFontConf
    );
    textFontConf = conf2[c4Shape.typeC4Shape.text + "Font"]();
    textFontConf.fontColor = fontColor;
    if (c4Shape.techn && ((_a2 = c4Shape.techn) == null ? void 0 : _a2.text) !== "") {
      _drawTextCandidateFunc$3(conf2)(
        c4Shape.techn.text,
        c4ShapeElem,
        c4Shape.x,
        c4Shape.y + c4Shape.techn.Y,
        c4Shape.width,
        c4Shape.height,
        { fill: fontColor, "font-style": "italic" },
        textFontConf
      );
    } else if (c4Shape.type && c4Shape.type.text !== "") {
      _drawTextCandidateFunc$3(conf2)(
        c4Shape.type.text,
        c4ShapeElem,
        c4Shape.x,
        c4Shape.y + c4Shape.type.Y,
        c4Shape.width,
        c4Shape.height,
        { fill: fontColor, "font-style": "italic" },
        textFontConf
      );
    }
    if (c4Shape.descr && c4Shape.descr.text !== "") {
      textFontConf = conf2.personFont();
      textFontConf.fontColor = fontColor;
      _drawTextCandidateFunc$3(conf2)(
        c4Shape.descr.text,
        c4ShapeElem,
        c4Shape.x,
        c4Shape.y + c4Shape.descr.Y,
        c4Shape.width,
        c4Shape.height,
        { fill: fontColor },
        textFontConf
      );
    }
    return c4Shape.height;
  };
  const insertDatabaseIcon$1 = function(elem) {
    elem.append("defs").append("symbol").attr("id", "database").attr("fill-rule", "evenodd").attr("clip-rule", "evenodd").append("path").attr("transform", "scale(.5)").attr(
      "d",
      "M12.258.001l.256.004.255.005.253.008.251.01.249.012.247.015.246.016.242.019.241.02.239.023.236.024.233.027.231.028.229.031.225.032.223.034.22.036.217.038.214.04.211.041.208.043.205.045.201.046.198.048.194.05.191.051.187.053.183.054.18.056.175.057.172.059.168.06.163.061.16.063.155.064.15.066.074.033.073.033.071.034.07.034.069.035.068.035.067.035.066.035.064.036.064.036.062.036.06.036.06.037.058.037.058.037.055.038.055.038.053.038.052.038.051.039.05.039.048.039.047.039.045.04.044.04.043.04.041.04.04.041.039.041.037.041.036.041.034.041.033.042.032.042.03.042.029.042.027.042.026.043.024.043.023.043.021.043.02.043.018.044.017.043.015.044.013.044.012.044.011.045.009.044.007.045.006.045.004.045.002.045.001.045v17l-.001.045-.002.045-.004.045-.006.045-.007.045-.009.044-.011.045-.012.044-.013.044-.015.044-.017.043-.018.044-.02.043-.021.043-.023.043-.024.043-.026.043-.027.042-.029.042-.03.042-.032.042-.033.042-.034.041-.036.041-.037.041-.039.041-.04.041-.041.04-.043.04-.044.04-.045.04-.047.039-.048.039-.05.039-.051.039-.052.038-.053.038-.055.038-.055.038-.058.037-.058.037-.06.037-.06.036-.062.036-.064.036-.064.036-.066.035-.067.035-.068.035-.069.035-.07.034-.071.034-.073.033-.074.033-.15.066-.155.064-.16.063-.163.061-.168.06-.172.059-.175.057-.18.056-.183.054-.187.053-.191.051-.194.05-.198.048-.201.046-.205.045-.208.043-.211.041-.214.04-.217.038-.22.036-.223.034-.225.032-.229.031-.231.028-.233.027-.236.024-.239.023-.241.02-.242.019-.246.016-.247.015-.249.012-.251.01-.253.008-.255.005-.256.004-.258.001-.258-.001-.256-.004-.255-.005-.253-.008-.251-.01-.249-.012-.247-.015-.245-.016-.243-.019-.241-.02-.238-.023-.236-.024-.234-.027-.231-.028-.228-.031-.226-.032-.223-.034-.22-.036-.217-.038-.214-.04-.211-.041-.208-.043-.204-.045-.201-.046-.198-.048-.195-.05-.19-.051-.187-.053-.184-.054-.179-.056-.176-.057-.172-.059-.167-.06-.164-.061-.159-.063-.155-.064-.151-.066-.074-.033-.072-.033-.072-.034-.07-.034-.069-.035-.068-.035-.067-.035-.066-.035-.064-.036-.063-.036-.062-.036-.061-.036-.06-.037-.058-.037-.057-.037-.056-.038-.055-.038-.053-.038-.052-.038-.051-.039-.049-.039-.049-.039-.046-.039-.046-.04-.044-.04-.043-.04-.041-.04-.04-.041-.039-.041-.037-.041-.036-.041-.034-.041-.033-.042-.032-.042-.03-.042-.029-.042-.027-.042-.026-.043-.024-.043-.023-.043-.021-.043-.02-.043-.018-.044-.017-.043-.015-.044-.013-.044-.012-.044-.011-.045-.009-.044-.007-.045-.006-.045-.004-.045-.002-.045-.001-.045v-17l.001-.045.002-.045.004-.045.006-.045.007-.045.009-.044.011-.045.012-.044.013-.044.015-.044.017-.043.018-.044.02-.043.021-.043.023-.043.024-.043.026-.043.027-.042.029-.042.03-.042.032-.042.033-.042.034-.041.036-.041.037-.041.039-.041.04-.041.041-.04.043-.04.044-.04.046-.04.046-.039.049-.039.049-.039.051-.039.052-.038.053-.038.055-.038.056-.038.057-.037.058-.037.06-.037.061-.036.062-.036.063-.036.064-.036.066-.035.067-.035.068-.035.069-.035.07-.034.072-.034.072-.033.074-.033.151-.066.155-.064.159-.063.164-.061.167-.06.172-.059.176-.057.179-.056.184-.054.187-.053.19-.051.195-.05.198-.048.201-.046.204-.045.208-.043.211-.041.214-.04.217-.038.22-.036.223-.034.226-.032.228-.031.231-.028.234-.027.236-.024.238-.023.241-.02.243-.019.245-.016.247-.015.249-.012.251-.01.253-.008.255-.005.256-.004.258-.001.258.001zm-9.258 20.499v.01l.001.021.003.021.004.022.005.021.006.022.007.022.009.023.01.022.011.023.012.023.013.023.015.023.016.024.017.023.018.024.019.024.021.024.022.025.023.024.024.025.052.049.056.05.061.051.066.051.07.051.075.051.079.052.084.052.088.052.092.052.097.052.102.051.105.052.11.052.114.051.119.051.123.051.127.05.131.05.135.05.139.048.144.049.147.047.152.047.155.047.16.045.163.045.167.043.171.043.176.041.178.041.183.039.187.039.19.037.194.035.197.035.202.033.204.031.209.03.212.029.216.027.219.025.222.024.226.021.23.02.233.018.236.016.24.015.243.012.246.01.249.008.253.005.256.004.259.001.26-.001.257-.004.254-.005.25-.008.247-.011.244-.012.241-.014.237-.016.233-.018.231-.021.226-.021.224-.024.22-.026.216-.027.212-.028.21-.031.205-.031.202-.034.198-.034.194-.036.191-.037.187-.039.183-.04.179-.04.175-.042.172-.043.168-.044.163-.045.16-.046.155-.046.152-.047.148-.048.143-.049.139-.049.136-.05.131-.05.126-.05.123-.051.118-.052.114-.051.11-.052.106-.052.101-.052.096-.052.092-.052.088-.053.083-.051.079-.052.074-.052.07-.051.065-.051.06-.051.056-.05.051-.05.023-.024.023-.025.021-.024.02-.024.019-.024.018-.024.017-.024.015-.023.014-.024.013-.023.012-.023.01-.023.01-.022.008-.022.006-.022.006-.022.004-.022.004-.021.001-.021.001-.021v-4.127l-.077.055-.08.053-.083.054-.085.053-.087.052-.09.052-.093.051-.095.05-.097.05-.1.049-.102.049-.105.048-.106.047-.109.047-.111.046-.114.045-.115.045-.118.044-.12.043-.122.042-.124.042-.126.041-.128.04-.13.04-.132.038-.134.038-.135.037-.138.037-.139.035-.142.035-.143.034-.144.033-.147.032-.148.031-.15.03-.151.03-.153.029-.154.027-.156.027-.158.026-.159.025-.161.024-.162.023-.163.022-.165.021-.166.02-.167.019-.169.018-.169.017-.171.016-.173.015-.173.014-.175.013-.175.012-.177.011-.178.01-.179.008-.179.008-.181.006-.182.005-.182.004-.184.003-.184.002h-.37l-.184-.002-.184-.003-.182-.004-.182-.005-.181-.006-.179-.008-.179-.008-.178-.01-.176-.011-.176-.012-.175-.013-.173-.014-.172-.015-.171-.016-.17-.017-.169-.018-.167-.019-.166-.02-.165-.021-.163-.022-.162-.023-.161-.024-.159-.025-.157-.026-.156-.027-.155-.027-.153-.029-.151-.03-.15-.03-.148-.031-.146-.032-.145-.033-.143-.034-.141-.035-.14-.035-.137-.037-.136-.037-.134-.038-.132-.038-.13-.04-.128-.04-.126-.041-.124-.042-.122-.042-.12-.044-.117-.043-.116-.045-.113-.045-.112-.046-.109-.047-.106-.047-.105-.048-.102-.049-.1-.049-.097-.05-.095-.05-.093-.052-.09-.051-.087-.052-.085-.053-.083-.054-.08-.054-.077-.054v4.127zm0-5.654v.011l.001.021.003.021.004.021.005.022.006.022.007.022.009.022.01.022.011.023.012.023.013.023.015.024.016.023.017.024.018.024.019.024.021.024.022.024.023.025.024.024.052.05.056.05.061.05.066.051.07.051.075.052.079.051.084.052.088.052.092.052.097.052.102.052.105.052.11.051.114.051.119.052.123.05.127.051.131.05.135.049.139.049.144.048.147.048.152.047.155.046.16.045.163.045.167.044.171.042.176.042.178.04.183.04.187.038.19.037.194.036.197.034.202.033.204.032.209.03.212.028.216.027.219.025.222.024.226.022.23.02.233.018.236.016.24.014.243.012.246.01.249.008.253.006.256.003.259.001.26-.001.257-.003.254-.006.25-.008.247-.01.244-.012.241-.015.237-.016.233-.018.231-.02.226-.022.224-.024.22-.025.216-.027.212-.029.21-.03.205-.032.202-.033.198-.035.194-.036.191-.037.187-.039.183-.039.179-.041.175-.042.172-.043.168-.044.163-.045.16-.045.155-.047.152-.047.148-.048.143-.048.139-.05.136-.049.131-.05.126-.051.123-.051.118-.051.114-.052.11-.052.106-.052.101-.052.096-.052.092-.052.088-.052.083-.052.079-.052.074-.051.07-.052.065-.051.06-.05.056-.051.051-.049.023-.025.023-.024.021-.025.02-.024.019-.024.018-.024.017-.024.015-.023.014-.023.013-.024.012-.022.01-.023.01-.023.008-.022.006-.022.006-.022.004-.021.004-.022.001-.021.001-.021v-4.139l-.077.054-.08.054-.083.054-.085.052-.087.053-.09.051-.093.051-.095.051-.097.05-.1.049-.102.049-.105.048-.106.047-.109.047-.111.046-.114.045-.115.044-.118.044-.12.044-.122.042-.124.042-.126.041-.128.04-.13.039-.132.039-.134.038-.135.037-.138.036-.139.036-.142.035-.143.033-.144.033-.147.033-.148.031-.15.03-.151.03-.153.028-.154.028-.156.027-.158.026-.159.025-.161.024-.162.023-.163.022-.165.021-.166.02-.167.019-.169.018-.169.017-.171.016-.173.015-.173.014-.175.013-.175.012-.177.011-.178.009-.179.009-.179.007-.181.007-.182.005-.182.004-.184.003-.184.002h-.37l-.184-.002-.184-.003-.182-.004-.182-.005-.181-.007-.179-.007-.179-.009-.178-.009-.176-.011-.176-.012-.175-.013-.173-.014-.172-.015-.171-.016-.17-.017-.169-.018-.167-.019-.166-.02-.165-.021-.163-.022-.162-.023-.161-.024-.159-.025-.157-.026-.156-.027-.155-.028-.153-.028-.151-.03-.15-.03-.148-.031-.146-.033-.145-.033-.143-.033-.141-.035-.14-.036-.137-.036-.136-.037-.134-.038-.132-.039-.13-.039-.128-.04-.126-.041-.124-.042-.122-.043-.12-.043-.117-.044-.116-.044-.113-.046-.112-.046-.109-.046-.106-.047-.105-.048-.102-.049-.1-.049-.097-.05-.095-.051-.093-.051-.09-.051-.087-.053-.085-.052-.083-.054-.08-.054-.077-.054v4.139zm0-5.666v.011l.001.02.003.022.004.021.005.022.006.021.007.022.009.023.01.022.011.023.012.023.013.023.015.023.016.024.017.024.018.023.019.024.021.025.022.024.023.024.024.025.052.05.056.05.061.05.066.051.07.051.075.052.079.051.084.052.088.052.092.052.097.052.102.052.105.051.11.052.114.051.119.051.123.051.127.05.131.05.135.05.139.049.144.048.147.048.152.047.155.046.16.045.163.045.167.043.171.043.176.042.178.04.183.04.187.038.19.037.194.036.197.034.202.033.204.032.209.03.212.028.216.027.219.025.222.024.226.021.23.02.233.018.236.017.24.014.243.012.246.01.249.008.253.006.256.003.259.001.26-.001.257-.003.254-.006.25-.008.247-.01.244-.013.241-.014.237-.016.233-.018.231-.02.226-.022.224-.024.22-.025.216-.027.212-.029.21-.03.205-.032.202-.033.198-.035.194-.036.191-.037.187-.039.183-.039.179-.041.175-.042.172-.043.168-.044.163-.045.16-.045.155-.047.152-.047.148-.048.143-.049.139-.049.136-.049.131-.051.126-.05.123-.051.118-.052.114-.051.11-.052.106-.052.101-.052.096-.052.092-.052.088-.052.083-.052.079-.052.074-.052.07-.051.065-.051.06-.051.056-.05.051-.049.023-.025.023-.025.021-.024.02-.024.019-.024.018-.024.017-.024.015-.023.014-.024.013-.023.012-.023.01-.022.01-.023.008-.022.006-.022.006-.022.004-.022.004-.021.001-.021.001-.021v-4.153l-.077.054-.08.054-.083.053-.085.053-.087.053-.09.051-.093.051-.095.051-.097.05-.1.049-.102.048-.105.048-.106.048-.109.046-.111.046-.114.046-.115.044-.118.044-.12.043-.122.043-.124.042-.126.041-.128.04-.13.039-.132.039-.134.038-.135.037-.138.036-.139.036-.142.034-.143.034-.144.033-.147.032-.148.032-.15.03-.151.03-.153.028-.154.028-.156.027-.158.026-.159.024-.161.024-.162.023-.163.023-.165.021-.166.02-.167.019-.169.018-.169.017-.171.016-.173.015-.173.014-.175.013-.175.012-.177.01-.178.01-.179.009-.179.007-.181.006-.182.006-.182.004-.184.003-.184.001-.185.001-.185-.001-.184-.001-.184-.003-.182-.004-.182-.006-.181-.006-.179-.007-.179-.009-.178-.01-.176-.01-.176-.012-.175-.013-.173-.014-.172-.015-.171-.016-.17-.017-.169-.018-.167-.019-.166-.02-.165-.021-.163-.023-.162-.023-.161-.024-.159-.024-.157-.026-.156-.027-.155-.028-.153-.028-.151-.03-.15-.03-.148-.032-.146-.032-.145-.033-.143-.034-.141-.034-.14-.036-.137-.036-.136-.037-.134-.038-.132-.039-.13-.039-.128-.041-.126-.041-.124-.041-.122-.043-.12-.043-.117-.044-.116-.044-.113-.046-.112-.046-.109-.046-.106-.048-.105-.048-.102-.048-.1-.05-.097-.049-.095-.051-.093-.051-.09-.052-.087-.052-.085-.053-.083-.053-.08-.054-.077-.054v4.153zm8.74-8.179l-.257.004-.254.005-.25.008-.247.011-.244.012-.241.014-.237.016-.233.018-.231.021-.226.022-.224.023-.22.026-.216.027-.212.028-.21.031-.205.032-.202.033-.198.034-.194.036-.191.038-.187.038-.183.04-.179.041-.175.042-.172.043-.168.043-.163.045-.16.046-.155.046-.152.048-.148.048-.143.048-.139.049-.136.05-.131.05-.126.051-.123.051-.118.051-.114.052-.11.052-.106.052-.101.052-.096.052-.092.052-.088.052-.083.052-.079.052-.074.051-.07.052-.065.051-.06.05-.056.05-.051.05-.023.025-.023.024-.021.024-.02.025-.019.024-.018.024-.017.023-.015.024-.014.023-.013.023-.012.023-.01.023-.01.022-.008.022-.006.023-.006.021-.004.022-.004.021-.001.021-.001.021.001.021.001.021.004.021.004.022.006.021.006.023.008.022.01.022.01.023.012.023.013.023.014.023.015.024.017.023.018.024.019.024.02.025.021.024.023.024.023.025.051.05.056.05.06.05.065.051.07.052.074.051.079.052.083.052.088.052.092.052.096.052.101.052.106.052.11.052.114.052.118.051.123.051.126.051.131.05.136.05.139.049.143.048.148.048.152.048.155.046.16.046.163.045.168.043.172.043.175.042.179.041.183.04.187.038.191.038.194.036.198.034.202.033.205.032.21.031.212.028.216.027.22.026.224.023.226.022.231.021.233.018.237.016.241.014.244.012.247.011.25.008.254.005.257.004.26.001.26-.001.257-.004.254-.005.25-.008.247-.011.244-.012.241-.014.237-.016.233-.018.231-.021.226-.022.224-.023.22-.026.216-.027.212-.028.21-.031.205-.032.202-.033.198-.034.194-.036.191-.038.187-.038.183-.04.179-.041.175-.042.172-.043.168-.043.163-.045.16-.046.155-.046.152-.048.148-.048.143-.048.139-.049.136-.05.131-.05.126-.051.123-.051.118-.051.114-.052.11-.052.106-.052.101-.052.096-.052.092-.052.088-.052.083-.052.079-.052.074-.051.07-.052.065-.051.06-.05.056-.05.051-.05.023-.025.023-.024.021-.024.02-.025.019-.024.018-.024.017-.023.015-.024.014-.023.013-.023.012-.023.01-.023.01-.022.008-.022.006-.023.006-.021.004-.022.004-.021.001-.021.001-.021-.001-.021-.001-.021-.004-.021-.004-.022-.006-.021-.006-.023-.008-.022-.01-.022-.01-.023-.012-.023-.013-.023-.014-.023-.015-.024-.017-.023-.018-.024-.019-.024-.02-.025-.021-.024-.023-.024-.023-.025-.051-.05-.056-.05-.06-.05-.065-.051-.07-.052-.074-.051-.079-.052-.083-.052-.088-.052-.092-.052-.096-.052-.101-.052-.106-.052-.11-.052-.114-.052-.118-.051-.123-.051-.126-.051-.131-.05-.136-.05-.139-.049-.143-.048-.148-.048-.152-.048-.155-.046-.16-.046-.163-.045-.168-.043-.172-.043-.175-.042-.179-.041-.183-.04-.187-.038-.191-.038-.194-.036-.198-.034-.202-.033-.205-.032-.21-.031-.212-.028-.216-.027-.22-.026-.224-.023-.226-.022-.231-.021-.233-.018-.237-.016-.241-.014-.244-.012-.247-.011-.25-.008-.254-.005-.257-.004-.26-.001-.26.001z"
    );
  };
  const insertComputerIcon$1 = function(elem) {
    elem.append("defs").append("symbol").attr("id", "computer").attr("width", "24").attr("height", "24").append("path").attr("transform", "scale(.5)").attr(
      "d",
      "M2 2v13h20v-13h-20zm18 11h-16v-9h16v9zm-10.228 6l.466-1h3.524l.467 1h-4.457zm14.228 3h-24l2-6h2.104l-1.33 4h18.45l-1.297-4h2.073l2 6zm-5-10h-14v-7h14v7z"
    );
  };
  const insertClockIcon$1 = function(elem) {
    elem.append("defs").append("symbol").attr("id", "clock").attr("width", "24").attr("height", "24").append("path").attr("transform", "scale(.5)").attr(
      "d",
      "M12 2c5.514 0 10 4.486 10 10s-4.486 10-10 10-10-4.486-10-10 4.486-10 10-10zm0-2c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12-5.373-12-12-12zm5.848 12.459c.202.038.202.333.001.372-1.907.361-6.045 1.111-6.547 1.111-.719 0-1.301-.582-1.301-1.301 0-.512.77-5.447 1.125-7.445.034-.192.312-.181.343.014l.985 6.238 5.394 1.011z"
    );
  };
  const insertArrowHead$1 = function(elem) {
    elem.append("defs").append("marker").attr("id", "arrowhead").attr("refX", 9).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 12).attr("markerHeight", 12).attr("orient", "auto").append("path").attr("d", "M 0 0 L 10 5 L 0 10 z");
  };
  const insertArrowEnd = function(elem) {
    elem.append("defs").append("marker").attr("id", "arrowend").attr("refX", 1).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 12).attr("markerHeight", 12).attr("orient", "auto").append("path").attr("d", "M 10 0 L 0 5 L 10 10 z");
  };
  const insertArrowFilledHead$1 = function(elem) {
    elem.append("defs").append("marker").attr("id", "filled-head").attr("refX", 18).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L14,7 L9,1 Z");
  };
  const insertDynamicNumber = function(elem) {
    elem.append("defs").append("marker").attr("id", "sequencenumber").attr("refX", 15).attr("refY", 15).attr("markerWidth", 60).attr("markerHeight", 40).attr("orient", "auto").append("circle").attr("cx", 15).attr("cy", 15).attr("r", 6);
  };
  const insertArrowCrossHead$1 = function(elem) {
    const defs = elem.append("defs");
    const marker = defs.append("marker").attr("id", "crosshead").attr("markerWidth", 15).attr("markerHeight", 8).attr("orient", "auto").attr("refX", 16).attr("refY", 4);
    marker.append("path").attr("fill", "black").attr("stroke", "#000000").style("stroke-dasharray", "0, 0").attr("stroke-width", "1px").attr("d", "M 9,2 V 6 L16,4 Z");
    marker.append("path").attr("fill", "none").attr("stroke", "#000000").style("stroke-dasharray", "0, 0").attr("stroke-width", "1px").attr("d", "M 0,1 L 6,7 M 6,1 L 0,7");
  };
  const getC4ShapeFont = (cnf, typeC4Shape) => {
    return {
      fontFamily: cnf[typeC4Shape + "FontFamily"],
      fontSize: cnf[typeC4Shape + "FontSize"],
      fontWeight: cnf[typeC4Shape + "FontWeight"]
    };
  };
  const _drawTextCandidateFunc$3 = function() {
    function byText(content2, g, x2, y2, width2, height, textAttrs) {
      const text2 = g.append("text").attr("x", x2 + width2 / 2).attr("y", y2 + height / 2 + 5).style("text-anchor", "middle").text(content2);
      _setTextAttrs(text2, textAttrs);
    }
    function byTspan(content2, g, x2, y2, width2, height, textAttrs, conf2) {
      const { fontSize, fontFamily, fontWeight } = conf2;
      const lines = content2.split(common$1.lineBreakRegex);
      for (let i2 = 0; i2 < lines.length; i2++) {
        const dy = i2 * fontSize - fontSize * (lines.length - 1) / 2;
        const text2 = g.append("text").attr("x", x2 + width2 / 2).attr("y", y2).style("text-anchor", "middle").attr("dominant-baseline", "middle").style("font-size", fontSize).style("font-weight", fontWeight).style("font-family", fontFamily);
        text2.append("tspan").attr("dy", dy).text(lines[i2]).attr("alignment-baseline", "mathematical");
        _setTextAttrs(text2, textAttrs);
      }
    }
    function byFo(content2, g, x2, y2, width2, height, textAttrs, conf2) {
      const s = g.append("switch");
      const f2 = s.append("foreignObject").attr("x", x2).attr("y", y2).attr("width", width2).attr("height", height);
      const text2 = f2.append("xhtml:div").style("display", "table").style("height", "100%").style("width", "100%");
      text2.append("div").style("display", "table-cell").style("text-align", "center").style("vertical-align", "middle").text(content2);
      byTspan(content2, s, x2, y2, width2, height, textAttrs, conf2);
      _setTextAttrs(text2, textAttrs);
    }
    function _setTextAttrs(toText, fromTextAttrsDict) {
      for (const key in fromTextAttrsDict) {
        if (fromTextAttrsDict.hasOwnProperty(key)) {
          toText.attr(key, fromTextAttrsDict[key]);
        }
      }
    }
    return function(conf2) {
      return conf2.textPlacement === "fo" ? byFo : conf2.textPlacement === "old" ? byText : byTspan;
    };
  }();
  const svgDraw$4 = {
    drawRect: drawRect$3,
    drawBoundary: drawBoundary$1,
    drawC4Shape,
    drawRels: drawRels$1,
    drawImage,
    insertArrowHead: insertArrowHead$1,
    insertArrowEnd,
    insertArrowFilledHead: insertArrowFilledHead$1,
    insertDynamicNumber,
    insertArrowCrossHead: insertArrowCrossHead$1,
    insertDatabaseIcon: insertDatabaseIcon$1,
    insertComputerIcon: insertComputerIcon$1,
    insertClockIcon: insertClockIcon$1
  };
  let globalBoundaryMaxX = 0, globalBoundaryMaxY = 0;
  let c4ShapeInRow = 4;
  let c4BoundaryInRow = 2;
  parser$v.yy = db$g;
  let conf$9 = {};
  class Bounds {
    constructor(diagObj) {
      this.name = "";
      this.data = {};
      this.data.startx = void 0;
      this.data.stopx = void 0;
      this.data.starty = void 0;
      this.data.stopy = void 0;
      this.data.widthLimit = void 0;
      this.nextData = {};
      this.nextData.startx = void 0;
      this.nextData.stopx = void 0;
      this.nextData.starty = void 0;
      this.nextData.stopy = void 0;
      this.nextData.cnt = 0;
      setConf$9(diagObj.db.getConfig());
    }
    setData(startx, stopx, starty, stopy) {
      this.nextData.startx = this.data.startx = startx;
      this.nextData.stopx = this.data.stopx = stopx;
      this.nextData.starty = this.data.starty = starty;
      this.nextData.stopy = this.data.stopy = stopy;
    }
    updateVal(obj, key, val, fun) {
      if (obj[key] === void 0) {
        obj[key] = val;
      } else {
        obj[key] = fun(val, obj[key]);
      }
    }
    insert(c4Shape) {
      this.nextData.cnt = this.nextData.cnt + 1;
      let _startx = this.nextData.startx === this.nextData.stopx ? this.nextData.stopx + c4Shape.margin : this.nextData.stopx + c4Shape.margin * 2;
      let _stopx = _startx + c4Shape.width;
      let _starty = this.nextData.starty + c4Shape.margin * 2;
      let _stopy = _starty + c4Shape.height;
      if (_startx >= this.data.widthLimit || _stopx >= this.data.widthLimit || this.nextData.cnt > c4ShapeInRow) {
        _startx = this.nextData.startx + c4Shape.margin + conf$9.nextLinePaddingX;
        _starty = this.nextData.stopy + c4Shape.margin * 2;
        this.nextData.stopx = _stopx = _startx + c4Shape.width;
        this.nextData.starty = this.nextData.stopy;
        this.nextData.stopy = _stopy = _starty + c4Shape.height;
        this.nextData.cnt = 1;
      }
      c4Shape.x = _startx;
      c4Shape.y = _starty;
      this.updateVal(this.data, "startx", _startx, Math.min);
      this.updateVal(this.data, "starty", _starty, Math.min);
      this.updateVal(this.data, "stopx", _stopx, Math.max);
      this.updateVal(this.data, "stopy", _stopy, Math.max);
      this.updateVal(this.nextData, "startx", _startx, Math.min);
      this.updateVal(this.nextData, "starty", _starty, Math.min);
      this.updateVal(this.nextData, "stopx", _stopx, Math.max);
      this.updateVal(this.nextData, "stopy", _stopy, Math.max);
    }
    init(diagObj) {
      this.name = "";
      this.data = {
        startx: void 0,
        stopx: void 0,
        starty: void 0,
        stopy: void 0,
        widthLimit: void 0
      };
      this.nextData = {
        startx: void 0,
        stopx: void 0,
        starty: void 0,
        stopy: void 0,
        cnt: 0
      };
      setConf$9(diagObj.db.getConfig());
    }
    bumpLastMargin(margin) {
      this.data.stopx += margin;
      this.data.stopy += margin;
    }
  }
  const setConf$9 = function(cnf) {
    assignWithDepth$1(conf$9, cnf);
    if (cnf.fontFamily) {
      conf$9.personFontFamily = conf$9.systemFontFamily = conf$9.messageFontFamily = cnf.fontFamily;
    }
    if (cnf.fontSize) {
      conf$9.personFontSize = conf$9.systemFontSize = conf$9.messageFontSize = cnf.fontSize;
    }
    if (cnf.fontWeight) {
      conf$9.personFontWeight = conf$9.systemFontWeight = conf$9.messageFontWeight = cnf.fontWeight;
    }
  };
  const c4ShapeFont = (cnf, typeC4Shape) => {
    return {
      fontFamily: cnf[typeC4Shape + "FontFamily"],
      fontSize: cnf[typeC4Shape + "FontSize"],
      fontWeight: cnf[typeC4Shape + "FontWeight"]
    };
  };
  const boundaryFont = (cnf) => {
    return {
      fontFamily: cnf.boundaryFontFamily,
      fontSize: cnf.boundaryFontSize,
      fontWeight: cnf.boundaryFontWeight
    };
  };
  const messageFont$1 = (cnf) => {
    return {
      fontFamily: cnf.messageFontFamily,
      fontSize: cnf.messageFontSize,
      fontWeight: cnf.messageFontWeight
    };
  };
  function calcC4ShapeTextWH(textType, c4Shape, c4ShapeTextWrap, textConf, textLimitWidth) {
    if (!c4Shape[textType].width) {
      if (c4ShapeTextWrap) {
        c4Shape[textType].text = wrapLabel(c4Shape[textType].text, textLimitWidth, textConf);
        c4Shape[textType].textLines = c4Shape[textType].text.split(common$1.lineBreakRegex).length;
        c4Shape[textType].width = textLimitWidth;
        c4Shape[textType].height = calculateTextHeight(c4Shape[textType].text, textConf);
      } else {
        let lines = c4Shape[textType].text.split(common$1.lineBreakRegex);
        c4Shape[textType].textLines = lines.length;
        let lineHeight = 0;
        c4Shape[textType].height = 0;
        c4Shape[textType].width = 0;
        for (const line2 of lines) {
          c4Shape[textType].width = Math.max(
            calculateTextWidth(line2, textConf),
            c4Shape[textType].width
          );
          lineHeight = calculateTextHeight(line2, textConf);
          c4Shape[textType].height = c4Shape[textType].height + lineHeight;
        }
      }
    }
  }
  const drawBoundary = function(diagram2, boundary, bounds2) {
    boundary.x = bounds2.data.startx;
    boundary.y = bounds2.data.starty;
    boundary.width = bounds2.data.stopx - bounds2.data.startx;
    boundary.height = bounds2.data.stopy - bounds2.data.starty;
    boundary.label.y = conf$9.c4ShapeMargin - 35;
    let boundaryTextWrap = boundary.wrap && conf$9.wrap;
    let boundaryLabelConf = boundaryFont(conf$9);
    boundaryLabelConf.fontSize = boundaryLabelConf.fontSize + 2;
    boundaryLabelConf.fontWeight = "bold";
    let textLimitWidth = calculateTextWidth(boundary.label.text, boundaryLabelConf);
    calcC4ShapeTextWH("label", boundary, boundaryTextWrap, boundaryLabelConf, textLimitWidth);
    svgDraw$4.drawBoundary(diagram2, boundary, conf$9);
  };
  const drawC4ShapeArray = function(currentBounds, diagram2, c4ShapeArray2, c4ShapeKeys) {
    let Y = 0;
    for (const c4ShapeKey of c4ShapeKeys) {
      Y = 0;
      const c4Shape = c4ShapeArray2[c4ShapeKey];
      let c4ShapeTypeConf = c4ShapeFont(conf$9, c4Shape.typeC4Shape.text);
      c4ShapeTypeConf.fontSize = c4ShapeTypeConf.fontSize - 2;
      c4Shape.typeC4Shape.width = calculateTextWidth(
        "«" + c4Shape.typeC4Shape.text + "»",
        c4ShapeTypeConf
      );
      c4Shape.typeC4Shape.height = c4ShapeTypeConf.fontSize + 2;
      c4Shape.typeC4Shape.Y = conf$9.c4ShapePadding;
      Y = c4Shape.typeC4Shape.Y + c4Shape.typeC4Shape.height - 4;
      c4Shape.image = { width: 0, height: 0, Y: 0 };
      switch (c4Shape.typeC4Shape.text) {
        case "person":
        case "external_person":
          c4Shape.image.width = 48;
          c4Shape.image.height = 48;
          c4Shape.image.Y = Y;
          Y = c4Shape.image.Y + c4Shape.image.height;
          break;
      }
      if (c4Shape.sprite) {
        c4Shape.image.width = 48;
        c4Shape.image.height = 48;
        c4Shape.image.Y = Y;
        Y = c4Shape.image.Y + c4Shape.image.height;
      }
      let c4ShapeTextWrap = c4Shape.wrap && conf$9.wrap;
      let textLimitWidth = conf$9.width - conf$9.c4ShapePadding * 2;
      let c4ShapeLabelConf = c4ShapeFont(conf$9, c4Shape.typeC4Shape.text);
      c4ShapeLabelConf.fontSize = c4ShapeLabelConf.fontSize + 2;
      c4ShapeLabelConf.fontWeight = "bold";
      calcC4ShapeTextWH("label", c4Shape, c4ShapeTextWrap, c4ShapeLabelConf, textLimitWidth);
      c4Shape["label"].Y = Y + 8;
      Y = c4Shape["label"].Y + c4Shape["label"].height;
      if (c4Shape.type && c4Shape.type.text !== "") {
        c4Shape.type.text = "[" + c4Shape.type.text + "]";
        let c4ShapeTypeConf2 = c4ShapeFont(conf$9, c4Shape.typeC4Shape.text);
        calcC4ShapeTextWH("type", c4Shape, c4ShapeTextWrap, c4ShapeTypeConf2, textLimitWidth);
        c4Shape["type"].Y = Y + 5;
        Y = c4Shape["type"].Y + c4Shape["type"].height;
      } else if (c4Shape.techn && c4Shape.techn.text !== "") {
        c4Shape.techn.text = "[" + c4Shape.techn.text + "]";
        let c4ShapeTechnConf = c4ShapeFont(conf$9, c4Shape.techn.text);
        calcC4ShapeTextWH("techn", c4Shape, c4ShapeTextWrap, c4ShapeTechnConf, textLimitWidth);
        c4Shape["techn"].Y = Y + 5;
        Y = c4Shape["techn"].Y + c4Shape["techn"].height;
      }
      let rectHeight = Y;
      let rectWidth = c4Shape.label.width;
      if (c4Shape.descr && c4Shape.descr.text !== "") {
        let c4ShapeDescrConf = c4ShapeFont(conf$9, c4Shape.typeC4Shape.text);
        calcC4ShapeTextWH("descr", c4Shape, c4ShapeTextWrap, c4ShapeDescrConf, textLimitWidth);
        c4Shape["descr"].Y = Y + 20;
        Y = c4Shape["descr"].Y + c4Shape["descr"].height;
        rectWidth = Math.max(c4Shape.label.width, c4Shape.descr.width);
        rectHeight = Y - c4Shape["descr"].textLines * 5;
      }
      rectWidth = rectWidth + conf$9.c4ShapePadding;
      c4Shape.width = Math.max(c4Shape.width || conf$9.width, rectWidth, conf$9.width);
      c4Shape.height = Math.max(c4Shape.height || conf$9.height, rectHeight, conf$9.height);
      c4Shape.margin = c4Shape.margin || conf$9.c4ShapeMargin;
      currentBounds.insert(c4Shape);
      svgDraw$4.drawC4Shape(diagram2, c4Shape, conf$9);
    }
    currentBounds.bumpLastMargin(conf$9.c4ShapeMargin);
  };
  let Point$1 = class Point {
    constructor(x2, y2) {
      this.x = x2;
      this.y = y2;
    }
  };
  let getIntersectPoint = function(fromNode, endPoint) {
    let x1 = fromNode.x;
    let y1 = fromNode.y;
    let x2 = endPoint.x;
    let y2 = endPoint.y;
    let fromCenterX = x1 + fromNode.width / 2;
    let fromCenterY = y1 + fromNode.height / 2;
    let dx = Math.abs(x1 - x2);
    let dy = Math.abs(y1 - y2);
    let tanDYX = dy / dx;
    let fromDYX = fromNode.height / fromNode.width;
    let returnPoint = null;
    if (y1 == y2 && x1 < x2) {
      returnPoint = new Point$1(x1 + fromNode.width, fromCenterY);
    } else if (y1 == y2 && x1 > x2) {
      returnPoint = new Point$1(x1, fromCenterY);
    } else if (x1 == x2 && y1 < y2) {
      returnPoint = new Point$1(fromCenterX, y1 + fromNode.height);
    } else if (x1 == x2 && y1 > y2) {
      returnPoint = new Point$1(fromCenterX, y1);
    }
    if (x1 > x2 && y1 < y2) {
      if (fromDYX >= tanDYX) {
        returnPoint = new Point$1(x1, fromCenterY + tanDYX * fromNode.width / 2);
      } else {
        returnPoint = new Point$1(
          fromCenterX - dx / dy * fromNode.height / 2,
          y1 + fromNode.height
        );
      }
    } else if (x1 < x2 && y1 < y2) {
      if (fromDYX >= tanDYX) {
        returnPoint = new Point$1(x1 + fromNode.width, fromCenterY + tanDYX * fromNode.width / 2);
      } else {
        returnPoint = new Point$1(
          fromCenterX + dx / dy * fromNode.height / 2,
          y1 + fromNode.height
        );
      }
    } else if (x1 < x2 && y1 > y2) {
      if (fromDYX >= tanDYX) {
        returnPoint = new Point$1(x1 + fromNode.width, fromCenterY - tanDYX * fromNode.width / 2);
      } else {
        returnPoint = new Point$1(fromCenterX + fromNode.height / 2 * dx / dy, y1);
      }
    } else if (x1 > x2 && y1 > y2) {
      if (fromDYX >= tanDYX) {
        returnPoint = new Point$1(x1, fromCenterY - fromNode.width / 2 * tanDYX);
      } else {
        returnPoint = new Point$1(fromCenterX - fromNode.height / 2 * dx / dy, y1);
      }
    }
    return returnPoint;
  };
  let getIntersectPoints = function(fromNode, endNode) {
    let endIntersectPoint = { x: 0, y: 0 };
    endIntersectPoint.x = endNode.x + endNode.width / 2;
    endIntersectPoint.y = endNode.y + endNode.height / 2;
    let startPoint = getIntersectPoint(fromNode, endIntersectPoint);
    endIntersectPoint.x = fromNode.x + fromNode.width / 2;
    endIntersectPoint.y = fromNode.y + fromNode.height / 2;
    let endPoint = getIntersectPoint(endNode, endIntersectPoint);
    return { startPoint, endPoint };
  };
  const drawRels = function(diagram2, rels2, getC4ShapeObj, diagObj) {
    let i2 = 0;
    for (let rel of rels2) {
      i2 = i2 + 1;
      let relTextWrap = rel.wrap && conf$9.wrap;
      let relConf = messageFont$1(conf$9);
      let diagramType = diagObj.db.getC4Type();
      if (diagramType === "C4Dynamic") {
        rel.label.text = i2 + ": " + rel.label.text;
      }
      let textLimitWidth = calculateTextWidth(rel.label.text, relConf);
      calcC4ShapeTextWH("label", rel, relTextWrap, relConf, textLimitWidth);
      if (rel.techn && rel.techn.text !== "") {
        textLimitWidth = calculateTextWidth(rel.techn.text, relConf);
        calcC4ShapeTextWH("techn", rel, relTextWrap, relConf, textLimitWidth);
      }
      if (rel.descr && rel.descr.text !== "") {
        textLimitWidth = calculateTextWidth(rel.descr.text, relConf);
        calcC4ShapeTextWH("descr", rel, relTextWrap, relConf, textLimitWidth);
      }
      let fromNode = getC4ShapeObj(rel.from);
      let endNode = getC4ShapeObj(rel.to);
      let points = getIntersectPoints(fromNode, endNode);
      rel.startPoint = points.startPoint;
      rel.endPoint = points.endPoint;
    }
    svgDraw$4.drawRels(diagram2, rels2, conf$9);
  };
  function drawInsideBoundary(diagram2, parentBoundaryAlias, parentBounds, currentBoundaries, diagObj) {
    let currentBounds = new Bounds(diagObj);
    currentBounds.data.widthLimit = parentBounds.data.widthLimit / Math.min(c4BoundaryInRow, currentBoundaries.length);
    for (let [i2, currentBoundary] of currentBoundaries.entries()) {
      let Y = 0;
      currentBoundary.image = { width: 0, height: 0, Y: 0 };
      if (currentBoundary.sprite) {
        currentBoundary.image.width = 48;
        currentBoundary.image.height = 48;
        currentBoundary.image.Y = Y;
        Y = currentBoundary.image.Y + currentBoundary.image.height;
      }
      let currentBoundaryTextWrap = currentBoundary.wrap && conf$9.wrap;
      let currentBoundaryLabelConf = boundaryFont(conf$9);
      currentBoundaryLabelConf.fontSize = currentBoundaryLabelConf.fontSize + 2;
      currentBoundaryLabelConf.fontWeight = "bold";
      calcC4ShapeTextWH(
        "label",
        currentBoundary,
        currentBoundaryTextWrap,
        currentBoundaryLabelConf,
        currentBounds.data.widthLimit
      );
      currentBoundary["label"].Y = Y + 8;
      Y = currentBoundary["label"].Y + currentBoundary["label"].height;
      if (currentBoundary.type && currentBoundary.type.text !== "") {
        currentBoundary.type.text = "[" + currentBoundary.type.text + "]";
        let currentBoundaryTypeConf = boundaryFont(conf$9);
        calcC4ShapeTextWH(
          "type",
          currentBoundary,
          currentBoundaryTextWrap,
          currentBoundaryTypeConf,
          currentBounds.data.widthLimit
        );
        currentBoundary["type"].Y = Y + 5;
        Y = currentBoundary["type"].Y + currentBoundary["type"].height;
      }
      if (currentBoundary.descr && currentBoundary.descr.text !== "") {
        let currentBoundaryDescrConf = boundaryFont(conf$9);
        currentBoundaryDescrConf.fontSize = currentBoundaryDescrConf.fontSize - 2;
        calcC4ShapeTextWH(
          "descr",
          currentBoundary,
          currentBoundaryTextWrap,
          currentBoundaryDescrConf,
          currentBounds.data.widthLimit
        );
        currentBoundary["descr"].Y = Y + 20;
        Y = currentBoundary["descr"].Y + currentBoundary["descr"].height;
      }
      if (i2 == 0 || i2 % c4BoundaryInRow === 0) {
        let _x = parentBounds.data.startx + conf$9.diagramMarginX;
        let _y = parentBounds.data.stopy + conf$9.diagramMarginY + Y;
        currentBounds.setData(_x, _x, _y, _y);
      } else {
        let _x = currentBounds.data.stopx !== currentBounds.data.startx ? currentBounds.data.stopx + conf$9.diagramMarginX : currentBounds.data.startx;
        let _y = currentBounds.data.starty;
        currentBounds.setData(_x, _x, _y, _y);
      }
      currentBounds.name = currentBoundary.alias;
      let currentPersonOrSystemArray = diagObj.db.getC4ShapeArray(currentBoundary.alias);
      let currentPersonOrSystemKeys = diagObj.db.getC4ShapeKeys(currentBoundary.alias);
      if (currentPersonOrSystemKeys.length > 0) {
        drawC4ShapeArray(
          currentBounds,
          diagram2,
          currentPersonOrSystemArray,
          currentPersonOrSystemKeys
        );
      }
      parentBoundaryAlias = currentBoundary.alias;
      let nextCurrentBoundarys = diagObj.db.getBoundarys(parentBoundaryAlias);
      if (nextCurrentBoundarys.length > 0) {
        drawInsideBoundary(
          diagram2,
          parentBoundaryAlias,
          currentBounds,
          nextCurrentBoundarys,
          diagObj
        );
      }
      if (currentBoundary.alias !== "global") {
        drawBoundary(diagram2, currentBoundary, currentBounds);
      }
      parentBounds.data.stopy = Math.max(
        currentBounds.data.stopy + conf$9.c4ShapeMargin,
        parentBounds.data.stopy
      );
      parentBounds.data.stopx = Math.max(
        currentBounds.data.stopx + conf$9.c4ShapeMargin,
        parentBounds.data.stopx
      );
      globalBoundaryMaxX = Math.max(globalBoundaryMaxX, parentBounds.data.stopx);
      globalBoundaryMaxY = Math.max(globalBoundaryMaxY, parentBounds.data.stopy);
    }
  }
  const draw$l = function(_text, id2, _version, diagObj) {
    conf$9 = getConfig$1().c4;
    const securityLevel = getConfig$1().securityLevel;
    let sandboxElement;
    if (securityLevel === "sandbox") {
      sandboxElement = d3select("#i" + id2);
    }
    const root2 = securityLevel === "sandbox" ? d3select(sandboxElement.nodes()[0].contentDocument.body) : d3select("body");
    let db2 = diagObj.db;
    diagObj.db.setWrap(conf$9.wrap);
    c4ShapeInRow = db2.getC4ShapeInRow();
    c4BoundaryInRow = db2.getC4BoundaryInRow();
    log$1.debug(`C:${JSON.stringify(conf$9, null, 2)}`);
    const diagram2 = securityLevel === "sandbox" ? root2.select(`[id="${id2}"]`) : d3select(`[id="${id2}"]`);
    svgDraw$4.insertComputerIcon(diagram2);
    svgDraw$4.insertDatabaseIcon(diagram2);
    svgDraw$4.insertClockIcon(diagram2);
    let screenBounds = new Bounds(diagObj);
    screenBounds.setData(
      conf$9.diagramMarginX,
      conf$9.diagramMarginX,
      conf$9.diagramMarginY,
      conf$9.diagramMarginY
    );
    screenBounds.data.widthLimit = screen.availWidth;
    globalBoundaryMaxX = conf$9.diagramMarginX;
    globalBoundaryMaxY = conf$9.diagramMarginY;
    const title2 = diagObj.db.getTitle();
    let currentBoundaries = diagObj.db.getBoundarys("");
    drawInsideBoundary(diagram2, "", screenBounds, currentBoundaries, diagObj);
    svgDraw$4.insertArrowHead(diagram2);
    svgDraw$4.insertArrowEnd(diagram2);
    svgDraw$4.insertArrowCrossHead(diagram2);
    svgDraw$4.insertArrowFilledHead(diagram2);
    drawRels(diagram2, diagObj.db.getRels(), diagObj.db.getC4Shape, diagObj);
    screenBounds.data.stopx = globalBoundaryMaxX;
    screenBounds.data.stopy = globalBoundaryMaxY;
    const box = screenBounds.data;
    let boxHeight = box.stopy - box.starty;
    let height = boxHeight + 2 * conf$9.diagramMarginY;
    let boxWidth = box.stopx - box.startx;
    const width2 = boxWidth + 2 * conf$9.diagramMarginX;
    if (title2) {
      diagram2.append("text").text(title2).attr("x", (box.stopx - box.startx) / 2 - 4 * conf$9.diagramMarginX).attr("y", box.starty + conf$9.diagramMarginY);
    }
    configureSvgSize(diagram2, height, width2, conf$9.useMaxWidth);
    const extraVertForTitle = title2 ? 60 : 0;
    diagram2.attr(
      "viewBox",
      box.startx - conf$9.diagramMarginX + " -" + (conf$9.diagramMarginY + extraVertForTitle) + " " + width2 + " " + (height + extraVertForTitle)
    );
    log$1.debug(`models:`, box);
  };
  const renderer$g = {
    drawPersonOrSystemArray: drawC4ShapeArray,
    drawBoundary,
    setConf: setConf$9,
    draw: draw$l
  };
  const getStyles$e = (options2) => `.person {
    stroke: ${options2.personBorder};
    fill: ${options2.personBkg};
  }
`;
  const styles$9 = getStyles$e;
  const diagram$l = {
    parser: parser$w,
    db: db$g,
    renderer: renderer$g,
    styles: styles$9,
    init: ({ c4: c42, wrap: wrap2 }) => {
      renderer$g.setConf(c42);
      db$g.setWrap(wrap2);
    }
  };
  const c4Diagram = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    diagram: diagram$l
  }, Symbol.toStringTag, { value: "Module" }));
  var parser$t = function() {
    var o = function(k, v, o2, l) {
      for (o2 = o2 || {}, l = k.length; l--; o2[k[l]] = v)
        ;
      return o2;
    }, $V0 = [1, 4], $V1 = [1, 3], $V2 = [1, 5], $V3 = [1, 8, 9, 10, 11, 27, 34, 36, 38, 42, 58, 81, 82, 83, 84, 85, 86, 99, 102, 103, 106, 108, 111, 112, 113, 118, 119, 120, 121], $V4 = [2, 2], $V5 = [1, 13], $V6 = [1, 14], $V7 = [1, 15], $V8 = [1, 16], $V9 = [1, 23], $Va = [1, 25], $Vb = [1, 26], $Vc = [1, 27], $Vd = [1, 49], $Ve = [1, 48], $Vf = [1, 29], $Vg = [1, 30], $Vh = [1, 31], $Vi = [1, 32], $Vj = [1, 33], $Vk = [1, 44], $Vl = [1, 46], $Vm = [1, 42], $Vn = [1, 47], $Vo = [1, 43], $Vp = [1, 50], $Vq = [1, 45], $Vr = [1, 51], $Vs = [1, 52], $Vt = [1, 34], $Vu = [1, 35], $Vv = [1, 36], $Vw = [1, 37], $Vx = [1, 57], $Vy = [1, 8, 9, 10, 11, 27, 32, 34, 36, 38, 42, 58, 81, 82, 83, 84, 85, 86, 99, 102, 103, 106, 108, 111, 112, 113, 118, 119, 120, 121], $Vz = [1, 61], $VA = [1, 60], $VB = [1, 62], $VC = [8, 9, 11, 73, 75], $VD = [1, 88], $VE = [1, 93], $VF = [1, 92], $VG = [1, 89], $VH = [1, 85], $VI = [1, 91], $VJ = [1, 87], $VK = [1, 94], $VL = [1, 90], $VM = [1, 95], $VN = [1, 86], $VO = [8, 9, 10, 11, 73, 75], $VP = [8, 9, 10, 11, 44, 73, 75], $VQ = [8, 9, 10, 11, 29, 42, 44, 46, 48, 50, 52, 54, 56, 58, 61, 63, 65, 66, 68, 73, 75, 86, 99, 102, 103, 106, 108, 111, 112, 113], $VR = [8, 9, 11, 42, 58, 73, 75, 86, 99, 102, 103, 106, 108, 111, 112, 113], $VS = [42, 58, 86, 99, 102, 103, 106, 108, 111, 112, 113], $VT = [1, 121], $VU = [1, 120], $VV = [1, 128], $VW = [1, 142], $VX = [1, 143], $VY = [1, 144], $VZ = [1, 145], $V_ = [1, 130], $V$ = [1, 132], $V01 = [1, 136], $V11 = [1, 137], $V21 = [1, 138], $V31 = [1, 139], $V41 = [1, 140], $V51 = [1, 141], $V61 = [1, 146], $V71 = [1, 147], $V81 = [1, 126], $V91 = [1, 127], $Va1 = [1, 134], $Vb1 = [1, 129], $Vc1 = [1, 133], $Vd1 = [1, 131], $Ve1 = [8, 9, 10, 11, 27, 32, 34, 36, 38, 42, 58, 81, 82, 83, 84, 85, 86, 99, 102, 103, 106, 108, 111, 112, 113, 118, 119, 120, 121], $Vf1 = [1, 149], $Vg1 = [8, 9, 11], $Vh1 = [8, 9, 10, 11, 14, 42, 58, 86, 102, 103, 106, 108, 111, 112, 113], $Vi1 = [1, 169], $Vj1 = [1, 165], $Vk1 = [1, 166], $Vl1 = [1, 170], $Vm1 = [1, 167], $Vn1 = [1, 168], $Vo1 = [75, 113, 116], $Vp1 = [8, 9, 10, 11, 12, 14, 27, 29, 32, 42, 58, 73, 81, 82, 83, 84, 85, 86, 87, 102, 106, 108, 111, 112, 113], $Vq1 = [10, 103], $Vr1 = [31, 47, 49, 51, 53, 55, 60, 62, 64, 65, 67, 69, 113, 114, 115], $Vs1 = [1, 235], $Vt1 = [1, 233], $Vu1 = [1, 237], $Vv1 = [1, 231], $Vw1 = [1, 232], $Vx1 = [1, 234], $Vy1 = [1, 236], $Vz1 = [1, 238], $VA1 = [1, 255], $VB1 = [8, 9, 11, 103], $VC1 = [8, 9, 10, 11, 58, 81, 102, 103, 106, 107, 108, 109];
    var parser2 = {
      trace: function trace() {
      },
      yy: {},
      symbols_: { "error": 2, "start": 3, "graphConfig": 4, "document": 5, "line": 6, "statement": 7, "SEMI": 8, "NEWLINE": 9, "SPACE": 10, "EOF": 11, "GRAPH": 12, "NODIR": 13, "DIR": 14, "FirstStmtSeperator": 15, "ending": 16, "endToken": 17, "spaceList": 18, "spaceListNewline": 19, "verticeStatement": 20, "separator": 21, "styleStatement": 22, "linkStyleStatement": 23, "classDefStatement": 24, "classStatement": 25, "clickStatement": 26, "subgraph": 27, "textNoTags": 28, "SQS": 29, "text": 30, "SQE": 31, "end": 32, "direction": 33, "acc_title": 34, "acc_title_value": 35, "acc_descr": 36, "acc_descr_value": 37, "acc_descr_multiline_value": 38, "link": 39, "node": 40, "styledVertex": 41, "AMP": 42, "vertex": 43, "STYLE_SEPARATOR": 44, "idString": 45, "DOUBLECIRCLESTART": 46, "DOUBLECIRCLEEND": 47, "PS": 48, "PE": 49, "(-": 50, "-)": 51, "STADIUMSTART": 52, "STADIUMEND": 53, "SUBROUTINESTART": 54, "SUBROUTINEEND": 55, "VERTEX_WITH_PROPS_START": 56, "NODE_STRING[field]": 57, "COLON": 58, "NODE_STRING[value]": 59, "PIPE": 60, "CYLINDERSTART": 61, "CYLINDEREND": 62, "DIAMOND_START": 63, "DIAMOND_STOP": 64, "TAGEND": 65, "TRAPSTART": 66, "TRAPEND": 67, "INVTRAPSTART": 68, "INVTRAPEND": 69, "linkStatement": 70, "arrowText": 71, "TESTSTR": 72, "START_LINK": 73, "edgeText": 74, "LINK": 75, "edgeTextToken": 76, "STR": 77, "MD_STR": 78, "textToken": 79, "keywords": 80, "STYLE": 81, "LINKSTYLE": 82, "CLASSDEF": 83, "CLASS": 84, "CLICK": 85, "DOWN": 86, "UP": 87, "textNoTagsToken": 88, "stylesOpt": 89, "idString[vertex]": 90, "idString[class]": 91, "CALLBACKNAME": 92, "CALLBACKARGS": 93, "HREF": 94, "LINK_TARGET": 95, "STR[link]": 96, "STR[tooltip]": 97, "alphaNum": 98, "DEFAULT": 99, "numList": 100, "INTERPOLATE": 101, "NUM": 102, "COMMA": 103, "style": 104, "styleComponent": 105, "NODE_STRING": 106, "UNIT": 107, "BRKT": 108, "PCT": 109, "idStringToken": 110, "MINUS": 111, "MULT": 112, "UNICODE_TEXT": 113, "TEXT": 114, "TAGSTART": 115, "EDGE_TEXT": 116, "alphaNumToken": 117, "direction_tb": 118, "direction_bt": 119, "direction_rl": 120, "direction_lr": 121, "$accept": 0, "$end": 1 },
      terminals_: { 2: "error", 8: "SEMI", 9: "NEWLINE", 10: "SPACE", 11: "EOF", 12: "GRAPH", 13: "NODIR", 14: "DIR", 27: "subgraph", 29: "SQS", 31: "SQE", 32: "end", 34: "acc_title", 35: "acc_title_value", 36: "acc_descr", 37: "acc_descr_value", 38: "acc_descr_multiline_value", 42: "AMP", 44: "STYLE_SEPARATOR", 46: "DOUBLECIRCLESTART", 47: "DOUBLECIRCLEEND", 48: "PS", 49: "PE", 50: "(-", 51: "-)", 52: "STADIUMSTART", 53: "STADIUMEND", 54: "SUBROUTINESTART", 55: "SUBROUTINEEND", 56: "VERTEX_WITH_PROPS_START", 57: "NODE_STRING[field]", 58: "COLON", 59: "NODE_STRING[value]", 60: "PIPE", 61: "CYLINDERSTART", 62: "CYLINDEREND", 63: "DIAMOND_START", 64: "DIAMOND_STOP", 65: "TAGEND", 66: "TRAPSTART", 67: "TRAPEND", 68: "INVTRAPSTART", 69: "INVTRAPEND", 72: "TESTSTR", 73: "START_LINK", 75: "LINK", 77: "STR", 78: "MD_STR", 81: "STYLE", 82: "LINKSTYLE", 83: "CLASSDEF", 84: "CLASS", 85: "CLICK", 86: "DOWN", 87: "UP", 90: "idString[vertex]", 91: "idString[class]", 92: "CALLBACKNAME", 93: "CALLBACKARGS", 94: "HREF", 95: "LINK_TARGET", 96: "STR[link]", 97: "STR[tooltip]", 99: "DEFAULT", 101: "INTERPOLATE", 102: "NUM", 103: "COMMA", 106: "NODE_STRING", 107: "UNIT", 108: "BRKT", 109: "PCT", 111: "MINUS", 112: "MULT", 113: "UNICODE_TEXT", 114: "TEXT", 115: "TAGSTART", 116: "EDGE_TEXT", 118: "direction_tb", 119: "direction_bt", 120: "direction_rl", 121: "direction_lr" },
      productions_: [0, [3, 2], [5, 0], [5, 2], [6, 1], [6, 1], [6, 1], [6, 1], [6, 1], [4, 2], [4, 2], [4, 2], [4, 3], [16, 2], [16, 1], [17, 1], [17, 1], [17, 1], [15, 1], [15, 1], [15, 2], [19, 2], [19, 2], [19, 1], [19, 1], [18, 2], [18, 1], [7, 2], [7, 2], [7, 2], [7, 2], [7, 2], [7, 2], [7, 9], [7, 6], [7, 4], [7, 1], [7, 2], [7, 2], [7, 1], [21, 1], [21, 1], [21, 1], [20, 3], [20, 4], [20, 2], [20, 1], [40, 1], [40, 5], [41, 1], [41, 3], [43, 4], [43, 4], [43, 6], [43, 4], [43, 4], [43, 4], [43, 8], [43, 4], [43, 4], [43, 4], [43, 6], [43, 4], [43, 4], [43, 4], [43, 4], [43, 4], [43, 1], [39, 2], [39, 3], [39, 3], [39, 1], [39, 3], [74, 1], [74, 2], [74, 1], [74, 1], [70, 1], [71, 3], [30, 1], [30, 2], [30, 1], [30, 1], [80, 1], [80, 1], [80, 1], [80, 1], [80, 1], [80, 1], [80, 1], [80, 1], [80, 1], [80, 1], [80, 1], [28, 1], [28, 2], [28, 1], [28, 1], [24, 5], [25, 5], [26, 2], [26, 4], [26, 3], [26, 5], [26, 3], [26, 5], [26, 5], [26, 7], [26, 2], [26, 4], [26, 2], [26, 4], [26, 4], [26, 6], [22, 5], [23, 5], [23, 5], [23, 9], [23, 9], [23, 7], [23, 7], [100, 1], [100, 3], [89, 1], [89, 3], [104, 1], [104, 2], [105, 1], [105, 1], [105, 1], [105, 1], [105, 1], [105, 1], [105, 1], [105, 1], [110, 1], [110, 1], [110, 1], [110, 1], [110, 1], [110, 1], [110, 1], [110, 1], [110, 1], [110, 1], [110, 1], [79, 1], [79, 1], [79, 1], [79, 1], [88, 1], [88, 1], [88, 1], [88, 1], [88, 1], [88, 1], [88, 1], [88, 1], [88, 1], [88, 1], [88, 1], [76, 1], [76, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [117, 1], [45, 1], [45, 2], [98, 1], [98, 2], [33, 1], [33, 1], [33, 1], [33, 1]],
      performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$) {
        var $0 = $$.length - 1;
        switch (yystate) {
          case 2:
            this.$ = [];
            break;
          case 3:
            if (!Array.isArray($$[$0]) || $$[$0].length > 0) {
              $$[$0 - 1].push($$[$0]);
            }
            this.$ = $$[$0 - 1];
            break;
          case 4:
          case 176:
            this.$ = $$[$0];
            break;
          case 11:
            yy.setDirection("TB");
            this.$ = "TB";
            break;
          case 12:
            yy.setDirection($$[$0 - 1]);
            this.$ = $$[$0 - 1];
            break;
          case 27:
            this.$ = $$[$0 - 1].nodes;
            break;
          case 28:
          case 29:
          case 30:
          case 31:
          case 32:
            this.$ = [];
            break;
          case 33:
            this.$ = yy.addSubGraph($$[$0 - 6], $$[$0 - 1], $$[$0 - 4]);
            break;
          case 34:
            this.$ = yy.addSubGraph($$[$0 - 3], $$[$0 - 1], $$[$0 - 3]);
            break;
          case 35:
            this.$ = yy.addSubGraph(void 0, $$[$0 - 1], void 0);
            break;
          case 37:
            this.$ = $$[$0].trim();
            yy.setAccTitle(this.$);
            break;
          case 38:
          case 39:
            this.$ = $$[$0].trim();
            yy.setAccDescription(this.$);
            break;
          case 43:
            yy.addLink($$[$0 - 2].stmt, $$[$0], $$[$0 - 1]);
            this.$ = { stmt: $$[$0], nodes: $$[$0].concat($$[$0 - 2].nodes) };
            break;
          case 44:
            yy.addLink($$[$0 - 3].stmt, $$[$0 - 1], $$[$0 - 2]);
            this.$ = { stmt: $$[$0 - 1], nodes: $$[$0 - 1].concat($$[$0 - 3].nodes) };
            break;
          case 45:
            this.$ = { stmt: $$[$0 - 1], nodes: $$[$0 - 1] };
            break;
          case 46:
            this.$ = { stmt: $$[$0], nodes: $$[$0] };
            break;
          case 47:
            this.$ = [$$[$0]];
            break;
          case 48:
            this.$ = $$[$0 - 4].concat($$[$0]);
            break;
          case 49:
            this.$ = $$[$0];
            break;
          case 50:
            this.$ = $$[$0 - 2];
            yy.setClass($$[$0 - 2], $$[$0]);
            break;
          case 51:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "square");
            break;
          case 52:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "doublecircle");
            break;
          case 53:
            this.$ = $$[$0 - 5];
            yy.addVertex($$[$0 - 5], $$[$0 - 2], "circle");
            break;
          case 54:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "ellipse");
            break;
          case 55:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "stadium");
            break;
          case 56:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "subroutine");
            break;
          case 57:
            this.$ = $$[$0 - 7];
            yy.addVertex($$[$0 - 7], $$[$0 - 1], "rect", void 0, void 0, void 0, Object.fromEntries([[$$[$0 - 5], $$[$0 - 3]]]));
            break;
          case 58:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "cylinder");
            break;
          case 59:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "round");
            break;
          case 60:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "diamond");
            break;
          case 61:
            this.$ = $$[$0 - 5];
            yy.addVertex($$[$0 - 5], $$[$0 - 2], "hexagon");
            break;
          case 62:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "odd");
            break;
          case 63:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "trapezoid");
            break;
          case 64:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "inv_trapezoid");
            break;
          case 65:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "lean_right");
            break;
          case 66:
            this.$ = $$[$0 - 3];
            yy.addVertex($$[$0 - 3], $$[$0 - 1], "lean_left");
            break;
          case 67:
            this.$ = $$[$0];
            yy.addVertex($$[$0]);
            break;
          case 68:
            $$[$0 - 1].text = $$[$0];
            this.$ = $$[$0 - 1];
            break;
          case 69:
          case 70:
            $$[$0 - 2].text = $$[$0 - 1];
            this.$ = $$[$0 - 2];
            break;
          case 71:
            this.$ = $$[$0];
            break;
          case 72:
            var inf = yy.destructLink($$[$0], $$[$0 - 2]);
            this.$ = { "type": inf.type, "stroke": inf.stroke, "length": inf.length, "text": $$[$0 - 1] };
            break;
          case 73:
            this.$ = { text: $$[$0], type: "text" };
            break;
          case 74:
            this.$ = { text: $$[$0 - 1].text + "" + $$[$0], type: $$[$0 - 1].type };
            break;
          case 75:
            this.$ = { text: $$[$0], type: "string" };
            break;
          case 76:
            this.$ = { text: $$[$0], type: "markdown" };
            break;
          case 77:
            var inf = yy.destructLink($$[$0]);
            this.$ = { "type": inf.type, "stroke": inf.stroke, "length": inf.length };
            break;
          case 78:
            this.$ = $$[$0 - 1];
            break;
          case 79:
            this.$ = { text: $$[$0], type: "text" };
            break;
          case 80:
            this.$ = { text: $$[$0 - 1].text + "" + $$[$0], type: $$[$0 - 1].type };
            break;
          case 81:
            this.$ = { text: $$[$0], type: "string" };
            break;
          case 82:
          case 97:
            this.$ = { text: $$[$0], type: "markdown" };
            break;
          case 94:
            this.$ = { text: $$[$0], type: "text" };
            break;
          case 95:
            this.$ = { text: $$[$0 - 1].text + "" + $$[$0], type: $$[$0 - 1].type };
            break;
          case 96:
            this.$ = { text: $$[$0], type: "text" };
            break;
          case 98:
            this.$ = $$[$0 - 4];
            yy.addClass($$[$0 - 2], $$[$0]);
            break;
          case 99:
            this.$ = $$[$0 - 4];
            yy.setClass($$[$0 - 2], $$[$0]);
            break;
          case 100:
          case 108:
            this.$ = $$[$0 - 1];
            yy.setClickEvent($$[$0 - 1], $$[$0]);
            break;
          case 101:
          case 109:
            this.$ = $$[$0 - 3];
            yy.setClickEvent($$[$0 - 3], $$[$0 - 2]);
            yy.setTooltip($$[$0 - 3], $$[$0]);
            break;
          case 102:
            this.$ = $$[$0 - 2];
            yy.setClickEvent($$[$0 - 2], $$[$0 - 1], $$[$0]);
            break;
          case 103:
            this.$ = $$[$0 - 4];
            yy.setClickEvent($$[$0 - 4], $$[$0 - 3], $$[$0 - 2]);
            yy.setTooltip($$[$0 - 4], $$[$0]);
            break;
          case 104:
            this.$ = $$[$0 - 2];
            yy.setLink($$[$0 - 2], $$[$0]);
            break;
          case 105:
            this.$ = $$[$0 - 4];
            yy.setLink($$[$0 - 4], $$[$0 - 2]);
            yy.setTooltip($$[$0 - 4], $$[$0]);
            break;
          case 106:
            this.$ = $$[$0 - 4];
            yy.setLink($$[$0 - 4], $$[$0 - 2], $$[$0]);
            break;
          case 107:
            this.$ = $$[$0 - 6];
            yy.setLink($$[$0 - 6], $$[$0 - 4], $$[$0]);
            yy.setTooltip($$[$0 - 6], $$[$0 - 2]);
            break;
          case 110:
            this.$ = $$[$0 - 1];
            yy.setLink($$[$0 - 1], $$[$0]);
            break;
          case 111:
            this.$ = $$[$0 - 3];
            yy.setLink($$[$0 - 3], $$[$0 - 2]);
            yy.setTooltip($$[$0 - 3], $$[$0]);
            break;
          case 112:
            this.$ = $$[$0 - 3];
            yy.setLink($$[$0 - 3], $$[$0 - 2], $$[$0]);
            break;
          case 113:
            this.$ = $$[$0 - 5];
            yy.setLink($$[$0 - 5], $$[$0 - 4], $$[$0]);
            yy.setTooltip($$[$0 - 5], $$[$0 - 2]);
            break;
          case 114:
            this.$ = $$[$0 - 4];
            yy.addVertex($$[$0 - 2], void 0, void 0, $$[$0]);
            break;
          case 115:
            this.$ = $$[$0 - 4];
            yy.updateLink([$$[$0 - 2]], $$[$0]);
            break;
          case 116:
            this.$ = $$[$0 - 4];
            yy.updateLink($$[$0 - 2], $$[$0]);
            break;
          case 117:
            this.$ = $$[$0 - 8];
            yy.updateLinkInterpolate([$$[$0 - 6]], $$[$0 - 2]);
            yy.updateLink([$$[$0 - 6]], $$[$0]);
            break;
          case 118:
            this.$ = $$[$0 - 8];
            yy.updateLinkInterpolate($$[$0 - 6], $$[$0 - 2]);
            yy.updateLink($$[$0 - 6], $$[$0]);
            break;
          case 119:
            this.$ = $$[$0 - 6];
            yy.updateLinkInterpolate([$$[$0 - 4]], $$[$0]);
            break;
          case 120:
            this.$ = $$[$0 - 6];
            yy.updateLinkInterpolate($$[$0 - 4], $$[$0]);
            break;
          case 121:
          case 123:
            this.$ = [$$[$0]];
            break;
          case 122:
          case 124:
            $$[$0 - 2].push($$[$0]);
            this.$ = $$[$0 - 2];
            break;
          case 126:
            this.$ = $$[$0 - 1] + $$[$0];
            break;
          case 174:
            this.$ = $$[$0];
            break;
          case 175:
            this.$ = $$[$0 - 1] + "" + $$[$0];
            break;
          case 177:
            this.$ = $$[$0 - 1] + "" + $$[$0];
            break;
          case 178:
            this.$ = { stmt: "dir", value: "TB" };
            break;
          case 179:
            this.$ = { stmt: "dir", value: "BT" };
            break;
          case 180:
            this.$ = { stmt: "dir", value: "RL" };
            break;
          case 181:
            this.$ = { stmt: "dir", value: "LR" };
            break;
        }
      },
      table: [{ 3: 1, 4: 2, 9: $V0, 10: $V1, 12: $V2 }, { 1: [3] }, o($V3, $V4, { 5: 6 }), { 4: 7, 9: $V0, 10: $V1, 12: $V2 }, { 4: 8, 9: $V0, 10: $V1, 12: $V2 }, { 13: [1, 9], 14: [1, 10] }, { 1: [2, 1], 6: 11, 7: 12, 8: $V5, 9: $V6, 10: $V7, 11: $V8, 20: 17, 22: 18, 23: 19, 24: 20, 25: 21, 26: 22, 27: $V9, 33: 24, 34: $Va, 36: $Vb, 38: $Vc, 40: 28, 41: 38, 42: $Vd, 43: 39, 45: 40, 58: $Ve, 81: $Vf, 82: $Vg, 83: $Vh, 84: $Vi, 85: $Vj, 86: $Vk, 99: $Vl, 102: $Vm, 103: $Vn, 106: $Vo, 108: $Vp, 110: 41, 111: $Vq, 112: $Vr, 113: $Vs, 118: $Vt, 119: $Vu, 120: $Vv, 121: $Vw }, o($V3, [2, 9]), o($V3, [2, 10]), o($V3, [2, 11]), { 8: [1, 54], 9: [1, 55], 10: $Vx, 15: 53, 18: 56 }, o($Vy, [2, 3]), o($Vy, [2, 4]), o($Vy, [2, 5]), o($Vy, [2, 6]), o($Vy, [2, 7]), o($Vy, [2, 8]), { 8: $Vz, 9: $VA, 11: $VB, 21: 58, 39: 59, 70: 63, 73: [1, 64], 75: [1, 65] }, { 8: $Vz, 9: $VA, 11: $VB, 21: 66 }, { 8: $Vz, 9: $VA, 11: $VB, 21: 67 }, { 8: $Vz, 9: $VA, 11: $VB, 21: 68 }, { 8: $Vz, 9: $VA, 11: $VB, 21: 69 }, { 8: $Vz, 9: $VA, 11: $VB, 21: 70 }, { 8: $Vz, 9: $VA, 10: [1, 71], 11: $VB, 21: 72 }, o($Vy, [2, 36]), { 35: [1, 73] }, { 37: [1, 74] }, o($Vy, [2, 39]), o($VC, [2, 46], { 18: 75, 10: $Vx }), { 10: [1, 76] }, { 10: [1, 77] }, { 10: [1, 78] }, { 10: [1, 79] }, { 14: $VD, 42: $VE, 58: $VF, 77: [1, 83], 86: $VG, 92: [1, 80], 94: [1, 81], 98: 82, 102: $VH, 103: $VI, 106: $VJ, 108: $VK, 111: $VL, 112: $VM, 113: $VN, 117: 84 }, o($Vy, [2, 178]), o($Vy, [2, 179]), o($Vy, [2, 180]), o($Vy, [2, 181]), o($VO, [2, 47]), o($VO, [2, 49], { 44: [1, 96] }), o($VP, [2, 67], { 110: 109, 29: [1, 97], 42: $Vd, 46: [1, 98], 48: [1, 99], 50: [1, 100], 52: [1, 101], 54: [1, 102], 56: [1, 103], 58: $Ve, 61: [1, 104], 63: [1, 105], 65: [1, 106], 66: [1, 107], 68: [1, 108], 86: $Vk, 99: $Vl, 102: $Vm, 103: $Vn, 106: $Vo, 108: $Vp, 111: $Vq, 112: $Vr, 113: $Vs }), o($VQ, [2, 174]), o($VQ, [2, 135]), o($VQ, [2, 136]), o($VQ, [2, 137]), o($VQ, [2, 138]), o($VQ, [2, 139]), o($VQ, [2, 140]), o($VQ, [2, 141]), o($VQ, [2, 142]), o($VQ, [2, 143]), o($VQ, [2, 144]), o($VQ, [2, 145]), o($V3, [2, 12]), o($V3, [2, 18]), o($V3, [2, 19]), { 9: [1, 110] }, o($VR, [2, 26], { 18: 111, 10: $Vx }), o($Vy, [2, 27]), { 40: 112, 41: 38, 42: $Vd, 43: 39, 45: 40, 58: $Ve, 86: $Vk, 99: $Vl, 102: $Vm, 103: $Vn, 106: $Vo, 108: $Vp, 110: 41, 111: $Vq, 112: $Vr, 113: $Vs }, o($Vy, [2, 40]), o($Vy, [2, 41]), o($Vy, [2, 42]), o($VS, [2, 71], { 71: 113, 60: [1, 115], 72: [1, 114] }), { 74: 116, 76: 117, 77: [1, 118], 78: [1, 119], 113: $VT, 116: $VU }, o([42, 58, 60, 72, 86, 99, 102, 103, 106, 108, 111, 112, 113], [2, 77]), o($Vy, [2, 28]), o($Vy, [2, 29]), o($Vy, [2, 30]), o($Vy, [2, 31]), o($Vy, [2, 32]), { 10: $VV, 12: $VW, 14: $VX, 27: $VY, 28: 122, 32: $VZ, 42: $V_, 58: $V$, 73: $V01, 77: [1, 124], 78: [1, 125], 80: 135, 81: $V11, 82: $V21, 83: $V31, 84: $V41, 85: $V51, 86: $V61, 87: $V71, 88: 123, 102: $V81, 106: $V91, 108: $Va1, 111: $Vb1, 112: $Vc1, 113: $Vd1 }, o($Ve1, $V4, { 5: 148 }), o($Vy, [2, 37]), o($Vy, [2, 38]), o($VC, [2, 45], { 42: $Vf1 }), { 42: $Vd, 45: 150, 58: $Ve, 86: $Vk, 99: $Vl, 102: $Vm, 103: $Vn, 106: $Vo, 108: $Vp, 110: 41, 111: $Vq, 112: $Vr, 113: $Vs }, { 99: [1, 151], 100: 152, 102: [1, 153] }, { 42: $Vd, 45: 154, 58: $Ve, 86: $Vk, 99: $Vl, 102: $Vm, 103: $Vn, 106: $Vo, 108: $Vp, 110: 41, 111: $Vq, 112: $Vr, 113: $Vs }, { 42: $Vd, 45: 155, 58: $Ve, 86: $Vk, 99: $Vl, 102: $Vm, 103: $Vn, 106: $Vo, 108: $Vp, 110: 41, 111: $Vq, 112: $Vr, 113: $Vs }, o($Vg1, [2, 100], { 10: [1, 156], 93: [1, 157] }), { 77: [1, 158] }, o($Vg1, [2, 108], { 117: 160, 10: [1, 159], 14: $VD, 42: $VE, 58: $VF, 86: $VG, 102: $VH, 103: $VI, 106: $VJ, 108: $VK, 111: $VL, 112: $VM, 113: $VN }), o($Vg1, [2, 110], { 10: [1, 161] }), o($Vh1, [2, 176]), o($Vh1, [2, 163]), o($Vh1, [2, 164]), o($Vh1, [2, 165]), o($Vh1, [2, 166]), o($Vh1, [2, 167]), o($Vh1, [2, 168]), o($Vh1, [2, 169]), o($Vh1, [2, 170]), o($Vh1, [2, 171]), o($Vh1, [2, 172]), o($Vh1, [2, 173]), { 42: $Vd, 45: 162, 58: $Ve, 86: $Vk, 99: $Vl, 102: $Vm, 103: $Vn, 106: $Vo, 108: $Vp, 110: 41, 111: $Vq, 112: $Vr, 113: $Vs }, { 30: 163, 65: $Vi1, 77: $Vj1, 78: $Vk1, 79: 164, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 30: 171, 65: $Vi1, 77: $Vj1, 78: $Vk1, 79: 164, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 30: 173, 48: [1, 172], 65: $Vi1, 77: $Vj1, 78: $Vk1, 79: 164, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 30: 174, 65: $Vi1, 77: $Vj1, 78: $Vk1, 79: 164, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 30: 175, 65: $Vi1, 77: $Vj1, 78: $Vk1, 79: 164, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 30: 176, 65: $Vi1, 77: $Vj1, 78: $Vk1, 79: 164, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 106: [1, 177] }, { 30: 178, 65: $Vi1, 77: $Vj1, 78: $Vk1, 79: 164, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 30: 179, 63: [1, 180], 65: $Vi1, 77: $Vj1, 78: $Vk1, 79: 164, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 30: 181, 65: $Vi1, 77: $Vj1, 78: $Vk1, 79: 164, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 30: 182, 65: $Vi1, 77: $Vj1, 78: $Vk1, 79: 164, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 30: 183, 65: $Vi1, 77: $Vj1, 78: $Vk1, 79: 164, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, o($VQ, [2, 175]), o($V3, [2, 20]), o($VR, [2, 25]), o($VC, [2, 43], { 18: 184, 10: $Vx }), o($VS, [2, 68], { 10: [1, 185] }), { 10: [1, 186] }, { 30: 187, 65: $Vi1, 77: $Vj1, 78: $Vk1, 79: 164, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 75: [1, 188], 76: 189, 113: $VT, 116: $VU }, o($Vo1, [2, 73]), o($Vo1, [2, 75]), o($Vo1, [2, 76]), o($Vo1, [2, 161]), o($Vo1, [2, 162]), { 8: $Vz, 9: $VA, 10: $VV, 11: $VB, 12: $VW, 14: $VX, 21: 191, 27: $VY, 29: [1, 190], 32: $VZ, 42: $V_, 58: $V$, 73: $V01, 80: 135, 81: $V11, 82: $V21, 83: $V31, 84: $V41, 85: $V51, 86: $V61, 87: $V71, 88: 192, 102: $V81, 106: $V91, 108: $Va1, 111: $Vb1, 112: $Vc1, 113: $Vd1 }, o($Vp1, [2, 94]), o($Vp1, [2, 96]), o($Vp1, [2, 97]), o($Vp1, [2, 150]), o($Vp1, [2, 151]), o($Vp1, [2, 152]), o($Vp1, [2, 153]), o($Vp1, [2, 154]), o($Vp1, [2, 155]), o($Vp1, [2, 156]), o($Vp1, [2, 157]), o($Vp1, [2, 158]), o($Vp1, [2, 159]), o($Vp1, [2, 160]), o($Vp1, [2, 83]), o($Vp1, [2, 84]), o($Vp1, [2, 85]), o($Vp1, [2, 86]), o($Vp1, [2, 87]), o($Vp1, [2, 88]), o($Vp1, [2, 89]), o($Vp1, [2, 90]), o($Vp1, [2, 91]), o($Vp1, [2, 92]), o($Vp1, [2, 93]), { 6: 11, 7: 12, 8: $V5, 9: $V6, 10: $V7, 11: $V8, 20: 17, 22: 18, 23: 19, 24: 20, 25: 21, 26: 22, 27: $V9, 32: [1, 193], 33: 24, 34: $Va, 36: $Vb, 38: $Vc, 40: 28, 41: 38, 42: $Vd, 43: 39, 45: 40, 58: $Ve, 81: $Vf, 82: $Vg, 83: $Vh, 84: $Vi, 85: $Vj, 86: $Vk, 99: $Vl, 102: $Vm, 103: $Vn, 106: $Vo, 108: $Vp, 110: 41, 111: $Vq, 112: $Vr, 113: $Vs, 118: $Vt, 119: $Vu, 120: $Vv, 121: $Vw }, { 10: $Vx, 18: 194 }, { 10: [1, 195], 42: $Vd, 58: $Ve, 86: $Vk, 99: $Vl, 102: $Vm, 103: $Vn, 106: $Vo, 108: $Vp, 110: 109, 111: $Vq, 112: $Vr, 113: $Vs }, { 10: [1, 196] }, { 10: [1, 197], 103: [1, 198] }, o($Vq1, [2, 121]), { 10: [1, 199], 42: $Vd, 58: $Ve, 86: $Vk, 99: $Vl, 102: $Vm, 103: $Vn, 106: $Vo, 108: $Vp, 110: 109, 111: $Vq, 112: $Vr, 113: $Vs }, { 10: [1, 200], 42: $Vd, 58: $Ve, 86: $Vk, 99: $Vl, 102: $Vm, 103: $Vn, 106: $Vo, 108: $Vp, 110: 109, 111: $Vq, 112: $Vr, 113: $Vs }, { 77: [1, 201] }, o($Vg1, [2, 102], { 10: [1, 202] }), o($Vg1, [2, 104], { 10: [1, 203] }), { 77: [1, 204] }, o($Vh1, [2, 177]), { 77: [1, 205], 95: [1, 206] }, o($VO, [2, 50], { 110: 109, 42: $Vd, 58: $Ve, 86: $Vk, 99: $Vl, 102: $Vm, 103: $Vn, 106: $Vo, 108: $Vp, 111: $Vq, 112: $Vr, 113: $Vs }), { 31: [1, 207], 65: $Vi1, 79: 208, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, o($Vr1, [2, 79]), o($Vr1, [2, 81]), o($Vr1, [2, 82]), o($Vr1, [2, 146]), o($Vr1, [2, 147]), o($Vr1, [2, 148]), o($Vr1, [2, 149]), { 47: [1, 209], 65: $Vi1, 79: 208, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 30: 210, 65: $Vi1, 77: $Vj1, 78: $Vk1, 79: 164, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 49: [1, 211], 65: $Vi1, 79: 208, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 51: [1, 212], 65: $Vi1, 79: 208, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 53: [1, 213], 65: $Vi1, 79: 208, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 55: [1, 214], 65: $Vi1, 79: 208, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 58: [1, 215] }, { 62: [1, 216], 65: $Vi1, 79: 208, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 64: [1, 217], 65: $Vi1, 79: 208, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 30: 218, 65: $Vi1, 77: $Vj1, 78: $Vk1, 79: 164, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 31: [1, 219], 65: $Vi1, 79: 208, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 65: $Vi1, 67: [1, 220], 69: [1, 221], 79: 208, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 65: $Vi1, 67: [1, 223], 69: [1, 222], 79: 208, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, o($VC, [2, 44], { 42: $Vf1 }), o($VS, [2, 70]), o($VS, [2, 69]), { 60: [1, 224], 65: $Vi1, 79: 208, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, o($VS, [2, 72]), o($Vo1, [2, 74]), { 30: 225, 65: $Vi1, 77: $Vj1, 78: $Vk1, 79: 164, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, o($Ve1, $V4, { 5: 226 }), o($Vp1, [2, 95]), o($Vy, [2, 35]), { 41: 227, 42: $Vd, 43: 39, 45: 40, 58: $Ve, 86: $Vk, 99: $Vl, 102: $Vm, 103: $Vn, 106: $Vo, 108: $Vp, 110: 41, 111: $Vq, 112: $Vr, 113: $Vs }, { 10: $Vs1, 58: $Vt1, 81: $Vu1, 89: 228, 102: $Vv1, 104: 229, 105: 230, 106: $Vw1, 107: $Vx1, 108: $Vy1, 109: $Vz1 }, { 10: $Vs1, 58: $Vt1, 81: $Vu1, 89: 239, 101: [1, 240], 102: $Vv1, 104: 229, 105: 230, 106: $Vw1, 107: $Vx1, 108: $Vy1, 109: $Vz1 }, { 10: $Vs1, 58: $Vt1, 81: $Vu1, 89: 241, 101: [1, 242], 102: $Vv1, 104: 229, 105: 230, 106: $Vw1, 107: $Vx1, 108: $Vy1, 109: $Vz1 }, { 102: [1, 243] }, { 10: $Vs1, 58: $Vt1, 81: $Vu1, 89: 244, 102: $Vv1, 104: 229, 105: 230, 106: $Vw1, 107: $Vx1, 108: $Vy1, 109: $Vz1 }, { 42: $Vd, 45: 245, 58: $Ve, 86: $Vk, 99: $Vl, 102: $Vm, 103: $Vn, 106: $Vo, 108: $Vp, 110: 41, 111: $Vq, 112: $Vr, 113: $Vs }, o($Vg1, [2, 101]), { 77: [1, 246] }, { 77: [1, 247], 95: [1, 248] }, o($Vg1, [2, 109]), o($Vg1, [2, 111], { 10: [1, 249] }), o($Vg1, [2, 112]), o($VP, [2, 51]), o($Vr1, [2, 80]), o($VP, [2, 52]), { 49: [1, 250], 65: $Vi1, 79: 208, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, o($VP, [2, 59]), o($VP, [2, 54]), o($VP, [2, 55]), o($VP, [2, 56]), { 106: [1, 251] }, o($VP, [2, 58]), o($VP, [2, 60]), { 64: [1, 252], 65: $Vi1, 79: 208, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, o($VP, [2, 62]), o($VP, [2, 63]), o($VP, [2, 65]), o($VP, [2, 64]), o($VP, [2, 66]), o([10, 42, 58, 86, 99, 102, 103, 106, 108, 111, 112, 113], [2, 78]), { 31: [1, 253], 65: $Vi1, 79: 208, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 6: 11, 7: 12, 8: $V5, 9: $V6, 10: $V7, 11: $V8, 20: 17, 22: 18, 23: 19, 24: 20, 25: 21, 26: 22, 27: $V9, 32: [1, 254], 33: 24, 34: $Va, 36: $Vb, 38: $Vc, 40: 28, 41: 38, 42: $Vd, 43: 39, 45: 40, 58: $Ve, 81: $Vf, 82: $Vg, 83: $Vh, 84: $Vi, 85: $Vj, 86: $Vk, 99: $Vl, 102: $Vm, 103: $Vn, 106: $Vo, 108: $Vp, 110: 41, 111: $Vq, 112: $Vr, 113: $Vs, 118: $Vt, 119: $Vu, 120: $Vv, 121: $Vw }, o($VO, [2, 48]), o($Vg1, [2, 114], { 103: $VA1 }), o($VB1, [2, 123], { 105: 256, 10: $Vs1, 58: $Vt1, 81: $Vu1, 102: $Vv1, 106: $Vw1, 107: $Vx1, 108: $Vy1, 109: $Vz1 }), o($VC1, [2, 125]), o($VC1, [2, 127]), o($VC1, [2, 128]), o($VC1, [2, 129]), o($VC1, [2, 130]), o($VC1, [2, 131]), o($VC1, [2, 132]), o($VC1, [2, 133]), o($VC1, [2, 134]), o($Vg1, [2, 115], { 103: $VA1 }), { 10: [1, 257] }, o($Vg1, [2, 116], { 103: $VA1 }), { 10: [1, 258] }, o($Vq1, [2, 122]), o($Vg1, [2, 98], { 103: $VA1 }), o($Vg1, [2, 99], { 110: 109, 42: $Vd, 58: $Ve, 86: $Vk, 99: $Vl, 102: $Vm, 103: $Vn, 106: $Vo, 108: $Vp, 111: $Vq, 112: $Vr, 113: $Vs }), o($Vg1, [2, 103]), o($Vg1, [2, 105], { 10: [1, 259] }), o($Vg1, [2, 106]), { 95: [1, 260] }, { 49: [1, 261] }, { 60: [1, 262] }, { 64: [1, 263] }, { 8: $Vz, 9: $VA, 11: $VB, 21: 264 }, o($Vy, [2, 34]), { 10: $Vs1, 58: $Vt1, 81: $Vu1, 102: $Vv1, 104: 265, 105: 230, 106: $Vw1, 107: $Vx1, 108: $Vy1, 109: $Vz1 }, o($VC1, [2, 126]), { 14: $VD, 42: $VE, 58: $VF, 86: $VG, 98: 266, 102: $VH, 103: $VI, 106: $VJ, 108: $VK, 111: $VL, 112: $VM, 113: $VN, 117: 84 }, { 14: $VD, 42: $VE, 58: $VF, 86: $VG, 98: 267, 102: $VH, 103: $VI, 106: $VJ, 108: $VK, 111: $VL, 112: $VM, 113: $VN, 117: 84 }, { 95: [1, 268] }, o($Vg1, [2, 113]), o($VP, [2, 53]), { 30: 269, 65: $Vi1, 77: $Vj1, 78: $Vk1, 79: 164, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, o($VP, [2, 61]), o($Ve1, $V4, { 5: 270 }), o($VB1, [2, 124], { 105: 256, 10: $Vs1, 58: $Vt1, 81: $Vu1, 102: $Vv1, 106: $Vw1, 107: $Vx1, 108: $Vy1, 109: $Vz1 }), o($Vg1, [2, 119], { 117: 160, 10: [1, 271], 14: $VD, 42: $VE, 58: $VF, 86: $VG, 102: $VH, 103: $VI, 106: $VJ, 108: $VK, 111: $VL, 112: $VM, 113: $VN }), o($Vg1, [2, 120], { 117: 160, 10: [1, 272], 14: $VD, 42: $VE, 58: $VF, 86: $VG, 102: $VH, 103: $VI, 106: $VJ, 108: $VK, 111: $VL, 112: $VM, 113: $VN }), o($Vg1, [2, 107]), { 31: [1, 273], 65: $Vi1, 79: 208, 113: $Vl1, 114: $Vm1, 115: $Vn1 }, { 6: 11, 7: 12, 8: $V5, 9: $V6, 10: $V7, 11: $V8, 20: 17, 22: 18, 23: 19, 24: 20, 25: 21, 26: 22, 27: $V9, 32: [1, 274], 33: 24, 34: $Va, 36: $Vb, 38: $Vc, 40: 28, 41: 38, 42: $Vd, 43: 39, 45: 40, 58: $Ve, 81: $Vf, 82: $Vg, 83: $Vh, 84: $Vi, 85: $Vj, 86: $Vk, 99: $Vl, 102: $Vm, 103: $Vn, 106: $Vo, 108: $Vp, 110: 41, 111: $Vq, 112: $Vr, 113: $Vs, 118: $Vt, 119: $Vu, 120: $Vv, 121: $Vw }, { 10: $Vs1, 58: $Vt1, 81: $Vu1, 89: 275, 102: $Vv1, 104: 229, 105: 230, 106: $Vw1, 107: $Vx1, 108: $Vy1, 109: $Vz1 }, { 10: $Vs1, 58: $Vt1, 81: $Vu1, 89: 276, 102: $Vv1, 104: 229, 105: 230, 106: $Vw1, 107: $Vx1, 108: $Vy1, 109: $Vz1 }, o($VP, [2, 57]), o($Vy, [2, 33]), o($Vg1, [2, 117], { 103: $VA1 }), o($Vg1, [2, 118], { 103: $VA1 })],
      defaultActions: {},
      parseError: function parseError(str2, hash) {
        if (hash.recoverable) {
          this.trace(str2);
        } else {
          var error = new Error(str2);
          error.hash = hash;
          throw error;
        }
      },
      parse: function parse2(input) {
        var self2 = this, stack = [0], tstack = [], vstack = [null], lstack = [], table = this.table, yytext = "", yylineno = 0, yyleng = 0, TERROR = 2, EOF = 1;
        var args = lstack.slice.call(arguments, 1);
        var lexer2 = Object.create(this.lexer);
        var sharedState = { yy: {} };
        for (var k in this.yy) {
          if (Object.prototype.hasOwnProperty.call(this.yy, k)) {
            sharedState.yy[k] = this.yy[k];
          }
        }
        lexer2.setInput(input, sharedState.yy);
        sharedState.yy.lexer = lexer2;
        sharedState.yy.parser = this;
        if (typeof lexer2.yylloc == "undefined") {
          lexer2.yylloc = {};
        }
        var yyloc = lexer2.yylloc;
        lstack.push(yyloc);
        var ranges = lexer2.options && lexer2.options.ranges;
        if (typeof sharedState.yy.parseError === "function") {
          this.parseError = sharedState.yy.parseError;
        } else {
          this.parseError = Object.getPrototypeOf(this).parseError;
        }
        function lex2() {
          var token2;
          token2 = tstack.pop() || lexer2.lex() || EOF;
          if (typeof token2 !== "number") {
            if (token2 instanceof Array) {
              tstack = token2;
              token2 = tstack.pop();
            }
            token2 = self2.symbols_[token2] || token2;
          }
          return token2;
        }
        var symbol, state2, action, r, yyval = {}, p, len, newState, expected;
        while (true) {
          state2 = stack[stack.length - 1];
          if (this.defaultActions[state2]) {
            action = this.defaultActions[state2];
          } else {
            if (symbol === null || typeof symbol == "undefined") {
              symbol = lex2();
            }
            action = table[state2] && table[state2][symbol];
          }
          if (typeof action === "undefined" || !action.length || !action[0]) {
            var errStr = "";
            expected = [];
            for (p in table[state2]) {
              if (this.terminals_[p] && p > TERROR) {
                expected.push("'" + this.terminals_[p] + "'");
              }
            }
            if (lexer2.showPosition) {
              errStr = "Parse error on line " + (yylineno + 1) + ":\n" + lexer2.showPosition() + "\nExpecting " + expected.join(", ") + ", got '" + (this.terminals_[symbol] || symbol) + "'";
            } else {
              errStr = "Parse error on line " + (yylineno + 1) + ": Unexpected " + (symbol == EOF ? "end of input" : "'" + (this.terminals_[symbol] || symbol) + "'");
            }
            this.parseError(errStr, {
              text: lexer2.match,
              token: this.terminals_[symbol] || symbol,
              line: lexer2.yylineno,
              loc: yyloc,
              expected
            });
          }
          if (action[0] instanceof Array && action.length > 1) {
            throw new Error("Parse Error: multiple actions possible at state: " + state2 + ", token: " + symbol);
          }
          switch (action[0]) {
            case 1:
              stack.push(symbol);
              vstack.push(lexer2.yytext);
              lstack.push(lexer2.yylloc);
              stack.push(action[1]);
              symbol = null;
              {
                yyleng = lexer2.yyleng;
                yytext = lexer2.yytext;
                yylineno = lexer2.yylineno;
                yyloc = lexer2.yylloc;
              }
              break;
            case 2:
              len = this.productions_[action[1]][1];
              yyval.$ = vstack[vstack.length - len];
              yyval._$ = {
                first_line: lstack[lstack.length - (len || 1)].first_line,
                last_line: lstack[lstack.length - 1].last_line,
                first_column: lstack[lstack.length - (len || 1)].first_column,
                last_column: lstack[lstack.length - 1].last_column
              };
              if (ranges) {
                yyval._$.range = [
                  lstack[lstack.length - (len || 1)].range[0],
                  lstack[lstack.length - 1].range[1]
                ];
              }
              r = this.performAction.apply(yyval, [
                yytext,
                yyleng,
                yylineno,
                sharedState.yy,
                action[1],
                vstack,
                lstack
              ].concat(args));
              if (typeof r !== "undefined") {
                return r;
              }
              if (len) {
                stack = stack.slice(0, -1 * len * 2);
                vstack = vstack.slice(0, -1 * len);
                lstack = lstack.slice(0, -1 * len);
              }
              stack.push(this.productions_[action[1]][0]);
              vstack.push(yyval.$);
              lstack.push(yyval._$);
              newState = table[stack[stack.length - 2]][stack[stack.length - 1]];
              stack.push(newState);
              break;
            case 3:
              return true;
          }
        }
        return true;
      }
    };
    var lexer = function() {
      var lexer2 = {
        EOF: 1,
        parseError: function parseError(str2, hash) {
          if (this.yy.parser) {
            this.yy.parser.parseError(str2, hash);
          } else {
            throw new Error(str2);
          }
        },
        // resets the lexer, sets new input
        setInput: function(input, yy) {
          this.yy = yy || this.yy || {};
          this._input = input;
          this._more = this._backtrack = this.done = false;
          this.yylineno = this.yyleng = 0;
          this.yytext = this.matched = this.match = "";
          this.conditionStack = ["INITIAL"];
          this.yylloc = {
            first_line: 1,
            first_column: 0,
            last_line: 1,
            last_column: 0
          };
          if (this.options.ranges) {
            this.yylloc.range = [0, 0];
          }
          this.offset = 0;
          return this;
        },
        // consumes and returns one char from the input
        input: function() {
          var ch = this._input[0];
          this.yytext += ch;
          this.yyleng++;
          this.offset++;
          this.match += ch;
          this.matched += ch;
          var lines = ch.match(/(?:\r\n?|\n).*/g);
          if (lines) {
            this.yylineno++;
            this.yylloc.last_line++;
          } else {
            this.yylloc.last_column++;
          }
          if (this.options.ranges) {
            this.yylloc.range[1]++;
          }
          this._input = this._input.slice(1);
          return ch;
        },
        // unshifts one char (or a string) into the input
        unput: function(ch) {
          var len = ch.length;
          var lines = ch.split(/(?:\r\n?|\n)/g);
          this._input = ch + this._input;
          this.yytext = this.yytext.substr(0, this.yytext.length - len);
          this.offset -= len;
          var oldLines = this.match.split(/(?:\r\n?|\n)/g);
          this.match = this.match.substr(0, this.match.length - 1);
          this.matched = this.matched.substr(0, this.matched.length - 1);
          if (lines.length - 1) {
            this.yylineno -= lines.length - 1;
          }
          var r = this.yylloc.range;
          this.yylloc = {
            first_line: this.yylloc.first_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.first_column,
            last_column: lines ? (lines.length === oldLines.length ? this.yylloc.first_column : 0) + oldLines[oldLines.length - lines.length].length - lines[0].length : this.yylloc.first_column - len
          };
          if (this.options.ranges) {
            this.yylloc.range = [r[0], r[0] + this.yyleng - len];
          }
          this.yyleng = this.yytext.length;
          return this;
        },
        // When called from action, caches matched text and appends it on next action
        more: function() {
          this._more = true;
          return this;
        },
        // When called from action, signals the lexer that this rule fails to match the input, so the next matching rule (regex) should be tested instead.
        reject: function() {
          if (this.options.backtrack_lexer) {
            this._backtrack = true;
          } else {
            return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". You can only invoke reject() in the lexer when the lexer is of the backtracking persuasion (options.backtrack_lexer = true).\n" + this.showPosition(), {
              text: "",
              token: null,
              line: this.yylineno
            });
          }
          return this;
        },
        // retain first n characters of the match
        less: function(n) {
          this.unput(this.match.slice(n));
        },
        // displays already matched input, i.e. for error messages
        pastInput: function() {
          var past = this.matched.substr(0, this.matched.length - this.match.length);
          return (past.length > 20 ? "..." : "") + past.substr(-20).replace(/\n/g, "");
        },
        // displays upcoming input, i.e. for error messages
        upcomingInput: function() {
          var next2 = this.match;
          if (next2.length < 20) {
            next2 += this._input.substr(0, 20 - next2.length);
          }
          return (next2.substr(0, 20) + (next2.length > 20 ? "..." : "")).replace(/\n/g, "");
        },
        // displays the character position where the lexing error occurred, i.e. for error messages
        showPosition: function() {
          var pre = this.pastInput();
          var c2 = new Array(pre.length + 1).join("-");
          return pre + this.upcomingInput() + "\n" + c2 + "^";
        },
        // test the lexed token: return FALSE when not a match, otherwise return token
        test_match: function(match, indexed_rule) {
          var token2, lines, backup;
          if (this.options.backtrack_lexer) {
            backup = {
              yylineno: this.yylineno,
              yylloc: {
                first_line: this.yylloc.first_line,
                last_line: this.last_line,
                first_column: this.yylloc.first_column,
                last_column: this.yylloc.last_column
              },
              yytext: this.yytext,
              match: this.match,
              matches: this.matches,
              matched: this.matched,
              yyleng: this.yyleng,
              offset: this.offset,
              _more: this._more,
              _input: this._input,
              yy: this.yy,
              conditionStack: this.conditionStack.slice(0),
              done: this.done
            };
            if (this.options.ranges) {
              backup.yylloc.range = this.yylloc.range.slice(0);
            }
          }
          lines = match[0].match(/(?:\r\n?|\n).*/g);
          if (lines) {
            this.yylineno += lines.length;
          }
          this.yylloc = {
            first_line: this.yylloc.last_line,
            last_line: this.yylineno + 1,
            first_column: this.yylloc.last_column,
            last_column: lines ? lines[lines.length - 1].length - lines[lines.length - 1].match(/\r?\n?/)[0].length : this.yylloc.last_column + match[0].length
          };
          this.yytext += match[0];
          this.match += match[0];
          this.matches = match;
          this.yyleng = this.yytext.length;
          if (this.options.ranges) {
            this.yylloc.range = [this.offset, this.offset += this.yyleng];
          }
          this._more = false;
          this._backtrack = false;
          this._input = this._input.slice(match[0].length);
          this.matched += match[0];
          token2 = this.performAction.call(this, this.yy, this, indexed_rule, this.conditionStack[this.conditionStack.length - 1]);
          if (this.done && this._input) {
            this.done = false;
          }
          if (token2) {
            return token2;
          } else if (this._backtrack) {
            for (var k in backup) {
              this[k] = backup[k];
            }
            return false;
          }
          return false;
        },
        // return next match in input
        next: function() {
          if (this.done) {
            return this.EOF;
          }
          if (!this._input) {
            this.done = true;
          }
          var token2, match, tempMatch, index2;
          if (!this._more) {
            this.yytext = "";
            this.match = "";
          }
          var rules = this._currentRules();
          for (var i2 = 0; i2 < rules.length; i2++) {
            tempMatch = this._input.match(this.rules[rules[i2]]);
            if (tempMatch && (!match || tempMatch[0].length > match[0].length)) {
              match = tempMatch;
              index2 = i2;
              if (this.options.backtrack_lexer) {
                token2 = this.test_match(tempMatch, rules[i2]);
                if (token2 !== false) {
                  return token2;
                } else if (this._backtrack) {
                  match = false;
                  continue;
                } else {
                  return false;
                }
              } else if (!this.options.flex) {
                break;
              }
            }
          }
          if (match) {
            token2 = this.test_match(match, rules[index2]);
            if (token2 !== false) {
              return token2;
            }
            return false;
          }
          if (this._input === "") {
            return this.EOF;
          } else {
            return this.parseError("Lexical error on line " + (this.yylineno + 1) + ". Unrecognized text.\n" + this.showPosition(), {
              text: "",
              token: null,
              line: this.yylineno
            });
          }
        },
        // return next match that has a token
        lex: function lex2() {
          var r = this.next();
          if (r) {
            return r;
          } else {
            return this.lex();
          }
        },
        // activates a new lexer condition state (pushes the new lexer condition state onto the condition stack)
        begin: function begin(condition) {
          this.conditionStack.push(condition);
        },
        // pop the previously active lexer condition state off the condition stack
        popState: function popState() {
          var n = this.conditionStack.length - 1;
          if (n > 0) {
            return this.conditionStack.pop();
          } else {
            return this.conditionStack[0];
          }
        },
        // produce the lexer rule set which is active for the currently active lexer condition state
        _currentRules: function _currentRules() {
          if (this.conditionStack.length && this.conditionStack[this.conditionStack.length - 1]) {
            return this.conditions[this.conditionStack[this.conditionStack.length - 1]].rules;
          } else {
            return this.conditions["INITIAL"].rules;
          }
        },
        // return the currently active lexer condition state; when an index argument is provided it produces the N-th previous condition state, if available
        topState: function topState(n) {
          n = this.conditionStack.length - 1 - Math.abs(n || 0);
          if (n >= 0) {
            return this.conditionStack[n];
          } else {
            return "INITIAL";
          }
        },
        // alias for begin(condition)
        pushState: function pushState(condition) {
          this.begin(condition);
        },
        // return the number of states currently on the stack
        stateStackSize: function stateStackSize() {
          return this.conditionStack.length;
        },
        options: {},
        performAction: function anonymous(yy, yy_, $avoiding_name_collisions, YY_START) {
          switch ($avoiding_name_collisions) {
            case 0:
              this.begin("acc_title");
              return 34;
            case 1:
              this.popState();
              return "acc_title_value";
            case 2:
              this.begin("acc_descr");
              return 36;
            case 3:
              this.popState();
              return "acc_descr_value";
            case 4:
              this.begin("acc_descr_multiline");
              break;
            case 5:
              this.popState();
              break;
            case 6:
              return "acc_descr_multiline_value";
            case 7:
              this.begin("callbackname");
              break;
            case 8:
              this.popState();
              break;
            case 9:
              this.popState();
              this.begin("callbackargs");
              break;
            case 10:
              return 92;
            case 11:
              this.popState();
              break;
            case 12:
              return 93;
            case 13:
              return "MD_STR";
            case 14:
              this.popState();
              break;
            case 15:
              this.begin("md_string");
              break;
            case 16:
              return "STR";
            case 17:
              this.popState();
              break;
            case 18:
              this.pushState("string");
              break;
            case 19:
              return 81;
            case 20:
              return 99;
            case 21:
              return 82;
            case 22:
              return 101;
            case 23:
              return 83;
            case 24:
              return 84;
            case 25:
              return 94;
            case 26:
              this.begin("click");
              break;
            case 27:
              this.popState();
              break;
            case 28:
              return 85;
            case 29:
              if (yy.lex.firstGraph()) {
                this.begin("dir");
              }
              return 12;
            case 30:
              if (yy.lex.firstGraph()) {
                this.begin("dir");
              }
              return 12;
            case 31:
              if (yy.lex.firstGraph()) {
                this.begin("dir");
              }
              return 12;
            case 32:
              return 27;
            case 33:
              return 32;
            case 34:
              return 95;
            case 35:
              return 95;
            case 36:
              return 95;
            case 37:
              return 95;
            case 38:
              this.popState();
              return 13;
            case 39:
              this.popState();
              return 14;
            case 40:
              this.popState();
              return 14;
            case 41:
              this.popState();
              return 14;
            case 42:
              this.popState();
              return 14;
            case 43:
              this.popState();
              return 14;
            case 44:
              this.popState();
              return 14;
            case 45:
              this.popState();
              return 14;
            case 46:
              this.popState();
              return 14;
            case 47:
              this.popState();
              return 14;
            case 48:
              this.popState();
              return 14;
            case 49:
              return 118;
            case 50:
              return 119;
            case 51:
              return 120;
            case 52:
              return 121;
            case 53:
              return 102;
            case 54:
              return 108;
            case 55:
              return 44;
            case 56:
              return 58;
            case 57:
              return 42;
            case 58:
              return 8;
            case 59:
              return 103;
            case 60:
              return 112;
            case 61:
              this.popState();
              return 75;
            case 62:
              this.pushState("edgeText");
              return 73;
            case 63:
              return 116;
            case 64:
              this.popState();
              return 75;
            case 65:
              this.pushState("thickEdgeText");
              return 73;
            case 66:
              return 116;
            case 67:
              this.popState();
              return 75;
            case 68:
              this.pushState("dottedEdgeText");
              return 73;
            case 69:
              return 116;
            case 70:
              return 75;
            case 71:
              this.popState();
              return 51;
            case 72:
              return "TEXT";
            case 73:
              this.pushState("ellipseText");
              return 50;
            case 74:
              this.popState();
              return 53;
            case 75:
              this.pushState("text");
              return 52;
            case 76:
              this.popState();
              return 55;
            case 77:
              this.pushState("text");
              return 54;
            case 78:
              return 56;
            case 79:
              this.pushState("text");
              return 65;
            case 80:
              this.popState();
              return 62;
            case 81:
              this.pushState("text");
              return 61;
            case 82:
              this.popState();
              return 47;
            case 83:
              this.pushState("text");
              return 46;
            case 84:
              this.popState();
              return 67;
            case 85:
              this.popState();
              return 69;
            case 86:
              return 114;
            case 87:
              this.pushState("trapText");
              return 66;
            case 88:
              this.pushState("trapText");
              return 68;
            case 89:
              return 115;
            case 90:
              return 65;
            case 91:
              return 87;
            case 92:
              return "SEP";
            case 93:
              return 86;
            case 94:
              return 112;
            case 95:
              return 108;
            case 96:
              return 42;
            case 97:
              return 106;
            case 98:
              return 111;
            case 99:
              return 113;
            case 100:
              this.popState();
              return 60;
            case 101:
              this.pushState("text");
              return 60;
            case 102:
              this.popState();
              return 49;
            case 103:
              this.pushState("text");
              return 48;
            case 104:
              this.popState();
              return 31;
            case 105:
              this.pushState("text");
              return 29;
            case 106:
              this.popState();
              return 64;
            case 107:
              this.pushState("text");
              return 63;
            case 108:
              return "TEXT";
            case 109:
              return "QUOTE";
            case 110:
              return 9;
            case 111:
              return 10;
            case 112:
              return 11;
          }
        },
        rules: [/^(?:accTitle\s*:\s*)/, /^(?:(?!\n||)*[^\n]*)/, /^(?:accDescr\s*:\s*)/, /^(?:(?!\n||)*[^\n]*)/, /^(?:accDescr\s*\{\s*)/, /^(?:[\}])/, /^(?:[^\}]*)/, /^(?:call[\s]+)/, /^(?:\([\s]*\))/, /^(?:\()/, /^(?:[^(]*)/, /^(?:\))/, /^(?:[^)]*)/, /^(?:[^`"]+)/, /^(?:[`]["])/, /^(?:["][`])/, /^(?:[^"]+)/, /^(?:["])/, /^(?:["])/, /^(?:style\b)/, /^(?:default\b)/, /^(?:linkStyle\b)/, /^(?:interpolate\b)/, /^(?:classDef\b)/, /^(?:class\b)/, /^(?:href[\s])/, /^(?:click[\s]+)/, /^(?:[\s\n])/, /^(?:[^\s\n]*)/, /^(?:flowchart-elk\b)/, /^(?:graph\b)/, /^(?:flowchart\b)/, /^(?:subgraph\b)/, /^(?:end\b\s*)/, /^(?:_self\b)/, /^(?:_blank\b)/, /^(?:_parent\b)/, /^(?:_top\b)/, /^(?:(\r?\n)*\s*\n)/, /^(?:\s*LR\b)/, /^(?:\s*RL\b)/, /^(?:\s*TB\b)/, /^(?:\s*BT\b)/, /^(?:\s*TD\b)/, /^(?:\s*BR\b)/, /^(?:\s*<)/, /^(?:\s*>)/, /^(?:\s*\^)/, /^(?:\s*v\b)/, /^(?:.*direction\s+TB[^\n]*)/, /^(?:.*direction\s+BT[^\n]*)/, /^(?:.*direction\s+RL[^\n]*)/, /^(?:.*direction\s+LR[^\n]*)/, /^(?:[0-9]+)/, /^(?:#)/, /^(?::::)/, /^(?::)/, /^(?:&)/, /^(?:;)/, /^(?:,)/, /^(?:\*)/, /^(?:\s*[xo<]?--+[-xo>]\s*)/, /^(?:\s*[xo<]?--\s*)/, /^(?:[^-]|-(?!-)+)/, /^(?:\s*[xo<]?==+[=xo>]\s*)/, /^(?:\s*[xo<]?==\s*)/, /^(?:[^=]|=(?!))/, /^(?:\s*[xo<]?-?\.+-[xo>]?\s*)/, /^(?:\s*[xo<]?-\.\s*)/, /^(?:[^\.]|\.(?!))/, /^(?:\s*~~[\~]+\s*)/, /^(?:[-/\)][\)])/, /^(?:[^\(\)\[\]\{\}]|!\)+)/, /^(?:\(-)/, /^(?:\]\))/, /^(?:\(\[)/, /^(?:\]\])/, /^(?:\[\[)/, /^(?:\[\|)/, /^(?:>)/, /^(?:\)\])/, /^(?:\[\()/, /^(?:\)\)\))/, /^(?:\(\(\()/, /^(?:[\\(?=\])][\]])/, /^(?:\/(?=\])\])/, /^(?:\/(?!\])|\\(?!\])|[^\\\[\]\(\)\{\}\/]+)/, /^(?:\[\/)/, /^(?:\[\\)/, /^(?:<)/, /^(?:>)/, /^(?:\^)/, /^(?:\\\|)/, /^(?:v\b)/, /^(?:\*)/, /^(?:#)/, /^(?:&)/, /^(?:([A-Za-z0-9!"\#$%&'*+\.`?\\_\/]|-(?=[^\>\-\.])|(?!))+)/, /^(?:-)/, /^(?:[\u00AA\u00B5\u00BA\u00C0-\u00D6\u00D8-\u00F6]|[\u00F8-\u02C1\u02C6-\u02D1\u02E0-\u02E4\u02EC\u02EE\u0370-\u0374\u0376\u0377]|[\u037A-\u037D\u0386\u0388-\u038A\u038C\u038E-\u03A1\u03A3-\u03F5]|[\u03F7-\u0481\u048A-\u0527\u0531-\u0556\u0559\u0561-\u0587\u05D0-\u05EA]|[\u05F0-\u05F2\u0620-\u064A\u066E\u066F\u0671-\u06D3\u06D5\u06E5\u06E6\u06EE]|[\u06EF\u06FA-\u06FC\u06FF\u0710\u0712-\u072F\u074D-\u07A5\u07B1\u07CA-\u07EA]|[\u07F4\u07F5\u07FA\u0800-\u0815\u081A\u0824\u0828\u0840-\u0858\u08A0]|[\u08A2-\u08AC\u0904-\u0939\u093D\u0950\u0958-\u0961\u0971-\u0977]|[\u0979-\u097F\u0985-\u098C\u098F\u0990\u0993-\u09A8\u09AA-\u09B0\u09B2]|[\u09B6-\u09B9\u09BD\u09CE\u09DC\u09DD\u09DF-\u09E1\u09F0\u09F1\u0A05-\u0A0A]|[\u0A0F\u0A10\u0A13-\u0A28\u0A2A-\u0A30\u0A32\u0A33\u0A35\u0A36\u0A38\u0A39]|[\u0A59-\u0A5C\u0A5E\u0A72-\u0A74\u0A85-\u0A8D\u0A8F-\u0A91\u0A93-\u0AA8]|[\u0AAA-\u0AB0\u0AB2\u0AB3\u0AB5-\u0AB9\u0ABD\u0AD0\u0AE0\u0AE1\u0B05-\u0B0C]|[\u0B0F\u0B10\u0B13-\u0B28\u0B2A-\u0B30\u0B32\u0B33\u0B35-\u0B39\u0B3D\u0B5C]|[\u0B5D\u0B5F-\u0B61\u0B71\u0B83\u0B85-\u0B8A\u0B8E-\u0B90\u0B92-\u0B95\u0B99]|[\u0B9A\u0B9C\u0B9E\u0B9F\u0BA3\u0BA4\u0BA8-\u0BAA\u0BAE-\u0BB9\u0BD0]|[\u0C05-\u0C0C\u0C0E-\u0C10\u0C12-\u0C28\u0C2A-\u0C33\u0C35-\u0C39\u0C3D]|[\u0C58\u0C59\u0C60\u0C61\u0C85-\u0C8C\u0C8E-\u0C90\u0C92-\u0CA8\u0CAA-\u0CB3]|[\u0CB5-\u0CB9\u0CBD\u0CDE\u0CE0\u0CE1\u0CF1\u0CF2\u0D05-\u0D0C\u0D0E-\u0D10]|[\u0D12-\u0D3A\u0D3D\u0D4E\u0D60\u0D61\u0D7A-\u0D7F\u0D85-\u0D96\u0D9A-\u0DB1]|[\u0DB3-\u0DBB\u0DBD\u0DC0-\u0DC6\u0E01-\u0E30\u0E32\u0E33\u0E40-\u0E46\u0E81]|[\u0E82\u0E84\u0E87\u0E88\u0E8A\u0E8D\u0E94-\u0E97\u0E99-\u0E9F\u0EA1-\u0EA3]|[\u0EA5\u0EA7\u0EAA\u0EAB\u0EAD-\u0EB0\u0EB2\u0EB3\u0EBD\u0EC0-\u0EC4\u0EC6]|[\u0EDC-\u0EDF\u0F00\u0F40-\u0F47\u0F49-\u0F6C\u0F88-\u0F8C\u1000-\u102A]|[\u103F\u1050-\u1055\u105A-\u105D\u1061\u1065\u1066\u106E-\u1070\u1075-\u1081]|[\u108E\u10A0-\u10C5\u10C7\u10CD\u10D0-\u10FA\u10FC-\u1248\u124A-\u124D]|[\u1250-\u1256\u1258\u125A-\u125D\u1260-\u1288\u128A-\u128D\u1290-\u12B0]|[\u12B2-\u12B5\u12B8-\u12BE\u12C0\u12C2-\u12C5\u12C8-\u12D6\u12D8-\u1310]|[\u1312-\u1315\u1318-\u135A\u1380-\u138F\u13A0-\u13F4\u1401-\u166C]|[\u166F-\u167F\u1681-\u169A\u16A0-\u16EA\u1700-\u170C\u170E-\u1711]|[\u1720-\u1731\u1740-\u1751\u1760-\u176C\u176E-\u1770\u1780-\u17B3\u17D7]|[\u17DC\u1820-\u1877\u1880-\u18A8\u18AA\u18B0-\u18F5\u1900-\u191C]|[\u1950-\u196D\u1970-\u1974\u1980-\u19AB\u19C1-\u19C7\u1A00-\u1A16]|[\u1A20-\u1A54\u1AA7\u1B05-\u1B33\u1B45-\u1B4B\u1B83-\u1BA0\u1BAE\u1BAF]|[\u1BBA-\u1BE5\u1C00-\u1C23\u1C4D-\u1C4F\u1C5A-\u1C7D\u1CE9-\u1CEC]|[\u1CEE-\u1CF1\u1CF5\u1CF6\u1D00-\u1DBF\u1E00-\u1F15\u1F18-\u1F1D]|[\u1F20-\u1F45\u1F48-\u1F4D\u1F50-\u1F57\u1F59\u1F5B\u1F5D\u1F5F-\u1F7D]|[\u1F80-\u1FB4\u1FB6-\u1FBC\u1FBE\u1FC2-\u1FC4\u1FC6-\u1FCC\u1FD0-\u1FD3]|[\u1FD6-\u1FDB\u1FE0-\u1FEC\u1FF2-\u1FF4\u1FF6-\u1FFC\u2071\u207F]|[\u2090-\u209C\u2102\u2107\u210A-\u2113\u2115\u2119-\u211D\u2124\u2126\u2128]|[\u212A-\u212D\u212F-\u2139\u213C-\u213F\u2145-\u2149\u214E\u2183\u2184]|[\u2C00-\u2C2E\u2C30-\u2C5E\u2C60-\u2CE4\u2CEB-\u2CEE\u2CF2\u2CF3]|[\u2D00-\u2D25\u2D27\u2D2D\u2D30-\u2D67\u2D6F\u2D80-\u2D96\u2DA0-\u2DA6]|[\u2DA8-\u2DAE\u2DB0-\u2DB6\u2DB8-\u2DBE\u2DC0-\u2DC6\u2DC8-\u2DCE]|[\u2DD0-\u2DD6\u2DD8-\u2DDE\u2E2F\u3005\u3006\u3031-\u3035\u303B\u303C]|[\u3041-\u3096\u309D-\u309F\u30A1-\u30FA\u30FC-\u30FF\u3105-\u312D]|[\u3131-\u318E\u31A0-\u31BA\u31F0-\u31FF\u3400-\u4DB5\u4E00-\u9FCC]|[\uA000-\uA48C\uA4D0-\uA4FD\uA500-\uA60C\uA610-\uA61F\uA62A\uA62B]|[\uA640-\uA66E\uA67F-\uA697\uA6A0-\uA6E5\uA717-\uA71F\uA722-\uA788]|[\uA78B-\uA78E\uA790-\uA793\uA7A0-\uA7AA\uA7F8-\uA801\uA803-\uA805]|[\uA807-\uA80A\uA80C-\uA822\uA840-\uA873\uA882-\uA8B3\uA8F2-\uA8F7\uA8FB]|[\uA90A-\uA925\uA930-\uA946\uA960-\uA97C\uA984-\uA9B2\uA9CF\uAA00-\uAA28]|[\uAA40-\uAA42\uAA44-\uAA4B\uAA60-\uAA76\uAA7A\uAA80-\uAAAF\uAAB1\uAAB5]|[\uAAB6\uAAB9-\uAABD\uAAC0\uAAC2\uAADB-\uAADD\uAAE0-\uAAEA\uAAF2-\uAAF4]|[\uAB01-\uAB06\uAB09-\uAB0E\uAB11-\uAB16\uAB20-\uAB26\uAB28-\uAB2E]|[\uABC0-\uABE2\uAC00-\uD7A3\uD7B0-\uD7C6\uD7CB-\uD7FB\uF900-\uFA6D]|[\uFA70-\uFAD9\uFB00-\uFB06\uFB13-\uFB17\uFB1D\uFB1F-\uFB28\uFB2A-\uFB36]|[\uFB38-\uFB3C\uFB3E\uFB40\uFB41\uFB43\uFB44\uFB46-\uFBB1\uFBD3-\uFD3D]|[\uFD50-\uFD8F\uFD92-\uFDC7\uFDF0-\uFDFB\uFE70-\uFE74\uFE76-\uFEFC]|[\uFF21-\uFF3A\uFF41-\uFF5A\uFF66-\uFFBE\uFFC2-\uFFC7\uFFCA-\uFFCF]|[\uFFD2-\uFFD7\uFFDA-\uFFDC])/, /^(?:\|)/, /^(?:\|)/, /^(?:\))/, /^(?:\()/, /^(?:\])/, /^(?:\[)/, /^(?:(\}))/, /^(?:\{)/, /^(?:[^\[\]\(\)\{\}\|\"]+)/, /^(?:")/, /^(?:(\r?\n)+)/, /^(?:\s)/, /^(?:$)/],
        conditions: { "callbackargs": { "rules": [11, 12, 15, 18, 70, 73, 75, 77, 81, 83, 87, 88, 101, 103, 105, 107], "inclusive": false }, "callbackname": { "rules": [8, 9, 10, 15, 18, 70, 73, 75, 77, 81, 83, 87, 88, 101, 103, 105, 107], "inclusive": false }, "href": { "rules": [15, 18, 70, 73, 75, 77, 81, 83, 87, 88, 101, 103, 105, 107], "inclusive": false }, "click": { "rules": [15, 18, 27, 28, 70, 73, 75, 77, 81, 83, 87, 88, 101, 103, 105, 107], "inclusive": false }, "dottedEdgeText": { "rules": [15, 18, 67, 69, 70, 73, 75, 77, 81, 83, 87, 88, 101, 103, 105, 107], "inclusive": false }, "thickEdgeText": { "rules": [15, 18, 64, 66, 70, 73, 75, 77, 81, 83, 87, 88, 101, 103, 105, 107], "inclusive": false }, "edgeText": { "rules": [15, 18, 61, 63, 70, 73, 75, 77, 81, 83, 87, 88, 101, 103, 105, 107], "inclusive": false }, "trapText": { "rules": [15, 18, 70, 73, 75, 77, 81, 83, 84, 85, 86, 87, 88, 101, 103, 105, 107], "inclusive": false }, "ellipseText": { "rules": [15, 18, 70, 71, 72, 73, 75, 77, 81, 83, 87, 88, 101, 103, 105, 107], "inclusive": false }, "text": { "rules": [15, 18, 70, 73, 74, 75, 76, 77, 80, 81, 82, 83, 87, 88, 100, 101, 102, 103, 104, 105, 106, 107, 108], "inclusive": false }, "vertex": { "rules": [15, 18, 70, 73, 75, 77, 81, 83, 87, 88, 101, 103, 105, 107], "inclusive": false }, "dir": { "rules": [15, 18, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 70, 73, 75, 77, 81, 83, 87, 88, 101, 103, 105, 107], "inclusive": false }, "acc_descr_multiline": { "rules": [5, 6, 15, 18, 70, 73, 75, 77, 81, 83, 87, 88, 101, 103, 105, 107], "inclusive": false }, "acc_descr": { "rules": [3, 15, 18, 70, 73, 75, 77, 81, 83, 87, 88, 101, 103, 105, 107], "inclusive": false }, "acc_title": { "rules": [1, 15, 18, 70, 73, 75, 77, 81, 83, 87, 88, 101, 103, 105, 107], "inclusive": false }, "md_string": { "rules": [13, 14, 15, 18, 70, 73, 75, 77, 81, 83, 87, 88, 101, 103, 105, 107], "inclusive": false }, "string": { "rules": [15, 16, 17, 18, 70, 73, 75, 77, 81, 83, 87, 88, 101, 103, 105, 107], "inclusive": false }, "INITIAL": { "rules": [0, 2, 4, 7, 15, 18, 19, 20, 21, 22, 23, 24, 25, 26, 29, 30, 31, 32, 33, 34, 35, 36, 37, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 64, 65, 67, 68, 70, 73, 75, 77, 78, 79, 81, 83, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 101, 103, 105, 107, 109, 110, 111, 112], "inclusive": true } }
      };
      return lexer2;
    }();
    parser2.lexer = lexer;
    function Parser() {
      this.yy = {};
    }
    Parser.prototype = parser2;
    parser2.Parser = Parser;
    return new Parser();
  }();
  parser$t.parser = parser$t;
  const parser$u = parser$t;
  const MERMAID_DOM_ID_PREFIX$1 = "flowchart-";
  let vertexCounter = 0;
  let config$2 = getConfig$1();
  let vertices = {};
  let edges = [];
  let classes$3 = {};
  let subGraphs = [];
  let subGraphLookup = {};
  let tooltips = {};
  let subCount = 0;
  let firstGraphFlag = true;
  let direction$3;
  let version;
  let funs$1 = [];
  const sanitizeText$2 = (txt) => common$1.sanitizeText(txt, config$2);
  const lookUpDomId$1 = function(id2) {
    const veritceKeys = Object.keys(vertices);
    for (const veritceKey of veritceKeys) {
      if (vertices[veritceKey].id === id2) {
        return vertices[veritceKey].domId;
      }
    }
    return id2;
  };
  const addVertex = function(_id, textObj, type2, style, classes2, dir2, props = {}) {
    let txt;
    let id2 = _id;
    if (id2 === void 0) {
      return;
    }
    if (id2.trim().length === 0) {
      return;
    }
    if (vertices[id2] === void 0) {
      vertices[id2] = {
        id: id2,
        labelType: "text",
        domId: MERMAID_DOM_ID_PREFIX$1 + id2 + "-" + vertexCounter,
        styles: [],
        classes: []
      };
    }
    vertexCounter++;
    if (textObj !== void 0) {
      config$2 = getConfig$1();
      txt = sanitizeText$2(textObj.text.trim());
      vertices[id2].labelType = textObj.type;
      if (txt[0] === '"' && txt[txt.length - 1] === '"') {
        txt = txt.substring(1, txt.length - 1);
      }
      vertices[id2].text = txt;
    } else {
      if (vertices[id2].text === void 0) {
        vertices[id2].text = _id;
      }
    }
    if (type2 !== void 0) {
      vertices[id2].type = type2;
    }
    if (style !== void 0 && style !== null) {
      style.forEach(function(s) {
        vertices[id2].styles.push(s);
      });
    }
    if (classes2 !== void 0 && classes2 !== null) {
      classes2.forEach(function(s) {
        vertices[id2].classes.push(s);
      });
    }
    if (dir2 !== void 0) {
      vertices[id2].dir = dir2;
    }
    if (vertices[id2].props === void 0) {
      vertices[id2].props = props;
    } else if (props !== void 0) {
      Object.assign(vertices[id2].props, props);
    }
  };
  const addSingleLink = function(_start, _end, type2) {
    let start2 = _start;
    let end2 = _end;
    const edge = { start: start2, end: end2, type: void 0, text: "", labelType: "text" };
    log$1.info("abc78 Got edge...", edge);
    const linkTextObj = type2.text;
    if (linkTextObj !== void 0) {
      edge.text = sanitizeText$2(linkTextObj.text.trim());
      if (edge.text[0] === '"' && edge.text[edge.text.length - 1] === '"') {
        edge.text = edge.text.substring(1, edge.text.length - 1);
      }
      edge.labelType = linkTextObj.type;
    }
    if (type2 !== void 0) {
      edge.type = type2.type;
      edge.stroke = type2.stroke;
      edge.length = type2.length;
    }
    if ((edge == null ? void 0 : edge.length) > 10) {
      edge.length = 10;
    }
    if (edges.length < (config$2.maxEdges ?? 500)) {
      log$1.info("abc78 pushing edge...");
      edges.push(edge);
    } else {
      throw new Error(
        `Edge limit exceeded. ${edges.length} edges found, but the limit is ${config$2.maxEdges}.

Initialize mermaid with maxEdges set to a higher number to allow more edges. 
You cannot set this config via configuration inside the diagram as it is a secure config. 
You have to call mermaid.initialize.`
      );
    }
  };
  const addLink$1 = function(_start, _end, type2) {
    log$1.info("addLink (abc78)", _start, _end, type2);
    let i2, j;
    for (i2 = 0; i2 < _start.length; i2++) {
      for (j = 0; j < _end.length; j++) {
        addSingleLink(_start[i2], _end[j], type2);
      }
    }
  };
  const updateLinkInterpolate = function(positions, interp) {
    positions.forEach(function(pos) {
      if (pos === "default") {
        edges.defaultInterpolate = interp;
      } else {
        edges[pos].interpolate = interp;
      }
    });
  };
  const updateLink = function(positions, style) {
    positions.forEach(function(pos) {
      if (pos >= edges.length) {
        throw new Error(
          `The index ${pos} for linkStyle is out of bounds. Valid indices for linkStyle are between 0 and ${edges.length - 1}. (Help: Ensure that the index is within the range of existing edges.)`
        );
      }
      if (pos === "default") {
        edges.defaultStyle = style;
      } else {
        if (utils.isSubstringInArray("fill", style) === -1) {
          style.push("fill:none");
        }
        edges[pos].style = style;
      }
    });
  };
  const addClass$1 = function(ids, style) {
    ids.split(",").forEach(function(id2) {
      if (classes$3[id2] === void 0) {
        classes$3[id2] = { id: id2, styles: [], textStyles: [] };
      }
      if (style !== void 0 && style !== null) {
        style.forEach(function(s) {
          if (s.match("color")) {
            const newStyle = s.replace("fill", "bgFill").replace("color", "fill");
            classes$3[id2].textStyles.push(newStyle);
          }
          classes$3[id2].styles.push(s);
        });
      }
    });
  };
  const setDirection$3 = function(dir2) {
    direction$3 = dir2;
    if (direction$3.match(/.*</)) {
      direction$3 = "RL";
    }
    if (direction$3.match(/.*\^/)) {
      direction$3 = "BT";
    }
    if (direction$3.match(/.*>/)) {
      direction$3 = "LR";
    }
    if (direction$3.match(/.*v/)) {
      direction$3 = "TB";
    }
    if (direction$3 === "TD") {
      direction$3 = "TB";
    }
  };
  const setClass$1 = function(ids, className) {
    ids.split(",").forEach(function(_id) {
      let id2 = _id;
      if (vertices[id2] !== void 0) {
        vertices[id2].classes.push(className);
      }
      if (subGraphLookup[id2] !== void 0) {
        subGraphLookup[id2].classes.push(className);
      }
    });
  };
  const setTooltip$1 = function(ids, tooltip) {
    ids.split(",").forEach(function(id2) {
      if (tooltip !== void 0) {
        tooltips[version === "gen-1" ? lookUpDomId$1(id2) : id2] = sanitizeText$2(tooltip);
      }
    });
  };
  const setClickFun$1 = function(id2, functionName, functionArgs) {
    let domId = lookUpDomId$1(id2);
    if (getConfig$1().securityLevel !== "loose") {
      return;
    }
    if (functionName === void 0) {
      return;
    }
    let argList = [];
    if (typeof functionArgs === "string") {
      argList = functionArgs.split(/,(?=(?:(?:[^"]*"){2})*[^"]*$)/);
      for (let i2 = 0; i2 < argList.length; i2++) {
        let item = argList[i2].trim();
        if (item.charAt(0) === '"' && item.charAt(item.length - 1) === '"') {
          item = item.substr(1, item.length - 2);
        }
        argList[i2] = item;
      }
    }
    if (argList.length === 0) {
      argList.push(id2);
    }
    if (vertices[id2] !== void 0) {
      vertices[id2].haveCallback = true;
      funs$1.push(function() {
        const elem = document.querySelector(`[id="${domId}"]`);
        if (elem !== null) {
          elem.addEventListener(
            "click",
            function() {
              utils.runFunc(functionName, ...argList);
            },
            false
          );
        }
      });
    }
  };
  const setLink$2 = function(ids, linkStr, target) {
    ids.split(",").forEach(function(id2) {
      if (vertices[id2] !== void 0) {
        vertices[id2].link = utils.formatUrl(linkStr, config$2);
        vertices[id2].linkTarget = target;
      }
    });
    setClass$1(ids, "clickable");
  };
  const getTooltip$1 = function(id2) {
    if (tooltips.hasOwnProperty(id2)) {
      return tooltips[id2];
    }
    return void 0;
  };
  const setClickEvent$2 = function(ids, functionName, functionArgs) {
    ids.split(",").forEach(function(id2) {
      setClickFun$1(id2, functionName, functionArgs);
    });
    setClass$1(ids, "clickable");
  };
  const bindFunctions$2 = function(element2) {
    funs$1.forEach(function(fun) {
      fun(element2);
    });
  };
  const getDirection$3 = function() {
    return direction$3.trim();
  };
  const getVertices = function() {
    return vertices;
  };
  const getEdges$1 = function() {
    return edges;
  };
  const getClasses$8 = function() {
    return classes$3;
  };
  const setupToolTips$1 = function(element2) {
    let tooltipElem = d3select(".mermaidTooltip");
    if ((tooltipElem._groups || tooltipElem)[0][0] === null) {
      tooltipElem = d3select("body").append("div").attr("class", "mermaidTooltip").style("opacity", 0);
    }
    const svg2 = d3select(element2).select("svg");
    const nodes2 = svg2.selectAll("g.node");
    nodes2.on("mouseover", function() {
      const el = d3select(this);
      const title2 = el.attr("title");
      if (title2 === null) {
        return;
      }
      const rect2 = this.getBoundingClientRect();
      tooltipElem.transition().duration(200).style("opacity", ".9");
      tooltipElem.text(el.attr("title")).style("left", window.scrollX + rect2.left + (rect2.right - rect2.left) / 2 + "px").style("top", window.scrollY + rect2.bottom + "px");
      tooltipElem.html(tooltipElem.html().replace(/&lt;br\/&gt;/g, "<br/>"));
      el.classed("hover", true);
    }).on("mouseout", function() {
      tooltipElem.transition().duration(500).style("opacity", 0);
      const el = d3select(this);
      el.classed("hover", false);
    });
  };
  funs$1.push(setupToolTips$1);
  const clear$l = function(ver = "gen-1") {
    vertices = {};
    classes$3 = {};
    edges = [];
    funs$1 = [setupToolTips$1];
    subGraphs = [];
    subGraphLookup = {};
    subCount = 0;
    tooltips = {};
    firstGraphFlag = true;
    version = ver;
    config$2 = getConfig$1();
    clear$n();
  };
  const setGen = (ver) => {
    version = ver || "gen-2";
  };
  const defaultStyle = function() {
    return "fill:#ffa;stroke: #f66; stroke-width: 3px; stroke-dasharray: 5, 5;fill:#ffa;stroke: #666;";
  };
  const addSubGraph = function(_id, list2, _title) {
    let id2 = _id.text.trim();
    let title2 = _title.text;
    if (_id === _title && _title.text.match(/\s/)) {
      id2 = void 0;
    }
    function uniq(a) {
      const prims = { boolean: {}, number: {}, string: {} };
      const objs = [];
      let dir3;
      const nodeList2 = a.filter(function(item) {
        const type2 = typeof item;
        if (item.stmt && item.stmt === "dir") {
          dir3 = item.value;
          return false;
        }
        if (item.trim() === "") {
          return false;
        }
        if (type2 in prims) {
          return prims[type2].hasOwnProperty(item) ? false : prims[type2][item] = true;
        } else {
          return objs.includes(item) ? false : objs.push(item);
        }
      });
      return { nodeList: nodeList2, dir: dir3 };
    }
    let nodeList = [];
    const { nodeList: nl, dir: dir2 } = uniq(nodeList.concat.apply(nodeList, list2));
    nodeList = nl;
    if (version === "gen-1") {
      for (let i2 = 0; i2 < nodeList.length; i2++) {
        nodeList[i2] = lookUpDomId$1(nodeList[i2]);
      }
    }
    id2 = id2 || "subGraph" + subCount;
    title2 = title2 || "";
    title2 = sanitizeText$2(title2);
    subCount = subCount + 1;
    const subGraph = {
      id: id2,
      nodes: nodeList,
      title: title2.trim(),
      classes: [],
      dir: dir2,
      labelType: _title.type
    };
    log$1.info("Adding", subGraph.id, subGraph.nodes, subGraph.dir);
    subGraph.nodes = makeUniq(subGraph, subGraphs).nodes;
    subGraphs.push(subGraph);
    subGraphLookup[id2] = subGraph;
    return id2;
  };
  const getPosForId = function(id2) {
    for (const [i2, subGraph] of subGraphs.entries()) {
      if (subGraph.id === id2) {
        return i2;
      }
    }
    return -1;
  };
  let secCount = -1;
  const posCrossRef = [];
  const indexNodes2 = function(id2, pos) {
    const nodes2 = subGraphs[pos].nodes;
    secCount = secCount + 1;
    if (secCount > 2e3) {
      return;
    }
    posCrossRef[secCount] = pos;
    if (subGraphs[pos].id === id2) {
      return {
        result: true,
        count: 0
      };
    }
    let count = 0;
    let posCount = 1;
    while (count < nodes2.length) {
      const childPos = getPosForId(nodes2[count]);
      if (childPos >= 0) {
        const res = indexNodes2(id2, childPos);
        if (res.result) {
          return {
            result: true,
            count: posCount + res.count
          };
        } else {
          posCount = posCount + res.count;
        }
      }
      count = count + 1;
    }
    return {
      result: false,
      count: posCount
    };
  };
  const getDepthFirstPos = function(pos) {
    return posCrossRef[pos];
  };
  const indexNodes = function() {
    secCount = -1;
    if (subGraphs.length > 0) {
      indexNodes2("none", subGraphs.length - 1);
    }
  };
  const getSubGraphs = function() {
    return subGraphs;
  };
  const firstGraph = () => {
    if (firstGraphFlag) {
      firstGraphFlag = false;
      return true;
    }
    return false;
  };
  const destructStartLink = (_str) => {
    let str2 = _str.trim();
    let type2 = "arrow_open";
    switch (str2[0]) {
      case "<":
        type2 = "arrow_point";
        str2 = str2.slice(1);
        break;
      case "x":
        type2 = "arrow_cross";
        str2 = str2.slice(1);
        break;
      case "o":
        type2 = "arrow_circle";
        str2 = str2.slice(1);
        break;
    }
    let stroke = "normal";
    if (str2.includes("=")) {
      stroke = "thick";
    }
    if (str2.includes(".")) {
      stroke = "dotted";
    }
    return { type: type2, stroke };
  };
  const countChar = (char2, str2) => {
    const length2 = str2.length;
    let count = 0;
    for (let i2 = 0; i2 < length2; ++i2) {
      if (str2[i2] === char2) {
        ++count;
      }
    }
    return count;
  };
  const destructEndLink = (_str) => {
    const str2 = _str.trim();
    let line2 = str2.slice(0, -1);
    let type2 = "arrow_open";
    switch (str2.slice(-1)) {
      case "x":
        type2 = "arrow_cross";
        if (str2[0] === "x") {
          type2 = "double_" + type2;
          line2 = line2.slice(1);
        }
        break;
      case ">":
        type2 = "arrow_point";
        if (str2[0] === "<") {
          type2 = "double_" + type2;
          line2 = line2.slice(1);
        }
        break;
      case "o":
        type2 = "arrow_circle";
        if (str2[0] === "o") {
          type2 = "double_" + type2;
          line2 = line2.slice(1);
        }
        break;
    }
    let stroke = "normal";
    let length2 = line2.length - 1;
    if (line2[0] === "=") {
      stroke = "thick";
    }
    if (line2[0] === "~") {
      stroke = "invisible";
    }
    let dots = countChar(".", line2);
    if (dots) {
      stroke = "dotted";
      length2 = dots;
    }
    return { type: type2, stroke, length: length2 };
  };
  const destructLink = (_str, _startStr) => {
    const info2 = destructEndLink(_str);
    let startInfo;
    if (_startStr) {
      startInfo = destructStartLink(_startStr);
      if (startInfo.stroke !== info2.stroke) {
        return { type: "INVALID", stroke: "INVALID" };
      }
      if (startInfo.type === "arrow_open") {
        startInfo.type = info2.type;
      } else {
        if (startInfo.type !== info2.type) {
          return { type: "INVALID", stroke: "INVALID" };
        }
        startInfo.type = "double_" + startInfo.type;
      }
      if (startInfo.type === "double_arrow") {
        startInfo.type = "double_arrow_point";
      }
      startInfo.length = info2.length;
      return startInfo;
    }
    return info2;
  };
  const exists = (allSgs, _id) => {
    let res = false;
    allSgs.forEach((sg) => {
      const pos = sg.nodes.indexOf(_id);
      if (pos >= 0) {
        res = true;
      }
    });
    return res;
  };
  const makeUniq = (sg, allSubgraphs) => {
    const res = [];
    sg.nodes.forEach((_id, pos) => {
      if (!exists(allSubgraphs, _id)) {
        res.push(sg.nodes[pos]);
      }
    });
    return { nodes: res };
  };
  const lex = {
    firstGraph
  };
  const flowDb = {
    defaultConfig: () => defaultConfig.flowchart,
    setAccTitle,
    getAccTitle,
    getAccDescription,
    setAccDescription,
    addVertex,
    lookUpDomId: lookUpDomId$1,
    addLink: addLink$1,
    updateLinkInterpolate,
    updateLink,
    addClass: addClass$1,
    setDirection: setDirection$3,
    setClass: setClass$1,
    setTooltip: setTooltip$1,
    getTooltip: getTooltip$1,
    setClickEvent: setClickEvent$2,
    setLink: setLink$2,
    bindFunctions: bindFunctions$2,
    getDirection: getDirection$3,
    getVertices,
    getEdges: getEdges$1,
    getClasses: getClasses$8,
    clear: clear$l,
    setGen,
    defaultStyle,
    addSubGraph,
    getDepthFirstPos,
    indexNodes,
    getSubGraphs,
    destructLink,
    lex,
    exists,
    makeUniq,
    setDiagramTitle,
    getDiagramTitle
  };
  const db$f = /* @__PURE__ */ Object.freeze(/* @__PURE__ */ Object.defineProperty({
    __proto__: null,
    addClass: addClass$1,
    addLink: addLink$1,
    addSingleLink,
    addSubGraph,
    addVertex,
    bindFunctions: bindFunctions$2,
    clear: clear$l,
    default: flowDb,
    defaultStyle,
    destructLink,
    firstGraph,
    getClasses: getClasses$8,
    getDepthFirstPos,
    getDirection: getDirection$3,
    getEdges: getEdges$1,
    getSubGraphs,
    getTooltip: getTooltip$1,
    getVertices,
    indexNodes,
    lex,
    lookUpDomId: lookUpDomId$1,
    setClass: setClass$1,
    setClickEvent: setClickEvent$2,
    setDirection: setDirection$3,
    setGen,
    setLink: setLink$2,
    updateLink,
    updateLinkInterpolate
  }, Symbol.toStringTag, { value: "Module" }));
  var symbolTag$3 = "[object Symbol]";
  function isSymbol(value2) {
    return typeof value2 == "symbol" || isObjectLike(value2) && baseGetTag(value2) == symbolTag$3;
  }
  function arrayMap(array2, iteratee) {
    var index2 = -1, length2 = array2 == null ? 0 : array2.length, result = Array(length2);
    while (++index2 < length2) {
      result[index2] = iteratee(array2[index2], index2, array2);
    }
    return result;
  }
  var INFINITY$3 = 1 / 0;
  var symbolProto$2 = Symbol$2 ? Symbol$2.prototype : void 0, symbolToString = symbolProto$2 ? symbolProto$2.toString : void 0;
  function baseToString(value2) {
    if (typeof value2 == "string") {
      return value2;
    }
    if (isArray$1(value2)) {
      return arrayMap(value2, baseToString) + "";
    }
    if (isSymbol(value2)) {
      return symbolToString ? symbolToString.call(value2) : "";
    }
    var result = value2 + "";
    return result == "0" && 1 / value2 == -INFINITY$3 ? "-0" : result;
  }
  var reWhitespace = /\s/;
  function trimmedEndIndex(string2) {
    var index2 = string2.length;
    while (index2-- && reWhitespace.test(string2.charAt(index2))) {
    }
    return index2;
  }
  var reTrimStart = /^\s+/;
  function baseTrim(string2) {
    return string2 ? string2.slice(0, trimmedEndIndex(string2) + 1).replace(reTrimStart, "") : string2;
  }
  var NAN = 0 / 0;
  var reIsBadHex = /^[-+]0x[0-9a-f]+$/i;
  var reIsBinary = /^0b[01]+$/i;
  var reIsOctal = /^0o[0-7]+$/i;
  var freeParseInt = parseInt;
  function toNumber(value2) {
    if (typeof value2 == "number") {
      return value2;
    }
    if (isSymbol(value2)) {
      return NAN;
    }
    if (isObject$1(value2)) {
      var other = typeof value2.valueOf == "function" ? value2.valueOf() : value2;
      value2 = isObject$1(other) ? other + "" : other;
    }
    if (typeof value2 != "string") {
      return value2 === 0 ? value2 : +value2;
    }
    value2 = baseTrim(value2);
    var isBinary2 = reIsBinary.test(value2);
    return isBinary2 || reIsOctal.test(value2) ? freeParseInt(value2.slice(2), isBinary2 ? 2 : 8) : reIsBadHex.test(value2) ? NAN : +value2;
  }
  var INFINITY$2 = 1 / 0, MAX_INTEGER = 17976931348623157e292;
  function toFinite(value2) {
    if (!value2) {
      return value2 === 0 ? value2 : 0;
    }
    value2 = toNumber(value2);
    if (value2 === INFINITY$2 || value2 === -INFINITY$2) {
      var sign2 = value2 < 0 ? -1 : 1;
      return sign2 * MAX_INTEGER;
    }
    return value2 === value2 ? value2 : 0;
  }
  function toInteger(value2) {
    var result = toFinite(value2), remainder = result % 1;
    return result === result ? remainder ? result - remainder : result : 0;
  }
  function noop() {
  }
  function arrayEach(array2, iteratee) {
    var index2 = -1, length2 = array2 == null ? 0 : array2.length;
    while (++index2 < length2) {
      if (iteratee(array2[index2], index2, array2) === false) {
        break;
      }
    }
    return array2;
  }
  function baseFindIndex(array2, predicate, fromIndex, fromRight) {
    var length2 = array2.length, index2 = fromIndex + (fromRight ? 1 : -1);
    while (fromRight ? index2-- : ++index2 < length2) {
      if (predicate(array2[index2], index2, array2)) {
        return index2;
      }
    }
    return -1;
  }
  function baseIsNaN(value2) {
    return value2 !== value2;
  }
  function strictIndexOf(array2, value2, fromIndex) {
    var index2 = fromIndex - 1, length2 = array2.length;
    while (++index2 < length2) {
      if (array2[index2] === value2) {
        return index2;
      }
    }
    return -1;
  }
  function baseIndexOf(array2, value2, fromIndex) {
    return value2 === value2 ? strictIndexOf(array2, value2, fromIndex) : baseFindIndex(array2, baseIsNaN, fromIndex);
  }
  function arrayIncludes(array2, value2) {
    var length2 = array2 == null ? 0 : array2.length;
    return !!length2 && baseIndexOf(array2, value2, 0) > -1;
  }
  function keys$1(object2) {
    return isArrayLike(object2) ? arrayLikeKeys(object2) : baseKeys(object2);
  }
  var reIsDeepProp = /\.|\[(?:[^[\]]*|(["'])(?:(?!\1)[^\\]|\\.)*?\1)\]/, reIsPlainProp = /^\w*$/;
  function isKey(value2, object2) {
    if (isArray$1(value2)) {
      return false;
    }
    var type2 = typeof value2;
    if (type2 == "number" || type2 == "symbol" || type2 == "boolean" || value2 == null || isSymbol(value2)) {
      return true;
    }
    return reIsPlainProp.test(value2) || !reIsDeepProp.test(value2) || object2 != null && value2 in Object(object2);
  }
  var MAX_MEMOIZE_SIZE = 500;
  function memoizeCapped(func) {
    var result = memoize(func, function(key) {
      if (cache.size === MAX_MEMOIZE_SIZE) {
        cache.clear();
      }
      return key;
    });
    var cache = result.cache;
    return result;
  }
  var rePropName = /[^.[\]]+|\[(?:(-?\d+(?:\.\d+)?)|(["'])((?:(?!\2)[^\\]|\\.)*?)\2)\]|(?=(?:\.|\[\])(?:\.|\[\]|$))/g;
  var reEscapeChar = /\\(\\)?/g;
  var stringToPath = memoizeCapped(function(string2) {
    var result = [];
    if (string2.charCodeAt(0) === 46) {
      result.push("");
    }
    string2.replace(rePropName, function(match, number2, quote, subString) {
      result.push(quote ? subString.replace(reEscapeChar, "$1") : number2 || match);
    });
    return result;
  });
  const stringToPath$1 = stringToPath;
  function toString$1(value2) {
    return value2 == null ? "" : baseToString(value2);
  }
  function castPath(value2, object2) {
    if (isArray$1(value2)) {
      return value2;
    }
    return isKey(value2, object2) ? [value2] : stringToPath$1(toString$1(value2));
  }
  var INFINITY$1 = 1 / 0;
  function toKey(value2) {
    if (typeof value2 == "string" || isSymbol(value2)) {
      return value2;
    }
    var result = value2 + "";
    return result == "0" && 1 / value2 == -INFINITY$1 ? "-0" : result;
  }
  function baseGet(object2, path2) {
    path2 = castPath(path2, object2);
    var index2 = 0, length2 = path2.length;
    while (object2 != null && index2 < length2) {
      object2 = object2[toKey(path2[index2++])];
    }
    return index2 && index2 == length2 ? object2 : void 0;
  }
  function get$1(object2, path2, defaultValue) {
    var result = object2 == null ? void 0 : baseGet(object2, path2);
    return result === void 0 ? defaultValue : result;
  }
  function arrayPush(array2, values2) {
    var index2 = -1, length2 = values2.length, offset = array2.length;
    while (++index2 < length2) {
      array2[offset + index2] = values2[index2];
    }
    return array2;
  }
  var spreadableSymbol = Symbol$2 ? Symbol$2.isConcatSpreadable : void 0;
  function isFlattenable(value2) {
    return isArray$1(value2) || isArguments$1(value2) || !!(spreadableSymbol && value2 && value2[spreadableSymbol]);
  }
  function baseFlatten(array2, depth, predicate, isStrict, result) {
    var index2 = -1, length2 = array2.length;
    predicate || (predicate = isFlattenable);
    result || (result = []);
    while (++index2 < length2) {
      var value2 = array2[index2];
      if (depth > 0 && predicate(value2)) {
        if (depth > 1) {
          baseFlatten(value2, depth - 1, predicate, isStrict, result);
        } else {
          arrayPush(result, value2);
        }
      } else if (!isStrict) {
        result[result.length] = value2;
      }
    }
    return result;
  }
  function flatten(array2) {
    var length2 = array2 == null ? 0 : array2.length;
    return length2 ? baseFlatten(array2, 1) : [];
  }
  function flatRest(func) {
    return setToString$1(overRest(func, void 0, flatten), func + "");
  }
  function arrayReduce(array2, iteratee, accumulator, initAccum) {
    var index2 = -1, length2 = array2 == null ? 0 : array2.length;
    if (initAccum && length2) {
      accumulator = array2[++index2];
    }
    while (++index2 < length2) {
      accumulator = iteratee(accumulator, array2[index2], index2, array2);
    }
    return accumulator;
  }
  function baseAssign(object2, source) {
    return object2 && copyObject(source, keys$1(source), object2);
  }
  function baseAssignIn(object2, source) {
    return object2 && copyObject(source, keysIn(source), object2);
  }
  function arrayFilter(array2, predicate) {
    var index2 = -1, length2 = array2 == null ? 0 : array2.length, resIndex = 0, result = [];
    while (++index2 < length2) {
      var value2 = array2[index2];
      if (predicate(value2, index2, array2)) {
        result[resIndex++] = value2;
      }
    }
    return result;
  }
  function stubArray() {
    return [];
  }
  var objectProto$5 = Object.prototype;
  var propertyIsEnumerable = objectProto$5.propertyIsEnumerable;
  var nativeGetSymbols$1 = Object.getOwnPropertySymbols;
  var getSymbols = !nativeGetSymbols$1 ? stubArray : function(object2) {
    if (object2 == null) {
      return [];
    }
    object2 = Object(object2);
    return arrayFilter(nativeGetSymbols$1(object2), function(symbol) {
      return propertyIsEnumerable.call(object2, symbol);
    });
  };
  const getSymbols$1 = getSymbols;
  function copySymbols(source, object2) {
    return copyObject(source, getSymbols$1(source), object2);
  }
  var nativeGetSymbols = Object.getOwnPropertySymbols;
  var getSymbolsIn = !nativeGetSymbols ? stubArray : function(object2) {
    var result = [];
    while (object2) {
      arrayPush(result, getSymbols$1(object2));
      object2 = getPrototype$1(object2);
    }
    return result;
  };
  const getSymbolsIn$1 = getSymbolsIn;
  function copySymbolsIn(source, object2) {
    return copyObject(source, getSymbolsIn$1(source), object2);
  }
  function baseGetAllKeys(object2, keysFunc, symbolsFunc) {
    var result = keysFunc(object2);
    return isArray$1(object2) ? result : arrayPush(result, symbolsFunc(object2));
  }
  function getAllKeys(object2) {
    return baseGetAllKeys(object2, keys$1, getSymbols$1);
  }
  function getAllKeysIn(object2) {
    return baseGetAllKeys(object2, keysIn, getSymbolsIn$1);
  }
  var objectProto$4 = Object.prototype;
  var hasOwnProperty$5 = objectProto$4.hasOwnProperty;
  function initCloneArray(array2) {
    var length2 = array2.length, result = new array2.constructor(length2);
    if (length2 && typeof array2[0] == "string" && hasOwnProperty$5.call(array2, "index")) {
      result.index = array2.index;
      result.input = array2.input;
    }
    return result;
  }
  function cloneDataView(dataView, isDeep) {
    var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;
    return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);
  }
  var reFlags = /\w*$/;
  function cloneRegExp(regexp) {
    var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));
    result.lastIndex = regexp.lastIndex;
    return result;
  }
  var symbolProto$1 = Symbol$2 ? Symbol$2.prototype : void 0, symbolValueOf$1 = symbolProto$1 ? symbolProto$1.valueOf : void 0;
  function cloneSymbol(symbol) {
    return symbolValueOf$1 ? Object(symbolValueOf$1.call(symbol)) : {};
  }
  var boolTag$2 = "[object Boolean]", dateTag$2 = "[object Date]", mapTag$3 = "[object Map]", numberTag$2 = "[object Number]", regexpTag$2 = "[object RegExp]", setTag$3 = "[object Set]", stringTag$2 = "[object String]", symbolTag$2 = "[object Symbol]";
  var arrayBufferTag$2 = "[object ArrayBuffer]", dataViewTag$2 = "[object DataView]", float32Tag$1 = "[object Float32Array]", float64Tag$1 = "[object Float64Array]", int8Tag$1 = "[object Int8Array]", int16Tag$1 = "[object Int16Array]", int32Tag$1 = "[object Int32Array]", uint8Tag$1 = "[object Uint8Array]", uint8ClampedTag$1 = "[object Uint8ClampedArray]", uint16Tag$1 = "[object Uint16Array]", uint32Tag$1 = "[object Uint32Array]";
  function initCloneByTag(object2, tag, isDeep) {
    var Ctor = object2.constructor;
    switch (tag) {
      case arrayBufferTag$2:
        return cloneArrayBuffer(object2);
      case boolTag$2:
      case dateTag$2:
        return new Ctor(+object2);
      case dataViewTag$2:
        return cloneDataView(object2, isDeep);
      case float32Tag$1:
      case float64Tag$1:
      case int8Tag$1:
      case int16Tag$1:
      case int32Tag$1:
      case uint8Tag$1:
      case uint8ClampedTag$1:
      case uint16Tag$1:
      case uint32Tag$1:
        return cloneTypedArray(object2, isDeep);
      case mapTag$3:
        return new Ctor();
      case numberTag$2:
      case stringTag$2:
        return new Ctor(object2);
      case regexpTag$2:
        return cloneRegExp(object2);
      case setTag$3:
        return new Ctor();
      case symbolTag$2:
        return cloneSymbol(object2);
    }
  }
  var mapTag$2 = "[object Map]";
  function baseIsMap(value2) {
    return isObjectLike(value2) && getTag$1(value2) == mapTag$2;
  }
  var nodeIsMap = nodeUtil$1 && nodeUtil$1.isMap;
  var isMap = nodeIsMap ? baseUnary(nodeIsMap) : baseIsMap;
  const isMap$1 = isMap;
  var setTag$2 = "[object Set]";
  function baseIsSet(value2) {
    return isObjectLike(value2) && getTag$1(value2) == setTag$2;
  }
  var nodeIsSet = nodeUtil$1 && nodeUtil$1.isSet;
  var isSet = nodeIsSet ? baseUnary(nodeIsSet) : baseIsSet;
  const isSet$1 = isSet;
  var CLONE_DEEP_FLAG$1 = 1, CLONE_FLAT_FLAG = 2, CLONE_SYMBOLS_FLAG$2 = 4;
  var argsTag$1 = "[object Arguments]", arrayTag$1 = "[object Array]", boolTag$1 = "[object Boolean]", dateTag$1 = "[object Date]", errorTag$1 = "[object Error]", funcTag = "[object Function]", genTag = "[object GeneratorFunction]", mapTag$1 = "[object Map]", numberTag$1 = "[object Number]", objectTag$1 = "[object Object]", regexpTag$1 = "[object RegExp]", setTag$1 = "[object Set]", stringTag$1 = "[object String]", symbolTag$1 = "[object Symbol]", weakMapTag = "[object WeakMap]";
  var arrayBufferTag$1 = "[object ArrayBuffer]", dataViewTag$1 = "[object DataView]", float32Tag = "[object Float32Array]", float64Tag = "[object Float64Array]", int8Tag = "[object Int8Array]", int16Tag = "[object Int16Array]", int32Tag = "[object Int32Array]", uint8Tag = "[object Uint8Array]", uint8ClampedTag = "[object Uint8ClampedArray]", uint16Tag = "[object Uint16Array]", uint32Tag = "[object Uint32Array]";
  var cloneableTags = {};
  cloneableTags[argsTag$1] = cloneableTags[arrayTag$1] = cloneableTags[arrayBufferTag$1] = cloneableTags[dataViewTag$1] = cloneableTags[boolTag$1] = cloneableTags[dateTag$1] = cloneableTags[float32Tag] = cloneableTags[float64Tag] = cloneableTags[int8Tag] = cloneableTags[int16Tag] = cloneableTags[int32Tag] = cloneableTags[mapTag$1] = cloneableTags[numberTag$1] = cloneableTags[objectTag$1] = cloneableTags[regexpTag$1] = cloneableTags[setTag$1] = cloneableTags[stringTag$1] = cloneableTags[symbolTag$1] = cloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] = cloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;
  cloneableTags[errorTag$1] = cloneableTags[funcTag] = cloneableTags[weakMapTag] = false;
  function baseClone(value2, bitmask, customizer, key, object2, stack) {
    var result, isDeep = bitmask & CLONE_DEEP_FLAG$1, isFlat = bitmask & CLONE_FLAT_FLAG, isFull = bitmask & CLONE_SYMBOLS_FLAG$2;
    if (customizer) {
      result = object2 ? customizer(value2, key, object2, stack) : customizer(value2);
    }
    if (result !== void 0) {
      return result;
    }
    if (!isObject$1(value2)) {
      return value2;
    }
    var isArr = isArray$1(value2);
    if (isArr) {
      result = initCloneArray(value2);
      if (!isDeep) {
        return copyArray(value2, result);
      }
    } else {
      var tag = getTag$1(value2), isFunc = tag == funcTag || tag == genTag;
      if (isBuffer$1(value2)) {
        return cloneBuffer(value2, isDeep);
      }
      if (tag == objectTag$1 || tag == argsTag$1 || isFunc && !object2) {
        result = isFlat || isFunc ? {} : initCloneObject(value2);
        if (!isDeep) {
          return isFlat ? copySymbolsIn(value2, baseAssignIn(result, value2)) : copySymbols(value2, baseAssign(result, value2));
        }
      } else {
        if (!cloneableTags[tag]) {
          return object2 ? value2 : {};
        }
        result = initCloneByTag(value2, tag, isDeep);
      }
    }
    stack || (stack = new Stack());
    var stacked = stack.get(value2);
    if (stacked) {
      return stacked;
    }
    stack.set(value2, result);
    if (isSet$1(value2)) {
      value2.forEach(function(subValue) {
        result.add(baseClone(subValue, bitmask, customizer, subValue, value2, stack));
      });
    } else if (isMap$1(value2)) {
      value2.forEach(function(subValue, key2) {
        result.set(key2, baseClone(subValue, bitmask, customizer, key2, value2, stack));
      });
    }
    var keysFunc = isFull ? isFlat ? getAllKeysIn : getAllKeys : isFlat ? keysIn : keys$1;
    var props = isArr ? void 0 : keysFunc(value2);
    arrayEach(props || value2, function(subValue, key2) {
      if (props) {
        key2 = subValue;
        subValue = value2[key2];
      }
      assignValue(result, key2, baseClone(subValue, bitmask, customizer, key2, value2, stack));
    });
    return result;
  }
  var CLONE_SYMBOLS_FLAG$1 = 4;
  function clone$1(value2) {
    return baseClone(value2, CLONE_SYMBOLS_FLAG$1);
  }
  var CLONE_DEEP_FLAG = 1, CLONE_SYMBOLS_FLAG = 4;
  function cloneDeep(value2) {
    return baseClone(value2, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG);
  }
  var HASH_UNDEFINED = "__lodash_hash_undefined__";
  function setCacheAdd(value2) {
    this.__data__.set(value2, HASH_UNDEFINED);
    return this;
  }
  function setCacheHas(value2) {
    return this.__data__.has(value2);
  }
  function SetCache(values2) {
    var index2 = -1, length2 = values2 == null ? 0 : values2.length;
    this.__data__ = new MapCache();
    while (++index2 < length2) {
      this.add(values2[index2]);
    }
  }
  SetCache.prototype.add = SetCache.prototype.push = setCacheAdd;
  SetCache.prototype.has = setCacheHas;
  function arraySome(array2, predicate) {
    var index2 = -1, length2 = array2 == null ? 0 : array2.length;
    while (++index2 < length2) {
      if (predicate(array2[index2], index2, array2)) {
        return true;
      }
    }
    return false;
  }
  function cacheHas(cache, key) {
    return cache.has(key);
  }
  var COMPARE_PARTIAL_FLAG$5 = 1, COMPARE_UNORDERED_FLAG$3 = 2;
  function equalArrays(array2, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG$5, arrLength = array2.length, othLength = other.length;
    if (arrLength != othLength && !(isPartial && othLength > arrLength)) {
      return false;
    }
    var arrStacked = stack.get(array2);
    var othStacked = stack.get(other);
    if (arrStacked && othStacked) {
      return arrStacked == other && othStacked == array2;
    }
    var index2 = -1, result = true, seen = bitmask & COMPARE_UNORDERED_FLAG$3 ? new SetCache() : void 0;
    stack.set(array2, other);
    stack.set(other, array2);
    while (++index2 < arrLength) {
      var arrValue = array2[index2], othValue = other[index2];
      if (customizer) {
        var compared = isPartial ? customizer(othValue, arrValue, index2, other, array2, stack) : customizer(arrValue, othValue, index2, array2, other, stack);
      }
      if (compared !== void 0) {
        if (compared) {
          continue;
        }
        result = false;
        break;
      }
      if (seen) {
        if (!arraySome(other, function(othValue2, othIndex) {
          if (!cacheHas(seen, othIndex) && (arrValue === othValue2 || equalFunc(arrValue, othValue2, bitmask, customizer, stack))) {
            return seen.push(othIndex);
          }
        })) {
          result = false;
          break;
        }
      } else if (!(arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {
        result = false;
        break;
      }
    }
    stack["delete"](array2);
    stack["delete"](other);
    return result;
  }
  function mapToArray(map2) {
    var index2 = -1, result = Array(map2.size);
    map2.forEach(function(value2, key) {
      result[++index2] = [key, value2];
    });
    return result;
  }
  function setToArray(set2) {
    var index2 = -1, result = Array(set2.size);
    set2.forEach(function(value2) {
      result[++index2] = value2;
    });
    return result;
  }
  var COMPARE_PARTIAL_FLAG$4 = 1, COMPARE_UNORDERED_FLAG$2 = 2;
  var boolTag = "[object Boolean]", dateTag = "[object Date]", errorTag = "[object Error]", mapTag = "[object Map]", numberTag = "[object Number]", regexpTag = "[object RegExp]", setTag = "[object Set]", stringTag = "[object String]", symbolTag = "[object Symbol]";
  var arrayBufferTag = "[object ArrayBuffer]", dataViewTag = "[object DataView]";
  var symbolProto = Symbol$2 ? Symbol$2.prototype : void 0, symbolValueOf = symbolProto ? symbolProto.valueOf : void 0;
  function equalByTag(object2, other, tag, bitmask, customizer, equalFunc, stack) {
    switch (tag) {
      case dataViewTag:
        if (object2.byteLength != other.byteLength || object2.byteOffset != other.byteOffset) {
          return false;
        }
        object2 = object2.buffer;
        other = other.buffer;
      case arrayBufferTag:
        if (object2.byteLength != other.byteLength || !equalFunc(new Uint8Array$2(object2), new Uint8Array$2(other))) {
          return false;
        }
        return true;
      case boolTag:
      case dateTag:
      case numberTag:
        return eq(+object2, +other);
      case errorTag:
        return object2.name == other.name && object2.message == other.message;
      case regexpTag:
      case stringTag:
        return object2 == other + "";
      case mapTag:
        var convert = mapToArray;
      case setTag:
        var isPartial = bitmask & COMPARE_PARTIAL_FLAG$4;
        convert || (convert = setToArray);
        if (object2.size != other.size && !isPartial) {
          return false;
        }
        var stacked = stack.get(object2);
        if (stacked) {
          return stacked == other;
        }
        bitmask |= COMPARE_UNORDERED_FLAG$2;
        stack.set(object2, other);
        var result = equalArrays(convert(object2), convert(other), bitmask, customizer, equalFunc, stack);
        stack["delete"](object2);
        return result;
      case symbolTag:
        if (symbolValueOf) {
          return symbolValueOf.call(object2) == symbolValueOf.call(other);
        }
    }
    return false;
  }
  var COMPARE_PARTIAL_FLAG$3 = 1;
  var objectProto$3 = Object.prototype;
  var hasOwnProperty$4 = objectProto$3.hasOwnProperty;
  function equalObjects(object2, other, bitmask, customizer, equalFunc, stack) {
    var isPartial = bitmask & COMPARE_PARTIAL_FLAG$3, objProps = getAllKeys(object2), objLength = objProps.length, othProps = getAllKeys(other), othLength = othProps.length;
    if (objLength != othLength && !isPartial) {
      return false;
    }
    var index2 = objLength;
    while (index2--) {
      var key = objProps[index2];
      if (!(isPartial ? key in other : hasOwnProperty$4.call(other, key))) {
        return false;
      }
    }
    var objStacked = stack.get(object2);
    var othStacked = stack.get(other);
    if (objStacked && othStacked) {
      return objStacked == other && othStacked == object2;
    }
    var result = true;
    stack.set(object2, other);
    stack.set(other, object2);
    var skipCtor = isPartial;
    while (++index2 < objLength) {
      key = objProps[index2];
      var objValue = object2[key], othValue = other[key];
      if (customizer) {
        var compared = isPartial ? customizer(othValue, objValue, key, other, object2, stack) : customizer(objValue, othValue, key, object2, other, stack);
      }
      if (!(compared === void 0 ? objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack) : compared)) {
        result = false;
        break;
      }
      skipCtor || (skipCtor = key == "constructor");
    }
    if (result && !skipCtor) {
      var objCtor = object2.constructor, othCtor = other.constructor;
      if (objCtor != othCtor && ("constructor" in object2 && "constructor" in other) && !(typeof objCtor == "function" && objCtor instanceof objCtor && typeof othCtor == "function" && othCtor instanceof othCtor)) {
        result = false;
      }
    }
    stack["delete"](object2);
    stack["delete"](other);
    return result;
  }
  var COMPARE_PARTIAL_FLAG$2 = 1;
  var argsTag = "[object Arguments]", arrayTag = "[object Array]", objectTag = "[object Object]";
  var objectProto$2 = Object.prototype;
  var hasOwnProperty$3 = objectProto$2.hasOwnProperty;
  function baseIsEqualDeep(object2, other, bitmask, customizer, equalFunc, stack) {
    var objIsArr = isArray$1(object2), othIsArr = isArray$1(other), objTag = objIsArr ? arrayTag : getTag$1(object2), othTag = othIsArr ? arrayTag : getTag$1(other);
    objTag = objTag == argsTag ? objectTag : objTag;
    othTag = othTag == argsTag ? objectTag : othTag;
    var objIsObj = objTag == objectTag, othIsObj = othTag == objectTag, isSameTag = objTag == othTag;
    if (isSameTag && isBuffer$1(object2)) {
      if (!isBuffer$1(other)) {
        return false;
      }
      objIsArr = true;
      objIsObj = false;
    }
    if (isSameTag && !objIsObj) {
      stack || (stack = new Stack());
      return objIsArr || isTypedArray$1(object2) ? equalArrays(object2, other, bitmask, customizer, equalFunc, stack) : equalByTag(object2, other, objTag, bitmask, customizer, equalFunc, stack);
    }
    if (!(bitmask & COMPARE_PARTIAL_FLAG$2)) {
      var objIsWrapped = objIsObj && hasOwnProperty$3.call(object2, "__wrapped__"), othIsWrapped = othIsObj && hasOwnProperty$3.call(other, "__wrapped__");
      if (objIsWrapped || othIsWrapped) {
        var objUnwrapped = objIsWrapped ? object2.value() : object2, othUnwrapped = othIsWrapped ? other.value() : other;
        stack || (stack = new Stack());
        return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);
      }
    }
    if (!isSameTag) {
      return false;
    }
    stack || (stack = new Stack());
    return equalObjects(object2, other, bitmask, customizer, equalFunc, stack);
  }
  function baseIsEqual(value2, other, bitmask, customizer, stack) {
    if (value2 === other) {
      return true;
    }
    if (value2 == null || other == null || !isObjectLike(value2) && !isObjectLike(other)) {
      return value2 !== value2 && other !== other;
    }
    return baseIsEqualDeep(value2, other, bitmask, customizer, baseIsEqual, stack);
  }
  var COMPARE_PARTIAL_FLAG$1 = 1, COMPARE_UNORDERED_FLAG$1 = 2;
  function baseIsMatch(object2, source, matchData, customizer) {
    var index2 = matchData.length, length2 = index2, noCustomizer = !customizer;
    if (object2 == null) {
      return !length2;
    }
    object2 = Object(object2);
    while (index2--) {
      var data = matchData[index2];
      if (noCustomizer && data[2] ? data[1] !== object2[data[0]] : !(data[0] in object2)) {
        return false;
      }
    }
    while (++index2 < length2) {
      data = matchData[index2];
      var key = data[0], objValue = object2[key], srcValue = data[1];
      if (noCustomizer && data[2]) {
        if (objValue === void 0 && !(key in object2)) {
          return false;
        }
      } else {
        var stack = new Stack();
        if (customizer) {
          var result = customizer(objValue, srcValue, key, object2, source, stack);
        }
        if (!(result === void 0 ? baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG$1 | COMPARE_UNORDERED_FLAG$1, customizer, stack) : result)) {
          return false;
        }
      }
    }
    return true;
  }
  function isStrictComparable(value2) {
    return value2 === value2 && !isObject$1(value2);
  }
  function getMatchData(object2) {
    var result = keys$1(object2), length2 = result.length;
    while (length2--) {
      var key = result[length2], value2 = object2[key];
      result[length2] = [key, value2, isStrictComparable(value2)];
    }
    return result;
  }
  function matchesStrictComparable(key, srcValue) {
    return function(object2) {
      if (object2 == null) {
        return false;
      }
      return object2[key] === srcValue && (srcValue !== void 0 || key in Object(object2));
    };
  }
  function baseMatches(source) {
    var matchData = getMatchData(source);
    if (matchData.length == 1 && matchData[0][2]) {
      return matchesStrictComparable(matchData[0][0], matchData[0][1]);
    }
    return function(object2) {
      return object2 === source || baseIsMatch(object2, source, matchData);
    };
  }
  function baseHasIn(object2, key) {
    return object2 != null && key in Object(object2);
  }
  function hasPath(object2, path2, hasFunc) {
    path2 = castPath(path2, object2);
    var index2 = -1, length2 = path2.length, result = false;
    while (++index2 < length2) {
      var key = toKey(path2[index2]);
      if (!(result = object2 != null && hasFunc(object2, key))) {
        break;
      }
      object2 = object2[key];
    }
    if (result || ++index2 != length2) {
      return result;
    }
    length2 = object2 == null ? 0 : object2.length;
    return !!length2 && isLength(length2) && isIndex(key, length2) && (isArray$1(object2) || isArguments$1(object2));
  }
  function hasIn(object2, path2) {
    return object2 != null && hasPath(object2, path2, baseHasIn);
  }
  var COMPARE_PARTIAL_FLAG = 1, COMPARE_UNORDERED_FLAG = 2;
  function baseMatchesProperty(path2, srcValue) {
    if (isKey(path2) && isStrictComparable(srcValue)) {
      return matchesStrictComparable(toKey(path2), srcValue);
    }
    return function(object2) {
      var objValue = get$1(object2, path2);
      return objValue === void 0 && objValue === srcValue ? hasIn(object2, path2) : baseIsEqual(srcValue, objValue, COMPARE_PARTIAL_FLAG | COMPARE_UNORDERED_FLAG);
    };
  }
  function baseProperty(key) {
    return function(object2) {
      return object2 == null ? void 0 : object2[key];
    };
  }
  function basePropertyDeep(path2) {
    return function(object2) {
      return baseGet(object2, path2);
    };
  }
  function property(path2) {
    return isKey(path2) ? baseProperty(toKey(path2)) : basePropertyDeep(path2);
  }
  function baseIteratee(value2) {
    if (typeof value2 == "function") {
      return value2;
    }
    if (value2 == null) {
      return identity;
    }
    if (typeof value2 == "object") {
      return isArray$1(value2) ? baseMatchesProperty(value2[0], value2[1]) : baseMatches(value2);
    }
    return property(value2);
  }
  function baseForOwn(object2, iteratee) {
    return object2 && baseFor$1(object2, iteratee, keys$1);
  }
  function createBaseEach(eachFunc, fromRight) {
    return function(collection, iteratee) {
      if (collection == null) {
        return collection;
      }
      if (!isArrayLike(collection)) {
        return eachFunc(collection, iteratee);
      }
      var length2 = collection.length, index2 = fromRight ? length2 : -1, iterable = Object(collection);
      while (fromRight ? index2-- : ++index2 < length2) {
        if (iteratee(iterable[index2], index2, iterable) === false) {
          break;
        }
      }
      return collection;
    };
  }
  var baseEach = createBaseEach(baseForOwn);
  const baseEach$1 = baseEach;
  var now = function() {
    return root$1.Date.now();
  };
  const now$1 = now;
  var objectProto$1 = Object.prototype;
  var hasOwnProperty$2 = objectProto$1.hasOwnProperty;
  var defaults = baseRest(function(object2, sources) {
    object2 = Object(object2);
    var index2 = -1;
    var length2 = sources.length;
    var guard = length2 > 2 ? sources[2] : void 0;
    if (guard && isIterateeCall(sources[0], sources[1], guard)) {
      length2 = 1;
    }
    while (++index2 < length2) {
      var source = sources[index2];
      var props = keysIn(source);
      var propsIndex = -1;
      var propsLength = props.length;
      while (++propsIndex < propsLength) {
        var key = props[propsIndex];
        var value2 = object2[key];
        if (value2 === void 0 || eq(value2, objectProto$1[key]) && !hasOwnProperty$2.call(object2, key)) {
          object2[key] = source[key];
        }
      }
    }
    return object2;
  });
  const defaults$1 = defaults;
  function arrayIncludesWith(array2, value2, comparator) {
    var index2 = -1, length2 = array2 == null ? 0 : array2.length;
    while (++index2 < length2) {
      if (comparator(value2, array2[index2])) {
        return true;
      }
    }
    return false;
  }
  function last(array2) {
    var length2 = array2 == null ? 0 : array2.length;
    return length2 ? array2[length2 - 1] : void 0;
  }
  function castFunction(value2) {
    return typeof value2 == "function" ? value2 : identity;
  }
  function forEach(collection, iteratee) {
    var func = isArray$1(collection) ? arrayEach : baseEach$1;
    return func(collection, castFunction(iteratee));
  }
  function baseFilter(collection, predicate) {
    var result = [];
    baseEach$1(collection, function(value2, index2, collection2) {
      if (predicate(value2, index2, collection2)) {
        result.push(value2);
      }
    });
    return result;
  }
  function filter(collection, predicate) {
    var func = isArray$1(collection) ? arrayFilter : baseFilter;
    return func(collection, baseIteratee(predicate));
  }
  function createFind(findIndexFunc) {
    return function(collection, predicate, fromIndex) {
      var iterable = Object(collection);
      if (!isArrayLike(collection)) {
        var iteratee = baseIteratee(predicate);
        collection = keys$1(collection);
        predicate = function(key) {
          return iteratee(iterable[key], key, iterable);
        };
      }
      var index2 = findIndexFunc(collection, predicate, fromIndex);
      return index2 > -1 ? iterable[iteratee ? collection[index2] : index2] : void 0;
    };
  }
  var nativeMax$1 = Math.max;
  function findIndex(array2, predicate, fromIndex) {
    var length2 = array2 == null ? 0 : array2.length;
    if (!length2) {
      return -1;
    }
    var index2 = fromIndex == null ? 0 : toInteger(fromIndex);
    if (index2 < 0) {
      index2 = nativeMax$1(length2 + index2, 0);
    }
    return baseFindIndex(array2, baseIteratee(predicate), index2);
  }
  var find$1 = createFind(findIndex);
  const find$2 = find$1;
  function baseMap(collection, iteratee) {
    var index2 = -1, result = isArrayLike(collection) ? Array(collection.length) : [];
    baseEach$1(collection, function(value2, key, collection2) {
      result[++index2] = iteratee(value2, key, collection2);
    });
    return result;
  }
  function map(collection, iteratee) {
    var func = isArray$1(collection) ? arrayMap : baseMap;
    return func(collection, baseIteratee(iteratee));
  }
  function forIn(object2, iteratee) {
    return object2 == null ? object2 : baseFor$1(object2, castFunction(iteratee), keysIn);
  }
  function forOwn(object2, iteratee) {
    return object2 && baseForOwn(object2, castFunction(iteratee));
  }
  function baseGt(value2, other) {
    return value2 > other;
  }
  var objectProto = Object.prototype;
  var hasOwnProperty$1 = objectProto.hasOwnProperty;
  function baseHas(object2, key) {
    return object2 != null && hasOwnProperty$1.call(object2, key);
  }
  function has(object2, path2) {
    return object2 != null && hasPath(object2, path2, baseHas);
  }
  function baseValues(object2, props) {
    return arrayMap(props, function(key) {
      return object2[key];
    });
  }
  function values(object2) {
    return object2 == null ? [] : baseValues(object2, keys$1(object2));
  }
  function isUndefined(value2) {
    return value2 === void 0;
  }
  function baseLt(value2, other) {
    return value2 < other;
  }
  function mapValues(object2, iteratee) {
    var result = {};
    iteratee = baseIteratee(iteratee);
    baseForOwn(object2, function(value2, key, object3) {
      baseAssignValue(result, key, iteratee(value2, key, object3));
    });
    return result;
  }
  function baseExtremum(array2, iteratee, comparator) {
    var index2 = -1, length2 = array2.length;
    while (++index2 < length2) {
      var value2 = array2[index2], current = iteratee(value2);
      if (current != null && (computed === void 0 ? current === current && !isSymbol(current) : comparator(current, computed))) {
        var computed = current, result = value2;
      }
    }
    return result;
  }
  function max$1(array2) {
    return array2 && array2.length ? baseExtremum(array2, identity, baseGt) : void 0;
  }
  function min$1(array2) {
    return array2 && array2.length ? baseExtremum(array2, identity, baseLt) : void 0;
  }
  function minBy(array2, iteratee) {
    return array2 && array2.length ? baseExtremum(array2, baseIteratee(iteratee), baseLt) : void 0;
  }
  function baseSet(object2, path2, value2, customizer) {
    if (!isObject$1(object2)) {
      return object2;
    }
    path2 = castPath(path2, object2);
    var index2 = -1, length2 = path2.length, lastIndex = length2 - 1, nested = object2;
    while (nested != null && ++index2 < length2) {
      var key = toKey(path2[index2]), newValue = value2;
      if (key === "__proto__" || key === "constructor" || key === "prototype") {
        return object2;
      }
      if (index2 != lastIndex) {
        var objValue = nested[key];
        newValue = customizer ? customizer(objValue, key, nested) : void 0;
        if (newValue === void 0) {
          newValue = isObject$1(objValue) ? objValue : isIndex(path2[index2 + 1]) ? [] : {};
        }
      }
      assignValue(nested, key, newValue);
      nested = nested[key];
    }
    return object2;
  }
  function basePickBy(object2, paths, predicate) {
    var index2 = -1, length2 = paths.length, result = {};
    while (++index2 < length2) {
      var path2 = paths[index2], value2 = baseGet(object2, path2);
      if (predicate(value2, path2)) {
        baseSet(result, castPath(path2, object2), value2);
      }
    }
    return result;
  }
  function baseSortBy(array2, comparer) {
    var length2 = array2.length;
    array2.sort(comparer);
    while (length2--) {
      array2[length2] = array2[length2].value;
    }
    return array2;
  }
  function compareAscending(value2, other) {
    if (value2 !== other) {
      var valIsDefined = value2 !== void 0, valIsNull = value2 === null, valIsReflexive = value2 === value2, valIsSymbol = isSymbol(value2);
      var othIsDefined = other !== void 0, othIsNull = other === null, othIsReflexive = other === other, othIsSymbol = isSymbol(other);
      if (!othIsNull && !othIsSymbol && !valIsSymbol && value2 > other || valIsSymbol && othIsDefined && othIsReflexive && !othIsNull && !othIsSymbol || valIsNull && othIsDefined && othIsReflexive || !valIsDefined && othIsReflexive || !valIsReflexive) {
        return 1;
      }
      if (!valIsNull && !valIsSymbol && !othIsSymbol && value2 < other || othIsSymbol && valIsDefined && valIsReflexive && !valIsNull && !valIsSymbol || othIsNull && valIsDefined && valIsReflexive || !othIsDefined && valIsReflexive || !othIsReflexive) {
        return -1;
      }
    }
    return 0;
  }
  function compareMultiple(object2, other, orders) {
    var index2 = -1, objCriteria = object2.criteria, othCriteria = other.criteria, length2 = objCriteria.length, ordersLength = orders.length;
    while (++index2 < length2) {
      var result = compareAscending(objCriteria[index2], othCriteria[index2]);
      if (result) {
        if (index2 >= ordersLength) {
          return result;
        }
        var order2 = orders[index2];
        return result * (order2 == "desc" ? -1 : 1);
      }
    }
    return object2.index - other.index;
  }
  function baseOrderBy(collection, iteratees, orders) {
    if (iteratees.length) {
      iteratees = arrayMap(iteratees, function(iteratee) {
        if (isArray$1(iteratee)) {
          return function(value2) {
            return baseGet(value2, iteratee.length === 1 ? iteratee[0] : iteratee);
          };
        }
        return iteratee;
      });
    } else {
      iteratees = [identity];
    }
    var index2 = -1;
    iteratees = arrayMap(iteratees, baseUnary(baseIteratee));
    var result = baseMap(collection, function(value2, key, collection2) {
      var criteria = arrayMap(iteratees, function(iteratee) {
        return iteratee(value2);
      });
      return { "criteria": criteria, "index": ++index2, "value": value2 };
    });
    return baseSortBy(result, function(object2, other) {
      return compareMultiple(object2, other, orders);
    });
  }
  function basePick(object2, paths) {
    return basePickBy(object2, paths, function(value2, path2) {
      return hasIn(object2, path2);
    });
  }
  var pick = flatRest(function(object2, paths) {
    return object2 == null ? {} : basePick(object2, paths);
  });
  const pick$1 = pick;
  var nativeCeil = Math.ceil, nativeMax = Math.max;
  function baseRange(start2, end2, step, fromRight) {
    var index2 = -1, length2 = nativeMax(nativeCeil((end2 - start2) / (step || 1)), 0), result = Array(length2);
    while (length2--) {
      result[fromRight ? length2 : ++index2] = start2;
      start2 += step;
    }
    return result;
  }
  function createRange(fromRight) {
    return function(start2, end2, step) {
      if (step && typeof step != "number" && isIterateeCall(start2, end2, step)) {
        end2 = step = void 0;
      }
      start2 = toFinite(start2);
      if (end2 === void 0) {
        end2 = start2;
        start2 = 0;
      } else {
        end2 = toFinite(end2);
      }
      step = step === void 0 ? start2 < end2 ? 1 : -1 : toFinite(step);
      return baseRange(start2, end2, step, fromRight);
    };
  }
  var range = createRange();
  const range$1 = range;
  function baseReduce(collection, iteratee, accumulator, initAccum, eachFunc) {
    eachFunc(collection, function(value2, index2, collection2) {
      accumulator = initAccum ? (initAccum = false, value2) : iteratee(accumulator, value2, index2, collection2);
    });
    return accumulator;
  }
  function reduce(collection, iteratee, accumulator) {
    var func = isArray$1(collection) ? arrayReduce : baseReduce, initAccum = arguments.length < 3;
    return func(collection, baseIteratee(iteratee), accumulator, initAccum, baseEach$1);
  }
  var sortBy = baseRest(function(collection, iteratees) {
    if (collection == null) {
      return [];
    }
    var length2 = iteratees.length;
    if (length2 > 1 && isIterateeCall(collection, iteratees[0], iteratees[1])) {
      iteratees = [];
    } else if (length2 > 2 && isIterateeCall(iteratees[0], iteratees[1], iteratees[2])) {
      iteratees = [iteratees[0]];
    }
    return baseOrderBy(collection, baseFlatten(iteratees, 1), []);
  });
  const sortBy$1 = sortBy;
  var INFINITY = 1 / 0;
  var createSet = !(Set$2 && 1 / setToArray(new Set$2([, -0]))[1] == INFINITY) ? noop : function(values2) {
    return new Set$2(values2);
  };
  const createSet$1 = createSet;
  var LARGE_ARRAY_SIZE = 200;
  function baseUniq(array2, iteratee, comparator) {
    var index2 = -1, includes2 = arrayIncludes, length2 = array2.length, isCommon = true, result = [], seen = result;
    if (comparator) {
      isCommon = false;
      includes2 = arrayIncludesWith;
    } else if (length2 >= LARGE_ARRAY_SIZE) {
      var set2 = iteratee ? null : createSet$1(array2);
      if (set2) {
        return setToArray(set2);
      }
      isCommon = false;
      includes2 = cacheHas;
      seen = new SetCache();
    } else {
      seen = iteratee ? [] : result;
    }
    outer:
      while (++index2 < length2) {
        var value2 = array2[index2], computed = iteratee ? iteratee(value2) : value2;
        value2 = comparator || value2 !== 0 ? value2 : 0;
        if (isCommon && computed === computed) {
          var seenIndex = seen.length;
          while (seenIndex--) {
            if (seen[seenIndex] === computed) {
              continue outer;
            }
          }
          if (iteratee) {
            seen.push(computed);
          }
          result.push(value2);
        } else if (!includes2(seen, computed, comparator)) {
          if (seen !== result) {
            seen.push(computed);
          }
          result.push(value2);
        }
      }
    return result;
  }
  var union = baseRest(function(arrays) {
    return baseUniq(baseFlatten(arrays, 1, isArrayLikeObject, true));
  });
  const union$1 = union;
  var idCounter = 0;
  function uniqueId(prefix) {
    var id2 = ++idCounter;
    return toString$1(prefix) + id2;
  }
  function baseZipObject(props, values2, assignFunc) {
    var index2 = -1, length2 = props.length, valsLength = values2.length, result = {};
    while (++index2 < length2) {
      var value2 = index2 < valsLength ? values2[index2] : void 0;
      assignFunc(result, props[index2], value2);
    }
    return result;
  }
  function zipObject(props, values2) {
    return baseZipObject(props || [], values2 || [], assignValue);
  }
  var DEFAULT_EDGE_NAME = "\0";
  var GRAPH_NODE = "\0";
  var EDGE_KEY_DELIM = "";
  class Graph {
    constructor(opts = {}) {
      this._isDirected = has(opts, "directed") ? opts.directed : true;
      this._isMultigraph = has(opts, "multigraph") ? opts.multigraph : false;
      this._isCompound = has(opts, "compound") ? opts.compound : false;
      this._label = void 0;
      this._defaultNodeLabelFn = constant$2(void 0);
      this._defaultEdgeLabelFn = constant$2(void 0);
      this._nodes = {};
      if (this._isCompound) {
        this._parent = {};
        this._children = {};
        this._children[GRAPH_NODE] = {};
      }
      this._in = {};
      this._preds = {};
      this._out = {};
      this._sucs = {};
      this._edgeObjs = {};
      this._edgeLabels = {};
    }
    /* === Graph functions ========= */
    isDirected() {
      return this._isDirected;
    }
    isMultigraph() {
      return this._isMultigraph;
    }
    isCompound() {
      return this._isCompound;
    }
    setGraph(label) {
      this._label = label;
      return this;
    }
    graph() {
      return this._label;
    }
    /* === Node functions ========== */
    setDefaultNodeLabel(newDefault) {
      if (!isFunction(newDefault)) {
        newDefault = constant$2(newDefault);
      }
      this._defaultNodeLabelFn = newDefault;
      return this;
    }
    nodeCount() {
      return this._nodeCount;
    }
    nodes() {
      return keys$1(this._nodes);
    }
    sources() {
      var self2 = this;
      return filter(this.nodes(), function(v) {
        return isEmpty(self2._in[v]);
      });
    }
    sinks() {
      var self2 = this;
      return filter(this.nodes(), function(v) {
        return isEmpty(self2._out[v]);
      });
    }
    setNodes(vs, value2) {
      var args = arguments;
      var self2 = this;
      forEach(vs, function(v) {
        if (args.length > 1) {
          self2.setNode(v, value2);
        } else {
          self2.setNode(v);
        }
      });
      return this;
    }
    setNode(v, value2) {
      if (has(this._nodes, v)) {
        if (arguments.length > 1) {
          this._nodes[v] = value2;
        }
        return this;
      }
      this._nodes[v] = arguments.length > 1 ? value2 : this._defaultNodeLabelFn(v);
      if (this._isCompound) {
        this._parent[v] = GRAPH_NODE;
        this._children[v] = {};
        this._children[GRAPH_NODE][v] = true;
      }
      this._in[v] = {};
      this._preds[v] = {};
      this._out[v] = {};
      this._sucs[v] = {};
      ++this._nodeCount;
      return this;
    }
    node(v) {
      return this._nodes[v];
    }
    hasNode(v) {
      return has(this._nodes, v);
    }
    removeNode(v) {
      var self2 = this;
      if (has(this._nodes, v)) {
        var removeEdge = function(e) {
          self2.removeEdge(self2._edgeObjs[e]);
        };
        delete this._nodes[v];
        if (this._isCompound) {
          this._removeFromParentsChildList(v);
          delete this._parent[v];
          forEach(this.children(v), function(child) {
            self2.setParent(child);
          });
          delete this._children[v];
        }
        forEach(keys$1(this._in[v]), removeEdge);
        delete this._in[v];
        delete this._preds[v];
        forEach(keys$1(this._out[v]), removeEdge);
        delete this._out[v];
        delete this._sucs[v];
        --this._nodeCount;
      }
      return this;
    }
    setParent(v, parent) {
      if (!this._isCompound) {
        throw new Error("Cannot set parent in a non-compound graph");
      }
      if (isUndefined(parent)) {
        parent = GRAPH_NODE;
      } else {
        parent += "";
        for (var ancestor = parent; !isUndefined(ancestor); ancestor = this.parent(ancestor)) {
          if (ancestor === v) {
            throw new Error("Setting " + parent + " as parent of " + v + " would create a cycle");
          }
        }
        this.setNode(parent);
      }
      this.setNode(v);
      this._removeFromParentsChildList(v);
      this._parent[v] = parent;
      this._children[parent][v] = true;
      return this;
    }
    _removeFromParentsChildList(v) {
      delete this._children[this._parent[v]][v];
    }
    parent(v) {
      if (this._isCompound) {
        var parent = this._parent[v];
        if (parent !== GRAPH_NODE) {
          return parent;
        }
      }
    }
    children(v) {
      if (isUndefined(v)) {
        v = GRAPH_NODE;
      }
      if (this._isCompound) {
        var children2 = this._children[v];
        if (children2) {
          return keys$1(children2);
        }
      } else if (v === GRAPH_NODE) {
        return this.nodes();
      } else if (this.hasNode(v)) {
        return [];
      }
    }
    predecessors(v) {
      var predsV = this._preds[v];
      if (predsV) {
        return keys$1(predsV);
      }
    }
    successors(v) {
      var sucsV = this._sucs[v];
      if (sucsV) {
        return keys$1(sucsV);
      }
    }
    neighbors(v) {
      var preds = this.predecessors(v);
      if (preds) {
        return union$1(preds, this.successors(v));
      }
    }
    isLeaf(v) {
      var neighbors;
      if (this.isDirected()) {
        neighbors = this.successors(v);
      } else {
        neighbors = this.neighbors(v);
      }
      return neighbors.length === 0;
    }
    filterNodes(filter2) {
      var copy2 = new this.constructor({
        directed: this._isDirected,
        multigraph: this._isMultigraph,
        compound: this._isCompound
      });
      copy2.setGraph(this.graph());
      var self2 = this;
      forEach(this._nodes, function(value2, v) {
        if (filter2(v)) {
          copy2.setNode(v, value2);
        }
      });
      forEach(this._edgeObjs, function(e) {
        if (copy2.hasNode(e.v) && copy2.hasNode(e.w)) {
          copy2.setEdge(e, self2.edge(e));
        }
      });
      var parents2 = {};
      function findParent(v) {
        var parent = self2.parent(v);
        if (parent === void 0 || copy2.hasNode(parent)) {
          parents2[v] = parent;
          return parent;
        } else if (parent in parents2) {
          return parents2[parent];
        } else {
          return findParent(parent);
        }
      }
      if (this._isCompound) {
        forEach(copy2.nodes(), function(v) {
          copy2.setParent(v, findParent(v));
        });
      }
      return copy2;
    }
    /* === Edge functions ========== */
    setDefaultEdgeLabel(newDefault) {
      if (!isFunction(newDefault)) {
        newDefault = constant$2(newDefault);
      }
      this._defaultEdgeLabelFn = newDefault;
      return this;
    }
    edgeCount() {
      return this._edgeCount;
    }
    edges() {
      return values(this._edgeObjs);
    }
    setPath(vs, value2) {
      var self2 = this;
      var args = arguments;
      reduce(vs, function(v, w2) {
        if (args.length > 1) {
          self2.setEdge(v, w2, value2);
        } else {
          self2.setEdge(v, w2);
        }
        return w2;
      });
      return this;
    }
    /*
     * setEdge(v, w, [value, [name]])
     * setEdge({ v, w, [name] }, [value])
     */
    setEdge() {
      var v, w2, name, value2;
      var valueSpecified = false;
      var arg0 = arguments[0];
      if (typeof arg0 === "object" && arg0 !== null && "v" in arg0) {
        v = arg0.v;
        w2 = arg0.w;
        name = arg0.name;
        if (arguments.length === 2) {
          value2 = arguments[1];
          valueSpecified = true;
        }
      } else {
        v = arg0;
        w2 = arguments[1];
        name = arguments[3];
        if (arguments.length > 2) {
          value2 = arguments[2];
          valueSpecified = true;
        }
      }
      v = "" + v;
      w2 = "" + w2;
      if (!isUndefined(name)) {
        name = "" + name;
      }
      var e = edgeArgsToId(this._isDirected, v, w2, name);
      if (has(this._edgeLabels, e)) {
        if (valueSpecified) {
          this._edgeLabels[e] = value2;
        }
        return this;
      }
      if (!isUndefined(name) && !this._isMultigraph) {
        throw new Error("Cannot set a named edge when isMultigraph = false");
      }
      this.setNode(v);
      this.setNode(w2);
      this._edgeLabels[e] = valueSpecified ? value2 : this._defaultEdgeLabelFn(v, w2, name);
      var edgeObj = edgeArgsToObj(this._isDirected, v, w2, name);
      v = edgeObj.v;
      w2 = edgeObj.w;
      Object.freeze(edgeObj);
      this._edgeObjs[e] = edgeObj;
      incrementOrInitEntry(this._preds[w2], v);
      incrementOrInitEntry(this._sucs[v], w2);
      this._in[w2][e] = edgeObj;
      this._out[v][e] = edgeObj;
      this._edgeCount++;
      return this;
    }
    edge(v, w2, name) {
      var e = arguments.length === 1 ? edgeObjToId(this._isDirected, arguments[0]) : edgeArgsToId(this._isDirected, v, w2, name);
      return this._edgeLabels[e];
    }
    hasEdge(v, w2, name) {
      var e = arguments.length === 1 ? edgeObjToId(this._isDirected, arguments[0]) : edgeArgsToId(this._isDirected, v, w2, name);
      return has(this._edgeLabels, e);
    }
    removeEdge(v, w2, name) {
      var e = arguments.length === 1 ? edgeObjToId(this._isDirected, arguments[0]) : edgeArgsToId(this._isDirected, v, w2, name);
      var edge = this._edgeObjs[e];
      if (edge) {
        v = edge.v;
        w2 = edge.w;
        delete this._edgeLabels[e];
        delete this._edgeObjs[e];
        decrementOrRemoveEntry(this._preds[w2], v);
        decrementOrRemoveEntry(this._sucs[v], w2);
        delete this._in[w2][e];
        delete this._out[v][e];
        this._edgeCount--;
      }
      return this;
    }
    inEdges(v, u) {
      var inV = this._in[v];
      if (inV) {
        var edges2 = values(inV);
        if (!u) {
          return edges2;
        }
        return filter(edges2, function(edge) {
          return edge.v === u;
        });
      }
    }
    outEdges(v, w2) {
      var outV = this._out[v];
      if (outV) {
        var edges2 = values(outV);
        if (!w2) {
          return edges2;
        }
        return filter(edges2, function(edge) {
          return edge.w === w2;
        });
      }
    }
    nodeEdges(v, w2) {
      var inEdges = this.inEdges(v, w2);
      if (inEdges) {
        return inEdges.concat(this.outEdges(v, w2));
      }
    }
  }
  Graph.prototype._nodeCount = 0;
  Graph.prototype._edgeCount = 0;
  function incrementOrInitEntry(map2, k) {
    if (map2[k]) {
      map2[k]++;
    } else {
      map2[k] = 1;
    }
  }
  function decrementOrRemoveEntry(map2, k) {
    if (!--map2[k]) {
      delete map2[k];
    }
  }
  function edgeArgsToId(isDirected, v_, w_, name) {
    var v = "" + v_;
    var w2 = "" + w_;
    if (!isDirected && v > w2) {
      var tmp = v;
      v = w2;
      w2 = tmp;
    }
    return v + EDGE_KEY_DELIM + w2 + EDGE_KEY_DELIM + (isUndefined(name) ? DEFAULT_EDGE_NAME : name);
  }
  function edgeArgsToObj(isDirected, v_, w_, name) {
    var v = "" + v_;
    var w2 = "" + w_;
    if (!isDirected && v > w2) {
      var tmp = v;
      v = w2;
      w2 = tmp;
    }
    var edgeObj = { v, w: w2 };
    if (name) {
      edgeObj.name = name;
    }
    return edgeObj;
  }
  function edgeObjToId(isDirected, edgeObj) {
    return edgeArgsToId(isDirected, edgeObj.v, edgeObj.w, edgeObj.name);
  }
  class List {
    constructor() {
      var sentinel = {};
      sentinel._next = sentinel._prev = sentinel;
      this._sentinel = sentinel;
    }
    dequeue() {
      var sentinel = this._sentinel;
      var entry = sentinel._prev;
      if (entry !== sentinel) {
        unlink(entry);
        return entry;
      }
    }
    enqueue(entry) {
      var sentinel = this._sentinel;
      if (entry._prev && entry._next) {
        unlink(entry);
      }
      entry._next = sentinel._next;
      sentinel._next._prev = entry;
      sentinel._next = entry;
      entry._prev = sentinel;
    }
    toString() {
      var strs = [];
      var sentinel = this._sentinel;
      var curr = sentinel._prev;
      while (curr !== sentinel) {
        strs.push(JSON.stringify(curr, filterOutLinks));
        curr = curr._prev;
      }
      return "[" + strs.join(", ") + "]";
    }
  }
  function unlink(entry) {
    entry._prev._next = entry._next;
    entry._next._prev = entry._prev;
    delete entry._next;
    delete entry._prev;
  }
  function filterOutLinks(k, v) {
    if (k !== "_next" && k !== "_prev") {
      return v;
    }
  }
  var DEFAULT_WEIGHT_FN = constant$2(1);
  function greedyFAS(g, weightFn) {
    if (g.nodeCount() <= 1) {
      return [];
    }
    var state2 = buildState(g, weightFn || DEFAULT_WEIGHT_FN);
    var results = doGreedyFAS(state2.graph, state2.buckets, state2.zeroIdx);
    return flatten(
      map(results, function(e) {
        return g.outEdges(e.v, e.w);
      })
    );
  }
  function doGreedyFAS(g, buckets, zeroIdx) {
    var results = [];
    var sources = buckets[buckets.length - 1];
    var sinks = buckets[0];
    var entry;
    while (g.nodeCount()) {
      while (entry = sinks.dequeue()) {
        removeNode(g, buckets, zeroIdx, entry);
      }
      while (entry = sources.dequeue()) {
        removeNode(g, buckets, zeroIdx, entry);
      }
      if (g.nodeCount()) {
        for (var i2 = buckets.length - 2; i2 > 0; --i2) {
          entry = buckets[i2].dequeue();
          if (entry) {
            results = results.concat(removeNode(g, buckets, zeroIdx, entry, true));
            break;
          }
        }
      }
    }
    return results;
  }
  function removeNode(g, buckets, zeroIdx, entry, collectPredecessors) {
    var results = collectPredecessors ? [] : void 0;
    forEach(g.inEdges(entry.v), function(edge) {
      var weight = g.edge(edge);
      var uEntry = g.node(edge.v);
      if (collectPredecessors) {
        results.push({ v: edge.v, w: edge.w });
      }
      uEntry.out -= weight;
      assignBucket(buckets, zeroIdx, uEntry);
    });
    forEach(g.outEdges(entry.v), function(edge) {
      var weight = g.edge(edge);
      var w2 = edge.w;
      var wEntry = g.node(w2);
      wEntry["in"] -= weight;
      assignBucket(buckets, zeroIdx, wEntry);
    });
    g.removeNode(entry.v);
    return results;
  }
  function buildState(g, weightFn) {
    var fasGraph = new Graph();
    var maxIn = 0;
    var maxOut = 0;
    forEach(g.nodes(), function(v) {
      fasGraph.setNode(v, { v, in: 0, out: 0 });
    });
    forEach(g.edges(), function(e) {
      var prevWeight = fasGraph.edge(e.v, e.w) || 0;
      var weight = weightFn(e);
      var edgeWeight = prevWeight + weight;
      fasGraph.setEdge(e.v, e.w, edgeWeight);
      maxOut = Math.max(maxOut, fasGraph.node(e.v).out += weight);
      maxIn = Math.max(maxIn, fasGraph.node(e.w)["in"] += weight);
    });
    var buckets = range$1(maxOut + maxIn + 3).map(function() {
      return new List();
    });
    var zeroIdx = maxIn + 1;
    forEach(fasGraph.nodes(), function(v) {
      assignBucket(buckets, zeroIdx, fasGraph.node(v));
    });
    return { graph: fasGraph, buckets, zeroIdx };
  }
  function assignBucket(buckets, zeroIdx, entry) {
    if (!entry.out) {
      buckets[0].enqueue(entry);
    } else if (!entry["in"]) {
      buckets[buckets.length - 1].enqueue(entry);
    } else {
      buckets[entry.out - entry["in"] + zeroIdx].enqueue(entry);
    }
  }
  function run$2(g) {
    var fas = g.graph().acyclicer === "greedy" ? greedyFAS(g, weightFn(g)) : dfsFAS(g);
    forEach(fas, function(e) {
      var label = g.edge(e);
      g.removeEdge(e);
      label.forwardName = e.name;
      label.reversed = true;
      g.setEdge(e.w, e.v, label, uniqueId("rev"));
    });
    function weightFn(g2) {
      return function(e) {
        return g2.edge(e).weight;
      };
    }
  }
  function dfsFAS(g) {
    var fas = [];
    var stack = {};
    var visited = {};
    function dfs2(v) {
      if (has(visited, v)) {
        return;
      }
      visited[v] = true;
      stack[v] = true;
      forEach(g.outEdges(v), function(e) {
        if (has(stack, e.w)) {
          fas.push(e);
        } else {
          dfs2(e.w);
        }
      });
      delete stack[v];
    }
    forEach(g.nodes(), dfs2);
    return fas;
  }
  function undo$2(g) {
    forEach(g.edges(), function(e) {
      var label = g.edge(e);
      if (label.reversed) {
        g.removeEdge(e);
        var forwardName = label.forwardName;
        delete label.reversed;
        delete label.forwardName;
        g.setEdge(e.w, e.v, label, forwardName);
      }
    });
  }
  function addDummyNode(g, type2, attrs, name) {
    var v;
    do {
      v = uniqueId(name);
    } while (g.hasNode(v));
    attrs.dummy = type2;
    g.setNode(v, attrs);
    return v;
  }
  function simplify(g) {
    var simplified = new Graph().setGraph(g.graph());
    forEach(g.nodes(), function(v) {
      simplified.setNode(v, g.node(v));
    });
    forEach(g.edges(), function(e) {
      var simpleLabel = simplified.edge(e.v, e.w) || { weight: 0, minlen: 1 };
      var label = g.edge(e);
      simplified.setEdge(e.v, e.w, {
        weight: simpleLabel.weight + label.weight,
        minlen: Math.max(simpleLabel.minlen, label.minlen)
      });
    });
    return simplified;
  }
  function asNonCompoundGraph(g) {
    var simplified = new Graph({ multigraph: g.isMultigraph() }).setGraph(g.graph());
    forEach(g.nodes(), function(v) {
      if (!g.children(v).length) {
        simplified.setNode(v, g.node(v));
      }
    });
    forEach(g.edges(), function(e) {
      simplified.setEdge(e, g.edge(e));
    });
    return simplified;
  }
  function intersectRect$3(rect2, point2) {
    var x2 = rect2.x;
    var y2 = rect2.y;
    var dx = point2.x - x2;
    var dy = point2.y - y2;
    var w2 = rect2.width / 2;
    var h = rect2.height / 2;
    if (!dx && !dy) {
      throw new Error("Not possible to find intersection inside of the rectangle");
    }
    var sx, sy;
    if (Math.abs(dy) * w2 > Math.abs(dx) * h) {
      if (dy < 0) {
        h = -h;
      }
      sx = h * dx / dy;
      sy = h;
    } else {
      if (dx < 0) {
        w2 = -w2;
      }
      sx = w2;
      sy = w2 * dy / dx;
    }
    return { x: x2 + sx, y: y2 + sy };
  }
  function buildLayerMatrix(g) {
    var layering = map(range$1(maxRank(g) + 1), function() {
      return [];
    });
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      var rank2 = node2.rank;
      if (!isUndefined(rank2)) {
        layering[rank2][node2.order] = v;
      }
    });
    return layering;
  }
  function normalizeRanks(g) {
    var min2 = min$1(
      map(g.nodes(), function(v) {
        return g.node(v).rank;
      })
    );
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      if (has(node2, "rank")) {
        node2.rank -= min2;
      }
    });
  }
  function removeEmptyRanks(g) {
    var offset = min$1(
      map(g.nodes(), function(v) {
        return g.node(v).rank;
      })
    );
    var layers = [];
    forEach(g.nodes(), function(v) {
      var rank2 = g.node(v).rank - offset;
      if (!layers[rank2]) {
        layers[rank2] = [];
      }
      layers[rank2].push(v);
    });
    var delta = 0;
    var nodeRankFactor = g.graph().nodeRankFactor;
    forEach(layers, function(vs, i2) {
      if (isUndefined(vs) && i2 % nodeRankFactor !== 0) {
        --delta;
      } else if (delta) {
        forEach(vs, function(v) {
          g.node(v).rank += delta;
        });
      }
    });
  }
  function addBorderNode$1(g, prefix, rank2, order2) {
    var node2 = {
      width: 0,
      height: 0
    };
    if (arguments.length >= 4) {
      node2.rank = rank2;
      node2.order = order2;
    }
    return addDummyNode(g, "border", node2, prefix);
  }
  function maxRank(g) {
    return max$1(
      map(g.nodes(), function(v) {
        var rank2 = g.node(v).rank;
        if (!isUndefined(rank2)) {
          return rank2;
        }
      })
    );
  }
  function partition(collection, fn) {
    var result = { lhs: [], rhs: [] };
    forEach(collection, function(value2) {
      if (fn(value2)) {
        result.lhs.push(value2);
      } else {
        result.rhs.push(value2);
      }
    });
    return result;
  }
  function time(name, fn) {
    var start2 = now$1();
    try {
      return fn();
    } finally {
      console.log(name + " time: " + (now$1() - start2) + "ms");
    }
  }
  function notime(name, fn) {
    return fn();
  }
  function addBorderSegments(g) {
    function dfs2(v) {
      var children2 = g.children(v);
      var node2 = g.node(v);
      if (children2.length) {
        forEach(children2, dfs2);
      }
      if (has(node2, "minRank")) {
        node2.borderLeft = [];
        node2.borderRight = [];
        for (var rank2 = node2.minRank, maxRank2 = node2.maxRank + 1; rank2 < maxRank2; ++rank2) {
          addBorderNode(g, "borderLeft", "_bl", v, node2, rank2);
          addBorderNode(g, "borderRight", "_br", v, node2, rank2);
        }
      }
    }
    forEach(g.children(), dfs2);
  }
  function addBorderNode(g, prop, prefix, sg, sgNode, rank2) {
    var label = { width: 0, height: 0, rank: rank2, borderType: prop };
    var prev2 = sgNode[prop][rank2 - 1];
    var curr = addDummyNode(g, "border", label, prefix);
    sgNode[prop][rank2] = curr;
    g.setParent(curr, sg);
    if (prev2) {
      g.setEdge(prev2, curr, { weight: 1 });
    }
  }
  function adjust(g) {
    var rankDir = g.graph().rankdir.toLowerCase();
    if (rankDir === "lr" || rankDir === "rl") {
      swapWidthHeight(g);
    }
  }
  function undo$1(g) {
    var rankDir = g.graph().rankdir.toLowerCase();
    if (rankDir === "bt" || rankDir === "rl") {
      reverseY(g);
    }
    if (rankDir === "lr" || rankDir === "rl") {
      swapXY(g);
      swapWidthHeight(g);
    }
  }
  function swapWidthHeight(g) {
    forEach(g.nodes(), function(v) {
      swapWidthHeightOne(g.node(v));
    });
    forEach(g.edges(), function(e) {
      swapWidthHeightOne(g.edge(e));
    });
  }
  function swapWidthHeightOne(attrs) {
    var w2 = attrs.width;
    attrs.width = attrs.height;
    attrs.height = w2;
  }
  function reverseY(g) {
    forEach(g.nodes(), function(v) {
      reverseYOne(g.node(v));
    });
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      forEach(edge.points, reverseYOne);
      if (has(edge, "y")) {
        reverseYOne(edge);
      }
    });
  }
  function reverseYOne(attrs) {
    attrs.y = -attrs.y;
  }
  function swapXY(g) {
    forEach(g.nodes(), function(v) {
      swapXYOne(g.node(v));
    });
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      forEach(edge.points, swapXYOne);
      if (has(edge, "x")) {
        swapXYOne(edge);
      }
    });
  }
  function swapXYOne(attrs) {
    var x2 = attrs.x;
    attrs.x = attrs.y;
    attrs.y = x2;
  }
  function run$1(g) {
    g.graph().dummyChains = [];
    forEach(g.edges(), function(edge) {
      normalizeEdge(g, edge);
    });
  }
  function normalizeEdge(g, e) {
    var v = e.v;
    var vRank = g.node(v).rank;
    var w2 = e.w;
    var wRank = g.node(w2).rank;
    var name = e.name;
    var edgeLabel = g.edge(e);
    var labelRank = edgeLabel.labelRank;
    if (wRank === vRank + 1)
      return;
    g.removeEdge(e);
    var dummy, attrs, i2;
    for (i2 = 0, ++vRank; vRank < wRank; ++i2, ++vRank) {
      edgeLabel.points = [];
      attrs = {
        width: 0,
        height: 0,
        edgeLabel,
        edgeObj: e,
        rank: vRank
      };
      dummy = addDummyNode(g, "edge", attrs, "_d");
      if (vRank === labelRank) {
        attrs.width = edgeLabel.width;
        attrs.height = edgeLabel.height;
        attrs.dummy = "edge-label";
        attrs.labelpos = edgeLabel.labelpos;
      }
      g.setEdge(v, dummy, { weight: edgeLabel.weight }, name);
      if (i2 === 0) {
        g.graph().dummyChains.push(dummy);
      }
      v = dummy;
    }
    g.setEdge(v, w2, { weight: edgeLabel.weight }, name);
  }
  function undo(g) {
    forEach(g.graph().dummyChains, function(v) {
      var node2 = g.node(v);
      var origLabel = node2.edgeLabel;
      var w2;
      g.setEdge(node2.edgeObj, origLabel);
      while (node2.dummy) {
        w2 = g.successors(v)[0];
        g.removeNode(v);
        origLabel.points.push({ x: node2.x, y: node2.y });
        if (node2.dummy === "edge-label") {
          origLabel.x = node2.x;
          origLabel.y = node2.y;
          origLabel.width = node2.width;
          origLabel.height = node2.height;
        }
        v = w2;
        node2 = g.node(v);
      }
    });
  }
  function longestPath(g) {
    var visited = {};
    function dfs2(v) {
      var label = g.node(v);
      if (has(visited, v)) {
        return label.rank;
      }
      visited[v] = true;
      var rank2 = min$1(
        map(g.outEdges(v), function(e) {
          return dfs2(e.w) - g.edge(e).minlen;
        })
      );
      if (rank2 === Number.POSITIVE_INFINITY || // return value of _.map([]) for Lodash 3
      rank2 === void 0 || // return value of _.map([]) for Lodash 4
      rank2 === null) {
        rank2 = 0;
      }
      return label.rank = rank2;
    }
    forEach(g.sources(), dfs2);
  }
  function slack(g, e) {
    return g.node(e.w).rank - g.node(e.v).rank - g.edge(e).minlen;
  }
  function feasibleTree(g) {
    var t = new Graph({ directed: false });
    var start2 = g.nodes()[0];
    var size2 = g.nodeCount();
    t.setNode(start2, {});
    var edge, delta;
    while (tightTree(t, g) < size2) {
      edge = findMinSlackEdge(t, g);
      delta = t.hasNode(edge.v) ? slack(g, edge) : -slack(g, edge);
      shiftRanks(t, g, delta);
    }
    return t;
  }
  function tightTree(t, g) {
    function dfs2(v) {
      forEach(g.nodeEdges(v), function(e) {
        var edgeV = e.v, w2 = v === edgeV ? e.w : edgeV;
        if (!t.hasNode(w2) && !slack(g, e)) {
          t.setNode(w2, {});
          t.setEdge(v, w2, {});
          dfs2(w2);
        }
      });
    }
    forEach(t.nodes(), dfs2);
    return t.nodeCount();
  }
  function findMinSlackEdge(t, g) {
    return minBy(g.edges(), function(e) {
      if (t.hasNode(e.v) !== t.hasNode(e.w)) {
        return slack(g, e);
      }
    });
  }
  function shiftRanks(t, g, delta) {
    forEach(t.nodes(), function(v) {
      g.node(v).rank += delta;
    });
  }
  function CycleException() {
  }
  CycleException.prototype = new Error();
  function dfs$1(g, vs, order2) {
    if (!isArray$1(vs)) {
      vs = [vs];
    }
    var navigation = (g.isDirected() ? g.successors : g.neighbors).bind(g);
    var acc = [];
    var visited = {};
    forEach(vs, function(v) {
      if (!g.hasNode(v)) {
        throw new Error("Graph does not have node: " + v);
      }
      doDfs(g, v, order2 === "post", visited, navigation, acc);
    });
    return acc;
  }
  function doDfs(g, v, postorder2, visited, navigation, acc) {
    if (!has(visited, v)) {
      visited[v] = true;
      if (!postorder2) {
        acc.push(v);
      }
      forEach(navigation(v), function(w2) {
        doDfs(g, w2, postorder2, visited, navigation, acc);
      });
      if (postorder2) {
        acc.push(v);
      }
    }
  }
  function postorder$1(g, vs) {
    return dfs$1(g, vs, "post");
  }
  function preorder(g, vs) {
    return dfs$1(g, vs, "pre");
  }
  networkSimplex.initLowLimValues = initLowLimValues;
  networkSimplex.initCutValues = initCutValues;
  networkSimplex.calcCutValue = calcCutValue;
  networkSimplex.leaveEdge = leaveEdge;
  networkSimplex.enterEdge = enterEdge;
  networkSimplex.exchangeEdges = exchangeEdges;
  function networkSimplex(g) {
    g = simplify(g);
    longestPath(g);
    var t = feasibleTree(g);
    initLowLimValues(t);
    initCutValues(t, g);
    var e, f2;
    while (e = leaveEdge(t)) {
      f2 = enterEdge(t, g, e);
      exchangeEdges(t, g, e, f2);
    }
  }
  function initCutValues(t, g) {
    var vs = postorder$1(t, t.nodes());
    vs = vs.slice(0, vs.length - 1);
    forEach(vs, function(v) {
      assignCutValue(t, g, v);
    });
  }
  function assignCutValue(t, g, child) {
    var childLab = t.node(child);
    var parent = childLab.parent;
    t.edge(child, parent).cutvalue = calcCutValue(t, g, child);
  }
  function calcCutValue(t, g, child) {
    var childLab = t.node(child);
    var parent = childLab.parent;
    var childIsTail = true;
    var graphEdge = g.edge(child, parent);
    var cutValue = 0;
    if (!graphEdge) {
      childIsTail = false;
      graphEdge = g.edge(parent, child);
    }
    cutValue = graphEdge.weight;
    forEach(g.nodeEdges(child), function(e) {
      var isOutEdge = e.v === child, other = isOutEdge ? e.w : e.v;
      if (other !== parent) {
        var pointsToHead = isOutEdge === childIsTail, otherWeight = g.edge(e).weight;
        cutValue += pointsToHead ? otherWeight : -otherWeight;
        if (isTreeEdge(t, child, other)) {
          var otherCutValue = t.edge(child, other).cutvalue;
          cutValue += pointsToHead ? -otherCutValue : otherCutValue;
        }
      }
    });
    return cutValue;
  }
  function initLowLimValues(tree, root2) {
    if (arguments.length < 2) {
      root2 = tree.nodes()[0];
    }
    dfsAssignLowLim(tree, {}, 1, root2);
  }
  function dfsAssignLowLim(tree, visited, nextLim, v, parent) {
    var low = nextLim;
    var label = tree.node(v);
    visited[v] = true;
    forEach(tree.neighbors(v), function(w2) {
      if (!has(visited, w2)) {
        nextLim = dfsAssignLowLim(tree, visited, nextLim, w2, v);
      }
    });
    label.low = low;
    label.lim = nextLim++;
    if (parent) {
      label.parent = parent;
    } else {
      delete label.parent;
    }
    return nextLim;
  }
  function leaveEdge(tree) {
    return find$2(tree.edges(), function(e) {
      return tree.edge(e).cutvalue < 0;
    });
  }
  function enterEdge(t, g, edge) {
    var v = edge.v;
    var w2 = edge.w;
    if (!g.hasEdge(v, w2)) {
      v = edge.w;
      w2 = edge.v;
    }
    var vLabel = t.node(v);
    var wLabel = t.node(w2);
    var tailLabel = vLabel;
    var flip = false;
    if (vLabel.lim > wLabel.lim) {
      tailLabel = wLabel;
      flip = true;
    }
    var candidates = filter(g.edges(), function(edge2) {
      return flip === isDescendant$1(t, t.node(edge2.v), tailLabel) && flip !== isDescendant$1(t, t.node(edge2.w), tailLabel);
    });
    return minBy(candidates, function(edge2) {
      return slack(g, edge2);
    });
  }
  function exchangeEdges(t, g, e, f2) {
    var v = e.v;
    var w2 = e.w;
    t.removeEdge(v, w2);
    t.setEdge(f2.v, f2.w, {});
    initLowLimValues(t);
    initCutValues(t, g);
    updateRanks(t, g);
  }
  function updateRanks(t, g) {
    var root2 = find$2(t.nodes(), function(v) {
      return !g.node(v).parent;
    });
    var vs = preorder(t, root2);
    vs = vs.slice(1);
    forEach(vs, function(v) {
      var parent = t.node(v).parent, edge = g.edge(v, parent), flipped = false;
      if (!edge) {
        edge = g.edge(parent, v);
        flipped = true;
      }
      g.node(v).rank = g.node(parent).rank + (flipped ? edge.minlen : -edge.minlen);
    });
  }
  function isTreeEdge(tree, u, v) {
    return tree.hasEdge(u, v);
  }
  function isDescendant$1(tree, vLabel, rootLabel) {
    return rootLabel.low <= vLabel.lim && vLabel.lim <= rootLabel.lim;
  }
  function rank(g) {
    switch (g.graph().ranker) {
      case "network-simplex":
        networkSimplexRanker(g);
        break;
      case "tight-tree":
        tightTreeRanker(g);
        break;
      case "longest-path":
        longestPathRanker(g);
        break;
      default:
        networkSimplexRanker(g);
    }
  }
  var longestPathRanker = longestPath;
  function tightTreeRanker(g) {
    longestPath(g);
    feasibleTree(g);
  }
  function networkSimplexRanker(g) {
    networkSimplex(g);
  }
  function run(g) {
    var root2 = addDummyNode(g, "root", {}, "_root");
    var depths = treeDepths(g);
    var height = max$1(values(depths)) - 1;
    var nodeSep = 2 * height + 1;
    g.graph().nestingRoot = root2;
    forEach(g.edges(), function(e) {
      g.edge(e).minlen *= nodeSep;
    });
    var weight = sumWeights(g) + 1;
    forEach(g.children(), function(child) {
      dfs(g, root2, nodeSep, weight, height, depths, child);
    });
    g.graph().nodeRankFactor = nodeSep;
  }
  function dfs(g, root2, nodeSep, weight, height, depths, v) {
    var children2 = g.children(v);
    if (!children2.length) {
      if (v !== root2) {
        g.setEdge(root2, v, { weight: 0, minlen: nodeSep });
      }
      return;
    }
    var top2 = addBorderNode$1(g, "_bt");
    var bottom2 = addBorderNode$1(g, "_bb");
    var label = g.node(v);
    g.setParent(top2, v);
    label.borderTop = top2;
    g.setParent(bottom2, v);
    label.borderBottom = bottom2;
    forEach(children2, function(child) {
      dfs(g, root2, nodeSep, weight, height, depths, child);
      var childNode = g.node(child);
      var childTop = childNode.borderTop ? childNode.borderTop : child;
      var childBottom = childNode.borderBottom ? childNode.borderBottom : child;
      var thisWeight = childNode.borderTop ? weight : 2 * weight;
      var minlen = childTop !== childBottom ? 1 : height - depths[v] + 1;
      g.setEdge(top2, childTop, {
        weight: thisWeight,
        minlen,
        nestingEdge: true
      });
      g.setEdge(childBottom, bottom2, {
        weight: thisWeight,
        minlen,
        nestingEdge: true
      });
    });
    if (!g.parent(v)) {
      g.setEdge(root2, top2, { weight: 0, minlen: height + depths[v] });
    }
  }
  function treeDepths(g) {
    var depths = {};
    function dfs2(v, depth) {
      var children2 = g.children(v);
      if (children2 && children2.length) {
        forEach(children2, function(child) {
          dfs2(child, depth + 1);
        });
      }
      depths[v] = depth;
    }
    forEach(g.children(), function(v) {
      dfs2(v, 1);
    });
    return depths;
  }
  function sumWeights(g) {
    return reduce(
      g.edges(),
      function(acc, e) {
        return acc + g.edge(e).weight;
      },
      0
    );
  }
  function cleanup(g) {
    var graphLabel = g.graph();
    g.removeNode(graphLabel.nestingRoot);
    delete graphLabel.nestingRoot;
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      if (edge.nestingEdge) {
        g.removeEdge(e);
      }
    });
  }
  function addSubgraphConstraints(g, cg, vs) {
    var prev2 = {}, rootPrev;
    forEach(vs, function(v) {
      var child = g.parent(v), parent, prevChild;
      while (child) {
        parent = g.parent(child);
        if (parent) {
          prevChild = prev2[parent];
          prev2[parent] = child;
        } else {
          prevChild = rootPrev;
          rootPrev = child;
        }
        if (prevChild && prevChild !== child) {
          cg.setEdge(prevChild, child);
          return;
        }
        child = parent;
      }
    });
  }
  function buildLayerGraph(g, rank2, relationship) {
    var root2 = createRootNode(g), result = new Graph({ compound: true }).setGraph({ root: root2 }).setDefaultNodeLabel(function(v) {
      return g.node(v);
    });
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v), parent = g.parent(v);
      if (node2.rank === rank2 || node2.minRank <= rank2 && rank2 <= node2.maxRank) {
        result.setNode(v);
        result.setParent(v, parent || root2);
        forEach(g[relationship](v), function(e) {
          var u = e.v === v ? e.w : e.v, edge = result.edge(u, v), weight = !isUndefined(edge) ? edge.weight : 0;
          result.setEdge(u, v, { weight: g.edge(e).weight + weight });
        });
        if (has(node2, "minRank")) {
          result.setNode(v, {
            borderLeft: node2.borderLeft[rank2],
            borderRight: node2.borderRight[rank2]
          });
        }
      }
    });
    return result;
  }
  function createRootNode(g) {
    var v;
    while (g.hasNode(v = uniqueId("_root")))
      ;
    return v;
  }
  function crossCount(g, layering) {
    var cc = 0;
    for (var i2 = 1; i2 < layering.length; ++i2) {
      cc += twoLayerCrossCount(g, layering[i2 - 1], layering[i2]);
    }
    return cc;
  }
  function twoLayerCrossCount(g, northLayer, southLayer) {
    var southPos = zipObject(
      southLayer,
      map(southLayer, function(v, i2) {
        return i2;
      })
    );
    var southEntries = flatten(
      map(northLayer, function(v) {
        return sortBy$1(
          map(g.outEdges(v), function(e) {
            return { pos: southPos[e.w], weight: g.edge(e).weight };
          }),
          "pos"
        );
      })
    );
    var firstIndex = 1;
    while (firstIndex < southLayer.length)
      firstIndex <<= 1;
    var treeSize = 2 * firstIndex - 1;
    firstIndex -= 1;
    var tree = map(new Array(treeSize), function() {
      return 0;
    });
    var cc = 0;
    forEach(
      // @ts-expect-error
      southEntries.forEach(function(entry) {
        var index2 = entry.pos + firstIndex;
        tree[index2] += entry.weight;
        var weightSum = 0;
        while (index2 > 0) {
          if (index2 % 2) {
            weightSum += tree[index2 + 1];
          }
          index2 = index2 - 1 >> 1;
          tree[index2] += entry.weight;
        }
        cc += entry.weight * weightSum;
      })
    );
    return cc;
  }
  function initOrder(g) {
    var visited = {};
    var simpleNodes = filter(g.nodes(), function(v) {
      return !g.children(v).length;
    });
    var maxRank2 = max$1(
      map(simpleNodes, function(v) {
        return g.node(v).rank;
      })
    );
    var layers = map(range$1(maxRank2 + 1), function() {
      return [];
    });
    function dfs2(v) {
      if (has(visited, v))
        return;
      visited[v] = true;
      var node2 = g.node(v);
      layers[node2.rank].push(v);
      forEach(g.successors(v), dfs2);
    }
    var orderedVs = sortBy$1(simpleNodes, function(v) {
      return g.node(v).rank;
    });
    forEach(orderedVs, dfs2);
    return layers;
  }
  function barycenter(g, movable) {
    return map(movable, function(v) {
      var inV = g.inEdges(v);
      if (!inV.length) {
        return { v };
      } else {
        var result = reduce(
          inV,
          function(acc, e) {
            var edge = g.edge(e), nodeU = g.node(e.v);
            return {
              sum: acc.sum + edge.weight * nodeU.order,
              weight: acc.weight + edge.weight
            };
          },
          { sum: 0, weight: 0 }
        );
        return {
          v,
          barycenter: result.sum / result.weight,
          weight: result.weight
        };
      }
    });
  }
  function resolveConflicts(entries2, cg) {
    var mappedEntries = {};
    forEach(entries2, function(entry, i2) {
      var tmp = mappedEntries[entry.v] = {
        indegree: 0,
        in: [],
        out: [],
        vs: [entry.v],
        i: i2
      };
      if (!isUndefined(entry.barycenter)) {
        tmp.barycenter = entry.barycenter;
        tmp.weight = entry.weight;
      }
    });
    forEach(cg.edges(), function(e) {
      var entryV = mappedEntries[e.v];
      var entryW = mappedEntries[e.w];
      if (!isUndefined(entryV) && !isUndefined(entryW)) {
        entryW.indegree++;
        entryV.out.push(mappedEntries[e.w]);
      }
    });
    var sourceSet = filter(mappedEntries, function(entry) {
      return !entry.indegree;
    });
    return doResolveConflicts(sourceSet);
  }
  function doResolveConflicts(sourceSet) {
    var entries2 = [];
    function handleIn(vEntry) {
      return function(uEntry) {
        if (uEntry.merged) {
          return;
        }
        if (isUndefined(uEntry.barycenter) || isUndefined(vEntry.barycenter) || uEntry.barycenter >= vEntry.barycenter) {
          mergeEntries(vEntry, uEntry);
        }
      };
    }
    function handleOut(vEntry) {
      return function(wEntry) {
        wEntry["in"].push(vEntry);
        if (--wEntry.indegree === 0) {
          sourceSet.push(wEntry);
        }
      };
    }
    while (sourceSet.length) {
      var entry = sourceSet.pop();
      entries2.push(entry);
      forEach(entry["in"].reverse(), handleIn(entry));
      forEach(entry.out, handleOut(entry));
    }
    return map(
      filter(entries2, function(entry2) {
        return !entry2.merged;
      }),
      function(entry2) {
        return pick$1(entry2, ["vs", "i", "barycenter", "weight"]);
      }
    );
  }
  function mergeEntries(target, source) {
    var sum2 = 0;
    var weight = 0;
    if (target.weight) {
      sum2 += target.barycenter * target.weight;
      weight += target.weight;
    }
    if (source.weight) {
      sum2 += source.barycenter * source.weight;
      weight += source.weight;
    }
    target.vs = source.vs.concat(target.vs);
    target.barycenter = sum2 / weight;
    target.weight = weight;
    target.i = Math.min(source.i, target.i);
    source.merged = true;
  }
  function sort(entries2, biasRight) {
    var parts = partition(entries2, function(entry) {
      return has(entry, "barycenter");
    });
    var sortable = parts.lhs, unsortable = sortBy$1(parts.rhs, function(entry) {
      return -entry.i;
    }), vs = [], sum2 = 0, weight = 0, vsIndex = 0;
    sortable.sort(compareWithBias(!!biasRight));
    vsIndex = consumeUnsortable(vs, unsortable, vsIndex);
    forEach(sortable, function(entry) {
      vsIndex += entry.vs.length;
      vs.push(entry.vs);
      sum2 += entry.barycenter * entry.weight;
      weight += entry.weight;
      vsIndex = consumeUnsortable(vs, unsortable, vsIndex);
    });
    var result = { vs: flatten(vs) };
    if (weight) {
      result.barycenter = sum2 / weight;
      result.weight = weight;
    }
    return result;
  }
  function consumeUnsortable(vs, unsortable, index2) {
    var last$1;
    while (unsortable.length && (last$1 = last(unsortable)).i <= index2) {
      unsortable.pop();
      vs.push(last$1.vs);
      index2++;
    }
    return index2;
  }
  function compareWithBias(bias) {
    return function(entryV, entryW) {
      if (entryV.barycenter < entryW.barycenter) {
        return -1;
      } else if (entryV.barycenter > entryW.barycenter) {
        return 1;
      }
      return !bias ? entryV.i - entryW.i : entryW.i - entryV.i;
    };
  }
  function sortSubgraph(g, v, cg, biasRight) {
    var movable = g.children(v);
    var node2 = g.node(v);
    var bl = node2 ? node2.borderLeft : void 0;
    var br = node2 ? node2.borderRight : void 0;
    var subgraphs = {};
    if (bl) {
      movable = filter(movable, function(w2) {
        return w2 !== bl && w2 !== br;
      });
    }
    var barycenters = barycenter(g, movable);
    forEach(barycenters, function(entry) {
      if (g.children(entry.v).length) {
        var subgraphResult = sortSubgraph(g, entry.v, cg, biasRight);
        subgraphs[entry.v] = subgraphResult;
        if (has(subgraphResult, "barycenter")) {
          mergeBarycenters(entry, subgraphResult);
        }
      }
    });
    var entries2 = resolveConflicts(barycenters, cg);
    expandSubgraphs(entries2, subgraphs);
    var result = sort(entries2, biasRight);
    if (bl) {
      result.vs = flatten([bl, result.vs, br]);
      if (g.predecessors(bl).length) {
        var blPred = g.node(g.predecessors(bl)[0]), brPred = g.node(g.predecessors(br)[0]);
        if (!has(result, "barycenter")) {
          result.barycenter = 0;
          result.weight = 0;
        }
        result.barycenter = (result.barycenter * result.weight + blPred.order + brPred.order) / (result.weight + 2);
        result.weight += 2;
      }
    }
    return result;
  }
  function expandSubgraphs(entries2, subgraphs) {
    forEach(entries2, function(entry) {
      entry.vs = flatten(
        entry.vs.map(function(v) {
          if (subgraphs[v]) {
            return subgraphs[v].vs;
          }
          return v;
        })
      );
    });
  }
  function mergeBarycenters(target, other) {
    if (!isUndefined(target.barycenter)) {
      target.barycenter = (target.barycenter * target.weight + other.barycenter * other.weight) / (target.weight + other.weight);
      target.weight += other.weight;
    } else {
      target.barycenter = other.barycenter;
      target.weight = other.weight;
    }
  }
  function order(g) {
    var maxRank$1 = maxRank(g), downLayerGraphs = buildLayerGraphs(g, range$1(1, maxRank$1 + 1), "inEdges"), upLayerGraphs = buildLayerGraphs(g, range$1(maxRank$1 - 1, -1, -1), "outEdges");
    var layering = initOrder(g);
    assignOrder(g, layering);
    var bestCC = Number.POSITIVE_INFINITY, best;
    for (var i2 = 0, lastBest = 0; lastBest < 4; ++i2, ++lastBest) {
      sweepLayerGraphs(i2 % 2 ? downLayerGraphs : upLayerGraphs, i2 % 4 >= 2);
      layering = buildLayerMatrix(g);
      var cc = crossCount(g, layering);
      if (cc < bestCC) {
        lastBest = 0;
        best = cloneDeep(layering);
        bestCC = cc;
      }
    }
    assignOrder(g, best);
  }
  function buildLayerGraphs(g, ranks, relationship) {
    return map(ranks, function(rank2) {
      return buildLayerGraph(g, rank2, relationship);
    });
  }
  function sweepLayerGraphs(layerGraphs, biasRight) {
    var cg = new Graph();
    forEach(layerGraphs, function(lg) {
      var root2 = lg.graph().root;
      var sorted = sortSubgraph(lg, root2, cg, biasRight);
      forEach(sorted.vs, function(v, i2) {
        lg.node(v).order = i2;
      });
      addSubgraphConstraints(lg, cg, sorted.vs);
    });
  }
  function assignOrder(g, layering) {
    forEach(layering, function(layer) {
      forEach(layer, function(v, i2) {
        g.node(v).order = i2;
      });
    });
  }
  function parentDummyChains(g) {
    var postorderNums = postorder(g);
    forEach(g.graph().dummyChains, function(v) {
      var node2 = g.node(v);
      var edgeObj = node2.edgeObj;
      var pathData = findPath(g, postorderNums, edgeObj.v, edgeObj.w);
      var path2 = pathData.path;
      var lca = pathData.lca;
      var pathIdx = 0;
      var pathV = path2[pathIdx];
      var ascending2 = true;
      while (v !== edgeObj.w) {
        node2 = g.node(v);
        if (ascending2) {
          while ((pathV = path2[pathIdx]) !== lca && g.node(pathV).maxRank < node2.rank) {
            pathIdx++;
          }
          if (pathV === lca) {
            ascending2 = false;
          }
        }
        if (!ascending2) {
          while (pathIdx < path2.length - 1 && g.node(pathV = path2[pathIdx + 1]).minRank <= node2.rank) {
            pathIdx++;
          }
          pathV = path2[pathIdx];
        }
        g.setParent(v, pathV);
        v = g.successors(v)[0];
      }
    });
  }
  function findPath(g, postorderNums, v, w2) {
    var vPath = [];
    var wPath = [];
    var low = Math.min(postorderNums[v].low, postorderNums[w2].low);
    var lim = Math.max(postorderNums[v].lim, postorderNums[w2].lim);
    var parent;
    var lca;
    parent = v;
    do {
      parent = g.parent(parent);
      vPath.push(parent);
    } while (parent && (postorderNums[parent].low > low || lim > postorderNums[parent].lim));
    lca = parent;
    parent = w2;
    while ((parent = g.parent(parent)) !== lca) {
      wPath.push(parent);
    }
    return { path: vPath.concat(wPath.reverse()), lca };
  }
  function postorder(g) {
    var result = {};
    var lim = 0;
    function dfs2(v) {
      var low = lim;
      forEach(g.children(v), dfs2);
      result[v] = { low, lim: lim++ };
    }
    forEach(g.children(), dfs2);
    return result;
  }
  function findType1Conflicts(g, layering) {
    var conflicts = {};
    function visitLayer(prevLayer, layer) {
      var k0 = 0, scanPos = 0, prevLayerLength = prevLayer.length, lastNode = last(layer);
      forEach(layer, function(v, i2) {
        var w2 = findOtherInnerSegmentNode(g, v), k1 = w2 ? g.node(w2).order : prevLayerLength;
        if (w2 || v === lastNode) {
          forEach(layer.slice(scanPos, i2 + 1), function(scanNode) {
            forEach(g.predecessors(scanNode), function(u) {
              var uLabel = g.node(u), uPos = uLabel.order;
              if ((uPos < k0 || k1 < uPos) && !(uLabel.dummy && g.node(scanNode).dummy)) {
                addConflict(conflicts, u, scanNode);
              }
            });
          });
          scanPos = i2 + 1;
          k0 = k1;
        }
      });
      return layer;
    }
    reduce(layering, visitLayer);
    return conflicts;
  }
  function findType2Conflicts(g, layering) {
    var conflicts = {};
    function scan(south, southPos, southEnd, prevNorthBorder, nextNorthBorder) {
      var v;
      forEach(range$1(southPos, southEnd), function(i2) {
        v = south[i2];
        if (g.node(v).dummy) {
          forEach(g.predecessors(v), function(u) {
            var uNode = g.node(u);
            if (uNode.dummy && (uNode.order < prevNorthBorder || uNode.order > nextNorthBorder)) {
              addConflict(conflicts, u, v);
            }
          });
        }
      });
    }
    function visitLayer(north, south) {
      var prevNorthPos = -1, nextNorthPos, southPos = 0;
      forEach(south, function(v, southLookahead) {
        if (g.node(v).dummy === "border") {
          var predecessors = g.predecessors(v);
          if (predecessors.length) {
            nextNorthPos = g.node(predecessors[0]).order;
            scan(south, southPos, southLookahead, prevNorthPos, nextNorthPos);
            southPos = southLookahead;
            prevNorthPos = nextNorthPos;
          }
        }
        scan(south, southPos, south.length, nextNorthPos, north.length);
      });
      return south;
    }
    reduce(layering, visitLayer);
    return conflicts;
  }
  function findOtherInnerSegmentNode(g, v) {
    if (g.node(v).dummy) {
      return find$2(g.predecessors(v), function(u) {
        return g.node(u).dummy;
      });
    }
  }
  function addConflict(conflicts, v, w2) {
    if (v > w2) {
      var tmp = v;
      v = w2;
      w2 = tmp;
    }
    var conflictsV = conflicts[v];
    if (!conflictsV) {
      conflicts[v] = conflictsV = {};
    }
    conflictsV[w2] = true;
  }
  function hasConflict(conflicts, v, w2) {
    if (v > w2) {
      var tmp = v;
      v = w2;
      w2 = tmp;
    }
    return has(conflicts[v], w2);
  }
  function verticalAlignment(g, layering, conflicts, neighborFn) {
    var root2 = {}, align = {}, pos = {};
    forEach(layering, function(layer) {
      forEach(layer, function(v, order2) {
        root2[v] = v;
        align[v] = v;
        pos[v] = order2;
      });
    });
    forEach(layering, function(layer) {
      var prevIdx = -1;
      forEach(layer, function(v) {
        var ws = neighborFn(v);
        if (ws.length) {
          ws = sortBy$1(ws, function(w3) {
            return pos[w3];
          });
          var mp = (ws.length - 1) / 2;
          for (var i2 = Math.floor(mp), il = Math.ceil(mp); i2 <= il; ++i2) {
            var w2 = ws[i2];
            if (align[v] === v && prevIdx < pos[w2] && !hasConflict(conflicts, v, w2)) {
              align[w2] = v;
              align[v] = root2[v] = root2[w2];
              prevIdx = pos[w2];
            }
          }
        }
      });
    });
    return { root: root2, align };
  }
  function horizontalCompaction(g, layering, root2, align, reverseSep) {
    var xs = {}, blockG = buildBlockGraph(g, layering, root2, reverseSep), borderType = reverseSep ? "borderLeft" : "borderRight";
    function iterate(setXsFunc, nextNodesFunc) {
      var stack = blockG.nodes();
      var elem = stack.pop();
      var visited = {};
      while (elem) {
        if (visited[elem]) {
          setXsFunc(elem);
        } else {
          visited[elem] = true;
          stack.push(elem);
          stack = stack.concat(nextNodesFunc(elem));
        }
        elem = stack.pop();
      }
    }
    function pass1(elem) {
      xs[elem] = blockG.inEdges(elem).reduce(function(acc, e) {
        return Math.max(acc, xs[e.v] + blockG.edge(e));
      }, 0);
    }
    function pass2(elem) {
      var min2 = blockG.outEdges(elem).reduce(function(acc, e) {
        return Math.min(acc, xs[e.w] - blockG.edge(e));
      }, Number.POSITIVE_INFINITY);
      var node2 = g.node(elem);
      if (min2 !== Number.POSITIVE_INFINITY && node2.borderType !== borderType) {
        xs[elem] = Math.max(xs[elem], min2);
      }
    }
    iterate(pass1, blockG.predecessors.bind(blockG));
    iterate(pass2, blockG.successors.bind(blockG));
    forEach(align, function(v) {
      xs[v] = xs[root2[v]];
    });
    return xs;
  }
  function buildBlockGraph(g, layering, root2, reverseSep) {
    var blockGraph = new Graph(), graphLabel = g.graph(), sepFn = sep(graphLabel.nodesep, graphLabel.edgesep, reverseSep);
    forEach(layering, function(layer) {
      var u;
      forEach(layer, function(v) {
        var vRoot = root2[v];
        blockGraph.setNode(vRoot);
        if (u) {
          var uRoot = root2[u], prevMax = blockGraph.edge(uRoot, vRoot);
          blockGraph.setEdge(uRoot, vRoot, Math.max(sepFn(g, v, u), prevMax || 0));
        }
        u = v;
      });
    });
    return blockGraph;
  }
  function findSmallestWidthAlignment(g, xss) {
    return minBy(values(xss), function(xs) {
      var max2 = Number.NEGATIVE_INFINITY;
      var min2 = Number.POSITIVE_INFINITY;
      forIn(xs, function(x2, v) {
        var halfWidth = width(g, v) / 2;
        max2 = Math.max(x2 + halfWidth, max2);
        min2 = Math.min(x2 - halfWidth, min2);
      });
      return max2 - min2;
    });
  }
  function alignCoordinates(xss, alignTo) {
    var alignToVals = values(alignTo), alignToMin = min$1(alignToVals), alignToMax = max$1(alignToVals);
    forEach(["u", "d"], function(vert) {
      forEach(["l", "r"], function(horiz) {
        var alignment = vert + horiz, xs = xss[alignment], delta;
        if (xs === alignTo)
          return;
        var xsVals = values(xs);
        delta = horiz === "l" ? alignToMin - min$1(xsVals) : alignToMax - max$1(xsVals);
        if (delta) {
          xss[alignment] = mapValues(xs, function(x2) {
            return x2 + delta;
          });
        }
      });
    });
  }
  function balance(xss, align) {
    return mapValues(xss.ul, function(ignore, v) {
      if (align) {
        return xss[align.toLowerCase()][v];
      } else {
        var xs = sortBy$1(map(xss, v));
        return (xs[1] + xs[2]) / 2;
      }
    });
  }
  function positionX(g) {
    var layering = buildLayerMatrix(g);
    var conflicts = merge$3(findType1Conflicts(g, layering), findType2Conflicts(g, layering));
    var xss = {};
    var adjustedLayering;
    forEach(["u", "d"], function(vert) {
      adjustedLayering = vert === "u" ? layering : values(layering).reverse();
      forEach(["l", "r"], function(horiz) {
        if (horiz === "r") {
          adjustedLayering = map(adjustedLayering, function(inner) {
            return values(inner).reverse();
          });
        }
        var neighborFn = (vert === "u" ? g.predecessors : g.successors).bind(g);
        var align = verticalAlignment(g, adjustedLayering, conflicts, neighborFn);
        var xs = horizontalCompaction(g, adjustedLayering, align.root, align.align, horiz === "r");
        if (horiz === "r") {
          xs = mapValues(xs, function(x2) {
            return -x2;
          });
        }
        xss[vert + horiz] = xs;
      });
    });
    var smallestWidth = findSmallestWidthAlignment(g, xss);
    alignCoordinates(xss, smallestWidth);
    return balance(xss, g.graph().align);
  }
  function sep(nodeSep, edgeSep, reverseSep) {
    return function(g, v, w2) {
      var vLabel = g.node(v);
      var wLabel = g.node(w2);
      var sum2 = 0;
      var delta;
      sum2 += vLabel.width / 2;
      if (has(vLabel, "labelpos")) {
        switch (vLabel.labelpos.toLowerCase()) {
          case "l":
            delta = -vLabel.width / 2;
            break;
          case "r":
            delta = vLabel.width / 2;
            break;
        }
      }
      if (delta) {
        sum2 += reverseSep ? delta : -delta;
      }
      delta = 0;
      sum2 += (vLabel.dummy ? edgeSep : nodeSep) / 2;
      sum2 += (wLabel.dummy ? edgeSep : nodeSep) / 2;
      sum2 += wLabel.width / 2;
      if (has(wLabel, "labelpos")) {
        switch (wLabel.labelpos.toLowerCase()) {
          case "l":
            delta = wLabel.width / 2;
            break;
          case "r":
            delta = -wLabel.width / 2;
            break;
        }
      }
      if (delta) {
        sum2 += reverseSep ? delta : -delta;
      }
      delta = 0;
      return sum2;
    };
  }
  function width(g, v) {
    return g.node(v).width;
  }
  function position$1(g) {
    g = asNonCompoundGraph(g);
    positionY(g);
    forOwn(positionX(g), function(x2, v) {
      g.node(v).x = x2;
    });
  }
  function positionY(g) {
    var layering = buildLayerMatrix(g);
    var rankSep = g.graph().ranksep;
    var prevY = 0;
    forEach(layering, function(layer) {
      var maxHeight = max$1(
        map(layer, function(v) {
          return g.node(v).height;
        })
      );
      forEach(layer, function(v) {
        g.node(v).y = prevY + maxHeight / 2;
      });
      prevY += maxHeight + rankSep;
    });
  }
  function layout$1(g, opts) {
    var time$12 = opts && opts.debugTiming ? time : notime;
    time$12("layout", function() {
      var layoutGraph = time$12("  buildLayoutGraph", function() {
        return buildLayoutGraph(g);
      });
      time$12("  runLayout", function() {
        runLayout(layoutGraph, time$12);
      });
      time$12("  updateInputGraph", function() {
        updateInputGraph(g, layoutGraph);
      });
    });
  }
  function runLayout(g, time2) {
    time2("    makeSpaceForEdgeLabels", function() {
      makeSpaceForEdgeLabels(g);
    });
    time2("    removeSelfEdges", function() {
      removeSelfEdges(g);
    });
    time2("    acyclic", function() {
      run$2(g);
    });
    time2("    nestingGraph.run", function() {
      run(g);
    });
    time2("    rank", function() {
      rank(asNonCompoundGraph(g));
    });
    time2("    injectEdgeLabelProxies", function() {
      injectEdgeLabelProxies(g);
    });
    time2("    removeEmptyRanks", function() {
      removeEmptyRanks(g);
    });
    time2("    nestingGraph.cleanup", function() {
      cleanup(g);
    });
    time2("    normalizeRanks", function() {
      normalizeRanks(g);
    });
    time2("    assignRankMinMax", function() {
      assignRankMinMax(g);
    });
    time2("    removeEdgeLabelProxies", function() {
      removeEdgeLabelProxies(g);
    });
    time2("    normalize.run", function() {
      run$1(g);
    });
    time2("    parentDummyChains", function() {
      parentDummyChains(g);
    });
    time2("    addBorderSegments", function() {
      addBorderSegments(g);
    });
    time2("    order", function() {
      order(g);
    });
    time2("    insertSelfEdges", function() {
      insertSelfEdges(g);
    });
    time2("    adjustCoordinateSystem", function() {
      adjust(g);
    });
    time2("    position", function() {
      position$1(g);
    });
    time2("    positionSelfEdges", function() {
      positionSelfEdges(g);
    });
    time2("    removeBorderNodes", function() {
      removeBorderNodes(g);
    });
    time2("    normalize.undo", function() {
      undo(g);
    });
    time2("    fixupEdgeLabelCoords", function() {
      fixupEdgeLabelCoords(g);
    });
    time2("    undoCoordinateSystem", function() {
      undo$1(g);
    });
    time2("    translateGraph", function() {
      translateGraph(g);
    });
    time2("    assignNodeIntersects", function() {
      assignNodeIntersects(g);
    });
    time2("    reversePoints", function() {
      reversePointsForReversedEdges(g);
    });
    time2("    acyclic.undo", function() {
      undo$2(g);
    });
  }
  function updateInputGraph(inputGraph, layoutGraph) {
    forEach(inputGraph.nodes(), function(v) {
      var inputLabel = inputGraph.node(v);
      var layoutLabel = layoutGraph.node(v);
      if (inputLabel) {
        inputLabel.x = layoutLabel.x;
        inputLabel.y = layoutLabel.y;
        if (layoutGraph.children(v).length) {
          inputLabel.width = layoutLabel.width;
          inputLabel.height = layoutLabel.height;
        }
      }
    });
    forEach(inputGraph.edges(), function(e) {
      var inputLabel = inputGraph.edge(e);
      var layoutLabel = layoutGraph.edge(e);
      inputLabel.points = layoutLabel.points;
      if (has(layoutLabel, "x")) {
        inputLabel.x = layoutLabel.x;
        inputLabel.y = layoutLabel.y;
      }
    });
    inputGraph.graph().width = layoutGraph.graph().width;
    inputGraph.graph().height = layoutGraph.graph().height;
  }
  var graphNumAttrs = ["nodesep", "edgesep", "ranksep", "marginx", "marginy"];
  var graphDefaults = { ranksep: 50, edgesep: 20, nodesep: 50, rankdir: "tb" };
  var graphAttrs = ["acyclicer", "ranker", "rankdir", "align"];
  var nodeNumAttrs = ["width", "height"];
  var nodeDefaults = { width: 0, height: 0 };
  var edgeNumAttrs = ["minlen", "weight", "width", "height", "labeloffset"];
  var edgeDefaults = {
    minlen: 1,
    weight: 1,
    width: 0,
    height: 0,
    labeloffset: 10,
    labelpos: "r"
  };
  var edgeAttrs = ["labelpos"];
  function buildLayoutGraph(inputGraph) {
    var g = new Graph({ multigraph: true, compound: true });
    var graph = canonicalize(inputGraph.graph());
    g.setGraph(
      merge$3({}, graphDefaults, selectNumberAttrs(graph, graphNumAttrs), pick$1(graph, graphAttrs))
    );
    forEach(inputGraph.nodes(), function(v) {
      var node2 = canonicalize(inputGraph.node(v));
      g.setNode(v, defaults$1(selectNumberAttrs(node2, nodeNumAttrs), nodeDefaults));
      g.setParent(v, inputGraph.parent(v));
    });
    forEach(inputGraph.edges(), function(e) {
      var edge = canonicalize(inputGraph.edge(e));
      g.setEdge(
        e,
        merge$3({}, edgeDefaults, selectNumberAttrs(edge, edgeNumAttrs), pick$1(edge, edgeAttrs))
      );
    });
    return g;
  }
  function makeSpaceForEdgeLabels(g) {
    var graph = g.graph();
    graph.ranksep /= 2;
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      edge.minlen *= 2;
      if (edge.labelpos.toLowerCase() !== "c") {
        if (graph.rankdir === "TB" || graph.rankdir === "BT") {
          edge.width += edge.labeloffset;
        } else {
          edge.height += edge.labeloffset;
        }
      }
    });
  }
  function injectEdgeLabelProxies(g) {
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      if (edge.width && edge.height) {
        var v = g.node(e.v);
        var w2 = g.node(e.w);
        var label = { rank: (w2.rank - v.rank) / 2 + v.rank, e };
        addDummyNode(g, "edge-proxy", label, "_ep");
      }
    });
  }
  function assignRankMinMax(g) {
    var maxRank2 = 0;
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      if (node2.borderTop) {
        node2.minRank = g.node(node2.borderTop).rank;
        node2.maxRank = g.node(node2.borderBottom).rank;
        maxRank2 = max$1(maxRank2, node2.maxRank);
      }
    });
    g.graph().maxRank = maxRank2;
  }
  function removeEdgeLabelProxies(g) {
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      if (node2.dummy === "edge-proxy") {
        g.edge(node2.e).labelRank = node2.rank;
        g.removeNode(v);
      }
    });
  }
  function translateGraph(g) {
    var minX = Number.POSITIVE_INFINITY;
    var maxX = 0;
    var minY = Number.POSITIVE_INFINITY;
    var maxY = 0;
    var graphLabel = g.graph();
    var marginX = graphLabel.marginx || 0;
    var marginY = graphLabel.marginy || 0;
    function getExtremes(attrs) {
      var x2 = attrs.x;
      var y2 = attrs.y;
      var w2 = attrs.width;
      var h = attrs.height;
      minX = Math.min(minX, x2 - w2 / 2);
      maxX = Math.max(maxX, x2 + w2 / 2);
      minY = Math.min(minY, y2 - h / 2);
      maxY = Math.max(maxY, y2 + h / 2);
    }
    forEach(g.nodes(), function(v) {
      getExtremes(g.node(v));
    });
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      if (has(edge, "x")) {
        getExtremes(edge);
      }
    });
    minX -= marginX;
    minY -= marginY;
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      node2.x -= minX;
      node2.y -= minY;
    });
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      forEach(edge.points, function(p) {
        p.x -= minX;
        p.y -= minY;
      });
      if (has(edge, "x")) {
        edge.x -= minX;
      }
      if (has(edge, "y")) {
        edge.y -= minY;
      }
    });
    graphLabel.width = maxX - minX + marginX;
    graphLabel.height = maxY - minY + marginY;
  }
  function assignNodeIntersects(g) {
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      var nodeV = g.node(e.v);
      var nodeW = g.node(e.w);
      var p1, p2;
      if (!edge.points) {
        edge.points = [];
        p1 = nodeW;
        p2 = nodeV;
      } else {
        p1 = edge.points[0];
        p2 = edge.points[edge.points.length - 1];
      }
      edge.points.unshift(intersectRect$3(nodeV, p1));
      edge.points.push(intersectRect$3(nodeW, p2));
    });
  }
  function fixupEdgeLabelCoords(g) {
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      if (has(edge, "x")) {
        if (edge.labelpos === "l" || edge.labelpos === "r") {
          edge.width -= edge.labeloffset;
        }
        switch (edge.labelpos) {
          case "l":
            edge.x -= edge.width / 2 + edge.labeloffset;
            break;
          case "r":
            edge.x += edge.width / 2 + edge.labeloffset;
            break;
        }
      }
    });
  }
  function reversePointsForReversedEdges(g) {
    forEach(g.edges(), function(e) {
      var edge = g.edge(e);
      if (edge.reversed) {
        edge.points.reverse();
      }
    });
  }
  function removeBorderNodes(g) {
    forEach(g.nodes(), function(v) {
      if (g.children(v).length) {
        var node2 = g.node(v);
        var t = g.node(node2.borderTop);
        var b = g.node(node2.borderBottom);
        var l = g.node(last(node2.borderLeft));
        var r = g.node(last(node2.borderRight));
        node2.width = Math.abs(r.x - l.x);
        node2.height = Math.abs(b.y - t.y);
        node2.x = l.x + node2.width / 2;
        node2.y = t.y + node2.height / 2;
      }
    });
    forEach(g.nodes(), function(v) {
      if (g.node(v).dummy === "border") {
        g.removeNode(v);
      }
    });
  }
  function removeSelfEdges(g) {
    forEach(g.edges(), function(e) {
      if (e.v === e.w) {
        var node2 = g.node(e.v);
        if (!node2.selfEdges) {
          node2.selfEdges = [];
        }
        node2.selfEdges.push({ e, label: g.edge(e) });
        g.removeEdge(e);
      }
    });
  }
  function insertSelfEdges(g) {
    var layers = buildLayerMatrix(g);
    forEach(layers, function(layer) {
      var orderShift = 0;
      forEach(layer, function(v, i2) {
        var node2 = g.node(v);
        node2.order = i2 + orderShift;
        forEach(node2.selfEdges, function(selfEdge) {
          addDummyNode(
            g,
            "selfedge",
            {
              width: selfEdge.label.width,
              height: selfEdge.label.height,
              rank: node2.rank,
              order: i2 + ++orderShift,
              e: selfEdge.e,
              label: selfEdge.label
            },
            "_se"
          );
        });
        delete node2.selfEdges;
      });
    });
  }
  function positionSelfEdges(g) {
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      if (node2.dummy === "selfedge") {
        var selfNode = g.node(node2.e.v);
        var x2 = selfNode.x + selfNode.width / 2;
        var y2 = selfNode.y;
        var dx = node2.x - x2;
        var dy = selfNode.height / 2;
        g.setEdge(node2.e, node2.label);
        g.removeNode(v);
        node2.label.points = [
          { x: x2 + 2 * dx / 3, y: y2 - dy },
          { x: x2 + 5 * dx / 6, y: y2 - dy },
          { x: x2 + dx, y: y2 },
          { x: x2 + 5 * dx / 6, y: y2 + dy },
          { x: x2 + 2 * dx / 3, y: y2 + dy }
        ];
        node2.label.x = node2.x;
        node2.label.y = node2.y;
      }
    });
  }
  function selectNumberAttrs(obj, attrs) {
    return mapValues(pick$1(obj, attrs), Number);
  }
  function canonicalize(attrs) {
    var newAttrs = {};
    forEach(attrs, function(v, k) {
      newAttrs[k.toLowerCase()] = v;
    });
    return newAttrs;
  }
  function isSubgraph(g, v) {
    return !!g.children(v).length;
  }
  function edgeToId(e) {
    return escapeId(e.v) + ":" + escapeId(e.w) + ":" + escapeId(e.name);
  }
  var ID_DELIM = /:/g;
  function escapeId(str2) {
    return str2 ? String(str2).replace(ID_DELIM, "\\:") : "";
  }
  function applyStyle$2(dom, styleFn) {
    if (styleFn) {
      dom.attr("style", styleFn);
    }
  }
  function applyClass(dom, classFn, otherClasses) {
    if (classFn) {
      dom.attr("class", classFn).attr("class", otherClasses + " " + dom.attr("class"));
    }
  }
  function applyTransition(selection2, g) {
    var graph = g.graph();
    if (isPlainObject(graph)) {
      var transition = graph.transition;
      if (isFunction(transition)) {
        return transition(selection2);
      }
    }
    return selection2;
  }
  var arrows = {
    normal,
    vee,
    undirected
  };
  function setArrows(value2) {
    arrows = value2;
  }
  function normal(parent, id2, edge, type2) {
    var marker = parent.append("marker").attr("id", id2).attr("viewBox", "0 0 10 10").attr("refX", 9).attr("refY", 5).attr("markerUnits", "strokeWidth").attr("markerWidth", 8).attr("markerHeight", 6).attr("orient", "auto");
    var path2 = marker.append("path").attr("d", "M 0 0 L 10 5 L 0 10 z").style("stroke-width", 1).style("stroke-dasharray", "1,0");
    applyStyle$2(path2, edge[type2 + "Style"]);
    if (edge[type2 + "Class"]) {
      path2.attr("class", edge[type2 + "Class"]);
    }
  }
  function vee(parent, id2, edge, type2) {
    var marker = parent.append("marker").attr("id", id2).attr("viewBox", "0 0 10 10").attr("refX", 9).attr("refY", 5).attr("markerUnits", "strokeWidth").attr("markerWidth", 8).attr("markerHeight", 6).attr("orient", "auto");
    var path2 = marker.append("path").attr("d", "M 0 0 L 10 5 L 0 10 L 4 5 z").style("stroke-width", 1).style("stroke-dasharray", "1,0");
    applyStyle$2(path2, edge[type2 + "Style"]);
    if (edge[type2 + "Class"]) {
      path2.attr("class", edge[type2 + "Class"]);
    }
  }
  function undirected(parent, id2, edge, type2) {
    var marker = parent.append("marker").attr("id", id2).attr("viewBox", "0 0 10 10").attr("refX", 9).attr("refY", 5).attr("markerUnits", "strokeWidth").attr("markerWidth", 8).attr("markerHeight", 6).attr("orient", "auto");
    var path2 = marker.append("path").attr("d", "M 0 5 L 10 5").style("stroke-width", 1).style("stroke-dasharray", "1,0");
    applyStyle$2(path2, edge[type2 + "Style"]);
    if (edge[type2 + "Class"]) {
      path2.attr("class", edge[type2 + "Class"]);
    }
  }
  function addHtmlLabel$1(root2, node2) {
    var fo = root2.append("foreignObject").attr("width", "100000");
    var div = fo.append("xhtml:div");
    div.attr("xmlns", "http://www.w3.org/1999/xhtml");
    var label = node2.label;
    switch (typeof label) {
      case "function":
        div.insert(label);
        break;
      case "object":
        div.insert(function() {
          return label;
        });
        break;
      default:
        div.html(label);
    }
    applyStyle$2(div, node2.labelStyle);
    div.style("display", "inline-block");
    div.style("white-space", "nowrap");
    var client = div.node().getBoundingClientRect();
    fo.attr("width", client.width).attr("height", client.height);
    return fo;
  }
  function addSVGLabel(root2, node2) {
    var domNode = root2;
    domNode.node().appendChild(node2.label);
    applyStyle$2(domNode, node2.labelStyle);
    return domNode;
  }
  function addTextLabel(root2, node2) {
    var domNode = root2.append("text");
    var lines = processEscapeSequences(node2.label).split("\n");
    for (var i2 = 0; i2 < lines.length; i2++) {
      domNode.append("tspan").attr("xml:space", "preserve").attr("dy", "1em").attr("x", "1").text(lines[i2]);
    }
    applyStyle$2(domNode, node2.labelStyle);
    return domNode;
  }
  function processEscapeSequences(text2) {
    var newText = "";
    var escaped = false;
    var ch;
    for (var i2 = 0; i2 < text2.length; ++i2) {
      ch = text2[i2];
      if (escaped) {
        switch (ch) {
          case "n":
            newText += "\n";
            break;
          default:
            newText += ch;
        }
        escaped = false;
      } else if (ch === "\\") {
        escaped = true;
      } else {
        newText += ch;
      }
    }
    return newText;
  }
  function addLabel(root2, node2, location2) {
    var label = node2.label;
    var labelSvg = root2.append("g");
    if (node2.labelType === "svg") {
      addSVGLabel(labelSvg, node2);
    } else if (typeof label !== "string" || node2.labelType === "html") {
      addHtmlLabel$1(labelSvg, node2);
    } else {
      addTextLabel(labelSvg, node2);
    }
    var labelBBox = labelSvg.node().getBBox();
    var y2;
    switch (location2) {
      case "top":
        y2 = -node2.height / 2;
        break;
      case "bottom":
        y2 = node2.height / 2 - labelBBox.height;
        break;
      default:
        y2 = -labelBBox.height / 2;
    }
    labelSvg.attr("transform", "translate(" + -labelBBox.width / 2 + "," + y2 + ")");
    return labelSvg;
  }
  var createClusters = function(selection2, g) {
    var clusters = g.nodes().filter(function(v) {
      return isSubgraph(g, v);
    });
    var svgClusters = selection2.selectAll("g.cluster").data(clusters, function(v) {
      return v;
    });
    applyTransition(svgClusters.exit(), g).style("opacity", 0).remove();
    var enterSelection = svgClusters.enter().append("g").attr("class", "cluster").attr("id", function(v) {
      var node2 = g.node(v);
      return node2.id;
    }).style("opacity", 0).each(function(v) {
      var node2 = g.node(v);
      var thisGroup = d3select(this);
      d3select(this).append("rect");
      var labelGroup = thisGroup.append("g").attr("class", "label");
      addLabel(labelGroup, node2, node2.clusterLabelPos);
    });
    svgClusters = svgClusters.merge(enterSelection);
    svgClusters = applyTransition(svgClusters, g).style("opacity", 1);
    svgClusters.selectAll("rect").each(function(c2) {
      var node2 = g.node(c2);
      var domCluster = d3select(this);
      applyStyle$2(domCluster, node2.style);
    });
    return svgClusters;
  };
  function setCreateClusters(value2) {
    createClusters = value2;
  }
  let createEdgeLabels = function(selection2, g) {
    var svgEdgeLabels = selection2.selectAll("g.edgeLabel").data(g.edges(), function(e) {
      return edgeToId(e);
    }).classed("update", true);
    svgEdgeLabels.exit().remove();
    svgEdgeLabels.enter().append("g").classed("edgeLabel", true).style("opacity", 0);
    svgEdgeLabels = selection2.selectAll("g.edgeLabel");
    svgEdgeLabels.each(function(e) {
      var root2 = d3select(this);
      root2.select(".label").remove();
      var edge = g.edge(e);
      var label = addLabel(root2, g.edge(e), 0).classed("label", true);
      var bbox = label.node().getBBox();
      if (edge.labelId) {
        label.attr("id", edge.labelId);
      }
      if (!has(edge, "width")) {
        edge.width = bbox.width;
      }
      if (!has(edge, "height")) {
        edge.height = bbox.height;
      }
    });
    var exitSelection;
    if (svgEdgeLabels.exit) {
      exitSelection = svgEdgeLabels.exit();
    } else {
      exitSelection = svgEdgeLabels.selectAll(null);
    }
    applyTransition(exitSelection, g).style("opacity", 0).remove();
    return svgEdgeLabels;
  };
  function setCreateEdgeLabels(value2) {
    createEdgeLabels = value2;
  }
  function intersectNode$1(node2, point2) {
    return node2.intersect(point2);
  }
  var createEdgePaths = function(selection2, g, arrows2) {
    var previousPaths = selection2.selectAll("g.edgePath").data(g.edges(), function(e) {
      return edgeToId(e);
    }).classed("update", true);
    var newPaths = enter(previousPaths, g);
    exit$1(previousPaths, g);
    var svgPaths = previousPaths.merge !== void 0 ? previousPaths.merge(newPaths) : previousPaths;
    applyTransition(svgPaths, g).style("opacity", 1);
    svgPaths.each(function(e) {
      var domEdge = d3select(this);
      var edge = g.edge(e);
      edge.elem = this;
      if (edge.id) {
        domEdge.attr("id", edge.id);
      }
      applyClass(
        domEdge,
        edge["class"],
        (domEdge.classed("update") ? "update " : "") + "edgePath"
      );
    });
    svgPaths.selectAll("path.path").each(function(e) {
      var edge = g.edge(e);
      edge.arrowheadId = uniqueId("arrowhead");
      var domEdge = d3select(this).attr("marker-end", function() {
        return "url(" + makeFragmentRef(location.href, edge.arrowheadId) + ")";
      }).style("fill", "none");
      applyTransition(domEdge, g).attr("d", function(e3) {
        return calcPoints(g, e3);
      });
      applyStyle$2(domEdge, edge.style);
    });
    svgPaths.selectAll("defs *").remove();
    svgPaths.selectAll("defs").each(function(e) {
      var edge = g.edge(e);
      var arrowhead = arrows2[edge.arrowhead];
      arrowhead(d3select(this), edge.arrowheadId, edge, "arrowhead");
    });
    return svgPaths;
  };
  function setCreateEdgePaths(value2) {
    createEdgePaths = value2;
  }
  function makeFragmentRef(url, fragmentId) {
    var baseUrl = url.split("#")[0];
    return baseUrl + "#" + fragmentId;
  }
  function calcPoints(g, e) {
    var edge = g.edge(e);
    var tail = g.node(e.v);
    var head2 = g.node(e.w);
    var points = edge.points.slice(1, edge.points.length - 1);
    points.unshift(intersectNode$1(tail, points[0]));
    points.push(intersectNode$1(head2, points[points.length - 1]));
    return createLine(edge, points);
  }
  function createLine(edge, points) {
    var line2 = (line$1 || svg$2.line)().x(function(d) {
      return d.x;
    }).y(function(d) {
      return d.y;
    });
    (line2.curve || line2.interpolate)(edge.curve);
    return line2(points);
  }
  function getCoords(elem) {
    var bbox = elem.getBBox();
    var matrix = elem.ownerSVGElement.getScreenCTM().inverse().multiply(elem.getScreenCTM()).translate(bbox.width / 2, bbox.height / 2);
    return { x: matrix.e, y: matrix.f };
  }
  function enter(svgPaths, g) {
    var svgPathsEnter = svgPaths.enter().append("g").attr("class", "edgePath").style("opacity", 0);
    svgPathsEnter.append("path").attr("class", "path").attr("d", function(e) {
      var edge = g.edge(e);
      var sourceElem = g.node(e.v).elem;
      var points = range$1(edge.points.length).map(function() {
        return getCoords(sourceElem);
      });
      return createLine(edge, points);
    });
    svgPathsEnter.append("defs");
    return svgPathsEnter;
  }
  function exit$1(svgPaths, g) {
    var svgPathExit = svgPaths.exit();
    applyTransition(svgPathExit, g).style("opacity", 0).remove();
  }
  var createNodes = function(selection2, g, shapes2) {
    var simpleNodes = g.nodes().filter(function(v) {
      return !isSubgraph(g, v);
    });
    var svgNodes = selection2.selectAll("g.node").data(simpleNodes, function(v) {
      return v;
    }).classed("update", true);
    svgNodes.exit().remove();
    svgNodes.enter().append("g").attr("class", "node").style("opacity", 0);
    svgNodes = selection2.selectAll("g.node");
    svgNodes.each(function(v) {
      var node2 = g.node(v);
      var thisGroup = d3select(this);
      applyClass(
        thisGroup,
        node2["class"],
        (thisGroup.classed("update") ? "update " : "") + "node"
      );
      thisGroup.select("g.label").remove();
      var labelGroup = thisGroup.append("g").attr("class", "label");
      var labelDom = addLabel(labelGroup, node2);
      var shape = shapes2[node2.shape];
      var bbox = pick$1(labelDom.node().getBBox(), "width", "height");
      node2.elem = this;
      if (node2.id) {
        thisGroup.attr("id", node2.id);
      }
      if (node2.labelId) {
        labelGroup.attr("id", node2.labelId);
      }
      if (has(node2, "width")) {
        bbox.width = node2.width;
      }
      if (has(node2, "height")) {
        bbox.height = node2.height;
      }
      bbox.width += node2.paddingLeft + node2.paddingRight;
      bbox.height += node2.paddingTop + node2.paddingBottom;
      labelGroup.attr(
        "transform",
        "translate(" + (node2.paddingLeft - node2.paddingRight) / 2 + "," + (node2.paddingTop - node2.paddingBottom) / 2 + ")"
      );
      var root2 = d3select(this);
      root2.select(".label-container").remove();
      var shapeSvg = shape(root2, bbox, node2).classed("label-container", true);
      applyStyle$2(shapeSvg, node2.style);
      var shapeBBox = shapeSvg.node().getBBox();
      node2.width = shapeBBox.width;
      node2.height = shapeBBox.height;
    });
    var exitSelection;
    if (svgNodes.exit) {
      exitSelection = svgNodes.exit();
    } else {
      exitSelection = svgNodes.selectAll(null);
    }
    applyTransition(exitSelection, g).style("opacity", 0).remove();
    return svgNodes;
  };
  function setCreateNodes(value2) {
    createNodes = value2;
  }
  function positionClusters(selection2, g) {
    var created = selection2.filter(function() {
      return !d3select(this).classed("update");
    });
    function translate(v) {
      var node2 = g.node(v);
      return "translate(" + node2.x + "," + node2.y + ")";
    }
    created.attr("transform", translate);
    applyTransition(selection2, g).style("opacity", 1).attr("transform", translate);
    applyTransition(created.selectAll("rect"), g).attr("width", function(v) {
      return g.node(v).width;
    }).attr("height", function(v) {
      return g.node(v).height;
    }).attr("x", function(v) {
      var node2 = g.node(v);
      return -node2.width / 2;
    }).attr("y", function(v) {
      var node2 = g.node(v);
      return -node2.height / 2;
    });
  }
  function positionEdgeLabels(selection2, g) {
    var created = selection2.filter(function() {
      return !d3select(this).classed("update");
    });
    function translate(e) {
      var edge = g.edge(e);
      return has(edge, "x") ? "translate(" + edge.x + "," + edge.y + ")" : "";
    }
    created.attr("transform", translate);
    applyTransition(selection2, g).style("opacity", 1).attr("transform", translate);
  }
  function positionNodes$1(selection2, g) {
    var created = selection2.filter(function() {
      return !d3select(this).classed("update");
    });
    function translate(v) {
      var node2 = g.node(v);
      return "translate(" + node2.x + "," + node2.y + ")";
    }
    created.attr("transform", translate);
    applyTransition(selection2, g).style("opacity", 1).attr("transform", translate);
  }
  function intersectEllipse$1(node2, rx, ry, point2) {
    var cx = node2.x;
    var cy = node2.y;
    var px = cx - point2.x;
    var py = cy - point2.y;
    var det = Math.sqrt(rx * rx * py * py + ry * ry * px * px);
    var dx = Math.abs(rx * ry * px / det);
    if (point2.x < cx) {
      dx = -dx;
    }
    var dy = Math.abs(rx * ry * py / det);
    if (point2.y < cy) {
      dy = -dy;
    }
    return { x: cx + dx, y: cy + dy };
  }
  function intersectCircle$1(node2, rx, point2) {
    return intersectEllipse$1(node2, rx, rx, point2);
  }
  function intersectLine$1(p1, p2, q1, q2) {
    var a1, a2, b1, b2, c1, c2;
    var r1, r2, r3, r4;
    var denom, offset, num;
    var x2, y2;
    a1 = p2.y - p1.y;
    b1 = p1.x - p2.x;
    c1 = p2.x * p1.y - p1.x * p2.y;
    r3 = a1 * q1.x + b1 * q1.y + c1;
    r4 = a1 * q2.x + b1 * q2.y + c1;
    if (r3 !== 0 && r4 !== 0 && sameSign$1(r3, r4)) {
      return;
    }
    a2 = q2.y - q1.y;
    b2 = q1.x - q2.x;
    c2 = q2.x * q1.y - q1.x * q2.y;
    r1 = a2 * p1.x + b2 * p1.y + c2;
    r2 = a2 * p2.x + b2 * p2.y + c2;
    if (r1 !== 0 && r2 !== 0 && sameSign$1(r1, r2)) {
      return;
    }
    denom = a1 * b2 - a2 * b1;
    if (denom === 0) {
      return;
    }
    offset = Math.abs(denom / 2);
    num = b1 * c2 - b2 * c1;
    x2 = num < 0 ? (num - offset) / denom : (num + offset) / denom;
    num = a2 * c1 - a1 * c2;
    y2 = num < 0 ? (num - offset) / denom : (num + offset) / denom;
    return { x: x2, y: y2 };
  }
  function sameSign$1(r1, r2) {
    return r1 * r2 > 0;
  }
  function intersectPolygon$1(node2, polyPoints, point2) {
    var x1 = node2.x;
    var y1 = node2.y;
    var intersections = [];
    var minX = Number.POSITIVE_INFINITY;
    var minY = Number.POSITIVE_INFINITY;
    polyPoints.forEach(function(entry) {
      minX = Math.min(minX, entry.x);
      minY = Math.min(minY, entry.y);
    });
    var left2 = x1 - node2.width / 2 - minX;
    var top2 = y1 - node2.height / 2 - minY;
    for (var i2 = 0; i2 < polyPoints.length; i2++) {
      var p1 = polyPoints[i2];
      var p2 = polyPoints[i2 < polyPoints.length - 1 ? i2 + 1 : 0];
      var intersect2 = intersectLine$1(
        node2,
        point2,
        { x: left2 + p1.x, y: top2 + p1.y },
        { x: left2 + p2.x, y: top2 + p2.y }
      );
      if (intersect2) {
        intersections.push(intersect2);
      }
    }
    if (!intersections.length) {
      console.log("NO INTERSECTION FOUND, RETURN NODE CENTER", node2);
      return node2;
    }
    if (intersections.length > 1) {
      intersections.sort(function(p, q) {
        var pdx = p.x - point2.x;
        var pdy = p.y - point2.y;
        var distp = Math.sqrt(pdx * pdx + pdy * pdy);
        var qdx = q.x - point2.x;
        var qdy = q.y - point2.y;
        var distq = Math.sqrt(qdx * qdx + qdy * qdy);
        return distp < distq ? -1 : distp === distq ? 0 : 1;
      });
    }
    return intersections[0];
  }
  function intersectRect$2(node2, point2) {
    var x2 = node2.x;
    var y2 = node2.y;
    var dx = point2.x - x2;
    var dy = point2.y - y2;
    var w2 = node2.width / 2;
    var h = node2.height / 2;
    var sx, sy;
    if (Math.abs(dy) * w2 > Math.abs(dx) * h) {
      if (dy < 0) {
        h = -h;
      }
      sx = dy === 0 ? 0 : h * dx / dy;
      sy = h;
    } else {
      if (dx < 0) {
        w2 = -w2;
      }
      sx = w2;
      sy = dx === 0 ? 0 : w2 * dy / dx;
    }
    return { x: x2 + sx, y: y2 + sy };
  }
  var shapes$2 = {
    rect: rect$2,
    ellipse,
    circle: circle$2,
    diamond
  };
  function setShapes(value2) {
    shapes$2 = value2;
  }
  function rect$2(parent, bbox, node2) {
    var shapeSvg = parent.insert("rect", ":first-child").attr("rx", node2.rx).attr("ry", node2.ry).attr("x", -bbox.width / 2).attr("y", -bbox.height / 2).attr("width", bbox.width).attr("height", bbox.height);
    node2.intersect = function(point2) {
      return intersectRect$2(node2, point2);
    };
    return shapeSvg;
  }
  function ellipse(parent, bbox, node2) {
    var rx = bbox.width / 2;
    var ry = bbox.height / 2;
    var shapeSvg = parent.insert("ellipse", ":first-child").attr("x", -bbox.width / 2).attr("y", -bbox.height / 2).attr("rx", rx).attr("ry", ry);
    node2.intersect = function(point2) {
      return intersectEllipse$1(node2, rx, ry, point2);
    };
    return shapeSvg;
  }
  function circle$2(parent, bbox, node2) {
    var r = Math.max(bbox.width, bbox.height) / 2;
    var shapeSvg = parent.insert("circle", ":first-child").attr("x", -bbox.width / 2).attr("y", -bbox.height / 2).attr("r", r);
    node2.intersect = function(point2) {
      return intersectCircle$1(node2, r, point2);
    };
    return shapeSvg;
  }
  function diamond(parent, bbox, node2) {
    var w2 = bbox.width * Math.SQRT2 / 2;
    var h = bbox.height * Math.SQRT2 / 2;
    var points = [
      { x: 0, y: -h },
      { x: -w2, y: 0 },
      { x: 0, y: h },
      { x: w2, y: 0 }
    ];
    var shapeSvg = parent.insert("polygon", ":first-child").attr(
      "points",
      points.map(function(p) {
        return p.x + "," + p.y;
      }).join(" ")
    );
    node2.intersect = function(p) {
      return intersectPolygon$1(node2, points, p);
    };
    return shapeSvg;
  }
  function render$1() {
    var fn = function(svg2, g) {
      preProcessGraph(g);
      var outputGroup = createOrSelectGroup(svg2, "output");
      var clustersGroup = createOrSelectGroup(outputGroup, "clusters");
      var edgePathsGroup = createOrSelectGroup(outputGroup, "edgePaths");
      var edgeLabels2 = createEdgeLabels(createOrSelectGroup(outputGroup, "edgeLabels"), g);
      var nodes2 = createNodes(createOrSelectGroup(outputGroup, "nodes"), g, shapes$2);
      layout$1(g);
      positionNodes$1(nodes2, g);
      positionEdgeLabels(edgeLabels2, g);
      createEdgePaths(edgePathsGroup, g, arrows);
      var clusters = createClusters(clustersGroup, g);
      positionClusters(clusters, g);
      postProcessGraph(g);
    };
    fn.createNodes = function(value2) {
      if (!arguments.length)
        return createNodes;
      setCreateNodes(value2);
      return fn;
    };
    fn.createClusters = function(value2) {
      if (!arguments.length)
        return createClusters;
      setCreateClusters(value2);
      return fn;
    };
    fn.createEdgeLabels = function(value2) {
      if (!arguments.length)
        return createEdgeLabels;
      setCreateEdgeLabels(value2);
      return fn;
    };
    fn.createEdgePaths = function(value2) {
      if (!arguments.length)
        return createEdgePaths;
      setCreateEdgePaths(value2);
      return fn;
    };
    fn.shapes = function(value2) {
      if (!arguments.length)
        return shapes$2;
      setShapes(value2);
      return fn;
    };
    fn.arrows = function(value2) {
      if (!arguments.length)
        return arrows;
      setArrows(value2);
      return fn;
    };
    return fn;
  }
  var NODE_DEFAULT_ATTRS = {
    paddingLeft: 10,
    paddingRight: 10,
    paddingTop: 10,
    paddingBottom: 10,
    rx: 0,
    ry: 0,
    shape: "rect"
  };
  var EDGE_DEFAULT_ATTRS = {
    arrowhead: "normal",
    curve: curveLinear
  };
  function preProcessGraph(g) {
    g.nodes().forEach(function(v) {
      var node2 = g.node(v);
      if (!has(node2, "label") && !g.children(v).length) {
        node2.label = v;
      }
      if (has(node2, "paddingX")) {
        defaults$1(node2, {
          paddingLeft: node2.paddingX,
          paddingRight: node2.paddingX
        });
      }
      if (has(node2, "paddingY")) {
        defaults$1(node2, {
          paddingTop: node2.paddingY,
          paddingBottom: node2.paddingY
        });
      }
      if (has(node2, "padding")) {
        defaults$1(node2, {
          paddingLeft: node2.padding,
          paddingRight: node2.padding,
          paddingTop: node2.padding,
          paddingBottom: node2.padding
        });
      }
      defaults$1(node2, NODE_DEFAULT_ATTRS);
      forEach(["paddingLeft", "paddingRight", "paddingTop", "paddingBottom"], function(k) {
        node2[k] = Number(node2[k]);
      });
      if (has(node2, "width")) {
        node2._prevWidth = node2.width;
      }
      if (has(node2, "height")) {
        node2._prevHeight = node2.height;
      }
    });
    g.edges().forEach(function(e) {
      var edge = g.edge(e);
      if (!has(edge, "label")) {
        edge.label = "";
      }
      defaults$1(edge, EDGE_DEFAULT_ATTRS);
    });
  }
  function postProcessGraph(g) {
    forEach(g.nodes(), function(v) {
      var node2 = g.node(v);
      if (has(node2, "_prevWidth")) {
        node2.width = node2._prevWidth;
      } else {
        delete node2.width;
      }
      if (has(node2, "_prevHeight")) {
        node2.height = node2._prevHeight;
      } else {
        delete node2.height;
      }
      delete node2._prevWidth;
      delete node2._prevHeight;
    });
  }
  function createOrSelectGroup(root2, name) {
    var selection2 = root2.select("g." + name);
    if (selection2.empty()) {
      selection2 = root2.append("g").attr("class", name);
    }
    return selection2;
  }
  function question$1(parent, bbox, node2) {
    const w2 = bbox.width;
    const h = bbox.height;
    const s = (w2 + h) * 0.9;
    const points = [
      { x: s / 2, y: 0 },
      { x: s, y: -s / 2 },
      { x: s / 2, y: -s },
      { x: 0, y: -s / 2 }
    ];
    const shapeSvg = insertPolygonShape$2(parent, s, s, points);
    node2.intersect = function(point2) {
      return intersectPolygon$1(node2, points, point2);
    };
    return shapeSvg;
  }
  function hexagon$1(parent, bbox, node2) {
    const f2 = 4;
    const h = bbox.height;
    const m = h / f2;
    const w2 = bbox.width + 2 * m;
    const points = [
      { x: m, y: 0 },
      { x: w2 - m, y: 0 },
      { x: w2, y: -h / 2 },
      { x: w2 - m, y: -h },
      { x: m, y: -h },
      { x: 0, y: -h / 2 }
    ];
    const shapeSvg = insertPolygonShape$2(parent, w2, h, points);
    node2.intersect = function(point2) {
      return intersectPolygon$1(node2, points, point2);
    };
    return shapeSvg;
  }
  function rect_left_inv_arrow$1(parent, bbox, node2) {
    const w2 = bbox.width;
    const h = bbox.height;
    const points = [
      { x: -h / 2, y: 0 },
      { x: w2, y: 0 },
      { x: w2, y: -h },
      { x: -h / 2, y: -h },
      { x: 0, y: -h / 2 }
    ];
    const shapeSvg = insertPolygonShape$2(parent, w2, h, points);
    node2.intersect = function(point2) {
      return intersectPolygon$1(node2, points, point2);
    };
    return shapeSvg;
  }
  function lean_right$1(parent, bbox, node2) {
    const w2 = bbox.width;
    const h = bbox.height;
    const points = [
      { x: -2 * h / 6, y: 0 },
      { x: w2 - h / 6, y: 0 },
      { x: w2 + 2 * h / 6, y: -h },
      { x: h / 6, y: -h }
    ];
    const shapeSvg = insertPolygonShape$2(parent, w2, h, points);
    node2.intersect = function(point2) {
      return intersectPolygon$1(node2, points, point2);
    };
    return shapeSvg;
  }
  function lean_left$1(parent, bbox, node2) {
    const w2 = bbox.width;
    const h = bbox.height;
    const points = [
      { x: 2 * h / 6, y: 0 },
      { x: w2 + h / 6, y: 0 },
      { x: w2 - 2 * h / 6, y: -h },
      { x: -h / 6, y: -h }
    ];
    const shapeSvg = insertPolygonShape$2(parent, w2, h, points);
    node2.intersect = function(point2) {
      return intersectPolygon$1(node2, points, point2);
    };
    return shapeSvg;
  }
  function trapezoid$1(parent, bbox, node2) {
    const w2 = bbox.width;
    const h = bbox.height;
    const points = [
      { x: -2 * h / 6, y: 0 },
      { x: w2 + 2 * h / 6, y: 0 },
      { x: w2 - h / 6, y: -h },
      { x: h / 6, y: -h }
    ];
    const shapeSvg = insertPolygonShape$2(parent, w2, h, points);
    node2.intersect = function(point2) {
      return intersectPolygon$1(node2, points, point2);
    };
    return shapeSvg;
  }
  function inv_trapezoid$1(parent, bbox, node2) {
    const w2 = bbox.width;
    const h = bbox.height;
    const points = [
      { x: h / 6, y: 0 },
      { x: w2 - h / 6, y: 0 },
      { x: w2 + 2 * h / 6, y: -h },
      { x: -2 * h / 6, y: -h }
    ];
    const shapeSvg = insertPolygonShape$2(parent, w2, h, points);
    node2.intersect = function(point2) {
      return intersectPolygon$1(node2, points, point2);
    };
    return shapeSvg;
  }
  function rect_right_inv_arrow$1(parent, bbox, node2) {
    const w2 = bbox.width;
    const h = bbox.height;
    const points = [
      { x: 0, y: 0 },
      { x: w2 + h / 2, y: 0 },
      { x: w2, y: -h / 2 },
      { x: w2 + h / 2, y: -h },
      { x: 0, y: -h }
    ];
    const shapeSvg = insertPolygonShape$2(parent, w2, h, points);
    node2.intersect = function(point2) {
      return intersectPolygon$1(node2, points, point2);
    };
    return shapeSvg;
  }
  function stadium$1(parent, bbox, node2) {
    const h = bbox.height;
    const w2 = bbox.width + h / 4;
    const shapeSvg = parent.insert("rect", ":first-child").attr("rx", h / 2).attr("ry", h / 2).attr("x", -w2 / 2).attr("y", -h / 2).attr("width", w2).attr("height", h);
    node2.intersect = function(point2) {
      return intersectRect$2(node2, point2);
    };
    return shapeSvg;
  }
  function subroutine$1(parent, bbox, node2) {
    const w2 = bbox.width;
    const h = bbox.height;
    const points = [
      { x: 0, y: 0 },
      { x: w2, y: 0 },
      { x: w2, y: -h },
      { x: 0, y: -h },
      { x: 0, y: 0 },
      { x: -8, y: 0 },
      { x: w2 + 8, y: 0 },
      { x: w2 + 8, y: -h },
      { x: -8, y: -h },
      { x: -8, y: 0 }
    ];
    const shapeSvg = insertPolygonShape$2(parent, w2, h, points);
    node2.intersect = function(point2) {
      return intersectPolygon$1(node2, points, point2);
    };
    return shapeSvg;
  }
  function cylinder$1(parent, bbox, node2) {
    const w2 = bbox.width;
    const rx = w2 / 2;
    const ry = rx / (2.5 + w2 / 50);
    const h = bbox.height + ry;
    const shape = "M 0," + ry + " a " + rx + "," + ry + " 0,0,0 " + w2 + " 0 a " + rx + "," + ry + " 0,0,0 " + -w2 + " 0 l 0," + h + " a " + rx + "," + ry + " 0,0,0 " + w2 + " 0 l 0," + -h;
    const shapeSvg = parent.attr("label-offset-y", ry).insert("path", ":first-child").attr("d", shape).attr("transform", "translate(" + -w2 / 2 + "," + -(h / 2 + ry) + ")");
    node2.intersect = function(point2) {
      const pos = intersectRect$2(node2, point2);
      const x2 = pos.x - node2.x;
      if (rx != 0 && (Math.abs(x2) < node2.width / 2 || Math.abs(x2) == node2.width / 2 && Math.abs(pos.y - node2.y) > node2.height / 2 - ry)) {
        let y2 = ry * ry * (1 - x2 * x2 / (rx * rx));
        if (y2 != 0) {
          y2 = Math.sqrt(y2);
        }
        y2 = ry - y2;
        if (point2.y - node2.y > 0) {
          y2 = -y2;
        }
        pos.y += y2;
      }
      return pos;
    };
    return shapeSvg;
  }
  function addToRender(render2) {
    render2.shapes().question = question$1;
    render2.shapes().hexagon = hexagon$1;
    render2.shapes().stadium = stadium$1;
    render2.shapes().subroutine = subroutine$1;
    render2.shapes().cylinder = cylinder$1;
    render2.shapes().rect_left_inv_arrow = rect_left_inv_arrow$1;
    render2.shapes().lean_right = lean_right$1;
    render2.shapes().lean_left = lean_left$1;
    render2.shapes().trapezoid = trapezoid$1;
    render2.shapes().inv_trapezoid = inv_trapezoid$1;
    render2.shapes().rect_right_inv_arrow = rect_right_inv_arrow$1;
  }
  function addToRenderV2(addShape) {
    addShape({ question: question$1 });
    addShape({ hexagon: hexagon$1 });
    addShape({ stadium: stadium$1 });
    addShape({ subroutine: subroutine$1 });
    addShape({ cylinder: cylinder$1 });
    addShape({ rect_left_inv_arrow: rect_left_inv_arrow$1 });
    addShape({ lean_right: lean_right$1 });
    addShape({ lean_left: lean_left$1 });
    addShape({ trapezoid: trapezoid$1 });
    addShape({ inv_trapezoid: inv_trapezoid$1 });
    addShape({ rect_right_inv_arrow: rect_right_inv_arrow$1 });
  }
  function insertPolygonShape$2(parent, w2, h, points) {
    return parent.insert("polygon", ":first-child").attr(
      "points",
      points.map(function(d) {
        return d.x + "," + d.y;
      }).join(" ")
    ).attr("transform", "translate(" + -w2 / 2 + "," + h / 2 + ")");
  }
  const flowChartShapes = {
    addToRender,
    addToRenderV2
  };
  const conf$8 = {};
  const setConf$8 = function(cnf) {
    const keys2 = Object.keys(cnf);
    for (const key of keys2) {
      conf$8[key] = cnf[key];
    }
  };
  const addVertices$2 = function(vert, g, svgId, root2, _doc, diagObj) {
    const svg2 = !root2 ? d3select(`[id="${svgId}"]`) : root2.select(`[id="${svgId}"]`);
    const doc = !_doc ? document : _doc;
    const keys2 = Object.keys(vert);
    keys2.forEach(function(id2) {
      const vertex = vert[id2];
      let classStr = "default";
      if (vertex.classes.length > 0) {
        classStr = vertex.classes.join(" ");
      }
      const styles2 = getStylesFromArray(vertex.styles);
      let vertexText = vertex.text !== void 0 ? vertex.text : vertex.id;
      let vertexNode;
      if (evaluate(getConfig$1().flowchart.htmlLabels)) {
        const node2 = {
          label: vertexText.replace(
            /fa[blrs]?:fa-[\w-]+/g,
            (s) => `<i class='${s.replace(":", " ")}'></i>`
          )
        };
        vertexNode = addHtmlLabel$1(svg2, node2).node();
        vertexNode.parentNode.removeChild(vertexNode);
      } else {
        const svgLabel = doc.createElementNS("http://www.w3.org/2000/svg", "text");
        svgLabel.setAttribute("style", styles2.labelStyle.replace("color:", "fill:"));
        const rows = vertexText.split(common$1.lineBreakRegex);
        for (const row of rows) {
          const tspan = doc.createElementNS("http://www.w3.org/2000/svg", "tspan");
          tspan.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
          tspan.setAttribute("dy", "1em");
          tspan.setAttribute("x", "1");
          tspan.textContent = row;
          svgLabel.appendChild(tspan);
        }
        vertexNode = svgLabel;
      }
      let radious = 0;
      let _shape = "";
      switch (vertex.type) {
        case "round":
          radious = 5;
          _shape = "rect";
          break;
        case "square":
          _shape = "rect";
          break;
        case "diamond":
          _shape = "question";
          break;
        case "hexagon":
          _shape = "hexagon";
          break;
        case "odd":
          _shape = "rect_left_inv_arrow";
          break;
        case "lean_right":
          _shape = "lean_right";
          break;
        case "lean_left":
          _shape = "lean_left";
          break;
        case "trapezoid":
          _shape = "trapezoid";
          break;
        case "inv_trapezoid":
          _shape = "inv_trapezoid";
          break;
        case "odd_right":
          _shape = "rect_left_inv_arrow";
          break;
        case "circle":
          _shape = "circle";
          break;
        case "ellipse":
          _shape = "ellipse";
          break;
        case "stadium":
          _shape = "stadium";
          break;
        case "subroutine":
          _shape = "subroutine";
          break;
        case "cylinder":
          _shape = "cylinder";
          break;
        case "group":
          _shape = "rect";
          break;
        default:
          _shape = "rect";
      }
      log$1.warn("Adding node", vertex.id, vertex.domId);
      g.setNode(diagObj.db.lookUpDomId(vertex.id), {
        labelType: "svg",
        labelStyle: styles2.labelStyle,
        shape: _shape,
        label: vertexNode,
        rx: radious,
        ry: radious,
        class: classStr,
        style: styles2.style,
        id: diagObj.db.lookUpDomId(vertex.id)
      });
    });
  };
  const addEdges$2 = function(edges2, g, diagObj) {
    let cnt2 = 0;
    let defaultStyle2;
    let defaultLabelStyle;
    if (edges2.defaultStyle !== void 0) {
      const defaultStyles = getStylesFromArray(edges2.defaultStyle);
      defaultStyle2 = defaultStyles.style;
      defaultLabelStyle = defaultStyles.labelStyle;
    }
    edges2.forEach(function(edge) {
      cnt2++;
      const linkId = "L-" + edge.start + "-" + edge.end;
      const linkNameStart = "LS-" + edge.start;
      const linkNameEnd = "LE-" + edge.end;
      const edgeData = {};
      if (edge.type === "arrow_open") {
        edgeData.arrowhead = "none";
      } else {
        edgeData.arrowhead = "normal";
      }
      let style = "";
      let labelStyle = "";
      if (edge.style !== void 0) {
        const styles2 = getStylesFromArray(edge.style);
        style = styles2.style;
        labelStyle = styles2.labelStyle;
      } else {
        switch (edge.stroke) {
          case "normal":
            style = "fill:none";
            if (defaultStyle2 !== void 0) {
              style = defaultStyle2;
            }
            if (defaultLabelStyle !== void 0) {
              labelStyle = defaultLabelStyle;
            }
            break;
          case "dotted":
            style = "fill:none;stroke-width:2px;stroke-dasharray:3;";
            break;
          case "thick":
            style = " stroke-width: 3.5px;fill:none";
            break;
        }
      }
      edgeData.style = style;
      edgeData.labelStyle = labelStyle;
      if (edge.interpolate !== void 0) {
        edgeData.curve = interpolateToCurve(edge.interpolate, curveLinear);
      } else if (edges2.defaultInterpolate !== void 0) {
        edgeData.curve = interpolateToCurve(edges2.defaultInterpolate, curveLinear);
      } else {
        edgeData.curve = interpolateToCurve(conf$8.curve, curveLinear);
      }
      if (edge.text === void 0) {
        if (edge.style !== void 0) {
          edgeData.arrowheadStyle = "fill: #333";
        }
      } else {
        edgeData.arrowheadStyle = "fill: #333";
        edgeData.labelpos = "c";
        if (evaluate(getConfig$1().flowchart.htmlLabels)) {
          edgeData.labelType = "html";
          edgeData.label = `<span id="L-${linkId}" class="edgeLabel L-${linkNameStart}' L-${linkNameEnd}" style="${edgeData.labelStyle}">${edge.text.replace(
            /fa[blrs]?:fa-[\w-]+/g,
            (s) => `<i class='${s.replace(":", " ")}'></i>`
          )}</span>`;
        } else {
          edgeData.labelType = "text";
          edgeData.label = edge.text.replace(common$1.lineBreakRegex, "\n");
          if (edge.style === void 0) {
            edgeData.style = edgeData.style || "stroke: #333; stroke-width: 1.5px;fill:none";
          }
          edgeData.labelStyle = edgeData.labelStyle.replace("color:", "fill:");
        }
      }
      edgeData.id = linkId;
      edgeData.class = linkNameStart + " " + linkNameEnd;
      edgeData.minlen = edge.length || 1;
      g.setEdge(diagObj.db.lookUpDomId(edge.start), diagObj.db.lookUpDomId(edge.end), edgeData, cnt2);
    });
  };
  const getClasses$7 = function(text2, diagObj) {
    log$1.info("Extracting classes");
    return diagObj.db.getClasses();
  };
  const draw$k = function(text2, id2, _version, diagObj) {
    log$1.info("Drawing flowchart");
    const { securityLevel, flowchart: conf2 } = getConfig$1();
    let sandboxElement;
    if (securityLevel === "sandbox") {
      sandboxElement = d3select("#i" + id2);
    }
    const root2 = securityLevel === "sandbox" ? d3select(sandboxElement.nodes()[0].contentDocument.body) : d3select("body");
    const doc = securityLevel === "sandbox" ? sandboxElement.nodes()[0].contentDocument : document;
    let dir2 = diagObj.db.getDirection();
    if (dir2 === void 0) {
      dir2 = "TD";
    }
    const nodeSpacing = conf2.nodeSpacing || 50;
    const rankSpacing = conf2.rankSpacing || 50;
    const g = new Graph({
      multigraph: true,
      compound: true
    }).setGraph({
      rankdir: dir2,
      nodesep: nodeSpacing,
      ranksep: rankSpacing,
      marginx: 8,
      marginy: 8
    }).setDefaultEdgeLabel(function() {
      return {};
    });
    let subG;
    const subGraphs2 = diagObj.db.getSubGraphs();
    for (let i3 = subGraphs2.length - 1; i3 >= 0; i3--) {
      subG = subGraphs2[i3];
      diagObj.db.addVertex(subG.id, subG.title, "group", void 0, subG.classes);
    }
    const vert = diagObj.db.getVertices();
    log$1.warn("Get vertices", vert);
    const edges2 = diagObj.db.getEdges();
    let i2 = 0;
    for (i2 = subGraphs2.length - 1; i2 >= 0; i2--) {
      subG = subGraphs2[i2];
      selectAll("cluster").append("text");
      for (let j = 0; j < subG.nodes.length; j++) {
        log$1.warn(
          "Setting subgraph",
          subG.nodes[j],
          diagObj.db.lookUpDomId(subG.nodes[j]),
          diagObj.db.lookUpDomId(subG.id)
        );
        g.setParent(diagObj.db.lookUpDomId(subG.nodes[j]), diagObj.db.lookUpDomId(subG.id));
      }
    }
    addVertices$2(vert, g, id2, root2, doc, diagObj);
    addEdges$2(edges2, g, diagObj);
    const render2 = new render$1();
    flowChartShapes.addToRender(render2);
    render2.arrows().none = function normal2(parent, id3, edge, type2) {
      const marker = parent.append("marker").attr("id", id3).attr("viewBox", "0 0 10 10").attr("refX", 9).attr("refY", 5).attr("markerUnits", "strokeWidth").attr("markerWidth", 8).attr("markerHeight", 6).attr("orient", "auto");
      const path2 = marker.append("path").attr("d", "M 0 0 L 0 0 L 0 0 z");
      applyStyle$2(path2, edge[type2 + "Style"]);
    };
    render2.arrows().normal = function normal2(parent, id3) {
      const marker = parent.append("marker").attr("id", id3).attr("viewBox", "0 0 10 10").attr("refX", 9).attr("refY", 5).attr("markerUnits", "strokeWidth").attr("markerWidth", 8).attr("markerHeight", 6).attr("orient", "auto");
      marker.append("path").attr("d", "M 0 0 L 10 5 L 0 10 z").attr("class", "arrowheadPath").style("stroke-width", 1).style("stroke-dasharray", "1,0");
    };
    const svg2 = root2.select(`[id="${id2}"]`);
    const element2 = root2.select("#" + id2 + " g");
    render2(element2, g);
    element2.selectAll("g.node").attr("title", function() {
      return diagObj.db.getTooltip(this.id);
    });
    diagObj.db.indexNodes("subGraph" + i2);
    for (i2 = 0; i2 < subGraphs2.length; i2++) {
      subG = subGraphs2[i2];
      if (subG.title !== "undefined") {
        const clusterRects = doc.querySelectorAll(
          "#" + id2 + ' [id="' + diagObj.db.lookUpDomId(subG.id) + '"] rect'
        );
        const clusterEl = doc.querySelectorAll(
          "#" + id2 + ' [id="' + diagObj.db.lookUpDomId(subG.id) + '"]'
        );
        const xPos = clusterRects[0].x.baseVal.value;
        const yPos = clusterRects[0].y.baseVal.value;
        const _width = clusterRects[0].width.baseVal.value;
        const cluster = d3select(clusterEl[0]);
        const te = cluster.select(".label");
        te.attr("transform", `translate(${xPos + _width / 2}, ${yPos + 14})`);
        te.attr("id", id2 + "Text");
        for (let j = 0; j < subG.classes.length; j++) {
          clusterEl[0].classList.add(subG.classes[j]);
        }
      }
    }
    if (!conf2.htmlLabels) {
      const labels = doc.querySelectorAll('[id="' + id2 + '"] .edgeLabel .label');
      for (const label of labels) {
        const dim = label.getBBox();
        const rect2 = doc.createElementNS("http://www.w3.org/2000/svg", "rect");
        rect2.setAttribute("rx", 0);
        rect2.setAttribute("ry", 0);
        rect2.setAttribute("width", dim.width);
        rect2.setAttribute("height", dim.height);
        label.insertBefore(rect2, label.firstChild);
      }
    }
    setupGraphViewbox$1(g, svg2, conf2.diagramPadding, conf2.useMaxWidth);
    const keys2 = Object.keys(vert);
    keys2.forEach(function(key) {
      const vertex = vert[key];
      if (vertex.link) {
        const node2 = root2.select("#" + id2 + ' [id="' + diagObj.db.lookUpDomId(key) + '"]');
        if (node2) {
          const link2 = doc.createElementNS("http://www.w3.org/2000/svg", "a");
          link2.setAttributeNS("http://www.w3.org/2000/svg", "class", vertex.classes.join(" "));
          link2.setAttributeNS("http://www.w3.org/2000/svg", "href", vertex.link);
          link2.setAttributeNS("http://www.w3.org/2000/svg", "rel", "noopener");
          if (securityLevel === "sandbox") {
            link2.setAttributeNS("http://www.w3.org/2000/svg", "target", "_top");
          } else if (vertex.linkTarget) {
            link2.setAttributeNS("http://www.w3.org/2000/svg", "target", vertex.linkTarget);
          }
          const linkNode = node2.insert(function() {
            return link2;
          }, ":first-child");
          const shape = node2.select(".label-container");
          if (shape) {
            linkNode.append(function() {
              return shape.node();
            });
          }
          const label = node2.select(".label");
          if (label) {
            linkNode.append(function() {
              return label.node();
            });
          }
        }
      }
    });
  };
  const flowRenderer = {
    setConf: setConf$8,
    addVertices: addVertices$2,
    addEdges: addEdges$2,
    getClasses: getClasses$7,
    draw: draw$k
  };
  function write(g) {
    var json2 = {
      options: {
        directed: g.isDirected(),
        multigraph: g.isMultigraph(),
        compound: g.isCompound()
      },
      nodes: writeNodes(g),
      edges: writeEdges(g)
    };
    if (!isUndefined(g.graph())) {
      json2.value = clone$1(g.graph());
    }
    return json2;
  }
  function writeNodes(g) {
    return map(g.nodes(), function(v) {
      var nodeValue = g.node(v);
      var parent = g.parent(v);
      var node2 = { v };
      if (!isUndefined(nodeValue)) {
        node2.value = nodeValue;
      }
      if (!isUndefined(parent)) {
        node2.parent = parent;
      }
      return node2;
    });
  }
  function writeEdges(g) {
    return map(g.edges(), function(e) {
      var edgeValue = g.edge(e);
      var edge = { v: e.v, w: e.w };
      if (!isUndefined(e.name)) {
        edge.name = e.name;
      }
      if (!isUndefined(edgeValue)) {
        edge.value = edgeValue;
      }
      return edge;
    });
  }
  const insertMarkers$3 = (elem, markerArray, type2, id2) => {
    markerArray.forEach((markerName) => {
      markers$1[markerName](elem, type2, id2);
    });
  };
  const extension$1 = (elem, type2, id2) => {
    log$1.trace("Making markers for ", id2);
    elem.append("defs").append("marker").attr("id", id2 + "_" + type2 + "-extensionStart").attr("class", "marker extension " + type2).attr("refX", 18).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("path").attr("d", "M 1,7 L18,13 V 1 Z");
    elem.append("defs").append("marker").attr("id", id2 + "_" + type2 + "-extensionEnd").attr("class", "marker extension " + type2).attr("refX", 1).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 1,1 V 13 L18,7 Z");
  };
  const composition = (elem, type2, id2) => {
    elem.append("defs").append("marker").attr("id", id2 + "_" + type2 + "-compositionStart").attr("class", "marker composition " + type2).attr("refX", 18).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L1,7 L9,1 Z");
    elem.append("defs").append("marker").attr("id", id2 + "_" + type2 + "-compositionEnd").attr("class", "marker composition " + type2).attr("refX", 1).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L1,7 L9,1 Z");
  };
  const aggregation = (elem, type2, id2) => {
    elem.append("defs").append("marker").attr("id", id2 + "_" + type2 + "-aggregationStart").attr("class", "marker aggregation " + type2).attr("refX", 18).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L1,7 L9,1 Z");
    elem.append("defs").append("marker").attr("id", id2 + "_" + type2 + "-aggregationEnd").attr("class", "marker aggregation " + type2).attr("refX", 1).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L1,7 L9,1 Z");
  };
  const dependency = (elem, type2, id2) => {
    elem.append("defs").append("marker").attr("id", id2 + "_" + type2 + "-dependencyStart").attr("class", "marker dependency " + type2).attr("refX", 6).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("path").attr("d", "M 5,7 L9,13 L1,7 L9,1 Z");
    elem.append("defs").append("marker").attr("id", id2 + "_" + type2 + "-dependencyEnd").attr("class", "marker dependency " + type2).attr("refX", 13).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 28).attr("orient", "auto").append("path").attr("d", "M 18,7 L9,13 L14,7 L9,1 Z");
  };
  const lollipop = (elem, type2, id2) => {
    elem.append("defs").append("marker").attr("id", id2 + "_" + type2 + "-lollipopStart").attr("class", "marker lollipop " + type2).attr("refX", 13).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("circle").attr("stroke", "black").attr("fill", "transparent").attr("cx", 7).attr("cy", 7).attr("r", 6);
    elem.append("defs").append("marker").attr("id", id2 + "_" + type2 + "-lollipopEnd").attr("class", "marker lollipop " + type2).attr("refX", 1).attr("refY", 7).attr("markerWidth", 190).attr("markerHeight", 240).attr("orient", "auto").append("circle").attr("stroke", "black").attr("fill", "transparent").attr("cx", 7).attr("cy", 7).attr("r", 6);
  };
  const point$2 = (elem, type2, id2) => {
    elem.append("marker").attr("id", id2 + "_" + type2 + "-pointEnd").attr("class", "marker " + type2).attr("viewBox", "0 0 10 10").attr("refX", 6).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 12).attr("markerHeight", 12).attr("orient", "auto").append("path").attr("d", "M 0 0 L 10 5 L 0 10 z").attr("class", "arrowMarkerPath").style("stroke-width", 1).style("stroke-dasharray", "1,0");
    elem.append("marker").attr("id", id2 + "_" + type2 + "-pointStart").attr("class", "marker " + type2).attr("viewBox", "0 0 10 10").attr("refX", 4.5).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 12).attr("markerHeight", 12).attr("orient", "auto").append("path").attr("d", "M 0 5 L 10 10 L 10 0 z").attr("class", "arrowMarkerPath").style("stroke-width", 1).style("stroke-dasharray", "1,0");
  };
  const circle$1 = (elem, type2, id2) => {
    elem.append("marker").attr("id", id2 + "_" + type2 + "-circleEnd").attr("class", "marker " + type2).attr("viewBox", "0 0 10 10").attr("refX", 11).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 11).attr("markerHeight", 11).attr("orient", "auto").append("circle").attr("cx", "5").attr("cy", "5").attr("r", "5").attr("class", "arrowMarkerPath").style("stroke-width", 1).style("stroke-dasharray", "1,0");
    elem.append("marker").attr("id", id2 + "_" + type2 + "-circleStart").attr("class", "marker " + type2).attr("viewBox", "0 0 10 10").attr("refX", -1).attr("refY", 5).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 11).attr("markerHeight", 11).attr("orient", "auto").append("circle").attr("cx", "5").attr("cy", "5").attr("r", "5").attr("class", "arrowMarkerPath").style("stroke-width", 1).style("stroke-dasharray", "1,0");
  };
  const cross = (elem, type2, id2) => {
    elem.append("marker").attr("id", id2 + "_" + type2 + "-crossEnd").attr("class", "marker cross " + type2).attr("viewBox", "0 0 11 11").attr("refX", 12).attr("refY", 5.2).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 11).attr("markerHeight", 11).attr("orient", "auto").append("path").attr("d", "M 1,1 l 9,9 M 10,1 l -9,9").attr("class", "arrowMarkerPath").style("stroke-width", 2).style("stroke-dasharray", "1,0");
    elem.append("marker").attr("id", id2 + "_" + type2 + "-crossStart").attr("class", "marker cross " + type2).attr("viewBox", "0 0 11 11").attr("refX", -1).attr("refY", 5.2).attr("markerUnits", "userSpaceOnUse").attr("markerWidth", 11).attr("markerHeight", 11).attr("orient", "auto").append("path").attr("d", "M 1,1 l 9,9 M 10,1 l -9,9").attr("class", "arrowMarkerPath").style("stroke-width", 2).style("stroke-dasharray", "1,0");
  };
  const barb = (elem, type2, id2) => {
    elem.append("defs").append("marker").attr("id", id2 + "_" + type2 + "-barbEnd").attr("refX", 19).attr("refY", 7).attr("markerWidth", 20).attr("markerHeight", 14).attr("markerUnits", "strokeWidth").attr("orient", "auto").append("path").attr("d", "M 19,7 L9,13 L14,7 L9,1 Z");
  };
  const markers$1 = {
    extension: extension$1,
    composition,
    aggregation,
    dependency,
    lollipop,
    point: point$2,
    circle: circle$1,
    cross,
    barb
  };
  const insertMarkers$4 = insertMarkers$3;
  function applyStyle$1(dom, styleFn) {
    if (styleFn) {
      dom.attr("style", styleFn);
    }
  }
  function addHtmlLabel(node2) {
    const fo = d3select(document.createElementNS("http://www.w3.org/2000/svg", "foreignObject"));
    const div = fo.append("xhtml:div");
    const label = node2.label;
    const labelClass = node2.isNode ? "nodeLabel" : "edgeLabel";
    div.html(
      '<span class="' + labelClass + '" ' + (node2.labelStyle ? 'style="' + node2.labelStyle + '"' : "") + ">" + label + "</span>"
    );
    applyStyle$1(div, node2.labelStyle);
    div.style("display", "inline-block");
    div.style("white-space", "nowrap");
    div.attr("xmlns", "http://www.w3.org/1999/xhtml");
    return fo.node();
  }
  const createLabel = (_vertexText, style, isTitle, isNode) => {
    let vertexText = _vertexText || "";
    if (typeof vertexText === "object") {
      vertexText = vertexText[0];
    }
    if (evaluate(getConfig$1().flowchart.htmlLabels)) {
      vertexText = vertexText.replace(/\\n|\n/g, "<br />");
      log$1.debug("vertexText" + vertexText);
      const node2 = {
        isNode,
        label: decodeEntities(vertexText).replace(
          /fa[blrs]?:fa-[\w-]+/g,
          (s) => `<i class='${s.replace(":", " ")}'></i>`
        ),
        labelStyle: style.replace("fill:", "color:")
      };
      let vertexNode = addHtmlLabel(node2);
      return vertexNode;
    } else {
      const svgLabel = document.createElementNS("http://www.w3.org/2000/svg", "text");
      svgLabel.setAttribute("style", style.replace("color:", "fill:"));
      let rows = [];
      if (typeof vertexText === "string") {
        rows = vertexText.split(/\\n|\n|<br\s*\/?>/gi);
      } else if (Array.isArray(vertexText)) {
        rows = vertexText;
      } else {
        rows = [];
      }
      for (const row of rows) {
        const tspan = document.createElementNS("http://www.w3.org/2000/svg", "tspan");
        tspan.setAttributeNS("http://www.w3.org/XML/1998/namespace", "xml:space", "preserve");
        tspan.setAttribute("dy", "1em");
        tspan.setAttribute("x", "0");
        if (isTitle) {
          tspan.setAttribute("class", "title-row");
        } else {
          tspan.setAttribute("class", "row");
        }
        tspan.textContent = row.trim();
        svgLabel.appendChild(tspan);
      }
      return svgLabel;
    }
  };
  const createLabel$1 = createLabel;
  const emptyOptions = {};
  function toString(value2, options2) {
    const settings = options2 || emptyOptions;
    const includeImageAlt = typeof settings.includeImageAlt === "boolean" ? settings.includeImageAlt : true;
    const includeHtml = typeof settings.includeHtml === "boolean" ? settings.includeHtml : true;
    return one(value2, includeImageAlt, includeHtml);
  }
  function one(value2, includeImageAlt, includeHtml) {
    if (node(value2)) {
      if ("value" in value2) {
        return value2.type === "html" && !includeHtml ? "" : value2.value;
      }
      if (includeImageAlt && "alt" in value2 && value2.alt) {
        return value2.alt;
      }
      if ("children" in value2) {
        return all(value2.children, includeImageAlt, includeHtml);
      }
    }
    if (Array.isArray(value2)) {
      return all(value2, includeImageAlt, includeHtml);
    }
    return "";
  }
  function all(values2, includeImageAlt, includeHtml) {
    const result = [];
    let index2 = -1;
    while (++index2 < values2.length) {
      result[index2] = one(values2[index2], includeImageAlt, includeHtml);
    }
    return result.join("");
  }
  function node(value2) {
    return Boolean(value2 && typeof value2 === "object");
  }
  function splice(list2, start2, remove2, items) {
    const end2 = list2.length;
    let chunkStart = 0;
    let parameters;
    if (start2 < 0) {
      start2 = -start2 > end2 ? 0 : end2 + start2;
    } else {
      start2 = start2 > end2 ? end2 : start2;
    }
    remove2 = remove2 > 0 ? remove2 : 0;
    if (items.length < 1e4) {
      parameters = Array.from(items);
      parameters.unshift(start2, remove2);
      list2.splice(...parameters);
    } else {
      if (remove2)
        list2.splice(start2, remove2);
      while (chunkStart < items.length) {
        parameters = items.slice(chunkStart, chunkStart + 1e4);
        parameters.unshift(start2, 0);
        list2.splice(...parameters);
        chunkStart += 1e4;
        start2 += 1e4;
      }
    }
  }
  function push(list2, items) {
    if (list2.length > 0) {
      splice(list2, list2.length, 0, items);
      return list2;
    }
    return items;
  }
  const hasOwnProperty = {}.hasOwnProperty;
  function combineExtensions(extensions) {
    const all2 = {};
    let index2 = -1;
    while (++index2 < extensions.length) {
      syntaxExtension(all2, extensions[index2]);
    }
    return all2;
  }
  function syntaxExtension(all2, extension2) {
    let hook;
    for (hook in extension2) {
      const maybe = hasOwnProperty.call(all2, hook) ? all2[hook] : void 0;
      const left2 = maybe || (all2[hook] = {});
      const right2 = extension2[hook];
      let code;
      if (right2) {
        for (code in right2) {
          if (!hasOwnProperty.call(left2, code))
            left2[code] = [];
          const value2 = right2[code];
          constructs(
            // @ts-expect-error Looks like a list.
            left2[code],
            Array.isArray(value2) ? value2 : value2 ? [value2] : []
          );
        }
      }
    }
  }
  function constructs(existing, list2) {
    let index2 = -1;
    const before = [];
    while (++index2 < list2.length) {
      (list2[index2].add === "after" ? existing : before).push(list2[index2]);
    }
    splice(existing, 0, 0, before);
  }
  const unicodePunctuationRegex = /[!-\/:-@\[-`\{-~\xA1\xA7\xAB\xB6\xB7\xBB\xBF\u037E\u0387\u055A-\u055F\u0589\u058A\u05BE\u05C0\u05C3\u05C6\u05F3\u05F4\u0609\u060A\u060C\u060D\u061B\u061D-\u061F\u066A-\u066D\u06D4\u0700-\u070D\u07F7-\u07F9\u0830-\u083E\u085E\u0964\u0965\u0970\u09FD\u0A76\u0AF0\u0C77\u0C84\u0DF4\u0E4F\u0E5A\u0E5B\u0F04-\u0F12\u0F14\u0F3A-\u0F3D\u0F85\u0FD0-\u0FD4\u0FD9\u0FDA\u104A-\u104F\u10FB\u1360-\u1368\u1400\u166E\u169B\u169C\u16EB-\u16ED\u1735\u1736\u17D4-\u17D6\u17D8-\u17DA\u1800-\u180A\u1944\u1945\u1A1E\u1A1F\u1AA0-\u1AA6\u1AA8-\u1AAD\u1B5A-\u1B60\u1B7D\u1B7E\u1BFC-\u1BFF\u1C3B-\u1C3F\u1C7E\u1C7F\u1CC0-\u1CC7\u1CD3\u2010-\u2027\u2030-\u2043\u2045-\u2051\u2053-\u205E\u207D\u207E\u208D\u208E\u2308-\u230B\u2329\u232A\u2768-\u2775\u27C5\u27C6\u27E6-\u27EF\u2983-\u2998\u29D8-\u29DB\u29FC\u29FD\u2CF9-\u2CFC\u2CFE\u2CFF\u2D70\u2E00-\u2E2E\u2E30-\u2E4F\u2E52-\u2E5D\u3001-\u3003\u3008-\u3011\u3014-\u301F\u3030\u303D\u30A0\u30FB\uA4FE\uA4FF\uA60D-\uA60F\uA673\uA67E\uA6F2-\uA6F7\uA874-\uA877\uA8CE\uA8CF\uA8F8-\uA8FA\uA8FC\uA92E\uA92F\uA95F\uA9C1-\uA9CD\uA9DE\uA9DF\uAA5C-\uAA5F\uAADE\uAADF\uAAF0\uAAF1\uABEB\uFD3E\uFD3F\uFE10-\uFE19\uFE30-\uFE52\uFE54-\uFE61\uFE63\uFE68\uFE6A\uFE6B\uFF01-\uFF03\uFF05-\uFF0A\uFF0C-\uFF0F\uFF1A\uFF1B\uFF1F\uFF20\uFF3B-\uFF3D\uFF3F\uFF5B\uFF5D\uFF5F-\uFF65]/;
  const asciiAlpha = regexCheck(/[A-Za-z]/);
  const asciiAlphanumeric = regexCheck(/[\dA-Za-z]/);
  const asciiAtext = regexCheck(/[#-'*+\--9=?A-Z^-~]/);
  function asciiControl(code) {
    return (
      // Special whitespace codes (which have negative values), C0 and Control
      // character DEL
      code !== null && (code < 32 || code === 127)
    );
  }
  const asciiDigit = regexCheck(/\d/);
  const asciiHexDigit = regexCheck(/[\dA-Fa-f]/);
  const asciiPunctuation = regexCheck(/[!-/:-@[-`{-~]/);
  function markdownLineEnding(code) {
    return code !== null && code < -2;
  }
  function markdownLineEndingOrSpace(code) {
    return code !== null && (code < 0 || code === 32);
  }
  function markdownSpace(code) {
    return code === -2 || code === -1 || code === 32;
  }
  const unicodePunctuation = regexCheck(unicodePunctuationRegex);
  const unicodeWhitespace = regexCheck(/\s/);
  function regexCheck(regex) {
    return check;
    function check(code) {
      return code !== null && regex.test(String.fromCharCode(code));
    }
  }
  function factorySpace(effects, ok, type2, max2) {
    const limit = max2 ? max2 - 1 : Number.POSITIVE_INFINITY;
    let size2 = 0;
    return start2;
    function start2(code) {
      if (markdownSpace(code)) {
        effects.enter(type2);
        return prefix(code);
      }
      return ok(code);
    }
    function prefix(code) {
      if (markdownSpace(code) && size2++ < limit) {
        effects.consume(code);
        return prefix;
      }
      effects.exit(type2);
      return ok(code);
    }
  }
  const content$1 = {
    tokenize: initializeContent
  };
  function initializeContent(effects) {
    const contentStart = effects.attempt(
      this.parser.constructs.contentInitial,
      afterContentStartConstruct,
      paragraphInitial
    );
    let previous2;
    return contentStart;
    function afterContentStartConstruct(code) {
      if (code === null) {
        effects.consume(code);
        return;
      }
      effects.enter("lineEnding");
      effects.consume(code);
      effects.exit("lineEnding");
      return factorySpace(effects, contentStart, "linePrefix");
    }
    function paragraphInitial(code) {
      effects.enter("paragraph");
      return lineStart(code);
    }
    function lineStart(code) {
      const token2 = effects.enter("chunkText", {
        contentType: "text",
        previous: previous2
      });
      if (previous2) {
        previous2.next = token2;
      }
      previous2 = token2;
      return data(code);
    }
    function data(code) {
      if (code === null) {
        effects.exit("chunkText");
        effects.exit("paragraph");
        effects.consume(code);
        return;
      }
      if (markdownLineEnding(code)) {
        effects.consume(code);
        effects.exit("chunkText");
        return lineStart;
      }
      effects.consume(code);
      return data;
    }
  }
  const document$2 = {
    tokenize: initializeDocument
  };
  const containerConstruct = {
    tokenize: tokenizeContainer
  };
  function initializeDocument(effects) {
    const self2 = this;
    const stack = [];
    let continued = 0;
    let childFlow;
    let childToken;
    let lineStartOffset;
    return start2;
    function start2(code) {
      if (continued < stack.length) {
        const item = stack[continued];
        self2.containerState = item[1];
        return effects.attempt(
          item[0].continuation,
          documentContinue,
          checkNewContainers
        )(code);
      }
      return checkNewContainers(code);
    }
    function documentContinue(code) {
      continued++;
      if (self2.containerState._closeFlow) {
        self2.containerState._closeFlow = void 0;
        if (childFlow) {
          closeFlow();
        }
        const indexBeforeExits = self2.events.length;
        let indexBeforeFlow = indexBeforeExits;
        let point2;
        while (indexBeforeFlow--) {
          if (self2.events[indexBeforeFlow][0] === "exit" && self2.events[indexBeforeFlow][1].type === "chunkFlow") {
            point2 = self2.events[indexBeforeFlow][1].end;
            break;
          }
        }
        exitContainers(continued);
        let index2 = indexBeforeExits;
        while (index2 < self2.events.length) {
          self2.events[index2][1].end = Object.assign({}, point2);
          index2++;
        }
        splice(
          self2.events,
          indexBeforeFlow + 1,
          0,
          self2.events.slice(indexBeforeExits)
        );
        self2.events.length = index2;
        return checkNewContainers(code);
      }
      return start2(code);
    }
    function checkNewContainers(code) {
      if (continued === stack.length) {
        if (!childFlow) {
          return documentContinued(code);
        }
        if (childFlow.currentConstruct && childFlow.currentConstruct.concrete) {
          return flowStart(code);
        }
        self2.interrupt = Boolean(
          childFlow.currentConstruct && !childFlow._gfmTableDynamicInterruptHack
        );
      }
      self2.containerState = {};
      return effects.check(
        containerConstruct,
        thereIsANewContainer,
        thereIsNoNewContainer
      )(code);
    }
    function thereIsANewContainer(code) {
      if (childFlow)
        closeFlow();
      exitContainers(continued);
      return documentContinued(code);
    }
    function thereIsNoNewContainer(code) {
      self2.parser.lazy[self2.now().line] = continued !== stack.length;
      lineStartOffset = self2.now().offset;
      return flowStart(code);
    }
    function documentContinued(code) {
      self2.containerState = {};
      return effects.attempt(
        containerConstruct,
        containerContinue,
        flowStart
      )(code);
    }
    function containerContinue(code) {
      continued++;
      stack.push([self2.currentConstruct, self2.containerState]);
      return documentContinued(code);
    }
    function flowStart(code) {
      if (code === null) {
        if (childFlow)
          closeFlow();
        exitContainers(0);
        effects.consume(code);
        return;
      }
      childFlow = childFlow || self2.parser.flow(self2.now());
      effects.enter("chunkFlow", {
        contentType: "flow",
        previous: childToken,
        _tokenizer: childFlow
      });
      return flowContinue(code);
    }
    function flowContinue(code) {
      if (code === null) {
        writeToChild(effects.exit("chunkFlow"), true);
        exitContainers(0);
        effects.consume(code);
        return;
      }
      if (markdownLineEnding(code)) {
        effects.consume(code);
        writeToChild(effects.exit("chunkFlow"));
        continued = 0;
        self2.interrupt = void 0;
        return start2;
      }
      effects.consume(code);
      return flowContinue;
    }
    function writeToChild(token2, eof) {
      const stream = self2.sliceStream(token2);
      if (eof)
        stream.push(null);
      token2.previous = childToken;
      if (childToken)
        childToken.next = token2;
      childToken = token2;
      childFlow.defineSkip(token2.start);
      childFlow.write(stream);
      if (self2.parser.lazy[token2.start.line]) {
        let index2 = childFlow.events.length;
        while (index2--) {
          if (
            // The token starts before the line ending…
            childFlow.events[index2][1].start.offset < lineStartOffset && // …and either is not ended yet…
            (!childFlow.events[index2][1].end || // …or ends after it.
            childFlow.events[index2][1].end.offset > lineStartOffset)
          ) {
            return;
          }
        }
        const indexBeforeExits = self2.events.length;
        let indexBeforeFlow = indexBeforeExits;
        let seen;
        let point2;
        while (indexBeforeFlow--) {
          if (self2.events[indexBeforeFlow][0] === "exit" && self2.events[indexBeforeFlow][1].type === "chunkFlow") {
            if (seen) {
              point2 = self2.events[indexBeforeFlow][1].end;
              break;
            }
            seen = true;
          }
        }
        exitContainers(continued);
        index2 = indexBeforeExits;
        while (index2 < self2.events.length) {
          self2.events[index2][1].end = Object.assign({}, point2);
          index2++;
        }
        splice(
          self2.events,
          indexBeforeFlow + 1,
          0,
          self2.events.slice(indexBeforeExits)
        );
        self2.events.length = index2;
      }
    }
    function exitContainers(size2) {
      let index2 = stack.length;
      while (index2-- > size2) {
        const entry = stack[index2];
        self2.containerState = entry[1];
        entry[0].exit.call(self2, effects);
      }
      stack.length = size2;
    }
    function closeFlow() {
      childFlow.write([null]);
      childToken = void 0;
      childFlow = void 0;
      self2.containerState._closeFlow = void 0;
    }
  }
  function tokenizeContainer(effects, ok, nok) {
    return factorySpace(
      effects,
      effects.attempt(this.parser.constructs.document, ok, nok),
      "linePrefix",
      this.parser.constructs.disable.null.includes("codeIndented") ? void 0 : 4
    );
  }
  function classifyCharacter(code) {
    if (code === null || markdownLineEndingOrSpace(code) || unicodeWhitespace(code)) {
      return 1;
    }
    if (unicodePunctuation(code)) {
      return 2;
    }
  }
  function resolveAll(constructs2, events, context) {
    const called = [];
    let index2 = -1;
    while (++index2 < constructs2.length) {
      const resolve = constructs2[index2].resolveAll;
      if (resolve && !called.includes(resolve)) {
        events = resolve(events, context);
        called.push(resolve);
      }
    }
    return events;
  }
  const attention = {
    name: "attention",
    tokenize: tokenizeAttention,
    resolveAll: resolveAllAttention
  };
  function resolveAllAttention(events, context) {
    let index2 = -1;
    let open;
    let group;
    let text2;
    let openingSequence;
    let closingSequence;
    let use;
    let nextEvents;
    let offset;
    while (++index2 < events.length) {
      if (events[index2][0] === "enter" && events[index2][1].type === "attentionSequence" && events[index2][1]._close) {
        open = index2;
        while (open--) {
          if (events[open][0] === "exit" && events[open][1].type === "attentionSequence" && events[open][1]._open && // If the markers are the same:
          context.sliceSerialize(events[open][1]).charCodeAt(0) === context.sliceSerialize(events[index2][1]).charCodeAt(0)) {
            if ((events[open][1]._close || events[index2][1]._open) && (events[index2][1].end.offset - events[index2][1].start.offset) % 3 && !((events[open][1].end.offset - events[open][1].start.offset + events[index2][1].end.offset - events[index2][1].start.offset) % 3)) {
              continue;
            }
            use = events[open][1].end.offset - events[open][1].start.offset > 1 && events[index2][1].end.offset - events[index2][1].start.offset > 1 ? 2 : 1;
            const start2 = Object.assign({}, events[open][1].end);
            const end2 = Object.assign({}, events[index2][1].start);
            movePoint(start2, -use);
            movePoint(end2, use);
            openingSequence = {
              type: use > 1 ? "strongSequence" : "emphasisSequence",
              start: start2,
              end: Object.assign({}, events[open][1].end)
            };
            closingSequence = {
              type: use > 1 ? "strongSequence" : "emphasisSequence",
              start: Object.assign({}, events[index2][1].start),
              end: end2
            };
            text2 = {
              type: use > 1 ? "strongText" : "emphasisText",
              start: Object.assign({}, events[open][1].end),
              end: Object.assign({}, events[index2][1].start)
            };
            group = {
              type: use > 1 ? "strong" : "emphasis",
              start: Object.assign({}, openingSequence.start),
              end: Object.assign({}, closingSequence.end)
            };
            events[open][1].end = Object.assign({}, openingSequence.start);
            events[index2][1].start = Object.assign({}, closingSequence.end);
            nextEvents = [];
            if (events[open][1].end.offset - events[open][1].start.offset) {
              nextEvents = push(nextEvents, [
                ["enter", events[open][1], context],
                ["exit", events[open][1], context]
              ]);
            }
            nextEvents = push(nextEvents, [
              ["enter", group, context],
              ["enter", openingSequence, context],
              ["exit", openingSequence, context],
              ["enter", text2, context]
            ]);
            nextEvents = push(
              nextEvents,
              resolveAll(
                context.parser.constructs.insideSpan.null,
                events.slice(open + 1, index2),
                context
              )
            );
            nextEvents = push(nextEvents, [
              ["exit", text2, context],
              ["enter", closingSequence, context],
              ["exit", closingSequence, context],
              ["exit", group, context]
            ]);
            if (events[index2][1].end.offset - events[index2][1].start.offset) {
              offset = 2;
              nextEvents = push(nextEvents, [
                ["enter", events[index2][1], context],
                ["exit", events[index2][1], context]
              ]);
            } else {
              offset = 0;
            }
            splice(events, open - 1, index2 - open + 3, nextEvents);
            index2 = open + nextEvents.length - offset - 2;
            break;
          }
        }
      }
    }
    index2 = -1;
    while (++index2 < events.length) {
      if (events[index2][1].type === "attentionSequence") {
        events[index2][1].type = "data";
      }
    }
    return events;
  }
  function tokenizeAttention(effects, ok) {
    const attentionMarkers2 = this.parser.constructs.attentionMarkers.null;
    const previous2 = this.previous;
    const before = classifyCharacter(previous2);
    let marker;
    return start2;
    function start2(code) {
      marker = code;
      effects.enter("attentionSequence");
      return inside(code);
    }
    function inside(code) {
      if (code === marker) {
        effects.consume(code);
        return inside;
      }
      const token2 = effects.exit("attentionSequence");
      const after = classifyCharacter(code);
      const open = !after || after === 2 && before || attentionMarkers2.includes(code);
      const close = !before || before === 2 && after || attentionMarkers2.includes(previous2);
      token2._open = Boolean(marker === 42 ? open : open && (before || !close));
      token2._close = Boolean(marker === 42 ? close : close && (after || !open));
      return ok(code);
    }
  }
  function movePoint(point2, offset) {
    point2.column += offset;
    point2.offset += offset;
    point2._bufferIndex += offset;
  }
  const autolink = {
    name: "autolink",
    tokenize: tokenizeAutolink
  };
  function tokenizeAutolink(effects, ok, nok) {
    let size2 = 0;
    return start2;
    function start2(code) {
      effects.enter("autolink");
      effects.enter("autolinkMarker");
      effects.consume(code);
      effects.exit("autolinkMarker");
      effects.enter("autolinkProtocol");
      return open;
    }
    function open(code) {
      if (asciiAlpha(code)) {
        effects.consume(code);
        return schemeOrEmailAtext;
      }
      return emailAtext(code);
    }
    function schemeOrEmailAtext(code) {
      if (code === 43 || code === 45 || code === 46 || asciiAlphanumeric(code)) {
        size2 = 1;
        return schemeInsideOrEmailAtext(code);
      }
      return emailAtext(code);
    }
    function schemeInsideOrEmailAtext(code) {
      if (code === 58) {
        effects.consume(code);
        size2 = 0;
        return urlInside;
      }
      if ((code === 43 || code === 45 || code === 46 || asciiAlphanumeric(code)) && size2++ < 32) {
        effects.consume(code);
        return schemeInsideOrEmailAtext;
      }
      size2 = 0;
      return emailAtext(code);
    }
    function urlInside(code) {
      if (code === 62) {
        effects.exit("autolinkProtocol");
        effects.enter("autolinkMarker");
        effects.consume(code);
        effects.exit("autolinkMarker");
        effects.exit("autolink");
        return ok;
      }
      if (code === null || code === 32 || code === 60 || asciiControl(code)) {
        return nok(code);
      }
      effects.consume(code);
      return urlInside;
    }
    function emailAtext(code) {
      if (code === 64) {
        effects.consume(code);
        return emailAtSignOrDot;
      }
      if (asciiAtext(code)) {
        effects.consume(code);
        return emailAtext;
      }
      return nok(code);
    }
    function emailAtSignOrDot(code) {
      return asciiAlphanumeric(code) ? emailLabel(code) : nok(code);
    }
    function emailLabel(code) {
      if (code === 46) {
        effects.consume(code);
        size2 = 0;
        return emailAtSignOrDot;
      }
      if (code === 62) {
        effects.exit("autolinkProtocol").type = "autolinkEmail";
        effects.enter("autolinkMarker");
        effects.consume(code);
        effects.exit("autolinkMarker");
        effects.exit("autolink");
        return ok;
      }
      return emailValue(code);
    }
    function emailValue(code) {
      if ((code === 45 || asciiAlphanumeric(code)) && size2++ < 63) {
        const next2 = code === 45 ? emailValue : emailLabel;
        effects.consume(code);
        return next2;
      }
      return nok(code);
    }
  }
  const blankLine = {
    tokenize: tokenizeBlankLine,
    partial: true
  };
  function tokenizeBlankLine(effects, ok, nok) {
    return start2;
    function start2(code) {
      return markdownSpace(code) ? factorySpace(effects, after, "linePrefix")(code) : after(code);
    }
    function after(code) {
      return code === null || markdownLineEnding(code) ? ok(code) : nok(code);
    }
  }
  const blockQuote = {
    name: "blockQuote",
    tokenize: tokenizeBlockQuoteStart,
    continuation: {
      tokenize: tokenizeBlockQuoteContinuation
    },
    exit
  };
  function tokenizeBlockQuoteStart(effects, ok, nok) {
    const self2 = this;
    return start2;
    function start2(code) {
      if (code === 62) {
        const state2 = self2.containerState;
        if (!state2.open) {
          effects.enter("blockQuote", {
            _container: true
          });
          state2.open = true;
        }
        effects.enter("blockQuotePrefix");
        effects.enter("blockQuoteMarker");
        effects.consume(code);
        effects.exit("blockQuoteMarker");
        return after;
      }
      return nok(code);
    }
    function after(code) {
      if (markdownSpace(code)) {
        effects.enter("blockQuotePrefixWhitespace");
        effects.consume(code);
        effects.exit("blockQuotePrefixWhitespace");
        effects.exit("blockQuotePrefix");
        return ok;
      }
      effects.exit("blockQuotePrefix");
      return ok(code);
    }
  }
  function tokenizeBlockQuoteContinuation(effects, ok, nok) {
    const self2 = this;
    return contStart;
    function contStart(code) {
      if (markdownSpace(code)) {
        return factorySpace(
          effects,
          contBefore,
          "linePrefix",
          self2.parser.constructs.disable.null.includes("codeIndented") ? void 0 : 4
        )(code);
      }
      return contBefore(code);
    }
    function contBefore(code) {
      return effects.attempt(blockQuote, ok, nok)(code);
    }
  }
  function exit(effects) {
    effects.exit("blockQuote");
  }
  const characterEscape = {
    name: "characterEscape",
    tokenize: tokenizeCharacterEscape
  };
  function tokenizeCharacterEscape(effects, ok, nok) {
    return start2;
    function start2(code) {
      effects.enter("characterEscape");
      effects.enter("escapeMarker");
      effects.consume(code);
      effects.exit("escapeMarker");
      return inside;
    }
    function inside(code) {
      if (asciiPunctuation(code)) {
        effects.enter("characterEscapeValue");
        effects.consume(code);
        effects.exit("characterEscapeValue");
        effects.exit("characterEscape");
        return ok;
      }
      return nok(code);
    }
  }
  const element = document.createElement("i");
  function decodeNamedCharacterReference(value2) {
    const characterReference2 = "&" + value2 + ";";
    element.innerHTML = characterReference2;
    const char2 = element.textContent;
    if (char2.charCodeAt(char2.length - 1) === 59 && value2 !== "semi") {
      return false;
    }
    return char2 === characterReference2 ? false : char2;
  }
  const characterReference = {
    name: "characterReference",
    tokenize: tokenizeCharacterReference
  };
  function tokenizeCharacterReference(effects, ok, nok) {
    const self2 = this;
    let size2 = 0;
    let max2;
    let test;
    return start2;
    function start2(code) {
      effects.enter("characterReference");
      effects.enter("characterReferenceMarker");
      effects.consume(code);
      effects.exit("characterReferenceMarker");
      return open;
    }
    function open(code) {
      if (code === 35) {
        effects.enter("characterReferenceMarkerNumeric");
        effects.consume(code);
        effects.exit("characterReferenceMarkerNumeric");
        return numeric;
      }
      effects.enter("characterReferenceValue");
      max2 = 31;
      test = asciiAlphanumeric;
      return value2(code);
    }
    function numeric(code) {
      if (code === 88 || code === 120) {
        effects.enter("characterReferenceMarkerHexadecimal");
        effects.consume(code);
        effects.exit("characterReferenceMarkerHexadecimal");
        effects.enter("characterReferenceValue");
        max2 = 6;
        test = asciiHexDigit;
        return value2;
      }
      effects.enter("characterReferenceValue");
      max2 = 7;
      test = asciiDigit;
      return value2(code);
    }
    function value2(code) {
      if (code === 59 && size2) {
        const token2 = effects.exit("characterReferenceValue");
        if (test === asciiAlphanumeric && !decodeNamedCharacterReference(self2.sliceSerialize(token2))) {
          return nok(code);
        }
        effects.enter("characterReferenceMarker");
        effects.consume(code);
        effects.exit("characterReferenceMarker");
        effects.exit("characterReference");
        return ok;
      }
      if (test(code) && size2++ < max2) {
        effects.consume(code);
        return value2;
      }
      return nok(code);
    }
  }
  const nonLazyContinuation = {
    tokenize: tokenizeNonLazyContinuation,
    partial: true
  };
  const codeFenced = {
    name: "codeFenced",
    tokenize: tokenizeCodeFenced,
    concrete: true
  };
  function tokenizeCodeFenced(effects, ok, nok) {
    const self2 = this;
    const closeStart = {
      tokenize: tokenizeCloseStart,
      partial: true
    };
    let initialPrefix = 0;
    let sizeOpen = 0;
    let marker;
    return start2;
    function start2(code) {
      return beforeSequenceOpen(code);
    }
    function beforeSequenceOpen(code) {
      const tail = self2.events[self2.events.length - 1];
      initialPrefix = tail && tail[1].type === "linePrefix" ? tail[2].sliceSerialize(tail[1], true).length : 0;
      marker = code;
      effects.enter("codeFenced");
      effects.enter("codeFencedFence");
      effects.enter("codeFencedFenceSequence");
      return sequenceOpen(code);
    }
    function sequenceOpen(code) {
      if (code === marker) {
        sizeOpen++;
        effects.consume(code);
        return sequenceOpen;
      }
      if (sizeOpen < 3) {
        return nok(code);
      }
      effects.exit("codeFencedFenceSequence");
      return markdownSpace(code) ? factorySpace(effects, infoBefore, "whitespace")(code) : infoBefore(code);
    }
    function infoBefore(code) {
      if (code === null || markdownLineEnding(code)) {
        effects.exit("codeFencedFence");
        return self2.interrupt ? ok(code) : effects.check(nonLazyContinuation, atNonLazyBreak, after)(code);
      }
      effects.enter("codeFencedFenceInfo");
      effects.enter("chunkString", {
        contentType: "string"
      });
      return info2(code);
    }
    function info2(code) {
      if (code === null || markdownLineEnding(code)) {
        effects.exit("chunkString");
        effects.exit("codeFencedFenceInfo");
        return infoBefore(code);
      }
      if (markdownSpace(code)) {
        effects.exit("chunkString");
        effects.exit("codeFencedFenceInfo");
        return factorySpace(effects, metaBefore, "whitespace")(code);
      }
      if (code === 96 && code === marker) {
        return nok(code);
      }
      effects.consume(code);
      return info2;
    }
    function metaBefore(code) {
      if (code === null || markdownLineEnding(code)) {
        return infoBefore(code);
      }
      effects.enter("codeFencedFenceMeta");
      effects.enter("chunkString", {
        contentType: "string"
      });
      return meta(code);
    }
    function meta(code) {
      if (code === null || markdownLineEnding(code)) {
        effects.exit("chunkString");
        effects.exit("codeFencedFenceMeta");
        return infoBefore(code);
      }
      if (code === 96 && code === marker) {
        return nok(code);
      }
      effects.consume(code);
      return meta;
    }
    function atNonLazyBreak(code) {
      return effects.attempt(closeStart, after, contentBefore)(code);
    }
    function contentBefore(code) {
      effects.enter("lineEnding");
      effects.consume(code);
      effects.exit("lineEnding");
      return contentStart;
    }
    function contentStart(code) {
      return initialPrefix > 0 && markdownSpace(code) ? factorySpace(
        effects,
        beforeContentChunk,
        "linePrefix",
        initialPrefix + 1
      )(code) : beforeContentChunk(code);
    }
    function beforeContentChunk(code) {
      if (code === null || markdownLineEnding(code)) {
        return effects.check(nonLazyContinuation, atNonLazyBreak, after)(code);
      }
      effects.enter("codeFlowValue");
      return contentChunk(code);
    }
    function contentChunk(code) {
      if (code === null || markdownLineEnding(code)) {
        effects.exit("codeFlowValue");
        return beforeContentChunk(code);
      }
      effects.consume(code);
      return contentChunk;
    }
    function after(code) {
      effects.exit("codeFenced");
      return ok(code);
    }
    function tokenizeCloseStart(effects2, ok2, nok2) {
      let size2 = 0;
      return startBefore;
      function startBefore(code) {
        effects2.enter("lineEnding");
        effects2.consume(code);
        effects2.exit("lineEnding");
        return start3;
      }
      function start3(code) {
        effects2.enter("codeFencedFence");
        return markdownSpace(code) ? factorySpace(
          effects2,
          beforeSequenceClose,
          "linePrefix",
          self2.parser.constructs.disable.null.includes("codeIndented") ? void 0 : 4
        )(code) : beforeSequenceClose(code);
      }
      function beforeSequenceClose(code) {
        if (code === marker) {
          effects2.enter("codeFencedFenceSequence");
          return sequenceClose(code);
        }
        return nok2(code);
      }
      function sequenceClose(code) {
        if (code === marker) {
          size2++;
          effects2.consume(code);
          return sequenceClose;
        }
        if (size2 >= sizeOpen) {
          effects2.exit("codeFencedFenceSequence");
          return markdownSpace(code) ? factorySpace(effects2, sequenceCloseAfter, "whitespace")(code) : sequenceCloseAfter(code);
        }
        return nok2(code);
      }
      function sequenceCloseAfter(code) {
        if (code === null || markdownLineEnding(code)) {
          effects2.exit("codeFencedFence");
          return ok2(code);
        }
        return nok2(code);
      }
    }
  }
  function tokenizeNonLazyContinuation(effects, ok, nok) {
    const self2 = this;
    return start2;
    function start2(code) {
      if (code === null) {
        return nok(code);
      }
      effects.enter("lineEnding");
      effects.consume(code);
      effects.exit("lineEnding");
      return lineStart;
    }
    function lineStart(code) {
      return self2.parser.lazy[self2.now().line] ? nok(code) : ok(code);
    }
  }
  const codeIndented = {
    name: "codeIndented",
    tokenize: tokenizeCodeIndented
  };
  const furtherStart = {
    tokenize: tokenizeFurtherStart,
    partial: true
  };
  function tokenizeCodeIndented(effects, ok, nok) {
    const self2 = this;
    return start2;
    function start2(code) {
      effects.enter("codeIndented");
      return factorySpace(effects, afterPrefix, "linePrefix", 4 + 1)(code);
    }
    function afterPrefix(code) {
      const tail = self2.events[self2.events.length - 1];
      return tail && tail[1].type === "linePrefix" && tail[2].sliceSerialize(tail[1], true).length >= 4 ? atBreak(code) : nok(code);
    }
    function atBreak(code) {
      if (code === null) {
        return after(code);
      }
      if (markdownLineEnding(code)) {
        return effects.attempt(furtherStart, atBreak, after)(code);
      }
      effects.enter("codeFlowValue");
      return inside(code);
    }
    function inside(code) {
      if (code === null || markdownLineEnding(code)) {
        effects.exit("codeFlowValue");
        return atBreak(code);
      }
      effects.consume(code);
      return inside;
    }
    function after(code) {
      effects.exit("codeIndented");
      return ok(code);
    }
  }
  function tokenizeFurtherStart(effects, ok, nok) {
    const self2 = this;
    return furtherStart2;
    function furtherStart2(code) {
      if (self2.parser.lazy[self2.now().line]) {
        return nok(code);
      }
      if (markdownLineEnding(code)) {
        effects.enter("lineEnding");
        effects.consume(code);
        effects.exit("lineEnding");
        return furtherStart2;
      }
      return factorySpace(effects, afterPrefix, "linePrefix", 4 + 1)(code);
    }
    function afterPrefix(code) {
      const tail = self2.events[self2.events.length - 1];
      return tail && tail[1].type === "linePrefix" && tail[2].sliceSerialize(tail[1], true).length >= 4 ? ok(code) : markdownLineEnding(code) ? furtherStart2(code) : nok(code);
    }
  }
  const codeText = {
    name: "codeText",
    tokenize: tokenizeCodeText,
    resolve: resolveCodeText,
    previous
  };
  function resolveCodeText(events) {
    let tailExitIndex = events.length - 4;
    let headEnterIndex = 3;
    let index2;
    let enter2;
    if ((events[headEnterIndex][1].type === "lineEnding" || events[headEnterIndex][1].type === "space") && (events[tailExitIndex][1].type === "lineEnding" || events[tailExitIndex][1].type === "space")) {
      index2 = headEnterIndex;
      while (++index2 < tailExitIndex) {
        if (events[index2][1].type === "codeTextData") {
          events[headEnterIndex][1].type = "codeTextPadding";
          events[tailExitIndex][1].type = "codeTextPadding";
          headEnterIndex += 2;
          tailExitIndex -= 2;
          break;
        }
      }
    }
    index2 = headEnterIndex - 1;
    tailExitIndex++;
    while (++index2 <= tailExitIndex) {
      if (enter2 === void 0) {
        if (index2 !== tailExitIndex && events[index2][1].type !== "lineEnding") {
          enter2 = index2;
        }
      } else if (index2 === tailExitIndex || events[index2][1].type === "lineEnding") {
        events[enter2][1].type = "codeTextData";
        if (index2 !== enter2 + 2) {
          events[enter2][1].end = events[index2 - 1][1].end;
          events.splice(enter2 + 2, index2 - enter2 - 2);
          tailExitIndex -= index2 - enter2 - 2;
          index2 = enter2 + 2;
        }
        enter2 = void 0;
      }
    }
    return events;
  }
  function previous(code) {
    return code !== 96 || this.events[this.events.length - 1][1].type === "characterEscape";
  }
  function tokenizeCodeText(effects, ok, nok) {
    let sizeOpen = 0;
    let size2;
    let token2;
    return start2;
    function start2(code) {
      effects.enter("codeText");
      effects.enter("codeTextSequence");
      return sequenceOpen(code);
    }
    function sequenceOpen(code) {
      if (code === 96) {
        effects.consume(code);
        sizeOpen++;
        return sequenceOpen;
      }
      effects.exit("codeTextSequence");
      return between(code);
    }
    function between(code) {
      if (code === null) {
        return nok(code);
      }
      if (code === 32) {
        effects.enter("space");
        effects.consume(code);
        effects.exit("space");
        return between;
      }
      if (code === 96) {
        token2 = effects.enter("codeTextSequence");
        size2 = 0;
        return sequenceClose(code);
      }
      if (markdownLineEnding(code)) {
        effects.enter("lineEnding");
        effects.consume(code);
        effects.exit("lineEnding");
        return between;
      }
      effects.enter("codeTextData");
      return data(code);
    }
    function data(code) {
      if (code === null || code === 32 || code === 96 || markdownLineEnding(code)) {
        effects.exit("codeTextData");
        return between(code);
      }
      effects.consume(code);
      return data;
    }
    function sequenceClose(code) {
      if (code === 96) {
        effects.consume(code);
        size2++;
        return sequenceClose;
      }
      if (size2 === sizeOpen) {
        effects.exit("codeTextSequence");
        effects.exit("codeText");
        return ok(code);
      }
      token2.type = "codeTextData";
      return data(code);
    }
  }
  function subtokenize(events) {
    const jumps = {};
    let index2 = -1;
    let event;
    let lineIndex;
    let otherIndex;
    let otherEvent;
    let parameters;
    let subevents;
    let more;
    while (++index2 < events.length) {
      while (index2 in jumps) {
        index2 = jumps[index2];
      }
      event = events[index2];
      if (index2 && event[1].type === "chunkFlow" && events[index2 - 1][1].type === "listItemPrefix") {
        subevents = event[1]._tokenizer.events;
        otherIndex = 0;
        if (otherIndex < subevents.length && subevents[otherIndex][1].type === "lineEndingBlank") {
          otherIndex += 2;
        }
        if (otherIndex < subevents.length && subevents[otherIndex][1].type === "content") {
          while (++otherIndex < subevents.length) {
            if (subevents[otherIndex][1].type === "content") {
              break;
            }
            if (subevents[otherIndex][1].type === "chunkText") {
              subevents[otherIndex][1]._isInFirstContentOfListItem = true;
              otherIndex++;
            }
          }
        }
      }
      if (event[0] === "enter") {
        if (event[1].contentType) {
          Object.assign(jumps, subcontent(events, index2));
          index2 = jumps[index2];
          more = true;
        }
      } else if (event[1]._container) {
        otherIndex = index2;
        lineIndex = void 0;
        while (otherIndex--) {
          otherEvent = events[otherIndex];
          if (otherEvent[1].type === "lineEnding" || otherEvent[1].type === "lineEndingBlank") {
            if (otherEvent[0] === "enter") {
              if (lineIndex) {
                events[lineIndex][1].type = "lineEndingBlank";
              }
              otherEvent[1].type = "lineEnding";
              lineIndex = otherIndex;
            }
          } else {
            break;
          }
        }
        if (lineIndex) {
          event[1].end = Object.assign({}, events[lineIndex][1].start);
          parameters = events.slice(lineIndex, index2);
          parameters.unshift(event);
          splice(events, lineIndex, index2 - lineIndex + 1, parameters);
        }
      }
    }
    return !more;
  }
  function subcontent(events, eventIndex) {
    const token2 = events[eventIndex][1];
    const context = events[eventIndex][2];
    let startPosition = eventIndex - 1;
    const startPositions = [];
    const tokenizer = token2._tokenizer || context.parser[token2.contentType](token2.start);
    const childEvents = tokenizer.events;
    const jumps = [];
    const gaps = {};
    let stream;
    let previous2;
    let index2 = -1;
    let current = token2;
    let adjust2 = 0;
    let start2 = 0;
    const breaks = [start2];
    while (current) {
      while (events[++startPosition][1] !== current) {
      }
      startPositions.push(startPosition);
      if (!current._tokenizer) {
        stream = context.sliceStream(current);
        if (!current.next) {
          stream.push(null);
        }
        if (previous2) {
          tokenizer.defineSkip(current.start);
        }
        if (current._isInFirstContentOfListItem) {
          tokenizer._gfmTasklistFirstContentOfListItem = true;
        }
        tokenizer.write(stream);
        if (current._isInFirstContentOfListItem) {
          tokenizer._gfmTasklistFirstContentOfListItem = void 0;
        }
      }
      previous2 = current;
      current = current.next;
    }
    current = token2;
    while (++index2 < childEvents.length) {
      if (
        // Find a void token that includes a break.
        childEvents[index2][0] === "exit" && childEvents[index2 - 1][0] === "enter" && childEvents[index2][1].type === childEvents[index2 - 1][1].type && childEvents[index2][1].start.line !== childEvents[index2][1].end.line
      ) {
        start2 = index2 + 1;
        breaks.push(start2);
        current._tokenizer = void 0;
        current.previous = void 0;
        current = current.next;
      }
    }
    tokenizer.events = [];
    if (current) {
      current._tokenizer = void 0;
      current.previous = void 0;
    } else {
      breaks.pop();
    }
    index2 = breaks.length;
    while (index2--) {
      const slice2 = childEvents.slice(breaks[index2], breaks[index2 + 1]);
      const start3 = startPositions.pop();
      jumps.unshift([start3, start3 + slice2.length - 1]);
      splice(events, start3, 2, slice2);
    }
    index2 = -1;
    while (++index2 < jumps.length) {
      gaps[adjust2 + jumps[index2][0]] = adjust2 + jumps[index2][1];
      adjust2 += jumps[index2][1] - jumps[index2][0] - 1;
    }
    return gaps;
  }
  const content = {
    tokenize: tokenizeContent,
    resolve: resolveContent
  };
  const continuationConstruct = {
    tokenize: tokenizeContinuation,
    partial: true
  };
  function resolveContent(events) {
    subtokenize(events);
    return events;
  }
  function tokenizeContent(effects, ok) {
    let previous2;
    return chunkStart;
    function chunkStart(code) {
      effects.enter("content");
      previous2 = effects.enter("chunkContent", {
        contentType: "content"
      });
      return chunkInside(code);
    }
    function chunkInside(code) {
      if (code === null) {
        return contentEnd(code);
      }
      if (markdownLineEnding(code)) {
        return effects.check(
          continuationConstruct,
          contentContinue,
          contentEnd
        )(code);
      }
      effects.consume(code);
      return chunkInside;
    }
    function contentEnd(code) {
      effects.exit("chunkContent");
      effects.exit("content");
      return ok(code);
    }
    function contentContinue(code) {
      effects.consume(code);
      effects.exit("chunkContent");
      previous2.next = effects.enter("chunkContent", {
        contentType: "content",
        previous: previous2
      });
      previous2 = previous2.next;
      return chunkInside;
    }
  }
  function tokenizeContinuation(effects, ok, nok) {
    const self2 = this;
    return startLookahead;
    function startLookahead(code) {
      effects.exit("chunkContent");
      effects.enter("lineEnding");
      effects.consume(code);
      effects.exit("lineEnding");
      return factorySpace(effects, prefixed, "linePrefix");
    }
    function prefixed(code) {
      if (code === null || markdownLineEnding(code)) {
        return nok(code);
      }
      const tail = self2.events[self2.events.length - 1];
      if (!self2.parser.constructs.disable.null.includes("codeIndented") && tail && tail[1].type === "linePrefix" && tail[2].sliceSerialize(tail[1], true).length >= 4) {
        return ok(code);
      }
      return effects.interrupt(self2.parser.constructs.flow, nok, ok)(code);
    }
  }
  function factoryDestination(effects, ok, nok, type2, literalType, literalMarkerType, rawType, stringType, max2) {
    const limit = max2 || Number.POSITIVE_INFINITY;
    let balance2 = 0;
    return start2;
    function start2(code) {
      if (code === 60) {
        effects.enter(type2);
        effects.enter(literalType);
        effects.enter(literalMarkerType);
        effects.consume(code);
        effects.exit(literalMarkerType);
        return enclosedBefore;
      }
      if (code === null || code === 32 || code === 41 || asciiControl(code)) {
        return nok(code);
      }
      effects.enter(type2);
      effects.enter(rawType);
      effects.enter(stringType);
      effects.enter("chunkString", {
        contentType: "string"
      });
      return raw(code);
    }
    function enclosedBefore(code) {
      if (code === 62) {
        effects.enter(literalMarkerType);
        effects.consume(code);
        effects.exit(literalMarkerType);
        effects.exit(literalType);
        effects.exit(type2);
        return ok;
      }
      effects.enter(stringType);
      effects.enter("chunkString", {
        contentType: "string"
      });
      return enclosed(code);
    }
    function enclosed(code) {
      if (code === 62) {
        effects.exit("chunkString");
        effects.exit(stringType);
        return enclosedBefore(code);
      }
      if (code === null || code === 60 || markdownLineEnding(code)) {
        return nok(code);
      }
      effects.consume(code);
      return code === 92 ? enclosedEscape : enclosed;
    }
    function enclosedEscape(code) {
      if (code === 60 || code === 62 || code === 92) {
        effects.consume(code);
        return enclosed;
      }
      return enclosed(code);
    }
    function raw(code) {
      if (!balance2 && (code === null || code === 41 || markdownLineEndingOrSpace(code))) {
        effects.exit("chunkString");
        effects.exit(stringType);
        effects.exit(rawType);
        effects.exit(type2);
        return ok(code);
      }
      if (balance2 < limit && code === 40) {
        effects.consume(code);
        balance2++;
        return raw;
      }
      if (code === 41) {
        effects.consume(code);
        balance2--;
        return raw;
      }
      if (code === null || code === 32 || code === 40 || asciiControl(code)) {
        return nok(code);
      }
      effects.consume(code);
      return code === 92 ? rawEscape : raw;
    }
    function rawEscape(code) {
      if (code === 40 || code === 41 || code === 92) {
        effects.consume(code);
        return raw;
      }
      return raw(code);
    }
  }
  function factoryLabel(effects, ok, nok, type2, markerType, stringType) {
    const self2 = this;
    let size2 = 0;
    let seen;
    return start2;
    function start2(code) {
      effects.enter(type2);
      effects.enter(markerType);
      effects.consume(code);
      effects.exit(markerType);
      effects.enter(stringType);
      return atBreak;
    }
    function atBreak(code) {
      if (size2 > 999 || code === null || code === 91 || code === 93 && !seen || // To do: remove in the future once we’ve switched from
      // `micromark-extension-footnote` to `micromark-extension-gfm-footnote`,
      // which doesn’t need this.
      // Hidden footnotes hook.
      /* c8 ignore next 3 */
      code === 94 && !size2 && "_hiddenFootnoteSupport" in self2.parser.constructs) {
        return nok(code);
      }
      if (code === 93) {
        effects.exit(stringType);
        effects.enter(markerType);
        effects.consume(code);
        effects.exit(markerType);
        effects.exit(type2);
        return ok;
      }
      if (markdownLineEnding(code)) {
        effects.enter("lineEnding");
        effects.consume(code);
        effects.exit("lineEnding");
        return atBreak;
      }
      effects.enter("chunkString", {
        contentType: "string"
      });
      return labelInside(code);
    }
    function labelInside(code) {
      if (code === null || code === 91 || code === 93 || markdownLineEnding(code) || size2++ > 999) {
        effects.exit("chunkString");
        return atBreak(code);
      }
      effects.consume(code);
      if (!seen)
        seen = !markdownSpace(code);
      return code === 92 ? labelEscape : labelInside;
    }
    function labelEscape(code) {
      if (code === 91 || code === 92 || code === 93) {
        effects.consume(code);
        size2++;
        return labelInside;
      }
      return labelInside(code);
    }
  }
  function factoryTitle(effects, ok, nok, type2, markerType, stringType) {
    let marker;
    return start2;
    function start2(code) {
      if (code === 34 || code === 39 || code === 40) {
        effects.enter(type2);
        effects.enter(markerType);
        effects.consume(code);
        effects.exit(markerType);
        marker = code === 40 ? 41 : code;
        return begin;
      }
      return nok(code);
    }
    function begin(code) {
      if (code === marker) {
        effects.enter(markerType);
        effects.consume(code);
        effects.exit(markerType);
        effects.exit(type2);
        return ok;
      }
      effects.enter(stringType);
      return atBreak(code);
    }
    function atBreak(code) {
      if (code === marker) {
        effects.exit(stringType);
        return begin(marker);
      }
      if (code === null) {
        return nok(code);
      }
      if (markdownLineEnding(code)) {
        effects.enter("lineEnding");
        effects.consume(code);
        effects.exit("lineEnding");
        return factorySpace(effects, atBreak, "linePrefix");
      }
      effects.enter("chunkString", {
        contentType: "string"
      });
      return inside(code);
    }
    function inside(code) {
      if (code === marker || code === null || markdownLineEnding(code)) {
        effects.exit("chunkString");
        return atBreak(code);
      }
      effects.consume(code);
      return code === 92 ? escape2 : inside;
    }
    function escape2(code) {
      if (code === marker || code === 92) {
        effects.consume(code);
        return inside;
      }
      return inside(code);
    }
  }
  function factoryWhitespace(effects, ok) {
    let seen;
    return start2;
    function start2(code) {
      if (markdownLineEnding(code)) {
        effects.enter("lineEnding");
        effects.consume(code);
        effects.exit("lineEnding");
        seen = true;
        return start2;
      }
      if (markdownSpace(code)) {
        return factorySpace(
          effects,
          start2,
          seen ? "linePrefix" : "lineSuffix"
        )(code);
      }
      return ok(code);
    }
  }
  function normalizeIdentifier(value2) {
    return value2.replace(/[\t\n\r ]+/g, " ").replace(/^ | $/g, "").toLowerCase().toUpperCase();
  }
  const definition = {
    name: "definition",
    tokenize: tokenizeDefinition
  };
  const titleBefore = {
    tokenize: tokenizeTitleBefore,
    partial: true
  };
  function tokenizeDefinition(effects, ok, nok) {
    const self2 = this;
    let identifier2;
    return start2;
    function start2(code) {
      effects.enter("definition");
      return before(code);
    }
    function before(code) {
      return factoryLabel.call(
        self2,
        effects,
        labelAfter,
        // Note: we don’t need to reset the way `markdown-rs` does.
        nok,
        "definitionLabel",
        "definitionLabelMarker",
        "definitionLabelString"
      )(code);
    }
    function labelAfter(code) {
      identifier2 = normalizeIdentifier(
        self2.sliceSerialize(self2.events[self2.events.length - 1][1]).slice(1, -1)
      );
      if (code === 58) {
        effects.enter("definitionMarker");
        effects.consume(code);
        effects.exit("definitionMarker");
        return markerAfter;
      }
      return nok(code);
    }
    function markerAfter(code) {
      return markdownLineEndingOrSpace(code) ? factoryWhitespace(effects, destinationBefore)(code) : destinationBefore(code);
    }
    function destinationBefore(code) {
      return factoryDestination(
        effects,
        destinationAfter,
        // Note: we don’t need to reset the way `markdown-rs` does.
        nok,
        "definitionDestination",
        "definitionDestinationLiteral",
        "definitionDestinationLiteralMarker",
        "definitionDestinationRaw",
        "definitionDestinationString"
      )(code);
    }
    function destinationAfter(code) {
      return effects.attempt(titleBefore, after, after)(code);
    }
    function after(code) {
      return markdownSpace(code) ? factorySpace(effects, afterWhitespace, "whitespace")(code) : afterWhitespace(code);
    }
    function afterWhitespace(code) {
      if (code === null || markdownLineEnding(code)) {
        effects.exit("definition");
        self2.parser.defined.push(identifier2);
        return ok(code);
      }
      return nok(code);
    }
  }
  function tokenizeTitleBefore(effects, ok, nok) {
    return titleBefore2;
    function titleBefore2(code) {
      return markdownLineEndingOrSpace(code) ? factoryWhitespace(effects, beforeMarker)(code) : nok(code);
    }
    function beforeMarker(code) {
      return factoryTitle(
        effects,
        titleAfter,
        nok,
        "definitionTitle",
        "definitionTitleMarker",
        "definitionTitleString"
      )(code);
    }
    function titleAfter(code) {
      return markdownSpace(code) ? factorySpace(effects, titleAfterOptionalWhitespace, "whitespace")(code) : titleAfterOptionalWhitespace(code);
    }
    function titleAfterOptionalWhitespace(code) {
      return code === null || markdownLineEnding(code) ? ok(code) : nok(code);
    }
  }
  const hardBreakEscape = {
    name: "hardBreakEscape",
    tokenize: tokenizeHardBreakEscape
  };
  function tokenizeHardBreakEscape(effects, ok, nok) {
    return start2;
    function start2(code) {
      effects.enter("hardBreakEscape");
      effects.consume(code);
      return after;
    }
    function after(code) {
      if (markdownLineEnding(code)) {
        effects.exit("hardBreakEscape");
        return ok(code);
      }
      return nok(code);
    }
  }
  const headingAtx = {
    name: "headingAtx",
    tokenize: tokenizeHeadingAtx,
    resolve: resolveHeadingAtx
  };
  function resolveHeadingAtx(events, context) {
    let contentEnd = events.length - 2;
    let contentStart = 3;
    let content2;
    let text2;
    if (events[contentStart][1].type === "whitespace") {
      contentStart += 2;
    }
    if (contentEnd - 2 > contentStart && events[contentEnd][1].type === "whitespace") {
      contentEnd -= 2;
    }
    if (events[contentEnd][1].type === "atxHeadingSequence" && (contentStart === contentEnd - 1 || contentEnd - 4 > contentStart && events[contentEnd - 2][1].type === "whitespace")) {
      contentEnd -= contentStart + 1 === contentEnd ? 2 : 4;
    }
    if (contentEnd > contentStart) {
      content2 = {
        type: "atxHeadingText",
        start: events[contentStart][1].start,
        end: events[contentEnd][1].end
      };
      text2 = {
        type: "chunkText",
        start: events[contentStart][1].start,
        end: events[contentEnd][1].end,
        contentType: "text"
      };
      splice(events, contentStart, contentEnd - contentStart + 1, [
        ["enter", content2, context],
        ["enter", text2, context],
        ["exit", text2, context],
        ["exit", content2, context]
      ]);
    }
    return events;
  }
  function tokenizeHeadingAtx(effects, ok, nok) {
    let size2 = 0;
    return start2;
    function start2(code) {
      effects.enter("atxHeading");
      return before(code);
    }
    function before(code) {
      effects.enter("atxHeadingSequence");
      return sequenceOpen(code);
    }
    function sequenceOpen(code) {
      if (code === 35 && size2++ < 6) {
        effects.consume(code);
        return sequenceOpen;
      }
      if (code === null || markdownLineEndingOrSpace(code)) {
        effects.exit("atxHeadingSequence");
        return atBreak(code);
      }
      return nok(code);
    }
    function atBreak(code) {
      if (code === 35) {
        effects.enter("atxHeadingSequence");
        return sequenceFurther(code);
      }
      if (code === null || markdownLineEnding(code)) {
        effects.exit("atxHeading");
        return ok(code);
      }
      if (markdownSpace(code)) {
        return factorySpace(effects, atBreak, "whitespace")(code);
      }
      effects.enter("atxHeadingText");
      return data(code);
    }
    function sequenceFurther(code) {
      if (code === 35) {
        effects.consume(code);
        return sequenceFurther;
      }
      effects.exit("atxHeadingSequence");
      return atBreak(code);
    }
    function data(code) {
      if (code === null || code === 35 || markdownLineEndingOrSpace(code)) {
        effects.exit("atxHeadingText");
        return atBreak(code);
      }
      effects.consume(code);
      return data;
    }
  }
  const htmlBlockNames = [
    "address",
    "article",
    "aside",
    "base",
    "basefont",
    "blockquote",
    "body",
    "caption",
    "center",
    "col",
    "colgroup",
    "dd",
    "details",
    "dialog",
    "dir",
    "div",
    "dl",
    "dt",
    "fieldset",
    "figcaption",
    "figure",
    "footer",
    "form",
    "frame",
    "frameset",
    "h1",
    "h2",
    "h3",
    "h4",
    "h5",
    "h6",
    "head",
    "header",
    "hr",
    "html",
    "iframe",
    "legend",
    "li",
    "link",
    "main",
    "menu",
    "menuitem",
    "nav",
    "noframes",
    "ol",
    "optgroup",
    "option",
    "p",
    "param",
    "search",
    "section",
    "summary",
    "table",
    "tbody",
    "td",
    "tfoot",
    "th",
    "thead",
    "title",
    "tr",
    "track",
    "ul"
  ];
  const htmlRawNames = ["pre", "script", "style", "textarea"];
  const htmlFlow = {
    name: "htmlFlow",
    tokenize: tokenizeHtmlFlow,
    resolveTo: resolveToHtmlFlow,
    concrete: true
  };
  const blankLineBefore = {
    tokenize: tokenizeBlankLineBefore,
    partial: true
  };
  const nonLazyContinuationStart = {
    tokenize: tokenizeNonLazyContinuationStart,
    partial: true
  };
  function resolveToHtmlFlow(events) {
    let index2 = events.length;
    while (index2--) {
      if (events[index2][0] === "enter" && events[index2][1].type === "htmlFlow") {
        break;
      }
    }
    if (index2 > 1 && events[index2 - 2][1].type === "linePrefix") {
      events[index2][1].start = events[index2 - 2][1].start;
      events[index2 + 1][1].start = events[index2 - 2][1].start;
      events.splice(index2 - 2, 2);
    }
    return events;
  }
  function tokenizeHtmlFlow(effects, ok, nok) {
    const self2 = this;
    let marker;
    let closingTag;
    let buffer;
    let index2;
    let markerB;
    return start2;
    function start2(code) {
      return before(code);
    }
    function before(code) {
      effects.enter("htmlFlow");
      effects.enter("htmlFlowData");
      effects.consume(code);
      return open;
    }
    function open(code) {
      if (code === 33) {
        effects.consume(code);
        return declarationOpen;
      }
      if (code === 47) {
        effects.consume(code);
        closingTag = true;
        return tagCloseStart;
      }
      if (code === 63) {
        effects.consume(code);
        marker = 3;
        return self2.interrupt ? ok : continuationDeclarationInside;
      }
      if (asciiAlpha(code)) {
        effects.consume(code);
        buffer = String.fromCharCode(code);
        return tagName;
      }
      return nok(code);
    }
    function declarationOpen(code) {
      if (code === 45) {
        effects.consume(code);
        marker = 2;
        return commentOpenInside;
      }
      if (code === 91) {
        effects.consume(code);
        marker = 5;
        index2 = 0;
        return cdataOpenInside;
      }
      if (asciiAlpha(code)) {
        effects.consume(code);
        marker = 4;
        return self2.interrupt ? ok : continuationDeclarationInside;
      }
      return nok(code);
    }
    function commentOpenInside(code) {
      if (code === 45) {
        effects.consume(code);
        return self2.interrupt ? ok : continuationDeclarationInside;
      }
      return nok(code);
    }
    function cdataOpenInside(code) {
      const value2 = "CDATA[";
      if (code === value2.charCodeAt(index2++)) {
        effects.consume(code);
        if (index2 === value2.length) {
          return self2.interrupt ? ok : continuation;
        }
        return cdataOpenInside;
      }
      return nok(code);
    }
    function tagCloseStart(code) {
      if (asciiAlpha(code)) {
        effects.consume(code);
        buffer = String.fromCharCode(code);
        return tagName;
      }
      return nok(code);
    }
    function tagName(code) {
      if (code === null || code === 47 || code === 62 || markdownLineEndingOrSpace(code)) {
        const slash = code === 47;
        const name = buffer.toLowerCase();
        if (!slash && !closingTag && htmlRawNames.includes(name)) {
          marker = 1;
          return self2.interrupt ? ok(code) : continuation(code);
        }
        if (htmlBlockNames.includes(buffer.toLowerCase())) {
          marker = 6;
          if (slash) {
            effects.consume(code);
            return basicSelfClosing;
          }
          return self2.interrupt ? ok(code) : continuation(code);
        }
        marker = 7;
        return self2.interrupt && !self2.parser.lazy[self2.now().line] ? nok(code) : closingTag ? completeClosingTagAfter(code) : completeAttributeNameBefore(code);
      }
      if (code === 45 || asciiAlphanumeric(code)) {
        effects.consume(code);
        buffer += String.fromCharCode(code);
        return tagName;
      }
      return nok(code);
    }
    function basicSelfClosing(code) {
      if (code === 62) {
        effects.consume(code);
        return self2.interrupt ? ok : continuation;
      }
      return nok(code);
    }
    function completeClosingTagAfter(code) {
      if (markdownSpace(code)) {
        effects.consume(code);
        return completeClosingTagAfter;
      }
      return completeEnd(code);
    }
    function completeAttributeNameBefore(code) {
      if (code === 47) {
        effects.consume(code);
        return completeEnd;
      }
      if (code === 58 || code === 95 || asciiAlpha(code)) {
        effects.consume(code);
        return completeAttributeName;
      }
      if (markdownSpace(code)) {
        effects.consume(code);
        return completeAttributeNameBefore;
      }
      return completeEnd(code);
    }
    function completeAttributeName(code) {
      if (code === 45 || code === 46 || code === 58 || code === 95 || asciiAlphanumeric(code)) {
        effects.consume(code);
        return completeAttributeName;
      }
      return completeAttributeNameAfter(code);
    }
    function completeAttributeNameAfter(code) {
      if (code === 61) {
        effects.consume(code);
        return completeAttributeValueBefore;
      }
      if (markdownSpace(code)) {
        effects.consume(code);
        return completeAttributeNameAfter;
      }
      return completeAttributeNameBefore(code);
    }
    function completeAttributeValueBefore(code) {
      if (code === null || code === 60 || code === 61 || code === 62 || code === 96) {
        return nok(code);
      }
      if (code === 34 || code === 39) {
        effects.consume(code);
        markerB = code;
        return completeAttributeValueQuoted;
      }
      if (markdownSpace(code)) {
        effects.consume(code);
        return completeAttributeValueBefore;
      }
      return completeAttributeValueUnquoted(code);
    }
    function completeAttributeValueQuoted(code) {
      if (code === markerB) {
        effects.consume(code);
        markerB = null;
        return completeAttributeValueQuotedAfter;
      }
      if (code === null || markdownLineEnding(code)) {
        return nok(code);
      }
      effects.consume(code);
      return completeAttributeValueQuoted;
    }
    function completeAttributeValueUnquoted(code) {
      if (code === null || code === 34 || code === 39 || code === 47 || code === 60 || code === 61 || code === 62 || code === 96 || markdownLineEndingOrSpace(code)) {
        return completeAttributeNameAfter(code);
      }
      effects.consume(code);
      return completeAttributeValueUnquoted;
    }
    function completeAttributeValueQuotedAfter(code) {
      if (code === 47 || code === 62 || markdownSpace(code)) {
        return completeAttributeNameBefore(code);
      }
      return nok(code);
    }
    function completeEnd(code) {
      if (code === 62) {
        effects.consume(code);
        return completeAfter;
      }
      return nok(code);
    }
    function completeAfter(code) {
      if (code === null || markdownLineEnding(code)) {
        return continuation(code);
      }
      if (markdownSpace(code)) {
        effects.consume(code);
        return completeAfter;
      }
      return nok(code);
    }
    function continuation(code) {
      if (code === 45 && marker === 2) {
        effects.consume(code);
        return continuationCommentInside;
      }
      if (code === 60 && marker === 1) {
        effects.consume(code);
        return continuationRawTagOpen;
      }
      if (code === 62 && marker === 4) {
        effects.consume(code);
        return continuationClose;
      }
      if (code === 63 && marker === 3) {
        effects.consume(code);
        return continuationDeclarationInside;
      }
      if (code === 93 && marker === 5) {
        effects.consume(code);
        return continuationCdataInside;
      }
      if (markdownLineEnding(code) && (marker === 6 || marker === 7)) {
        effects.exit("htmlFlowData");
        return effects.check(
          blankLineBefore,
          continuationAfter,
          continuationStart
        )(code);
      }
      if (code === null || markdownLineEnding(code)) {
        effects.exit("htmlFlowData");
        return continuationStart(code);
      }
      effects.consume(code);
      return continuation;
    }
    function continuationStart(code) {
      return effects.check(
        nonLazyContinuationStart,
        continuationStartNonLazy,
        continuationAfter
      )(code);
    }
    function continuationStartNonLazy(code) {
      effects.enter("lineEnding");
      effects.consume(code);
      effects.exit("lineEnding");
      return continuationBefore;
    }
    function continuationBefore(code) {
      if (code === null || markdownLineEnding(code)) {
        return continuationStart(code);
      }
      effects.enter("htmlFlowData");
      return continuation(code);
    }
    function continuationCommentInside(code) {
      if (code === 45) {
        effects.consume(code);
        return continuationDeclarationInside;
      }
      return continuation(code);
    }
    function continuationRawTagOpen(code) {
      if (code === 47) {
        effects.consume(code);
        buffer = "";
        return continuationRawEndTag;
      }
      return continuation(code);
    }
    function continuationRawEndTag(code) {
      if (code === 62) {
        const name = buffer.toLowerCase();
        if (htmlRawNames.includes(name)) {
          effects.consume(code);
          return continuationClose;
        }
        return continuation(code);
      }
      if (asciiAlpha(code) && buffer.length < 8) {
        effects.consume(code);
        buffer += String.fromCharCode(code);
        return continuationRawEndTag;
      }
      return continuation(code);
    }
    function continuationCdataInside(code) {
      if (code === 93) {
        effects.consume(code);
        return continuationDeclarationInside;
      }
      return continuation(code);
    }
    function continuationDeclarationInside(code) {
      if (code === 62) {
        effects.consume(code);
        return continuationClose;
      }
      if (code === 45 && marker === 2) {
        effects.consume(code);
        return continuationDeclarationInside;
      }
      return continuation(code);
    }
    function continuationClose(code) {
      if (code === null || markdownLineEnding(code)) {
        effects.exit("htmlFlowData");
        return continuationAfter(code);
      }
      effects.consume(code);
      return continuationClose;
    }
    function continuationAfter(code) {
      effects.exit("htmlFlow");
      return ok(code);
    }
  }
  function tokenizeNonLazyContinuationStart(effects, ok, nok) {
    const self2 = this;
    return start2;
    function start2(code) {
      if (markdownLineEnding(code)) {
        effects.enter("lineEnding");
        effects.consume(code);
        effects.exit("lineEnding");
        return after;
      }
      return nok(code);
    }
    function after(code) {
      return self2.parser.lazy[self2.now().line] ? nok(code) : ok(code);
    }
  }
  function tokenizeBlankLineBefore(effects, ok, nok) {
    return start2;
    function start2(code) {
      effects.enter("lineEnding");
      effects.consume(code);
      effects.exit("lineEnding");
      return effects.attempt(blankLine, ok, nok);
    }
  }
  const htmlText = {
    name: "htmlText",
    tokenize: tokenizeHtmlText
  };
  function tokenizeHtmlText(effects, ok, nok) {
    const self2 = this;
    let marker;
    let index2;
    let returnState;
    return start2;
    function start2(code) {
      effects.enter("htmlText");
      effects.enter("htmlTextData");
      effects.consume(code);
      return open;
    }
    function open(code) {
      if (code === 33) {
        effects.consume(code);
        return declarationOpen;
      }
      if (code === 47) {
        effects.consume(code);
        return tagCloseStart;
      }
      if (code === 63) {
        effects.consume(code);
        return instruction;
      }
      if (asciiAlpha(code)) {
        effects.consume(code);
        return tagOpen;
      }
      return nok(code);
    }
    function declarationOpen(code) {
      if (code === 45) {
        effects.consume(code);
        return commentOpenInside;
      }
      if (code === 91) {
        effects.consume(code);
        index2 = 0;
        return cdataOpenInside;
      }
      if (asciiAlpha(code