'use strict';

var path = require('path');
var jsToMarkdown = require('./js-to-markdown');
var independent = require('independent');
var codemo = require('codemo');

module.exports = function (opts) {
  var markdownPath = opts.filePath;
  var markdownDir = path.dirname(markdownPath);

  var example = createExample();

  example.es6 = createExample({ es6: true });

  function createExample(codemoOpts) {
    return function (relativeFilePath) {
      var filePath = path.resolve(markdownDir, relativeFilePath);
      return codemo.processFile(filePath, codemoOpts).then(function (code) {
        return independent({
          code: code.trim(),
          path: filePath
        });
      }).then(jsToMarkdown);
    };
  }

  return example;
};