"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Perf = void 0;

/**
 * Attempt to use a high resolution timestamp when in the browswer environment, but fallback to Date.now
 * When the performance API is not available.
 */
const Perf = {
  getNow
};
exports.Perf = Perf;

function getNow() {
  if (typeof performance !== `undefined`) {
    return performance.now();
  }

  return Date.now();
}