"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.paramsModule = void 0;

function updateParams(oldVnode, vnode) {
  const elm = vnode.elm; // common guards used in snabbdom-attr-module

  const oldParams = oldVnode.data.params;
  const params = vnode.data.params;
  if (oldParams === params) return;
  if (!oldParams && !params) return;

  if (elm.setParams) {
    elm.setParams(params);
  }
}

const paramsModule = {
  create: updateParams,
  update: updateParams
};
exports.paramsModule = paramsModule;