"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _stateController = _interopRequireDefault(require("./state-controller"));

var _stateStore = _interopRequireDefault(require("./state-store"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Optional component wrappers and utilities for state management;
 * exported in the main {@link panel} module for convenience.
 * @module component-utils
 * @example
 * // direct top-level import
 * import {ProxyComponent, StateController} from 'panel';
 * // module import
 * import {ComponentUtils} from 'panel';
 * const {ProxyComponent, StateController} = ComponentUtils;
 */
var _default = {
  /** {@link StateController} class, to be subclassed by apps */
  StateController: _stateController.default,

  /** A simple subscribable state store */
  StateStore: _stateStore.default
};
exports.default = _default;