"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _stateStore = _interopRequireDefault(require("./state-store"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * A StateController manages state for an application or component
 * Subclasses extend this and expose methods that call the controller's _update method
 * Controller will default create its own state store unless one is passed.
 * StateController subclasses should only accept the dependencies they need via constructor
 * This means the dependencies can easily be mocked and unit tested
 */
class StateController {
  // Create's a default store if one isn't given
  constructor() {
    let {
      store = null
    } = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    this._store = store || new _stateStore.default();

    this._update(this.defaultState);
  }

  get defaultState() {
    return {};
  }

  get state() {
    return this._store.state;
  } // Discourage external users from using state directly


  _update(props) {
    this._store.update(props);
  }

  subscribeUpdates(listener) {
    return this._store.subscribeUpdates(listener);
  }

  unsubscribeUpdates(listener) {
    return this._store.unsubscribeUpdates(listener);
  }

}

var _default = StateController;
exports.default = _default;