"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "Component", {
  enumerable: true,
  get: function () {
    return _component.default;
  }
});
Object.defineProperty(exports, "ComponentUtils", {
  enumerable: true,
  get: function () {
    return _componentUtils.default;
  }
});
exports.StateStore = exports.StateController = exports.ParamComponent = void 0;
Object.defineProperty(exports, "h", {
  enumerable: true,
  get: function () {
    return _domPatcher.h;
  }
});
Object.defineProperty(exports, "jsx", {
  enumerable: true,
  get: function () {
    return _snabbdomJsxLite.jsx;
  }
});
Object.defineProperty(exports, "shallowEqual", {
  enumerable: true,
  get: function () {
    return _shallowEqual.default;
  }
});

var _component = _interopRequireDefault(require("./component"));

var _componentUtils = _interopRequireDefault(require("./component-utils"));

var _shallowEqual = _interopRequireDefault(require("./component-utils/shallowEqual"));

var _domPatcher = require("./dom-patcher");

var _snabbdomJsxLite = require("snabbdom-jsx-lite");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/**
 * Entry point for Panel apps and components
 * @module panel
 * @example
 * import { Component } from 'panel';
 * customElements.define('my-widget', class extends Component {
 *   // app definition
 * });
 */
const {
  StateController,
  StateStore
} = _componentUtils.default;
exports.StateStore = StateStore;
exports.StateController = StateController;
const ParamComponent = _component.default;
exports.ParamComponent = ParamComponent;