import _classCallCheck from 'babel-runtime/helpers/classCallCheck';
import _possibleConstructorReturn from 'babel-runtime/helpers/possibleConstructorReturn';
import _inherits from 'babel-runtime/helpers/inherits';
import PropTypes from 'prop-types';
import enUs from '../locale/en_US';

function noop() {}

export var propType = {
  className: PropTypes.string,
  locale: PropTypes.object,
  style: PropTypes.object,
  visible: PropTypes.bool,
  onSelect: PropTypes.func,
  prefixCls: PropTypes.string,
  onChange: PropTypes.func,
  onOk: PropTypes.func
};

export var defaultProp = {
  locale: enUs,
  style: {},
  visible: true,
  prefixCls: 'rc-calendar',
  className: '',
  onSelect: noop,
  onChange: noop,
  onClear: noop,
  renderFooter: function renderFooter() {
    return null;
  },
  renderSidebar: function renderSidebar() {
    return null;
  }
};

export var commonMixinWrapper = function commonMixinWrapper(ComposeComponent) {
  var _class, _temp2;

  return _temp2 = _class = function (_ComposeComponent) {
    _inherits(_class, _ComposeComponent);

    function _class() {
      var _temp, _this, _ret;

      _classCallCheck(this, _class);

      for (var _len = arguments.length, args = Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }

      return _ret = (_temp = (_this = _possibleConstructorReturn(this, _ComposeComponent.call.apply(_ComposeComponent, [this].concat(args))), _this), _this.getFormat = function () {
        var format = _this.props.format;
        var _this$props = _this.props,
            locale = _this$props.locale,
            timePicker = _this$props.timePicker;

        if (!format) {
          if (timePicker) {
            format = locale.dateTimeFormat;
          } else {
            format = locale.dateFormat;
          }
        }
        return format;
      }, _this.focus = function () {
        if (_this.focusElement) {
          _this.focusElement.focus();
        } else if (_this.rootInstance) {
          _this.rootInstance.focus();
        }
      }, _this.saveFocusElement = function (focusElement) {
        _this.focusElement = focusElement;
      }, _this.saveRoot = function (root) {
        _this.rootInstance = root;
      }, _temp), _possibleConstructorReturn(_this, _ret);
    }

    _class.prototype.shouldComponentUpdate = function shouldComponentUpdate(nextProps) {
      return this.props.visible || nextProps.visible;
    };

    return _class;
  }(ComposeComponent), _class.displayName = 'CommonMixinWrapper', _class.defaultProps = ComposeComponent.defaultProps, _class.getDerivedStateFromProps = ComposeComponent.getDerivedStateFromProps, _temp2;
};