'use strict';

exports.__esModule = true;

var _react = require('react');

var _react2 = _interopRequireDefault(_react);

var _reactDom = require('react-dom');

var _reactDom2 = _interopRequireDefault(_reactDom);

var _createReactClass = require('create-react-class');

var _createReactClass2 = _interopRequireDefault(_createReactClass);

var _propTypes = require('prop-types');

var _propTypes2 = _interopRequireDefault(_propTypes);

var _moment = require('moment');

var _moment2 = _interopRequireDefault(_moment);

var _util = require('../util');

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { 'default': obj }; }

var DateInput = (0, _createReactClass2['default'])({
  displayName: 'DateInput',

  propTypes: {
    prefixCls: _propTypes2['default'].string,
    timePicker: _propTypes2['default'].object,
    value: _propTypes2['default'].object,
    disabledTime: _propTypes2['default'].any,
    format: _propTypes2['default'].oneOfType([_propTypes2['default'].string, _propTypes2['default'].arrayOf(_propTypes2['default'].string)]),
    locale: _propTypes2['default'].object,
    disabledDate: _propTypes2['default'].func,
    onChange: _propTypes2['default'].func,
    onClear: _propTypes2['default'].func,
    placeholder: _propTypes2['default'].string,
    onSelect: _propTypes2['default'].func,
    selectedValue: _propTypes2['default'].object,
    clearIcon: _propTypes2['default'].node
  },

  getInitialState: function getInitialState() {
    var selectedValue = this.props.selectedValue;
    return {
      str: (0, _util.formatDate)(selectedValue, this.props.format),
      invalid: false,
      hasFocus: false
    };
  },
  componentWillReceiveProps: function componentWillReceiveProps(nextProps) {
    this.cachedSelectionStart = this.dateInputInstance.selectionStart;
    this.cachedSelectionEnd = this.dateInputInstance.selectionEnd;
    // when popup show, click body will call this, bug!
    var selectedValue = nextProps.selectedValue;
    if (!this.state.hasFocus) {
      this.setState({
        str: (0, _util.formatDate)(selectedValue, nextProps.format),
        invalid: false
      });
    }
  },
  componentDidUpdate: function componentDidUpdate() {
    if (this.state.hasFocus && !this.state.invalid && !(this.cachedSelectionStart === 0 && this.cachedSelectionEnd === 0)) {
      this.dateInputInstance.setSelectionRange(this.cachedSelectionStart, this.cachedSelectionEnd);
    }
  },
  onInputChange: function onInputChange(event) {
    var str = event.target.value;
    var _props = this.props,
        disabledDate = _props.disabledDate,
        format = _props.format,
        onChange = _props.onChange,
        selectedValue = _props.selectedValue;

    // 没有内容，合法并直接退出

    if (!str) {
      onChange(null);
      this.setState({
        invalid: false,
        str: str
      });
      return;
    }

    // 不合法直接退出
    var parsed = (0, _moment2['default'])(str, format, true);
    if (!parsed.isValid()) {
      this.setState({
        invalid: true,
        str: str
      });
      return;
    }

    var value = this.props.value.clone();
    value.year(parsed.year()).month(parsed.month()).date(parsed.date()).hour(parsed.hour()).minute(parsed.minute()).second(parsed.second());

    if (!value || disabledDate && disabledDate(value)) {
      this.setState({
        invalid: true,
        str: str
      });
      return;
    }

    if (selectedValue !== value || selectedValue && value && !selectedValue.isSame(value)) {
      this.setState({
        str: str
      });
      onChange(value);
    }
  },
  onClear: function onClear() {
    this.setState({
      str: ''
    });
    this.props.onClear(null);
  },
  getRootDOMNode: function getRootDOMNode() {
    return _reactDom2['default'].findDOMNode(this);
  },
  focus: function focus() {
    if (this.dateInputInstance) {
      this.dateInputInstance.focus();
    }
  },
  saveDateInput: function saveDateInput(dateInput) {
    this.dateInputInstance = dateInput;
  },
  onFocus: function onFocus() {
    this.setState({ hasFocus: true });
  },
  onBlur: function onBlur() {
    this.setState(function (prevState, prevProps) {
      return {
        hasFocus: false,
        str: (0, _util.formatDate)(prevProps.value, prevProps.format)
      };
    });
  },
  render: function render() {
    var props = this.props;
    var _state = this.state,
        invalid = _state.invalid,
        str = _state.str;
    var locale = props.locale,
        prefixCls = props.prefixCls,
        placeholder = props.placeholder,
        clearIcon = props.clearIcon;

    var invalidClass = invalid ? prefixCls + '-input-invalid' : '';
    return _react2['default'].createElement(
      'div',
      { className: prefixCls + '-input-wrap' },
      _react2['default'].createElement(
        'div',
        { className: prefixCls + '-date-input-wrap' },
        _react2['default'].createElement('input', {
          ref: this.saveDateInput,
          className: prefixCls + '-input ' + invalidClass,
          value: str,
          disabled: props.disabled,
          placeholder: placeholder,
          onChange: this.onInputChange,
          onFocus: this.onFocus,
          onBlur: this.onBlur
        })
      ),
      props.showClear ? _react2['default'].createElement(
        'a',
        {
          role: 'button',
          title: locale.clear,
          onClick: this.onClear
        },
        clearIcon || _react2['default'].createElement('span', { className: prefixCls + '-clear-btn' })
      ) : null
    );
  }
});

exports['default'] = DateInput;
module.exports = exports['default'];