//#region src/isNonNull.d.ts
/**
 * A function that checks if the passed parameter is not `null` and narrows its type accordingly.
 * Notice that `undefined` is not null!
 *
 * @param data - The variable to check.
 * @returns True if the passed input is defined, false otherwise.
 * @signature
 *    R.isNonNull(data)
 * @example
 *    R.isNonNull('string') //=> true
 *    R.isNonNull(null) //=> false
 *    R.isNonNull(undefined) //=> true
 * @category Guard
 */
declare function isNonNull<T>(data: T | null): data is T;
//#endregion
export { isNonNull };
//# sourceMappingURL=isNonNull-C-TKYeFi.d.ts.map