import { IfNever } from "type-fest";

//#region src/internal/types/CoercedArray.d.ts

/**
 * `never[]` and `[]` are not the same type, and in some cases they aren't
 * interchangeable.
 *
 * This type makes it easier to use the result of TupleParts when the input is a
 * fixed-length tuple but we still want to spread the rest of the array. e.g.
 * `[...CoercedArray<TupleParts<T>["item"]>, ...TupleParts<T>["suffix"]]`.
 *
 */
type CoercedArray<T> = IfNever<T, [], Array<T>>;
//#endregion
export { CoercedArray };
//# sourceMappingURL=CoercedArray-DlyU2XyU.d.cts.map