import RRule from './rrule';
import dateutil from './dateutil';
export declare type DaySet = [(number | null)[], number, number];
export declare type GetDayset = () => DaySet;
export default class Iterinfo {
    rrule: RRule;
    lastyear: number;
    lastmonth: number;
    yearlen: 365 | 366;
    nextyearlen: 365 | 366;
    yearordinal: number;
    yearweekday: number;
    mmask: number[] | null;
    mrange: number[] | null;
    mdaymask: number[] | null;
    nmdaymask: number[] | null;
    wdaymask: number[] | null;
    wnomask: number[] | null;
    nwdaymask: number[] | null;
    eastermask: number[] | null;
    constructor(rrule: RRule);
    easter(y: number, offset?: number): number[];
    rebuild(year: number, month: number): void;
    private rebuildYear;
    private rebuildMonth;
    ydayset(): (number | number[])[];
    mdayset(_: any, month: number, __: any): (number | (number | null)[])[];
    wdayset(year: number, month: number, day: number): (number | (number | null)[])[];
    ddayset(year: number, month: number, day: number): (number | (number | null)[])[];
    htimeset(hour: number, minute: number, second: number, millisecond: number): dateutil.Time[];
    mtimeset(hour: number, minute: number, second: number, millisecond: number): dateutil.Time[];
    stimeset(hour: number, minute: number, second: number, millisecond: number): dateutil.Time[];
}
