var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    }
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import RRule from './rrule';
import dateutil from './dateutil';
import { includes } from './helpers';
/**
 *
 * @param {Boolean?} noCache
 *  The same stratagy as RRule on cache, default to false
 * @constructor
 */
var RRuleSet = /** @class */ (function (_super) {
    __extends(RRuleSet, _super);
    function RRuleSet(noCache) {
        if (noCache === void 0) { noCache = false; }
        var _this = _super.call(this, {}, noCache) || this;
        _this._rrule = [];
        _this._rdate = [];
        _this._exrule = [];
        _this._exdate = [];
        return _this;
    }
    /**
     * Adds an RRule to the set
     *
     * @param {RRule}
     */
    RRuleSet.prototype.rrule = function (rrule) {
        if (!(rrule instanceof RRule)) {
            throw new TypeError(String(rrule) + ' is not RRule instance');
        }
        if (!includes(this._rrule.map(String), String(rrule))) {
            this._rrule.push(rrule);
        }
    };
    /**
     * Adds an RDate to the set
     *
     * @param {Date}
     */
    RRuleSet.prototype.rdate = function (date) {
        if (!(date instanceof Date)) {
            throw new TypeError(String(date) + ' is not Date instance');
        }
        if (!includes(this._rdate.map(Number), Number(date))) {
            this._rdate.push(date);
            dateutil.sort(this._rdate);
        }
    };
    /**
     * Adds an EXRULE to the set
     *
     * @param {RRule}
     */
    RRuleSet.prototype.exrule = function (rrule) {
        if (!(rrule instanceof RRule)) {
            throw new TypeError(String(rrule) + ' is not RRule instance');
        }
        if (!includes(this._exrule.map(String), String(rrule))) {
            this._exrule.push(rrule);
        }
    };
    /**
     * Adds an EXDATE to the set
     *
     * @param {Date}
     */
    RRuleSet.prototype.exdate = function (date) {
        if (!(date instanceof Date)) {
            throw new TypeError(String(date) + ' is not Date instance');
        }
        if (!includes(this._exdate.map(Number), Number(date))) {
            this._exdate.push(date);
            dateutil.sort(this._exdate);
        }
    };
    RRuleSet.prototype.valueOf = function () {
        var result = [];
        if (this._rrule.length) {
            this._rrule.forEach(function (rrule) {
                result.push('RRULE:' + rrule);
            });
        }
        if (this._rdate.length) {
            result.push('RDATE:' +
                this._rdate
                    .map(function (rdate) {
                    return dateutil.timeToUntilString(rdate.valueOf());
                })
                    .join(','));
        }
        if (this._exrule.length) {
            this._exrule.forEach(function (exrule) {
                result.push('EXRULE:' + exrule);
            });
        }
        if (this._exdate.length) {
            result.push('EXDATE:' +
                this._exdate
                    .map(function (exdate) {
                    return dateutil.timeToUntilString(exdate.valueOf());
                })
                    .join(','));
        }
        return result;
    };
    /**
     * to generate recurrence field sush as:
     *   ["RRULE:FREQ=YEARLY;COUNT=2;BYDAY=TU;DTSTART=19970902T010000Z","RRULE:FREQ=YEARLY;COUNT=1;BYDAY=TH;DTSTART=19970902T010000Z"]
     */
    RRuleSet.prototype.toString = function () {
        return JSON.stringify(this.valueOf());
    };
    RRuleSet.prototype._iter = function (iterResult) {
        var _exdateHash = {};
        var _exrule = this._exrule;
        var _accept = iterResult.accept;
        function evalExdate(after, before) {
            _exrule.forEach(function (rrule) {
                rrule.between(after, before, true).forEach(function (date) {
                    _exdateHash[Number(date)] = true;
                });
            });
        }
        this._exdate.forEach(function (date) {
            _exdateHash[Number(date)] = true;
        });
        iterResult.accept = function (date) {
            var dt = Number(date);
            if (!_exdateHash[dt]) {
                evalExdate(new Date(dt - 1), new Date(dt + 1));
                if (!_exdateHash[dt]) {
                    _exdateHash[dt] = true;
                    return _accept.call(this, date);
                }
            }
            return true;
        };
        if (iterResult.method === 'between') {
            evalExdate(iterResult.args.after, iterResult.args.before);
            iterResult.accept = function (date) {
                var dt = Number(date);
                if (!_exdateHash[dt]) {
                    _exdateHash[dt] = true;
                    return _accept.call(this, date);
                }
                return true;
            };
        }
        for (var i = 0; i < this._rdate.length; i++) {
            if (!iterResult.accept(new Date(this._rdate[i].valueOf())))
                break;
        }
        this._rrule.forEach(function (rrule) {
            rrule._iter(iterResult);
        });
        var res = iterResult._result;
        dateutil.sort(res);
        switch (iterResult.method) {
            case 'all':
            case 'between':
                return res;
            case 'before':
                return (res.length && res[res.length - 1]) || null;
            case 'after':
                return (res.length && res[0]) || null;
            default:
                return null;
        }
    };
    /**
     * Create a new RRuleSet Object completely base on current instance
     */
    RRuleSet.prototype.clone = function () {
        var rrs = new RRuleSet(!!this._cache);
        var i;
        for (i = 0; i < this._rrule.length; i++) {
            rrs.rrule(this._rrule[i].clone());
        }
        for (i = 0; i < this._rdate.length; i++) {
            rrs.rdate(new Date(this._rdate[i].valueOf()));
        }
        for (i = 0; i < this._exrule.length; i++) {
            rrs.exrule(this._exrule[i].clone());
        }
        for (i = 0; i < this._exdate.length; i++) {
            rrs.exdate(new Date(this._exdate[i].valueOf()));
        }
        return rrs;
    };
    return RRuleSet;
}(RRule));
export default RRuleSet;
//# sourceMappingURL=rruleset.js.map