'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var index = require('../../dist/index-dd942fa3.cjs.dev.js');
var data = require('../../dist/data-d0a8f6df.cjs.dev.js');
require('../../dist/inherits-4172bb27.cjs.dev.js');
require('../../dist/colors-a4626581.cjs.dev.js');

/**
 * Sigma.js Settings
 * =================================
 *
 * The list of settings and some handy functions.
 * @module
 */

/**
 * Sigma.js settings
 * =================================
 */

var DEFAULT_SETTINGS = {
  // Performance
  hideEdgesOnMove: false,
  hideLabelsOnMove: false,
  renderLabels: true,
  renderEdgeLabels: false,
  enableEdgeEvents: false,
  // Component rendering
  defaultNodeColor: "#999",
  defaultNodeType: "circle",
  defaultEdgeColor: "#ccc",
  defaultEdgeType: "line",
  labelFont: "Arial",
  labelSize: 14,
  labelWeight: "normal",
  labelColor: {
    color: "#000"
  },
  edgeLabelFont: "Arial",
  edgeLabelSize: 14,
  edgeLabelWeight: "normal",
  edgeLabelColor: {
    attribute: "color"
  },
  stagePadding: 30,
  zoomToSizeRatioFunction: Math.sqrt,
  itemSizesReference: "screen",
  defaultDrawEdgeLabel: index.drawStraightEdgeLabel,
  defaultDrawNodeLabel: index.drawDiscNodeLabel,
  defaultDrawNodeHover: index.drawDiscNodeHover,
  minEdgeThickness: 1.7,
  antiAliasingFeather: 1,
  // Labels
  labelDensity: 1,
  labelGridCellSize: 100,
  labelRenderedSizeThreshold: 6,
  // Reducers
  nodeReducer: null,
  edgeReducer: null,
  // Features
  zIndex: false,
  minCameraRatio: null,
  maxCameraRatio: null,
  enableCameraRotation: true,
  // Lifecycle
  allowInvalidContainer: false,
  // Program classes
  nodeProgramClasses: {},
  nodeHoverProgramClasses: {},
  edgeProgramClasses: {}
};
var DEFAULT_NODE_PROGRAM_CLASSES = {
  circle: index.NodeCircleProgram
};
var DEFAULT_EDGE_PROGRAM_CLASSES = {
  arrow: index.EdgeArrowProgram,
  line: index.EdgeRectangleProgram
};
function validateSettings(settings) {
  if (typeof settings.labelDensity !== "number" || settings.labelDensity < 0) {
    throw new Error("Settings: invalid `labelDensity`. Expecting a positive number.");
  }
  var minCameraRatio = settings.minCameraRatio,
    maxCameraRatio = settings.maxCameraRatio;
  if (typeof minCameraRatio === "number" && typeof maxCameraRatio === "number" && maxCameraRatio < minCameraRatio) {
    throw new Error("Settings: invalid camera ratio boundaries. Expecting `maxCameraRatio` to be greater than `minCameraRatio`.");
  }
}
function resolveSettings(settings) {
  var resolvedSettings = data.assign({}, DEFAULT_SETTINGS, settings);
  resolvedSettings.nodeProgramClasses = data.assign({}, DEFAULT_NODE_PROGRAM_CLASSES, resolvedSettings.nodeProgramClasses);
  resolvedSettings.edgeProgramClasses = data.assign({}, DEFAULT_EDGE_PROGRAM_CLASSES, resolvedSettings.edgeProgramClasses);
  return resolvedSettings;
}

exports.DEFAULT_EDGE_PROGRAM_CLASSES = DEFAULT_EDGE_PROGRAM_CLASSES;
exports.DEFAULT_NODE_PROGRAM_CLASSES = DEFAULT_NODE_PROGRAM_CLASSES;
exports.DEFAULT_SETTINGS = DEFAULT_SETTINGS;
exports.resolveSettings = resolveSettings;
exports.validateSettings = validateSettings;
