"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.customTags = void 0;
const yaml_types_1 = require("yaml-types");
const date_js_1 = require("./date.js");
const timestamp_js_1 = require("./timestamp.js");
// prepend our custom tags so that they take priority over anything
// enabled by default in the schema.
const t = [
    yaml_types_1.regexp,
    yaml_types_1.sharedSymbol,
    yaml_types_1.symbol,
    yaml_types_1.bigint,
    yaml_types_1.nullobject,
    yaml_types_1.error,
    yaml_types_1.classTag,
    yaml_types_1.functionTag,
    timestamp_js_1.timestamp,
    date_js_1.date,
    'omap',
    'set',
    'binary',
];
const customTags = (tags) => [...new Set(t.concat(tags))];
exports.customTags = customTags;
//# sourceMappingURL=index.js.map