import { classTag, error, functionTag, nullobject, regexp, sharedSymbol, symbol, bigint, } from 'yaml-types';
import { date } from './date.js';
import { timestamp } from './timestamp.js';
// prepend our custom tags so that they take priority over anything
// enabled by default in the schema.
const t = [
    regexp,
    sharedSymbol,
    symbol,
    bigint,
    nullobject,
    error,
    classTag,
    functionTag,
    timestamp,
    date,
    'omap',
    'set',
    'binary',
];
export const customTags = (tags) => [...new Set(t.concat(tags))];
//# sourceMappingURL=index.js.map