import React from "react";
import { BlockProps, ColorScalePropType, EventPropTypeInterface, OrientationTypes, PaddingProps, StringOrNumberOrCallback, VictoryCommonProps, VictoryDatableProps, VictorySingleLabelableProps, VictoryStyleInterface, VictoryLabelStyleObject, EventsMixinClass } from "victory-core";
export declare type VictoryLegendTTargetType = "data" | "labels" | "parent";
export declare type VictoryLegendOrientationType = "horizontal" | "vertical";
export interface VictoryLegendProps extends VictoryCommonProps, VictoryDatableProps, VictorySingleLabelableProps {
    borderComponent?: React.ReactElement;
    borderPadding?: PaddingProps;
    centerTitle?: boolean;
    colorScale?: ColorScalePropType;
    dataComponent?: React.ReactElement;
    eventKey?: StringOrNumberOrCallback | string[];
    events?: EventPropTypeInterface<VictoryLegendTTargetType, StringOrNumberOrCallback>[];
    gutter?: number | {
        left: number;
        right: number;
    };
    itemsPerRow?: number;
    orientation?: VictoryLegendOrientationType;
    rowGutter?: number | Omit<BlockProps, "left" | "right">;
    style?: VictoryStyleInterface & {
        title?: VictoryLabelStyleObject | VictoryLabelStyleObject[];
    };
    symbolSpacer?: number;
    title?: string | string[];
    titleComponent?: React.ReactElement;
    titleOrientation?: OrientationTypes;
}
interface VictoryLegendBase extends EventsMixinClass<VictoryLegendProps> {
}
declare class VictoryLegendBase extends React.Component<VictoryLegendProps> {
    static displayName: string;
    static role: string;
    static defaultProps: {
        borderComponent: JSX.Element;
        data: {
            name: string;
        }[];
        containerComponent: JSX.Element;
        dataComponent: JSX.Element;
        groupComponent: JSX.Element;
        labelComponent: JSX.Element;
        standalone: boolean;
        theme: import("victory-core").VictoryThemeDefinition;
        titleComponent: JSX.Element;
    };
    static getBaseProps: (props: VictoryLegendProps) => any;
    static getDimensions: (props: VictoryLegendProps) => {
        height: number;
        width: number;
    };
    static expectedComponents: string[];
    renderChildren(props: VictoryLegendProps): React.ReactElement<any, string | React.JSXElementConstructor<any>>[];
    render(): React.ReactElement;
}
export declare const VictoryLegend: {
    new (props: import("victory-core").EventMixinCommonProps): {
        state: {};
        getEventState: (eventKey: string | number, namespace: string, childType?: string | undefined) => any;
        getScopedEvents: (events: any, namespace: any, childType: any, baseProps: any) => {};
        getEvents: (p: any, target: any, eventKey: any) => any;
        externalMutations: {} | undefined;
        calculatedState: {};
        globalEvents: {};
        prevGlobalEventKeys: string[];
        boundGlobalEvents: {};
        shouldComponentUpdate(nextProps: import("victory-core").EventMixinCommonProps): boolean;
        componentDidMount(): void;
        componentDidUpdate(prevProps: any): void;
        componentWillUnmount(): void;
        addGlobalListener(key: any): void;
        removeGlobalListener(key: any): void;
        getStateChanges(props: any): {};
        applyExternalMutations(props: any, externalMutations: any): void;
        getCalculatedValues(props: any): import("victory-core").EventMixinCalculatedValues;
        getExternalMutations(props: import("victory-core").EventMixinCommonProps): {} | undefined;
        cacheValues(obj: any): void;
        getBaseProps(props: any, getSharedEventState: any): Record<string, object>;
        getAllEvents(props: any): any;
        getComponentProps(component: React.ReactNode, type: string, index: string | number): any;
        renderContainer(component: any, children: any): React.DetailedReactHTMLElement<any, HTMLElement>;
        animateComponent(props: import("victory-core").EventMixinCommonProps, defaultAnimationWhitelist: string[]): React.ReactElement<any, string | React.JSXElementConstructor<any>>;
        renderContinuousData(props: import("victory-core").EventMixinCommonProps): React.DetailedReactHTMLElement<any, HTMLElement>;
        renderData(props: any, shouldRenderDatum?: ((datum: any) => boolean) | undefined): React.DetailedReactHTMLElement<any, HTMLElement>;
        context: unknown;
        setState<K extends never>(state: {} | ((prevState: Readonly<{}>, props: Readonly<import("victory-core").EventMixinCommonProps>) => {} | Pick<{}, K> | null) | Pick<{}, K> | null, callback?: (() => void) | undefined): void;
        forceUpdate(callback?: (() => void) | undefined): void;
        render(): React.ReactNode;
        readonly props: Readonly<import("victory-core").EventMixinCommonProps>;
        refs: {
            [key: string]: React.ReactInstance;
        };
        componentDidCatch?(error: Error, errorInfo: React.ErrorInfo): void;
        getSnapshotBeforeUpdate?(prevProps: Readonly<import("victory-core").EventMixinCommonProps>, prevState: Readonly<{}>): any;
        componentWillMount?(): void;
        UNSAFE_componentWillMount?(): void;
        componentWillReceiveProps?(nextProps: Readonly<import("victory-core").EventMixinCommonProps>, nextContext: any): void;
        UNSAFE_componentWillReceiveProps?(nextProps: Readonly<import("victory-core").EventMixinCommonProps>, nextContext: any): void;
        componentWillUpdate?(nextProps: Readonly<import("victory-core").EventMixinCommonProps>, nextState: Readonly<{}>, nextContext: any): void;
        UNSAFE_componentWillUpdate?(nextProps: Readonly<import("victory-core").EventMixinCommonProps>, nextState: Readonly<{}>, nextContext: any): void;
        componentEvents: import("victory-core/lib/victory-util/events").ComponentEvent[];
        getSharedEventState: (key: string, value: string) => unknown;
        baseProps: Record<string, object>;
        dataKeys: string[];
        hasEvents: unknown;
        events: unknown;
    };
    getBaseProps?(props: import("victory-core").EventMixinCommonProps): Record<string, object>;
    role?: string | undefined;
    expectedComponents?: string[] | undefined;
    getChildren?: ((props: import("victory-core").EventMixinCommonProps, childComponents?: React.ReactNode[] | undefined, calculatedProps?: import("victory-core").EventMixinCommonProps | undefined) => void) | undefined;
    animationWhitelist?: string[] | undefined;
} & typeof VictoryLegendBase;
export {};
//# sourceMappingURL=victory-legend.d.ts.map