"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDimensions = exports.getBaseProps = void 0;

var _range2 = _interopRequireDefault(require("lodash/range"));

var _groupBy2 = _interopRequireDefault(require("lodash/groupBy"));

var _defaults2 = _interopRequireDefault(require("lodash/defaults"));

var _victoryCore = require("victory-core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && iter[Symbol.iterator] != null || iter["@@iterator"] != null) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var getColorScale = function (props) {
  var colorScale = props.colorScale;
  return typeof colorScale === "string" ? _victoryCore.Style.getColorScale(colorScale) : colorScale || [];
};

var getLabelStyles = function (props) {
  var data = props.data,
      style = props.style;
  return data.map(function (datum, index) {
    var baseLabelStyles = (0, _defaults2.default)({}, datum.labels, style.labels);
    return _victoryCore.Helpers.evaluateStyle(baseLabelStyles, {
      datum: datum,
      index: index,
      data: data
    });
  });
};

var getStyles = function (props) {
  var styleObject = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var style = props.style || {};
  var parentStyleProps = {
    height: "100%",
    width: "100%"
  };
  return {
    parent: (0, _defaults2.default)(style.parent, styleObject.parent, parentStyleProps),
    data: (0, _defaults2.default)({}, style.data, styleObject.data),
    labels: (0, _defaults2.default)({}, style.labels, styleObject.labels),
    border: (0, _defaults2.default)({}, style.border, styleObject.border),
    title: (0, _defaults2.default)({}, style.title, styleObject.title)
  };
};

var getCalculatedValues = function (props) {
  var orientation = props.orientation,
      theme = props.theme;
  var defaultStyles = theme && theme.legend && theme.legend.style ? theme.legend.style : {};
  var style = getStyles(props, defaultStyles);
  var colorScale = getColorScale(props);
  var isHorizontal = orientation === "horizontal";

  var borderPadding = _victoryCore.Helpers.getPadding({
    padding: props.borderPadding
  });

  return Object.assign({}, props, {
    style: style,
    isHorizontal: isHorizontal,
    colorScale: colorScale,
    borderPadding: borderPadding
  });
};

var getColumn = function (props, index) {
  var itemsPerRow = props.itemsPerRow,
      isHorizontal = props.isHorizontal;

  if (!itemsPerRow) {
    return isHorizontal ? index : 0;
  }

  return isHorizontal ? index % itemsPerRow : Math.floor(index / itemsPerRow);
};

var getRow = function (props, index) {
  var itemsPerRow = props.itemsPerRow,
      isHorizontal = props.isHorizontal;

  if (!itemsPerRow) {
    return isHorizontal ? 0 : index;
  }

  return isHorizontal ? Math.floor(index / itemsPerRow) : index % itemsPerRow;
};

var groupData = function (props) {
  var data = props.data;
  var style = props.style && props.style.data || {};
  var labelStyles = getLabelStyles(props);
  return data.map(function (datum, index) {
    var symbol = datum.symbol || {};
    var fontSize = labelStyles[index].fontSize; // eslint-disable-next-line no-magic-numbers

    var size = symbol.size || style.size || fontSize / 2.5;
    var symbolSpacer = props.symbolSpacer || Math.max(size, fontSize);
    return _objectSpread(_objectSpread({}, datum), {}, {
      size: size,
      symbolSpacer: symbolSpacer,
      fontSize: fontSize,
      textSize: _victoryCore.TextSize.approximateTextSize(datum.name, labelStyles[index]),
      column: getColumn(props, index),
      row: getRow(props, index)
    });
  });
};

var getColumnWidths = function (props, data) {
  var gutter = props.gutter || {};
  var gutterWidth = typeof gutter === "object" ? (gutter.left || 0) + (gutter.right || 0) : gutter || 0;
  var dataByColumn = (0, _groupBy2.default)(data, "column");
  var columns = Object.keys(dataByColumn);
  return columns.reduce(function (memo, curr, index) {
    var lengths = dataByColumn[curr].map(function (d) {
      return d.textSize.width + d.size + d.symbolSpacer + gutterWidth;
    });
    memo[index] = Math.max.apply(Math, _toConsumableArray(lengths));
    return memo;
  }, []);
};

var getRowHeights = function (props, data) {
  var gutter = props.rowGutter || {};
  var gutterHeight = typeof gutter === "object" ? (gutter.top || 0) + (gutter.bottom || 0) : gutter || 0;
  var dataByRow = (0, _groupBy2.default)(data, "row");
  return Object.keys(dataByRow).reduce(function (memo, curr, index) {
    var rows = dataByRow[curr];
    var lengths = rows.map(function (d) {
      return d.textSize.height + d.symbolSpacer + gutterHeight;
    });
    memo[index] = Math.max.apply(Math, _toConsumableArray(lengths));
    return memo;
  }, []);
};

var getTitleDimensions = function (props) {
  var style = props.style && props.style.title || {};

  var textSize = _victoryCore.TextSize.approximateTextSize(props.title, style);

  var padding = style.padding || 0;
  return {
    height: textSize.height + 2 * padding || 0,
    width: textSize.width + 2 * padding || 0
  };
};

var getOffset = function (datum, rowHeights, columnWidths) {
  var column = datum.column,
      row = datum.row;
  return {
    x: (0, _range2.default)(column).reduce(function (memo, curr) {
      return memo + columnWidths[curr];
    }, 0),
    y: (0, _range2.default)(row).reduce(function (memo, curr) {
      return memo + rowHeights[curr];
    }, 0)
  };
};

var getAnchors = function (titleOrientation, centerTitle) {
  var standardAnchors = {
    textAnchor: titleOrientation === "right" ? "end" : "start",
    verticalAnchor: titleOrientation === "bottom" ? "end" : "start"
  };

  if (centerTitle) {
    var horizontal = titleOrientation === "top" || titleOrientation === "bottom";
    return {
      textAnchor: horizontal ? "middle" : standardAnchors.textAnchor,
      verticalAnchor: horizontal ? standardAnchors.verticalAnchor : "middle"
    };
  }

  return standardAnchors;
};

var getTitleStyle = function (props) {
  var titleOrientation = props.titleOrientation,
      centerTitle = props.centerTitle,
      titleComponent = props.titleComponent;
  var baseStyle = props.style && props.style.title || {};
  var componentStyle = titleComponent.props && titleComponent.props.style || {};
  var anchors = getAnchors(titleOrientation, centerTitle);
  return Array.isArray(componentStyle) ? componentStyle.map(function (obj) {
    return (0, _defaults2.default)({}, obj, baseStyle, anchors);
  }) : (0, _defaults2.default)({}, componentStyle, baseStyle, anchors);
}; // eslint-disable-next-line complexity


var getTitleProps = function (props, borderProps) {
  var title = props.title,
      titleOrientation = props.titleOrientation,
      centerTitle = props.centerTitle,
      borderPadding = props.borderPadding;
  var height = borderProps.height,
      width = borderProps.width;
  var style = getTitleStyle(props);
  var padding = Array.isArray(style) ? style[0].padding : style.padding;
  var horizontal = titleOrientation === "top" || titleOrientation === "bottom";
  var xOrientation = titleOrientation === "bottom" ? "bottom" : "top";
  var yOrientation = titleOrientation === "right" ? "right" : "left";
  var standardPadding = {
    x: centerTitle ? width / 2 : borderPadding[xOrientation] + (padding || 0),
    y: centerTitle ? height / 2 : borderPadding[yOrientation] + (padding || 0)
  };

  var getPadding = function () {
    return borderPadding[titleOrientation] + (padding || 0);
  };

  var xOffset = horizontal ? standardPadding.x : getPadding();
  var yOffset = horizontal ? getPadding() : standardPadding.y;
  return {
    x: titleOrientation === "right" ? props.x + width - xOffset : props.x + xOffset,
    y: titleOrientation === "bottom" ? props.y + height - yOffset : props.y + yOffset,
    style: style,
    text: title
  };
};

var getBorderProps = function (props, contentHeight, contentWidth) {
  var x = props.x,
      y = props.y,
      borderPadding = props.borderPadding,
      style = props.style;
  var height = (contentHeight || 0) + borderPadding.top + borderPadding.bottom;
  var width = (contentWidth || 0) + borderPadding.left + borderPadding.right;
  return {
    x: x,
    y: y,
    height: height,
    width: width,
    style: Object.assign({
      fill: "none"
    }, style.border)
  };
};

var getDimensions = function (initialProps, fallbackProps) {
  var modifiedProps = _victoryCore.Helpers.modifyProps(initialProps, fallbackProps, "legend");

  var props = Object.assign({}, modifiedProps, getCalculatedValues(modifiedProps));
  var title = props.title,
      titleOrientation = props.titleOrientation;
  var groupedData = groupData(props);
  var columnWidths = getColumnWidths(props, groupedData);
  var rowHeights = getRowHeights(props, groupedData);
  var titleDimensions = title ? getTitleDimensions(props) : {
    height: 0,
    width: 0
  };
  return {
    height: titleOrientation === "left" || titleOrientation === "right" ? Math.max(sum(rowHeights), titleDimensions.height) : sum(rowHeights) + titleDimensions.height,
    width: titleOrientation === "left" || titleOrientation === "right" ? sum(columnWidths) + titleDimensions.width : Math.max(sum(columnWidths), titleDimensions.width)
  };
};

exports.getDimensions = getDimensions;

var getBaseProps = function (initialProps, fallbackProps) {
  var modifiedProps = _victoryCore.Helpers.modifyProps(initialProps, fallbackProps, "legend");

  var props = Object.assign({}, modifiedProps, getCalculatedValues(modifiedProps));
  var data = props.data,
      standalone = props.standalone,
      theme = props.theme,
      padding = props.padding,
      style = props.style,
      colorScale = props.colorScale,
      gutter = props.gutter,
      rowGutter = props.rowGutter,
      borderPadding = props.borderPadding,
      title = props.title,
      titleOrientation = props.titleOrientation,
      name = props.name,
      _props$x = props.x,
      x = _props$x === void 0 ? 0 : _props$x,
      _props$y = props.y,
      y = _props$y === void 0 ? 0 : _props$y;
  var groupedData = groupData(props);
  var columnWidths = getColumnWidths(props, groupedData);
  var rowHeights = getRowHeights(props, groupedData);
  var labelStyles = getLabelStyles(props);
  var titleDimensions = title ? getTitleDimensions(props) : {
    height: 0,
    width: 0
  };
  var titleOffset = {
    x: titleOrientation === "left" ? titleDimensions.width : 0,
    y: titleOrientation === "top" ? titleDimensions.height : 0
  };
  var gutterOffset = {
    x: gutter && typeof gutter === "object" ? gutter.left || 0 : 0,
    y: rowGutter && typeof rowGutter === "object" ? rowGutter.top || 0 : 0
  };

  var _getDimensions = getDimensions(props, fallbackProps),
      height = _getDimensions.height,
      width = _getDimensions.width;

  var borderProps = getBorderProps(props, height, width);
  var titleProps = getTitleProps(props, borderProps);
  var initialChildProps = {
    parent: {
      data: data,
      standalone: standalone,
      theme: theme,
      padding: padding,
      name: name,
      height: props.height,
      width: props.width,
      style: style.parent
    },
    all: {
      border: borderProps,
      title: titleProps
    }
  };
  return groupedData.reduce(function (childProps, datum, i) {
    var color = colorScale[i % colorScale.length];
    var dataStyle = (0, _defaults2.default)({}, datum.symbol, style.data, {
      fill: color
    });
    var eventKey = !_victoryCore.Helpers.isNil(datum.eventKey) ? datum.eventKey : i;
    var offset = getOffset(datum, rowHeights, columnWidths);
    var originY = y + borderPadding.top + datum.symbolSpacer;
    var originX = x + borderPadding.left + datum.symbolSpacer;
    var dataProps = {
      index: i,
      data: data,
      datum: datum,
      symbol: dataStyle.type || dataStyle.symbol || "circle",
      size: datum.size,
      style: dataStyle,
      y: originY + offset.y + titleOffset.y + gutterOffset.y,
      x: originX + offset.x + titleOffset.x + gutterOffset.x
    };
    var labelProps = {
      datum: datum,
      data: data,
      text: datum.name,
      style: labelStyles[i],
      y: dataProps.y,
      x: dataProps.x + datum.symbolSpacer + datum.size / 2
    };
    childProps[eventKey] = {
      data: dataProps,
      labels: labelProps
    };
    return childProps;
  }, initialChildProps);
};
/**
 * Computes the sum of the values in `array`.
 * @param {Array} array The array to iterate over.
 * @returns {number} Returns the sum.
 */


exports.getBaseProps = getBaseProps;

function sum(array) {
  if (array && array.length) {
    var value = 0;

    for (var i = 0; i < array.length; i++) {
      value += array[i];
    }

    return value;
  }

  return 0;
}