function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/* eslint no-magic-numbers: ["error", { "ignore": [-1, 0, 1, 2] }]*/
import React from "react";
import { Helpers, Path, LineHelpers, UserProps } from "victory-core";

var evaluateProps = function (props) {
  /**
   * Potential evaluated props are:
   * `ariaLabel`
   * `id`
   * `style`
   * `tabIndex`
   */
  var ariaLabel = Helpers.evaluateProp(props.ariaLabel, props);
  var id = Helpers.evaluateProp(props.id, props);
  var style = Helpers.evaluateStyle(Object.assign({
    fill: "none",
    stroke: "black",
    pointerEvents: "stroke"
  }, props.style), props);
  var tabIndex = Helpers.evaluateProp(props.tabIndex, props);
  return Object.assign({}, props, {
    ariaLabel: ariaLabel,
    id: id,
    style: style,
    tabIndex: tabIndex
  });
};

var defaultProps = {
  pathComponent: /*#__PURE__*/React.createElement(Path, null),
  role: "presentation",
  shapeRendering: "auto"
};
export var Curve = function (initialProps) {
  var props = evaluateProps(_objectSpread(_objectSpread({}, defaultProps), initialProps));
  var userProps = UserProps.getSafeUserProps(props);
  var polar = props.polar,
      origin = props.origin;
  var lineFunction = LineHelpers.getLineFunction(props);
  var defaultTransform = polar && origin ? "translate(".concat(origin.x, ", ").concat(origin.y, ")") : undefined;
  var d = lineFunction(props.data);
  return /*#__PURE__*/React.cloneElement(props.pathComponent, _objectSpread(_objectSpread(_objectSpread({}, props.events), userProps), {}, {
    "aria-label": props.ariaLabel,
    d: d,
    style: props.style,
    transform: props.transform || defaultTransform,
    className: props.className,
    role: props.role,
    shapeRendering: props.shapeRendering,
    clipPath: props.clipPath,
    tabIndex: props.tabIndex
  }));
};