import { Helpers, LabelHelpers, Data, Domain, Scale } from "victory-core";

var getCalculatedValues = function (props) {
  var data = Data.getData(props);

  if (data.length < 2) {
    data = [];
  }

  var range = {
    x: Helpers.getRange(props, "x"),
    y: Helpers.getRange(props, "y")
  };
  var domain = {
    x: Domain.getDomain(props, "x"),
    y: Domain.getDomain(props, "y")
  };
  var scale = {
    x: Scale.getBaseScale(props, "x").domain(domain.x).range(props.horizontal ? range.y : range.x),
    y: Scale.getBaseScale(props, "y").domain(domain.y).range(props.horizontal ? range.x : range.y)
  };
  var origin = props.polar ? props.origin || Helpers.getPolarOrigin(props) : undefined;
  var defaultStyles = Helpers.getDefaultStyles(props, "line");
  var style = Helpers.getStyles(props.style, defaultStyles);
  return {
    domain: domain,
    data: data,
    scale: scale,
    style: style,
    origin: origin
  };
};

export var getBaseProps = function (initialProps, fallbackProps) {
  var modifiedProps = Helpers.modifyProps(initialProps, fallbackProps, "line");
  var props = Object.assign({}, modifiedProps, getCalculatedValues(modifiedProps));
  var data = props.data,
      domain = props.domain,
      events = props.events,
      groupComponent = props.groupComponent,
      height = props.height,
      horizontal = props.horizontal,
      interpolation = props.interpolation,
      origin = props.origin,
      padding = props.padding,
      polar = props.polar,
      scale = props.scale,
      sharedEvents = props.sharedEvents,
      standalone = props.standalone,
      style = props.style,
      theme = props.theme,
      width = props.width,
      labels = props.labels,
      name = props.name,
      disableInlineStyles = props.disableInlineStyles;
  var initialChildProps = {
    parent: {
      style: style.parent,
      scale: scale,
      data: data,
      height: height,
      width: width,
      name: name,
      domain: domain,
      standalone: standalone,
      polar: polar,
      origin: origin,
      padding: padding,
      horizontal: horizontal
    },
    all: {
      data: {
        horizontal: horizontal,
        polar: polar,
        origin: origin,
        scale: scale,
        data: data,
        interpolation: interpolation,
        groupComponent: groupComponent,
        style: disableInlineStyles ? {} : style.data,
        theme: theme,
        disableInlineStyles: disableInlineStyles
      }
    }
  };
  return data.reduce(function (childProps, datum, index) {
    var text = LabelHelpers.getText(props, datum, index);

    if (text !== undefined && text !== null || labels && (events || sharedEvents)) {
      var eventKey = !Helpers.isNil(datum.eventKey) ? datum.eventKey : index;
      childProps[eventKey] = {
        labels: LabelHelpers.getProps(props, index)
      };
    }

    return childProps;
  }, initialChildProps);
};