import React from "react";
import { Data, Domain, EventPropTypeInterface, InterpolationPropType, StringOrNumberOrCallback, VictoryCommonProps, VictoryDatableProps, VictoryMultiLabelableProps, VictoryLabelableProps, VictoryStyleInterface, EventsMixinClass } from "victory-core";
interface VictoryLineBase extends EventsMixinClass<VictoryLineProps> {
}
declare class VictoryLineBase extends React.Component<VictoryLineProps> {
    constructor(props: any);
    static animationWhitelist: string[];
    static displayName: string;
    static role: string;
    static defaultTransitions: import("victory-core").AnimatePropTypeInterface;
    static defaultPolarTransitions: import("victory-core").AnimatePropTypeInterface;
    static continuous: boolean;
    static defaultProps: VictoryLineProps;
    static getDomain: typeof Domain.getDomain;
    static getData: typeof Data.getData;
    static getBaseProps: (props: any) => any;
    static expectedComponents: string[];
    shouldAnimate(): boolean;
    render(): React.ReactElement<any, string | React.JSXElementConstructor<any>>;
}
export declare const VictoryLine: {
    new (props: import("victory-core").EventMixinCommonProps): {
        state: {};
        getEventState: (eventKey: string | number, namespace: string, childType?: string | undefined) => any;
        getScopedEvents: (events: any, namespace: any, childType: any, baseProps: any) => {};
        getEvents: (p: any, target: any, eventKey: any) => any;
        externalMutations: {} | undefined;
        calculatedState: {};
        globalEvents: {};
        prevGlobalEventKeys: string[];
        boundGlobalEvents: {};
        shouldComponentUpdate(nextProps: import("victory-core").EventMixinCommonProps): boolean;
        componentDidMount(): void;
        componentDidUpdate(prevProps: any): void;
        componentWillUnmount(): void;
        addGlobalListener(key: any): void;
        removeGlobalListener(key: any): void;
        getStateChanges(props: any): {};
        applyExternalMutations(props: any, externalMutations: any): void;
        getCalculatedValues(props: any): import("victory-core").EventMixinCalculatedValues;
        getExternalMutations(props: import("victory-core").EventMixinCommonProps): {} | undefined;
        cacheValues(obj: any): void;
        getBaseProps(props: any, getSharedEventState: any): Record<string, object>;
        getAllEvents(props: any): any;
        getComponentProps(component: React.ReactNode, type: string, index: string | number): any;
        renderContainer(component: any, children: any): React.DetailedReactHTMLElement<any, HTMLElement>;
        animateComponent(props: import("victory-core").EventMixinCommonProps, defaultAnimationWhitelist: string[]): React.ReactElement<any, string | React.JSXElementConstructor<any>>;
        renderContinuousData(props: import("victory-core").EventMixinCommonProps): React.DetailedReactHTMLElement<any, HTMLElement>;
        renderData(props: any, shouldRenderDatum?: ((datum: any) => boolean) | undefined): React.DetailedReactHTMLElement<any, HTMLElement>;
        context: unknown;
        setState<K extends never>(state: {} | ((prevState: Readonly<{}>, props: Readonly<import("victory-core").EventMixinCommonProps>) => {} | Pick<{}, K> | null) | Pick<{}, K> | null, callback?: (() => void) | undefined): void;
        forceUpdate(callback?: (() => void) | undefined): void;
        render(): React.ReactNode;
        readonly props: Readonly<import("victory-core").EventMixinCommonProps>;
        refs: {
            [key: string]: React.ReactInstance;
        };
        componentDidCatch?(error: Error, errorInfo: React.ErrorInfo): void;
        getSnapshotBeforeUpdate?(prevProps: Readonly<import("victory-core").EventMixinCommonProps>, prevState: Readonly<{}>): any;
        componentWillMount?(): void;
        UNSAFE_componentWillMount?(): void;
        componentWillReceiveProps?(nextProps: Readonly<import("victory-core").EventMixinCommonProps>, nextContext: any): void;
        UNSAFE_componentWillReceiveProps?(nextProps: Readonly<import("victory-core").EventMixinCommonProps>, nextContext: any): void;
        componentWillUpdate?(nextProps: Readonly<import("victory-core").EventMixinCommonProps>, nextState: Readonly<{}>, nextContext: any): void;
        UNSAFE_componentWillUpdate?(nextProps: Readonly<import("victory-core").EventMixinCommonProps>, nextState: Readonly<{}>, nextContext: any): void;
        componentEvents: import("victory-core/lib/victory-util/events").ComponentEvent[];
        getSharedEventState: (key: string, value: string) => unknown;
        baseProps: Record<string, object>;
        dataKeys: string[];
        hasEvents: unknown;
        events: unknown;
    };
    getBaseProps?(props: import("victory-core").EventMixinCommonProps): Record<string, object>;
    role?: string | undefined;
    expectedComponents?: string[] | undefined;
    getChildren?: ((props: import("victory-core").EventMixinCommonProps, childComponents?: React.ReactNode[] | undefined, calculatedProps?: import("victory-core").EventMixinCommonProps | undefined) => void) | undefined;
    animationWhitelist?: string[] | undefined;
} & typeof VictoryLineBase;
export declare type VictoryLineTTargetType = "data" | "labels" | "parent";
export interface VictoryLineProps extends VictoryCommonProps, VictoryDatableProps, VictoryLabelableProps, VictoryMultiLabelableProps {
    events?: EventPropTypeInterface<VictoryLineTTargetType, number | string>[];
    eventKey?: StringOrNumberOrCallback | string[];
    interpolation?: InterpolationPropType | Function;
    samples?: number;
    style?: VictoryStyleInterface;
}
export {};
//# sourceMappingURL=victory-line.d.ts.map