"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Curve = void 0;

var _react = _interopRequireDefault(require("react"));

var _victoryCore = require("victory-core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var evaluateProps = function (props) {
  /**
   * Potential evaluated props are:
   * `ariaLabel`
   * `id`
   * `style`
   * `tabIndex`
   */
  var ariaLabel = _victoryCore.Helpers.evaluateProp(props.ariaLabel, props);

  var id = _victoryCore.Helpers.evaluateProp(props.id, props);

  var style = _victoryCore.Helpers.evaluateStyle(Object.assign({
    fill: "none",
    stroke: "black",
    pointerEvents: "stroke"
  }, props.style), props);

  var tabIndex = _victoryCore.Helpers.evaluateProp(props.tabIndex, props);

  return Object.assign({}, props, {
    ariaLabel: ariaLabel,
    id: id,
    style: style,
    tabIndex: tabIndex
  });
};

var defaultProps = {
  pathComponent: /*#__PURE__*/_react.default.createElement(_victoryCore.Path, null),
  role: "presentation",
  shapeRendering: "auto"
};

var Curve = function (initialProps) {
  var props = evaluateProps(_objectSpread(_objectSpread({}, defaultProps), initialProps));

  var userProps = _victoryCore.UserProps.getSafeUserProps(props);

  var polar = props.polar,
      origin = props.origin;

  var lineFunction = _victoryCore.LineHelpers.getLineFunction(props);

  var defaultTransform = polar && origin ? "translate(".concat(origin.x, ", ").concat(origin.y, ")") : undefined;
  var d = lineFunction(props.data);
  return /*#__PURE__*/_react.default.cloneElement(props.pathComponent, _objectSpread(_objectSpread(_objectSpread({}, props.events), userProps), {}, {
    "aria-label": props.ariaLabel,
    d: d,
    style: props.style,
    transform: props.transform || defaultTransform,
    className: props.className,
    role: props.role,
    shapeRendering: props.shapeRendering,
    clipPath: props.clipPath,
    tabIndex: props.tabIndex
  }));
};

exports.Curve = Curve;