import React from "react";
import { Axis, EventsMixinClass } from "victory-core";
import { VictoryPolarAxisProps } from "./types";
interface VictoryPolarAxisBase extends EventsMixinClass<VictoryPolarAxisProps> {
}
declare class VictoryPolarAxisBase extends React.Component<VictoryPolarAxisProps> {
    static animationWhitelist: string[];
    static displayName: string;
    static role: string;
    static defaultTransitions: {
        onExit: {
            duration: number;
        };
        onEnter: {
            duration: number;
        };
    };
    static defaultProps: VictoryPolarAxisProps;
    static getDomain: typeof Axis.getDomain;
    static getAxis: typeof Axis.getAxis;
    static getScale: (props: VictoryPolarAxisProps) => import("victory-core").D3Scale<any>;
    static getStyles: (props: any) => {
        parent?: undefined;
        axis?: undefined;
        axisLabel?: undefined;
        grid?: undefined;
        ticks?: undefined;
        tickLabels?: undefined;
    } | {
        parent: import("victory-core").VictoryStyleObject & {
            height: string;
            width: string;
        };
        axis: import("victory-core").VictoryStyleObject;
        axisLabel: import("victory-core").VictoryLabelStyleObject | import("victory-core").VictoryLabelStyleObject[];
        grid: import("victory-core").VictoryStyleObject;
        ticks: import("victory-core").VictoryTickStyleObject;
        tickLabels: import("victory-core").VictoryLabelStyleObject | import("victory-core").VictoryLabelStyleObject[];
    };
    static getBaseProps: (props: any) => any;
    static expectedComponents: string[];
    renderAxisLine(props: VictoryPolarAxisProps): React.ReactElement<any, string | React.JSXElementConstructor<any>>;
    renderLabel(props: VictoryPolarAxisProps): React.ReactElement<any, string | React.JSXElementConstructor<any>> | null;
    renderAxis(props: VictoryPolarAxisProps): React.ReactElement<any, string | React.JSXElementConstructor<any>>;
    renderGroup(props: VictoryPolarAxisProps, children: React.ReactNode): React.ReactElement<any, string | React.JSXElementConstructor<any>>;
    shouldAnimate(): boolean;
    render(): React.ReactElement;
}
export declare const VictoryPolarAxis: {
    new (props: import("victory-core").EventMixinCommonProps): {
        state: {};
        getEventState: (eventKey: string | number, namespace: string, childType?: string | undefined) => any;
        getScopedEvents: (events: any, namespace: any, childType: any, baseProps: any) => {};
        getEvents: (p: any, target: any, eventKey: any) => any;
        externalMutations: {} | undefined;
        calculatedState: {};
        globalEvents: {};
        prevGlobalEventKeys: string[];
        boundGlobalEvents: {};
        shouldComponentUpdate(nextProps: import("victory-core").EventMixinCommonProps): boolean;
        componentDidMount(): void;
        componentDidUpdate(prevProps: any): void;
        componentWillUnmount(): void;
        addGlobalListener(key: any): void;
        removeGlobalListener(key: any): void;
        getStateChanges(props: any): {};
        applyExternalMutations(props: any, externalMutations: any): void;
        getCalculatedValues(props: any): import("victory-core").EventMixinCalculatedValues;
        getExternalMutations(props: import("victory-core").EventMixinCommonProps): {} | undefined;
        cacheValues(obj: any): void;
        getBaseProps(props: any, getSharedEventState: any): Record<string, object>;
        getAllEvents(props: any): any;
        getComponentProps(component: React.ReactNode, type: string, index: string | number): any;
        renderContainer(component: any, children: any): React.DetailedReactHTMLElement<any, HTMLElement>;
        animateComponent(props: import("victory-core").EventMixinCommonProps, defaultAnimationWhitelist: string[]): React.ReactElement<any, string | React.JSXElementConstructor<any>>;
        renderContinuousData(props: import("victory-core").EventMixinCommonProps): React.DetailedReactHTMLElement<any, HTMLElement>;
        renderData(props: any, shouldRenderDatum?: ((datum: any) => boolean) | undefined): React.DetailedReactHTMLElement<any, HTMLElement>;
        context: unknown;
        setState<K extends never>(state: {} | ((prevState: Readonly<{}>, props: Readonly<import("victory-core").EventMixinCommonProps>) => {} | Pick<{}, K> | null) | Pick<{}, K> | null, callback?: (() => void) | undefined): void;
        forceUpdate(callback?: (() => void) | undefined): void;
        render(): React.ReactNode;
        readonly props: Readonly<import("victory-core").EventMixinCommonProps>;
        refs: {
            [key: string]: React.ReactInstance;
        };
        componentDidCatch?(error: Error, errorInfo: React.ErrorInfo): void;
        getSnapshotBeforeUpdate?(prevProps: Readonly<import("victory-core").EventMixinCommonProps>, prevState: Readonly<{}>): any;
        componentWillMount?(): void;
        UNSAFE_componentWillMount?(): void;
        componentWillReceiveProps?(nextProps: Readonly<import("victory-core").EventMixinCommonProps>, nextContext: any): void;
        UNSAFE_componentWillReceiveProps?(nextProps: Readonly<import("victory-core").EventMixinCommonProps>, nextContext: any): void;
        componentWillUpdate?(nextProps: Readonly<import("victory-core").EventMixinCommonProps>, nextState: Readonly<{}>, nextContext: any): void;
        UNSAFE_componentWillUpdate?(nextProps: Readonly<import("victory-core").EventMixinCommonProps>, nextState: Readonly<{}>, nextContext: any): void;
        componentEvents: import("victory-core/lib/victory-util/events").ComponentEvent[];
        getSharedEventState: (key: string, value: string) => unknown;
        baseProps: Record<string, object>;
        dataKeys: string[];
        hasEvents: unknown;
        events: unknown;
    };
    getBaseProps?(props: import("victory-core").EventMixinCommonProps): Record<string, object>;
    role?: string | undefined;
    expectedComponents?: string[] | undefined;
    getChildren?: ((props: import("victory-core").EventMixinCommonProps, childComponents?: React.ReactNode[] | undefined, calculatedProps?: import("victory-core").EventMixinCommonProps | undefined) => void) | undefined;
    animationWhitelist?: string[] | undefined;
} & typeof VictoryPolarAxisBase;
export {};
//# sourceMappingURL=victory-polar-axis.d.ts.map