/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.dbunit.ext.postgresql;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;
import org.postgresql.util.PGobject;

public class MoneyDataType
extends AbstractDataType {
    public static final DataType MONEY = new MoneyDataType();

    public MoneyDataType() {
        super("money", 1111, Double.class, true);
    }

    public Object typeCast(Object value) throws TypeCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof Double || value instanceof Float) {
            return value;
        }
        if (value instanceof String) {
            return value;
        }
        throw new TypeCastException(value, (DataType)this);
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        return resultSet.getDouble(column);
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        PGobject pgObject = new PGobject();
        pgObject.setType("money");
        if (value == null) {
            pgObject.setValue(null);
        } else {
            pgObject.setValue(value.toString());
        }
        statement.setObject(column, pgObject);
    }
}

