/*
 * Decompiled with CFR 0.152.
 */
package org.mvnsearch.dbunit.ext.postgresql;

import com.pgvector.PGvector;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.dbunit.dataset.datatype.AbstractDataType;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.TypeCastException;

public class VectorType
extends AbstractDataType {
    public static final DataType VECTOR = new VectorType();

    public VectorType() {
        super("vector", 1111, PGvector.class, false);
    }

    public Object typeCast(Object value) throws TypeCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof PGvector) {
            return value;
        }
        if (value instanceof String) {
            try {
                return new PGvector((String)value);
            }
            catch (SQLException e) {
                throw new TypeCastException((Throwable)e);
            }
        }
        throw new TypeCastException(value, (DataType)this);
    }

    public Object getSqlValue(int column, ResultSet resultSet) throws SQLException, TypeCastException {
        return resultSet.getString(column);
    }

    public void setSqlValue(Object value, int column, PreparedStatement statement) throws SQLException, TypeCastException {
        if (value == null) {
            statement.setObject(column, null);
        } else {
            PGvector pgVector = new PGvector(value.toString());
            statement.setObject(column, pgVector);
        }
    }
}

