/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.dotenv;

import io.github.cdimascio.dotenv.Dotenv;
import io.github.cdimascio.dotenv.DotenvBuilder;
import io.github.cdimascio.dotenv.DotenvEntry;
import io.github.cdimascio.dotenv.DotenvException;
import io.github.cdimascio.dotenv.internal.DotenvParser;
import io.github.cdimascio.dotenv.internal.DotenvReader;
import io.github.cdimascio.ecies.Ecies;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;

public class DotenvxBuilder
extends DotenvBuilder {
    private String privateKeyHex = null;
    private String filename = ".env";
    private String directoryPath = "./";
    private boolean systemProperties = false;
    private boolean throwIfMissing = true;
    private boolean throwIfMalformed = true;

    public DotenvxBuilder directory(String path) {
        this.directoryPath = path;
        return this;
    }

    public DotenvxBuilder filename(String name) {
        this.filename = name;
        return this;
    }

    public DotenvxBuilder ignoreIfMissing() {
        this.throwIfMissing = false;
        return this;
    }

    public DotenvxBuilder ignoreIfMalformed() {
        this.throwIfMalformed = false;
        return this;
    }

    public DotenvxBuilder systemProperties() {
        this.systemProperties = true;
        return this;
    }

    public DotenvxBuilder privateKey(String privateKeyHex) {
        this.privateKeyHex = privateKeyHex;
        return this;
    }

    public Dotenv load() throws DotenvException {
        DotenvParser parser = new DotenvParser(new DotenvReader(this.directoryPath, this.filename), this.throwIfMissing, this.throwIfMalformed);
        ArrayList<DotenvEntry> entries = parser.parse();
        boolean isEncrypted = entries.stream().anyMatch(entry -> entry.getValue().startsWith("encrypted:"));
        if (isEncrypted) {
            String privateKey = this.getDotenvxPrivateKey();
            if (privateKey == null || privateKey.isEmpty()) {
                throw new DotenvException("No DOTENV_PRIVATE_KEY found in environment variables or .env.keys file.");
            }
            ArrayList<DotenvEntry> decryptedEntries = new ArrayList<DotenvEntry>();
            for (DotenvEntry entry2 : entries) {
                if (entry2.getValue().startsWith("encrypted:")) {
                    String encryptedText = entry2.getValue().substring(10);
                    decryptedEntries.add(new DotenvEntry(entry2.getKey(), this.decryptItem(privateKey, encryptedText)));
                    continue;
                }
                decryptedEntries.add(entry2);
            }
            entries = decryptedEntries;
        }
        if (this.systemProperties) {
            entries.forEach(it -> System.setProperty(it.getKey(), it.getValue()));
        }
        return new DotenvBuilder.DotenvImpl((List)entries);
    }

    private String getDotenvxPrivateKey() {
        if (this.privateKeyHex != null && !this.privateKeyHex.isEmpty()) {
            return this.privateKeyHex;
        }
        String privateKey = System.getenv("DOTENV_PRIVATE_KEY");
        if (privateKey == null || privateKey.isEmpty()) {
            if (Files.exists(Paths.get(".env.keys", new String[0]), new LinkOption[0])) {
                Dotenv keysEnv = Dotenv.configure().filename(".env.keys").load();
                privateKey = keysEnv.get("DOTENV_PRIVATE_KEY");
            } else if (Files.exists(Paths.get(System.getProperty("user.home"), ".env.keys"), new LinkOption[0])) {
                Dotenv keysEnv = Dotenv.configure().directory(System.getProperty("user.home")).filename(".env.keys").load();
                privateKey = keysEnv.get("DOTENV_PRIVATE_KEY");
            }
        }
        this.privateKeyHex = privateKey;
        return this.privateKeyHex;
    }

    private String decryptItem(String privateKeyHex, String item) throws DotenvException {
        try {
            return Ecies.decrypt(privateKeyHex, item);
        }
        catch (Exception e) {
            throw new DotenvException("Failed to decrypt item: " + item);
        }
    }
}

