/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.dotenv;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.cdimascio.dotenv.Dotenv;
import io.github.cdimascio.dotenv.DotenvBuilder;
import io.github.cdimascio.dotenv.DotenvEntry;
import io.github.cdimascio.dotenv.DotenvException;
import io.github.cdimascio.dotenv.internal.DotenvParser;
import io.github.cdimascio.dotenv.internal.DotenvReader;
import io.github.cdimascio.ecies.Ecies;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DotenvxBuilder
extends DotenvBuilder {
    public static final ObjectMapper objectMapper = new ObjectMapper();
    private String privateKeyHex = null;
    private String filename = ".env";
    private String directoryPath = "./";
    private boolean systemProperties = false;
    private boolean throwIfMissing = true;
    private boolean throwIfMalformed = true;

    public DotenvxBuilder directory(String path) {
        this.directoryPath = path;
        return this;
    }

    public DotenvxBuilder filename(String name) {
        this.filename = name;
        return this;
    }

    public DotenvxBuilder ignoreIfMissing() {
        this.throwIfMissing = false;
        return this;
    }

    public DotenvxBuilder ignoreIfMalformed() {
        this.throwIfMalformed = false;
        return this;
    }

    public DotenvxBuilder systemProperties() {
        this.systemProperties = true;
        return this;
    }

    public DotenvxBuilder privateKey(String privateKeyHex) {
        this.privateKeyHex = privateKeyHex;
        return this;
    }

    public Dotenv load() throws DotenvException {
        boolean isEncrypted;
        DotenvParser parser = new DotenvParser(new DotenvReader(this.directoryPath, this.filename), this.throwIfMissing, this.throwIfMalformed);
        ArrayList<DotenvEntry> entries = parser.parse();
        String publicKeyHex = this.getPublicKeyHex((List<DotenvEntry>)entries);
        String profileName = null;
        if (this.filename.contains(".env.")) {
            profileName = this.filename.substring(this.filename.indexOf(".env.") + 5);
        }
        if (isEncrypted = entries.stream().anyMatch(entry -> entry.getValue().startsWith("encrypted:"))) {
            String privateKey = this.getDotenvxPrivateKey(profileName, publicKeyHex);
            if (privateKey == null || privateKey.isEmpty()) {
                throw new DotenvException("No DOTENV_PRIVATE_KEY found in environment variables or .env.keys file.");
            }
            ArrayList<DotenvEntry> decryptedEntries = new ArrayList<DotenvEntry>();
            for (DotenvEntry entry2 : entries) {
                if (entry2.getValue().startsWith("encrypted:")) {
                    String encryptedText = entry2.getValue().substring(10);
                    decryptedEntries.add(new DotenvEntry(entry2.getKey(), this.decryptItem(privateKey, encryptedText)));
                    continue;
                }
                decryptedEntries.add(entry2);
            }
            entries = decryptedEntries;
        }
        if (this.systemProperties) {
            entries.forEach(it -> System.setProperty(it.getKey(), it.getValue()));
        }
        return new DotenvBuilder.DotenvImpl((List)entries);
    }

    public String getPublicKeyHex(List<DotenvEntry> entries) {
        for (DotenvEntry entry : entries) {
            String key = entry.getKey();
            if (!key.startsWith("DOTENV_PUBLIC_KEY")) continue;
            return entry.getValue();
        }
        return null;
    }

    public String getDotenvxPrivateKey(String profileName, String publicKeyHex) {
        String privateKey;
        Path globalFileStore;
        if (this.privateKeyHex != null && !this.privateKeyHex.isEmpty()) {
            return this.privateKeyHex;
        }
        if (publicKeyHex != null && !publicKeyHex.isEmpty() && Files.exists(globalFileStore = Paths.get(System.getProperty("user.home"), ".dotenvx", ".env.keys.json"), new LinkOption[0])) {
            try {
                Object keyPair;
                Map globalStore = (Map)objectMapper.readValue(globalFileStore.toFile(), Map.class);
                if (globalStore.containsKey(publicKeyHex) && (keyPair = globalStore.get(publicKeyHex)) instanceof Map) {
                    Map keyPairMap = (Map)keyPair;
                    this.privateKeyHex = keyPairMap.get("private_key").toString();
                    return this.privateKeyHex;
                }
            }
            catch (Exception globalStore) {
                // empty catch block
            }
        }
        Object privateKeyEnvName = "DOTENV_PRIVATE_KEY";
        if (profileName != null && !profileName.isEmpty()) {
            privateKeyEnvName = "DOTENV_PRIVATE_KEY_" + profileName.toUpperCase();
        }
        if ((privateKey = System.getenv((String)privateKeyEnvName)) == null || privateKey.isEmpty()) {
            Dotenv keysEnv;
            if (this.directoryPath != null && Files.exists(Paths.get(this.directoryPath, ".env.keys"), new LinkOption[0])) {
                keysEnv = Dotenv.configure().directory(this.directoryPath).filename(".env.keys").load();
                privateKey = keysEnv.get((String)privateKeyEnvName);
            } else if (Files.exists(Paths.get(".env.keys", new String[0]), new LinkOption[0])) {
                keysEnv = Dotenv.configure().filename(".env.keys").load();
                privateKey = keysEnv.get((String)privateKeyEnvName);
            } else if (Files.exists(Paths.get(System.getProperty("user.home"), ".env.keys"), new LinkOption[0])) {
                keysEnv = Dotenv.configure().directory(System.getProperty("user.home")).filename(".env.keys").load();
                privateKey = keysEnv.get((String)privateKeyEnvName);
            }
        }
        this.privateKeyHex = privateKey;
        return this.privateKeyHex;
    }

    private String decryptItem(String privateKeyHex, String item) throws DotenvException {
        try {
            return Ecies.decrypt(privateKeyHex, item);
        }
        catch (Exception e) {
            throw new DotenvException("Failed to decrypt item: " + item);
        }
    }
}

