/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.ecies;

import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.util.encoders.Hex;

public final class ECKeyPair {
    private final ECPrivateKey privateKey;
    private final ECPublicKey publicKey;

    public ECKeyPair(ECPublicKey publicKey, ECPrivateKey privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public ECPublicKey getPublic() {
        return this.publicKey;
    }

    public ECPrivateKey getPrivate() {
        return this.privateKey;
    }

    public byte[] getPublicBinary(boolean encoded) {
        return this.publicKey.getQ().getEncoded(encoded);
    }

    public byte[] getPrivateBinary() {
        return this.privateKey.getD().toByteArray();
    }

    public String getPublicHex(boolean encoded) {
        return Hex.toHexString((byte[])this.getPublicBinary(encoded));
    }

    public String getPrivateHex() {
        return Hex.toHexString((byte[])this.getPrivateBinary());
    }
}

