/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.ecies;

import io.github.cdimascio.ecies.ECKeyPair;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.modes.GCMModeCipher;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.ECPointUtil;
import org.bouncycastle.jce.interfaces.ECPrivateKey;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;

public class Ecies {
    private static final String CURVE_NAME = "secp256k1";
    private static final int UNCOMPRESSED_PUBLIC_KEY_SIZE = 65;
    private static final int AES_IV_LENGTH = 16;
    private static final int AES_TAG_LENGTH = 16;
    private static final int AES_IV_PLUS_TAG_LENGTH = 32;
    private static final int SECRET_KEY_LENGTH = 32;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();
    private static final BouncyCastleProvider BOUNCY_CASTLE_PROVIDER = new BouncyCastleProvider();

    public static ECKeyPair generateEcKeyPair() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)CURVE_NAME);
        KeyPairGenerator g = KeyPairGenerator.getInstance("EC", (Provider)BOUNCY_CASTLE_PROVIDER);
        g.initialize((AlgorithmParameterSpec)ecSpec, SECURE_RANDOM);
        KeyPair keyPair = g.generateKeyPair();
        return new ECKeyPair((ECPublicKey)keyPair.getPublic(), (ECPrivateKey)keyPair.getPrivate());
    }

    public static String encrypt(String publicKeyHex, String message) throws InvalidCipherTextException, InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] publicKey = Hex.decode((String)publicKeyHex);
        byte[] encrypt = Ecies.encrypt(publicKey, message.getBytes(StandardCharsets.UTF_8));
        return Base64.toBase64String((byte[])encrypt);
    }

    public static String decrypt(String privateKeyHex, String ciphertext) throws InvalidCipherTextException, NoSuchAlgorithmException, InvalidKeySpecException {
        byte[] privateKey = Hex.decode((String)privateKeyHex);
        byte[] cipherBytes = Base64.decode((String)ciphertext);
        return new String(Ecies.decrypt(privateKey, cipherBytes), StandardCharsets.UTF_8);
    }

    public static byte[] encrypt(byte[] publicKeyBytes, byte[] message) throws InvalidAlgorithmParameterException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidCipherTextException {
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)CURVE_NAME);
        KeyPair pair = Ecies.generateEphemeralKey(ecSpec);
        ECPrivateKey ephemeralPrivateKey = (ECPrivateKey)pair.getPrivate();
        ECPublicKey ephemeralPublicKey = (ECPublicKey)pair.getPublic();
        KeyFactory keyFactory = Ecies.getKeyFactory();
        ECNamedCurveSpec curvedParams = new ECNamedCurveSpec(CURVE_NAME, ecSpec.getCurve(), ecSpec.getG(), ecSpec.getN());
        ECPublicKey publicKey = Ecies.getEcPublicKey(curvedParams, publicKeyBytes, keyFactory);
        byte[] uncompressed = ephemeralPublicKey.getQ().getEncoded(false);
        byte[] multiply = publicKey.getQ().multiply(ephemeralPrivateKey.getD()).getEncoded(false);
        byte[] aesKey = Ecies.hkdf(uncompressed, multiply);
        return Ecies.aesEncrypt(message, ephemeralPublicKey, aesKey);
    }

    public static byte[] decrypt(byte[] privateKeyBytes, byte[] cipherBytes) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidCipherTextException {
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)CURVE_NAME);
        KeyFactory keyFactory = Ecies.getKeyFactory();
        ECNamedCurveSpec curvedParams = new ECNamedCurveSpec(CURVE_NAME, ecSpec.getCurve(), ecSpec.getG(), ecSpec.getN());
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(new BigInteger(1, privateKeyBytes), (ECParameterSpec)curvedParams);
        ECPrivateKey receiverPrivateKey = (ECPrivateKey)keyFactory.generatePrivate(privateKeySpec);
        byte[] senderPubKeyByte = java.util.Arrays.copyOf(cipherBytes, 65);
        ECPublicKey senderPubKey = Ecies.getEcPublicKey(curvedParams, senderPubKeyByte, keyFactory);
        byte[] uncompressed = senderPubKey.getQ().getEncoded(false);
        byte[] multiply = senderPubKey.getQ().multiply(receiverPrivateKey.getD()).getEncoded(false);
        byte[] aesKey = Ecies.hkdf(uncompressed, multiply);
        return Ecies.aesDecrypt(cipherBytes, aesKey);
    }

    private static KeyFactory getKeyFactory() throws NoSuchAlgorithmException {
        return KeyFactory.getInstance("EC", (Provider)BOUNCY_CASTLE_PROVIDER);
    }

    private static byte[] aesEncrypt(byte[] message, ECPublicKey ephemeralPubKey, byte[] aesKey) throws InvalidCipherTextException {
        GCMModeCipher aesGcmBlockCipher = GCMBlockCipher.newInstance((BlockCipher)AESEngine.newInstance());
        byte[] nonce = new byte[16];
        SECURE_RANDOM.nextBytes(nonce);
        ParametersWithIV parametersWithIV = new ParametersWithIV((CipherParameters)new KeyParameter(aesKey), nonce);
        aesGcmBlockCipher.init(true, (CipherParameters)parametersWithIV);
        int outputSize = aesGcmBlockCipher.getOutputSize(message.length);
        byte[] encrypted = new byte[outputSize];
        int pos = aesGcmBlockCipher.processBytes(message, 0, message.length, encrypted, 0);
        aesGcmBlockCipher.doFinal(encrypted, pos);
        byte[] tag = java.util.Arrays.copyOfRange(encrypted, encrypted.length - nonce.length, encrypted.length);
        encrypted = java.util.Arrays.copyOfRange(encrypted, 0, encrypted.length - tag.length);
        byte[] ephemeralPkUncompressed = ephemeralPubKey.getQ().getEncoded(false);
        return Arrays.concatenate((byte[])ephemeralPkUncompressed, (byte[])nonce, (byte[])tag, (byte[])encrypted);
    }

    private static KeyPair generateEphemeralKey(ECNamedCurveParameterSpec ecSpec) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        KeyPairGenerator g = KeyPairGenerator.getInstance("EC", (Provider)BOUNCY_CASTLE_PROVIDER);
        g.initialize((AlgorithmParameterSpec)ecSpec, SECURE_RANDOM);
        return g.generateKeyPair();
    }

    private static byte[] aesDecrypt(byte[] inputBytes, byte[] aesKey) throws InvalidCipherTextException {
        byte[] encrypted = java.util.Arrays.copyOfRange(inputBytes, 65, inputBytes.length);
        byte[] nonce = java.util.Arrays.copyOf(encrypted, 16);
        byte[] tag = java.util.Arrays.copyOfRange(encrypted, 16, 32);
        byte[] ciphered = java.util.Arrays.copyOfRange(encrypted, 32, encrypted.length);
        GCMModeCipher aesGcmBlockCipher = GCMBlockCipher.newInstance((BlockCipher)AESEngine.newInstance());
        ParametersWithIV parametersWithIV = new ParametersWithIV((CipherParameters)new KeyParameter(aesKey), nonce);
        aesGcmBlockCipher.init(false, (CipherParameters)parametersWithIV);
        int outputSize = aesGcmBlockCipher.getOutputSize(ciphered.length + tag.length);
        byte[] decrypted = new byte[outputSize];
        int pos = aesGcmBlockCipher.processBytes(ciphered, 0, ciphered.length, decrypted, 0);
        pos += aesGcmBlockCipher.processBytes(tag, 0, tag.length, decrypted, pos);
        aesGcmBlockCipher.doFinal(decrypted, pos);
        return decrypted;
    }

    private static byte[] hkdf(byte[] uncompressed, byte[] multiply) {
        byte[] master = Arrays.concatenate((byte[])uncompressed, (byte[])multiply);
        HKDFBytesGenerator hkdfBytesGenerator = new HKDFBytesGenerator((Digest)new SHA256Digest());
        hkdfBytesGenerator.init((DerivationParameters)new HKDFParameters(master, null, null));
        byte[] aesKey = new byte[32];
        hkdfBytesGenerator.generateBytes(aesKey, 0, aesKey.length);
        return aesKey;
    }

    private static ECPublicKey getEcPublicKey(ECNamedCurveSpec curvedParams, byte[] senderPubKeyByte, KeyFactory keyFactory) throws InvalidKeySpecException {
        ECPoint point = ECPointUtil.decodePoint((EllipticCurve)curvedParams.getCurve(), (byte[])senderPubKeyByte);
        ECPublicKeySpec pubKeySpec = new ECPublicKeySpec(point, (ECParameterSpec)curvedParams);
        return (ECPublicKey)keyFactory.generatePublic(pubKeySpec);
    }
}

