/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.dotenv;

import io.github.cdimascio.dotenv.Dotenv;
import io.github.cdimascio.dotenv.DotenvEntry;
import io.github.cdimascio.dotenv.Dotenvx;
import io.github.cdimascio.dotenv.DotenvxBuilder;
import io.github.cdimascio.dotenv.DotenvxPropertiesBuilder;
import jakarta.config.Loader;
import jakarta.config.TypeToken;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.RecordComponent;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;

public class DotenvxLoader
implements Loader {
    private String configFilePath;
    private String extName;

    public <T> T load(Class<T> clazz) {
        if (clazz == Loader.class) {
            return (T)this;
        }
        try {
            Map<String, String> entries = this.entries();
            if (clazz.isInterface()) {
                Class[] interfaces = new Class[]{clazz};
                return (T)Proxy.newProxyInstance(clazz.getClassLoader(), interfaces, (InvocationHandler)new DotenvxJakartaConfigInvocationHandler(entries));
            }
            if (clazz.isRecord()) {
                RecordComponent[] components = clazz.getRecordComponents();
                Class[] componentTypes = new Class[components.length];
                Object[] args = new Object[components.length];
                for (int i = 0; i < components.length; ++i) {
                    String fieldName = components[i].getName();
                    componentTypes[i] = components[i].getType();
                    String value = entries.get(this.getConfigKeyName(fieldName));
                    if (value == null) continue;
                    args[i] = this.convertValue(value, componentTypes[i]);
                }
                return clazz.getConstructor(componentTypes).newInstance(args);
            }
            T instance = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (instance instanceof Map) {
                Map mapInstance = (Map)instance;
                mapInstance.putAll(entries);
            }
            for (Field declaredField : clazz.getDeclaredFields()) {
                String fieldName = declaredField.getName();
                String value = entries.get(this.getConfigKeyName(fieldName));
                if (value == null) continue;
                declaredField.setAccessible(true);
                Object fieldValue = this.convertValue(value, declaredField.getType());
                declaredField.set(instance, fieldValue);
            }
            return instance;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public <T> T load(TypeToken<T> type) {
        Type javaType = type.type();
        try {
            Class<?> clazz = Class.forName(javaType.getTypeName());
            return (T)this.load(clazz);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Loader path(String path) {
        this.configFilePath = path;
        if (this.configFilePath.endsWith(".properties")) {
            this.extName = "properties";
        } else if (this.configFilePath.startsWith(".env")) {
            this.extName = "env";
        }
        return this;
    }

    private Object convertValue(String value, Class<?> type) {
        if (type == String.class) {
            return value;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return Integer.parseInt(value);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (type == Long.TYPE || type == Long.class) {
            return Long.parseLong(value);
        }
        if (type == Double.TYPE || type == Double.class) {
            return Double.parseDouble(value);
        }
        throw new UnsupportedOperationException("Unsupported type: " + type.getName());
    }

    private String getConfigKeyName(String fieldName) {
        StringBuilder sb = new StringBuilder();
        if ("properties".equals(this.extName)) {
            for (char c : fieldName.toCharArray()) {
                if (Character.isUpperCase(c)) {
                    sb.append('.').append(Character.toLowerCase(c));
                    continue;
                }
                sb.append(c);
            }
        } else {
            for (char c : fieldName.toCharArray()) {
                if (Character.isUpperCase(c)) {
                    sb.append('_');
                }
                sb.append(Character.toUpperCase(c));
            }
        }
        return sb.toString();
    }

    private Map<String, String> entries() throws Exception {
        if (this.configFilePath == null) {
            return Dotenvx.load().entries().stream().collect(Collectors.toMap(DotenvEntry::getKey, DotenvEntry::getValue));
        }
        if (this.configFilePath.startsWith("classpath:") && this.configFilePath.endsWith(".properties")) {
            Properties properties = new DotenvxPropertiesBuilder().filename(this.configFilePath).load();
            return properties.entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString(), entry -> entry.getValue().toString()));
        }
        Path filePath = Paths.get(this.configFilePath, new String[0]).toAbsolutePath();
        if (!filePath.toFile().exists()) {
            throw new IllegalArgumentException("File not found: " + filePath);
        }
        String directory = filePath.getParent().toString();
        String fileName = filePath.toFile().getName();
        if (this.configFilePath.endsWith(".properties")) {
            Properties properties = new DotenvxPropertiesBuilder().directory(directory).filename(fileName).load();
            return properties.entrySet().stream().collect(Collectors.toMap(entry -> entry.getKey().toString(), entry -> entry.getValue().toString()));
        }
        DotenvxBuilder builder = Dotenvx.configure().directory(directory).filename(fileName).ignoreIfMissing().systemProperties();
        Dotenv dotenv = builder.load();
        return dotenv.entries().stream().collect(Collectors.toMap(DotenvEntry::getKey, DotenvEntry::getValue));
    }

    public class DotenvxJakartaConfigInvocationHandler
    implements InvocationHandler {
        public Map<String, String> entries;

        public DotenvxJakartaConfigInvocationHandler(Map<String, String> entries) {
            this.entries = entries;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (method.isDefault()) {
                return MethodHandles.lookup().unreflectSpecial(method, method.getDeclaringClass()).bindTo(proxy).invokeWithArguments(args);
            }
            String methodName = method.getName();
            String keyName = DotenvxLoader.this.getConfigKeyName(methodName);
            if (!this.entries.containsKey(keyName)) {
                return null;
            }
            String value = this.entries.get(keyName);
            return DotenvxLoader.this.convertValue(value, method.getReturnType());
        }
    }
}

