/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.crypto;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.Security;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.KeySpec;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;

public class Secp256k1KeyParser {
    public static ECPublicKey parseSecp256k1CompressedPublicKey(byte[] compressedPublicKeyBytes) throws Exception {
        X9ECParameters x9ECParameters = SECNamedCurves.getByName((String)"secp256k1");
        ECCurve curve = x9ECParameters.getCurve();
        ECPoint ecPoint = curve.decodePoint(compressedPublicKeyBytes);
        ECParameterSpec ecParameterSpec = new ECParameterSpec(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH());
        ECPublicKeySpec pubSpec = new ECPublicKeySpec(ecPoint, ecParameterSpec);
        KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
        return (ECPublicKey)keyFactory.generatePublic((KeySpec)pubSpec);
    }

    public static ECPrivateKey parseSecp256k1PrivateKey(byte[] privateKeyBytes) throws Exception {
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        BigInteger privateKeyValue = new BigInteger(1, privateKeyBytes);
        ECPrivateKeySpec privateKeySpec = new ECPrivateKeySpec(privateKeyValue, (ECParameterSpec)ecSpec);
        KeyFactory keyFactory = KeyFactory.getInstance("EC", "BC");
        return (ECPrivateKey)keyFactory.generatePrivate((KeySpec)privateKeySpec);
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

