/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.dotenv;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;

public interface DotenvxBaseBuilder {
    public static final ObjectMapper objectMapper = new ObjectMapper();

    default public String getPrivateKeyFromGlobalStore(String publicKeyHex) {
        Path globalFileStore = Paths.get(System.getProperty("user.home"), ".dotenvx", ".env.keys.json");
        if (Files.exists(globalFileStore, new LinkOption[0])) {
            try {
                Object keyPair;
                Map globalStore = (Map)objectMapper.readValue(globalFileStore.toFile(), Map.class);
                if (globalStore.containsKey("version") && globalStore.containsKey("keys")) {
                    globalStore = (Map)globalStore.get("keys");
                }
                if (globalStore.containsKey(publicKeyHex) && (keyPair = globalStore.get(publicKeyHex)) instanceof Map) {
                    Map keyPairMap = (Map)keyPair;
                    return keyPairMap.get("private_key").toString();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }
}

