/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.dotenv;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.cdimascio.dotenv.Dotenv;
import io.github.cdimascio.dotenv.DotenvException;
import io.github.cdimascio.dotenv.DotenvxBaseBuilder;
import io.github.cdimascio.ecies.Ecies;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;

public class DotenvxPropertiesBuilder
implements DotenvxBaseBuilder {
    public static final ObjectMapper objectMapper = new ObjectMapper();
    private String privateKeyHex = null;
    private String filename = "application.properties";
    private String directoryPath = ".";

    public DotenvxPropertiesBuilder directory(String path) {
        this.directoryPath = path;
        return this;
    }

    public DotenvxPropertiesBuilder filename(String name) {
        this.filename = name;
        return this;
    }

    public DotenvxPropertiesBuilder privateKey(String privateKeyHex) {
        this.privateKeyHex = privateKeyHex;
        return this;
    }

    public Properties load() throws DotenvException {
        boolean isEncrypted;
        Properties properties;
        block23: {
            InputStream inputStream;
            properties = new Properties();
            if (this.filename.startsWith("classpath:")) {
                String classpathFile = this.filename.substring("classpath:".length());
                try {
                    inputStream = this.getClass().getClassLoader().getResourceAsStream(classpathFile);
                    try {
                        if (inputStream == null) {
                            throw new DotenvException("File not found in classpath: " + classpathFile);
                        }
                        properties.load(inputStream);
                        break block23;
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                catch (Exception e) {
                    throw new DotenvException("Failed to load properties from classpath: " + classpathFile);
                }
            }
            Path filePath = Paths.get(this.directoryPath, this.filename);
            if (!Files.exists(filePath, new LinkOption[0])) {
                throw new DotenvException("File not found: " + filePath);
            }
            try {
                inputStream = Files.newInputStream(filePath, new OpenOption[0]);
                try {
                    properties.load(inputStream);
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
            catch (Exception e) {
                throw new DotenvException("Failed to load properties from file: " + filePath);
            }
        }
        String publicKeyHex = this.getPublicKeyHex(properties);
        String profileName = null;
        if (this.filename.contains("-")) {
            profileName = this.filename.substring(this.filename.indexOf("-") + 1, this.filename.lastIndexOf(46));
        }
        if (isEncrypted = properties.entrySet().stream().anyMatch(entry -> {
            String value = entry.getValue().toString();
            return value.startsWith("encrypted:");
        })) {
            String privateKey = this.getDotenvxPrivateKey(profileName, publicKeyHex);
            if (privateKey == null || privateKey.isEmpty()) {
                throw new DotenvException("No DOTENV_PRIVATE_KEY found in environment variables or .env.keys file.");
            }
            ArrayList decryptedEntries = new ArrayList();
            for (Map.Entry<Object, Object> entry2 : properties.entrySet()) {
                String value = entry2.getValue().toString();
                if (!value.startsWith("encrypted:")) continue;
                String encryptedText = value.substring(10);
                properties.put(entry2.getKey(), this.decryptItem(privateKey, encryptedText));
            }
        }
        return properties;
    }

    public String getPublicKeyHex(Properties properties) {
        for (String key : properties.stringPropertyNames()) {
            String publicKeyHex;
            if (!key.startsWith("dotenv.public.key") || (publicKeyHex = properties.getProperty(key)) == null || publicKeyHex.isEmpty()) continue;
            return publicKeyHex;
        }
        return null;
    }

    public String getDotenvxPrivateKey(String profileName, String publicKeyHex) {
        String privateKey;
        String privateKey2;
        if (this.privateKeyHex != null && !this.privateKeyHex.isEmpty()) {
            return this.privateKeyHex;
        }
        if (publicKeyHex != null && !publicKeyHex.isEmpty() && (privateKey2 = this.getPrivateKeyFromGlobalStore(publicKeyHex)) != null && !privateKey2.isEmpty()) {
            this.privateKeyHex = privateKey2;
            return this.privateKeyHex;
        }
        Object privateKeyEnvName = "DOTENV_PRIVATE_KEY";
        if (profileName != null && !profileName.isEmpty()) {
            privateKeyEnvName = "DOTENV_PRIVATE_KEY_" + profileName.toUpperCase();
        }
        if ((privateKey = System.getenv((String)privateKeyEnvName)) == null || privateKey.isEmpty()) {
            if (this.directoryPath != null && Files.exists(Paths.get(this.directoryPath, ".env.keys"), new LinkOption[0])) {
                Dotenv keysEnv = Dotenv.configure().directory(this.directoryPath).filename(".env.keys").load();
                privateKey = keysEnv.get((String)privateKeyEnvName);
            } else if (Files.exists(Paths.get(".env.keys", new String[0]), new LinkOption[0])) {
                Dotenv keysEnv = Dotenv.configure().filename(".env.keys").load();
                privateKey = keysEnv.get((String)privateKeyEnvName);
            } else if (Files.exists(Paths.get(System.getProperty("user.home"), ".env.keys"), new LinkOption[0])) {
                Dotenv keysEnv = Dotenv.configure().directory(System.getProperty("user.home")).filename(".env.keys").load();
                privateKey = keysEnv.get((String)privateKeyEnvName);
            }
        }
        this.privateKeyHex = privateKey;
        return this.privateKeyHex;
    }

    private String decryptItem(String privateKeyHex, String item) throws DotenvException {
        try {
            return Ecies.decrypt(privateKeyHex, item);
        }
        catch (Exception e) {
            throw new DotenvException("Failed to decrypt item: " + item);
        }
    }
}

