/*
 * Decompiled with CFR 0.152.
 */
package io.github.cdimascio.ecies;

import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.util.encoders.Hex;

public final class ECKeyPair {
    private final BCECPrivateKey privateKey;
    private final BCECPublicKey publicKey;

    public ECKeyPair(BCECPublicKey publicKey, BCECPrivateKey privateKey) {
        this.publicKey = publicKey;
        this.privateKey = privateKey;
    }

    public BCECPublicKey getPublic() {
        return this.publicKey;
    }

    public BCECPrivateKey getPrivate() {
        return this.privateKey;
    }

    public byte[] getPublicBinary(boolean compressed) {
        return this.publicKey.getQ().getEncoded(compressed);
    }

    public byte[] getPrivateBinary() {
        return this.privateKey.getD().toByteArray();
    }

    public String getPublicHex(boolean compressed) {
        return Hex.toHexString((byte[])this.getPublicBinary(compressed));
    }

    public String getPrivateHex() {
        return Hex.toHexString((byte[])this.getPrivateBinary());
    }
}

