/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.toolchain;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Proxy;
import org.codehaus.plexus.archiver.tar.TarGZipUnArchiver;
import org.codehaus.plexus.archiver.zip.ZipUnArchiver;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.logging.console.ConsoleLogger;

public class FoojayService {
    private final HttpClient httpClient;
    private final Log log;

    public FoojayService(Log log, Proxy proxy) {
        this.log = log;
        if (proxy != null) {
            HttpClientBuilder builder = HttpClients.custom();
            builder.setProxy(new HttpHost(proxy.getHost(), proxy.getPort(), proxy.getProtocol()));
            if (proxy.getUsername() != null) {
                UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(proxy.getUsername(), proxy.getPassword());
                AuthScope authScope = new AuthScope(proxy.getHost(), proxy.getPort());
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(authScope, (Credentials)credentials);
                builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            this.httpClient = builder.build();
        } else {
            this.httpClient = HttpClients.createDefault();
        }
    }

    public Path downloadAndExtractJdk(String version, String vendor) throws Exception {
        Path jdkHome;
        this.log.info((CharSequence)("Begin to install JDK " + version));
        String[] fileNameAndDownloadUrl = this.parseFileNameAndDownloadUrl(version, vendor);
        if (fileNameAndDownloadUrl == null) {
            return null;
        }
        String jdkFileName = fileNameAndDownloadUrl[0];
        String downloadUrl = fileNameAndDownloadUrl[1];
        Path userHome = Paths.get(System.getProperty("user.home"), new String[0]);
        Path jdksDir = userHome.resolve(".m2").resolve("jdks");
        if (!jdksDir.toFile().exists()) {
            jdksDir.toFile().mkdir();
        }
        if ((jdkHome = this.downloadAndExtract(downloadUrl, jdkFileName, jdksDir)).resolve("Contents").resolve("Home").toFile().exists()) {
            jdkHome = jdkHome.resolve("Contents").resolve("Home");
        }
        this.log.info((CharSequence)("JDK installed: " + jdkHome.toAbsolutePath()));
        if (vendor.contains("graalvm")) {
            Path guBin = jdkHome.resolve("bin").resolve("gu");
            ProcessBuilder pb = new ProcessBuilder(guBin.toAbsolutePath().toString(), "install", "native-image", "--ignore");
            pb.environment().put("GRAALVM_HOME", jdkHome.toAbsolutePath().toString());
            pb.start();
        }
        return jdkHome;
    }

    public String[] parseFileNameAndDownloadUrl(String version, String vendor) throws Exception {
        Gson gson;
        JsonObject jsonObject;
        JsonObject pkgJson;
        String pkgInfoUri;
        HttpGet pkgInfoGet;
        HttpResponse pkgInfoResponse;
        String libcType;
        String archName;
        String os = this.getOsName();
        String archiveType = "tar.gz";
        if (os.equals("windows")) {
            archiveType = "zip";
        }
        String bitness = (archName = this.getArchName()).equals("x32") ? "32" : "64";
        switch (os) {
            case "linux": {
                libcType = "glibc";
                break;
            }
            case "windows": {
                libcType = "c_std_lib";
                break;
            }
            case "macos": {
                libcType = "libc";
                break;
            }
            default: {
                libcType = "";
            }
        }
        String queryUrl = "https://api.foojay.io/disco/v3.0/packages?distribution=" + vendor + "&version=" + version + "&operating_system=" + os + "&architecture=" + archName + "&bitness=" + bitness + "&archive_type=" + archiveType + "&libc_type=" + libcType + "&latest=overall&package_type=jdk&discovery_scope_id=directly_downloadable&match=any&javafx_bundled=false&directly_downloadable=true&release_status=ga";
        HttpGet request = new HttpGet(queryUrl);
        HttpResponse response = this.httpClient.execute((HttpUriRequest)request);
        if (response.getStatusLine().getStatusCode() == 200 && (pkgInfoResponse = this.httpClient.execute((HttpUriRequest)(pkgInfoGet = new HttpGet(pkgInfoUri = (pkgJson = (jsonObject = ((JsonElement)(gson = new Gson()).fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), JsonElement.class)).getAsJsonObject()).getAsJsonArray("result").get(0).getAsJsonObject()).getAsJsonObject("links").get("pkg_info_uri").getAsString())))).getStatusLine().getStatusCode() == 200) {
            JsonObject pkgInfoJson = ((JsonElement)gson.fromJson(EntityUtils.toString((HttpEntity)pkgInfoResponse.getEntity()), JsonElement.class)).getAsJsonObject();
            String downloadUrl = pkgInfoJson.getAsJsonArray("result").get(0).getAsJsonObject().get("direct_download_uri").getAsString();
            return new String[]{pkgJson.get("filename").getAsString(), downloadUrl};
        }
        return null;
    }

    private Path downloadAndExtract(String link, String fileName, Path destDir) throws Exception {
        File destFile = destDir.resolve(fileName).toFile();
        if (!destFile.exists()) {
            this.log.info((CharSequence)("Download " + fileName + " from " + link));
            FileUtils.copyURLToFile((URL)new URL(link), (File)destFile);
        }
        this.log.info((CharSequence)("Extract " + fileName));
        String extractDir = this.getRootNameInArchive(destFile);
        this.extractArchiveFile(destFile, destDir.toFile());
        destFile.delete();
        return destDir.resolve(extractDir);
    }

    private String getRootNameInArchive(File archiveFile) throws Exception {
        Object archiveInputStream = archiveFile.getName().endsWith("tar.gz") || archiveFile.getName().endsWith("tgz") ? new TarArchiveInputStream((InputStream)new GzipCompressorInputStream((InputStream)new FileInputStream(archiveFile))) : new ZipArchiveInputStream((InputStream)new FileInputStream(archiveFile));
        String name = archiveInputStream.getNextEntry().getName();
        while (name.startsWith(".") && name.length() < 4) {
            name = archiveInputStream.getNextEntry().getName();
        }
        archiveInputStream.close();
        if (name.startsWith("./")) {
            name = name.substring(2);
        }
        if (name.contains("/")) {
            name = name.substring(0, name.indexOf("/"));
        }
        return name;
    }

    private void extractArchiveFile(File sourceFile, File destDir) {
        String fileName = sourceFile.getName();
        Object unArchiver = fileName.endsWith(".tgz") || fileName.endsWith(".tar.gz") ? new TarGZipUnArchiver() : new ZipUnArchiver();
        unArchiver.enableLogging((Logger)new ConsoleLogger(3, "console"));
        unArchiver.setSourceFile(sourceFile);
        unArchiver.setDestDirectory(destDir);
        unArchiver.setOverwrite(true);
        unArchiver.extract();
    }

    private String getOsName() {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.contains("mac")) {
            return "macos";
        }
        if (os.contains("windows")) {
            return "windows";
        }
        return "linux";
    }

    private String getArchName() {
        String arch = System.getProperty("os.arch").toLowerCase();
        arch = arch.contains("x86_32") || arch.contains("amd32") ? "x32" : (arch.contains("aarch64") || arch.contains("arm64") ? "aarch64" : "x64");
        return arch;
    }
}

