/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client;

import com.google.common.base.Preconditions;
import java.util.concurrent.ConcurrentHashMap;
import org.mydotey.artemis.client.ArtemisClientManagerConfig;
import org.mydotey.artemis.client.DiscoveryClient;
import org.mydotey.artemis.client.RegistryClient;
import org.mydotey.artemis.client.discovery.DiscoveryClientImpl;
import org.mydotey.artemis.client.registry.RegistryClientImpl;
import org.mydotey.java.StringExtension;

public class ArtemisClientManager {
    private static final ConcurrentHashMap<String, ArtemisClientManager> _managers = new ConcurrentHashMap();
    private final String _managerId;
    private final ArtemisClientManagerConfig _managerConfig;
    private final String _clientId;
    private DiscoveryClient _discoveryClient;
    private RegistryClient _registryClient;

    private ArtemisClientManager(String managerId, ArtemisClientManagerConfig managerConfig) {
        Preconditions.checkArgument((!StringExtension.isBlank((String)managerId) ? 1 : 0) != 0, (Object)"managerId");
        Preconditions.checkArgument((managerConfig != null ? 1 : 0) != 0, (Object)"manager config");
        this._managerId = managerId;
        this._managerConfig = managerConfig;
        this._clientId = "artemis.client." + managerId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiscoveryClient getDiscoveryClient() {
        if (this._discoveryClient == null) {
            ArtemisClientManager artemisClientManager = this;
            synchronized (artemisClientManager) {
                if (this._discoveryClient == null) {
                    this._discoveryClient = new DiscoveryClientImpl(this._clientId, this._managerConfig);
                }
            }
        }
        return this._discoveryClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegistryClient getRegistryClient() {
        if (this._registryClient == null) {
            ArtemisClientManager artemisClientManager = this;
            synchronized (artemisClientManager) {
                if (this._registryClient == null) {
                    this._registryClient = new RegistryClientImpl(this._clientId, this._managerConfig);
                }
            }
        }
        return this._registryClient;
    }

    public String getManagerId() {
        return this._managerId;
    }

    public ArtemisClientManagerConfig getManagerConfig() {
        return this._managerConfig;
    }

    public static ArtemisClientManager getManager(String managerId, ArtemisClientManagerConfig managerConfig) {
        Preconditions.checkArgument((!StringExtension.isBlank((String)managerId) ? 1 : 0) != 0, (Object)"managerId");
        Preconditions.checkArgument((managerConfig != null ? 1 : 0) != 0, (Object)"manager config");
        return _managers.computeIfAbsent(managerId, k -> new ArtemisClientManager(managerId, managerConfig));
    }
}

