/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client;

import com.google.common.base.Preconditions;
import org.mydotey.artemis.client.DiscoveryClientConfig;
import org.mydotey.artemis.client.RegistryClientConfig;
import org.mydotey.caravan.util.metric.AuditMetricManager;
import org.mydotey.caravan.util.metric.EventMetricManager;
import org.mydotey.caravan.util.metric.NullAuditMetricManager;
import org.mydotey.caravan.util.metric.NullEventMetricManager;
import org.mydotey.scf.facade.StringProperties;

public class ArtemisClientManagerConfig {
    private final StringProperties _properties;
    private final EventMetricManager _eventMetricManager;
    private final AuditMetricManager _auditMetricManager;
    private final RegistryClientConfig _registryClientConfig;
    private final DiscoveryClientConfig _discoveryClientConfig;

    public ArtemisClientManagerConfig(StringProperties properties) {
        this(properties, (EventMetricManager)NullEventMetricManager.INSTANCE, (AuditMetricManager)NullAuditMetricManager.INSTANCE);
    }

    public ArtemisClientManagerConfig(StringProperties properties, EventMetricManager eventMetricManager, AuditMetricManager valueMetricManager) {
        this(properties, eventMetricManager, valueMetricManager, new RegistryClientConfig(), new DiscoveryClientConfig());
    }

    public ArtemisClientManagerConfig(StringProperties properties, EventMetricManager eventMetricManager, AuditMetricManager valueMetricManager, RegistryClientConfig registryClientConfig) {
        this(properties, eventMetricManager, valueMetricManager, registryClientConfig, new DiscoveryClientConfig());
    }

    public ArtemisClientManagerConfig(StringProperties properties, EventMetricManager eventMetricManager, AuditMetricManager valueMetricManager, DiscoveryClientConfig discoveryClientConfig) {
        this(properties, eventMetricManager, valueMetricManager, new RegistryClientConfig(), new DiscoveryClientConfig());
    }

    public ArtemisClientManagerConfig(StringProperties properties, EventMetricManager eventMetricManager, AuditMetricManager valueMetricManager, RegistryClientConfig registryClientConfig, DiscoveryClientConfig discoveryClientConfig) {
        Preconditions.checkArgument((properties != null ? 1 : 0) != 0, (Object)"properties");
        Preconditions.checkArgument((eventMetricManager != null ? 1 : 0) != 0, (Object)"event metric manager");
        Preconditions.checkArgument((valueMetricManager != null ? 1 : 0) != 0, (Object)"value metric manager");
        Preconditions.checkArgument((registryClientConfig != null ? 1 : 0) != 0, (Object)"registry client config");
        Preconditions.checkArgument((discoveryClientConfig != null ? 1 : 0) != 0, (Object)"discovery client config");
        this._properties = properties;
        this._eventMetricManager = eventMetricManager;
        this._auditMetricManager = valueMetricManager;
        this._registryClientConfig = registryClientConfig;
        this._discoveryClientConfig = discoveryClientConfig;
    }

    public StringProperties properties() {
        return this._properties;
    }

    public EventMetricManager eventMetricManager() {
        return this._eventMetricManager;
    }

    public AuditMetricManager valueMetricManager() {
        return this._auditMetricManager;
    }

    public RegistryClientConfig registryClientConfig() {
        return this._registryClientConfig;
    }

    public DiscoveryClientConfig discoveryClientConfig() {
        return this._discoveryClientConfig;
    }
}

