/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client.common;

import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicReference;
import org.mydotey.artemis.client.ArtemisClientManagerConfig;
import org.mydotey.artemis.client.common.AddressContext;
import org.mydotey.artemis.client.common.AddressRepository;
import org.mydotey.java.StringExtension;

public abstract class AddressManager {
    private final AtomicReference<AddressContext> _addressContext = new AtomicReference();
    protected final AddressRepository _addressRepository;

    public AddressManager(ArtemisClientManagerConfig managerConfig, AddressRepository addressRepository) {
        Preconditions.checkArgument((managerConfig != null ? 1 : 0) != 0, (Object)"manager config");
        Preconditions.checkArgument((addressRepository != null ? 1 : 0) != 0, (Object)"address repository");
        this._addressRepository = addressRepository;
        this._addressContext.set(this.newAddressContext());
    }

    public AddressContext getContext() {
        AddressContext context = this._addressContext.get();
        if (!context.isAavailable() || context.isExpired()) {
            context = this.newAddressContext();
            this._addressContext.set(context);
        }
        return context;
    }

    protected abstract AddressContext newAddressContext();

    public static AddressManager getDiscoveryAddressManager(final String clientId, final ArtemisClientManagerConfig managerConfig) {
        Preconditions.checkArgument((!StringExtension.isBlank((String)clientId) ? 1 : 0) != 0, (Object)"clientId");
        Preconditions.checkArgument((managerConfig != null ? 1 : 0) != 0, (Object)"manager config");
        return new AddressManager(managerConfig, new AddressRepository(clientId, managerConfig, "/artemis/api/cluster/up-discovery-nodes.json")){

            @Override
            protected AddressContext newAddressContext() {
                return new AddressContext(clientId, managerConfig, this._addressRepository.get(), "/artemis/websocket/discovery/instance-change");
            }
        };
    }

    public static AddressManager getRegistryAddressManager(final String clientId, final ArtemisClientManagerConfig managerConfig) {
        Preconditions.checkArgument((!StringExtension.isBlank((String)clientId) ? 1 : 0) != 0, (Object)"clientId");
        Preconditions.checkArgument((managerConfig != null ? 1 : 0) != 0, (Object)"manager config");
        return new AddressManager(managerConfig, new AddressRepository(clientId, managerConfig, "/artemis/api/cluster/up-registry-nodes.json")){

            @Override
            protected AddressContext newAddressContext() {
                return new AddressContext(clientId, managerConfig, this._addressRepository.get(), "/artemis/websocket/registry/heartbeat");
            }
        };
    }
}

