/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client.common;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.mydotey.artemis.client.ArtemisClientManagerConfig;
import org.mydotey.artemis.cluster.GetServiceNodesRequest;
import org.mydotey.artemis.cluster.GetServiceNodesResponse;
import org.mydotey.artemis.cluster.ServiceNode;
import org.mydotey.artemis.config.DeploymentConfig;
import org.mydotey.caravan.util.concurrent.DynamicScheduledThread;
import org.mydotey.caravan.util.concurrent.DynamicScheduledThreadConfig;
import org.mydotey.codec.Codec;
import org.mydotey.codec.json.JacksonJsonCodec;
import org.mydotey.java.StringExtension;
import org.mydotey.java.io.file.FileExtension;
import org.mydotey.rpc.client.http.apache.HttpRequestFactory;
import org.mydotey.rpc.client.http.apache.sync.DynamicPoolingHttpClientProvider;
import org.mydotey.rpc.client.http.apache.sync.HttpRequestExecutors;
import org.mydotey.scf.Property;
import org.mydotey.scf.filter.RangeValueConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class AddressRepository {
    private static final Logger _logger = LoggerFactory.getLogger(AddressRepository.class);
    private final Property<String, String> _domainUrl;
    private final AtomicReference<List<String>> _avlSvcUrls = new AtomicReference();
    private final DynamicPoolingHttpClientProvider _clientProvider;
    private final String _path;
    private final GetServiceNodesRequest _request;
    private final DynamicScheduledThread _addressesPoller;

    public AddressRepository(String clientId, ArtemisClientManagerConfig managerConfig, String path) {
        Preconditions.checkArgument((!StringExtension.isBlank((String)clientId) ? 1 : 0) != 0, (Object)"clientId");
        Preconditions.checkArgument((managerConfig != null ? 1 : 0) != 0, (Object)"manager config");
        Preconditions.checkArgument((!StringExtension.isBlank((String)path) ? 1 : 0) != 0, (Object)"path");
        this._clientProvider = new DynamicPoolingHttpClientProvider(clientId + ".address.http-client", managerConfig.properties().getManager());
        this._path = path;
        this._request = new GetServiceNodesRequest(DeploymentConfig.regionId(), DeploymentConfig.zoneId());
        this._domainUrl = managerConfig.properties().getStringProperty((Object)(clientId + ".service.domain.url"), "");
        DynamicScheduledThreadConfig dynamicScheduledThreadConfig = new DynamicScheduledThreadConfig(managerConfig.properties(), new RangeValueConfig((Comparable)Integer.valueOf(20), (Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(200)), new RangeValueConfig((Comparable)Integer.valueOf(300000), (Comparable)Integer.valueOf(60000), (Comparable)Integer.valueOf(1800000)));
        this._addressesPoller = new DynamicScheduledThread(clientId + ".address-repository", this::refresh, dynamicScheduledThreadConfig);
        this.refresh();
        this._addressesPoller.setDaemon(true);
        this._addressesPoller.start();
    }

    public String get() {
        List<String> addressList = this._avlSvcUrls.get();
        if (CollectionUtils.isEmpty(addressList)) {
            return (String)this._domainUrl.getValue();
        }
        return addressList.get(ThreadLocalRandom.current().nextInt(addressList.size()));
    }

    protected void refresh() {
        try {
            _logger.info("start refresh service urls");
            String domainUrl = (String)this._domainUrl.getValue();
            if (StringExtension.isBlank((String)domainUrl)) {
                _logger.error("domain url should not be null or empty for artemis client");
                return;
            }
            List<String> urls = this.getUrlsFromService(domainUrl);
            if (!CollectionUtils.isEmpty(urls)) {
                this._avlSvcUrls.set(urls);
            }
        }
        catch (Throwable e) {
            _logger.warn("refesh service urls failed", e);
        }
        finally {
            _logger.info("end refresh service urls");
        }
    }

    private List<String> getUrlsFromService(String url) {
        ArrayList<String> addressList = new ArrayList<String>();
        try {
            if (StringExtension.isBlank((String)url)) {
                return addressList;
            }
            String requestUrl = FileExtension.concatPathParts((String[])new String[]{url, this._path});
            HttpEntityEnclosingRequestBase request = HttpRequestFactory.createRequest((String)requestUrl, (String)"POST", (Object)this._request, (Codec)JacksonJsonCodec.DEFAULT);
            HttpRequestFactory.gzipRequest((HttpEntityEnclosingRequest)request);
            GetServiceNodesResponse response = (GetServiceNodesResponse)HttpRequestExecutors.execute((CloseableHttpClient)((CloseableHttpClient)this._clientProvider.get()), (HttpUriRequest)request, (Codec)JacksonJsonCodec.DEFAULT, GetServiceNodesResponse.class);
            if (CollectionUtils.isEmpty((Collection)response.getNodes())) {
                return addressList;
            }
            HashSet<String> newAddressList = new HashSet<String>();
            for (ServiceNode node : response.getNodes()) {
                if (node == null || StringExtension.isBlank((String)node.getUrl())) continue;
                String address = node.getUrl();
                if (StringExtension.isBlank((String)(address = StringExtension.trimEnd((String)address, (char[])new char[]{'/'})))) continue;
                newAddressList.add(address);
            }
            addressList.addAll(newAddressList);
        }
        catch (Throwable e) {
            _logger.error("reset address from service failed", e);
        }
        return addressList;
    }
}

