/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.mydotey.artemis.HasResponseStatus;
import org.mydotey.artemis.ResponseStatus;
import org.mydotey.artemis.client.common.AddressContext;
import org.mydotey.artemis.client.common.AddressManager;
import org.mydotey.artemis.client.common.ArtemisClientConfig;
import org.mydotey.artemis.util.ResponseStatusUtil;
import org.mydotey.caravan.util.metric.EventMetric;
import org.mydotey.caravan.util.metric.EventMetricManager;
import org.mydotey.caravan.util.metric.MetricConfig;
import org.mydotey.codec.Codec;
import org.mydotey.codec.json.JacksonJsonCodec;
import org.mydotey.java.StringExtension;
import org.mydotey.java.ThreadExtension;
import org.mydotey.rpc.client.http.apache.HttpRequestFactory;
import org.mydotey.rpc.client.http.apache.sync.DynamicPoolingHttpClientProvider;
import org.mydotey.rpc.client.http.apache.sync.HttpRequestExecutors;
import org.mydotey.scf.Property;
import org.mydotey.scf.filter.RangeValueFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtemisHttpClient {
    protected final Logger _logger = LoggerFactory.getLogger(this.getClass());
    private final DynamicPoolingHttpClientProvider _clientProvider;
    private final AddressManager _addressManager;
    private final Property<String, Integer> _httpClientRetryTimes;
    private final Property<String, Integer> _retryInterval;
    private final String _distributionMetricName;
    protected final EventMetricManager _eventMetricManager;

    public ArtemisHttpClient(ArtemisClientConfig config, String httpClientId) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config");
        Preconditions.checkArgument((!StringExtension.isBlank((String)httpClientId) ? 1 : 0) != 0, (Object)"httpClientId");
        this._clientProvider = new DynamicPoolingHttpClientProvider(httpClientId + ".http-client", config.properties().getManager());
        this._addressManager = config.addressManager();
        this._httpClientRetryTimes = config.properties().getIntProperty((Object)(httpClientId + ".http-client.retry-times"), Integer.valueOf(5), (Function)new RangeValueFilter((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(10)));
        this._retryInterval = config.properties().getIntProperty((Object)(httpClientId + ".http-client.retry-interval"), Integer.valueOf(100), (Function)new RangeValueFilter((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1000)));
        this._distributionMetricName = config.key("http-response.status-code");
        this._eventMetricManager = config.eventMetricManager();
    }

    public <T extends HasResponseStatus> T request(String path, Object request, Class<T> clazz) {
        int retryTimes = (Integer)this._httpClientRetryTimes.getValue();
        ResponseStatus responseStatus = null;
        for (int i = 0; i < retryTimes; ++i) {
            AddressContext context = null;
            try {
                context = this._addressManager.getContext();
                String requestUrl = context.customHttpUrl(path);
                HttpEntityEnclosingRequestBase httpRequest = HttpRequestFactory.createRequest((String)requestUrl, (String)"POST", (Object)request, (Codec)JacksonJsonCodec.DEFAULT);
                HttpRequestFactory.gzipRequest((HttpEntityEnclosingRequest)httpRequest);
                HasResponseStatus response = (HasResponseStatus)HttpRequestExecutors.execute((CloseableHttpClient)((CloseableHttpClient)this._clientProvider.get()), (HttpUriRequest)httpRequest, (Codec)JacksonJsonCodec.DEFAULT, clazz);
                if (response == null || response.getResponseStatus() == null) {
                    throw new RuntimeException("Got null response or null response status.");
                }
                responseStatus = response.getResponseStatus();
                boolean isServiceDown = ResponseStatusUtil.isServiceDown((ResponseStatus)responseStatus);
                boolean isRerunnable = ResponseStatusUtil.isRerunnable((ResponseStatus)responseStatus);
                if (!isServiceDown && !isRerunnable) {
                    return (T)response;
                }
                if (isServiceDown) {
                    context.markUnavailable();
                }
                this._logger.info("get response failed, but can be retried. at turn: " + (i + 1) + ". responseStatus: " + responseStatus);
            }
            catch (Throwable e) {
                if (context != null) {
                    context.markUnavailable();
                }
                if (i < retryTimes - 1) {
                    this._logger.info("get response failed in this turn: " + (i + 1), e);
                }
                this._logger.error("\u4e0e SOA \u6ce8\u518c\u4e2d\u5fc3\u901a\u4fe1\u65f6\u53d1\u751f\u9519\u8bef", e);
                throw e;
            }
            ThreadExtension.sleep((int)((Integer)this._retryInterval.getValue()));
        }
        throw new RuntimeException("Got failed response: " + responseStatus);
    }

    protected void logEvent(String service, String operation) {
        this.logEvent(null, service, operation);
    }

    protected void logEvent(ResponseStatus status, String service, String operation) {
        String metricId = this._distributionMetricName + "|" + service + "|" + operation;
        HashMap metadata = Maps.newHashMap();
        metadata.put("metric_name_distribution", this._distributionMetricName);
        metadata.put("service", service);
        metadata.put("operation", operation);
        EventMetric metric = this._eventMetricManager.getMetric(metricId, new MetricConfig((Map)metadata));
        if (status == null) {
            metric.addEvent("null");
        } else {
            metric.addEvent(status.getErrorCode());
        }
    }
}

