/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client.discovery;

import com.google.common.base.Preconditions;
import org.mydotey.artemis.Service;
import org.mydotey.artemis.client.ArtemisClientManagerConfig;
import org.mydotey.artemis.client.DiscoveryClient;
import org.mydotey.artemis.client.ServiceChangeListener;
import org.mydotey.artemis.client.common.AddressManager;
import org.mydotey.artemis.client.common.ArtemisClientConfig;
import org.mydotey.artemis.client.discovery.ServiceRepository;
import org.mydotey.artemis.discovery.DiscoveryConfig;
import org.mydotey.artemis.util.DiscoveryConfigChecker;
import org.mydotey.java.ObjectExtension;
import org.mydotey.java.StringExtension;

public class DiscoveryClientImpl
implements DiscoveryClient {
    private final ServiceRepository serviceRepository;

    public DiscoveryClientImpl(String clientId, ArtemisClientManagerConfig managerConfig) {
        Preconditions.checkArgument((!StringExtension.isBlank((String)clientId) ? 1 : 0) != 0, (Object)"clientId");
        Preconditions.checkArgument((managerConfig != null ? 1 : 0) != 0, (Object)"manager config");
        ArtemisClientConfig config = new ArtemisClientConfig(clientId, managerConfig, AddressManager.getDiscoveryAddressManager(clientId, managerConfig));
        this.serviceRepository = new ServiceRepository(config);
    }

    @Override
    public Service getService(DiscoveryConfig discoveryConfig) {
        DiscoveryConfigChecker.DEFAULT.check(discoveryConfig, "discoveryConfig");
        return this.serviceRepository.getService(discoveryConfig);
    }

    @Override
    public void registerServiceChangeListener(DiscoveryConfig discoveryConfig, ServiceChangeListener listener) {
        DiscoveryConfigChecker.DEFAULT.check(discoveryConfig, "discoveryConfig");
        ObjectExtension.requireNonNull((Object)listener, (String)"listener");
        this.serviceRepository.registerServiceChangeListener(discoveryConfig, listener);
    }
}

