/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client.discovery;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.mydotey.artemis.Instance;
import org.mydotey.artemis.Service;
import org.mydotey.artemis.checker.ValueCheckers;
import org.mydotey.artemis.client.ServiceChangeEvent;
import org.mydotey.artemis.client.ServiceChangeListener;
import org.mydotey.artemis.discovery.DiscoveryConfig;
import org.mydotey.artemis.util.RouteRules;
import org.mydotey.java.ObjectExtension;
import org.mydotey.java.StringExtension;
import org.mydotey.java.collection.CollectionExtension;

public class ServiceContext {
    private final DiscoveryConfig discoveryConfig;
    private final String serviceId;
    private final Set<ServiceChangeListener> listeners;
    private volatile Service service;

    public ServiceContext(DiscoveryConfig discoveryConfig) {
        ObjectExtension.requireNonNull((Object)discoveryConfig, (String)"discoveryConfig");
        ObjectExtension.requireNonBlank((String)discoveryConfig.getServiceId(), (String)"discoveryConfig.serviceId");
        this.discoveryConfig = discoveryConfig;
        this.serviceId = StringExtension.toLowerCase((String)discoveryConfig.getServiceId());
        this.listeners = Sets.newConcurrentHashSet();
        this.service = new Service(this.discoveryConfig.getServiceId());
    }

    public DiscoveryConfig getDiscoveryConfig() {
        return this.discoveryConfig;
    }

    public synchronized Service newService() {
        Service newService = this.service.clone();
        newService.setRouteRules(RouteRules.newRouteRules((Service)this.service));
        return newService;
    }

    public synchronized void setService(Service service) {
        ValueCheckers.notNull((Object)service, (String)"service");
        String newServiceId = service.getServiceId();
        ValueCheckers.notNullOrWhiteSpace((String)newServiceId, (String)"serviceId");
        Preconditions.checkArgument((boolean)this.serviceId.equals(newServiceId.toLowerCase()), (Object)("service's serviceId is not this same as discoveryConfig. expected: " + this.serviceId + ", actual: " + newServiceId));
        this.service = service;
    }

    public synchronized boolean deleteInstance(Instance instance) {
        if (instance == null) {
            return false;
        }
        List instances = this.service.getInstances();
        if (instances == null) {
            return false;
        }
        return instances.remove(instance);
    }

    public synchronized boolean updateInstance(Instance instance) {
        return this.addInstance(instance);
    }

    public synchronized boolean addInstance(Instance instance) {
        if (instance == null) {
            return false;
        }
        String instanceServiceId = instance.getServiceId();
        if (instanceServiceId == null || !this.serviceId.equals(instanceServiceId.toLowerCase())) {
            return false;
        }
        ArrayList<Instance> instances = this.service.getInstances();
        if (instances == null) {
            instances = new ArrayList<Instance>();
        }
        this.deleteInstance(instance);
        instances.add(instance);
        this.service.setInstances(instances);
        return true;
    }

    public synchronized boolean isAvailable() {
        Service service = this.service;
        return service != null && !CollectionExtension.isEmpty((Collection)service.getInstances());
    }

    public synchronized Set<ServiceChangeListener> getListeners() {
        return this.listeners;
    }

    public synchronized void addListener(ServiceChangeListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public ServiceChangeEvent newServiceChangeEvent(final String changeType) {
        Preconditions.checkArgument((!StringExtension.isBlank((String)changeType) ? 1 : 0) != 0, (Object)"changeType");
        final Service service = this.newService();
        return new ServiceChangeEvent(){

            @Override
            public Service changedService() {
                return service;
            }

            @Override
            public String changeType() {
                return changeType;
            }
        };
    }

    public String toString() {
        return this.serviceId;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return Objects.equal((Object)this.toString(), (Object)other.toString());
    }
}

