/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client.registry;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.mydotey.artemis.Instance;
import org.mydotey.artemis.client.RegistryFilter;
import org.mydotey.artemis.client.common.ArtemisClientConfig;
import org.mydotey.artemis.client.common.RegisterType;
import org.mydotey.artemis.client.registry.ArtemisRegistryHttpClient;
import org.mydotey.artemis.registry.HeartbeatRequest;
import org.mydotey.caravan.util.metric.AuditMetric;
import org.mydotey.caravan.util.metric.AuditMetricManager;
import org.mydotey.caravan.util.metric.MetricConfig;
import org.mydotey.codec.json.JacksonJsonCodec;
import org.mydotey.java.StringExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.web.socket.TextMessage;

public class InstanceRepository {
    private static final Logger _logger = LoggerFactory.getLogger(InstanceRepository.class);
    private final AtomicReference<Set<Instance>> _instances = new AtomicReference(new HashSet());
    private final ArtemisRegistryHttpClient _client;
    private final List<RegistryFilter> _filters;
    private final AuditMetricManager _valueMetricManager;
    private final String _metricNameAudit;
    private final String _metricNameDistribution;

    public InstanceRepository(ArtemisClientConfig config) {
        Preconditions.checkArgument((config != null ? 1 : 0) != 0, (Object)"config");
        this._client = new ArtemisRegistryHttpClient(config);
        this._filters = config.registryClientConfig().getRegistryFilters();
        this._valueMetricManager = config.valueMetricManager();
        this._metricNameAudit = config.key("filter-instances.latency");
        this._metricNameDistribution = config.key("filter-instances.latency.distribution");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Instance> filterInstances(Set<Instance> instances) {
        if (CollectionUtils.isEmpty(instances) || CollectionUtils.isEmpty(this._filters)) {
            return instances;
        }
        ArrayList filterInstances = Lists.newArrayList(instances);
        for (RegistryFilter filter : this._filters) {
            if (filter == null) continue;
            long start = System.currentTimeMillis();
            try {
                filter.filter(filterInstances);
            }
            catch (Throwable e) {
                _logger.warn("filter instances failed", e);
            }
            finally {
                this.metric(filter.getRegistryFilterId(), System.currentTimeMillis() - start);
            }
        }
        if (filterInstances == null) {
            return Sets.newHashSet();
        }
        return Sets.newHashSet((Iterable)filterInstances);
    }

    public Set<Instance> getAvailableInstances() {
        return this.filterInstances(this._instances.get());
    }

    public TextMessage getHeartbeatMessage() {
        try {
            ArrayList<Instance> instances = new ArrayList<Instance>(this.getAvailableInstances());
            if (instances.size() > 0) {
                return new TextMessage((CharSequence)new String(JacksonJsonCodec.DEFAULT.encode((Object)new HeartbeatRequest(instances))));
            }
            return null;
        }
        catch (Throwable e) {
            _logger.warn("get heartbeat message failed", e);
            return null;
        }
    }

    public void registerToRemote(Set<Instance> instances) {
        if (CollectionUtils.isEmpty(instances)) {
            return;
        }
        Set<Instance> filterInstances = this.filterInstances(instances);
        if (CollectionUtils.isEmpty(filterInstances)) {
            _logger.info("get empty instances after RegistryFilter processed:" + Joiner.on((char)',').join(instances));
            return;
        }
        this._client.register(filterInstances);
    }

    public void register(Set<Instance> instances) {
        if (CollectionUtils.isEmpty(instances)) {
            return;
        }
        this._client.unregister(instances);
        this.updateInstances(instances, RegisterType.register);
    }

    public void unregister(Set<Instance> instances) {
        if (CollectionUtils.isEmpty(instances)) {
            return;
        }
        this._client.unregister(instances);
        this.updateInstances(instances, RegisterType.unregister);
    }

    protected synchronized void updateInstances(Set<Instance> instances, RegisterType type) {
        try {
            if (CollectionUtils.isEmpty(instances)) {
                return;
            }
            HashSet<Instance> newInstances = new HashSet<Instance>((Collection)this._instances.get());
            for (Instance instance : instances) {
                if (RegisterType.register.equals((Object)type)) {
                    newInstances.add(instance);
                    continue;
                }
                if (!RegisterType.unregister.equals((Object)type)) continue;
                newInstances.remove(instance);
            }
            this._instances.set(newInstances);
        }
        catch (Throwable e) {
            _logger.warn("update instances failed", e);
        }
    }

    private void metric(String filterId, long value) {
        if (StringExtension.isBlank((String)filterId)) {
            return;
        }
        String metricId = "filter-instances." + filterId;
        AuditMetric metric = this._valueMetricManager.getMetric(metricId, new MetricConfig((Map)ImmutableMap.of((Object)"metric_name_distribution", (Object)this._metricNameDistribution, (Object)"metric_name_audit", (Object)this._metricNameAudit, (Object)"filter", (Object)filterId)));
        metric.addValue((double)value);
    }
}

