/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import org.mydotey.artemis.Instance;
import org.mydotey.artemis.client.ArtemisClientManagerConfig;
import org.mydotey.artemis.client.RegistryClient;
import org.mydotey.artemis.client.common.AddressManager;
import org.mydotey.artemis.client.common.ArtemisClientConfig;
import org.mydotey.artemis.client.common.Conditions;
import org.mydotey.artemis.client.registry.InstanceRegistry;
import org.mydotey.artemis.client.registry.InstanceRepository;
import org.mydotey.java.StringExtension;

public class RegistryClientImpl
implements RegistryClient {
    protected final InstanceRepository _instanceRepository;
    protected final InstanceRegistry _instanceRegistry;

    public RegistryClientImpl(String clientId, ArtemisClientManagerConfig managerConfig) {
        Preconditions.checkArgument((!StringExtension.isBlank((String)clientId) ? 1 : 0) != 0, (Object)"clientId");
        Preconditions.checkArgument((managerConfig != null ? 1 : 0) != 0, (Object)"manager config");
        ArtemisClientConfig config = new ArtemisClientConfig(clientId, managerConfig, AddressManager.getRegistryAddressManager(clientId, managerConfig));
        this._instanceRepository = new InstanceRepository(config);
        this._instanceRegistry = new InstanceRegistry(this._instanceRepository, config);
    }

    @Override
    public void register(Instance ... instances) {
        Preconditions.checkArgument((boolean)Conditions.verifyInstances(instances), (Object)"instances");
        this._instanceRepository.register(Sets.newHashSet((Object[])instances));
    }

    @Override
    public void unregister(Instance ... instances) {
        Preconditions.checkArgument((boolean)Conditions.verifyInstances(instances), (Object)"instances");
        Conditions.verifyInstances(instances);
        this._instanceRepository.unregister(Sets.newHashSet((Object[])instances));
    }
}

