/*
 * Decompiled with CFR 0.152.
 */
package org.mydotey.artemis.client.registry;

import com.google.common.base.Preconditions;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.mydotey.artemis.registry.HeartbeatRequest;
import org.mydotey.artemis.registry.HeartbeatResponse;
import org.mydotey.artemis.registry.RegisterRequest;
import org.mydotey.artemis.registry.RegisterResponse;
import org.mydotey.artemis.registry.RegistryService;
import org.mydotey.artemis.registry.UnregisterRequest;
import org.mydotey.artemis.registry.UnregisterResponse;
import org.mydotey.artemis.trace.ArtemisTraceExecutor;
import org.mydotey.codec.Codec;
import org.mydotey.codec.json.JacksonJsonCodec;
import org.mydotey.java.StringExtension;
import org.mydotey.java.io.file.FileExtension;
import org.mydotey.rpc.client.http.apache.HttpRequestFactory;
import org.mydotey.rpc.client.http.apache.sync.DynamicPoolingHttpClientProvider;
import org.mydotey.rpc.client.http.apache.sync.HttpRequestExecutors;
import org.mydotey.scf.facade.StringProperties;

public class RegistryServiceClient
implements RegistryService {
    private final DynamicPoolingHttpClientProvider _clientProvider;
    private final String _url;

    public RegistryServiceClient(StringProperties properties, String url) {
        Preconditions.checkArgument((properties != null ? 1 : 0) != 0, (Object)"properties");
        Preconditions.checkArgument((!StringExtension.isBlank((String)url) ? 1 : 0) != 0, (Object)"url");
        this._clientProvider = new DynamicPoolingHttpClientProvider("artemis.client.registry-service", properties.getManager());
        this._url = url;
    }

    public RegisterResponse register(RegisterRequest request) {
        return (RegisterResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.client.registry-service.register", () -> {
            String requestUrl = FileExtension.concatPathParts((String[])new String[]{this._url, "/artemis/api/registry/register.json"});
            HttpEntityEnclosingRequestBase httpRequest = HttpRequestFactory.createRequest((String)requestUrl, (String)"POST", (Object)request, (Codec)JacksonJsonCodec.DEFAULT);
            HttpRequestFactory.gzipRequest((HttpEntityEnclosingRequest)httpRequest);
            return (RegisterResponse)HttpRequestExecutors.execute((CloseableHttpClient)((CloseableHttpClient)this._clientProvider.get()), (HttpUriRequest)httpRequest, (Codec)JacksonJsonCodec.DEFAULT, RegisterResponse.class);
        });
    }

    public HeartbeatResponse heartbeat(HeartbeatRequest request) {
        return (HeartbeatResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.client.registry-service.heartbeat", () -> {
            String requestUrl = FileExtension.concatPathParts((String[])new String[]{this._url, "/artemis/api/registry/heartbeat.json"});
            HttpEntityEnclosingRequestBase httpRequest = HttpRequestFactory.createRequest((String)requestUrl, (String)"POST", (Object)request, (Codec)JacksonJsonCodec.DEFAULT);
            HttpRequestFactory.gzipRequest((HttpEntityEnclosingRequest)httpRequest);
            return (HeartbeatResponse)HttpRequestExecutors.execute((CloseableHttpClient)((CloseableHttpClient)this._clientProvider.get()), (HttpUriRequest)httpRequest, (Codec)JacksonJsonCodec.DEFAULT, HeartbeatResponse.class);
        });
    }

    public UnregisterResponse unregister(UnregisterRequest request) {
        return (UnregisterResponse)ArtemisTraceExecutor.INSTANCE.execute("artemis.client.registry-service.unregister", () -> {
            String requestUrl = FileExtension.concatPathParts((String[])new String[]{this._url, "/artemis/api/registry/unregister.json"});
            HttpEntityEnclosingRequestBase httpRequest = HttpRequestFactory.createRequest((String)requestUrl, (String)"POST", (Object)request, (Codec)JacksonJsonCodec.DEFAULT);
            HttpRequestFactory.gzipRequest((HttpEntityEnclosingRequest)httpRequest);
            return (UnregisterResponse)HttpRequestExecutors.execute((CloseableHttpClient)((CloseableHttpClient)this._clientProvider.get()), (HttpUriRequest)httpRequest, (Codec)JacksonJsonCodec.DEFAULT, UnregisterResponse.class);
        });
    }
}

